# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetAlarmResult',
    'AwaitableGetAlarmResult',
    'get_alarm',
    'get_alarm_output',
]

@pulumi.output_type
class GetAlarmResult:
    def __init__(__self__, actions_enabled=None, alarm_actions=None, alarm_description=None, arn=None, comparison_operator=None, datapoints_to_alarm=None, dimensions=None, evaluate_low_sample_count_percentile=None, evaluation_periods=None, extended_statistic=None, insufficient_data_actions=None, metric_name=None, metrics=None, namespace=None, ok_actions=None, period=None, statistic=None, tags=None, threshold=None, threshold_metric_id=None, treat_missing_data=None, unit=None):
        if actions_enabled and not isinstance(actions_enabled, bool):
            raise TypeError("Expected argument 'actions_enabled' to be a bool")
        pulumi.set(__self__, "actions_enabled", actions_enabled)
        if alarm_actions and not isinstance(alarm_actions, list):
            raise TypeError("Expected argument 'alarm_actions' to be a list")
        pulumi.set(__self__, "alarm_actions", alarm_actions)
        if alarm_description and not isinstance(alarm_description, str):
            raise TypeError("Expected argument 'alarm_description' to be a str")
        pulumi.set(__self__, "alarm_description", alarm_description)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if comparison_operator and not isinstance(comparison_operator, str):
            raise TypeError("Expected argument 'comparison_operator' to be a str")
        pulumi.set(__self__, "comparison_operator", comparison_operator)
        if datapoints_to_alarm and not isinstance(datapoints_to_alarm, int):
            raise TypeError("Expected argument 'datapoints_to_alarm' to be a int")
        pulumi.set(__self__, "datapoints_to_alarm", datapoints_to_alarm)
        if dimensions and not isinstance(dimensions, list):
            raise TypeError("Expected argument 'dimensions' to be a list")
        pulumi.set(__self__, "dimensions", dimensions)
        if evaluate_low_sample_count_percentile and not isinstance(evaluate_low_sample_count_percentile, str):
            raise TypeError("Expected argument 'evaluate_low_sample_count_percentile' to be a str")
        pulumi.set(__self__, "evaluate_low_sample_count_percentile", evaluate_low_sample_count_percentile)
        if evaluation_periods and not isinstance(evaluation_periods, int):
            raise TypeError("Expected argument 'evaluation_periods' to be a int")
        pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if extended_statistic and not isinstance(extended_statistic, str):
            raise TypeError("Expected argument 'extended_statistic' to be a str")
        pulumi.set(__self__, "extended_statistic", extended_statistic)
        if insufficient_data_actions and not isinstance(insufficient_data_actions, list):
            raise TypeError("Expected argument 'insufficient_data_actions' to be a list")
        pulumi.set(__self__, "insufficient_data_actions", insufficient_data_actions)
        if metric_name and not isinstance(metric_name, str):
            raise TypeError("Expected argument 'metric_name' to be a str")
        pulumi.set(__self__, "metric_name", metric_name)
        if metrics and not isinstance(metrics, list):
            raise TypeError("Expected argument 'metrics' to be a list")
        pulumi.set(__self__, "metrics", metrics)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if ok_actions and not isinstance(ok_actions, list):
            raise TypeError("Expected argument 'ok_actions' to be a list")
        pulumi.set(__self__, "ok_actions", ok_actions)
        if period and not isinstance(period, int):
            raise TypeError("Expected argument 'period' to be a int")
        pulumi.set(__self__, "period", period)
        if statistic and not isinstance(statistic, str):
            raise TypeError("Expected argument 'statistic' to be a str")
        pulumi.set(__self__, "statistic", statistic)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if threshold and not isinstance(threshold, float):
            raise TypeError("Expected argument 'threshold' to be a float")
        pulumi.set(__self__, "threshold", threshold)
        if threshold_metric_id and not isinstance(threshold_metric_id, str):
            raise TypeError("Expected argument 'threshold_metric_id' to be a str")
        pulumi.set(__self__, "threshold_metric_id", threshold_metric_id)
        if treat_missing_data and not isinstance(treat_missing_data, str):
            raise TypeError("Expected argument 'treat_missing_data' to be a str")
        pulumi.set(__self__, "treat_missing_data", treat_missing_data)
        if unit and not isinstance(unit, str):
            raise TypeError("Expected argument 'unit' to be a str")
        pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="actionsEnabled")
    def actions_enabled(self) -> Optional[builtins.bool]:
        """
        Indicates whether actions should be executed during any changes to the alarm state. The default is TRUE.
        """
        return pulumi.get(self, "actions_enabled")

    @property
    @pulumi.getter(name="alarmActions")
    def alarm_actions(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of actions to execute when this alarm transitions into an ALARM state from any other state. Specify each action as an Amazon Resource Name (ARN). For more information about creating alarms and the actions that you can specify, see [PutMetricAlarm](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutMetricAlarm.html) in the *API Reference*.
        """
        return pulumi.get(self, "alarm_actions")

    @property
    @pulumi.getter(name="alarmDescription")
    def alarm_description(self) -> Optional[builtins.str]:
        """
        The description of the alarm.
        """
        return pulumi.get(self, "alarm_description")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The ARN of the CloudWatch alarm, such as `arn:aws:cloudwatch:us-west-2:123456789012:alarm:myCloudWatchAlarm-CPUAlarm-UXMMZK36R55Z` .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> Optional[builtins.str]:
        """
        The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic value is used as the first operand.
        """
        return pulumi.get(self, "comparison_operator")

    @property
    @pulumi.getter(name="datapointsToAlarm")
    def datapoints_to_alarm(self) -> Optional[builtins.int]:
        """
        The number of datapoints that must be breaching to trigger the alarm. This is used only if you are setting an "M out of N" alarm. In that case, this value is the M, and the value that you set for ``EvaluationPeriods`` is the N value. For more information, see [Evaluating an Alarm](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation) in the *User Guide*.
         If you omit this parameter, CW uses the same value here that you set for ``EvaluationPeriods``, and the alarm goes to alarm state if that many consecutive periods are breaching.
        """
        return pulumi.get(self, "datapoints_to_alarm")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.AlarmDimension']]:
        """
        The dimensions for the metric associated with the alarm. For an alarm based on a math expression, you can't specify ``Dimensions``. Instead, you use ``Metrics``.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="evaluateLowSampleCountPercentile")
    def evaluate_low_sample_count_percentile(self) -> Optional[builtins.str]:
        """
        Used only for alarms based on percentiles. If ``ignore``, the alarm state does not change during periods with too few data points to be statistically significant. If ``evaluate`` or this parameter is not used, the alarm is always evaluated and possibly changes state no matter how many data points are available.
        """
        return pulumi.get(self, "evaluate_low_sample_count_percentile")

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[builtins.int]:
        """
        The number of periods over which data is compared to the specified threshold. If you are setting an alarm that requires that a number of consecutive data points be breaching to trigger the alarm, this value specifies that number. If you are setting an "M out of N" alarm, this value is the N, and ``DatapointsToAlarm`` is the M.
         For more information, see [Evaluating an Alarm](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation) in the *User Guide*.
        """
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter(name="extendedStatistic")
    def extended_statistic(self) -> Optional[builtins.str]:
        """
        The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
         For an alarm based on a metric, you must specify either ``Statistic`` or ``ExtendedStatistic`` but not both.
         For an alarm based on a math expression, you can't specify ``ExtendedStatistic``. Instead, you use ``Metrics``.
        """
        return pulumi.get(self, "extended_statistic")

    @property
    @pulumi.getter(name="insufficientDataActions")
    def insufficient_data_actions(self) -> Optional[Sequence[builtins.str]]:
        """
        The actions to execute when this alarm transitions to the ``INSUFFICIENT_DATA`` state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "insufficient_data_actions")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[builtins.str]:
        """
        The name of the metric associated with the alarm. This is required for an alarm based on a metric. For an alarm based on a math expression, you use ``Metrics`` instead and you can't specify ``MetricName``.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.AlarmMetricDataQuery']]:
        """
        An array that enables you to create an alarm based on the result of a metric math expression. Each item in the array either retrieves a metric or performs a math expression.
         If you specify the ``Metrics`` parameter, you cannot specify ``MetricName``, ``Dimensions``, ``Period``, ``Namespace``, ``Statistic``, ``ExtendedStatistic``, or ``Unit``.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        The namespace of the metric associated with the alarm. This is required for an alarm based on a metric. For an alarm based on a math expression, you can't specify ``Namespace`` and you use ``Metrics`` instead.
         For a list of namespaces for metrics from AWS services, see [Services That Publish Metrics.](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html)
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="okActions")
    def ok_actions(self) -> Optional[Sequence[builtins.str]]:
        """
        The actions to execute when this alarm transitions to the ``OK`` state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "ok_actions")

    @property
    @pulumi.getter
    def period(self) -> Optional[builtins.int]:
        """
        The period, in seconds, over which the statistic is applied. This is required for an alarm based on a metric. Valid values are 10, 30, 60, and any multiple of 60.
         For an alarm based on a math expression, you can't specify ``Period``, and instead you use the ``Metrics`` parameter.
          *Minimum:* 10
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def statistic(self) -> Optional[builtins.str]:
        """
        The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use ``ExtendedStatistic``.
         For an alarm based on a metric, you must specify either ``Statistic`` or ``ExtendedStatistic`` but not both.
         For an alarm based on a math expression, you can't specify ``Statistic``. Instead, you use ``Metrics``.
        """
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A list of key-value pairs to associate with the alarm. You can associate as many as 50 tags with an alarm. To be able to associate tags with the alarm when you create the alarm, you must have the ``cloudwatch:TagResource`` permission.
         Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[builtins.float]:
        """
        The value to compare with the specified statistic.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="thresholdMetricId")
    def threshold_metric_id(self) -> Optional[builtins.str]:
        """
        In an alarm based on an anomaly detection model, this is the ID of the ``ANOMALY_DETECTION_BAND`` function used as the threshold for the alarm.
        """
        return pulumi.get(self, "threshold_metric_id")

    @property
    @pulumi.getter(name="treatMissingData")
    def treat_missing_data(self) -> Optional[builtins.str]:
        """
        Sets how this alarm is to handle missing data points. Valid values are ``breaching``, ``notBreaching``, ``ignore``, and ``missing``. For more information, see [Configuring How Alarms Treat Missing Data](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data) in the *Amazon User Guide*.
         If you omit this parameter, the default behavior of ``missing`` is used.
        """
        return pulumi.get(self, "treat_missing_data")

    @property
    @pulumi.getter
    def unit(self) -> Optional[builtins.str]:
        """
        The unit of the metric associated with the alarm. Specify this only if you are creating an alarm based on a single metric. Do not specify this if you are specifying a ``Metrics`` array.
          You can specify the following values: Seconds, Microseconds, Milliseconds, Bytes, Kilobytes, Megabytes, Gigabytes, Terabytes, Bits, Kilobits, Megabits, Gigabits, Terabits, Percent, Count, Bytes/Second, Kilobytes/Second, Megabytes/Second, Gigabytes/Second, Terabytes/Second, Bits/Second, Kilobits/Second, Megabits/Second, Gigabits/Second, Terabits/Second, Count/Second, or None.
        """
        return pulumi.get(self, "unit")


class AwaitableGetAlarmResult(GetAlarmResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlarmResult(
            actions_enabled=self.actions_enabled,
            alarm_actions=self.alarm_actions,
            alarm_description=self.alarm_description,
            arn=self.arn,
            comparison_operator=self.comparison_operator,
            datapoints_to_alarm=self.datapoints_to_alarm,
            dimensions=self.dimensions,
            evaluate_low_sample_count_percentile=self.evaluate_low_sample_count_percentile,
            evaluation_periods=self.evaluation_periods,
            extended_statistic=self.extended_statistic,
            insufficient_data_actions=self.insufficient_data_actions,
            metric_name=self.metric_name,
            metrics=self.metrics,
            namespace=self.namespace,
            ok_actions=self.ok_actions,
            period=self.period,
            statistic=self.statistic,
            tags=self.tags,
            threshold=self.threshold,
            threshold_metric_id=self.threshold_metric_id,
            treat_missing_data=self.treat_missing_data,
            unit=self.unit)


def get_alarm(alarm_name: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlarmResult:
    """
    The ``AWS::CloudWatch::Alarm`` type specifies an alarm and associates it with the specified metric or metric math expression.
     When this operation creates an alarm, the alarm state is immediately set to ``INSUFFICIENT_DATA``. The alarm is then evaluated and its state is set appropriately. Any actions associated with the new state are then executed.
     When you update an existing alarm, its state is left unchanged, but the update completely overwrites the previous configuration of the alarm.


    :param builtins.str alarm_name: The name of the alarm. If you don't specify a name, CFN generates a unique physical ID and uses that ID for the alarm name. 
             If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
    """
    __args__ = dict()
    __args__['alarmName'] = alarm_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cloudwatch:getAlarm', __args__, opts=opts, typ=GetAlarmResult).value

    return AwaitableGetAlarmResult(
        actions_enabled=pulumi.get(__ret__, 'actions_enabled'),
        alarm_actions=pulumi.get(__ret__, 'alarm_actions'),
        alarm_description=pulumi.get(__ret__, 'alarm_description'),
        arn=pulumi.get(__ret__, 'arn'),
        comparison_operator=pulumi.get(__ret__, 'comparison_operator'),
        datapoints_to_alarm=pulumi.get(__ret__, 'datapoints_to_alarm'),
        dimensions=pulumi.get(__ret__, 'dimensions'),
        evaluate_low_sample_count_percentile=pulumi.get(__ret__, 'evaluate_low_sample_count_percentile'),
        evaluation_periods=pulumi.get(__ret__, 'evaluation_periods'),
        extended_statistic=pulumi.get(__ret__, 'extended_statistic'),
        insufficient_data_actions=pulumi.get(__ret__, 'insufficient_data_actions'),
        metric_name=pulumi.get(__ret__, 'metric_name'),
        metrics=pulumi.get(__ret__, 'metrics'),
        namespace=pulumi.get(__ret__, 'namespace'),
        ok_actions=pulumi.get(__ret__, 'ok_actions'),
        period=pulumi.get(__ret__, 'period'),
        statistic=pulumi.get(__ret__, 'statistic'),
        tags=pulumi.get(__ret__, 'tags'),
        threshold=pulumi.get(__ret__, 'threshold'),
        threshold_metric_id=pulumi.get(__ret__, 'threshold_metric_id'),
        treat_missing_data=pulumi.get(__ret__, 'treat_missing_data'),
        unit=pulumi.get(__ret__, 'unit'))
def get_alarm_output(alarm_name: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAlarmResult]:
    """
    The ``AWS::CloudWatch::Alarm`` type specifies an alarm and associates it with the specified metric or metric math expression.
     When this operation creates an alarm, the alarm state is immediately set to ``INSUFFICIENT_DATA``. The alarm is then evaluated and its state is set appropriately. Any actions associated with the new state are then executed.
     When you update an existing alarm, its state is left unchanged, but the update completely overwrites the previous configuration of the alarm.


    :param builtins.str alarm_name: The name of the alarm. If you don't specify a name, CFN generates a unique physical ID and uses that ID for the alarm name. 
             If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
    """
    __args__ = dict()
    __args__['alarmName'] = alarm_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cloudwatch:getAlarm', __args__, opts=opts, typ=GetAlarmResult)
    return __ret__.apply(lambda __response__: GetAlarmResult(
        actions_enabled=pulumi.get(__response__, 'actions_enabled'),
        alarm_actions=pulumi.get(__response__, 'alarm_actions'),
        alarm_description=pulumi.get(__response__, 'alarm_description'),
        arn=pulumi.get(__response__, 'arn'),
        comparison_operator=pulumi.get(__response__, 'comparison_operator'),
        datapoints_to_alarm=pulumi.get(__response__, 'datapoints_to_alarm'),
        dimensions=pulumi.get(__response__, 'dimensions'),
        evaluate_low_sample_count_percentile=pulumi.get(__response__, 'evaluate_low_sample_count_percentile'),
        evaluation_periods=pulumi.get(__response__, 'evaluation_periods'),
        extended_statistic=pulumi.get(__response__, 'extended_statistic'),
        insufficient_data_actions=pulumi.get(__response__, 'insufficient_data_actions'),
        metric_name=pulumi.get(__response__, 'metric_name'),
        metrics=pulumi.get(__response__, 'metrics'),
        namespace=pulumi.get(__response__, 'namespace'),
        ok_actions=pulumi.get(__response__, 'ok_actions'),
        period=pulumi.get(__response__, 'period'),
        statistic=pulumi.get(__response__, 'statistic'),
        tags=pulumi.get(__response__, 'tags'),
        threshold=pulumi.get(__response__, 'threshold'),
        threshold_metric_id=pulumi.get(__response__, 'threshold_metric_id'),
        treat_missing_data=pulumi.get(__response__, 'treat_missing_data'),
        unit=pulumi.get(__response__, 'unit')))
