# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetTrailResult',
    'AwaitableGetTrailResult',
    'get_trail',
    'get_trail_output',
]

@pulumi.output_type
class GetTrailResult:
    def __init__(__self__, advanced_event_selectors=None, arn=None, cloud_watch_logs_log_group_arn=None, cloud_watch_logs_role_arn=None, enable_log_file_validation=None, event_selectors=None, include_global_service_events=None, insight_selectors=None, is_logging=None, is_multi_region_trail=None, is_organization_trail=None, kms_key_id=None, s3_bucket_name=None, s3_key_prefix=None, sns_topic_arn=None, sns_topic_name=None, tags=None):
        if advanced_event_selectors and not isinstance(advanced_event_selectors, list):
            raise TypeError("Expected argument 'advanced_event_selectors' to be a list")
        pulumi.set(__self__, "advanced_event_selectors", advanced_event_selectors)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if cloud_watch_logs_log_group_arn and not isinstance(cloud_watch_logs_log_group_arn, str):
            raise TypeError("Expected argument 'cloud_watch_logs_log_group_arn' to be a str")
        pulumi.set(__self__, "cloud_watch_logs_log_group_arn", cloud_watch_logs_log_group_arn)
        if cloud_watch_logs_role_arn and not isinstance(cloud_watch_logs_role_arn, str):
            raise TypeError("Expected argument 'cloud_watch_logs_role_arn' to be a str")
        pulumi.set(__self__, "cloud_watch_logs_role_arn", cloud_watch_logs_role_arn)
        if enable_log_file_validation and not isinstance(enable_log_file_validation, bool):
            raise TypeError("Expected argument 'enable_log_file_validation' to be a bool")
        pulumi.set(__self__, "enable_log_file_validation", enable_log_file_validation)
        if event_selectors and not isinstance(event_selectors, list):
            raise TypeError("Expected argument 'event_selectors' to be a list")
        pulumi.set(__self__, "event_selectors", event_selectors)
        if include_global_service_events and not isinstance(include_global_service_events, bool):
            raise TypeError("Expected argument 'include_global_service_events' to be a bool")
        pulumi.set(__self__, "include_global_service_events", include_global_service_events)
        if insight_selectors and not isinstance(insight_selectors, list):
            raise TypeError("Expected argument 'insight_selectors' to be a list")
        pulumi.set(__self__, "insight_selectors", insight_selectors)
        if is_logging and not isinstance(is_logging, bool):
            raise TypeError("Expected argument 'is_logging' to be a bool")
        pulumi.set(__self__, "is_logging", is_logging)
        if is_multi_region_trail and not isinstance(is_multi_region_trail, bool):
            raise TypeError("Expected argument 'is_multi_region_trail' to be a bool")
        pulumi.set(__self__, "is_multi_region_trail", is_multi_region_trail)
        if is_organization_trail and not isinstance(is_organization_trail, bool):
            raise TypeError("Expected argument 'is_organization_trail' to be a bool")
        pulumi.set(__self__, "is_organization_trail", is_organization_trail)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if s3_bucket_name and not isinstance(s3_bucket_name, str):
            raise TypeError("Expected argument 's3_bucket_name' to be a str")
        pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_key_prefix and not isinstance(s3_key_prefix, str):
            raise TypeError("Expected argument 's3_key_prefix' to be a str")
        pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)
        if sns_topic_arn and not isinstance(sns_topic_arn, str):
            raise TypeError("Expected argument 'sns_topic_arn' to be a str")
        pulumi.set(__self__, "sns_topic_arn", sns_topic_arn)
        if sns_topic_name and not isinstance(sns_topic_name, str):
            raise TypeError("Expected argument 'sns_topic_name' to be a str")
        pulumi.set(__self__, "sns_topic_name", sns_topic_name)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="advancedEventSelectors")
    def advanced_event_selectors(self) -> Optional[Sequence['outputs.TrailAdvancedEventSelector']]:
        """
        The advanced event selectors that were used to select events for the data store.
        """
        return pulumi.get(self, "advanced_event_selectors")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        `Ref` returns the ARN of the CloudTrail trail, such as `arn:aws:cloudtrail:us-east-2:123456789012:trail/myCloudTrail` .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="cloudWatchLogsLogGroupArn")
    def cloud_watch_logs_log_group_arn(self) -> Optional[builtins.str]:
        """
        Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered. Not required unless you specify CloudWatchLogsRoleArn.
        """
        return pulumi.get(self, "cloud_watch_logs_log_group_arn")

    @property
    @pulumi.getter(name="cloudWatchLogsRoleArn")
    def cloud_watch_logs_role_arn(self) -> Optional[builtins.str]:
        """
        Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
        """
        return pulumi.get(self, "cloud_watch_logs_role_arn")

    @property
    @pulumi.getter(name="enableLogFileValidation")
    def enable_log_file_validation(self) -> Optional[builtins.bool]:
        """
        Specifies whether log file validation is enabled. The default is false.
        """
        return pulumi.get(self, "enable_log_file_validation")

    @property
    @pulumi.getter(name="eventSelectors")
    def event_selectors(self) -> Optional[Sequence['outputs.TrailEventSelector']]:
        """
        Use event selectors to further specify the management and data event settings for your trail. By default, trails created without specific event selectors will be configured to log all read and write management events, and no data events. When an event occurs in your account, CloudTrail evaluates the event selector for all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event. You can configure up to five event selectors for a trail.
        """
        return pulumi.get(self, "event_selectors")

    @property
    @pulumi.getter(name="includeGlobalServiceEvents")
    def include_global_service_events(self) -> Optional[builtins.bool]:
        """
        Specifies whether the trail is publishing events from global services such as IAM to the log files.
        """
        return pulumi.get(self, "include_global_service_events")

    @property
    @pulumi.getter(name="insightSelectors")
    def insight_selectors(self) -> Optional[Sequence['outputs.TrailInsightSelector']]:
        """
        Lets you enable Insights event logging by specifying the Insights selectors that you want to enable on an existing trail.
        """
        return pulumi.get(self, "insight_selectors")

    @property
    @pulumi.getter(name="isLogging")
    def is_logging(self) -> Optional[builtins.bool]:
        """
        Whether the CloudTrail is currently logging AWS API calls.
        """
        return pulumi.get(self, "is_logging")

    @property
    @pulumi.getter(name="isMultiRegionTrail")
    def is_multi_region_trail(self) -> Optional[builtins.bool]:
        """
        Specifies whether the trail applies only to the current region or to all regions. The default is false. If the trail exists only in the current region and this value is set to true, shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider using trails that log events in all regions.
        """
        return pulumi.get(self, "is_multi_region_trail")

    @property
    @pulumi.getter(name="isOrganizationTrail")
    def is_organization_trail(self) -> Optional[builtins.bool]:
        """
        Specifies whether the trail is created for all accounts in an organization in AWS Organizations, or only for the current AWS account. The default is false, and cannot be true unless the call is made on behalf of an AWS account that is the master account for an organization in AWS Organizations.
        """
        return pulumi.get(self, "is_organization_trail")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias name prefixed by 'alias/', a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[builtins.str]:
        """
        Specifies the name of the Amazon S3 bucket designated for publishing log files. See Amazon S3 Bucket Naming Requirements.
        """
        return pulumi.get(self, "s3_bucket_name")

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> Optional[builtins.str]:
        """
        Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see Finding Your CloudTrail Log Files. The maximum length is 200 characters.
        """
        return pulumi.get(self, "s3_key_prefix")

    @property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> Optional[builtins.str]:
        """
        `Ref` returns the ARN of the Amazon SNS topic that's associated with the CloudTrail trail, such as `arn:aws:sns:us-east-2:123456789012:mySNSTopic` .
        """
        return pulumi.get(self, "sns_topic_arn")

    @property
    @pulumi.getter(name="snsTopicName")
    def sns_topic_name(self) -> Optional[builtins.str]:
        """
        Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.
        """
        return pulumi.get(self, "sns_topic_name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A custom set of tags (key-value pairs) for this trail.
        """
        return pulumi.get(self, "tags")


class AwaitableGetTrailResult(GetTrailResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTrailResult(
            advanced_event_selectors=self.advanced_event_selectors,
            arn=self.arn,
            cloud_watch_logs_log_group_arn=self.cloud_watch_logs_log_group_arn,
            cloud_watch_logs_role_arn=self.cloud_watch_logs_role_arn,
            enable_log_file_validation=self.enable_log_file_validation,
            event_selectors=self.event_selectors,
            include_global_service_events=self.include_global_service_events,
            insight_selectors=self.insight_selectors,
            is_logging=self.is_logging,
            is_multi_region_trail=self.is_multi_region_trail,
            is_organization_trail=self.is_organization_trail,
            kms_key_id=self.kms_key_id,
            s3_bucket_name=self.s3_bucket_name,
            s3_key_prefix=self.s3_key_prefix,
            sns_topic_arn=self.sns_topic_arn,
            sns_topic_name=self.sns_topic_name,
            tags=self.tags)


def get_trail(trail_name: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTrailResult:
    """
    Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket. A maximum of five trails can exist in a region, irrespective of the region in which they were created.


    :param builtins.str trail_name: Specifies the name of the trail. The name must meet the following requirements:
           
           - Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
           - Start with a letter or number, and end with a letter or number
           - Be between 3 and 128 characters
           - Have no adjacent periods, underscores or dashes. Names like `my-_namespace` and `my--namespace` are not valid.
           - Not be in IP address format (for example, 192.168.5.4)
    """
    __args__ = dict()
    __args__['trailName'] = trail_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cloudtrail:getTrail', __args__, opts=opts, typ=GetTrailResult).value

    return AwaitableGetTrailResult(
        advanced_event_selectors=pulumi.get(__ret__, 'advanced_event_selectors'),
        arn=pulumi.get(__ret__, 'arn'),
        cloud_watch_logs_log_group_arn=pulumi.get(__ret__, 'cloud_watch_logs_log_group_arn'),
        cloud_watch_logs_role_arn=pulumi.get(__ret__, 'cloud_watch_logs_role_arn'),
        enable_log_file_validation=pulumi.get(__ret__, 'enable_log_file_validation'),
        event_selectors=pulumi.get(__ret__, 'event_selectors'),
        include_global_service_events=pulumi.get(__ret__, 'include_global_service_events'),
        insight_selectors=pulumi.get(__ret__, 'insight_selectors'),
        is_logging=pulumi.get(__ret__, 'is_logging'),
        is_multi_region_trail=pulumi.get(__ret__, 'is_multi_region_trail'),
        is_organization_trail=pulumi.get(__ret__, 'is_organization_trail'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        s3_bucket_name=pulumi.get(__ret__, 's3_bucket_name'),
        s3_key_prefix=pulumi.get(__ret__, 's3_key_prefix'),
        sns_topic_arn=pulumi.get(__ret__, 'sns_topic_arn'),
        sns_topic_name=pulumi.get(__ret__, 'sns_topic_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_trail_output(trail_name: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTrailResult]:
    """
    Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket. A maximum of five trails can exist in a region, irrespective of the region in which they were created.


    :param builtins.str trail_name: Specifies the name of the trail. The name must meet the following requirements:
           
           - Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
           - Start with a letter or number, and end with a letter or number
           - Be between 3 and 128 characters
           - Have no adjacent periods, underscores or dashes. Names like `my-_namespace` and `my--namespace` are not valid.
           - Not be in IP address format (for example, 192.168.5.4)
    """
    __args__ = dict()
    __args__['trailName'] = trail_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cloudtrail:getTrail', __args__, opts=opts, typ=GetTrailResult)
    return __ret__.apply(lambda __response__: GetTrailResult(
        advanced_event_selectors=pulumi.get(__response__, 'advanced_event_selectors'),
        arn=pulumi.get(__response__, 'arn'),
        cloud_watch_logs_log_group_arn=pulumi.get(__response__, 'cloud_watch_logs_log_group_arn'),
        cloud_watch_logs_role_arn=pulumi.get(__response__, 'cloud_watch_logs_role_arn'),
        enable_log_file_validation=pulumi.get(__response__, 'enable_log_file_validation'),
        event_selectors=pulumi.get(__response__, 'event_selectors'),
        include_global_service_events=pulumi.get(__response__, 'include_global_service_events'),
        insight_selectors=pulumi.get(__response__, 'insight_selectors'),
        is_logging=pulumi.get(__response__, 'is_logging'),
        is_multi_region_trail=pulumi.get(__response__, 'is_multi_region_trail'),
        is_organization_trail=pulumi.get(__response__, 'is_organization_trail'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        s3_bucket_name=pulumi.get(__response__, 's3_bucket_name'),
        s3_key_prefix=pulumi.get(__response__, 's3_key_prefix'),
        sns_topic_arn=pulumi.get(__response__, 'sns_topic_arn'),
        sns_topic_name=pulumi.get(__response__, 'sns_topic_name'),
        tags=pulumi.get(__response__, 'tags')))
