# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetDashboardResult',
    'AwaitableGetDashboardResult',
    'get_dashboard',
    'get_dashboard_output',
]

@pulumi.output_type
class GetDashboardResult:
    def __init__(__self__, created_timestamp=None, dashboard_arn=None, name=None, refresh_schedule=None, status=None, tags=None, termination_protection_enabled=None, type=None, updated_timestamp=None, widgets=None):
        if created_timestamp and not isinstance(created_timestamp, str):
            raise TypeError("Expected argument 'created_timestamp' to be a str")
        pulumi.set(__self__, "created_timestamp", created_timestamp)
        if dashboard_arn and not isinstance(dashboard_arn, str):
            raise TypeError("Expected argument 'dashboard_arn' to be a str")
        pulumi.set(__self__, "dashboard_arn", dashboard_arn)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if refresh_schedule and not isinstance(refresh_schedule, dict):
            raise TypeError("Expected argument 'refresh_schedule' to be a dict")
        pulumi.set(__self__, "refresh_schedule", refresh_schedule)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if termination_protection_enabled and not isinstance(termination_protection_enabled, bool):
            raise TypeError("Expected argument 'termination_protection_enabled' to be a bool")
        pulumi.set(__self__, "termination_protection_enabled", termination_protection_enabled)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if updated_timestamp and not isinstance(updated_timestamp, str):
            raise TypeError("Expected argument 'updated_timestamp' to be a str")
        pulumi.set(__self__, "updated_timestamp", updated_timestamp)
        if widgets and not isinstance(widgets, list):
            raise TypeError("Expected argument 'widgets' to be a list")
        pulumi.set(__self__, "widgets", widgets)

    @property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> Optional[builtins.str]:
        """
        The timestamp of the dashboard creation.
        """
        return pulumi.get(self, "created_timestamp")

    @property
    @pulumi.getter(name="dashboardArn")
    def dashboard_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the dashboard.
        """
        return pulumi.get(self, "dashboard_arn")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the dashboard.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="refreshSchedule")
    def refresh_schedule(self) -> Optional['outputs.DashboardRefreshSchedule']:
        """
        Configures the automatic refresh schedule for the dashboard. Includes the frequency unit (DAYS or HOURS) and value, as well as the status (ENABLED or DISABLED) of the refresh schedule.
        """
        return pulumi.get(self, "refresh_schedule")

    @property
    @pulumi.getter
    def status(self) -> Optional['DashboardStatus']:
        """
        The status of the dashboard. Values are CREATING, CREATED, UPDATING, UPDATED and DELETING.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A list of tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="terminationProtectionEnabled")
    def termination_protection_enabled(self) -> Optional[builtins.bool]:
        """
        Indicates whether the dashboard is protected from termination.
        """
        return pulumi.get(self, "termination_protection_enabled")

    @property
    @pulumi.getter
    def type(self) -> Optional['DashboardType']:
        """
        The type of the dashboard. Values are CUSTOM and MANAGED.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedTimestamp")
    def updated_timestamp(self) -> Optional[builtins.str]:
        """
        The timestamp showing when the dashboard was updated, if applicable. UpdatedTimestamp is always either the same or newer than the time shown in CreatedTimestamp.
        """
        return pulumi.get(self, "updated_timestamp")

    @property
    @pulumi.getter
    def widgets(self) -> Optional[Sequence['outputs.DashboardWidget']]:
        """
        List of widgets on the dashboard
        """
        return pulumi.get(self, "widgets")


class AwaitableGetDashboardResult(GetDashboardResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDashboardResult(
            created_timestamp=self.created_timestamp,
            dashboard_arn=self.dashboard_arn,
            name=self.name,
            refresh_schedule=self.refresh_schedule,
            status=self.status,
            tags=self.tags,
            termination_protection_enabled=self.termination_protection_enabled,
            type=self.type,
            updated_timestamp=self.updated_timestamp,
            widgets=self.widgets)


def get_dashboard(dashboard_arn: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDashboardResult:
    """
    The Amazon CloudTrail dashboard resource allows customers to manage managed dashboards and create custom dashboards. You can manually refresh custom and managed dashboards. For custom dashboards, you can also set up an automatic refresh schedule and modify dashboard widgets.


    :param builtins.str dashboard_arn: The ARN of the dashboard.
    """
    __args__ = dict()
    __args__['dashboardArn'] = dashboard_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cloudtrail:getDashboard', __args__, opts=opts, typ=GetDashboardResult).value

    return AwaitableGetDashboardResult(
        created_timestamp=pulumi.get(__ret__, 'created_timestamp'),
        dashboard_arn=pulumi.get(__ret__, 'dashboard_arn'),
        name=pulumi.get(__ret__, 'name'),
        refresh_schedule=pulumi.get(__ret__, 'refresh_schedule'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        termination_protection_enabled=pulumi.get(__ret__, 'termination_protection_enabled'),
        type=pulumi.get(__ret__, 'type'),
        updated_timestamp=pulumi.get(__ret__, 'updated_timestamp'),
        widgets=pulumi.get(__ret__, 'widgets'))
def get_dashboard_output(dashboard_arn: Optional[pulumi.Input[builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDashboardResult]:
    """
    The Amazon CloudTrail dashboard resource allows customers to manage managed dashboards and create custom dashboards. You can manually refresh custom and managed dashboards. For custom dashboards, you can also set up an automatic refresh schedule and modify dashboard widgets.


    :param builtins.str dashboard_arn: The ARN of the dashboard.
    """
    __args__ = dict()
    __args__['dashboardArn'] = dashboard_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cloudtrail:getDashboard', __args__, opts=opts, typ=GetDashboardResult)
    return __ret__.apply(lambda __response__: GetDashboardResult(
        created_timestamp=pulumi.get(__response__, 'created_timestamp'),
        dashboard_arn=pulumi.get(__response__, 'dashboard_arn'),
        name=pulumi.get(__response__, 'name'),
        refresh_schedule=pulumi.get(__response__, 'refresh_schedule'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        termination_protection_enabled=pulumi.get(__response__, 'termination_protection_enabled'),
        type=pulumi.get(__response__, 'type'),
        updated_timestamp=pulumi.get(__response__, 'updated_timestamp'),
        widgets=pulumi.get(__response__, 'widgets')))
