# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['DashboardArgs', 'Dashboard']

@pulumi.input_type
class DashboardArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_schedule: Optional[pulumi.Input['DashboardRefreshScheduleArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 termination_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 widgets: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardWidgetArgs']]]] = None):
        """
        The set of arguments for constructing a Dashboard resource.
        :param pulumi.Input[builtins.str] name: The name of the dashboard.
        :param pulumi.Input['DashboardRefreshScheduleArgs'] refresh_schedule: Configures the automatic refresh schedule for the dashboard. Includes the frequency unit (DAYS or HOURS) and value, as well as the status (ENABLED or DISABLED) of the refresh schedule.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A list of tags.
        :param pulumi.Input[builtins.bool] termination_protection_enabled: Indicates whether the dashboard is protected from termination.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardWidgetArgs']]] widgets: List of widgets on the dashboard
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if refresh_schedule is not None:
            pulumi.set(__self__, "refresh_schedule", refresh_schedule)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_protection_enabled is not None:
            pulumi.set(__self__, "termination_protection_enabled", termination_protection_enabled)
        if widgets is not None:
            pulumi.set(__self__, "widgets", widgets)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the dashboard.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="refreshSchedule")
    def refresh_schedule(self) -> Optional[pulumi.Input['DashboardRefreshScheduleArgs']]:
        """
        Configures the automatic refresh schedule for the dashboard. Includes the frequency unit (DAYS or HOURS) and value, as well as the status (ENABLED or DISABLED) of the refresh schedule.
        """
        return pulumi.get(self, "refresh_schedule")

    @refresh_schedule.setter
    def refresh_schedule(self, value: Optional[pulumi.Input['DashboardRefreshScheduleArgs']]):
        pulumi.set(self, "refresh_schedule", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A list of tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="terminationProtectionEnabled")
    def termination_protection_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the dashboard is protected from termination.
        """
        return pulumi.get(self, "termination_protection_enabled")

    @termination_protection_enabled.setter
    def termination_protection_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "termination_protection_enabled", value)

    @property
    @pulumi.getter
    def widgets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardWidgetArgs']]]]:
        """
        List of widgets on the dashboard
        """
        return pulumi.get(self, "widgets")

    @widgets.setter
    def widgets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardWidgetArgs']]]]):
        pulumi.set(self, "widgets", value)


@pulumi.type_token("aws-native:cloudtrail:Dashboard")
class Dashboard(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_schedule: Optional[pulumi.Input[Union['DashboardRefreshScheduleArgs', 'DashboardRefreshScheduleArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 termination_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 widgets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardWidgetArgs', 'DashboardWidgetArgsDict']]]]] = None,
                 __props__=None):
        """
        The Amazon CloudTrail dashboard resource allows customers to manage managed dashboards and create custom dashboards. You can manually refresh custom and managed dashboards. For custom dashboards, you can also set up an automatic refresh schedule and modify dashboard widgets.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name of the dashboard.
        :param pulumi.Input[Union['DashboardRefreshScheduleArgs', 'DashboardRefreshScheduleArgsDict']] refresh_schedule: Configures the automatic refresh schedule for the dashboard. Includes the frequency unit (DAYS or HOURS) and value, as well as the status (ENABLED or DISABLED) of the refresh schedule.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A list of tags.
        :param pulumi.Input[builtins.bool] termination_protection_enabled: Indicates whether the dashboard is protected from termination.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DashboardWidgetArgs', 'DashboardWidgetArgsDict']]]] widgets: List of widgets on the dashboard
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DashboardArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Amazon CloudTrail dashboard resource allows customers to manage managed dashboards and create custom dashboards. You can manually refresh custom and managed dashboards. For custom dashboards, you can also set up an automatic refresh schedule and modify dashboard widgets.

        :param str resource_name: The name of the resource.
        :param DashboardArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DashboardArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_schedule: Optional[pulumi.Input[Union['DashboardRefreshScheduleArgs', 'DashboardRefreshScheduleArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 termination_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 widgets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardWidgetArgs', 'DashboardWidgetArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DashboardArgs.__new__(DashboardArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["refresh_schedule"] = refresh_schedule
            __props__.__dict__["tags"] = tags
            __props__.__dict__["termination_protection_enabled"] = termination_protection_enabled
            __props__.__dict__["widgets"] = widgets
            __props__.__dict__["created_timestamp"] = None
            __props__.__dict__["dashboard_arn"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["updated_timestamp"] = None
        super(Dashboard, __self__).__init__(
            'aws-native:cloudtrail:Dashboard',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Dashboard':
        """
        Get an existing Dashboard resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DashboardArgs.__new__(DashboardArgs)

        __props__.__dict__["created_timestamp"] = None
        __props__.__dict__["dashboard_arn"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["refresh_schedule"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["termination_protection_enabled"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["updated_timestamp"] = None
        __props__.__dict__["widgets"] = None
        return Dashboard(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp of the dashboard creation.
        """
        return pulumi.get(self, "created_timestamp")

    @property
    @pulumi.getter(name="dashboardArn")
    def dashboard_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the dashboard.
        """
        return pulumi.get(self, "dashboard_arn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the dashboard.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="refreshSchedule")
    def refresh_schedule(self) -> pulumi.Output[Optional['outputs.DashboardRefreshSchedule']]:
        """
        Configures the automatic refresh schedule for the dashboard. Includes the frequency unit (DAYS or HOURS) and value, as well as the status (ENABLED or DISABLED) of the refresh schedule.
        """
        return pulumi.get(self, "refresh_schedule")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['DashboardStatus']:
        """
        The status of the dashboard. Values are CREATING, CREATED, UPDATING, UPDATED and DELETING.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A list of tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="terminationProtectionEnabled")
    def termination_protection_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether the dashboard is protected from termination.
        """
        return pulumi.get(self, "termination_protection_enabled")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output['DashboardType']:
        """
        The type of the dashboard. Values are CUSTOM and MANAGED.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedTimestamp")
    def updated_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp showing when the dashboard was updated, if applicable. UpdatedTimestamp is always either the same or newer than the time shown in CreatedTimestamp.
        """
        return pulumi.get(self, "updated_timestamp")

    @property
    @pulumi.getter
    def widgets(self) -> pulumi.Output[Optional[Sequence['outputs.DashboardWidget']]]:
        """
        List of widgets on the dashboard
        """
        return pulumi.get(self, "widgets")

