# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['VpcOriginArgs', 'VpcOrigin']

@pulumi.input_type
class VpcOriginArgs:
    def __init__(__self__, *,
                 vpc_origin_endpoint_config: pulumi.Input['VpcOriginEndpointConfigArgs'],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a VpcOrigin resource.
        :param pulumi.Input['VpcOriginEndpointConfigArgs'] vpc_origin_endpoint_config: The VPC origin endpoint configuration.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A complex type that contains zero or more ``Tag`` elements.
        """
        pulumi.set(__self__, "vpc_origin_endpoint_config", vpc_origin_endpoint_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="vpcOriginEndpointConfig")
    def vpc_origin_endpoint_config(self) -> pulumi.Input['VpcOriginEndpointConfigArgs']:
        """
        The VPC origin endpoint configuration.
        """
        return pulumi.get(self, "vpc_origin_endpoint_config")

    @vpc_origin_endpoint_config.setter
    def vpc_origin_endpoint_config(self, value: pulumi.Input['VpcOriginEndpointConfigArgs']):
        pulumi.set(self, "vpc_origin_endpoint_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A complex type that contains zero or more ``Tag`` elements.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:cloudfront:VpcOrigin")
class VpcOrigin(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 vpc_origin_endpoint_config: Optional[pulumi.Input[Union['VpcOriginEndpointConfigArgs', 'VpcOriginEndpointConfigArgsDict']]] = None,
                 __props__=None):
        """
        An Amazon CloudFront VPC origin.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A complex type that contains zero or more ``Tag`` elements.
        :param pulumi.Input[Union['VpcOriginEndpointConfigArgs', 'VpcOriginEndpointConfigArgsDict']] vpc_origin_endpoint_config: The VPC origin endpoint configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcOriginArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An Amazon CloudFront VPC origin.

        :param str resource_name: The name of the resource.
        :param VpcOriginArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcOriginArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 vpc_origin_endpoint_config: Optional[pulumi.Input[Union['VpcOriginEndpointConfigArgs', 'VpcOriginEndpointConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcOriginArgs.__new__(VpcOriginArgs)

            __props__.__dict__["tags"] = tags
            if vpc_origin_endpoint_config is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_origin_endpoint_config'")
            __props__.__dict__["vpc_origin_endpoint_config"] = vpc_origin_endpoint_config
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["last_modified_time"] = None
            __props__.__dict__["status"] = None
        super(VpcOrigin, __self__).__init__(
            'aws-native:cloudfront:VpcOrigin',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'VpcOrigin':
        """
        Get an existing VpcOrigin resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = VpcOriginArgs.__new__(VpcOriginArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["created_time"] = None
        __props__.__dict__["last_modified_time"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["vpc_origin_endpoint_config"] = None
        return VpcOrigin(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The VPC origin ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The VPC origin ID.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[builtins.str]:
        """
        The VPC origin created time.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[builtins.str]:
        """
        The VPC origin last modified time.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The VPC origin status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A complex type that contains zero or more ``Tag`` elements.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcOriginEndpointConfig")
    def vpc_origin_endpoint_config(self) -> pulumi.Output['outputs.VpcOriginEndpointConfig']:
        """
        The VPC origin endpoint configuration.
        """
        return pulumi.get(self, "vpc_origin_endpoint_config")

