# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CachePolicyConfig',
    'CachePolicyCookiesConfig',
    'CachePolicyHeadersConfig',
    'CachePolicyParametersInCacheKeyAndForwardedToOrigin',
    'CachePolicyQueryStringsConfig',
    'CloudFrontOriginAccessIdentityConfig',
    'ContinuousDeploymentPolicyConfig',
    'ContinuousDeploymentPolicyConfigSingleHeaderPolicyConfigProperties',
    'ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigProperties',
    'ContinuousDeploymentPolicySessionStickinessConfig',
    'ContinuousDeploymentPolicySingleHeaderConfig',
    'ContinuousDeploymentPolicySingleWeightConfig',
    'ContinuousDeploymentPolicyTrafficConfig',
    'DistributionCacheBehavior',
    'DistributionConfig',
    'DistributionConfigTenantConfigProperties',
    'DistributionCookies',
    'DistributionCustomErrorResponse',
    'DistributionCustomOriginConfig',
    'DistributionDefaultCacheBehavior',
    'DistributionForwardedValues',
    'DistributionFunctionAssociation',
    'DistributionGeoRestriction',
    'DistributionGrpcConfig',
    'DistributionLambdaFunctionAssociation',
    'DistributionLegacyCustomOrigin',
    'DistributionLegacyS3Origin',
    'DistributionLogging',
    'DistributionOrigin',
    'DistributionOriginCustomHeader',
    'DistributionOriginGroup',
    'DistributionOriginGroupFailoverCriteria',
    'DistributionOriginGroupMember',
    'DistributionOriginGroupMembers',
    'DistributionOriginGroups',
    'DistributionOriginShield',
    'DistributionParameterDefinition',
    'DistributionParameterDefinitionDefinitionProperties',
    'DistributionParameterDefinitionDefinitionPropertiesStringSchemaProperties',
    'DistributionRestrictions',
    'DistributionS3OriginConfig',
    'DistributionStatusCodes',
    'DistributionTenantCertificate',
    'DistributionTenantCustomizations',
    'DistributionTenantDomainResult',
    'DistributionTenantGeoRestrictionCustomization',
    'DistributionTenantManagedCertificateRequest',
    'DistributionTenantParameter',
    'DistributionTenantWebAclCustomization',
    'DistributionViewerCertificate',
    'DistributionVpcOriginConfig',
    'FunctionConfig',
    'FunctionKeyValueStoreAssociation',
    'FunctionMetadata',
    'KeyGroupConfig',
    'KeyValueStoreImportSource',
    'MonitoringSubscription',
    'MonitoringSubscriptionRealtimeMetricsSubscriptionConfig',
    'OriginAccessControlConfig',
    'OriginRequestPolicyConfig',
    'OriginRequestPolicyCookiesConfig',
    'OriginRequestPolicyHeadersConfig',
    'OriginRequestPolicyQueryStringsConfig',
    'PublicKeyConfig',
    'RealtimeLogConfigEndPoint',
    'RealtimeLogConfigKinesisStreamConfig',
    'ResponseHeadersPolicyAccessControlAllowHeaders',
    'ResponseHeadersPolicyAccessControlAllowMethods',
    'ResponseHeadersPolicyAccessControlAllowOrigins',
    'ResponseHeadersPolicyAccessControlExposeHeaders',
    'ResponseHeadersPolicyConfig',
    'ResponseHeadersPolicyContentSecurityPolicy',
    'ResponseHeadersPolicyContentTypeOptions',
    'ResponseHeadersPolicyCorsConfig',
    'ResponseHeadersPolicyCustomHeader',
    'ResponseHeadersPolicyCustomHeadersConfig',
    'ResponseHeadersPolicyFrameOptions',
    'ResponseHeadersPolicyReferrerPolicy',
    'ResponseHeadersPolicyRemoveHeader',
    'ResponseHeadersPolicyRemoveHeadersConfig',
    'ResponseHeadersPolicySecurityHeadersConfig',
    'ResponseHeadersPolicyServerTimingHeadersConfig',
    'ResponseHeadersPolicyStrictTransportSecurity',
    'ResponseHeadersPolicyXssProtection',
    'VpcOriginEndpointConfig',
]

@pulumi.output_type
class CachePolicyConfig(dict):
    """
    A cache policy configuration.
     This configuration determines the following:
      +  The values that CloudFront includes in the cache key. These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
      +  The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront cache.
      
     The headers, cookies, and query strings that are included in the cache key are also included in requests that CloudFront sends to the origin. CloudFront sends a request when it can't find a valid object in its cache that matches the request's cache key. If you want to send values to the origin but *not* include them in the cache key, use ``OriginRequestPolicy``.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultTtl":
            suggest = "default_ttl"
        elif key == "maxTtl":
            suggest = "max_ttl"
        elif key == "minTtl":
            suggest = "min_ttl"
        elif key == "parametersInCacheKeyAndForwardedToOrigin":
            suggest = "parameters_in_cache_key_and_forwarded_to_origin"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CachePolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CachePolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CachePolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_ttl: builtins.float,
                 max_ttl: builtins.float,
                 min_ttl: builtins.float,
                 name: builtins.str,
                 parameters_in_cache_key_and_forwarded_to_origin: 'outputs.CachePolicyParametersInCacheKeyAndForwardedToOrigin',
                 comment: Optional[builtins.str] = None):
        """
        A cache policy configuration.
         This configuration determines the following:
          +  The values that CloudFront includes in the cache key. These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
          +  The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront cache.
          
         The headers, cookies, and query strings that are included in the cache key are also included in requests that CloudFront sends to the origin. CloudFront sends a request when it can't find a valid object in its cache that matches the request's cache key. If you want to send values to the origin but *not* include them in the cache key, use ``OriginRequestPolicy``.
        :param builtins.float default_ttl: The default amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. CloudFront uses this value as the object's time to live (TTL) only when the origin does *not* send ``Cache-Control`` or ``Expires`` headers with the object. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
                The default value for this field is 86400 seconds (one day). If the value of ``MinTTL`` is more than 86400 seconds, then the default value for this field is the same as the value of ``MinTTL``.
        :param builtins.float max_ttl: The maximum amount of time, in seconds, that objects stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. CloudFront uses this value only when the origin sends ``Cache-Control`` or ``Expires`` headers with the object. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
                The default value for this field is 31536000 seconds (one year). If the value of ``MinTTL`` or ``DefaultTTL`` is more than 31536000 seconds, then the default value for this field is the same as the value of ``DefaultTTL``.
        :param builtins.float min_ttl: The minimum amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.str name: A unique name to identify the cache policy.
        :param 'CachePolicyParametersInCacheKeyAndForwardedToOrigin' parameters_in_cache_key_and_forwarded_to_origin: The HTTP headers, cookies, and URL query strings to include in the cache key. The values included in the cache key are also included in requests that CloudFront sends to the origin.
        :param builtins.str comment: A comment to describe the cache policy. The comment cannot be longer than 128 characters.
        """
        pulumi.set(__self__, "default_ttl", default_ttl)
        pulumi.set(__self__, "max_ttl", max_ttl)
        pulumi.set(__self__, "min_ttl", min_ttl)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameters_in_cache_key_and_forwarded_to_origin", parameters_in_cache_key_and_forwarded_to_origin)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> builtins.float:
        """
        The default amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. CloudFront uses this value as the object's time to live (TTL) only when the origin does *not* send ``Cache-Control`` or ``Expires`` headers with the object. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
         The default value for this field is 86400 seconds (one day). If the value of ``MinTTL`` is more than 86400 seconds, then the default value for this field is the same as the value of ``MinTTL``.
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> builtins.float:
        """
        The maximum amount of time, in seconds, that objects stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. CloudFront uses this value only when the origin sends ``Cache-Control`` or ``Expires`` headers with the object. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
         The default value for this field is 31536000 seconds (one year). If the value of ``MinTTL`` or ``DefaultTTL`` is more than 31536000 seconds, then the default value for this field is the same as the value of ``DefaultTTL``.
        """
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter(name="minTtl")
    def min_ttl(self) -> builtins.float:
        """
        The minimum amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "min_ttl")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify the cache policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parametersInCacheKeyAndForwardedToOrigin")
    def parameters_in_cache_key_and_forwarded_to_origin(self) -> 'outputs.CachePolicyParametersInCacheKeyAndForwardedToOrigin':
        """
        The HTTP headers, cookies, and URL query strings to include in the cache key. The values included in the cache key are also included in requests that CloudFront sends to the origin.
        """
        return pulumi.get(self, "parameters_in_cache_key_and_forwarded_to_origin")

    @property
    @pulumi.getter
    def comment(self) -> Optional[builtins.str]:
        """
        A comment to describe the cache policy. The comment cannot be longer than 128 characters.
        """
        return pulumi.get(self, "comment")


@pulumi.output_type
class CachePolicyCookiesConfig(dict):
    """
    An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and in requests that CloudFront sends to the origin.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieBehavior":
            suggest = "cookie_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CachePolicyCookiesConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CachePolicyCookiesConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CachePolicyCookiesConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookie_behavior: builtins.str,
                 cookies: Optional[Sequence[builtins.str]] = None):
        """
        An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and in requests that CloudFront sends to the origin.
        :param builtins.str cookie_behavior: Determines whether any cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin. Valid values are:
                 +  ``none`` – No cookies in viewer requests are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any cookies that are listed in an ``OriginRequestPolicy``*are* included in origin requests.
                 +  ``whitelist`` – Only the cookies in viewer requests that are listed in the ``CookieNames`` type are included in the cache key and in requests that CloudFront sends to the origin.
                 +  ``allExcept`` – All cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin, *except* for those that are listed in the ``CookieNames`` type, which are not included.
                 +  ``all`` – All cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin.
        :param Sequence[builtins.str] cookies: Contains a list of cookie names.
        """
        pulumi.set(__self__, "cookie_behavior", cookie_behavior)
        if cookies is not None:
            pulumi.set(__self__, "cookies", cookies)

    @property
    @pulumi.getter(name="cookieBehavior")
    def cookie_behavior(self) -> builtins.str:
        """
        Determines whether any cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin. Valid values are:
          +  ``none`` – No cookies in viewer requests are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any cookies that are listed in an ``OriginRequestPolicy``*are* included in origin requests.
          +  ``whitelist`` – Only the cookies in viewer requests that are listed in the ``CookieNames`` type are included in the cache key and in requests that CloudFront sends to the origin.
          +  ``allExcept`` – All cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin, *except* for those that are listed in the ``CookieNames`` type, which are not included.
          +  ``all`` – All cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin.
        """
        return pulumi.get(self, "cookie_behavior")

    @property
    @pulumi.getter
    def cookies(self) -> Optional[Sequence[builtins.str]]:
        """
        Contains a list of cookie names.
        """
        return pulumi.get(self, "cookies")


@pulumi.output_type
class CachePolicyHeadersConfig(dict):
    """
    An object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and in requests that CloudFront sends to the origin.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerBehavior":
            suggest = "header_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CachePolicyHeadersConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CachePolicyHeadersConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CachePolicyHeadersConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_behavior: builtins.str,
                 headers: Optional[Sequence[builtins.str]] = None):
        """
        An object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and in requests that CloudFront sends to the origin.
        :param builtins.str header_behavior: Determines whether any HTTP headers are included in the cache key and in requests that CloudFront sends to the origin. Valid values are:
                 +  ``none`` – No HTTP headers are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any headers that are listed in an ``OriginRequestPolicy``*are* included in origin requests.
                 +  ``whitelist`` – Only the HTTP headers that are listed in the ``Headers`` type are included in the cache key and in requests that CloudFront sends to the origin.
        :param Sequence[builtins.str] headers: Contains a list of HTTP header names.
        """
        pulumi.set(__self__, "header_behavior", header_behavior)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)

    @property
    @pulumi.getter(name="headerBehavior")
    def header_behavior(self) -> builtins.str:
        """
        Determines whether any HTTP headers are included in the cache key and in requests that CloudFront sends to the origin. Valid values are:
          +  ``none`` – No HTTP headers are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any headers that are listed in an ``OriginRequestPolicy``*are* included in origin requests.
          +  ``whitelist`` – Only the HTTP headers that are listed in the ``Headers`` type are included in the cache key and in requests that CloudFront sends to the origin.
        """
        return pulumi.get(self, "header_behavior")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence[builtins.str]]:
        """
        Contains a list of HTTP header names.
        """
        return pulumi.get(self, "headers")


@pulumi.output_type
class CachePolicyParametersInCacheKeyAndForwardedToOrigin(dict):
    """
    This object determines the values that CloudFront includes in the cache key. These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
     The headers, cookies, and query strings that are included in the cache key are also included in requests that CloudFront sends to the origin. CloudFront sends a request when it can't find an object in its cache that matches the request's cache key. If you want to send values to the origin but *not* include them in the cache key, use ``OriginRequestPolicy``.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookiesConfig":
            suggest = "cookies_config"
        elif key == "enableAcceptEncodingGzip":
            suggest = "enable_accept_encoding_gzip"
        elif key == "headersConfig":
            suggest = "headers_config"
        elif key == "queryStringsConfig":
            suggest = "query_strings_config"
        elif key == "enableAcceptEncodingBrotli":
            suggest = "enable_accept_encoding_brotli"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CachePolicyParametersInCacheKeyAndForwardedToOrigin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CachePolicyParametersInCacheKeyAndForwardedToOrigin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CachePolicyParametersInCacheKeyAndForwardedToOrigin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookies_config: 'outputs.CachePolicyCookiesConfig',
                 enable_accept_encoding_gzip: builtins.bool,
                 headers_config: 'outputs.CachePolicyHeadersConfig',
                 query_strings_config: 'outputs.CachePolicyQueryStringsConfig',
                 enable_accept_encoding_brotli: Optional[builtins.bool] = None):
        """
        This object determines the values that CloudFront includes in the cache key. These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
         The headers, cookies, and query strings that are included in the cache key are also included in requests that CloudFront sends to the origin. CloudFront sends a request when it can't find an object in its cache that matches the request's cache key. If you want to send values to the origin but *not* include them in the cache key, use ``OriginRequestPolicy``.
        :param 'CachePolicyCookiesConfig' cookies_config: An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and in requests that CloudFront sends to the origin.
        :param builtins.bool enable_accept_encoding_gzip: A flag that can affect whether the ``Accept-Encoding`` HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
                This field is related to the ``EnableAcceptEncodingBrotli`` field. If one or both of these fields is ``true``*and* the viewer request includes the ``Accept-Encoding`` header, then CloudFront does the following:
                 +  Normalizes the value of the viewer's ``Accept-Encoding`` header
                 +  Includes the normalized header in the cache key
                 +  Includes the normalized header in the request to the origin, if a request is necessary
                 
                For more information, see [Compression support](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects) in the *Amazon CloudFront Developer Guide*.
                If you set this value to ``true``, and this cache behavior also has an origin request policy attached, do not include the ``Accept-Encoding`` header in the origin request policy. CloudFront always includes the ``Accept-Encoding`` header in origin requests when the value of this field is ``true``, so including this header in an origin request policy has no effect.
                If both of these fields are ``false``, then CloudFront treats the ``Accept-Encoding`` header the same as any other HTTP header in the viewer request. By default, it's not included in the cache key and it's not included in origin requests. In this case, you can manually add ``Accept-Encoding`` to the headers whitelist like any other HTTP header.
        :param 'CachePolicyHeadersConfig' headers_config: An object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and in requests that CloudFront sends to the origin.
        :param 'CachePolicyQueryStringsConfig' query_strings_config: An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and in requests that CloudFront sends to the origin.
        :param builtins.bool enable_accept_encoding_brotli: A flag that can affect whether the ``Accept-Encoding`` HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
                This field is related to the ``EnableAcceptEncodingGzip`` field. If one or both of these fields is ``true``*and* the viewer request includes the ``Accept-Encoding`` header, then CloudFront does the following:
                 +  Normalizes the value of the viewer's ``Accept-Encoding`` header
                 +  Includes the normalized header in the cache key
                 +  Includes the normalized header in the request to the origin, if a request is necessary
                 
                For more information, see [Compression support](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects) in the *Amazon CloudFront Developer Guide*.
                If you set this value to ``true``, and this cache behavior also has an origin request policy attached, do not include the ``Accept-Encoding`` header in the origin request policy. CloudFront always includes the ``Accept-Encoding`` header in origin requests when the value of this field is ``true``, so including this header in an origin request policy has no effect.
                If both of these fields are ``false``, then CloudFront treats the ``Accept-Encoding`` header the same as any other HTTP header in the viewer request. By default, it's not included in the cache key and it's not included in origin requests. In this case, you can manually add ``Accept-Encoding`` to the headers whitelist like any other HTTP header.
        """
        pulumi.set(__self__, "cookies_config", cookies_config)
        pulumi.set(__self__, "enable_accept_encoding_gzip", enable_accept_encoding_gzip)
        pulumi.set(__self__, "headers_config", headers_config)
        pulumi.set(__self__, "query_strings_config", query_strings_config)
        if enable_accept_encoding_brotli is not None:
            pulumi.set(__self__, "enable_accept_encoding_brotli", enable_accept_encoding_brotli)

    @property
    @pulumi.getter(name="cookiesConfig")
    def cookies_config(self) -> 'outputs.CachePolicyCookiesConfig':
        """
        An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and in requests that CloudFront sends to the origin.
        """
        return pulumi.get(self, "cookies_config")

    @property
    @pulumi.getter(name="enableAcceptEncodingGzip")
    def enable_accept_encoding_gzip(self) -> builtins.bool:
        """
        A flag that can affect whether the ``Accept-Encoding`` HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
         This field is related to the ``EnableAcceptEncodingBrotli`` field. If one or both of these fields is ``true``*and* the viewer request includes the ``Accept-Encoding`` header, then CloudFront does the following:
          +  Normalizes the value of the viewer's ``Accept-Encoding`` header
          +  Includes the normalized header in the cache key
          +  Includes the normalized header in the request to the origin, if a request is necessary
          
         For more information, see [Compression support](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects) in the *Amazon CloudFront Developer Guide*.
         If you set this value to ``true``, and this cache behavior also has an origin request policy attached, do not include the ``Accept-Encoding`` header in the origin request policy. CloudFront always includes the ``Accept-Encoding`` header in origin requests when the value of this field is ``true``, so including this header in an origin request policy has no effect.
         If both of these fields are ``false``, then CloudFront treats the ``Accept-Encoding`` header the same as any other HTTP header in the viewer request. By default, it's not included in the cache key and it's not included in origin requests. In this case, you can manually add ``Accept-Encoding`` to the headers whitelist like any other HTTP header.
        """
        return pulumi.get(self, "enable_accept_encoding_gzip")

    @property
    @pulumi.getter(name="headersConfig")
    def headers_config(self) -> 'outputs.CachePolicyHeadersConfig':
        """
        An object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and in requests that CloudFront sends to the origin.
        """
        return pulumi.get(self, "headers_config")

    @property
    @pulumi.getter(name="queryStringsConfig")
    def query_strings_config(self) -> 'outputs.CachePolicyQueryStringsConfig':
        """
        An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and in requests that CloudFront sends to the origin.
        """
        return pulumi.get(self, "query_strings_config")

    @property
    @pulumi.getter(name="enableAcceptEncodingBrotli")
    def enable_accept_encoding_brotli(self) -> Optional[builtins.bool]:
        """
        A flag that can affect whether the ``Accept-Encoding`` HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
         This field is related to the ``EnableAcceptEncodingGzip`` field. If one or both of these fields is ``true``*and* the viewer request includes the ``Accept-Encoding`` header, then CloudFront does the following:
          +  Normalizes the value of the viewer's ``Accept-Encoding`` header
          +  Includes the normalized header in the cache key
          +  Includes the normalized header in the request to the origin, if a request is necessary
          
         For more information, see [Compression support](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects) in the *Amazon CloudFront Developer Guide*.
         If you set this value to ``true``, and this cache behavior also has an origin request policy attached, do not include the ``Accept-Encoding`` header in the origin request policy. CloudFront always includes the ``Accept-Encoding`` header in origin requests when the value of this field is ``true``, so including this header in an origin request policy has no effect.
         If both of these fields are ``false``, then CloudFront treats the ``Accept-Encoding`` header the same as any other HTTP header in the viewer request. By default, it's not included in the cache key and it's not included in origin requests. In this case, you can manually add ``Accept-Encoding`` to the headers whitelist like any other HTTP header.
        """
        return pulumi.get(self, "enable_accept_encoding_brotli")


@pulumi.output_type
class CachePolicyQueryStringsConfig(dict):
    """
    An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and in requests that CloudFront sends to the origin.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryStringBehavior":
            suggest = "query_string_behavior"
        elif key == "queryStrings":
            suggest = "query_strings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CachePolicyQueryStringsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CachePolicyQueryStringsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CachePolicyQueryStringsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_string_behavior: builtins.str,
                 query_strings: Optional[Sequence[builtins.str]] = None):
        """
        An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and in requests that CloudFront sends to the origin.
        :param builtins.str query_string_behavior: Determines whether any URL query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin. Valid values are:
                 +  ``none`` – No query strings in viewer requests are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any query strings that are listed in an ``OriginRequestPolicy``*are* included in origin requests.
                 +  ``whitelist`` – Only the query strings in viewer requests that are listed in the ``QueryStringNames`` type are included in the cache key and in requests that CloudFront sends to the origin.
                 +  ``allExcept`` – All query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin, *except* those that are listed in the ``QueryStringNames`` type, which are not included.
                 +  ``all`` – All query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin.
        :param Sequence[builtins.str] query_strings: Contains a list of query string names.
        """
        pulumi.set(__self__, "query_string_behavior", query_string_behavior)
        if query_strings is not None:
            pulumi.set(__self__, "query_strings", query_strings)

    @property
    @pulumi.getter(name="queryStringBehavior")
    def query_string_behavior(self) -> builtins.str:
        """
        Determines whether any URL query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin. Valid values are:
          +  ``none`` – No query strings in viewer requests are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any query strings that are listed in an ``OriginRequestPolicy``*are* included in origin requests.
          +  ``whitelist`` – Only the query strings in viewer requests that are listed in the ``QueryStringNames`` type are included in the cache key and in requests that CloudFront sends to the origin.
          +  ``allExcept`` – All query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin, *except* those that are listed in the ``QueryStringNames`` type, which are not included.
          +  ``all`` – All query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin.
        """
        return pulumi.get(self, "query_string_behavior")

    @property
    @pulumi.getter(name="queryStrings")
    def query_strings(self) -> Optional[Sequence[builtins.str]]:
        """
        Contains a list of query string names.
        """
        return pulumi.get(self, "query_strings")


@pulumi.output_type
class CloudFrontOriginAccessIdentityConfig(dict):
    """
    Origin access identity configuration. Send a ``GET`` request to the ``/CloudFront API version/CloudFront/identity ID/config`` resource.
    """
    def __init__(__self__, *,
                 comment: builtins.str):
        """
        Origin access identity configuration. Send a ``GET`` request to the ``/CloudFront API version/CloudFront/identity ID/config`` resource.
        :param builtins.str comment: A comment to describe the origin access identity. The comment cannot be longer than 128 characters.
        """
        pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter
    def comment(self) -> builtins.str:
        """
        A comment to describe the origin access identity. The comment cannot be longer than 128 characters.
        """
        return pulumi.get(self, "comment")


@pulumi.output_type
class ContinuousDeploymentPolicyConfig(dict):
    """
    Contains the configuration for a continuous deployment policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stagingDistributionDnsNames":
            suggest = "staging_distribution_dns_names"
        elif key == "singleHeaderPolicyConfig":
            suggest = "single_header_policy_config"
        elif key == "singleWeightPolicyConfig":
            suggest = "single_weight_policy_config"
        elif key == "trafficConfig":
            suggest = "traffic_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContinuousDeploymentPolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContinuousDeploymentPolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContinuousDeploymentPolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 staging_distribution_dns_names: Sequence[builtins.str],
                 single_header_policy_config: Optional['outputs.ContinuousDeploymentPolicyConfigSingleHeaderPolicyConfigProperties'] = None,
                 single_weight_policy_config: Optional['outputs.ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigProperties'] = None,
                 traffic_config: Optional['outputs.ContinuousDeploymentPolicyTrafficConfig'] = None,
                 type: Optional['ContinuousDeploymentPolicyConfigType'] = None):
        """
        Contains the configuration for a continuous deployment policy.
        :param builtins.bool enabled: A Boolean that indicates whether this continuous deployment policy is enabled (in effect). When this value is ``true``, this policy is enabled and in effect. When this value is ``false``, this policy is not enabled and has no effect.
        :param Sequence[builtins.str] staging_distribution_dns_names: The CloudFront domain name of the staging distribution. For example: ``d111111abcdef8.cloudfront.net``.
        :param 'ContinuousDeploymentPolicyConfigSingleHeaderPolicyConfigProperties' single_header_policy_config: This configuration determines which HTTP requests are sent to the staging distribution. If the HTTP request contains a header and value that matches what you specify here, the request is sent to the staging distribution. Otherwise the request is sent to the primary distribution.
        :param 'ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigProperties' single_weight_policy_config: This configuration determines the percentage of HTTP requests that are sent to the staging distribution.
        :param 'ContinuousDeploymentPolicyTrafficConfig' traffic_config: Contains the parameters for routing production traffic from your primary to staging distributions.
        :param 'ContinuousDeploymentPolicyConfigType' type: The type of traffic configuration.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "staging_distribution_dns_names", staging_distribution_dns_names)
        if single_header_policy_config is not None:
            pulumi.set(__self__, "single_header_policy_config", single_header_policy_config)
        if single_weight_policy_config is not None:
            pulumi.set(__self__, "single_weight_policy_config", single_weight_policy_config)
        if traffic_config is not None:
            pulumi.set(__self__, "traffic_config", traffic_config)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        A Boolean that indicates whether this continuous deployment policy is enabled (in effect). When this value is ``true``, this policy is enabled and in effect. When this value is ``false``, this policy is not enabled and has no effect.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="stagingDistributionDnsNames")
    def staging_distribution_dns_names(self) -> Sequence[builtins.str]:
        """
        The CloudFront domain name of the staging distribution. For example: ``d111111abcdef8.cloudfront.net``.
        """
        return pulumi.get(self, "staging_distribution_dns_names")

    @property
    @pulumi.getter(name="singleHeaderPolicyConfig")
    def single_header_policy_config(self) -> Optional['outputs.ContinuousDeploymentPolicyConfigSingleHeaderPolicyConfigProperties']:
        """
        This configuration determines which HTTP requests are sent to the staging distribution. If the HTTP request contains a header and value that matches what you specify here, the request is sent to the staging distribution. Otherwise the request is sent to the primary distribution.
        """
        return pulumi.get(self, "single_header_policy_config")

    @property
    @pulumi.getter(name="singleWeightPolicyConfig")
    def single_weight_policy_config(self) -> Optional['outputs.ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigProperties']:
        """
        This configuration determines the percentage of HTTP requests that are sent to the staging distribution.
        """
        return pulumi.get(self, "single_weight_policy_config")

    @property
    @pulumi.getter(name="trafficConfig")
    def traffic_config(self) -> Optional['outputs.ContinuousDeploymentPolicyTrafficConfig']:
        """
        Contains the parameters for routing production traffic from your primary to staging distributions.
        """
        return pulumi.get(self, "traffic_config")

    @property
    @pulumi.getter
    def type(self) -> Optional['ContinuousDeploymentPolicyConfigType']:
        """
        The type of traffic configuration.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ContinuousDeploymentPolicyConfigSingleHeaderPolicyConfigProperties(dict):
    """
    This configuration determines which HTTP requests are sent to the staging distribution. If the HTTP request contains a header and value that matches what you specify here, the request is sent to the staging distribution. Otherwise the request is sent to the primary distribution.
    """
    def __init__(__self__, *,
                 header: builtins.str,
                 value: builtins.str):
        """
        This configuration determines which HTTP requests are sent to the staging distribution. If the HTTP request contains a header and value that matches what you specify here, the request is sent to the staging distribution. Otherwise the request is sent to the primary distribution.
        """
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def header(self) -> builtins.str:
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigProperties(dict):
    """
    This configuration determines the percentage of HTTP requests that are sent to the staging distribution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sessionStickinessConfig":
            suggest = "session_stickiness_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 weight: builtins.float,
                 session_stickiness_config: Optional['outputs.ContinuousDeploymentPolicySessionStickinessConfig'] = None):
        """
        This configuration determines the percentage of HTTP requests that are sent to the staging distribution.
        """
        pulumi.set(__self__, "weight", weight)
        if session_stickiness_config is not None:
            pulumi.set(__self__, "session_stickiness_config", session_stickiness_config)

    @property
    @pulumi.getter
    def weight(self) -> builtins.float:
        return pulumi.get(self, "weight")

    @property
    @pulumi.getter(name="sessionStickinessConfig")
    def session_stickiness_config(self) -> Optional['outputs.ContinuousDeploymentPolicySessionStickinessConfig']:
        return pulumi.get(self, "session_stickiness_config")


@pulumi.output_type
class ContinuousDeploymentPolicySessionStickinessConfig(dict):
    """
    Session stickiness provides the ability to define multiple requests from a single viewer as a single session. This prevents the potentially inconsistent experience of sending some of a given user's requests to your staging distribution, while others are sent to your primary distribution. Define the session duration using TTL values.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idleTtl":
            suggest = "idle_ttl"
        elif key == "maximumTtl":
            suggest = "maximum_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContinuousDeploymentPolicySessionStickinessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContinuousDeploymentPolicySessionStickinessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContinuousDeploymentPolicySessionStickinessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idle_ttl: builtins.int,
                 maximum_ttl: builtins.int):
        """
        Session stickiness provides the ability to define multiple requests from a single viewer as a single session. This prevents the potentially inconsistent experience of sending some of a given user's requests to your staging distribution, while others are sent to your primary distribution. Define the session duration using TTL values.
        :param builtins.int idle_ttl: The amount of time after which you want sessions to cease if no requests are received. Allowed values are 300–3600 seconds (5–60 minutes).
        :param builtins.int maximum_ttl: The maximum amount of time to consider requests from the viewer as being part of the same session. Allowed values are 300–3600 seconds (5–60 minutes).
        """
        pulumi.set(__self__, "idle_ttl", idle_ttl)
        pulumi.set(__self__, "maximum_ttl", maximum_ttl)

    @property
    @pulumi.getter(name="idleTtl")
    def idle_ttl(self) -> builtins.int:
        """
        The amount of time after which you want sessions to cease if no requests are received. Allowed values are 300–3600 seconds (5–60 minutes).
        """
        return pulumi.get(self, "idle_ttl")

    @property
    @pulumi.getter(name="maximumTtl")
    def maximum_ttl(self) -> builtins.int:
        """
        The maximum amount of time to consider requests from the viewer as being part of the same session. Allowed values are 300–3600 seconds (5–60 minutes).
        """
        return pulumi.get(self, "maximum_ttl")


@pulumi.output_type
class ContinuousDeploymentPolicySingleHeaderConfig(dict):
    """
    Determines which HTTP requests are sent to the staging distribution.
    """
    def __init__(__self__, *,
                 header: builtins.str,
                 value: builtins.str):
        """
        Determines which HTTP requests are sent to the staging distribution.
        :param builtins.str header: The request header name that you want CloudFront to send to your staging distribution. The header must contain the prefix ``aws-cf-cd-``.
        :param builtins.str value: The request header value.
        """
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def header(self) -> builtins.str:
        """
        The request header name that you want CloudFront to send to your staging distribution. The header must contain the prefix ``aws-cf-cd-``.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The request header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ContinuousDeploymentPolicySingleWeightConfig(dict):
    """
    This configuration determines the percentage of HTTP requests that are sent to the staging distribution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sessionStickinessConfig":
            suggest = "session_stickiness_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContinuousDeploymentPolicySingleWeightConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContinuousDeploymentPolicySingleWeightConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContinuousDeploymentPolicySingleWeightConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 weight: builtins.float,
                 session_stickiness_config: Optional['outputs.ContinuousDeploymentPolicySessionStickinessConfig'] = None):
        """
        This configuration determines the percentage of HTTP requests that are sent to the staging distribution.
        :param builtins.float weight: The percentage of traffic to send to a staging distribution, expressed as a decimal number between 0 and 0.15. For example, a value of 0.10 means 10% of traffic is sent to the staging distribution.
        :param 'ContinuousDeploymentPolicySessionStickinessConfig' session_stickiness_config: Session stickiness provides the ability to define multiple requests from a single viewer as a single session. This prevents the potentially inconsistent experience of sending some of a given user's requests to your staging distribution, while others are sent to your primary distribution. Define the session duration using TTL values.
        """
        pulumi.set(__self__, "weight", weight)
        if session_stickiness_config is not None:
            pulumi.set(__self__, "session_stickiness_config", session_stickiness_config)

    @property
    @pulumi.getter
    def weight(self) -> builtins.float:
        """
        The percentage of traffic to send to a staging distribution, expressed as a decimal number between 0 and 0.15. For example, a value of 0.10 means 10% of traffic is sent to the staging distribution.
        """
        return pulumi.get(self, "weight")

    @property
    @pulumi.getter(name="sessionStickinessConfig")
    def session_stickiness_config(self) -> Optional['outputs.ContinuousDeploymentPolicySessionStickinessConfig']:
        """
        Session stickiness provides the ability to define multiple requests from a single viewer as a single session. This prevents the potentially inconsistent experience of sending some of a given user's requests to your staging distribution, while others are sent to your primary distribution. Define the session duration using TTL values.
        """
        return pulumi.get(self, "session_stickiness_config")


@pulumi.output_type
class ContinuousDeploymentPolicyTrafficConfig(dict):
    """
    The traffic configuration of your continuous deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "singleHeaderConfig":
            suggest = "single_header_config"
        elif key == "singleWeightConfig":
            suggest = "single_weight_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContinuousDeploymentPolicyTrafficConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContinuousDeploymentPolicyTrafficConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContinuousDeploymentPolicyTrafficConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'ContinuousDeploymentPolicyTrafficConfigType',
                 single_header_config: Optional['outputs.ContinuousDeploymentPolicySingleHeaderConfig'] = None,
                 single_weight_config: Optional['outputs.ContinuousDeploymentPolicySingleWeightConfig'] = None):
        """
        The traffic configuration of your continuous deployment.
        :param 'ContinuousDeploymentPolicyTrafficConfigType' type: The type of traffic configuration.
        :param 'ContinuousDeploymentPolicySingleHeaderConfig' single_header_config: Determines which HTTP requests are sent to the staging distribution.
        :param 'ContinuousDeploymentPolicySingleWeightConfig' single_weight_config: Contains the percentage of traffic to send to the staging distribution.
        """
        pulumi.set(__self__, "type", type)
        if single_header_config is not None:
            pulumi.set(__self__, "single_header_config", single_header_config)
        if single_weight_config is not None:
            pulumi.set(__self__, "single_weight_config", single_weight_config)

    @property
    @pulumi.getter
    def type(self) -> 'ContinuousDeploymentPolicyTrafficConfigType':
        """
        The type of traffic configuration.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="singleHeaderConfig")
    def single_header_config(self) -> Optional['outputs.ContinuousDeploymentPolicySingleHeaderConfig']:
        """
        Determines which HTTP requests are sent to the staging distribution.
        """
        return pulumi.get(self, "single_header_config")

    @property
    @pulumi.getter(name="singleWeightConfig")
    def single_weight_config(self) -> Optional['outputs.ContinuousDeploymentPolicySingleWeightConfig']:
        """
        Contains the percentage of traffic to send to the staging distribution.
        """
        return pulumi.get(self, "single_weight_config")


@pulumi.output_type
class DistributionCacheBehavior(dict):
    """
    A complex type that describes how CloudFront processes requests.
     You must create at least as many cache behaviors (including the default cache behavior) as you have origins if you want CloudFront to serve objects from all of the origins. Each cache behavior specifies the one origin from which you want CloudFront to get objects. If you have two origins and only the default cache behavior, the default cache behavior will cause CloudFront to get objects from one of the origins, but the other origin is never used.
     For the current quota (formerly known as limit) on the number of cache behaviors that you can add to a distribution, see [Quotas](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html) in the *Amazon CloudFront Developer Guide*.
     If you don't want to specify any cache behaviors, include only an empty ``CacheBehaviors`` element. Don't specify an empty individual ``CacheBehavior`` element, because this is invalid. For more information, see [CacheBehaviors](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CacheBehaviors.html). 
     To delete all cache behaviors in an existing distribution, update the distribution configuration and include only an empty ``CacheBehaviors`` element.
     To add, change, or remove one or more cache behaviors, update the distribution configuration and specify all of the cache behaviors that you want to include in the updated distribution.
     For more information about cache behaviors, see [Cache Behavior Settings](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesCacheBehavior) in the *Amazon CloudFront Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pathPattern":
            suggest = "path_pattern"
        elif key == "targetOriginId":
            suggest = "target_origin_id"
        elif key == "viewerProtocolPolicy":
            suggest = "viewer_protocol_policy"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "cachePolicyId":
            suggest = "cache_policy_id"
        elif key == "cachedMethods":
            suggest = "cached_methods"
        elif key == "defaultTtl":
            suggest = "default_ttl"
        elif key == "fieldLevelEncryptionId":
            suggest = "field_level_encryption_id"
        elif key == "forwardedValues":
            suggest = "forwarded_values"
        elif key == "functionAssociations":
            suggest = "function_associations"
        elif key == "grpcConfig":
            suggest = "grpc_config"
        elif key == "lambdaFunctionAssociations":
            suggest = "lambda_function_associations"
        elif key == "maxTtl":
            suggest = "max_ttl"
        elif key == "minTtl":
            suggest = "min_ttl"
        elif key == "originRequestPolicyId":
            suggest = "origin_request_policy_id"
        elif key == "realtimeLogConfigArn":
            suggest = "realtime_log_config_arn"
        elif key == "responseHeadersPolicyId":
            suggest = "response_headers_policy_id"
        elif key == "smoothStreaming":
            suggest = "smooth_streaming"
        elif key == "trustedKeyGroups":
            suggest = "trusted_key_groups"
        elif key == "trustedSigners":
            suggest = "trusted_signers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCacheBehavior. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCacheBehavior.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCacheBehavior.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path_pattern: builtins.str,
                 target_origin_id: builtins.str,
                 viewer_protocol_policy: builtins.str,
                 allowed_methods: Optional[Sequence[builtins.str]] = None,
                 cache_policy_id: Optional[builtins.str] = None,
                 cached_methods: Optional[Sequence[builtins.str]] = None,
                 compress: Optional[builtins.bool] = None,
                 default_ttl: Optional[builtins.float] = None,
                 field_level_encryption_id: Optional[builtins.str] = None,
                 forwarded_values: Optional['outputs.DistributionForwardedValues'] = None,
                 function_associations: Optional[Sequence['outputs.DistributionFunctionAssociation']] = None,
                 grpc_config: Optional['outputs.DistributionGrpcConfig'] = None,
                 lambda_function_associations: Optional[Sequence['outputs.DistributionLambdaFunctionAssociation']] = None,
                 max_ttl: Optional[builtins.float] = None,
                 min_ttl: Optional[builtins.float] = None,
                 origin_request_policy_id: Optional[builtins.str] = None,
                 realtime_log_config_arn: Optional[builtins.str] = None,
                 response_headers_policy_id: Optional[builtins.str] = None,
                 smooth_streaming: Optional[builtins.bool] = None,
                 trusted_key_groups: Optional[Sequence[builtins.str]] = None,
                 trusted_signers: Optional[Sequence[builtins.str]] = None):
        """
        A complex type that describes how CloudFront processes requests.
         You must create at least as many cache behaviors (including the default cache behavior) as you have origins if you want CloudFront to serve objects from all of the origins. Each cache behavior specifies the one origin from which you want CloudFront to get objects. If you have two origins and only the default cache behavior, the default cache behavior will cause CloudFront to get objects from one of the origins, but the other origin is never used.
         For the current quota (formerly known as limit) on the number of cache behaviors that you can add to a distribution, see [Quotas](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html) in the *Amazon CloudFront Developer Guide*.
         If you don't want to specify any cache behaviors, include only an empty ``CacheBehaviors`` element. Don't specify an empty individual ``CacheBehavior`` element, because this is invalid. For more information, see [CacheBehaviors](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CacheBehaviors.html). 
         To delete all cache behaviors in an existing distribution, update the distribution configuration and include only an empty ``CacheBehaviors`` element.
         To add, change, or remove one or more cache behaviors, update the distribution configuration and specify all of the cache behaviors that you want to include in the updated distribution.
         For more information about cache behaviors, see [Cache Behavior Settings](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesCacheBehavior) in the *Amazon CloudFront Developer Guide*.
        :param builtins.str path_pattern: The pattern (for example, ``images/*.jpg``) that specifies which requests to apply the behavior to. When CloudFront receives a viewer request, the requested path is compared with path patterns in the order in which cache behaviors are listed in the distribution.
                 You can optionally include a slash (``/``) at the beginning of the path pattern. For example, ``/images/*.jpg``. CloudFront behavior is the same with or without the leading ``/``.
                 The path pattern for the default cache behavior is ``*`` and cannot be changed. If the request for an object does not match the path pattern for any cache behaviors, CloudFront applies the behavior in the default cache behavior.
                For more information, see [Path Pattern](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesPathPattern) in the *Amazon CloudFront Developer Guide*.
        :param builtins.str target_origin_id: The value of ``ID`` for the origin that you want CloudFront to route requests to when they match this cache behavior.
        :param builtins.str viewer_protocol_policy: The protocol that viewers can use to access the files in the origin specified by ``TargetOriginId`` when a request matches the path pattern in ``PathPattern``. You can specify the following options:
                 +  ``allow-all``: Viewers can use HTTP or HTTPS.
                 +  ``redirect-to-https``: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.
                 +  ``https-only``: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).
                 
                For more information about requiring the HTTPS protocol, see [Requiring HTTPS Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html) in the *Amazon CloudFront Developer Guide*.
                 The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see [Managing Cache Expiration](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        :param Sequence[builtins.str] allowed_methods: A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin. There are three choices:
                 +  CloudFront forwards only ``GET`` and ``HEAD`` requests.
                 +  CloudFront forwards only ``GET``, ``HEAD``, and ``OPTIONS`` requests.
                 +  CloudFront forwards ``GET, HEAD, OPTIONS, PUT, PATCH, POST``, and ``DELETE`` requests.
                 
                If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
        :param builtins.str cache_policy_id: The unique identifier of the cache policy that is attached to this cache behavior. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                A ``CacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
        :param Sequence[builtins.str] cached_methods: A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods. There are two choices:
                 +  CloudFront caches responses to ``GET`` and ``HEAD`` requests.
                 +  CloudFront caches responses to ``GET``, ``HEAD``, and ``OPTIONS`` requests.
                 
                If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
        :param builtins.bool compress: Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify true; if not, specify false. For more information, see [Serving Compressed Files](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.float default_ttl: This field is deprecated. We recommend that you use the ``DefaultTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.str field_level_encryption_id: The value of ``ID`` for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for this cache behavior.
        :param 'DistributionForwardedValues' forwarded_values: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see [Working with policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html) in the *Amazon CloudFront Developer Guide*.
                If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
                A ``CacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
                A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
        :param Sequence['DistributionFunctionAssociation'] function_associations: A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must be published to the ``LIVE`` stage to associate them with a cache behavior.
        :param 'DistributionGrpcConfig' grpc_config: The gRPC configuration for your cache behavior.
        :param Sequence['DistributionLambdaFunctionAssociation'] lambda_function_associations: A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
        :param builtins.float max_ttl: This field is deprecated. We recommend that you use the ``MaxTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.float min_ttl: This field is deprecated. We recommend that you use the ``MinTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
                You must specify ``0`` for ``MinTTL`` if you configure CloudFront to forward all headers to your origin (under ``Headers``, if you specify ``1`` for ``Quantity`` and ``*`` for ``Name``).
        :param builtins.str origin_request_policy_id: The unique identifier of the origin request policy that is attached to this cache behavior. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.str realtime_log_config_arn: The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior. For more information, see [Real-time logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.str response_headers_policy_id: The identifier for a response headers policy.
        :param builtins.bool smooth_streaming: Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior. If so, specify ``true``; if not, specify ``false``. If you specify ``true`` for ``SmoothStreaming``, you can still distribute other content using this cache behavior if the content matches the value of ``PathPattern``.
        :param Sequence[builtins.str] trusted_key_groups: A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
                When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        :param Sequence[builtins.str] trusted_signers: We recommend using ``TrustedKeyGroups`` instead of ``TrustedSigners``.
                 A list of AWS-account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.
                When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in the trusted signer's AWS-account. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        pulumi.set(__self__, "path_pattern", path_pattern)
        pulumi.set(__self__, "target_origin_id", target_origin_id)
        pulumi.set(__self__, "viewer_protocol_policy", viewer_protocol_policy)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if cache_policy_id is not None:
            pulumi.set(__self__, "cache_policy_id", cache_policy_id)
        if cached_methods is not None:
            pulumi.set(__self__, "cached_methods", cached_methods)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if field_level_encryption_id is not None:
            pulumi.set(__self__, "field_level_encryption_id", field_level_encryption_id)
        if forwarded_values is not None:
            pulumi.set(__self__, "forwarded_values", forwarded_values)
        if function_associations is not None:
            pulumi.set(__self__, "function_associations", function_associations)
        if grpc_config is not None:
            pulumi.set(__self__, "grpc_config", grpc_config)
        if lambda_function_associations is not None:
            pulumi.set(__self__, "lambda_function_associations", lambda_function_associations)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if min_ttl is not None:
            pulumi.set(__self__, "min_ttl", min_ttl)
        if origin_request_policy_id is not None:
            pulumi.set(__self__, "origin_request_policy_id", origin_request_policy_id)
        if realtime_log_config_arn is not None:
            pulumi.set(__self__, "realtime_log_config_arn", realtime_log_config_arn)
        if response_headers_policy_id is not None:
            pulumi.set(__self__, "response_headers_policy_id", response_headers_policy_id)
        if smooth_streaming is not None:
            pulumi.set(__self__, "smooth_streaming", smooth_streaming)
        if trusted_key_groups is not None:
            pulumi.set(__self__, "trusted_key_groups", trusted_key_groups)
        if trusted_signers is not None:
            pulumi.set(__self__, "trusted_signers", trusted_signers)

    @property
    @pulumi.getter(name="pathPattern")
    def path_pattern(self) -> builtins.str:
        """
        The pattern (for example, ``images/*.jpg``) that specifies which requests to apply the behavior to. When CloudFront receives a viewer request, the requested path is compared with path patterns in the order in which cache behaviors are listed in the distribution.
          You can optionally include a slash (``/``) at the beginning of the path pattern. For example, ``/images/*.jpg``. CloudFront behavior is the same with or without the leading ``/``.
          The path pattern for the default cache behavior is ``*`` and cannot be changed. If the request for an object does not match the path pattern for any cache behaviors, CloudFront applies the behavior in the default cache behavior.
         For more information, see [Path Pattern](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesPathPattern) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "path_pattern")

    @property
    @pulumi.getter(name="targetOriginId")
    def target_origin_id(self) -> builtins.str:
        """
        The value of ``ID`` for the origin that you want CloudFront to route requests to when they match this cache behavior.
        """
        return pulumi.get(self, "target_origin_id")

    @property
    @pulumi.getter(name="viewerProtocolPolicy")
    def viewer_protocol_policy(self) -> builtins.str:
        """
        The protocol that viewers can use to access the files in the origin specified by ``TargetOriginId`` when a request matches the path pattern in ``PathPattern``. You can specify the following options:
          +  ``allow-all``: Viewers can use HTTP or HTTPS.
          +  ``redirect-to-https``: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.
          +  ``https-only``: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).
          
         For more information about requiring the HTTPS protocol, see [Requiring HTTPS Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html) in the *Amazon CloudFront Developer Guide*.
          The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see [Managing Cache Expiration](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "viewer_protocol_policy")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[Sequence[builtins.str]]:
        """
        A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin. There are three choices:
          +  CloudFront forwards only ``GET`` and ``HEAD`` requests.
          +  CloudFront forwards only ``GET``, ``HEAD``, and ``OPTIONS`` requests.
          +  CloudFront forwards ``GET, HEAD, OPTIONS, PUT, PATCH, POST``, and ``DELETE`` requests.
          
         If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="cachePolicyId")
    def cache_policy_id(self) -> Optional[builtins.str]:
        """
        The unique identifier of the cache policy that is attached to this cache behavior. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         A ``CacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
        """
        return pulumi.get(self, "cache_policy_id")

    @property
    @pulumi.getter(name="cachedMethods")
    def cached_methods(self) -> Optional[Sequence[builtins.str]]:
        """
        A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods. There are two choices:
          +  CloudFront caches responses to ``GET`` and ``HEAD`` requests.
          +  CloudFront caches responses to ``GET``, ``HEAD``, and ``OPTIONS`` requests.
          
         If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
        """
        return pulumi.get(self, "cached_methods")

    @property
    @pulumi.getter
    def compress(self) -> Optional[builtins.bool]:
        """
        Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify true; if not, specify false. For more information, see [Serving Compressed Files](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[builtins.float]:
        """
        This field is deprecated. We recommend that you use the ``DefaultTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="fieldLevelEncryptionId")
    def field_level_encryption_id(self) -> Optional[builtins.str]:
        """
        The value of ``ID`` for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for this cache behavior.
        """
        return pulumi.get(self, "field_level_encryption_id")

    @property
    @pulumi.getter(name="forwardedValues")
    def forwarded_values(self) -> Optional['outputs.DistributionForwardedValues']:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see [Working with policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html) in the *Amazon CloudFront Developer Guide*.
         If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
         A ``CacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
         A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
        """
        return pulumi.get(self, "forwarded_values")

    @property
    @pulumi.getter(name="functionAssociations")
    def function_associations(self) -> Optional[Sequence['outputs.DistributionFunctionAssociation']]:
        """
        A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must be published to the ``LIVE`` stage to associate them with a cache behavior.
        """
        return pulumi.get(self, "function_associations")

    @property
    @pulumi.getter(name="grpcConfig")
    def grpc_config(self) -> Optional['outputs.DistributionGrpcConfig']:
        """
        The gRPC configuration for your cache behavior.
        """
        return pulumi.get(self, "grpc_config")

    @property
    @pulumi.getter(name="lambdaFunctionAssociations")
    def lambda_function_associations(self) -> Optional[Sequence['outputs.DistributionLambdaFunctionAssociation']]:
        """
        A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
        """
        return pulumi.get(self, "lambda_function_associations")

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[builtins.float]:
        """
        This field is deprecated. We recommend that you use the ``MaxTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter(name="minTtl")
    def min_ttl(self) -> Optional[builtins.float]:
        """
        This field is deprecated. We recommend that you use the ``MinTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
         You must specify ``0`` for ``MinTTL`` if you configure CloudFront to forward all headers to your origin (under ``Headers``, if you specify ``1`` for ``Quantity`` and ``*`` for ``Name``).
        """
        return pulumi.get(self, "min_ttl")

    @property
    @pulumi.getter(name="originRequestPolicyId")
    def origin_request_policy_id(self) -> Optional[builtins.str]:
        """
        The unique identifier of the origin request policy that is attached to this cache behavior. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_request_policy_id")

    @property
    @pulumi.getter(name="realtimeLogConfigArn")
    def realtime_log_config_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior. For more information, see [Real-time logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "realtime_log_config_arn")

    @property
    @pulumi.getter(name="responseHeadersPolicyId")
    def response_headers_policy_id(self) -> Optional[builtins.str]:
        """
        The identifier for a response headers policy.
        """
        return pulumi.get(self, "response_headers_policy_id")

    @property
    @pulumi.getter(name="smoothStreaming")
    def smooth_streaming(self) -> Optional[builtins.bool]:
        """
        Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior. If so, specify ``true``; if not, specify ``false``. If you specify ``true`` for ``SmoothStreaming``, you can still distribute other content using this cache behavior if the content matches the value of ``PathPattern``.
        """
        return pulumi.get(self, "smooth_streaming")

    @property
    @pulumi.getter(name="trustedKeyGroups")
    def trusted_key_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
         When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "trusted_key_groups")

    @property
    @pulumi.getter(name="trustedSigners")
    def trusted_signers(self) -> Optional[Sequence[builtins.str]]:
        """
        We recommend using ``TrustedKeyGroups`` instead of ``TrustedSigners``.
          A list of AWS-account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.
         When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in the trusted signer's AWS-account. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "trusted_signers")


@pulumi.output_type
class DistributionConfig(dict):
    """
    A distribution configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultCacheBehavior":
            suggest = "default_cache_behavior"
        elif key == "anycastIpListId":
            suggest = "anycast_ip_list_id"
        elif key == "cacheBehaviors":
            suggest = "cache_behaviors"
        elif key == "connectionMode":
            suggest = "connection_mode"
        elif key == "continuousDeploymentPolicyId":
            suggest = "continuous_deployment_policy_id"
        elif key == "customErrorResponses":
            suggest = "custom_error_responses"
        elif key == "customOrigin":
            suggest = "custom_origin"
        elif key == "defaultRootObject":
            suggest = "default_root_object"
        elif key == "httpVersion":
            suggest = "http_version"
        elif key == "ipv6Enabled":
            suggest = "ipv6_enabled"
        elif key == "originGroups":
            suggest = "origin_groups"
        elif key == "priceClass":
            suggest = "price_class"
        elif key == "s3Origin":
            suggest = "s3_origin"
        elif key == "tenantConfig":
            suggest = "tenant_config"
        elif key == "viewerCertificate":
            suggest = "viewer_certificate"
        elif key == "webAclId":
            suggest = "web_acl_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_cache_behavior: 'outputs.DistributionDefaultCacheBehavior',
                 enabled: builtins.bool,
                 aliases: Optional[Sequence[builtins.str]] = None,
                 anycast_ip_list_id: Optional[builtins.str] = None,
                 cache_behaviors: Optional[Sequence['outputs.DistributionCacheBehavior']] = None,
                 cnames: Optional[Sequence[builtins.str]] = None,
                 comment: Optional[builtins.str] = None,
                 connection_mode: Optional['DistributionConnectionMode'] = None,
                 continuous_deployment_policy_id: Optional[builtins.str] = None,
                 custom_error_responses: Optional[Sequence['outputs.DistributionCustomErrorResponse']] = None,
                 custom_origin: Optional['outputs.DistributionLegacyCustomOrigin'] = None,
                 default_root_object: Optional[builtins.str] = None,
                 http_version: Optional[builtins.str] = None,
                 ipv6_enabled: Optional[builtins.bool] = None,
                 logging: Optional['outputs.DistributionLogging'] = None,
                 origin_groups: Optional['outputs.DistributionOriginGroups'] = None,
                 origins: Optional[Sequence['outputs.DistributionOrigin']] = None,
                 price_class: Optional[builtins.str] = None,
                 restrictions: Optional['outputs.DistributionRestrictions'] = None,
                 s3_origin: Optional['outputs.DistributionLegacyS3Origin'] = None,
                 staging: Optional[builtins.bool] = None,
                 tenant_config: Optional['outputs.DistributionConfigTenantConfigProperties'] = None,
                 viewer_certificate: Optional['outputs.DistributionViewerCertificate'] = None,
                 web_acl_id: Optional[builtins.str] = None):
        """
        A distribution configuration.
        :param 'DistributionDefaultCacheBehavior' default_cache_behavior: A complex type that describes the default cache behavior if you don't specify a ``CacheBehavior`` element or if files don't match any of the values of ``PathPattern`` in ``CacheBehavior`` elements. You must create exactly one default cache behavior.
        :param builtins.bool enabled: From this field, you can enable or disable the selected distribution.
        :param Sequence[builtins.str] aliases: A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution.
        :param builtins.str anycast_ip_list_id: ID of the Anycast static IP list that is associated with the distribution.
        :param Sequence['DistributionCacheBehavior'] cache_behaviors: A complex type that contains zero or more ``CacheBehavior`` elements.
        :param Sequence[builtins.str] cnames: An alias for the CF distribution's domain name.
                 This property is legacy. We recommend that you use [Aliases](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-aliases) instead.
        :param builtins.str comment: A comment to describe the distribution. The comment cannot be longer than 128 characters.
        :param 'DistributionConnectionMode' connection_mode: The connection mode to filter distributions by.
        :param builtins.str continuous_deployment_policy_id: The identifier of a continuous deployment policy. For more information, see ``CreateContinuousDeploymentPolicy``.
        :param Sequence['DistributionCustomErrorResponse'] custom_error_responses: A complex type that controls the following:
                 +  Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.
                 +  How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
                 
                For more information about custom error pages, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
        :param 'DistributionLegacyCustomOrigin' custom_origin: The user-defined HTTP server that serves as the origin for content that CF distributes.
                 This property is legacy. We recommend that you use [Origin](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html) instead.
        :param builtins.str default_root_object: When a viewer requests the root URL for your distribution, the default root object is the object that you want CloudFront to request from your origin. For example, if your root URL is ``https://www.example.com``, you can specify CloudFront to return the ``index.html`` file as the default root object. You can specify a default root object so that viewers see a specific file or object, instead of another object in your distribution (for example, ``https://www.example.com/product-description.html``). A default root object avoids exposing the contents of your distribution.
                You can specify the object name or a path to the object name (for example, ``index.html`` or ``exampleFolderName/index.html``). Your string can't begin with a forward slash (``/``). Only specify the object name or the path to the object.
                If you don't want to specify a default root object when you create a distribution, include an empty ``DefaultRootObject`` element.
                To delete the default root object from an existing distribution, update the distribution configuration and include an empty ``DefaultRootObject`` element.
                To replace the default root object, update the distribution configuration and specify the new object.
                For more information about the default root object, see [Specify a default root object](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.str http_version: (Optional) Specify the HTTP version(s) that you want viewers to use to communicate with CF. The default value for new distributions is ``http1.1``.
                For viewers and CF to use HTTP/2, viewers must support TLSv1.2 or later, and must support Server Name Indication (SNI).
                For viewers and CF to use HTTP/3, viewers must support TLSv1.3 and Server Name Indication (SNI). CF supports HTTP/3 connection migration to allow the viewer to switch networks without losing connection. For more information about connection migration, see [Connection Migration](https://docs.aws.amazon.com/https://www.rfc-editor.org/rfc/rfc9000.html#name-connection-migration) at RFC 9000. For more information about supported TLSv1.3 ciphers, see [Supported protocols and ciphers between viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html).
        :param builtins.bool ipv6_enabled: If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution, specify ``true``. If you specify ``false``, CloudFront responds to IPv6 DNS requests with the DNS response code ``NOERROR`` and with no IP addresses. This allows viewers to submit a second request, for an IPv4 address for your distribution.
                In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content. However, if you're using signed URLs or signed cookies to restrict access to your content, and if you're using a custom policy that includes the ``IpAddress`` parameter to restrict the IP addresses that can access your content, don't enable IPv6. If you want to restrict access to some content by IP address and not restrict access to other content (or restrict access but not by IP address), you can create two distributions. For more information, see [Creating a Signed URL Using a Custom Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html) in the *Amazon CloudFront Developer Guide*.
                If you're using an R53AWSIntlong alias resource record set to route traffic to your CloudFront distribution, you need to create a second alias resource record set when both of the following are true:
                 +  You enable IPv6 for the distribution
                 +  You're using alternate domain names in the URLs for your objects
                 
                For more information, see [Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html) in the *Developer Guide*.
                If you created a CNAME resource record set, either with R53AWSIntlong or with another DNS service, you don't need to make any changes. A CNAME record will route traffic to your distribution regardless of the IP address format of the viewer request.
        :param 'DistributionLogging' logging: A complex type that controls whether access logs are written for the distribution.
                For more information about logging, see [Access Logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html) in the *Amazon CloudFront Developer Guide*.
        :param 'DistributionOriginGroups' origin_groups: A complex type that contains information about origin groups for this distribution.
                Specify a value for either the ``Origins`` or ``OriginGroups`` property.
        :param Sequence['DistributionOrigin'] origins: A complex type that contains information about origins for this distribution.
                Specify a value for either the ``Origins`` or ``OriginGroups`` property.
        :param builtins.str price_class: The price class that corresponds with the maximum price that you want to pay for CloudFront service. If you specify ``PriceClass_All``, CloudFront responds to requests for your objects from all CloudFront edge locations.
                If you specify a price class other than ``PriceClass_All``, CloudFront serves your objects from the CloudFront edge location that has the lowest latency among the edge locations in your price class. Viewers who are in or near regions that are excluded from your specified price class may encounter slower performance.
                For more information about price classes, see [Choosing the Price Class for a CloudFront Distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html) in the *Amazon CloudFront Developer Guide*. For information about CloudFront pricing, including how price classes (such as Price Class 100) map to CloudFront regions, see [Amazon CloudFront Pricing](https://docs.aws.amazon.com/cloudfront/pricing/).
        :param 'DistributionRestrictions' restrictions: A complex type that identifies ways in which you want to restrict distribution of your content.
        :param 'DistributionLegacyS3Origin' s3_origin: The origin as an S3 bucket.
                 This property is legacy. We recommend that you use [Origin](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html) instead.
        :param builtins.bool staging: A Boolean that indicates whether this is a staging distribution. When this value is ``true``, this is a staging distribution. When this value is ``false``, this is not a staging distribution.
        :param 'DistributionConfigTenantConfigProperties' tenant_config: A distribution tenant configuration.
        :param 'DistributionViewerCertificate' viewer_certificate: A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
        :param builtins.str web_acl_id: A unique identifier that specifies the WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of WAF, use the ACL ARN, for example ``arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111``. To specify a web ACL created using WAF Classic, use the ACL ID, for example ``a1b2c3d4-5678-90ab-cdef-EXAMPLE11111``.
                WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to CloudFront, and lets you control access to your content. Based on conditions that you specify, such as the IP addresses that requests originate from or the values of query strings, CloudFront responds to requests either with the requested content or with an HTTP 403 status code (Forbidden). You can also configure CloudFront to return a custom error page when a request is blocked. For more information about WAF, see the [Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html).
        """
        pulumi.set(__self__, "default_cache_behavior", default_cache_behavior)
        pulumi.set(__self__, "enabled", enabled)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if anycast_ip_list_id is not None:
            pulumi.set(__self__, "anycast_ip_list_id", anycast_ip_list_id)
        if cache_behaviors is not None:
            pulumi.set(__self__, "cache_behaviors", cache_behaviors)
        if cnames is not None:
            pulumi.set(__self__, "cnames", cnames)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if connection_mode is not None:
            pulumi.set(__self__, "connection_mode", connection_mode)
        if continuous_deployment_policy_id is not None:
            pulumi.set(__self__, "continuous_deployment_policy_id", continuous_deployment_policy_id)
        if custom_error_responses is not None:
            pulumi.set(__self__, "custom_error_responses", custom_error_responses)
        if custom_origin is not None:
            pulumi.set(__self__, "custom_origin", custom_origin)
        if default_root_object is not None:
            pulumi.set(__self__, "default_root_object", default_root_object)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if ipv6_enabled is not None:
            pulumi.set(__self__, "ipv6_enabled", ipv6_enabled)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if origin_groups is not None:
            pulumi.set(__self__, "origin_groups", origin_groups)
        if origins is not None:
            pulumi.set(__self__, "origins", origins)
        if price_class is not None:
            pulumi.set(__self__, "price_class", price_class)
        if restrictions is not None:
            pulumi.set(__self__, "restrictions", restrictions)
        if s3_origin is not None:
            pulumi.set(__self__, "s3_origin", s3_origin)
        if staging is not None:
            pulumi.set(__self__, "staging", staging)
        if tenant_config is not None:
            pulumi.set(__self__, "tenant_config", tenant_config)
        if viewer_certificate is not None:
            pulumi.set(__self__, "viewer_certificate", viewer_certificate)
        if web_acl_id is not None:
            pulumi.set(__self__, "web_acl_id", web_acl_id)

    @property
    @pulumi.getter(name="defaultCacheBehavior")
    def default_cache_behavior(self) -> 'outputs.DistributionDefaultCacheBehavior':
        """
        A complex type that describes the default cache behavior if you don't specify a ``CacheBehavior`` element or if files don't match any of the values of ``PathPattern`` in ``CacheBehavior`` elements. You must create exactly one default cache behavior.
        """
        return pulumi.get(self, "default_cache_behavior")

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        From this field, you can enable or disable the selected distribution.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def aliases(self) -> Optional[Sequence[builtins.str]]:
        """
        A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution.
        """
        return pulumi.get(self, "aliases")

    @property
    @pulumi.getter(name="anycastIpListId")
    def anycast_ip_list_id(self) -> Optional[builtins.str]:
        """
        ID of the Anycast static IP list that is associated with the distribution.
        """
        return pulumi.get(self, "anycast_ip_list_id")

    @property
    @pulumi.getter(name="cacheBehaviors")
    def cache_behaviors(self) -> Optional[Sequence['outputs.DistributionCacheBehavior']]:
        """
        A complex type that contains zero or more ``CacheBehavior`` elements.
        """
        return pulumi.get(self, "cache_behaviors")

    @property
    @pulumi.getter
    def cnames(self) -> Optional[Sequence[builtins.str]]:
        """
        An alias for the CF distribution's domain name.
          This property is legacy. We recommend that you use [Aliases](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-aliases) instead.
        """
        return pulumi.get(self, "cnames")

    @property
    @pulumi.getter
    def comment(self) -> Optional[builtins.str]:
        """
        A comment to describe the distribution. The comment cannot be longer than 128 characters.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="connectionMode")
    def connection_mode(self) -> Optional['DistributionConnectionMode']:
        """
        The connection mode to filter distributions by.
        """
        return pulumi.get(self, "connection_mode")

    @property
    @pulumi.getter(name="continuousDeploymentPolicyId")
    def continuous_deployment_policy_id(self) -> Optional[builtins.str]:
        """
        The identifier of a continuous deployment policy. For more information, see ``CreateContinuousDeploymentPolicy``.
        """
        return pulumi.get(self, "continuous_deployment_policy_id")

    @property
    @pulumi.getter(name="customErrorResponses")
    def custom_error_responses(self) -> Optional[Sequence['outputs.DistributionCustomErrorResponse']]:
        """
        A complex type that controls the following:
          +  Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.
          +  How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
          
         For more information about custom error pages, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "custom_error_responses")

    @property
    @pulumi.getter(name="customOrigin")
    def custom_origin(self) -> Optional['outputs.DistributionLegacyCustomOrigin']:
        """
        The user-defined HTTP server that serves as the origin for content that CF distributes.
          This property is legacy. We recommend that you use [Origin](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html) instead.
        """
        return pulumi.get(self, "custom_origin")

    @property
    @pulumi.getter(name="defaultRootObject")
    def default_root_object(self) -> Optional[builtins.str]:
        """
        When a viewer requests the root URL for your distribution, the default root object is the object that you want CloudFront to request from your origin. For example, if your root URL is ``https://www.example.com``, you can specify CloudFront to return the ``index.html`` file as the default root object. You can specify a default root object so that viewers see a specific file or object, instead of another object in your distribution (for example, ``https://www.example.com/product-description.html``). A default root object avoids exposing the contents of your distribution.
         You can specify the object name or a path to the object name (for example, ``index.html`` or ``exampleFolderName/index.html``). Your string can't begin with a forward slash (``/``). Only specify the object name or the path to the object.
         If you don't want to specify a default root object when you create a distribution, include an empty ``DefaultRootObject`` element.
         To delete the default root object from an existing distribution, update the distribution configuration and include an empty ``DefaultRootObject`` element.
         To replace the default root object, update the distribution configuration and specify the new object.
         For more information about the default root object, see [Specify a default root object](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "default_root_object")

    @property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[builtins.str]:
        """
        (Optional) Specify the HTTP version(s) that you want viewers to use to communicate with CF. The default value for new distributions is ``http1.1``.
         For viewers and CF to use HTTP/2, viewers must support TLSv1.2 or later, and must support Server Name Indication (SNI).
         For viewers and CF to use HTTP/3, viewers must support TLSv1.3 and Server Name Indication (SNI). CF supports HTTP/3 connection migration to allow the viewer to switch networks without losing connection. For more information about connection migration, see [Connection Migration](https://docs.aws.amazon.com/https://www.rfc-editor.org/rfc/rfc9000.html#name-connection-migration) at RFC 9000. For more information about supported TLSv1.3 ciphers, see [Supported protocols and ciphers between viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html).
        """
        return pulumi.get(self, "http_version")

    @property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> Optional[builtins.bool]:
        """
        If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution, specify ``true``. If you specify ``false``, CloudFront responds to IPv6 DNS requests with the DNS response code ``NOERROR`` and with no IP addresses. This allows viewers to submit a second request, for an IPv4 address for your distribution.
         In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content. However, if you're using signed URLs or signed cookies to restrict access to your content, and if you're using a custom policy that includes the ``IpAddress`` parameter to restrict the IP addresses that can access your content, don't enable IPv6. If you want to restrict access to some content by IP address and not restrict access to other content (or restrict access but not by IP address), you can create two distributions. For more information, see [Creating a Signed URL Using a Custom Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html) in the *Amazon CloudFront Developer Guide*.
         If you're using an R53AWSIntlong alias resource record set to route traffic to your CloudFront distribution, you need to create a second alias resource record set when both of the following are true:
          +  You enable IPv6 for the distribution
          +  You're using alternate domain names in the URLs for your objects
          
         For more information, see [Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html) in the *Developer Guide*.
         If you created a CNAME resource record set, either with R53AWSIntlong or with another DNS service, you don't need to make any changes. A CNAME record will route traffic to your distribution regardless of the IP address format of the viewer request.
        """
        return pulumi.get(self, "ipv6_enabled")

    @property
    @pulumi.getter
    def logging(self) -> Optional['outputs.DistributionLogging']:
        """
        A complex type that controls whether access logs are written for the distribution.
         For more information about logging, see [Access Logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter(name="originGroups")
    def origin_groups(self) -> Optional['outputs.DistributionOriginGroups']:
        """
        A complex type that contains information about origin groups for this distribution.
         Specify a value for either the ``Origins`` or ``OriginGroups`` property.
        """
        return pulumi.get(self, "origin_groups")

    @property
    @pulumi.getter
    def origins(self) -> Optional[Sequence['outputs.DistributionOrigin']]:
        """
        A complex type that contains information about origins for this distribution.
         Specify a value for either the ``Origins`` or ``OriginGroups`` property.
        """
        return pulumi.get(self, "origins")

    @property
    @pulumi.getter(name="priceClass")
    def price_class(self) -> Optional[builtins.str]:
        """
        The price class that corresponds with the maximum price that you want to pay for CloudFront service. If you specify ``PriceClass_All``, CloudFront responds to requests for your objects from all CloudFront edge locations.
         If you specify a price class other than ``PriceClass_All``, CloudFront serves your objects from the CloudFront edge location that has the lowest latency among the edge locations in your price class. Viewers who are in or near regions that are excluded from your specified price class may encounter slower performance.
         For more information about price classes, see [Choosing the Price Class for a CloudFront Distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html) in the *Amazon CloudFront Developer Guide*. For information about CloudFront pricing, including how price classes (such as Price Class 100) map to CloudFront regions, see [Amazon CloudFront Pricing](https://docs.aws.amazon.com/cloudfront/pricing/).
        """
        return pulumi.get(self, "price_class")

    @property
    @pulumi.getter
    def restrictions(self) -> Optional['outputs.DistributionRestrictions']:
        """
        A complex type that identifies ways in which you want to restrict distribution of your content.
        """
        return pulumi.get(self, "restrictions")

    @property
    @pulumi.getter(name="s3Origin")
    def s3_origin(self) -> Optional['outputs.DistributionLegacyS3Origin']:
        """
        The origin as an S3 bucket.
          This property is legacy. We recommend that you use [Origin](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html) instead.
        """
        return pulumi.get(self, "s3_origin")

    @property
    @pulumi.getter
    def staging(self) -> Optional[builtins.bool]:
        """
        A Boolean that indicates whether this is a staging distribution. When this value is ``true``, this is a staging distribution. When this value is ``false``, this is not a staging distribution.
        """
        return pulumi.get(self, "staging")

    @property
    @pulumi.getter(name="tenantConfig")
    def tenant_config(self) -> Optional['outputs.DistributionConfigTenantConfigProperties']:
        """
        A distribution tenant configuration.
        """
        return pulumi.get(self, "tenant_config")

    @property
    @pulumi.getter(name="viewerCertificate")
    def viewer_certificate(self) -> Optional['outputs.DistributionViewerCertificate']:
        """
        A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
        """
        return pulumi.get(self, "viewer_certificate")

    @property
    @pulumi.getter(name="webAclId")
    def web_acl_id(self) -> Optional[builtins.str]:
        """
        A unique identifier that specifies the WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of WAF, use the ACL ARN, for example ``arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111``. To specify a web ACL created using WAF Classic, use the ACL ID, for example ``a1b2c3d4-5678-90ab-cdef-EXAMPLE11111``.
         WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to CloudFront, and lets you control access to your content. Based on conditions that you specify, such as the IP addresses that requests originate from or the values of query strings, CloudFront responds to requests either with the requested content or with an HTTP 403 status code (Forbidden). You can also configure CloudFront to return a custom error page when a request is blocked. For more information about WAF, see the [Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html).
        """
        return pulumi.get(self, "web_acl_id")


@pulumi.output_type
class DistributionConfigTenantConfigProperties(dict):
    """
    A distribution tenant configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterDefinitions":
            suggest = "parameter_definitions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfigTenantConfigProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfigTenantConfigProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfigTenantConfigProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameter_definitions: Optional[Sequence['outputs.DistributionParameterDefinition']] = None):
        """
        A distribution tenant configuration.
        """
        if parameter_definitions is not None:
            pulumi.set(__self__, "parameter_definitions", parameter_definitions)

    @property
    @pulumi.getter(name="parameterDefinitions")
    def parameter_definitions(self) -> Optional[Sequence['outputs.DistributionParameterDefinition']]:
        return pulumi.get(self, "parameter_definitions")


@pulumi.output_type
class DistributionCookies(dict):
    """
    This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
     If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
     If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
     A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones. For more information about forwarding cookies to the origin, see [How CloudFront Forwards, Caches, and Logs Cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html) in the *Amazon CloudFront Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "whitelistedNames":
            suggest = "whitelisted_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCookies. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCookies.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCookies.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 forward: builtins.str,
                 whitelisted_names: Optional[Sequence[builtins.str]] = None):
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones. For more information about forwarding cookies to the origin, see [How CloudFront Forwards, Caches, and Logs Cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.str forward: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
                If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
                If you want to send cookies to the origin but not include them in the cache key, use origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
                Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of cookies specified in the ``WhitelistedNames`` complex type.
                Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3 origin, specify none for the ``Forward`` element.
        :param Sequence[builtins.str] whitelisted_names: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
                If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
                If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
                Required if you specify ``whitelist`` for the value of ``Forward``. A complex type that specifies how many different cookies you want CloudFront to forward to the origin for this cache behavior and, if you want to forward selected cookies, the names of those cookies.
                If you specify ``all`` or ``none`` for the value of ``Forward``, omit ``WhitelistedNames``. If you change the value of ``Forward`` from ``whitelist`` to ``all`` or ``none`` and you don't delete the ``WhitelistedNames`` element and its child elements, CloudFront deletes them automatically.
                For the current limit on the number of cookie names that you can whitelist for each cache behavior, see [CloudFront Limits](https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront) in the *General Reference*.
        """
        pulumi.set(__self__, "forward", forward)
        if whitelisted_names is not None:
            pulumi.set(__self__, "whitelisted_names", whitelisted_names)

    @property
    @pulumi.getter
    def forward(self) -> builtins.str:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send cookies to the origin but not include them in the cache key, use origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of cookies specified in the ``WhitelistedNames`` complex type.
         Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3 origin, specify none for the ``Forward`` element.
        """
        return pulumi.get(self, "forward")

    @property
    @pulumi.getter(name="whitelistedNames")
    def whitelisted_names(self) -> Optional[Sequence[builtins.str]]:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         Required if you specify ``whitelist`` for the value of ``Forward``. A complex type that specifies how many different cookies you want CloudFront to forward to the origin for this cache behavior and, if you want to forward selected cookies, the names of those cookies.
         If you specify ``all`` or ``none`` for the value of ``Forward``, omit ``WhitelistedNames``. If you change the value of ``Forward`` from ``whitelist`` to ``all`` or ``none`` and you don't delete the ``WhitelistedNames`` element and its child elements, CloudFront deletes them automatically.
         For the current limit on the number of cookie names that you can whitelist for each cache behavior, see [CloudFront Limits](https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront) in the *General Reference*.
        """
        return pulumi.get(self, "whitelisted_names")


@pulumi.output_type
class DistributionCustomErrorResponse(dict):
    """
    A complex type that controls:
      +  Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.
      +  How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
      
     For more information about custom error pages, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "errorCachingMinTtl":
            suggest = "error_caching_min_ttl"
        elif key == "responseCode":
            suggest = "response_code"
        elif key == "responsePagePath":
            suggest = "response_page_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCustomErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCustomErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCustomErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: builtins.int,
                 error_caching_min_ttl: Optional[builtins.float] = None,
                 response_code: Optional[builtins.int] = None,
                 response_page_path: Optional[builtins.str] = None):
        """
        A complex type that controls:
          +  Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.
          +  How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
          
         For more information about custom error pages, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.int error_code: The HTTP status code for which you want to specify a custom error page and/or a caching duration.
        :param builtins.float error_caching_min_ttl: The minimum amount of time, in seconds, that you want CloudFront to cache the HTTP status code specified in ``ErrorCode``. When this time period has elapsed, CloudFront queries your origin to see whether the problem that caused the error has been resolved and the requested object is now available.
                For more information, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.int response_code: The HTTP status code that you want CloudFront to return to the viewer along with the custom error page. There are a variety of reasons that you might want CloudFront to return a status code different from the status code that your origin returned to CloudFront, for example:
                 +  Some Internet devices (some firewalls and corporate proxies, for example) intercept HTTP 4xx and 5xx and prevent the response from being returned to the viewer. If you substitute ``200``, the response typically won't be intercepted.
                 +  If you don't care about distinguishing among different client errors or server errors, you can specify ``400`` or ``500`` as the ``ResponseCode`` for all 4xx or 5xx errors.
                 +  You might want to return a ``200`` status code (OK) and static website so your customers don't know that your website is down.
                 
                If you specify a value for ``ResponseCode``, you must also specify a value for ``ResponsePagePath``.
        :param builtins.str response_page_path: The path to the custom error page that you want CloudFront to return to a viewer when your origin returns the HTTP status code specified by ``ErrorCode``, for example, ``/4xx-errors/403-forbidden.html``. If you want to store your objects and your custom error pages in different locations, your distribution must include a cache behavior for which the following is true:
                 +  The value of ``PathPattern`` matches the path to your custom error messages. For example, suppose you saved custom error pages for 4xx errors in an Amazon S3 bucket in a directory named ``/4xx-errors``. Your distribution must include a cache behavior for which the path pattern routes requests for your custom error pages to that location, for example, ``/4xx-errors/*``.
                 +  The value of ``TargetOriginId`` specifies the value of the ``ID`` element for the origin that contains your custom error pages.
                 
                If you specify a value for ``ResponsePagePath``, you must also specify a value for ``ResponseCode``.
                We recommend that you store custom error pages in an Amazon S3 bucket. If you store custom error pages on an HTTP server and the server starts to return 5xx errors, CloudFront can't get the files that you want to return to viewers because the origin server is unavailable.
        """
        pulumi.set(__self__, "error_code", error_code)
        if error_caching_min_ttl is not None:
            pulumi.set(__self__, "error_caching_min_ttl", error_caching_min_ttl)
        if response_code is not None:
            pulumi.set(__self__, "response_code", response_code)
        if response_page_path is not None:
            pulumi.set(__self__, "response_page_path", response_page_path)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> builtins.int:
        """
        The HTTP status code for which you want to specify a custom error page and/or a caching duration.
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorCachingMinTtl")
    def error_caching_min_ttl(self) -> Optional[builtins.float]:
        """
        The minimum amount of time, in seconds, that you want CloudFront to cache the HTTP status code specified in ``ErrorCode``. When this time period has elapsed, CloudFront queries your origin to see whether the problem that caused the error has been resolved and the requested object is now available.
         For more information, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "error_caching_min_ttl")

    @property
    @pulumi.getter(name="responseCode")
    def response_code(self) -> Optional[builtins.int]:
        """
        The HTTP status code that you want CloudFront to return to the viewer along with the custom error page. There are a variety of reasons that you might want CloudFront to return a status code different from the status code that your origin returned to CloudFront, for example:
          +  Some Internet devices (some firewalls and corporate proxies, for example) intercept HTTP 4xx and 5xx and prevent the response from being returned to the viewer. If you substitute ``200``, the response typically won't be intercepted.
          +  If you don't care about distinguishing among different client errors or server errors, you can specify ``400`` or ``500`` as the ``ResponseCode`` for all 4xx or 5xx errors.
          +  You might want to return a ``200`` status code (OK) and static website so your customers don't know that your website is down.
          
         If you specify a value for ``ResponseCode``, you must also specify a value for ``ResponsePagePath``.
        """
        return pulumi.get(self, "response_code")

    @property
    @pulumi.getter(name="responsePagePath")
    def response_page_path(self) -> Optional[builtins.str]:
        """
        The path to the custom error page that you want CloudFront to return to a viewer when your origin returns the HTTP status code specified by ``ErrorCode``, for example, ``/4xx-errors/403-forbidden.html``. If you want to store your objects and your custom error pages in different locations, your distribution must include a cache behavior for which the following is true:
          +  The value of ``PathPattern`` matches the path to your custom error messages. For example, suppose you saved custom error pages for 4xx errors in an Amazon S3 bucket in a directory named ``/4xx-errors``. Your distribution must include a cache behavior for which the path pattern routes requests for your custom error pages to that location, for example, ``/4xx-errors/*``.
          +  The value of ``TargetOriginId`` specifies the value of the ``ID`` element for the origin that contains your custom error pages.
          
         If you specify a value for ``ResponsePagePath``, you must also specify a value for ``ResponseCode``.
         We recommend that you store custom error pages in an Amazon S3 bucket. If you store custom error pages on an HTTP server and the server starts to return 5xx errors, CloudFront can't get the files that you want to return to viewers because the origin server is unavailable.
        """
        return pulumi.get(self, "response_page_path")


@pulumi.output_type
class DistributionCustomOriginConfig(dict):
    """
    A custom origin. A custom origin is any origin that is *not* an Amazon S3 bucket, with one exception. An Amazon S3 bucket that is [configured with static website hosting](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html)*is* a custom origin.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "originProtocolPolicy":
            suggest = "origin_protocol_policy"
        elif key == "httpPort":
            suggest = "http_port"
        elif key == "httpsPort":
            suggest = "https_port"
        elif key == "originKeepaliveTimeout":
            suggest = "origin_keepalive_timeout"
        elif key == "originReadTimeout":
            suggest = "origin_read_timeout"
        elif key == "originSslProtocols":
            suggest = "origin_ssl_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCustomOriginConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCustomOriginConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCustomOriginConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 origin_protocol_policy: builtins.str,
                 http_port: Optional[builtins.int] = None,
                 https_port: Optional[builtins.int] = None,
                 origin_keepalive_timeout: Optional[builtins.int] = None,
                 origin_read_timeout: Optional[builtins.int] = None,
                 origin_ssl_protocols: Optional[Sequence[builtins.str]] = None):
        """
        A custom origin. A custom origin is any origin that is *not* an Amazon S3 bucket, with one exception. An Amazon S3 bucket that is [configured with static website hosting](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html)*is* a custom origin.
        :param builtins.str origin_protocol_policy: Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. Valid values are:
                 +  ``http-only`` – CloudFront always uses HTTP to connect to the origin.
                 +  ``match-viewer`` – CloudFront connects to the origin using the same protocol that the viewer used to connect to CloudFront.
                 +  ``https-only`` – CloudFront always uses HTTPS to connect to the origin.
        :param builtins.int http_port: The HTTP port that CloudFront uses to connect to the origin. Specify the HTTP port that the origin listens on.
        :param builtins.int https_port: The HTTPS port that CloudFront uses to connect to the origin. Specify the HTTPS port that the origin listens on.
        :param builtins.int origin_keepalive_timeout: Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 5 seconds.
                For more information, see [Keep-alive timeout (custom origins only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout) in the *Amazon CloudFront Developer Guide*.
        :param builtins.int origin_read_timeout: Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as the *origin response timeout*. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 30 seconds.
                For more information, see [Response timeout (custom origins only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout) in the *Amazon CloudFront Developer Guide*.
        :param Sequence[builtins.str] origin_ssl_protocols: Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS. Valid values include ``SSLv3``, ``TLSv1``, ``TLSv1.1``, and ``TLSv1.2``.
                For more information, see [Minimum Origin SSL Protocol](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols) in the *Amazon CloudFront Developer Guide*.
        """
        pulumi.set(__self__, "origin_protocol_policy", origin_protocol_policy)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if https_port is not None:
            pulumi.set(__self__, "https_port", https_port)
        if origin_keepalive_timeout is not None:
            pulumi.set(__self__, "origin_keepalive_timeout", origin_keepalive_timeout)
        if origin_read_timeout is not None:
            pulumi.set(__self__, "origin_read_timeout", origin_read_timeout)
        if origin_ssl_protocols is not None:
            pulumi.set(__self__, "origin_ssl_protocols", origin_ssl_protocols)

    @property
    @pulumi.getter(name="originProtocolPolicy")
    def origin_protocol_policy(self) -> builtins.str:
        """
        Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. Valid values are:
          +  ``http-only`` – CloudFront always uses HTTP to connect to the origin.
          +  ``match-viewer`` – CloudFront connects to the origin using the same protocol that the viewer used to connect to CloudFront.
          +  ``https-only`` – CloudFront always uses HTTPS to connect to the origin.
        """
        return pulumi.get(self, "origin_protocol_policy")

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[builtins.int]:
        """
        The HTTP port that CloudFront uses to connect to the origin. Specify the HTTP port that the origin listens on.
        """
        return pulumi.get(self, "http_port")

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> Optional[builtins.int]:
        """
        The HTTPS port that CloudFront uses to connect to the origin. Specify the HTTPS port that the origin listens on.
        """
        return pulumi.get(self, "https_port")

    @property
    @pulumi.getter(name="originKeepaliveTimeout")
    def origin_keepalive_timeout(self) -> Optional[builtins.int]:
        """
        Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 5 seconds.
         For more information, see [Keep-alive timeout (custom origins only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_keepalive_timeout")

    @property
    @pulumi.getter(name="originReadTimeout")
    def origin_read_timeout(self) -> Optional[builtins.int]:
        """
        Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as the *origin response timeout*. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 30 seconds.
         For more information, see [Response timeout (custom origins only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_read_timeout")

    @property
    @pulumi.getter(name="originSslProtocols")
    def origin_ssl_protocols(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS. Valid values include ``SSLv3``, ``TLSv1``, ``TLSv1.1``, and ``TLSv1.2``.
         For more information, see [Minimum Origin SSL Protocol](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_ssl_protocols")


@pulumi.output_type
class DistributionDefaultCacheBehavior(dict):
    """
    A complex type that describes the default cache behavior if you don't specify a ``CacheBehavior`` element or if request URLs don't match any of the values of ``PathPattern`` in ``CacheBehavior`` elements. You must create exactly one default cache behavior.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetOriginId":
            suggest = "target_origin_id"
        elif key == "viewerProtocolPolicy":
            suggest = "viewer_protocol_policy"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "cachePolicyId":
            suggest = "cache_policy_id"
        elif key == "cachedMethods":
            suggest = "cached_methods"
        elif key == "defaultTtl":
            suggest = "default_ttl"
        elif key == "fieldLevelEncryptionId":
            suggest = "field_level_encryption_id"
        elif key == "forwardedValues":
            suggest = "forwarded_values"
        elif key == "functionAssociations":
            suggest = "function_associations"
        elif key == "grpcConfig":
            suggest = "grpc_config"
        elif key == "lambdaFunctionAssociations":
            suggest = "lambda_function_associations"
        elif key == "maxTtl":
            suggest = "max_ttl"
        elif key == "minTtl":
            suggest = "min_ttl"
        elif key == "originRequestPolicyId":
            suggest = "origin_request_policy_id"
        elif key == "realtimeLogConfigArn":
            suggest = "realtime_log_config_arn"
        elif key == "responseHeadersPolicyId":
            suggest = "response_headers_policy_id"
        elif key == "smoothStreaming":
            suggest = "smooth_streaming"
        elif key == "trustedKeyGroups":
            suggest = "trusted_key_groups"
        elif key == "trustedSigners":
            suggest = "trusted_signers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionDefaultCacheBehavior. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionDefaultCacheBehavior.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionDefaultCacheBehavior.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_origin_id: builtins.str,
                 viewer_protocol_policy: builtins.str,
                 allowed_methods: Optional[Sequence[builtins.str]] = None,
                 cache_policy_id: Optional[builtins.str] = None,
                 cached_methods: Optional[Sequence[builtins.str]] = None,
                 compress: Optional[builtins.bool] = None,
                 default_ttl: Optional[builtins.float] = None,
                 field_level_encryption_id: Optional[builtins.str] = None,
                 forwarded_values: Optional['outputs.DistributionForwardedValues'] = None,
                 function_associations: Optional[Sequence['outputs.DistributionFunctionAssociation']] = None,
                 grpc_config: Optional['outputs.DistributionGrpcConfig'] = None,
                 lambda_function_associations: Optional[Sequence['outputs.DistributionLambdaFunctionAssociation']] = None,
                 max_ttl: Optional[builtins.float] = None,
                 min_ttl: Optional[builtins.float] = None,
                 origin_request_policy_id: Optional[builtins.str] = None,
                 realtime_log_config_arn: Optional[builtins.str] = None,
                 response_headers_policy_id: Optional[builtins.str] = None,
                 smooth_streaming: Optional[builtins.bool] = None,
                 trusted_key_groups: Optional[Sequence[builtins.str]] = None,
                 trusted_signers: Optional[Sequence[builtins.str]] = None):
        """
        A complex type that describes the default cache behavior if you don't specify a ``CacheBehavior`` element or if request URLs don't match any of the values of ``PathPattern`` in ``CacheBehavior`` elements. You must create exactly one default cache behavior.
        :param builtins.str target_origin_id: The value of ``ID`` for the origin that you want CloudFront to route requests to when they use the default cache behavior.
        :param builtins.str viewer_protocol_policy: The protocol that viewers can use to access the files in the origin specified by ``TargetOriginId`` when a request matches the path pattern in ``PathPattern``. You can specify the following options:
                 +  ``allow-all``: Viewers can use HTTP or HTTPS.
                 +  ``redirect-to-https``: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.
                 +  ``https-only``: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).
                 
                For more information about requiring the HTTPS protocol, see [Requiring HTTPS Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html) in the *Amazon CloudFront Developer Guide*.
                 The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see [Managing Cache Expiration](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        :param Sequence[builtins.str] allowed_methods: A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin. There are three choices:
                 +  CloudFront forwards only ``GET`` and ``HEAD`` requests.
                 +  CloudFront forwards only ``GET``, ``HEAD``, and ``OPTIONS`` requests.
                 +  CloudFront forwards ``GET, HEAD, OPTIONS, PUT, PATCH, POST``, and ``DELETE`` requests.
                 
                If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
        :param builtins.str cache_policy_id: The unique identifier of the cache policy that is attached to the default cache behavior. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                A ``DefaultCacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
        :param Sequence[builtins.str] cached_methods: A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods. There are two choices:
                 +  CloudFront caches responses to ``GET`` and ``HEAD`` requests.
                 +  CloudFront caches responses to ``GET``, ``HEAD``, and ``OPTIONS`` requests.
                 
                If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
        :param builtins.bool compress: Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify ``true``; if not, specify ``false``. For more information, see [Serving Compressed Files](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.float default_ttl: This field is deprecated. We recommend that you use the ``DefaultTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.str field_level_encryption_id: The value of ``ID`` for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for the default cache behavior.
        :param 'DistributionForwardedValues' forwarded_values: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see [Working with policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html) in the *Amazon CloudFront Developer Guide*.
                If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
                A ``DefaultCacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
                A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
        :param Sequence['DistributionFunctionAssociation'] function_associations: A list of CloudFront functions that are associated with this cache behavior. Your functions must be published to the ``LIVE`` stage to associate them with a cache behavior.
        :param 'DistributionGrpcConfig' grpc_config: The gRPC configuration for your cache behavior.
        :param Sequence['DistributionLambdaFunctionAssociation'] lambda_function_associations: A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
        :param builtins.float max_ttl: This field is deprecated. We recommend that you use the ``MaxTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.float min_ttl: This field is deprecated. We recommend that you use the ``MinTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
                You must specify ``0`` for ``MinTTL`` if you configure CloudFront to forward all headers to your origin (under ``Headers``, if you specify ``1`` for ``Quantity`` and ``*`` for ``Name``).
        :param builtins.str origin_request_policy_id: The unique identifier of the origin request policy that is attached to the default cache behavior. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.str realtime_log_config_arn: The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior. For more information, see [Real-time logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.str response_headers_policy_id: The identifier for a response headers policy.
        :param builtins.bool smooth_streaming: Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior. If so, specify ``true``; if not, specify ``false``. If you specify ``true`` for ``SmoothStreaming``, you can still distribute other content using this cache behavior if the content matches the value of ``PathPattern``.
        :param Sequence[builtins.str] trusted_key_groups: A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
                When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        :param Sequence[builtins.str] trusted_signers: We recommend using ``TrustedKeyGroups`` instead of ``TrustedSigners``.
                 A list of AWS-account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.
                When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in a trusted signer's AWS-account. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        pulumi.set(__self__, "target_origin_id", target_origin_id)
        pulumi.set(__self__, "viewer_protocol_policy", viewer_protocol_policy)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if cache_policy_id is not None:
            pulumi.set(__self__, "cache_policy_id", cache_policy_id)
        if cached_methods is not None:
            pulumi.set(__self__, "cached_methods", cached_methods)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if field_level_encryption_id is not None:
            pulumi.set(__self__, "field_level_encryption_id", field_level_encryption_id)
        if forwarded_values is not None:
            pulumi.set(__self__, "forwarded_values", forwarded_values)
        if function_associations is not None:
            pulumi.set(__self__, "function_associations", function_associations)
        if grpc_config is not None:
            pulumi.set(__self__, "grpc_config", grpc_config)
        if lambda_function_associations is not None:
            pulumi.set(__self__, "lambda_function_associations", lambda_function_associations)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if min_ttl is not None:
            pulumi.set(__self__, "min_ttl", min_ttl)
        if origin_request_policy_id is not None:
            pulumi.set(__self__, "origin_request_policy_id", origin_request_policy_id)
        if realtime_log_config_arn is not None:
            pulumi.set(__self__, "realtime_log_config_arn", realtime_log_config_arn)
        if response_headers_policy_id is not None:
            pulumi.set(__self__, "response_headers_policy_id", response_headers_policy_id)
        if smooth_streaming is not None:
            pulumi.set(__self__, "smooth_streaming", smooth_streaming)
        if trusted_key_groups is not None:
            pulumi.set(__self__, "trusted_key_groups", trusted_key_groups)
        if trusted_signers is not None:
            pulumi.set(__self__, "trusted_signers", trusted_signers)

    @property
    @pulumi.getter(name="targetOriginId")
    def target_origin_id(self) -> builtins.str:
        """
        The value of ``ID`` for the origin that you want CloudFront to route requests to when they use the default cache behavior.
        """
        return pulumi.get(self, "target_origin_id")

    @property
    @pulumi.getter(name="viewerProtocolPolicy")
    def viewer_protocol_policy(self) -> builtins.str:
        """
        The protocol that viewers can use to access the files in the origin specified by ``TargetOriginId`` when a request matches the path pattern in ``PathPattern``. You can specify the following options:
          +  ``allow-all``: Viewers can use HTTP or HTTPS.
          +  ``redirect-to-https``: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.
          +  ``https-only``: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).
          
         For more information about requiring the HTTPS protocol, see [Requiring HTTPS Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html) in the *Amazon CloudFront Developer Guide*.
          The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see [Managing Cache Expiration](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "viewer_protocol_policy")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[Sequence[builtins.str]]:
        """
        A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin. There are three choices:
          +  CloudFront forwards only ``GET`` and ``HEAD`` requests.
          +  CloudFront forwards only ``GET``, ``HEAD``, and ``OPTIONS`` requests.
          +  CloudFront forwards ``GET, HEAD, OPTIONS, PUT, PATCH, POST``, and ``DELETE`` requests.
          
         If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="cachePolicyId")
    def cache_policy_id(self) -> Optional[builtins.str]:
        """
        The unique identifier of the cache policy that is attached to the default cache behavior. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         A ``DefaultCacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
        """
        return pulumi.get(self, "cache_policy_id")

    @property
    @pulumi.getter(name="cachedMethods")
    def cached_methods(self) -> Optional[Sequence[builtins.str]]:
        """
        A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods. There are two choices:
          +  CloudFront caches responses to ``GET`` and ``HEAD`` requests.
          +  CloudFront caches responses to ``GET``, ``HEAD``, and ``OPTIONS`` requests.
          
         If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
        """
        return pulumi.get(self, "cached_methods")

    @property
    @pulumi.getter
    def compress(self) -> Optional[builtins.bool]:
        """
        Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify ``true``; if not, specify ``false``. For more information, see [Serving Compressed Files](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[builtins.float]:
        """
        This field is deprecated. We recommend that you use the ``DefaultTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="fieldLevelEncryptionId")
    def field_level_encryption_id(self) -> Optional[builtins.str]:
        """
        The value of ``ID`` for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for the default cache behavior.
        """
        return pulumi.get(self, "field_level_encryption_id")

    @property
    @pulumi.getter(name="forwardedValues")
    def forwarded_values(self) -> Optional['outputs.DistributionForwardedValues']:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see [Working with policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html) in the *Amazon CloudFront Developer Guide*.
         If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
         A ``DefaultCacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
         A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
        """
        return pulumi.get(self, "forwarded_values")

    @property
    @pulumi.getter(name="functionAssociations")
    def function_associations(self) -> Optional[Sequence['outputs.DistributionFunctionAssociation']]:
        """
        A list of CloudFront functions that are associated with this cache behavior. Your functions must be published to the ``LIVE`` stage to associate them with a cache behavior.
        """
        return pulumi.get(self, "function_associations")

    @property
    @pulumi.getter(name="grpcConfig")
    def grpc_config(self) -> Optional['outputs.DistributionGrpcConfig']:
        """
        The gRPC configuration for your cache behavior.
        """
        return pulumi.get(self, "grpc_config")

    @property
    @pulumi.getter(name="lambdaFunctionAssociations")
    def lambda_function_associations(self) -> Optional[Sequence['outputs.DistributionLambdaFunctionAssociation']]:
        """
        A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
        """
        return pulumi.get(self, "lambda_function_associations")

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[builtins.float]:
        """
        This field is deprecated. We recommend that you use the ``MaxTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter(name="minTtl")
    def min_ttl(self) -> Optional[builtins.float]:
        """
        This field is deprecated. We recommend that you use the ``MinTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
         You must specify ``0`` for ``MinTTL`` if you configure CloudFront to forward all headers to your origin (under ``Headers``, if you specify ``1`` for ``Quantity`` and ``*`` for ``Name``).
        """
        return pulumi.get(self, "min_ttl")

    @property
    @pulumi.getter(name="originRequestPolicyId")
    def origin_request_policy_id(self) -> Optional[builtins.str]:
        """
        The unique identifier of the origin request policy that is attached to the default cache behavior. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_request_policy_id")

    @property
    @pulumi.getter(name="realtimeLogConfigArn")
    def realtime_log_config_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior. For more information, see [Real-time logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "realtime_log_config_arn")

    @property
    @pulumi.getter(name="responseHeadersPolicyId")
    def response_headers_policy_id(self) -> Optional[builtins.str]:
        """
        The identifier for a response headers policy.
        """
        return pulumi.get(self, "response_headers_policy_id")

    @property
    @pulumi.getter(name="smoothStreaming")
    def smooth_streaming(self) -> Optional[builtins.bool]:
        """
        Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior. If so, specify ``true``; if not, specify ``false``. If you specify ``true`` for ``SmoothStreaming``, you can still distribute other content using this cache behavior if the content matches the value of ``PathPattern``.
        """
        return pulumi.get(self, "smooth_streaming")

    @property
    @pulumi.getter(name="trustedKeyGroups")
    def trusted_key_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
         When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "trusted_key_groups")

    @property
    @pulumi.getter(name="trustedSigners")
    def trusted_signers(self) -> Optional[Sequence[builtins.str]]:
        """
        We recommend using ``TrustedKeyGroups`` instead of ``TrustedSigners``.
          A list of AWS-account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.
         When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in a trusted signer's AWS-account. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "trusted_signers")


@pulumi.output_type
class DistributionForwardedValues(dict):
    """
    This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
     If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
     If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
     A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryString":
            suggest = "query_string"
        elif key == "queryStringCacheKeys":
            suggest = "query_string_cache_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionForwardedValues. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionForwardedValues.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionForwardedValues.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_string: builtins.bool,
                 cookies: Optional['outputs.DistributionCookies'] = None,
                 headers: Optional[Sequence[builtins.str]] = None,
                 query_string_cache_keys: Optional[Sequence[builtins.str]] = None):
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
        :param builtins.bool query_string: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
                If you want to include query strings in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
                If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
                Indicates whether you want CloudFront to forward query strings to the origin that is associated with this cache behavior and cache based on the query string parameters. CloudFront behavior depends on the value of ``QueryString`` and on the values that you specify for ``QueryStringCacheKeys``, if any:
                If you specify true for ``QueryString`` and you don't specify any values for ``QueryStringCacheKeys``, CloudFront forwards all query string parameters to the origin and caches based on all query string parameters. Depending on how many query string parameters and values you have, this can adversely affect performance because CloudFront must forward more requests to the origin.
                If you specify true for ``QueryString`` and you specify one or more values for ``QueryStringCacheKeys``, CloudFront forwards all query string parameters to the origin, but it only caches based on the query string parameters that you specify.
                If you specify false for ``QueryString``, CloudFront doesn't forward any query string parameters to the origin, and doesn't cache based on query string parameters.
                For more information, see [Configuring CloudFront to Cache Based on Query String Parameters](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html) in the *Amazon CloudFront Developer Guide*.
        :param 'DistributionCookies' cookies: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
                If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
                If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
                A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones. For more information about forwarding cookies to the origin, see [How CloudFront Forwards, Caches, and Logs Cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html) in the *Amazon CloudFront Developer Guide*.
        :param Sequence[builtins.str] headers: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
                If you want to include headers in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
                If you want to send headers to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
                A complex type that specifies the ``Headers``, if any, that you want CloudFront to forward to the origin for this cache behavior (whitelisted headers). For the headers that you specify, CloudFront also caches separate versions of a specified object that is based on the header values in viewer requests.
                For more information, see [Caching Content Based on Request Headers](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html) in the *Amazon CloudFront Developer Guide*.
        :param Sequence[builtins.str] query_string_cache_keys: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
                If you want to include query strings in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
                If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
                A complex type that contains information about the query string parameters that you want CloudFront to use for caching for this cache behavior.
        """
        pulumi.set(__self__, "query_string", query_string)
        if cookies is not None:
            pulumi.set(__self__, "cookies", cookies)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_string_cache_keys is not None:
            pulumi.set(__self__, "query_string_cache_keys", query_string_cache_keys)

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> builtins.bool:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include query strings in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         Indicates whether you want CloudFront to forward query strings to the origin that is associated with this cache behavior and cache based on the query string parameters. CloudFront behavior depends on the value of ``QueryString`` and on the values that you specify for ``QueryStringCacheKeys``, if any:
         If you specify true for ``QueryString`` and you don't specify any values for ``QueryStringCacheKeys``, CloudFront forwards all query string parameters to the origin and caches based on all query string parameters. Depending on how many query string parameters and values you have, this can adversely affect performance because CloudFront must forward more requests to the origin.
         If you specify true for ``QueryString`` and you specify one or more values for ``QueryStringCacheKeys``, CloudFront forwards all query string parameters to the origin, but it only caches based on the query string parameters that you specify.
         If you specify false for ``QueryString``, CloudFront doesn't forward any query string parameters to the origin, and doesn't cache based on query string parameters.
         For more information, see [Configuring CloudFront to Cache Based on Query String Parameters](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "query_string")

    @property
    @pulumi.getter
    def cookies(self) -> Optional['outputs.DistributionCookies']:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones. For more information about forwarding cookies to the origin, see [How CloudFront Forwards, Caches, and Logs Cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "cookies")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence[builtins.str]]:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include headers in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send headers to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         A complex type that specifies the ``Headers``, if any, that you want CloudFront to forward to the origin for this cache behavior (whitelisted headers). For the headers that you specify, CloudFront also caches separate versions of a specified object that is based on the header values in viewer requests.
         For more information, see [Caching Content Based on Request Headers](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="queryStringCacheKeys")
    def query_string_cache_keys(self) -> Optional[Sequence[builtins.str]]:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include query strings in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         A complex type that contains information about the query string parameters that you want CloudFront to use for caching for this cache behavior.
        """
        return pulumi.get(self, "query_string_cache_keys")


@pulumi.output_type
class DistributionFunctionAssociation(dict):
    """
    A CloudFront function that is associated with a cache behavior in a CloudFront distribution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventType":
            suggest = "event_type"
        elif key == "functionArn":
            suggest = "function_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionFunctionAssociation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionFunctionAssociation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionFunctionAssociation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_type: Optional[builtins.str] = None,
                 function_arn: Optional[builtins.str] = None):
        """
        A CloudFront function that is associated with a cache behavior in a CloudFront distribution.
        :param builtins.str event_type: The event type of the function, either ``viewer-request`` or ``viewer-response``. You cannot use origin-facing event types (``origin-request`` and ``origin-response``) with a CloudFront function.
        :param builtins.str function_arn: The Amazon Resource Name (ARN) of the function.
        """
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if function_arn is not None:
            pulumi.set(__self__, "function_arn", function_arn)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[builtins.str]:
        """
        The event type of the function, either ``viewer-request`` or ``viewer-response``. You cannot use origin-facing event types (``origin-request`` and ``origin-response``) with a CloudFront function.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the function.
        """
        return pulumi.get(self, "function_arn")


@pulumi.output_type
class DistributionGeoRestriction(dict):
    """
    A complex type that controls the countries in which your content is distributed. CF determines the location of your users using ``MaxMind`` GeoIP databases. To disable geo restriction, remove the [Restrictions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions) property from your stack template.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restrictionType":
            suggest = "restriction_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionGeoRestriction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionGeoRestriction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionGeoRestriction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 restriction_type: builtins.str,
                 locations: Optional[Sequence[builtins.str]] = None):
        """
        A complex type that controls the countries in which your content is distributed. CF determines the location of your users using ``MaxMind`` GeoIP databases. To disable geo restriction, remove the [Restrictions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions) property from your stack template.
        :param builtins.str restriction_type: The method that you want to use to restrict distribution of your content by country:
                 +  ``none``: No geo restriction is enabled, meaning access to content is not restricted by client geo location.
                 +  ``blacklist``: The ``Location`` elements specify the countries in which you don't want CloudFront to distribute your content.
                 +  ``whitelist``: The ``Location`` elements specify the countries in which you want CloudFront to distribute your content.
        :param Sequence[builtins.str] locations: A complex type that contains a ``Location`` element for each country in which you want CloudFront either to distribute your content (``whitelist``) or not distribute your content (``blacklist``).
                The ``Location`` element is a two-letter, uppercase country code for a country that you want to include in your ``blacklist`` or ``whitelist``. Include one ``Location`` element for each country.
                CloudFront and ``MaxMind`` both use ``ISO 3166`` country codes. For the current list of countries and the corresponding codes, see ``ISO 3166-1-alpha-2`` code on the *International Organization for Standardization* website. You can also refer to the country list on the CloudFront console, which includes both country names and codes.
        """
        pulumi.set(__self__, "restriction_type", restriction_type)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)

    @property
    @pulumi.getter(name="restrictionType")
    def restriction_type(self) -> builtins.str:
        """
        The method that you want to use to restrict distribution of your content by country:
          +  ``none``: No geo restriction is enabled, meaning access to content is not restricted by client geo location.
          +  ``blacklist``: The ``Location`` elements specify the countries in which you don't want CloudFront to distribute your content.
          +  ``whitelist``: The ``Location`` elements specify the countries in which you want CloudFront to distribute your content.
        """
        return pulumi.get(self, "restriction_type")

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[builtins.str]]:
        """
        A complex type that contains a ``Location`` element for each country in which you want CloudFront either to distribute your content (``whitelist``) or not distribute your content (``blacklist``).
         The ``Location`` element is a two-letter, uppercase country code for a country that you want to include in your ``blacklist`` or ``whitelist``. Include one ``Location`` element for each country.
         CloudFront and ``MaxMind`` both use ``ISO 3166`` country codes. For the current list of countries and the corresponding codes, see ``ISO 3166-1-alpha-2`` code on the *International Organization for Standardization* website. You can also refer to the country list on the CloudFront console, which includes both country names and codes.
        """
        return pulumi.get(self, "locations")


@pulumi.output_type
class DistributionGrpcConfig(dict):
    """
    Amazon CloudFront supports gRPC, an open-source remote procedure call (RPC) framework built on HTTP/2. gRPC offers bi-directional streaming and binary protocol that buffers payloads, making it suitable for applications that require low latency communications.
     To enable your distribution to handle gRPC requests, you must include HTTP/2 as one of the supported ``HTTP`` versions and allow ``HTTP`` methods, including ``POST``.
     For more information, see [Using gRPC with CloudFront distributions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-using-grpc.html) in the *Amazon CloudFront Developer Guide*.
    """
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        Amazon CloudFront supports gRPC, an open-source remote procedure call (RPC) framework built on HTTP/2. gRPC offers bi-directional streaming and binary protocol that buffers payloads, making it suitable for applications that require low latency communications.
         To enable your distribution to handle gRPC requests, you must include HTTP/2 as one of the supported ``HTTP`` versions and allow ``HTTP`` methods, including ``POST``.
         For more information, see [Using gRPC with CloudFront distributions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-using-grpc.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.bool enabled: Enables your CloudFront distribution to receive gRPC requests and to proxy them directly to your origins.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Enables your CloudFront distribution to receive gRPC requests and to proxy them directly to your origins.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DistributionLambdaFunctionAssociation(dict):
    """
    A complex type that contains a Lambda@Edge function association.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventType":
            suggest = "event_type"
        elif key == "includeBody":
            suggest = "include_body"
        elif key == "lambdaFunctionArn":
            suggest = "lambda_function_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionLambdaFunctionAssociation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionLambdaFunctionAssociation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionLambdaFunctionAssociation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_type: Optional[builtins.str] = None,
                 include_body: Optional[builtins.bool] = None,
                 lambda_function_arn: Optional[builtins.str] = None):
        """
        A complex type that contains a Lambda@Edge function association.
        :param builtins.str event_type: Specifies the event type that triggers a Lambda@Edge function invocation. You can specify the following values:
                 +  ``viewer-request``: The function executes when CloudFront receives a request from a viewer and before it checks to see whether the requested object is in the edge cache.
                 +  ``origin-request``: The function executes only when CloudFront sends a request to your origin. When the requested object is in the edge cache, the function doesn't execute.
                 +  ``origin-response``: The function executes after CloudFront receives a response from the origin and before it caches the object in the response. When the requested object is in the edge cache, the function doesn't execute.
                 +  ``viewer-response``: The function executes before CloudFront returns the requested object to the viewer. The function executes regardless of whether the object was already in the edge cache.
                If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
        :param builtins.bool include_body: A flag that allows a Lambda@Edge function to have read access to the body content. For more information, see [Accessing the Request Body by Choosing the Include Body Option](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html) in the Amazon CloudFront Developer Guide.
        :param builtins.str lambda_function_arn: The ARN of the Lambda@Edge function. You must specify the ARN of a function version; you can't specify an alias or $LATEST.
        """
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if include_body is not None:
            pulumi.set(__self__, "include_body", include_body)
        if lambda_function_arn is not None:
            pulumi.set(__self__, "lambda_function_arn", lambda_function_arn)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[builtins.str]:
        """
        Specifies the event type that triggers a Lambda@Edge function invocation. You can specify the following values:
          +  ``viewer-request``: The function executes when CloudFront receives a request from a viewer and before it checks to see whether the requested object is in the edge cache.
          +  ``origin-request``: The function executes only when CloudFront sends a request to your origin. When the requested object is in the edge cache, the function doesn't execute.
          +  ``origin-response``: The function executes after CloudFront receives a response from the origin and before it caches the object in the response. When the requested object is in the edge cache, the function doesn't execute.
          +  ``viewer-response``: The function executes before CloudFront returns the requested object to the viewer. The function executes regardless of whether the object was already in the edge cache.
         If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter(name="includeBody")
    def include_body(self) -> Optional[builtins.bool]:
        """
        A flag that allows a Lambda@Edge function to have read access to the body content. For more information, see [Accessing the Request Body by Choosing the Include Body Option](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html) in the Amazon CloudFront Developer Guide.
        """
        return pulumi.get(self, "include_body")

    @property
    @pulumi.getter(name="lambdaFunctionArn")
    def lambda_function_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the Lambda@Edge function. You must specify the ARN of a function version; you can't specify an alias or $LATEST.
        """
        return pulumi.get(self, "lambda_function_arn")


@pulumi.output_type
class DistributionLegacyCustomOrigin(dict):
    """
    A custom origin. A custom origin is any origin that is *not* an S3 bucket, with one exception. An S3 bucket that is [configured with static website hosting](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html)*is* a custom origin.
      This property is legacy. We recommend that you use [Origin](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html) instead.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsName":
            suggest = "dns_name"
        elif key == "originProtocolPolicy":
            suggest = "origin_protocol_policy"
        elif key == "originSslProtocols":
            suggest = "origin_ssl_protocols"
        elif key == "httpPort":
            suggest = "http_port"
        elif key == "httpsPort":
            suggest = "https_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionLegacyCustomOrigin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionLegacyCustomOrigin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionLegacyCustomOrigin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_name: builtins.str,
                 origin_protocol_policy: builtins.str,
                 origin_ssl_protocols: Sequence[builtins.str],
                 http_port: Optional[builtins.int] = None,
                 https_port: Optional[builtins.int] = None):
        """
        A custom origin. A custom origin is any origin that is *not* an S3 bucket, with one exception. An S3 bucket that is [configured with static website hosting](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html)*is* a custom origin.
          This property is legacy. We recommend that you use [Origin](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html) instead.
        :param builtins.str dns_name: The domain name assigned to your CF distribution.
        :param builtins.str origin_protocol_policy: Specifies the protocol (HTTP or HTTPS) that CF uses to connect to the origin.
        :param Sequence[builtins.str] origin_ssl_protocols: The minimum SSL/TLS protocol version that CF uses when communicating with your origin server over HTTPs.
                For more information, see [Minimum Origin SSL Protocol](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols) in the *Developer Guide*.
        :param builtins.int http_port: The HTTP port that CF uses to connect to the origin. Specify the HTTP port that the origin listens on.
        :param builtins.int https_port: The HTTPS port that CF uses to connect to the origin. Specify the HTTPS port that the origin listens on.
        """
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "origin_protocol_policy", origin_protocol_policy)
        pulumi.set(__self__, "origin_ssl_protocols", origin_ssl_protocols)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if https_port is not None:
            pulumi.set(__self__, "https_port", https_port)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> builtins.str:
        """
        The domain name assigned to your CF distribution.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="originProtocolPolicy")
    def origin_protocol_policy(self) -> builtins.str:
        """
        Specifies the protocol (HTTP or HTTPS) that CF uses to connect to the origin.
        """
        return pulumi.get(self, "origin_protocol_policy")

    @property
    @pulumi.getter(name="originSslProtocols")
    def origin_ssl_protocols(self) -> Sequence[builtins.str]:
        """
        The minimum SSL/TLS protocol version that CF uses when communicating with your origin server over HTTPs.
         For more information, see [Minimum Origin SSL Protocol](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols) in the *Developer Guide*.
        """
        return pulumi.get(self, "origin_ssl_protocols")

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[builtins.int]:
        """
        The HTTP port that CF uses to connect to the origin. Specify the HTTP port that the origin listens on.
        """
        return pulumi.get(self, "http_port")

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> Optional[builtins.int]:
        """
        The HTTPS port that CF uses to connect to the origin. Specify the HTTPS port that the origin listens on.
        """
        return pulumi.get(self, "https_port")


@pulumi.output_type
class DistributionLegacyS3Origin(dict):
    """
    The origin as an S3 bucket. 
      This property is legacy. We recommend that you use [Origin](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html) instead.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsName":
            suggest = "dns_name"
        elif key == "originAccessIdentity":
            suggest = "origin_access_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionLegacyS3Origin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionLegacyS3Origin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionLegacyS3Origin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_name: builtins.str,
                 origin_access_identity: Optional[builtins.str] = None):
        """
        The origin as an S3 bucket. 
          This property is legacy. We recommend that you use [Origin](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html) instead.
        :param builtins.str dns_name: The domain name assigned to your CF distribution.
        :param builtins.str origin_access_identity: The CF origin access identity to associate with the distribution. Use an origin access identity to configure the distribution so that end users can only access objects in an S3 through CF.
                 This property is legacy. We recommend that you use [OriginAccessControl](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originaccesscontrol.html) instead.
        """
        pulumi.set(__self__, "dns_name", dns_name)
        if origin_access_identity is not None:
            pulumi.set(__self__, "origin_access_identity", origin_access_identity)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> builtins.str:
        """
        The domain name assigned to your CF distribution.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="originAccessIdentity")
    def origin_access_identity(self) -> Optional[builtins.str]:
        """
        The CF origin access identity to associate with the distribution. Use an origin access identity to configure the distribution so that end users can only access objects in an S3 through CF.
          This property is legacy. We recommend that you use [OriginAccessControl](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originaccesscontrol.html) instead.
        """
        return pulumi.get(self, "origin_access_identity")


@pulumi.output_type
class DistributionLogging(dict):
    """
    A complex type that specifies whether access logs are written for the distribution.
      If you already enabled standard logging (legacy) and you want to enable standard logging (v2) to send your access logs to Amazon S3, we recommend that you specify a *different* Amazon S3 bucket or use a *separate path* in the same bucket (for example, use a log prefix or partitioning). This helps you keep track of which log files are associated with which logging subscription and prevents log files from overwriting each other. For more information, see [Standard logging (access logs)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html) in the *Amazon CloudFront Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeCookies":
            suggest = "include_cookies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionLogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionLogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionLogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: Optional[builtins.str] = None,
                 include_cookies: Optional[builtins.bool] = None,
                 prefix: Optional[builtins.str] = None):
        """
        A complex type that specifies whether access logs are written for the distribution.
          If you already enabled standard logging (legacy) and you want to enable standard logging (v2) to send your access logs to Amazon S3, we recommend that you specify a *different* Amazon S3 bucket or use a *separate path* in the same bucket (for example, use a log prefix or partitioning). This helps you keep track of which log files are associated with which logging subscription and prevents log files from overwriting each other. For more information, see [Standard logging (access logs)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.str bucket: The Amazon S3 bucket to store the access logs in, for example, ``amzn-s3-demo-bucket.s3.amazonaws.com``.
        :param builtins.bool include_cookies: Specifies whether you want CloudFront to include cookies in access logs, specify ``true`` for ``IncludeCookies``. If you choose to include cookies in logs, CloudFront logs all cookies regardless of how you configure the cache behaviors for this distribution. If you don't want to include cookies when you create a distribution or if you want to disable include cookies for an existing distribution, specify ``false`` for ``IncludeCookies``.
        :param builtins.str prefix: An optional string that you want CloudFront to prefix to the access log ``filenames`` for this distribution, for example, ``myprefix/``. If you want to enable logging, but you don't want to specify a prefix, you still must include an empty ``Prefix`` element in the ``Logging`` element.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if include_cookies is not None:
            pulumi.set(__self__, "include_cookies", include_cookies)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[builtins.str]:
        """
        The Amazon S3 bucket to store the access logs in, for example, ``amzn-s3-demo-bucket.s3.amazonaws.com``.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="includeCookies")
    def include_cookies(self) -> Optional[builtins.bool]:
        """
        Specifies whether you want CloudFront to include cookies in access logs, specify ``true`` for ``IncludeCookies``. If you choose to include cookies in logs, CloudFront logs all cookies regardless of how you configure the cache behaviors for this distribution. If you don't want to include cookies when you create a distribution or if you want to disable include cookies for an existing distribution, specify ``false`` for ``IncludeCookies``.
        """
        return pulumi.get(self, "include_cookies")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        An optional string that you want CloudFront to prefix to the access log ``filenames`` for this distribution, for example, ``myprefix/``. If you want to enable logging, but you don't want to specify a prefix, you still must include an empty ``Prefix`` element in the ``Logging`` element.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class DistributionOrigin(dict):
    """
    An origin.
     An origin is the location where content is stored, and from which CloudFront gets content to serve to viewers. To specify an origin:
      +  Use ``S3OriginConfig`` to specify an Amazon S3 bucket that is not configured with static website hosting.
      +  Use ``VpcOriginConfig`` to specify a VPC origin.
      +  Use ``CustomOriginConfig`` to specify all other kinds of origins, including:
      +  An Amazon S3 bucket that is configured with static website hosting
      +  An Elastic Load Balancing load balancer
      +  An EMPlong endpoint
      +  An EMSlong container
      +  Any other HTTP server, running on an Amazon EC2 instance or any other kind of host
      
      
     For the current maximum number of origins that you can specify per distribution, see [General Quotas on Web Distributions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html#limits-web-distributions) in the *Amazon CloudFront Developer Guide* (quotas were formerly referred to as limits).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "connectionAttempts":
            suggest = "connection_attempts"
        elif key == "connectionTimeout":
            suggest = "connection_timeout"
        elif key == "customOriginConfig":
            suggest = "custom_origin_config"
        elif key == "originAccessControlId":
            suggest = "origin_access_control_id"
        elif key == "originCustomHeaders":
            suggest = "origin_custom_headers"
        elif key == "originPath":
            suggest = "origin_path"
        elif key == "originShield":
            suggest = "origin_shield"
        elif key == "s3OriginConfig":
            suggest = "s3_origin_config"
        elif key == "vpcOriginConfig":
            suggest = "vpc_origin_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionOrigin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionOrigin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionOrigin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: builtins.str,
                 id: builtins.str,
                 connection_attempts: Optional[builtins.int] = None,
                 connection_timeout: Optional[builtins.int] = None,
                 custom_origin_config: Optional['outputs.DistributionCustomOriginConfig'] = None,
                 origin_access_control_id: Optional[builtins.str] = None,
                 origin_custom_headers: Optional[Sequence['outputs.DistributionOriginCustomHeader']] = None,
                 origin_path: Optional[builtins.str] = None,
                 origin_shield: Optional['outputs.DistributionOriginShield'] = None,
                 s3_origin_config: Optional['outputs.DistributionS3OriginConfig'] = None,
                 vpc_origin_config: Optional['outputs.DistributionVpcOriginConfig'] = None):
        """
        An origin.
         An origin is the location where content is stored, and from which CloudFront gets content to serve to viewers. To specify an origin:
          +  Use ``S3OriginConfig`` to specify an Amazon S3 bucket that is not configured with static website hosting.
          +  Use ``VpcOriginConfig`` to specify a VPC origin.
          +  Use ``CustomOriginConfig`` to specify all other kinds of origins, including:
          +  An Amazon S3 bucket that is configured with static website hosting
          +  An Elastic Load Balancing load balancer
          +  An EMPlong endpoint
          +  An EMSlong container
          +  Any other HTTP server, running on an Amazon EC2 instance or any other kind of host
          
          
         For the current maximum number of origins that you can specify per distribution, see [General Quotas on Web Distributions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html#limits-web-distributions) in the *Amazon CloudFront Developer Guide* (quotas were formerly referred to as limits).
        :param builtins.str domain_name: The domain name for the origin.
                For more information, see [Origin Domain Name](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName) in the *Amazon CloudFront Developer Guide*.
        :param builtins.str id: A unique identifier for the origin. This value must be unique within the distribution.
                Use this value to specify the ``TargetOriginId`` in a ``CacheBehavior`` or ``DefaultCacheBehavior``.
        :param builtins.int connection_attempts: The number of times that CloudFront attempts to connect to the origin. The minimum number is 1, the maximum is 3, and the default (if you don't specify otherwise) is 3.
                For a custom origin (including an Amazon S3 bucket that's configured with static website hosting), this value also specifies the number of times that CloudFront attempts to get a response from the origin, in the case of an [Origin Response Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout).
                For more information, see [Origin Connection Attempts](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts) in the *Amazon CloudFront Developer Guide*.
        :param builtins.int connection_timeout: The number of seconds that CloudFront waits when trying to establish a connection to the origin. The minimum timeout is 1 second, the maximum is 10 seconds, and the default (if you don't specify otherwise) is 10 seconds.
                For more information, see [Origin Connection Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout) in the *Amazon CloudFront Developer Guide*.
        :param 'DistributionCustomOriginConfig' custom_origin_config: Use this type to specify an origin that is not an Amazon S3 bucket, with one exception. If the Amazon S3 bucket is configured with static website hosting, use this type. If the Amazon S3 bucket is not configured with static website hosting, use the ``S3OriginConfig`` type instead.
        :param builtins.str origin_access_control_id: The unique identifier of an origin access control for this origin.
                For more information, see [Restricting access to an Amazon S3 origin](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html) in the *Amazon CloudFront Developer Guide*.
        :param Sequence['DistributionOriginCustomHeader'] origin_custom_headers: A list of HTTP header names and values that CloudFront adds to the requests that it sends to the origin.
                For more information, see [Adding Custom Headers to Origin Requests](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.str origin_path: An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
                For more information, see [Origin Path](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath) in the *Amazon CloudFront Developer Guide*.
        :param 'DistributionOriginShield' origin_shield: CloudFront Origin Shield. Using Origin Shield can help reduce the load on your origin.
                For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the *Amazon CloudFront Developer Guide*.
        :param 'DistributionS3OriginConfig' s3_origin_config: Use this type to specify an origin that is an Amazon S3 bucket that is not configured with static website hosting. To specify any other type of origin, including an Amazon S3 bucket that is configured with static website hosting, use the ``CustomOriginConfig`` type instead.
        :param 'DistributionVpcOriginConfig' vpc_origin_config: The VPC origin configuration.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "id", id)
        if connection_attempts is not None:
            pulumi.set(__self__, "connection_attempts", connection_attempts)
        if connection_timeout is not None:
            pulumi.set(__self__, "connection_timeout", connection_timeout)
        if custom_origin_config is not None:
            pulumi.set(__self__, "custom_origin_config", custom_origin_config)
        if origin_access_control_id is not None:
            pulumi.set(__self__, "origin_access_control_id", origin_access_control_id)
        if origin_custom_headers is not None:
            pulumi.set(__self__, "origin_custom_headers", origin_custom_headers)
        if origin_path is not None:
            pulumi.set(__self__, "origin_path", origin_path)
        if origin_shield is not None:
            pulumi.set(__self__, "origin_shield", origin_shield)
        if s3_origin_config is not None:
            pulumi.set(__self__, "s3_origin_config", s3_origin_config)
        if vpc_origin_config is not None:
            pulumi.set(__self__, "vpc_origin_config", vpc_origin_config)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> builtins.str:
        """
        The domain name for the origin.
         For more information, see [Origin Domain Name](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        A unique identifier for the origin. This value must be unique within the distribution.
         Use this value to specify the ``TargetOriginId`` in a ``CacheBehavior`` or ``DefaultCacheBehavior``.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="connectionAttempts")
    def connection_attempts(self) -> Optional[builtins.int]:
        """
        The number of times that CloudFront attempts to connect to the origin. The minimum number is 1, the maximum is 3, and the default (if you don't specify otherwise) is 3.
         For a custom origin (including an Amazon S3 bucket that's configured with static website hosting), this value also specifies the number of times that CloudFront attempts to get a response from the origin, in the case of an [Origin Response Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout).
         For more information, see [Origin Connection Attempts](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "connection_attempts")

    @property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> Optional[builtins.int]:
        """
        The number of seconds that CloudFront waits when trying to establish a connection to the origin. The minimum timeout is 1 second, the maximum is 10 seconds, and the default (if you don't specify otherwise) is 10 seconds.
         For more information, see [Origin Connection Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "connection_timeout")

    @property
    @pulumi.getter(name="customOriginConfig")
    def custom_origin_config(self) -> Optional['outputs.DistributionCustomOriginConfig']:
        """
        Use this type to specify an origin that is not an Amazon S3 bucket, with one exception. If the Amazon S3 bucket is configured with static website hosting, use this type. If the Amazon S3 bucket is not configured with static website hosting, use the ``S3OriginConfig`` type instead.
        """
        return pulumi.get(self, "custom_origin_config")

    @property
    @pulumi.getter(name="originAccessControlId")
    def origin_access_control_id(self) -> Optional[builtins.str]:
        """
        The unique identifier of an origin access control for this origin.
         For more information, see [Restricting access to an Amazon S3 origin](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_access_control_id")

    @property
    @pulumi.getter(name="originCustomHeaders")
    def origin_custom_headers(self) -> Optional[Sequence['outputs.DistributionOriginCustomHeader']]:
        """
        A list of HTTP header names and values that CloudFront adds to the requests that it sends to the origin.
         For more information, see [Adding Custom Headers to Origin Requests](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_custom_headers")

    @property
    @pulumi.getter(name="originPath")
    def origin_path(self) -> Optional[builtins.str]:
        """
        An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
         For more information, see [Origin Path](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_path")

    @property
    @pulumi.getter(name="originShield")
    def origin_shield(self) -> Optional['outputs.DistributionOriginShield']:
        """
        CloudFront Origin Shield. Using Origin Shield can help reduce the load on your origin.
         For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_shield")

    @property
    @pulumi.getter(name="s3OriginConfig")
    def s3_origin_config(self) -> Optional['outputs.DistributionS3OriginConfig']:
        """
        Use this type to specify an origin that is an Amazon S3 bucket that is not configured with static website hosting. To specify any other type of origin, including an Amazon S3 bucket that is configured with static website hosting, use the ``CustomOriginConfig`` type instead.
        """
        return pulumi.get(self, "s3_origin_config")

    @property
    @pulumi.getter(name="vpcOriginConfig")
    def vpc_origin_config(self) -> Optional['outputs.DistributionVpcOriginConfig']:
        """
        The VPC origin configuration.
        """
        return pulumi.get(self, "vpc_origin_config")


@pulumi.output_type
class DistributionOriginCustomHeader(dict):
    """
    A complex type that contains ``HeaderName`` and ``HeaderValue`` elements, if any, for this distribution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"
        elif key == "headerValue":
            suggest = "header_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionOriginCustomHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionOriginCustomHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionOriginCustomHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: builtins.str,
                 header_value: builtins.str):
        """
        A complex type that contains ``HeaderName`` and ``HeaderValue`` elements, if any, for this distribution.
        :param builtins.str header_name: The name of a header that you want CloudFront to send to your origin. For more information, see [Adding Custom Headers to Origin Requests](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.str header_value: The value for the header that you specified in the ``HeaderName`` field.
        """
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "header_value", header_value)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> builtins.str:
        """
        The name of a header that you want CloudFront to send to your origin. For more information, see [Adding Custom Headers to Origin Requests](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> builtins.str:
        """
        The value for the header that you specified in the ``HeaderName`` field.
        """
        return pulumi.get(self, "header_value")


@pulumi.output_type
class DistributionOriginGroup(dict):
    """
    An origin group includes two origins (a primary origin and a secondary origin to failover to) and a failover criteria that you specify. You create an origin group to support origin failover in CloudFront. When you create or update a distribution, you can specify the origin group instead of a single origin, and CloudFront will failover from the primary origin to the secondary origin under the failover conditions that you've chosen.
     Optionally, you can choose selection criteria for your origin group to specify how your origins are selected when your distribution routes viewer requests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverCriteria":
            suggest = "failover_criteria"
        elif key == "selectionCriteria":
            suggest = "selection_criteria"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionOriginGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionOriginGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionOriginGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_criteria: 'outputs.DistributionOriginGroupFailoverCriteria',
                 id: builtins.str,
                 members: 'outputs.DistributionOriginGroupMembers',
                 selection_criteria: Optional['DistributionOriginGroupSelectionCriteria'] = None):
        """
        An origin group includes two origins (a primary origin and a secondary origin to failover to) and a failover criteria that you specify. You create an origin group to support origin failover in CloudFront. When you create or update a distribution, you can specify the origin group instead of a single origin, and CloudFront will failover from the primary origin to the secondary origin under the failover conditions that you've chosen.
         Optionally, you can choose selection criteria for your origin group to specify how your origins are selected when your distribution routes viewer requests.
        :param 'DistributionOriginGroupFailoverCriteria' failover_criteria: A complex type that contains information about the failover criteria for an origin group.
        :param builtins.str id: The origin group's ID.
        :param 'DistributionOriginGroupMembers' members: A complex type that contains information about the origins in an origin group.
        :param 'DistributionOriginGroupSelectionCriteria' selection_criteria: The selection criteria for the origin group. For more information, see [Create an origin group](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/high_availability_origin_failover.html#concept_origin_groups.creating) in the *Amazon CloudFront Developer Guide*.
        """
        pulumi.set(__self__, "failover_criteria", failover_criteria)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "members", members)
        if selection_criteria is not None:
            pulumi.set(__self__, "selection_criteria", selection_criteria)

    @property
    @pulumi.getter(name="failoverCriteria")
    def failover_criteria(self) -> 'outputs.DistributionOriginGroupFailoverCriteria':
        """
        A complex type that contains information about the failover criteria for an origin group.
        """
        return pulumi.get(self, "failover_criteria")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The origin group's ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def members(self) -> 'outputs.DistributionOriginGroupMembers':
        """
        A complex type that contains information about the origins in an origin group.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter(name="selectionCriteria")
    def selection_criteria(self) -> Optional['DistributionOriginGroupSelectionCriteria']:
        """
        The selection criteria for the origin group. For more information, see [Create an origin group](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/high_availability_origin_failover.html#concept_origin_groups.creating) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "selection_criteria")


@pulumi.output_type
class DistributionOriginGroupFailoverCriteria(dict):
    """
    A complex data type that includes information about the failover criteria for an origin group, including the status codes for which CloudFront will failover from the primary origin to the second origin.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCodes":
            suggest = "status_codes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionOriginGroupFailoverCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionOriginGroupFailoverCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionOriginGroupFailoverCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status_codes: 'outputs.DistributionStatusCodes'):
        """
        A complex data type that includes information about the failover criteria for an origin group, including the status codes for which CloudFront will failover from the primary origin to the second origin.
        :param 'DistributionStatusCodes' status_codes: The status codes that, when returned from the primary origin, will trigger CloudFront to failover to the second origin.
        """
        pulumi.set(__self__, "status_codes", status_codes)

    @property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> 'outputs.DistributionStatusCodes':
        """
        The status codes that, when returned from the primary origin, will trigger CloudFront to failover to the second origin.
        """
        return pulumi.get(self, "status_codes")


@pulumi.output_type
class DistributionOriginGroupMember(dict):
    """
    An origin in an origin group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "originId":
            suggest = "origin_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionOriginGroupMember. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionOriginGroupMember.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionOriginGroupMember.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 origin_id: builtins.str):
        """
        An origin in an origin group.
        :param builtins.str origin_id: The ID for an origin in an origin group.
        """
        pulumi.set(__self__, "origin_id", origin_id)

    @property
    @pulumi.getter(name="originId")
    def origin_id(self) -> builtins.str:
        """
        The ID for an origin in an origin group.
        """
        return pulumi.get(self, "origin_id")


@pulumi.output_type
class DistributionOriginGroupMembers(dict):
    """
    A complex data type for the origins included in an origin group.
    """
    def __init__(__self__, *,
                 items: Sequence['outputs.DistributionOriginGroupMember'],
                 quantity: builtins.int):
        """
        A complex data type for the origins included in an origin group.
        :param Sequence['DistributionOriginGroupMember'] items: Items (origins) in an origin group.
        :param builtins.int quantity: The number of origins in an origin group.
        """
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.DistributionOriginGroupMember']:
        """
        Items (origins) in an origin group.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def quantity(self) -> builtins.int:
        """
        The number of origins in an origin group.
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class DistributionOriginGroups(dict):
    """
    A complex data type for the origin groups specified for a distribution.
    """
    def __init__(__self__, *,
                 quantity: builtins.int,
                 items: Optional[Sequence['outputs.DistributionOriginGroup']] = None):
        """
        A complex data type for the origin groups specified for a distribution.
        :param builtins.int quantity: The number of origin groups.
        :param Sequence['DistributionOriginGroup'] items: The items (origin groups) in a distribution.
        """
        pulumi.set(__self__, "quantity", quantity)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def quantity(self) -> builtins.int:
        """
        The number of origin groups.
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.DistributionOriginGroup']]:
        """
        The items (origin groups) in a distribution.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class DistributionOriginShield(dict):
    """
    CloudFront Origin Shield.
     Using Origin Shield can help reduce the load on your origin. For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the *Amazon CloudFront Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "originShieldRegion":
            suggest = "origin_shield_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionOriginShield. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionOriginShield.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionOriginShield.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 origin_shield_region: Optional[builtins.str] = None):
        """
        CloudFront Origin Shield.
         Using Origin Shield can help reduce the load on your origin. For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.bool enabled: A flag that specifies whether Origin Shield is enabled.
                When it's enabled, CloudFront routes all requests through Origin Shield, which can help protect your origin. When it's disabled, CloudFront might send requests directly to your origin from multiple edge locations or regional edge caches.
        :param builtins.str origin_shield_region: The AWS-Region for Origin Shield.
                Specify the AWS-Region that has the lowest latency to your origin. To specify a region, use the region code, not the region name. For example, specify the US East (Ohio) region as ``us-east-2``.
                When you enable CloudFront Origin Shield, you must specify the AWS-Region for Origin Shield. For the list of AWS-Regions that you can specify, and for help choosing the best Region for your origin, see [Choosing the for Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region) in the *Amazon CloudFront Developer Guide*.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if origin_shield_region is not None:
            pulumi.set(__self__, "origin_shield_region", origin_shield_region)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        A flag that specifies whether Origin Shield is enabled.
         When it's enabled, CloudFront routes all requests through Origin Shield, which can help protect your origin. When it's disabled, CloudFront might send requests directly to your origin from multiple edge locations or regional edge caches.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="originShieldRegion")
    def origin_shield_region(self) -> Optional[builtins.str]:
        """
        The AWS-Region for Origin Shield.
         Specify the AWS-Region that has the lowest latency to your origin. To specify a region, use the region code, not the region name. For example, specify the US East (Ohio) region as ``us-east-2``.
         When you enable CloudFront Origin Shield, you must specify the AWS-Region for Origin Shield. For the list of AWS-Regions that you can specify, and for help choosing the best Region for your origin, see [Choosing the for Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_shield_region")


@pulumi.output_type
class DistributionParameterDefinition(dict):
    """
    A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
    """
    def __init__(__self__, *,
                 definition: 'outputs.DistributionParameterDefinitionDefinitionProperties',
                 name: builtins.str):
        """
        A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
        :param 'DistributionParameterDefinitionDefinitionProperties' definition: The value that you assigned to the parameter.
        :param builtins.str name: The name of the parameter.
        """
        pulumi.set(__self__, "definition", definition)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def definition(self) -> 'outputs.DistributionParameterDefinitionDefinitionProperties':
        """
        The value that you assigned to the parameter.
        """
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the parameter.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DistributionParameterDefinitionDefinitionProperties(dict):
    """
    The value that you assigned to the parameter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stringSchema":
            suggest = "string_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionParameterDefinitionDefinitionProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionParameterDefinitionDefinitionProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionParameterDefinitionDefinitionProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 string_schema: Optional['outputs.DistributionParameterDefinitionDefinitionPropertiesStringSchemaProperties'] = None):
        """
        The value that you assigned to the parameter.
        """
        if string_schema is not None:
            pulumi.set(__self__, "string_schema", string_schema)

    @property
    @pulumi.getter(name="stringSchema")
    def string_schema(self) -> Optional['outputs.DistributionParameterDefinitionDefinitionPropertiesStringSchemaProperties']:
        return pulumi.get(self, "string_schema")


@pulumi.output_type
class DistributionParameterDefinitionDefinitionPropertiesStringSchemaProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionParameterDefinitionDefinitionPropertiesStringSchemaProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionParameterDefinitionDefinitionPropertiesStringSchemaProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionParameterDefinitionDefinitionPropertiesStringSchemaProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 required: builtins.bool,
                 comment: Optional[builtins.str] = None,
                 default_value: Optional[builtins.str] = None):
        pulumi.set(__self__, "required", required)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)

    @property
    @pulumi.getter
    def required(self) -> builtins.bool:
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def comment(self) -> Optional[builtins.str]:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "default_value")


@pulumi.output_type
class DistributionRestrictions(dict):
    """
    A complex type that identifies ways in which you want to restrict distribution of your content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "geoRestriction":
            suggest = "geo_restriction"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionRestrictions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionRestrictions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionRestrictions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 geo_restriction: 'outputs.DistributionGeoRestriction'):
        """
        A complex type that identifies ways in which you want to restrict distribution of your content.
        :param 'DistributionGeoRestriction' geo_restriction: A complex type that controls the countries in which your content is distributed. CF determines the location of your users using ``MaxMind`` GeoIP databases. To disable geo restriction, remove the [Restrictions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions) property from your stack template.
        """
        pulumi.set(__self__, "geo_restriction", geo_restriction)

    @property
    @pulumi.getter(name="geoRestriction")
    def geo_restriction(self) -> 'outputs.DistributionGeoRestriction':
        """
        A complex type that controls the countries in which your content is distributed. CF determines the location of your users using ``MaxMind`` GeoIP databases. To disable geo restriction, remove the [Restrictions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions) property from your stack template.
        """
        return pulumi.get(self, "geo_restriction")


@pulumi.output_type
class DistributionS3OriginConfig(dict):
    """
    A complex type that contains information about the Amazon S3 origin. If the origin is a custom origin or an S3 bucket that is configured as a website endpoint, use the ``CustomOriginConfig`` element instead.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "originAccessIdentity":
            suggest = "origin_access_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionS3OriginConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionS3OriginConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionS3OriginConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 origin_access_identity: Optional[builtins.str] = None):
        """
        A complex type that contains information about the Amazon S3 origin. If the origin is a custom origin or an S3 bucket that is configured as a website endpoint, use the ``CustomOriginConfig`` element instead.
        :param builtins.str origin_access_identity: If you're using origin access control (OAC) instead of origin access identity, specify an empty ``OriginAccessIdentity`` element. For more information, see [Restricting access to an](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html) in the *Amazon CloudFront Developer Guide*.
                 The CloudFront origin access identity to associate with the origin. Use an origin access identity to configure the origin so that viewers can *only* access objects in an Amazon S3 bucket through CloudFront. The format of the value is:
                 ``origin-access-identity/cloudfront/ID-of-origin-access-identity`` 
                The ``ID-of-origin-access-identity`` is the value that CloudFront returned in the ``ID`` element when you created the origin access identity.
                If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an empty ``OriginAccessIdentity`` element.
                To delete the origin access identity from an existing distribution, update the distribution configuration and include an empty ``OriginAccessIdentity`` element.
                To replace the origin access identity, update the distribution configuration and specify the new origin access identity.
                For more information about the origin access identity, see [Serving Private Content through CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        if origin_access_identity is not None:
            pulumi.set(__self__, "origin_access_identity", origin_access_identity)

    @property
    @pulumi.getter(name="originAccessIdentity")
    def origin_access_identity(self) -> Optional[builtins.str]:
        """
        If you're using origin access control (OAC) instead of origin access identity, specify an empty ``OriginAccessIdentity`` element. For more information, see [Restricting access to an](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html) in the *Amazon CloudFront Developer Guide*.
          The CloudFront origin access identity to associate with the origin. Use an origin access identity to configure the origin so that viewers can *only* access objects in an Amazon S3 bucket through CloudFront. The format of the value is:
          ``origin-access-identity/cloudfront/ID-of-origin-access-identity`` 
         The ``ID-of-origin-access-identity`` is the value that CloudFront returned in the ``ID`` element when you created the origin access identity.
         If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an empty ``OriginAccessIdentity`` element.
         To delete the origin access identity from an existing distribution, update the distribution configuration and include an empty ``OriginAccessIdentity`` element.
         To replace the origin access identity, update the distribution configuration and specify the new origin access identity.
         For more information about the origin access identity, see [Serving Private Content through CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_access_identity")


@pulumi.output_type
class DistributionStatusCodes(dict):
    """
    A complex data type for the status codes that you specify that, when returned by a primary origin, trigger CloudFront to failover to a second origin.
    """
    def __init__(__self__, *,
                 items: Sequence[builtins.int],
                 quantity: builtins.int):
        """
        A complex data type for the status codes that you specify that, when returned by a primary origin, trigger CloudFront to failover to a second origin.
        :param Sequence[builtins.int] items: The items (status codes) for an origin group.
        :param builtins.int quantity: The number of status codes.
        """
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def items(self) -> Sequence[builtins.int]:
        """
        The items (status codes) for an origin group.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def quantity(self) -> builtins.int:
        """
        The number of status codes.
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class DistributionTenantCertificate(dict):
    """
    The ACMlong (ACM) certificate associated with your distribution.
    """
    def __init__(__self__, *,
                 arn: Optional[builtins.str] = None):
        """
        The ACMlong (ACM) certificate associated with your distribution.
        :param builtins.str arn: The Amazon Resource Name (ARN) of the ACM certificate.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the ACM certificate.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class DistributionTenantCustomizations(dict):
    """
    Customizations for the distribution tenant. For each distribution tenant, you can specify the geographic restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and WAF web ACL. These are specific values that you can override or disable from the multi-tenant distribution that was used to create the distribution tenant.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "geoRestrictions":
            suggest = "geo_restrictions"
        elif key == "webAcl":
            suggest = "web_acl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionTenantCustomizations. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionTenantCustomizations.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionTenantCustomizations.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate: Optional['outputs.DistributionTenantCertificate'] = None,
                 geo_restrictions: Optional['outputs.DistributionTenantGeoRestrictionCustomization'] = None,
                 web_acl: Optional['outputs.DistributionTenantWebAclCustomization'] = None):
        """
        Customizations for the distribution tenant. For each distribution tenant, you can specify the geographic restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and WAF web ACL. These are specific values that you can override or disable from the multi-tenant distribution that was used to create the distribution tenant.
        :param 'DistributionTenantCertificate' certificate: The ACMlong (ACM) certificate.
        :param 'DistributionTenantGeoRestrictionCustomization' geo_restrictions: The geographic restrictions.
        :param 'DistributionTenantWebAclCustomization' web_acl: The WAF web ACL.
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if geo_restrictions is not None:
            pulumi.set(__self__, "geo_restrictions", geo_restrictions)
        if web_acl is not None:
            pulumi.set(__self__, "web_acl", web_acl)

    @property
    @pulumi.getter
    def certificate(self) -> Optional['outputs.DistributionTenantCertificate']:
        """
        The ACMlong (ACM) certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="geoRestrictions")
    def geo_restrictions(self) -> Optional['outputs.DistributionTenantGeoRestrictionCustomization']:
        """
        The geographic restrictions.
        """
        return pulumi.get(self, "geo_restrictions")

    @property
    @pulumi.getter(name="webAcl")
    def web_acl(self) -> Optional['outputs.DistributionTenantWebAclCustomization']:
        """
        The WAF web ACL.
        """
        return pulumi.get(self, "web_acl")


@pulumi.output_type
class DistributionTenantDomainResult(dict):
    """
    The details about the domain result.
    """
    def __init__(__self__, *,
                 domain: Optional[builtins.str] = None,
                 status: Optional['DistributionTenantDomainResultStatus'] = None):
        """
        The details about the domain result.
        :param builtins.str domain: The specified domain.
        :param 'DistributionTenantDomainResultStatus' status: Whether the domain is active or inactive.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def domain(self) -> Optional[builtins.str]:
        """
        The specified domain.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def status(self) -> Optional['DistributionTenantDomainResultStatus']:
        """
        Whether the domain is active or inactive.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class DistributionTenantGeoRestrictionCustomization(dict):
    """
    The customizations that you specified for the distribution tenant for geographic restrictions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restrictionType":
            suggest = "restriction_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionTenantGeoRestrictionCustomization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionTenantGeoRestrictionCustomization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionTenantGeoRestrictionCustomization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 locations: Optional[Sequence[builtins.str]] = None,
                 restriction_type: Optional['DistributionTenantGeoRestrictionCustomizationRestrictionType'] = None):
        """
        The customizations that you specified for the distribution tenant for geographic restrictions.
        :param Sequence[builtins.str] locations: The locations for geographic restrictions.
        :param 'DistributionTenantGeoRestrictionCustomizationRestrictionType' restriction_type: The method that you want to use to restrict distribution of your content by country:
                 +  ``none``: No geographic restriction is enabled, meaning access to content is not restricted by client geo location.
                 +  ``blacklist``: The ``Location`` elements specify the countries in which you don't want CloudFront to distribute your content.
                 +  ``whitelist``: The ``Location`` elements specify the countries in which you want CloudFront to distribute your content.
        """
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if restriction_type is not None:
            pulumi.set(__self__, "restriction_type", restriction_type)

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[builtins.str]]:
        """
        The locations for geographic restrictions.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="restrictionType")
    def restriction_type(self) -> Optional['DistributionTenantGeoRestrictionCustomizationRestrictionType']:
        """
        The method that you want to use to restrict distribution of your content by country:
          +  ``none``: No geographic restriction is enabled, meaning access to content is not restricted by client geo location.
          +  ``blacklist``: The ``Location`` elements specify the countries in which you don't want CloudFront to distribute your content.
          +  ``whitelist``: The ``Location`` elements specify the countries in which you want CloudFront to distribute your content.
        """
        return pulumi.get(self, "restriction_type")


@pulumi.output_type
class DistributionTenantManagedCertificateRequest(dict):
    """
    An object that represents the request for the Amazon CloudFront managed ACM certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateTransparencyLoggingPreference":
            suggest = "certificate_transparency_logging_preference"
        elif key == "primaryDomainName":
            suggest = "primary_domain_name"
        elif key == "validationTokenHost":
            suggest = "validation_token_host"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionTenantManagedCertificateRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionTenantManagedCertificateRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionTenantManagedCertificateRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_transparency_logging_preference: Optional['DistributionTenantManagedCertificateRequestCertificateTransparencyLoggingPreference'] = None,
                 primary_domain_name: Optional[builtins.str] = None,
                 validation_token_host: Optional['DistributionTenantManagedCertificateRequestValidationTokenHost'] = None):
        """
        An object that represents the request for the Amazon CloudFront managed ACM certificate.
        :param 'DistributionTenantManagedCertificateRequestCertificateTransparencyLoggingPreference' certificate_transparency_logging_preference: You can opt out of certificate transparency logging by specifying the ``disabled`` option. Opt in by specifying ``enabled``. For more information, see [Certificate Transparency Logging](https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency) in the *User Guide*.
        :param builtins.str primary_domain_name: The primary domain name associated with the CloudFront managed ACM certificate.
        :param 'DistributionTenantManagedCertificateRequestValidationTokenHost' validation_token_host: Specify how the HTTP validation token will be served when requesting the CloudFront managed ACM certificate.
                 +  For ``cloudfront``, CloudFront will automatically serve the validation token. Choose this mode if you can point the domain's DNS to CloudFront immediately.
                 +  For ``self-hosted``, you serve the validation token from your existing infrastructure. Choose this mode when you need to maintain current traffic flow while your certificate is being issued. You can place the validation token at the well-known path on your existing web server, wait for ACM to validate and issue the certificate, and then update your DNS to point to CloudFront.
        """
        if certificate_transparency_logging_preference is not None:
            pulumi.set(__self__, "certificate_transparency_logging_preference", certificate_transparency_logging_preference)
        if primary_domain_name is not None:
            pulumi.set(__self__, "primary_domain_name", primary_domain_name)
        if validation_token_host is not None:
            pulumi.set(__self__, "validation_token_host", validation_token_host)

    @property
    @pulumi.getter(name="certificateTransparencyLoggingPreference")
    def certificate_transparency_logging_preference(self) -> Optional['DistributionTenantManagedCertificateRequestCertificateTransparencyLoggingPreference']:
        """
        You can opt out of certificate transparency logging by specifying the ``disabled`` option. Opt in by specifying ``enabled``. For more information, see [Certificate Transparency Logging](https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency) in the *User Guide*.
        """
        return pulumi.get(self, "certificate_transparency_logging_preference")

    @property
    @pulumi.getter(name="primaryDomainName")
    def primary_domain_name(self) -> Optional[builtins.str]:
        """
        The primary domain name associated with the CloudFront managed ACM certificate.
        """
        return pulumi.get(self, "primary_domain_name")

    @property
    @pulumi.getter(name="validationTokenHost")
    def validation_token_host(self) -> Optional['DistributionTenantManagedCertificateRequestValidationTokenHost']:
        """
        Specify how the HTTP validation token will be served when requesting the CloudFront managed ACM certificate.
          +  For ``cloudfront``, CloudFront will automatically serve the validation token. Choose this mode if you can point the domain's DNS to CloudFront immediately.
          +  For ``self-hosted``, you serve the validation token from your existing infrastructure. Choose this mode when you need to maintain current traffic flow while your certificate is being issued. You can place the validation token at the well-known path on your existing web server, wait for ACM to validate and issue the certificate, and then update your DNS to point to CloudFront.
        """
        return pulumi.get(self, "validation_token_host")


@pulumi.output_type
class DistributionTenantParameter(dict):
    """
    A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
    """
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
        :param builtins.str name: The parameter name.
        :param builtins.str value: The parameter value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The parameter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DistributionTenantWebAclCustomization(dict):
    """
    The WAF web ACL customization specified for the distribution tenant.
    """
    def __init__(__self__, *,
                 action: Optional['DistributionTenantWebAclCustomizationAction'] = None,
                 arn: Optional[builtins.str] = None):
        """
        The WAF web ACL customization specified for the distribution tenant.
        :param 'DistributionTenantWebAclCustomizationAction' action: The action for the WAF web ACL customization. You can specify ``override`` to specify a separate WAF web ACL for the distribution tenant. If you specify ``disable``, the distribution tenant won't have WAF web ACL protections and won't inherit from the multi-tenant distribution.
        :param builtins.str arn: The Amazon Resource Name (ARN) of the WAF web ACL.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def action(self) -> Optional['DistributionTenantWebAclCustomizationAction']:
        """
        The action for the WAF web ACL customization. You can specify ``override`` to specify a separate WAF web ACL for the distribution tenant. If you specify ``disable``, the distribution tenant won't have WAF web ACL protections and won't inherit from the multi-tenant distribution.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the WAF web ACL.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class DistributionViewerCertificate(dict):
    """
    A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
     If the distribution doesn't use ``Aliases`` (also known as alternate domain names or CNAMEs)—that is, if the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net``—set ``CloudFrontDefaultCertificate`` to ``true`` and leave all other fields empty.
     If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), use the fields in this type to specify the following settings:
      +  Which viewers the distribution accepts HTTPS connections from: only viewers that support [server name indication (SNI)](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Server_Name_Indication) (recommended), or all viewers including those that don't support SNI.
      +  To accept HTTPS connections from only viewers that support SNI, set ``SSLSupportMethod`` to ``sni-only``. This is recommended. Most browsers and clients support SNI. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
      +  To accept HTTPS connections from all viewers, including those that don't support SNI, set ``SSLSupportMethod`` to ``vip``. This is not recommended, and results in additional monthly charges from CloudFront. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
      
      +  The minimum SSL/TLS protocol version that the distribution can use to communicate with viewers. To specify a minimum version, choose a value for ``MinimumProtocolVersion``. For more information, see [Security Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy) in the *Amazon CloudFront Developer Guide*.
      +  The location of the SSL/TLS certificate, [(ACM)](https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html) (recommended) or [(IAM)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html). You specify the location by setting a value in one of the following fields (not both):
      +  ``ACMCertificateArn`` (In CloudFormation, this field name is ``AcmCertificateArn``. Note the different capitalization.)
      +  ``IAMCertificateId`` (In CloudFormation, this field name is ``IamCertificateId``. Note the different capitalization.)
      
      
     All distributions support HTTPS connections from viewers. To require viewers to use HTTPS only, or to redirect them from HTTP to HTTPS, use ``ViewerProtocolPolicy`` in the ``CacheBehavior`` or ``DefaultCacheBehavior``. To specify how CloudFront should use SSL/TLS to communicate with your custom origin, use ``CustomOriginConfig``.
     For more information, see [Using HTTPS with CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https.html) and [Using Alternate Domain Names and HTTPS](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-alternate-domain-names.html) in the *Amazon CloudFront Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acmCertificateArn":
            suggest = "acm_certificate_arn"
        elif key == "cloudFrontDefaultCertificate":
            suggest = "cloud_front_default_certificate"
        elif key == "iamCertificateId":
            suggest = "iam_certificate_id"
        elif key == "minimumProtocolVersion":
            suggest = "minimum_protocol_version"
        elif key == "sslSupportMethod":
            suggest = "ssl_support_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionViewerCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionViewerCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionViewerCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acm_certificate_arn: Optional[builtins.str] = None,
                 cloud_front_default_certificate: Optional[builtins.bool] = None,
                 iam_certificate_id: Optional[builtins.str] = None,
                 minimum_protocol_version: Optional[builtins.str] = None,
                 ssl_support_method: Optional[builtins.str] = None):
        """
        A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
         If the distribution doesn't use ``Aliases`` (also known as alternate domain names or CNAMEs)—that is, if the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net``—set ``CloudFrontDefaultCertificate`` to ``true`` and leave all other fields empty.
         If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), use the fields in this type to specify the following settings:
          +  Which viewers the distribution accepts HTTPS connections from: only viewers that support [server name indication (SNI)](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Server_Name_Indication) (recommended), or all viewers including those that don't support SNI.
          +  To accept HTTPS connections from only viewers that support SNI, set ``SSLSupportMethod`` to ``sni-only``. This is recommended. Most browsers and clients support SNI. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
          +  To accept HTTPS connections from all viewers, including those that don't support SNI, set ``SSLSupportMethod`` to ``vip``. This is not recommended, and results in additional monthly charges from CloudFront. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
          
          +  The minimum SSL/TLS protocol version that the distribution can use to communicate with viewers. To specify a minimum version, choose a value for ``MinimumProtocolVersion``. For more information, see [Security Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy) in the *Amazon CloudFront Developer Guide*.
          +  The location of the SSL/TLS certificate, [(ACM)](https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html) (recommended) or [(IAM)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html). You specify the location by setting a value in one of the following fields (not both):
          +  ``ACMCertificateArn`` (In CloudFormation, this field name is ``AcmCertificateArn``. Note the different capitalization.)
          +  ``IAMCertificateId`` (In CloudFormation, this field name is ``IamCertificateId``. Note the different capitalization.)
          
          
         All distributions support HTTPS connections from viewers. To require viewers to use HTTPS only, or to redirect them from HTTP to HTTPS, use ``ViewerProtocolPolicy`` in the ``CacheBehavior`` or ``DefaultCacheBehavior``. To specify how CloudFront should use SSL/TLS to communicate with your custom origin, use ``CustomOriginConfig``.
         For more information, see [Using HTTPS with CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https.html) and [Using Alternate Domain Names and HTTPS](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-alternate-domain-names.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.str acm_certificate_arn: In CloudFormation, this field name is ``AcmCertificateArn``. Note the different capitalization.
                 If the distribution uses ``Aliases`` (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in [(ACM)](https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html), provide the Amazon Resource Name (ARN) of the ACM certificate. CloudFront only supports ACM certificates in the US East (N. Virginia) Region (``us-east-1``).
                If you specify an ACM certificate ARN, you must also specify values for ``MinimumProtocolVersion`` and ``SSLSupportMethod``. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
        :param builtins.bool cloud_front_default_certificate: If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net``, set this field to ``true``.
                If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), omit this field and specify values for the following fields:
                 +  ``AcmCertificateArn`` or ``IamCertificateId`` (specify a value for one, not both) 
                 +   ``MinimumProtocolVersion`` 
                 +   ``SslSupportMethod``
        :param builtins.str iam_certificate_id: In CloudFormation, this field name is ``IamCertificateId``. Note the different capitalization.
                 If the distribution uses ``Aliases`` (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in [(IAM)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html), provide the ID of the IAM certificate.
                If you specify an IAM certificate ID, you must also specify values for ``MinimumProtocolVersion`` and ``SSLSupportMethod``. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
        :param builtins.str minimum_protocol_version: If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), specify the security policy that you want CloudFront to use for HTTPS connections with viewers. The security policy determines two settings:
                 +  The minimum SSL/TLS protocol that CloudFront can use to communicate with viewers.
                 +  The ciphers that CloudFront can use to encrypt the content that it returns to viewers.
                 
                For more information, see [Security Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy) and [Supported Protocols and Ciphers Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html#secure-connections-supported-ciphers) in the *Amazon CloudFront Developer Guide*.
                 On the CloudFront console, this setting is called *Security Policy*.
                 When you're using SNI only (you set ``SSLSupportMethod`` to ``sni-only``), you must specify ``TLSv1`` or higher. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
                If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net`` (you set ``CloudFrontDefaultCertificate`` to ``true``), CloudFront automatically sets the security policy to ``TLSv1`` regardless of the value that you set here.
        :param builtins.str ssl_support_method: In CloudFormation, this field name is ``SslSupportMethod``. Note the different capitalization.
                 If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), specify which viewers the distribution accepts HTTPS connections from.
                 +  ``sni-only`` – The distribution accepts HTTPS connections from only viewers that support [server name indication (SNI)](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Server_Name_Indication). This is recommended. Most browsers and clients support SNI.
                 +  ``vip`` – The distribution accepts HTTPS connections from all viewers including those that don't support SNI. This is not recommended, and results in additional monthly charges from CloudFront.
                 +  ``static-ip`` - Do not specify this value unless your distribution has been enabled for this feature by the CloudFront team. If you have a use case that requires static IP addresses for a distribution, contact CloudFront through the [Center](https://docs.aws.amazon.com/support/home).
                 
                If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net``, don't set a value for this field.
        """
        if acm_certificate_arn is not None:
            pulumi.set(__self__, "acm_certificate_arn", acm_certificate_arn)
        if cloud_front_default_certificate is not None:
            pulumi.set(__self__, "cloud_front_default_certificate", cloud_front_default_certificate)
        if iam_certificate_id is not None:
            pulumi.set(__self__, "iam_certificate_id", iam_certificate_id)
        if minimum_protocol_version is not None:
            pulumi.set(__self__, "minimum_protocol_version", minimum_protocol_version)
        if ssl_support_method is not None:
            pulumi.set(__self__, "ssl_support_method", ssl_support_method)

    @property
    @pulumi.getter(name="acmCertificateArn")
    def acm_certificate_arn(self) -> Optional[builtins.str]:
        """
        In CloudFormation, this field name is ``AcmCertificateArn``. Note the different capitalization.
          If the distribution uses ``Aliases`` (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in [(ACM)](https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html), provide the Amazon Resource Name (ARN) of the ACM certificate. CloudFront only supports ACM certificates in the US East (N. Virginia) Region (``us-east-1``).
         If you specify an ACM certificate ARN, you must also specify values for ``MinimumProtocolVersion`` and ``SSLSupportMethod``. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
        """
        return pulumi.get(self, "acm_certificate_arn")

    @property
    @pulumi.getter(name="cloudFrontDefaultCertificate")
    def cloud_front_default_certificate(self) -> Optional[builtins.bool]:
        """
        If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net``, set this field to ``true``.
         If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), omit this field and specify values for the following fields:
          +  ``AcmCertificateArn`` or ``IamCertificateId`` (specify a value for one, not both) 
          +   ``MinimumProtocolVersion`` 
          +   ``SslSupportMethod``
        """
        return pulumi.get(self, "cloud_front_default_certificate")

    @property
    @pulumi.getter(name="iamCertificateId")
    def iam_certificate_id(self) -> Optional[builtins.str]:
        """
        In CloudFormation, this field name is ``IamCertificateId``. Note the different capitalization.
          If the distribution uses ``Aliases`` (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in [(IAM)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html), provide the ID of the IAM certificate.
         If you specify an IAM certificate ID, you must also specify values for ``MinimumProtocolVersion`` and ``SSLSupportMethod``. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
        """
        return pulumi.get(self, "iam_certificate_id")

    @property
    @pulumi.getter(name="minimumProtocolVersion")
    def minimum_protocol_version(self) -> Optional[builtins.str]:
        """
        If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), specify the security policy that you want CloudFront to use for HTTPS connections with viewers. The security policy determines two settings:
          +  The minimum SSL/TLS protocol that CloudFront can use to communicate with viewers.
          +  The ciphers that CloudFront can use to encrypt the content that it returns to viewers.
          
         For more information, see [Security Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy) and [Supported Protocols and Ciphers Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html#secure-connections-supported-ciphers) in the *Amazon CloudFront Developer Guide*.
          On the CloudFront console, this setting is called *Security Policy*.
          When you're using SNI only (you set ``SSLSupportMethod`` to ``sni-only``), you must specify ``TLSv1`` or higher. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
         If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net`` (you set ``CloudFrontDefaultCertificate`` to ``true``), CloudFront automatically sets the security policy to ``TLSv1`` regardless of the value that you set here.
        """
        return pulumi.get(self, "minimum_protocol_version")

    @property
    @pulumi.getter(name="sslSupportMethod")
    def ssl_support_method(self) -> Optional[builtins.str]:
        """
        In CloudFormation, this field name is ``SslSupportMethod``. Note the different capitalization.
          If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), specify which viewers the distribution accepts HTTPS connections from.
          +  ``sni-only`` – The distribution accepts HTTPS connections from only viewers that support [server name indication (SNI)](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Server_Name_Indication). This is recommended. Most browsers and clients support SNI.
          +  ``vip`` – The distribution accepts HTTPS connections from all viewers including those that don't support SNI. This is not recommended, and results in additional monthly charges from CloudFront.
          +  ``static-ip`` - Do not specify this value unless your distribution has been enabled for this feature by the CloudFront team. If you have a use case that requires static IP addresses for a distribution, contact CloudFront through the [Center](https://docs.aws.amazon.com/support/home).
          
         If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net``, don't set a value for this field.
        """
        return pulumi.get(self, "ssl_support_method")


@pulumi.output_type
class DistributionVpcOriginConfig(dict):
    """
    An Amazon CloudFront VPC origin configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcOriginId":
            suggest = "vpc_origin_id"
        elif key == "originKeepaliveTimeout":
            suggest = "origin_keepalive_timeout"
        elif key == "originReadTimeout":
            suggest = "origin_read_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionVpcOriginConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionVpcOriginConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionVpcOriginConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_origin_id: builtins.str,
                 origin_keepalive_timeout: Optional[builtins.int] = None,
                 origin_read_timeout: Optional[builtins.int] = None):
        """
        An Amazon CloudFront VPC origin configuration.
        :param builtins.str vpc_origin_id: The VPC origin ID.
        :param builtins.int origin_keepalive_timeout: Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 5 seconds.
                For more information, see [Keep-alive timeout (custom origins only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout) in the *Amazon CloudFront Developer Guide*.
        :param builtins.int origin_read_timeout: Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as the *origin response timeout*. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 30 seconds.
                For more information, see [Response timeout (custom origins only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout) in the *Amazon CloudFront Developer Guide*.
        """
        pulumi.set(__self__, "vpc_origin_id", vpc_origin_id)
        if origin_keepalive_timeout is not None:
            pulumi.set(__self__, "origin_keepalive_timeout", origin_keepalive_timeout)
        if origin_read_timeout is not None:
            pulumi.set(__self__, "origin_read_timeout", origin_read_timeout)

    @property
    @pulumi.getter(name="vpcOriginId")
    def vpc_origin_id(self) -> builtins.str:
        """
        The VPC origin ID.
        """
        return pulumi.get(self, "vpc_origin_id")

    @property
    @pulumi.getter(name="originKeepaliveTimeout")
    def origin_keepalive_timeout(self) -> Optional[builtins.int]:
        """
        Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 5 seconds.
         For more information, see [Keep-alive timeout (custom origins only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_keepalive_timeout")

    @property
    @pulumi.getter(name="originReadTimeout")
    def origin_read_timeout(self) -> Optional[builtins.int]:
        """
        Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as the *origin response timeout*. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 30 seconds.
         For more information, see [Response timeout (custom origins only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_read_timeout")


@pulumi.output_type
class FunctionConfig(dict):
    """
    Contains configuration information about a CloudFront function.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyValueStoreAssociations":
            suggest = "key_value_store_associations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comment: builtins.str,
                 runtime: builtins.str,
                 key_value_store_associations: Optional[Sequence['outputs.FunctionKeyValueStoreAssociation']] = None):
        """
        Contains configuration information about a CloudFront function.
        :param builtins.str comment: A comment to describe the function.
        :param builtins.str runtime: The function's runtime environment version.
        :param Sequence['FunctionKeyValueStoreAssociation'] key_value_store_associations: The configuration for the key value store associations.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "runtime", runtime)
        if key_value_store_associations is not None:
            pulumi.set(__self__, "key_value_store_associations", key_value_store_associations)

    @property
    @pulumi.getter
    def comment(self) -> builtins.str:
        """
        A comment to describe the function.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def runtime(self) -> builtins.str:
        """
        The function's runtime environment version.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="keyValueStoreAssociations")
    def key_value_store_associations(self) -> Optional[Sequence['outputs.FunctionKeyValueStoreAssociation']]:
        """
        The configuration for the key value store associations.
        """
        return pulumi.get(self, "key_value_store_associations")


@pulumi.output_type
class FunctionKeyValueStoreAssociation(dict):
    """
    The key value store association.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyValueStoreArn":
            suggest = "key_value_store_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionKeyValueStoreAssociation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionKeyValueStoreAssociation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionKeyValueStoreAssociation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_value_store_arn: builtins.str):
        """
        The key value store association.
        :param builtins.str key_value_store_arn: The Amazon Resource Name (ARN) of the key value store association.
        """
        pulumi.set(__self__, "key_value_store_arn", key_value_store_arn)

    @property
    @pulumi.getter(name="keyValueStoreArn")
    def key_value_store_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the key value store association.
        """
        return pulumi.get(self, "key_value_store_arn")


@pulumi.output_type
class FunctionMetadata(dict):
    """
    Contains metadata about a CloudFront function.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionArn":
            suggest = "function_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_arn: Optional[builtins.str] = None):
        """
        Contains metadata about a CloudFront function.
        :param builtins.str function_arn: The Amazon Resource Name (ARN) of the function. The ARN uniquely identifies the function.
        """
        if function_arn is not None:
            pulumi.set(__self__, "function_arn", function_arn)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the function. The ARN uniquely identifies the function.
        """
        return pulumi.get(self, "function_arn")


@pulumi.output_type
class KeyGroupConfig(dict):
    """
    A key group configuration.
     A key group contains a list of public keys that you can use with [CloudFront signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html).
    """
    def __init__(__self__, *,
                 items: Sequence[builtins.str],
                 name: builtins.str,
                 comment: Optional[builtins.str] = None):
        """
        A key group configuration.
         A key group contains a list of public keys that you can use with [CloudFront signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html).
        :param Sequence[builtins.str] items: A list of the identifiers of the public keys in the key group.
        :param builtins.str name: A name to identify the key group.
        :param builtins.str comment: A comment to describe the key group. The comment cannot be longer than 128 characters.
        """
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter
    def items(self) -> Sequence[builtins.str]:
        """
        A list of the identifiers of the public keys in the key group.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A name to identify the key group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[builtins.str]:
        """
        A comment to describe the key group. The comment cannot be longer than 128 characters.
        """
        return pulumi.get(self, "comment")


@pulumi.output_type
class KeyValueStoreImportSource(dict):
    """
    The import source for the key value store.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceArn":
            suggest = "source_arn"
        elif key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyValueStoreImportSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyValueStoreImportSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyValueStoreImportSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_arn: builtins.str,
                 source_type: builtins.str):
        """
        The import source for the key value store.
        :param builtins.str source_arn: The Amazon Resource Name (ARN) of the import source for the key value store.
        :param builtins.str source_type: The source type of the import source for the key value store.
        """
        pulumi.set(__self__, "source_arn", source_arn)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the import source for the key value store.
        """
        return pulumi.get(self, "source_arn")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> builtins.str:
        """
        The source type of the import source for the key value store.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class MonitoringSubscription(dict):
    """
    A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "realtimeMetricsSubscriptionConfig":
            suggest = "realtime_metrics_subscription_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringSubscription. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringSubscription.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringSubscription.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 realtime_metrics_subscription_config: Optional['outputs.MonitoringSubscriptionRealtimeMetricsSubscriptionConfig'] = None):
        """
        A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
        :param 'MonitoringSubscriptionRealtimeMetricsSubscriptionConfig' realtime_metrics_subscription_config: A subscription configuration for additional CloudWatch metrics.
        """
        if realtime_metrics_subscription_config is not None:
            pulumi.set(__self__, "realtime_metrics_subscription_config", realtime_metrics_subscription_config)

    @property
    @pulumi.getter(name="realtimeMetricsSubscriptionConfig")
    def realtime_metrics_subscription_config(self) -> Optional['outputs.MonitoringSubscriptionRealtimeMetricsSubscriptionConfig']:
        """
        A subscription configuration for additional CloudWatch metrics.
        """
        return pulumi.get(self, "realtime_metrics_subscription_config")


@pulumi.output_type
class MonitoringSubscriptionRealtimeMetricsSubscriptionConfig(dict):
    """
    A subscription configuration for additional CloudWatch metrics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "realtimeMetricsSubscriptionStatus":
            suggest = "realtime_metrics_subscription_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringSubscriptionRealtimeMetricsSubscriptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringSubscriptionRealtimeMetricsSubscriptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringSubscriptionRealtimeMetricsSubscriptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 realtime_metrics_subscription_status: 'MonitoringSubscriptionRealtimeMetricsSubscriptionConfigRealtimeMetricsSubscriptionStatus'):
        """
        A subscription configuration for additional CloudWatch metrics.
        :param 'MonitoringSubscriptionRealtimeMetricsSubscriptionConfigRealtimeMetricsSubscriptionStatus' realtime_metrics_subscription_status: A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
        """
        pulumi.set(__self__, "realtime_metrics_subscription_status", realtime_metrics_subscription_status)

    @property
    @pulumi.getter(name="realtimeMetricsSubscriptionStatus")
    def realtime_metrics_subscription_status(self) -> 'MonitoringSubscriptionRealtimeMetricsSubscriptionConfigRealtimeMetricsSubscriptionStatus':
        """
        A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
        """
        return pulumi.get(self, "realtime_metrics_subscription_status")


@pulumi.output_type
class OriginAccessControlConfig(dict):
    """
    Creates a new origin access control in CloudFront. After you create an origin access control, you can add it to an origin in a CloudFront distribution so that CloudFront sends authenticated (signed) requests to the origin.
     This makes it possible to block public access to the origin, allowing viewers (users) to access the origin's content only through CloudFront.
     For more information about using a CloudFront origin access control, see [Restricting access to an origin](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html) in the *Amazon CloudFront Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "originAccessControlOriginType":
            suggest = "origin_access_control_origin_type"
        elif key == "signingBehavior":
            suggest = "signing_behavior"
        elif key == "signingProtocol":
            suggest = "signing_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginAccessControlConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginAccessControlConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginAccessControlConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 origin_access_control_origin_type: builtins.str,
                 signing_behavior: builtins.str,
                 signing_protocol: builtins.str,
                 description: Optional[builtins.str] = None):
        """
        Creates a new origin access control in CloudFront. After you create an origin access control, you can add it to an origin in a CloudFront distribution so that CloudFront sends authenticated (signed) requests to the origin.
         This makes it possible to block public access to the origin, allowing viewers (users) to access the origin's content only through CloudFront.
         For more information about using a CloudFront origin access control, see [Restricting access to an origin](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html) in the *Amazon CloudFront Developer Guide*.
        :param builtins.str name: A name to identify the origin access control. You can specify up to 64 characters.
        :param builtins.str origin_access_control_origin_type: The type of origin that this origin access control is for.
        :param builtins.str signing_behavior: Specifies which requests CloudFront signs (adds authentication information to). Specify ``always`` for the most common use case. For more information, see [origin access control advanced settings](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html#oac-advanced-settings) in the *Amazon CloudFront Developer Guide*.
                This field can have one of the following values:
                 +  ``always`` – CloudFront signs all origin requests, overwriting the ``Authorization`` header from the viewer request if one exists.
                 +  ``never`` – CloudFront doesn't sign any origin requests. This value turns off origin access control for all origins in all distributions that use this origin access control.
                 +  ``no-override`` – If the viewer request doesn't contain the ``Authorization`` header, then CloudFront signs the origin request. If the viewer request contains the ``Authorization`` header, then CloudFront doesn't sign the origin request and instead passes along the ``Authorization`` header from the viewer request. *WARNING: To pass along the Authorization header from the viewer request, you must add the Authorization header to a cache policy for all cache behaviors that use origins associated with this origin access control.*
        :param builtins.str signing_protocol: The signing protocol of the origin access control, which determines how CloudFront signs (authenticates) requests. The only valid value is ``sigv4``.
        :param builtins.str description: A description of the origin access control.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "origin_access_control_origin_type", origin_access_control_origin_type)
        pulumi.set(__self__, "signing_behavior", signing_behavior)
        pulumi.set(__self__, "signing_protocol", signing_protocol)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A name to identify the origin access control. You can specify up to 64 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="originAccessControlOriginType")
    def origin_access_control_origin_type(self) -> builtins.str:
        """
        The type of origin that this origin access control is for.
        """
        return pulumi.get(self, "origin_access_control_origin_type")

    @property
    @pulumi.getter(name="signingBehavior")
    def signing_behavior(self) -> builtins.str:
        """
        Specifies which requests CloudFront signs (adds authentication information to). Specify ``always`` for the most common use case. For more information, see [origin access control advanced settings](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html#oac-advanced-settings) in the *Amazon CloudFront Developer Guide*.
         This field can have one of the following values:
          +  ``always`` – CloudFront signs all origin requests, overwriting the ``Authorization`` header from the viewer request if one exists.
          +  ``never`` – CloudFront doesn't sign any origin requests. This value turns off origin access control for all origins in all distributions that use this origin access control.
          +  ``no-override`` – If the viewer request doesn't contain the ``Authorization`` header, then CloudFront signs the origin request. If the viewer request contains the ``Authorization`` header, then CloudFront doesn't sign the origin request and instead passes along the ``Authorization`` header from the viewer request. *WARNING: To pass along the Authorization header from the viewer request, you must add the Authorization header to a cache policy for all cache behaviors that use origins associated with this origin access control.*
        """
        return pulumi.get(self, "signing_behavior")

    @property
    @pulumi.getter(name="signingProtocol")
    def signing_protocol(self) -> builtins.str:
        """
        The signing protocol of the origin access control, which determines how CloudFront signs (authenticates) requests. The only valid value is ``sigv4``.
        """
        return pulumi.get(self, "signing_protocol")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description of the origin access control.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class OriginRequestPolicyConfig(dict):
    """
    An origin request policy configuration.
     This configuration determines the values that CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends to the origin includes the following:
      +  The request body and the URL path (without the domain name) from the viewer request.
      +  The headers that CloudFront automatically includes in every origin request, including ``Host``, ``User-Agent``, and ``X-Amz-Cf-Id``.
      +  All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request policy. These can include items from the viewer request and, in the case of headers, additional ones that are added by CloudFront.
      
     CloudFront sends a request when it can't find an object in its cache that matches the request. If you want to send values to the origin and also include them in the cache key, use ``CachePolicy``.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookiesConfig":
            suggest = "cookies_config"
        elif key == "headersConfig":
            suggest = "headers_config"
        elif key == "queryStringsConfig":
            suggest = "query_strings_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginRequestPolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginRequestPolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginRequestPolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookies_config: 'outputs.OriginRequestPolicyCookiesConfig',
                 headers_config: 'outputs.OriginRequestPolicyHeadersConfig',
                 name: builtins.str,
                 query_strings_config: 'outputs.OriginRequestPolicyQueryStringsConfig',
                 comment: Optional[builtins.str] = None):
        """
        An origin request policy configuration.
         This configuration determines the values that CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends to the origin includes the following:
          +  The request body and the URL path (without the domain name) from the viewer request.
          +  The headers that CloudFront automatically includes in every origin request, including ``Host``, ``User-Agent``, and ``X-Amz-Cf-Id``.
          +  All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request policy. These can include items from the viewer request and, in the case of headers, additional ones that are added by CloudFront.
          
         CloudFront sends a request when it can't find an object in its cache that matches the request. If you want to send values to the origin and also include them in the cache key, use ``CachePolicy``.
        :param 'OriginRequestPolicyCookiesConfig' cookies_config: The cookies from viewer requests to include in origin requests.
        :param 'OriginRequestPolicyHeadersConfig' headers_config: The HTTP headers to include in origin requests. These can include headers from viewer requests and additional headers added by CloudFront.
        :param builtins.str name: A unique name to identify the origin request policy.
        :param 'OriginRequestPolicyQueryStringsConfig' query_strings_config: The URL query strings from viewer requests to include in origin requests.
        :param builtins.str comment: A comment to describe the origin request policy. The comment cannot be longer than 128 characters.
        """
        pulumi.set(__self__, "cookies_config", cookies_config)
        pulumi.set(__self__, "headers_config", headers_config)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "query_strings_config", query_strings_config)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter(name="cookiesConfig")
    def cookies_config(self) -> 'outputs.OriginRequestPolicyCookiesConfig':
        """
        The cookies from viewer requests to include in origin requests.
        """
        return pulumi.get(self, "cookies_config")

    @property
    @pulumi.getter(name="headersConfig")
    def headers_config(self) -> 'outputs.OriginRequestPolicyHeadersConfig':
        """
        The HTTP headers to include in origin requests. These can include headers from viewer requests and additional headers added by CloudFront.
        """
        return pulumi.get(self, "headers_config")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify the origin request policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="queryStringsConfig")
    def query_strings_config(self) -> 'outputs.OriginRequestPolicyQueryStringsConfig':
        """
        The URL query strings from viewer requests to include in origin requests.
        """
        return pulumi.get(self, "query_strings_config")

    @property
    @pulumi.getter
    def comment(self) -> Optional[builtins.str]:
        """
        A comment to describe the origin request policy. The comment cannot be longer than 128 characters.
        """
        return pulumi.get(self, "comment")


@pulumi.output_type
class OriginRequestPolicyCookiesConfig(dict):
    """
    An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in requests that CloudFront sends to the origin.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieBehavior":
            suggest = "cookie_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginRequestPolicyCookiesConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginRequestPolicyCookiesConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginRequestPolicyCookiesConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookie_behavior: builtins.str,
                 cookies: Optional[Sequence[builtins.str]] = None):
        """
        An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in requests that CloudFront sends to the origin.
        :param builtins.str cookie_behavior: Determines whether cookies in viewer requests are included in requests that CloudFront sends to the origin. Valid values are:
                 +  ``none`` – No cookies in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any cookies that are listed in a ``CachePolicy``*are* included in origin requests.
                 +  ``whitelist`` – Only the cookies in viewer requests that are listed in the ``CookieNames`` type are included in requests that CloudFront sends to the origin.
                 +  ``all`` – All cookies in viewer requests are included in requests that CloudFront sends to the origin.
                 +  ``allExcept`` – All cookies in viewer requests are included in requests that CloudFront sends to the origin, *except* for those listed in the ``CookieNames`` type, which are not included.
        :param Sequence[builtins.str] cookies: Contains a list of cookie names.
        """
        pulumi.set(__self__, "cookie_behavior", cookie_behavior)
        if cookies is not None:
            pulumi.set(__self__, "cookies", cookies)

    @property
    @pulumi.getter(name="cookieBehavior")
    def cookie_behavior(self) -> builtins.str:
        """
        Determines whether cookies in viewer requests are included in requests that CloudFront sends to the origin. Valid values are:
          +  ``none`` – No cookies in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any cookies that are listed in a ``CachePolicy``*are* included in origin requests.
          +  ``whitelist`` – Only the cookies in viewer requests that are listed in the ``CookieNames`` type are included in requests that CloudFront sends to the origin.
          +  ``all`` – All cookies in viewer requests are included in requests that CloudFront sends to the origin.
          +  ``allExcept`` – All cookies in viewer requests are included in requests that CloudFront sends to the origin, *except* for those listed in the ``CookieNames`` type, which are not included.
        """
        return pulumi.get(self, "cookie_behavior")

    @property
    @pulumi.getter
    def cookies(self) -> Optional[Sequence[builtins.str]]:
        """
        Contains a list of cookie names.
        """
        return pulumi.get(self, "cookies")


@pulumi.output_type
class OriginRequestPolicyHeadersConfig(dict):
    """
    An object that determines whether any HTTP headers (and if so, which headers) are included in requests that CloudFront sends to the origin.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerBehavior":
            suggest = "header_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginRequestPolicyHeadersConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginRequestPolicyHeadersConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginRequestPolicyHeadersConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_behavior: builtins.str,
                 headers: Optional[Sequence[builtins.str]] = None):
        """
        An object that determines whether any HTTP headers (and if so, which headers) are included in requests that CloudFront sends to the origin.
        :param builtins.str header_behavior: Determines whether any HTTP headers are included in requests that CloudFront sends to the origin. Valid values are:
                 +  ``none`` – No HTTP headers in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any headers that are listed in a ``CachePolicy``*are* included in origin requests.
                 +  ``whitelist`` – Only the HTTP headers that are listed in the ``Headers`` type are included in requests that CloudFront sends to the origin.
                 +  ``allViewer`` – All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin.
                 +  ``allViewerAndWhitelistCloudFront`` – All HTTP headers in viewer requests and the additional CloudFront headers that are listed in the ``Headers`` type are included in requests that CloudFront sends to the origin. The additional headers are added by CloudFront.
                 +  ``allExcept`` – All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin, *except* for those listed in the ``Headers`` type, which are not included.
        :param Sequence[builtins.str] headers: Contains a list of HTTP header names.
        """
        pulumi.set(__self__, "header_behavior", header_behavior)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)

    @property
    @pulumi.getter(name="headerBehavior")
    def header_behavior(self) -> builtins.str:
        """
        Determines whether any HTTP headers are included in requests that CloudFront sends to the origin. Valid values are:
          +  ``none`` – No HTTP headers in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any headers that are listed in a ``CachePolicy``*are* included in origin requests.
          +  ``whitelist`` – Only the HTTP headers that are listed in the ``Headers`` type are included in requests that CloudFront sends to the origin.
          +  ``allViewer`` – All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin.
          +  ``allViewerAndWhitelistCloudFront`` – All HTTP headers in viewer requests and the additional CloudFront headers that are listed in the ``Headers`` type are included in requests that CloudFront sends to the origin. The additional headers are added by CloudFront.
          +  ``allExcept`` – All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin, *except* for those listed in the ``Headers`` type, which are not included.
        """
        return pulumi.get(self, "header_behavior")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence[builtins.str]]:
        """
        Contains a list of HTTP header names.
        """
        return pulumi.get(self, "headers")


@pulumi.output_type
class OriginRequestPolicyQueryStringsConfig(dict):
    """
    An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in requests that CloudFront sends to the origin.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryStringBehavior":
            suggest = "query_string_behavior"
        elif key == "queryStrings":
            suggest = "query_strings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginRequestPolicyQueryStringsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginRequestPolicyQueryStringsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginRequestPolicyQueryStringsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_string_behavior: builtins.str,
                 query_strings: Optional[Sequence[builtins.str]] = None):
        """
        An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in requests that CloudFront sends to the origin.
        :param builtins.str query_string_behavior: Determines whether any URL query strings in viewer requests are included in requests that CloudFront sends to the origin. Valid values are:
                 +  ``none`` – No query strings in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any query strings that are listed in a ``CachePolicy``*are* included in origin requests.
                 +  ``whitelist`` – Only the query strings in viewer requests that are listed in the ``QueryStringNames`` type are included in requests that CloudFront sends to the origin.
                 +  ``all`` – All query strings in viewer requests are included in requests that CloudFront sends to the origin.
                 +  ``allExcept`` – All query strings in viewer requests are included in requests that CloudFront sends to the origin, *except* for those listed in the ``QueryStringNames`` type, which are not included.
        :param Sequence[builtins.str] query_strings: Contains a list of query string names.
        """
        pulumi.set(__self__, "query_string_behavior", query_string_behavior)
        if query_strings is not None:
            pulumi.set(__self__, "query_strings", query_strings)

    @property
    @pulumi.getter(name="queryStringBehavior")
    def query_string_behavior(self) -> builtins.str:
        """
        Determines whether any URL query strings in viewer requests are included in requests that CloudFront sends to the origin. Valid values are:
          +  ``none`` – No query strings in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any query strings that are listed in a ``CachePolicy``*are* included in origin requests.
          +  ``whitelist`` – Only the query strings in viewer requests that are listed in the ``QueryStringNames`` type are included in requests that CloudFront sends to the origin.
          +  ``all`` – All query strings in viewer requests are included in requests that CloudFront sends to the origin.
          +  ``allExcept`` – All query strings in viewer requests are included in requests that CloudFront sends to the origin, *except* for those listed in the ``QueryStringNames`` type, which are not included.
        """
        return pulumi.get(self, "query_string_behavior")

    @property
    @pulumi.getter(name="queryStrings")
    def query_strings(self) -> Optional[Sequence[builtins.str]]:
        """
        Contains a list of query string names.
        """
        return pulumi.get(self, "query_strings")


@pulumi.output_type
class PublicKeyConfig(dict):
    """
    Configuration information about a public key that you can use with [signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html), or with [field-level encryption](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callerReference":
            suggest = "caller_reference"
        elif key == "encodedKey":
            suggest = "encoded_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublicKeyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublicKeyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublicKeyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 caller_reference: builtins.str,
                 encoded_key: builtins.str,
                 name: builtins.str,
                 comment: Optional[builtins.str] = None):
        """
        Configuration information about a public key that you can use with [signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html), or with [field-level encryption](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
        :param builtins.str caller_reference: A string included in the request to help make sure that the request can't be replayed.
        :param builtins.str encoded_key: The public key that you can use with [signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html), or with [field-level encryption](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
        :param builtins.str name: A name to help identify the public key.
        :param builtins.str comment: A comment to describe the public key. The comment cannot be longer than 128 characters.
        """
        pulumi.set(__self__, "caller_reference", caller_reference)
        pulumi.set(__self__, "encoded_key", encoded_key)
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter(name="callerReference")
    def caller_reference(self) -> builtins.str:
        """
        A string included in the request to help make sure that the request can't be replayed.
        """
        return pulumi.get(self, "caller_reference")

    @property
    @pulumi.getter(name="encodedKey")
    def encoded_key(self) -> builtins.str:
        """
        The public key that you can use with [signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html), or with [field-level encryption](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
        """
        return pulumi.get(self, "encoded_key")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A name to help identify the public key.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[builtins.str]:
        """
        A comment to describe the public key. The comment cannot be longer than 128 characters.
        """
        return pulumi.get(self, "comment")


@pulumi.output_type
class RealtimeLogConfigEndPoint(dict):
    """
    Contains information about the Amazon Kinesis data stream where you are sending real-time log data for this real-time log configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kinesisStreamConfig":
            suggest = "kinesis_stream_config"
        elif key == "streamType":
            suggest = "stream_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RealtimeLogConfigEndPoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RealtimeLogConfigEndPoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RealtimeLogConfigEndPoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kinesis_stream_config: 'outputs.RealtimeLogConfigKinesisStreamConfig',
                 stream_type: builtins.str):
        """
        Contains information about the Amazon Kinesis data stream where you are sending real-time log data for this real-time log configuration.
        :param 'RealtimeLogConfigKinesisStreamConfig' kinesis_stream_config: Contains information about the Amazon Kinesis data stream where you are sending real-time log data in a real-time log configuration.
        :param builtins.str stream_type: The type of data stream where you are sending real-time log data. The only valid value is ``Kinesis``.
        """
        pulumi.set(__self__, "kinesis_stream_config", kinesis_stream_config)
        pulumi.set(__self__, "stream_type", stream_type)

    @property
    @pulumi.getter(name="kinesisStreamConfig")
    def kinesis_stream_config(self) -> 'outputs.RealtimeLogConfigKinesisStreamConfig':
        """
        Contains information about the Amazon Kinesis data stream where you are sending real-time log data in a real-time log configuration.
        """
        return pulumi.get(self, "kinesis_stream_config")

    @property
    @pulumi.getter(name="streamType")
    def stream_type(self) -> builtins.str:
        """
        The type of data stream where you are sending real-time log data. The only valid value is ``Kinesis``.
        """
        return pulumi.get(self, "stream_type")


@pulumi.output_type
class RealtimeLogConfigKinesisStreamConfig(dict):
    """
    Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "streamArn":
            suggest = "stream_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RealtimeLogConfigKinesisStreamConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RealtimeLogConfigKinesisStreamConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RealtimeLogConfigKinesisStreamConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: builtins.str,
                 stream_arn: builtins.str):
        """
        Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
        :param builtins.str role_arn: The Amazon Resource Name (ARN) of an IAMlong (IAM) role that CloudFront can use to send real-time log data to your Kinesis data stream.
                For more information the IAM role, see [Real-time log configuration IAM role](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role) in the *Amazon CloudFront Developer Guide*.
        :param builtins.str stream_arn: The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending real-time log data.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "stream_arn", stream_arn)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of an IAMlong (IAM) role that CloudFront can use to send real-time log data to your Kinesis data stream.
         For more information the IAM role, see [Real-time log configuration IAM role](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending real-time log data.
        """
        return pulumi.get(self, "stream_arn")


@pulumi.output_type
class ResponseHeadersPolicyAccessControlAllowHeaders(dict):
    """
    A list of HTTP header names that CloudFront includes as values for the ``Access-Control-Allow-Headers`` HTTP response header.
     For more information about the ``Access-Control-Allow-Headers`` HTTP response header, see [Access-Control-Allow-Headers](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers) in the MDN Web Docs.
    """
    def __init__(__self__, *,
                 items: Sequence[builtins.str]):
        """
        A list of HTTP header names that CloudFront includes as values for the ``Access-Control-Allow-Headers`` HTTP response header.
         For more information about the ``Access-Control-Allow-Headers`` HTTP response header, see [Access-Control-Allow-Headers](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers) in the MDN Web Docs.
        :param Sequence[builtins.str] items: The list of HTTP header names. You can specify ``*`` to allow all headers.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence[builtins.str]:
        """
        The list of HTTP header names. You can specify ``*`` to allow all headers.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ResponseHeadersPolicyAccessControlAllowMethods(dict):
    """
    A list of HTTP methods that CloudFront includes as values for the ``Access-Control-Allow-Methods`` HTTP response header.
     For more information about the ``Access-Control-Allow-Methods`` HTTP response header, see [Access-Control-Allow-Methods](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods) in the MDN Web Docs.
    """
    def __init__(__self__, *,
                 items: Sequence[builtins.str]):
        """
        A list of HTTP methods that CloudFront includes as values for the ``Access-Control-Allow-Methods`` HTTP response header.
         For more information about the ``Access-Control-Allow-Methods`` HTTP response header, see [Access-Control-Allow-Methods](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods) in the MDN Web Docs.
        :param Sequence[builtins.str] items: The list of HTTP methods. Valid values are:
                 +   ``GET`` 
                 +   ``DELETE`` 
                 +   ``HEAD`` 
                 +   ``OPTIONS`` 
                 +   ``PATCH`` 
                 +   ``POST`` 
                 +   ``PUT`` 
                 +   ``ALL`` 
                 
                ``ALL`` is a special value that includes all of the listed HTTP methods.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence[builtins.str]:
        """
        The list of HTTP methods. Valid values are:
          +   ``GET`` 
          +   ``DELETE`` 
          +   ``HEAD`` 
          +   ``OPTIONS`` 
          +   ``PATCH`` 
          +   ``POST`` 
          +   ``PUT`` 
          +   ``ALL`` 
          
         ``ALL`` is a special value that includes all of the listed HTTP methods.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ResponseHeadersPolicyAccessControlAllowOrigins(dict):
    """
    A list of origins (domain names) that CloudFront can use as the value for the ``Access-Control-Allow-Origin`` HTTP response header.
     For more information about the ``Access-Control-Allow-Origin`` HTTP response header, see [Access-Control-Allow-Origin](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin) in the MDN Web Docs.
    """
    def __init__(__self__, *,
                 items: Sequence[builtins.str]):
        """
        A list of origins (domain names) that CloudFront can use as the value for the ``Access-Control-Allow-Origin`` HTTP response header.
         For more information about the ``Access-Control-Allow-Origin`` HTTP response header, see [Access-Control-Allow-Origin](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin) in the MDN Web Docs.
        :param Sequence[builtins.str] items: The list of origins (domain names). You can specify ``*`` to allow all origins.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence[builtins.str]:
        """
        The list of origins (domain names). You can specify ``*`` to allow all origins.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ResponseHeadersPolicyAccessControlExposeHeaders(dict):
    """
    A list of HTTP headers that CloudFront includes as values for the ``Access-Control-Expose-Headers`` HTTP response header.
     For more information about the ``Access-Control-Expose-Headers`` HTTP response header, see [Access-Control-Expose-Headers](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers) in the MDN Web Docs.
    """
    def __init__(__self__, *,
                 items: Sequence[builtins.str]):
        """
        A list of HTTP headers that CloudFront includes as values for the ``Access-Control-Expose-Headers`` HTTP response header.
         For more information about the ``Access-Control-Expose-Headers`` HTTP response header, see [Access-Control-Expose-Headers](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers) in the MDN Web Docs.
        :param Sequence[builtins.str] items: The list of HTTP headers. You can specify ``*`` to expose all headers.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence[builtins.str]:
        """
        The list of HTTP headers. You can specify ``*`` to expose all headers.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ResponseHeadersPolicyConfig(dict):
    """
    A response headers policy configuration.
     A response headers policy configuration contains metadata about the response headers policy, and configurations for sets of HTTP response headers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "corsConfig":
            suggest = "cors_config"
        elif key == "customHeadersConfig":
            suggest = "custom_headers_config"
        elif key == "removeHeadersConfig":
            suggest = "remove_headers_config"
        elif key == "securityHeadersConfig":
            suggest = "security_headers_config"
        elif key == "serverTimingHeadersConfig":
            suggest = "server_timing_headers_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 comment: Optional[builtins.str] = None,
                 cors_config: Optional['outputs.ResponseHeadersPolicyCorsConfig'] = None,
                 custom_headers_config: Optional['outputs.ResponseHeadersPolicyCustomHeadersConfig'] = None,
                 remove_headers_config: Optional['outputs.ResponseHeadersPolicyRemoveHeadersConfig'] = None,
                 security_headers_config: Optional['outputs.ResponseHeadersPolicySecurityHeadersConfig'] = None,
                 server_timing_headers_config: Optional['outputs.ResponseHeadersPolicyServerTimingHeadersConfig'] = None):
        """
        A response headers policy configuration.
         A response headers policy configuration contains metadata about the response headers policy, and configurations for sets of HTTP response headers.
        :param builtins.str name: A name to identify the response headers policy.
                The name must be unique for response headers policies in this AWS-account.
        :param builtins.str comment: A comment to describe the response headers policy.
                The comment cannot be longer than 128 characters.
        :param 'ResponseHeadersPolicyCorsConfig' cors_config: A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS).
        :param 'ResponseHeadersPolicyCustomHeadersConfig' custom_headers_config: A configuration for a set of custom HTTP response headers.
        :param 'ResponseHeadersPolicyRemoveHeadersConfig' remove_headers_config: A configuration for a set of HTTP headers to remove from the HTTP response.
        :param 'ResponseHeadersPolicySecurityHeadersConfig' security_headers_config: A configuration for a set of security-related HTTP response headers.
        :param 'ResponseHeadersPolicyServerTimingHeadersConfig' server_timing_headers_config: A configuration for enabling the ``Server-Timing`` header in HTTP responses sent from CloudFront.
        """
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if cors_config is not None:
            pulumi.set(__self__, "cors_config", cors_config)
        if custom_headers_config is not None:
            pulumi.set(__self__, "custom_headers_config", custom_headers_config)
        if remove_headers_config is not None:
            pulumi.set(__self__, "remove_headers_config", remove_headers_config)
        if security_headers_config is not None:
            pulumi.set(__self__, "security_headers_config", security_headers_config)
        if server_timing_headers_config is not None:
            pulumi.set(__self__, "server_timing_headers_config", server_timing_headers_config)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A name to identify the response headers policy.
         The name must be unique for response headers policies in this AWS-account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[builtins.str]:
        """
        A comment to describe the response headers policy.
         The comment cannot be longer than 128 characters.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="corsConfig")
    def cors_config(self) -> Optional['outputs.ResponseHeadersPolicyCorsConfig']:
        """
        A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS).
        """
        return pulumi.get(self, "cors_config")

    @property
    @pulumi.getter(name="customHeadersConfig")
    def custom_headers_config(self) -> Optional['outputs.ResponseHeadersPolicyCustomHeadersConfig']:
        """
        A configuration for a set of custom HTTP response headers.
        """
        return pulumi.get(self, "custom_headers_config")

    @property
    @pulumi.getter(name="removeHeadersConfig")
    def remove_headers_config(self) -> Optional['outputs.ResponseHeadersPolicyRemoveHeadersConfig']:
        """
        A configuration for a set of HTTP headers to remove from the HTTP response.
        """
        return pulumi.get(self, "remove_headers_config")

    @property
    @pulumi.getter(name="securityHeadersConfig")
    def security_headers_config(self) -> Optional['outputs.ResponseHeadersPolicySecurityHeadersConfig']:
        """
        A configuration for a set of security-related HTTP response headers.
        """
        return pulumi.get(self, "security_headers_config")

    @property
    @pulumi.getter(name="serverTimingHeadersConfig")
    def server_timing_headers_config(self) -> Optional['outputs.ResponseHeadersPolicyServerTimingHeadersConfig']:
        """
        A configuration for enabling the ``Server-Timing`` header in HTTP responses sent from CloudFront.
        """
        return pulumi.get(self, "server_timing_headers_config")


@pulumi.output_type
class ResponseHeadersPolicyContentSecurityPolicy(dict):
    """
    The policy directives and their values that CloudFront includes as values for the ``Content-Security-Policy`` HTTP response header.
     For more information about the ``Content-Security-Policy`` HTTP response header, see [Content-Security-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy) in the MDN Web Docs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentSecurityPolicy":
            suggest = "content_security_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyContentSecurityPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyContentSecurityPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyContentSecurityPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_security_policy: builtins.str,
                 override: builtins.bool):
        """
        The policy directives and their values that CloudFront includes as values for the ``Content-Security-Policy`` HTTP response header.
         For more information about the ``Content-Security-Policy`` HTTP response header, see [Content-Security-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy) in the MDN Web Docs.
        :param builtins.str content_security_policy: The policy directives and their values that CloudFront includes as values for the ``Content-Security-Policy`` HTTP response header.
                For more information about the ``Content-Security-Policy`` HTTP response header, see [Content-Security-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy) in the MDN Web Docs.
        :param builtins.bool override: A Boolean that determines whether CloudFront overrides the ``Content-Security-Policy`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        pulumi.set(__self__, "content_security_policy", content_security_policy)
        pulumi.set(__self__, "override", override)

    @property
    @pulumi.getter(name="contentSecurityPolicy")
    def content_security_policy(self) -> builtins.str:
        """
        The policy directives and their values that CloudFront includes as values for the ``Content-Security-Policy`` HTTP response header.
         For more information about the ``Content-Security-Policy`` HTTP response header, see [Content-Security-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy) in the MDN Web Docs.
        """
        return pulumi.get(self, "content_security_policy")

    @property
    @pulumi.getter
    def override(self) -> builtins.bool:
        """
        A Boolean that determines whether CloudFront overrides the ``Content-Security-Policy`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        return pulumi.get(self, "override")


@pulumi.output_type
class ResponseHeadersPolicyContentTypeOptions(dict):
    """
    Determines whether CloudFront includes the ``X-Content-Type-Options`` HTTP response header with its value set to ``nosniff``.
     For more information about the ``X-Content-Type-Options`` HTTP response header, see [X-Content-Type-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options) in the MDN Web Docs.
    """
    def __init__(__self__, *,
                 override: builtins.bool):
        """
        Determines whether CloudFront includes the ``X-Content-Type-Options`` HTTP response header with its value set to ``nosniff``.
         For more information about the ``X-Content-Type-Options`` HTTP response header, see [X-Content-Type-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options) in the MDN Web Docs.
        :param builtins.bool override: A Boolean that determines whether CloudFront overrides the ``X-Content-Type-Options`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        pulumi.set(__self__, "override", override)

    @property
    @pulumi.getter
    def override(self) -> builtins.bool:
        """
        A Boolean that determines whether CloudFront overrides the ``X-Content-Type-Options`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        return pulumi.get(self, "override")


@pulumi.output_type
class ResponseHeadersPolicyCorsConfig(dict):
    """
    A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS). CloudFront adds these headers to HTTP responses that it sends for CORS requests that match a cache behavior associated with this response headers policy.
     For more information about CORS, see [Cross-Origin Resource Sharing (CORS)](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) in the MDN Web Docs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessControlAllowCredentials":
            suggest = "access_control_allow_credentials"
        elif key == "accessControlAllowHeaders":
            suggest = "access_control_allow_headers"
        elif key == "accessControlAllowMethods":
            suggest = "access_control_allow_methods"
        elif key == "accessControlAllowOrigins":
            suggest = "access_control_allow_origins"
        elif key == "originOverride":
            suggest = "origin_override"
        elif key == "accessControlExposeHeaders":
            suggest = "access_control_expose_headers"
        elif key == "accessControlMaxAgeSec":
            suggest = "access_control_max_age_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyCorsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyCorsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyCorsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_control_allow_credentials: builtins.bool,
                 access_control_allow_headers: 'outputs.ResponseHeadersPolicyAccessControlAllowHeaders',
                 access_control_allow_methods: 'outputs.ResponseHeadersPolicyAccessControlAllowMethods',
                 access_control_allow_origins: 'outputs.ResponseHeadersPolicyAccessControlAllowOrigins',
                 origin_override: builtins.bool,
                 access_control_expose_headers: Optional['outputs.ResponseHeadersPolicyAccessControlExposeHeaders'] = None,
                 access_control_max_age_sec: Optional[builtins.int] = None):
        """
        A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS). CloudFront adds these headers to HTTP responses that it sends for CORS requests that match a cache behavior associated with this response headers policy.
         For more information about CORS, see [Cross-Origin Resource Sharing (CORS)](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) in the MDN Web Docs.
        :param builtins.bool access_control_allow_credentials: A Boolean that CloudFront uses as the value for the ``Access-Control-Allow-Credentials`` HTTP response header.
                For more information about the ``Access-Control-Allow-Credentials`` HTTP response header, see [Access-Control-Allow-Credentials](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials) in the MDN Web Docs.
        :param 'ResponseHeadersPolicyAccessControlAllowHeaders' access_control_allow_headers: A list of HTTP header names that CloudFront includes as values for the ``Access-Control-Allow-Headers`` HTTP response header.
                For more information about the ``Access-Control-Allow-Headers`` HTTP response header, see [Access-Control-Allow-Headers](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers) in the MDN Web Docs.
        :param 'ResponseHeadersPolicyAccessControlAllowMethods' access_control_allow_methods: A list of HTTP methods that CloudFront includes as values for the ``Access-Control-Allow-Methods`` HTTP response header.
                For more information about the ``Access-Control-Allow-Methods`` HTTP response header, see [Access-Control-Allow-Methods](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods) in the MDN Web Docs.
        :param 'ResponseHeadersPolicyAccessControlAllowOrigins' access_control_allow_origins: A list of origins (domain names) that CloudFront can use as the value for the ``Access-Control-Allow-Origin`` HTTP response header.
                For more information about the ``Access-Control-Allow-Origin`` HTTP response header, see [Access-Control-Allow-Origin](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin) in the MDN Web Docs.
        :param builtins.bool origin_override: A Boolean that determines whether CloudFront overrides HTTP response headers received from the origin with the ones specified in this response headers policy.
        :param 'ResponseHeadersPolicyAccessControlExposeHeaders' access_control_expose_headers: A list of HTTP headers that CloudFront includes as values for the ``Access-Control-Expose-Headers`` HTTP response header.
                For more information about the ``Access-Control-Expose-Headers`` HTTP response header, see [Access-Control-Expose-Headers](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers) in the MDN Web Docs.
        :param builtins.int access_control_max_age_sec: A number that CloudFront uses as the value for the ``Access-Control-Max-Age`` HTTP response header.
                For more information about the ``Access-Control-Max-Age`` HTTP response header, see [Access-Control-Max-Age](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Max-Age) in the MDN Web Docs.
        """
        pulumi.set(__self__, "access_control_allow_credentials", access_control_allow_credentials)
        pulumi.set(__self__, "access_control_allow_headers", access_control_allow_headers)
        pulumi.set(__self__, "access_control_allow_methods", access_control_allow_methods)
        pulumi.set(__self__, "access_control_allow_origins", access_control_allow_origins)
        pulumi.set(__self__, "origin_override", origin_override)
        if access_control_expose_headers is not None:
            pulumi.set(__self__, "access_control_expose_headers", access_control_expose_headers)
        if access_control_max_age_sec is not None:
            pulumi.set(__self__, "access_control_max_age_sec", access_control_max_age_sec)

    @property
    @pulumi.getter(name="accessControlAllowCredentials")
    def access_control_allow_credentials(self) -> builtins.bool:
        """
        A Boolean that CloudFront uses as the value for the ``Access-Control-Allow-Credentials`` HTTP response header.
         For more information about the ``Access-Control-Allow-Credentials`` HTTP response header, see [Access-Control-Allow-Credentials](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials) in the MDN Web Docs.
        """
        return pulumi.get(self, "access_control_allow_credentials")

    @property
    @pulumi.getter(name="accessControlAllowHeaders")
    def access_control_allow_headers(self) -> 'outputs.ResponseHeadersPolicyAccessControlAllowHeaders':
        """
        A list of HTTP header names that CloudFront includes as values for the ``Access-Control-Allow-Headers`` HTTP response header.
         For more information about the ``Access-Control-Allow-Headers`` HTTP response header, see [Access-Control-Allow-Headers](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers) in the MDN Web Docs.
        """
        return pulumi.get(self, "access_control_allow_headers")

    @property
    @pulumi.getter(name="accessControlAllowMethods")
    def access_control_allow_methods(self) -> 'outputs.ResponseHeadersPolicyAccessControlAllowMethods':
        """
        A list of HTTP methods that CloudFront includes as values for the ``Access-Control-Allow-Methods`` HTTP response header.
         For more information about the ``Access-Control-Allow-Methods`` HTTP response header, see [Access-Control-Allow-Methods](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods) in the MDN Web Docs.
        """
        return pulumi.get(self, "access_control_allow_methods")

    @property
    @pulumi.getter(name="accessControlAllowOrigins")
    def access_control_allow_origins(self) -> 'outputs.ResponseHeadersPolicyAccessControlAllowOrigins':
        """
        A list of origins (domain names) that CloudFront can use as the value for the ``Access-Control-Allow-Origin`` HTTP response header.
         For more information about the ``Access-Control-Allow-Origin`` HTTP response header, see [Access-Control-Allow-Origin](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin) in the MDN Web Docs.
        """
        return pulumi.get(self, "access_control_allow_origins")

    @property
    @pulumi.getter(name="originOverride")
    def origin_override(self) -> builtins.bool:
        """
        A Boolean that determines whether CloudFront overrides HTTP response headers received from the origin with the ones specified in this response headers policy.
        """
        return pulumi.get(self, "origin_override")

    @property
    @pulumi.getter(name="accessControlExposeHeaders")
    def access_control_expose_headers(self) -> Optional['outputs.ResponseHeadersPolicyAccessControlExposeHeaders']:
        """
        A list of HTTP headers that CloudFront includes as values for the ``Access-Control-Expose-Headers`` HTTP response header.
         For more information about the ``Access-Control-Expose-Headers`` HTTP response header, see [Access-Control-Expose-Headers](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers) in the MDN Web Docs.
        """
        return pulumi.get(self, "access_control_expose_headers")

    @property
    @pulumi.getter(name="accessControlMaxAgeSec")
    def access_control_max_age_sec(self) -> Optional[builtins.int]:
        """
        A number that CloudFront uses as the value for the ``Access-Control-Max-Age`` HTTP response header.
         For more information about the ``Access-Control-Max-Age`` HTTP response header, see [Access-Control-Max-Age](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Max-Age) in the MDN Web Docs.
        """
        return pulumi.get(self, "access_control_max_age_sec")


@pulumi.output_type
class ResponseHeadersPolicyCustomHeader(dict):
    """
    An HTTP response header name and its value. CloudFront includes this header in HTTP responses that it sends for requests that match a cache behavior that's associated with this response headers policy.
    """
    def __init__(__self__, *,
                 header: builtins.str,
                 override: builtins.bool,
                 value: builtins.str):
        """
        An HTTP response header name and its value. CloudFront includes this header in HTTP responses that it sends for requests that match a cache behavior that's associated with this response headers policy.
        :param builtins.str header: The HTTP response header name.
        :param builtins.bool override: A Boolean that determines whether CloudFront overrides a response header with the same name received from the origin with the header specified here.
        :param builtins.str value: The value for the HTTP response header.
        """
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "override", override)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def header(self) -> builtins.str:
        """
        The HTTP response header name.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def override(self) -> builtins.bool:
        """
        A Boolean that determines whether CloudFront overrides a response header with the same name received from the origin with the header specified here.
        """
        return pulumi.get(self, "override")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value for the HTTP response header.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ResponseHeadersPolicyCustomHeadersConfig(dict):
    """
    A list of HTTP response header names and their values. CloudFront includes these headers in HTTP responses that it sends for requests that match a cache behavior that's associated with this response headers policy.
    """
    def __init__(__self__, *,
                 items: Sequence['outputs.ResponseHeadersPolicyCustomHeader']):
        """
        A list of HTTP response header names and their values. CloudFront includes these headers in HTTP responses that it sends for requests that match a cache behavior that's associated with this response headers policy.
        :param Sequence['ResponseHeadersPolicyCustomHeader'] items: The list of HTTP response headers and their values.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.ResponseHeadersPolicyCustomHeader']:
        """
        The list of HTTP response headers and their values.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ResponseHeadersPolicyFrameOptions(dict):
    """
    Determines whether CloudFront includes the ``X-Frame-Options`` HTTP response header and the header's value.
     For more information about the ``X-Frame-Options`` HTTP response header, see [X-Frame-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options) in the MDN Web Docs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "frameOption":
            suggest = "frame_option"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyFrameOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyFrameOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyFrameOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 frame_option: builtins.str,
                 override: builtins.bool):
        """
        Determines whether CloudFront includes the ``X-Frame-Options`` HTTP response header and the header's value.
         For more information about the ``X-Frame-Options`` HTTP response header, see [X-Frame-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options) in the MDN Web Docs.
        :param builtins.str frame_option: The value of the ``X-Frame-Options`` HTTP response header. Valid values are ``DENY`` and ``SAMEORIGIN``.
                For more information about these values, see [X-Frame-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options) in the MDN Web Docs.
        :param builtins.bool override: A Boolean that determines whether CloudFront overrides the ``X-Frame-Options`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        pulumi.set(__self__, "frame_option", frame_option)
        pulumi.set(__self__, "override", override)

    @property
    @pulumi.getter(name="frameOption")
    def frame_option(self) -> builtins.str:
        """
        The value of the ``X-Frame-Options`` HTTP response header. Valid values are ``DENY`` and ``SAMEORIGIN``.
         For more information about these values, see [X-Frame-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options) in the MDN Web Docs.
        """
        return pulumi.get(self, "frame_option")

    @property
    @pulumi.getter
    def override(self) -> builtins.bool:
        """
        A Boolean that determines whether CloudFront overrides the ``X-Frame-Options`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        return pulumi.get(self, "override")


@pulumi.output_type
class ResponseHeadersPolicyReferrerPolicy(dict):
    """
    Determines whether CloudFront includes the ``Referrer-Policy`` HTTP response header and the header's value.
     For more information about the ``Referrer-Policy`` HTTP response header, see [Referrer-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy) in the MDN Web Docs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "referrerPolicy":
            suggest = "referrer_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyReferrerPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyReferrerPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyReferrerPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 override: builtins.bool,
                 referrer_policy: builtins.str):
        """
        Determines whether CloudFront includes the ``Referrer-Policy`` HTTP response header and the header's value.
         For more information about the ``Referrer-Policy`` HTTP response header, see [Referrer-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy) in the MDN Web Docs.
        :param builtins.bool override: A Boolean that determines whether CloudFront overrides the ``Referrer-Policy`` HTTP response header received from the origin with the one specified in this response headers policy.
        :param builtins.str referrer_policy: Determines whether CloudFront includes the ``Referrer-Policy`` HTTP response header and the header's value.
                For more information about the ``Referrer-Policy`` HTTP response header, see [Referrer-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy) in the MDN Web Docs.
        """
        pulumi.set(__self__, "override", override)
        pulumi.set(__self__, "referrer_policy", referrer_policy)

    @property
    @pulumi.getter
    def override(self) -> builtins.bool:
        """
        A Boolean that determines whether CloudFront overrides the ``Referrer-Policy`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        return pulumi.get(self, "override")

    @property
    @pulumi.getter(name="referrerPolicy")
    def referrer_policy(self) -> builtins.str:
        """
        Determines whether CloudFront includes the ``Referrer-Policy`` HTTP response header and the header's value.
         For more information about the ``Referrer-Policy`` HTTP response header, see [Referrer-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy) in the MDN Web Docs.
        """
        return pulumi.get(self, "referrer_policy")


@pulumi.output_type
class ResponseHeadersPolicyRemoveHeader(dict):
    """
    The name of an HTTP header that CloudFront removes from HTTP responses to requests that match the cache behavior that this response headers policy is attached to.
    """
    def __init__(__self__, *,
                 header: builtins.str):
        """
        The name of an HTTP header that CloudFront removes from HTTP responses to requests that match the cache behavior that this response headers policy is attached to.
        :param builtins.str header: The HTTP header name.
        """
        pulumi.set(__self__, "header", header)

    @property
    @pulumi.getter
    def header(self) -> builtins.str:
        """
        The HTTP header name.
        """
        return pulumi.get(self, "header")


@pulumi.output_type
class ResponseHeadersPolicyRemoveHeadersConfig(dict):
    """
    A list of HTTP header names that CloudFront removes from HTTP responses to requests that match the cache behavior that this response headers policy is attached to.
    """
    def __init__(__self__, *,
                 items: Sequence['outputs.ResponseHeadersPolicyRemoveHeader']):
        """
        A list of HTTP header names that CloudFront removes from HTTP responses to requests that match the cache behavior that this response headers policy is attached to.
        :param Sequence['ResponseHeadersPolicyRemoveHeader'] items: The list of HTTP header names.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.ResponseHeadersPolicyRemoveHeader']:
        """
        The list of HTTP header names.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ResponseHeadersPolicySecurityHeadersConfig(dict):
    """
    A configuration for a set of security-related HTTP response headers. CloudFront adds these headers to HTTP responses that it sends for requests that match a cache behavior associated with this response headers policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentSecurityPolicy":
            suggest = "content_security_policy"
        elif key == "contentTypeOptions":
            suggest = "content_type_options"
        elif key == "frameOptions":
            suggest = "frame_options"
        elif key == "referrerPolicy":
            suggest = "referrer_policy"
        elif key == "strictTransportSecurity":
            suggest = "strict_transport_security"
        elif key == "xssProtection":
            suggest = "xss_protection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicySecurityHeadersConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicySecurityHeadersConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicySecurityHeadersConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_security_policy: Optional['outputs.ResponseHeadersPolicyContentSecurityPolicy'] = None,
                 content_type_options: Optional['outputs.ResponseHeadersPolicyContentTypeOptions'] = None,
                 frame_options: Optional['outputs.ResponseHeadersPolicyFrameOptions'] = None,
                 referrer_policy: Optional['outputs.ResponseHeadersPolicyReferrerPolicy'] = None,
                 strict_transport_security: Optional['outputs.ResponseHeadersPolicyStrictTransportSecurity'] = None,
                 xss_protection: Optional['outputs.ResponseHeadersPolicyXssProtection'] = None):
        """
        A configuration for a set of security-related HTTP response headers. CloudFront adds these headers to HTTP responses that it sends for requests that match a cache behavior associated with this response headers policy.
        :param 'ResponseHeadersPolicyContentSecurityPolicy' content_security_policy: The policy directives and their values that CloudFront includes as values for the ``Content-Security-Policy`` HTTP response header.
                For more information about the ``Content-Security-Policy`` HTTP response header, see [Content-Security-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy) in the MDN Web Docs.
        :param 'ResponseHeadersPolicyContentTypeOptions' content_type_options: Determines whether CloudFront includes the ``X-Content-Type-Options`` HTTP response header with its value set to ``nosniff``.
                For more information about the ``X-Content-Type-Options`` HTTP response header, see [X-Content-Type-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options) in the MDN Web Docs.
        :param 'ResponseHeadersPolicyFrameOptions' frame_options: Determines whether CloudFront includes the ``X-Frame-Options`` HTTP response header and the header's value.
                For more information about the ``X-Frame-Options`` HTTP response header, see [X-Frame-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options) in the MDN Web Docs.
        :param 'ResponseHeadersPolicyReferrerPolicy' referrer_policy: Determines whether CloudFront includes the ``Referrer-Policy`` HTTP response header and the header's value.
                For more information about the ``Referrer-Policy`` HTTP response header, see [Referrer-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy) in the MDN Web Docs.
        :param 'ResponseHeadersPolicyStrictTransportSecurity' strict_transport_security: Determines whether CloudFront includes the ``Strict-Transport-Security`` HTTP response header and the header's value.
                For more information about the ``Strict-Transport-Security`` HTTP response header, see [Security headers](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/understanding-response-headers-policies.html#understanding-response-headers-policies-security) in the *Amazon CloudFront Developer Guide* and [Strict-Transport-Security](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security) in the MDN Web Docs.
        :param 'ResponseHeadersPolicyXssProtection' xss_protection: Determines whether CloudFront includes the ``X-XSS-Protection`` HTTP response header and the header's value.
                For more information about the ``X-XSS-Protection`` HTTP response header, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        """
        if content_security_policy is not None:
            pulumi.set(__self__, "content_security_policy", content_security_policy)
        if content_type_options is not None:
            pulumi.set(__self__, "content_type_options", content_type_options)
        if frame_options is not None:
            pulumi.set(__self__, "frame_options", frame_options)
        if referrer_policy is not None:
            pulumi.set(__self__, "referrer_policy", referrer_policy)
        if strict_transport_security is not None:
            pulumi.set(__self__, "strict_transport_security", strict_transport_security)
        if xss_protection is not None:
            pulumi.set(__self__, "xss_protection", xss_protection)

    @property
    @pulumi.getter(name="contentSecurityPolicy")
    def content_security_policy(self) -> Optional['outputs.ResponseHeadersPolicyContentSecurityPolicy']:
        """
        The policy directives and their values that CloudFront includes as values for the ``Content-Security-Policy`` HTTP response header.
         For more information about the ``Content-Security-Policy`` HTTP response header, see [Content-Security-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy) in the MDN Web Docs.
        """
        return pulumi.get(self, "content_security_policy")

    @property
    @pulumi.getter(name="contentTypeOptions")
    def content_type_options(self) -> Optional['outputs.ResponseHeadersPolicyContentTypeOptions']:
        """
        Determines whether CloudFront includes the ``X-Content-Type-Options`` HTTP response header with its value set to ``nosniff``.
         For more information about the ``X-Content-Type-Options`` HTTP response header, see [X-Content-Type-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options) in the MDN Web Docs.
        """
        return pulumi.get(self, "content_type_options")

    @property
    @pulumi.getter(name="frameOptions")
    def frame_options(self) -> Optional['outputs.ResponseHeadersPolicyFrameOptions']:
        """
        Determines whether CloudFront includes the ``X-Frame-Options`` HTTP response header and the header's value.
         For more information about the ``X-Frame-Options`` HTTP response header, see [X-Frame-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options) in the MDN Web Docs.
        """
        return pulumi.get(self, "frame_options")

    @property
    @pulumi.getter(name="referrerPolicy")
    def referrer_policy(self) -> Optional['outputs.ResponseHeadersPolicyReferrerPolicy']:
        """
        Determines whether CloudFront includes the ``Referrer-Policy`` HTTP response header and the header's value.
         For more information about the ``Referrer-Policy`` HTTP response header, see [Referrer-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy) in the MDN Web Docs.
        """
        return pulumi.get(self, "referrer_policy")

    @property
    @pulumi.getter(name="strictTransportSecurity")
    def strict_transport_security(self) -> Optional['outputs.ResponseHeadersPolicyStrictTransportSecurity']:
        """
        Determines whether CloudFront includes the ``Strict-Transport-Security`` HTTP response header and the header's value.
         For more information about the ``Strict-Transport-Security`` HTTP response header, see [Security headers](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/understanding-response-headers-policies.html#understanding-response-headers-policies-security) in the *Amazon CloudFront Developer Guide* and [Strict-Transport-Security](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security) in the MDN Web Docs.
        """
        return pulumi.get(self, "strict_transport_security")

    @property
    @pulumi.getter(name="xssProtection")
    def xss_protection(self) -> Optional['outputs.ResponseHeadersPolicyXssProtection']:
        """
        Determines whether CloudFront includes the ``X-XSS-Protection`` HTTP response header and the header's value.
         For more information about the ``X-XSS-Protection`` HTTP response header, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        """
        return pulumi.get(self, "xss_protection")


@pulumi.output_type
class ResponseHeadersPolicyServerTimingHeadersConfig(dict):
    """
    A configuration for enabling the ``Server-Timing`` header in HTTP responses sent from CloudFront.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "samplingRate":
            suggest = "sampling_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyServerTimingHeadersConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyServerTimingHeadersConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyServerTimingHeadersConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 sampling_rate: Optional[builtins.float] = None):
        """
        A configuration for enabling the ``Server-Timing`` header in HTTP responses sent from CloudFront.
        :param builtins.bool enabled: A Boolean that determines whether CloudFront adds the ``Server-Timing`` header to HTTP responses that it sends in response to requests that match a cache behavior that's associated with this response headers policy.
        :param builtins.float sampling_rate: A number 0–100 (inclusive) that specifies the percentage of responses that you want CloudFront to add the ``Server-Timing`` header to. When you set the sampling rate to 100, CloudFront adds the ``Server-Timing`` header to the HTTP response for every request that matches the cache behavior that this response headers policy is attached to. When you set it to 50, CloudFront adds the header to 50% of the responses for requests that match the cache behavior. You can set the sampling rate to any number 0–100 with up to four decimal places.
        """
        pulumi.set(__self__, "enabled", enabled)
        if sampling_rate is not None:
            pulumi.set(__self__, "sampling_rate", sampling_rate)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        A Boolean that determines whether CloudFront adds the ``Server-Timing`` header to HTTP responses that it sends in response to requests that match a cache behavior that's associated with this response headers policy.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> Optional[builtins.float]:
        """
        A number 0–100 (inclusive) that specifies the percentage of responses that you want CloudFront to add the ``Server-Timing`` header to. When you set the sampling rate to 100, CloudFront adds the ``Server-Timing`` header to the HTTP response for every request that matches the cache behavior that this response headers policy is attached to. When you set it to 50, CloudFront adds the header to 50% of the responses for requests that match the cache behavior. You can set the sampling rate to any number 0–100 with up to four decimal places.
        """
        return pulumi.get(self, "sampling_rate")


@pulumi.output_type
class ResponseHeadersPolicyStrictTransportSecurity(dict):
    """
    Determines whether CloudFront includes the ``Strict-Transport-Security`` HTTP response header and the header's value.
     For more information about the ``Strict-Transport-Security`` HTTP response header, see [Strict-Transport-Security](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security) in the MDN Web Docs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessControlMaxAgeSec":
            suggest = "access_control_max_age_sec"
        elif key == "includeSubdomains":
            suggest = "include_subdomains"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyStrictTransportSecurity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyStrictTransportSecurity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyStrictTransportSecurity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_control_max_age_sec: builtins.int,
                 override: builtins.bool,
                 include_subdomains: Optional[builtins.bool] = None,
                 preload: Optional[builtins.bool] = None):
        """
        Determines whether CloudFront includes the ``Strict-Transport-Security`` HTTP response header and the header's value.
         For more information about the ``Strict-Transport-Security`` HTTP response header, see [Strict-Transport-Security](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security) in the MDN Web Docs.
        :param builtins.int access_control_max_age_sec: A number that CloudFront uses as the value for the ``max-age`` directive in the ``Strict-Transport-Security`` HTTP response header.
        :param builtins.bool override: A Boolean that determines whether CloudFront overrides the ``Strict-Transport-Security`` HTTP response header received from the origin with the one specified in this response headers policy.
        :param builtins.bool include_subdomains: A Boolean that determines whether CloudFront includes the ``includeSubDomains`` directive in the ``Strict-Transport-Security`` HTTP response header.
        :param builtins.bool preload: A Boolean that determines whether CloudFront includes the ``preload`` directive in the ``Strict-Transport-Security`` HTTP response header.
        """
        pulumi.set(__self__, "access_control_max_age_sec", access_control_max_age_sec)
        pulumi.set(__self__, "override", override)
        if include_subdomains is not None:
            pulumi.set(__self__, "include_subdomains", include_subdomains)
        if preload is not None:
            pulumi.set(__self__, "preload", preload)

    @property
    @pulumi.getter(name="accessControlMaxAgeSec")
    def access_control_max_age_sec(self) -> builtins.int:
        """
        A number that CloudFront uses as the value for the ``max-age`` directive in the ``Strict-Transport-Security`` HTTP response header.
        """
        return pulumi.get(self, "access_control_max_age_sec")

    @property
    @pulumi.getter
    def override(self) -> builtins.bool:
        """
        A Boolean that determines whether CloudFront overrides the ``Strict-Transport-Security`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        return pulumi.get(self, "override")

    @property
    @pulumi.getter(name="includeSubdomains")
    def include_subdomains(self) -> Optional[builtins.bool]:
        """
        A Boolean that determines whether CloudFront includes the ``includeSubDomains`` directive in the ``Strict-Transport-Security`` HTTP response header.
        """
        return pulumi.get(self, "include_subdomains")

    @property
    @pulumi.getter
    def preload(self) -> Optional[builtins.bool]:
        """
        A Boolean that determines whether CloudFront includes the ``preload`` directive in the ``Strict-Transport-Security`` HTTP response header.
        """
        return pulumi.get(self, "preload")


@pulumi.output_type
class ResponseHeadersPolicyXssProtection(dict):
    """
    Determines whether CloudFront includes the ``X-XSS-Protection`` HTTP response header and the header's value.
     For more information about the ``X-XSS-Protection`` HTTP response header, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modeBlock":
            suggest = "mode_block"
        elif key == "reportUri":
            suggest = "report_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyXssProtection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyXssProtection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyXssProtection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 override: builtins.bool,
                 protection: builtins.bool,
                 mode_block: Optional[builtins.bool] = None,
                 report_uri: Optional[builtins.str] = None):
        """
        Determines whether CloudFront includes the ``X-XSS-Protection`` HTTP response header and the header's value.
         For more information about the ``X-XSS-Protection`` HTTP response header, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        :param builtins.bool override: A Boolean that determines whether CloudFront overrides the ``X-XSS-Protection`` HTTP response header received from the origin with the one specified in this response headers policy.
        :param builtins.bool protection: A Boolean that determines the value of the ``X-XSS-Protection`` HTTP response header. When this setting is ``true``, the value of the ``X-XSS-Protection`` header is ``1``. When this setting is ``false``, the value of the ``X-XSS-Protection`` header is ``0``.
                For more information about these settings, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        :param builtins.bool mode_block: A Boolean that determines whether CloudFront includes the ``mode=block`` directive in the ``X-XSS-Protection`` header.
                For more information about this directive, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        :param builtins.str report_uri: A reporting URI, which CloudFront uses as the value of the ``report`` directive in the ``X-XSS-Protection`` header.
                You cannot specify a ``ReportUri`` when ``ModeBlock`` is ``true``.
                For more information about using a reporting URL, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        """
        pulumi.set(__self__, "override", override)
        pulumi.set(__self__, "protection", protection)
        if mode_block is not None:
            pulumi.set(__self__, "mode_block", mode_block)
        if report_uri is not None:
            pulumi.set(__self__, "report_uri", report_uri)

    @property
    @pulumi.getter
    def override(self) -> builtins.bool:
        """
        A Boolean that determines whether CloudFront overrides the ``X-XSS-Protection`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        return pulumi.get(self, "override")

    @property
    @pulumi.getter
    def protection(self) -> builtins.bool:
        """
        A Boolean that determines the value of the ``X-XSS-Protection`` HTTP response header. When this setting is ``true``, the value of the ``X-XSS-Protection`` header is ``1``. When this setting is ``false``, the value of the ``X-XSS-Protection`` header is ``0``.
         For more information about these settings, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        """
        return pulumi.get(self, "protection")

    @property
    @pulumi.getter(name="modeBlock")
    def mode_block(self) -> Optional[builtins.bool]:
        """
        A Boolean that determines whether CloudFront includes the ``mode=block`` directive in the ``X-XSS-Protection`` header.
         For more information about this directive, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        """
        return pulumi.get(self, "mode_block")

    @property
    @pulumi.getter(name="reportUri")
    def report_uri(self) -> Optional[builtins.str]:
        """
        A reporting URI, which CloudFront uses as the value of the ``report`` directive in the ``X-XSS-Protection`` header.
         You cannot specify a ``ReportUri`` when ``ModeBlock`` is ``true``.
         For more information about using a reporting URL, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        """
        return pulumi.get(self, "report_uri")


@pulumi.output_type
class VpcOriginEndpointConfig(dict):
    """
    An Amazon CloudFront VPC origin endpoint configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpPort":
            suggest = "http_port"
        elif key == "httpsPort":
            suggest = "https_port"
        elif key == "originProtocolPolicy":
            suggest = "origin_protocol_policy"
        elif key == "originSslProtocols":
            suggest = "origin_ssl_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpcOriginEndpointConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpcOriginEndpointConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpcOriginEndpointConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: builtins.str,
                 name: builtins.str,
                 http_port: Optional[builtins.int] = None,
                 https_port: Optional[builtins.int] = None,
                 origin_protocol_policy: Optional[builtins.str] = None,
                 origin_ssl_protocols: Optional[Sequence[builtins.str]] = None):
        """
        An Amazon CloudFront VPC origin endpoint configuration.
        :param builtins.str arn: The ARN of the CloudFront VPC origin endpoint configuration.
        :param builtins.str name: The name of the CloudFront VPC origin endpoint configuration.
        :param builtins.int http_port: The HTTP port for the CloudFront VPC origin endpoint configuration. The default value is ``80``.
        :param builtins.int https_port: The HTTPS port of the CloudFront VPC origin endpoint configuration. The default value is ``443``.
        :param builtins.str origin_protocol_policy: The origin protocol policy for the CloudFront VPC origin endpoint configuration.
        :param Sequence[builtins.str] origin_ssl_protocols: Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS. Valid values include ``SSLv3``, ``TLSv1``, ``TLSv1.1``, and ``TLSv1.2``.
                For more information, see [Minimum Origin SSL Protocol](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols) in the *Amazon CloudFront Developer Guide*.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "name", name)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if https_port is not None:
            pulumi.set(__self__, "https_port", https_port)
        if origin_protocol_policy is not None:
            pulumi.set(__self__, "origin_protocol_policy", origin_protocol_policy)
        if origin_ssl_protocols is not None:
            pulumi.set(__self__, "origin_ssl_protocols", origin_ssl_protocols)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        The ARN of the CloudFront VPC origin endpoint configuration.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the CloudFront VPC origin endpoint configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[builtins.int]:
        """
        The HTTP port for the CloudFront VPC origin endpoint configuration. The default value is ``80``.
        """
        return pulumi.get(self, "http_port")

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> Optional[builtins.int]:
        """
        The HTTPS port of the CloudFront VPC origin endpoint configuration. The default value is ``443``.
        """
        return pulumi.get(self, "https_port")

    @property
    @pulumi.getter(name="originProtocolPolicy")
    def origin_protocol_policy(self) -> Optional[builtins.str]:
        """
        The origin protocol policy for the CloudFront VPC origin endpoint configuration.
        """
        return pulumi.get(self, "origin_protocol_policy")

    @property
    @pulumi.getter(name="originSslProtocols")
    def origin_ssl_protocols(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS. Valid values include ``SSLv3``, ``TLSv1``, ``TLSv1.1``, and ``TLSv1.2``.
         For more information, see [Minimum Origin SSL Protocol](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_ssl_protocols")


