# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRealtimeLogConfigResult',
    'AwaitableGetRealtimeLogConfigResult',
    'get_realtime_log_config',
    'get_realtime_log_config_output',
]

@pulumi.output_type
class GetRealtimeLogConfigResult:
    def __init__(__self__, arn=None, end_points=None, fields=None, sampling_rate=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if end_points and not isinstance(end_points, list):
            raise TypeError("Expected argument 'end_points' to be a list")
        pulumi.set(__self__, "end_points", end_points)
        if fields and not isinstance(fields, list):
            raise TypeError("Expected argument 'fields' to be a list")
        pulumi.set(__self__, "fields", fields)
        if sampling_rate and not isinstance(sampling_rate, float):
            raise TypeError("Expected argument 'sampling_rate' to be a float")
        pulumi.set(__self__, "sampling_rate", sampling_rate)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the real-time log configuration. For example: `arn:aws:cloudfront::111122223333:realtime-log-config/ExampleNameForRealtimeLogConfig` .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="endPoints")
    def end_points(self) -> Optional[Sequence['outputs.RealtimeLogConfigEndPoint']]:
        """
        Contains information about the Amazon Kinesis data stream where you are sending real-time log data for this real-time log configuration.
        """
        return pulumi.get(self, "end_points")

    @property
    @pulumi.getter
    def fields(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of fields that are included in each real-time log record. In an API response, the fields are provided in the same order in which they are sent to the Amazon Kinesis data stream.
         For more information about fields, see [Real-time log configuration fields](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> Optional[builtins.float]:
        """
        The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. The sampling rate is an integer between 1 and 100, inclusive.
        """
        return pulumi.get(self, "sampling_rate")


class AwaitableGetRealtimeLogConfigResult(GetRealtimeLogConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRealtimeLogConfigResult(
            arn=self.arn,
            end_points=self.end_points,
            fields=self.fields,
            sampling_rate=self.sampling_rate)


def get_realtime_log_config(arn: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRealtimeLogConfigResult:
    """
    A real-time log configuration.


    :param builtins.str arn: The Amazon Resource Name (ARN) of the real-time log configuration. For example: `arn:aws:cloudfront::111122223333:realtime-log-config/ExampleNameForRealtimeLogConfig` .
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cloudfront:getRealtimeLogConfig', __args__, opts=opts, typ=GetRealtimeLogConfigResult).value

    return AwaitableGetRealtimeLogConfigResult(
        arn=pulumi.get(__ret__, 'arn'),
        end_points=pulumi.get(__ret__, 'end_points'),
        fields=pulumi.get(__ret__, 'fields'),
        sampling_rate=pulumi.get(__ret__, 'sampling_rate'))
def get_realtime_log_config_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRealtimeLogConfigResult]:
    """
    A real-time log configuration.


    :param builtins.str arn: The Amazon Resource Name (ARN) of the real-time log configuration. For example: `arn:aws:cloudfront::111122223333:realtime-log-config/ExampleNameForRealtimeLogConfig` .
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cloudfront:getRealtimeLogConfig', __args__, opts=opts, typ=GetRealtimeLogConfigResult)
    return __ret__.apply(lambda __response__: GetRealtimeLogConfigResult(
        arn=pulumi.get(__response__, 'arn'),
        end_points=pulumi.get(__response__, 'end_points'),
        fields=pulumi.get(__response__, 'fields'),
        sampling_rate=pulumi.get(__response__, 'sampling_rate')))
