# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOriginRequestPolicyResult',
    'AwaitableGetOriginRequestPolicyResult',
    'get_origin_request_policy',
    'get_origin_request_policy_output',
]

@pulumi.output_type
class GetOriginRequestPolicyResult:
    def __init__(__self__, id=None, last_modified_time=None, origin_request_policy_config=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_modified_time and not isinstance(last_modified_time, str):
            raise TypeError("Expected argument 'last_modified_time' to be a str")
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        if origin_request_policy_config and not isinstance(origin_request_policy_config, dict):
            raise TypeError("Expected argument 'origin_request_policy_config' to be a dict")
        pulumi.set(__self__, "origin_request_policy_config", origin_request_policy_config)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The unique identifier for the origin request policy. For example: `befd7079-9bbc-4ebf-8ade-498a3694176c` .
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[builtins.str]:
        """
        The date and time when the origin request policy was last modified.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="originRequestPolicyConfig")
    def origin_request_policy_config(self) -> Optional['outputs.OriginRequestPolicyConfig']:
        """
        The origin request policy configuration.
        """
        return pulumi.get(self, "origin_request_policy_config")


class AwaitableGetOriginRequestPolicyResult(GetOriginRequestPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOriginRequestPolicyResult(
            id=self.id,
            last_modified_time=self.last_modified_time,
            origin_request_policy_config=self.origin_request_policy_config)


def get_origin_request_policy(id: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOriginRequestPolicyResult:
    """
    An origin request policy.
     When it's attached to a cache behavior, the origin request policy determines the values that CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends to the origin includes the following:
      +  The request body and the URL path (without the domain name) from the viewer request.
      +  The headers that CloudFront automatically includes in every origin request, including ``Host``, ``User-Agent``, and ``X-Amz-Cf-Id``.
      +  All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request policy. These can include items from the viewer request and, in the case of headers, additional ones that are added by CloudFront.

     CloudFront sends a request when it can't find an object in its cache that matches the request. If you want to send values to the origin and also include them in the cache key, use ``CachePolicy``.


    :param builtins.str id: The unique identifier for the origin request policy. For example: `befd7079-9bbc-4ebf-8ade-498a3694176c` .
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cloudfront:getOriginRequestPolicy', __args__, opts=opts, typ=GetOriginRequestPolicyResult).value

    return AwaitableGetOriginRequestPolicyResult(
        id=pulumi.get(__ret__, 'id'),
        last_modified_time=pulumi.get(__ret__, 'last_modified_time'),
        origin_request_policy_config=pulumi.get(__ret__, 'origin_request_policy_config'))
def get_origin_request_policy_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOriginRequestPolicyResult]:
    """
    An origin request policy.
     When it's attached to a cache behavior, the origin request policy determines the values that CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends to the origin includes the following:
      +  The request body and the URL path (without the domain name) from the viewer request.
      +  The headers that CloudFront automatically includes in every origin request, including ``Host``, ``User-Agent``, and ``X-Amz-Cf-Id``.
      +  All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request policy. These can include items from the viewer request and, in the case of headers, additional ones that are added by CloudFront.

     CloudFront sends a request when it can't find an object in its cache that matches the request. If you want to send values to the origin and also include them in the cache key, use ``CachePolicy``.


    :param builtins.str id: The unique identifier for the origin request policy. For example: `befd7079-9bbc-4ebf-8ade-498a3694176c` .
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cloudfront:getOriginRequestPolicy', __args__, opts=opts, typ=GetOriginRequestPolicyResult)
    return __ret__.apply(lambda __response__: GetOriginRequestPolicyResult(
        id=pulumi.get(__response__, 'id'),
        last_modified_time=pulumi.get(__response__, 'last_modified_time'),
        origin_request_policy_config=pulumi.get(__response__, 'origin_request_policy_config')))
