# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetKeyValueStoreResult',
    'AwaitableGetKeyValueStoreResult',
    'get_key_value_store',
    'get_key_value_store_output',
]

@pulumi.output_type
class GetKeyValueStoreResult:
    def __init__(__self__, arn=None, comment=None, id=None, status=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if comment and not isinstance(comment, str):
            raise TypeError("Expected argument 'comment' to be a str")
        pulumi.set(__self__, "comment", comment)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the key value store.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def comment(self) -> Optional[builtins.str]:
        """
        A comment for the key value store.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The unique Id for the key value store.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        The current status of the key value store. For more information, see [Key value store statuses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/kvs-with-functions-create.html#key-value-store-status) in the *.*
        """
        return pulumi.get(self, "status")


class AwaitableGetKeyValueStoreResult(GetKeyValueStoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyValueStoreResult(
            arn=self.arn,
            comment=self.comment,
            id=self.id,
            status=self.status)


def get_key_value_store(name: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyValueStoreResult:
    """
    The key value store. Use this to separate data from function code, allowing you to update data without having to publish a new version of a function. The key value store holds keys and their corresponding values.


    :param builtins.str name: The name of the key value store.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cloudfront:getKeyValueStore', __args__, opts=opts, typ=GetKeyValueStoreResult).value

    return AwaitableGetKeyValueStoreResult(
        arn=pulumi.get(__ret__, 'arn'),
        comment=pulumi.get(__ret__, 'comment'),
        id=pulumi.get(__ret__, 'id'),
        status=pulumi.get(__ret__, 'status'))
def get_key_value_store_output(name: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKeyValueStoreResult]:
    """
    The key value store. Use this to separate data from function code, allowing you to update data without having to publish a new version of a function. The key value store holds keys and their corresponding values.


    :param builtins.str name: The name of the key value store.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cloudfront:getKeyValueStore', __args__, opts=opts, typ=GetKeyValueStoreResult)
    return __ret__.apply(lambda __response__: GetKeyValueStoreResult(
        arn=pulumi.get(__response__, 'arn'),
        comment=pulumi.get(__response__, 'comment'),
        id=pulumi.get(__response__, 'id'),
        status=pulumi.get(__response__, 'status')))
