# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetDistributionTenantResult',
    'AwaitableGetDistributionTenantResult',
    'get_distribution_tenant',
    'get_distribution_tenant_output',
]

@pulumi.output_type
class GetDistributionTenantResult:
    def __init__(__self__, arn=None, connection_group_id=None, created_time=None, customizations=None, distribution_id=None, domain_results=None, domains=None, e_tag=None, enabled=None, id=None, last_modified_time=None, parameters=None, status=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if connection_group_id and not isinstance(connection_group_id, str):
            raise TypeError("Expected argument 'connection_group_id' to be a str")
        pulumi.set(__self__, "connection_group_id", connection_group_id)
        if created_time and not isinstance(created_time, str):
            raise TypeError("Expected argument 'created_time' to be a str")
        pulumi.set(__self__, "created_time", created_time)
        if customizations and not isinstance(customizations, dict):
            raise TypeError("Expected argument 'customizations' to be a dict")
        pulumi.set(__self__, "customizations", customizations)
        if distribution_id and not isinstance(distribution_id, str):
            raise TypeError("Expected argument 'distribution_id' to be a str")
        pulumi.set(__self__, "distribution_id", distribution_id)
        if domain_results and not isinstance(domain_results, list):
            raise TypeError("Expected argument 'domain_results' to be a list")
        pulumi.set(__self__, "domain_results", domain_results)
        if domains and not isinstance(domains, list):
            raise TypeError("Expected argument 'domains' to be a list")
        pulumi.set(__self__, "domains", domains)
        if e_tag and not isinstance(e_tag, str):
            raise TypeError("Expected argument 'e_tag' to be a str")
        pulumi.set(__self__, "e_tag", e_tag)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_modified_time and not isinstance(last_modified_time, str):
            raise TypeError("Expected argument 'last_modified_time' to be a str")
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        if parameters and not isinstance(parameters, list):
            raise TypeError("Expected argument 'parameters' to be a list")
        pulumi.set(__self__, "parameters", parameters)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the distribution tenant.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="connectionGroupId")
    def connection_group_id(self) -> Optional[builtins.str]:
        """
        The ID of the connection group for the distribution tenant. If you don't specify a connection group, CloudFront uses the default connection group.
        """
        return pulumi.get(self, "connection_group_id")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[builtins.str]:
        """
        The date and time when the distribution tenant was created.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def customizations(self) -> Optional['outputs.DistributionTenantCustomizations']:
        """
        Customizations for the distribution tenant. For each distribution tenant, you can specify the geographic restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and WAF web ACL. These are specific values that you can override or disable from the multi-tenant distribution that was used to create the distribution tenant.
        """
        return pulumi.get(self, "customizations")

    @property
    @pulumi.getter(name="distributionId")
    def distribution_id(self) -> Optional[builtins.str]:
        """
        The ID of the multi-tenant distribution.
        """
        return pulumi.get(self, "distribution_id")

    @property
    @pulumi.getter(name="domainResults")
    def domain_results(self) -> Optional[Sequence['outputs.DistributionTenantDomainResult']]:
        return pulumi.get(self, "domain_results")

    @property
    @pulumi.getter
    def domains(self) -> Optional[Sequence[builtins.str]]:
        """
        The domains associated with the distribution tenant.
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> Optional[builtins.str]:
        """
        The current version of the distribution tenant.
        """
        return pulumi.get(self, "e_tag")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Indicates whether the distribution tenant is in an enabled state. If disabled, the distribution tenant won't serve traffic.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the distribution tenant.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[builtins.str]:
        """
        The date and time when the distribution tenant was updated.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.DistributionTenantParameter']]:
        """
        A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        The status of the distribution tenant.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A complex type that contains zero or more ``Tag`` elements.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDistributionTenantResult(GetDistributionTenantResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDistributionTenantResult(
            arn=self.arn,
            connection_group_id=self.connection_group_id,
            created_time=self.created_time,
            customizations=self.customizations,
            distribution_id=self.distribution_id,
            domain_results=self.domain_results,
            domains=self.domains,
            e_tag=self.e_tag,
            enabled=self.enabled,
            id=self.id,
            last_modified_time=self.last_modified_time,
            parameters=self.parameters,
            status=self.status,
            tags=self.tags)


def get_distribution_tenant(id: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDistributionTenantResult:
    """
    The distribution tenant.


    :param builtins.str id: The ID of the distribution tenant.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cloudfront:getDistributionTenant', __args__, opts=opts, typ=GetDistributionTenantResult).value

    return AwaitableGetDistributionTenantResult(
        arn=pulumi.get(__ret__, 'arn'),
        connection_group_id=pulumi.get(__ret__, 'connection_group_id'),
        created_time=pulumi.get(__ret__, 'created_time'),
        customizations=pulumi.get(__ret__, 'customizations'),
        distribution_id=pulumi.get(__ret__, 'distribution_id'),
        domain_results=pulumi.get(__ret__, 'domain_results'),
        domains=pulumi.get(__ret__, 'domains'),
        e_tag=pulumi.get(__ret__, 'e_tag'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        last_modified_time=pulumi.get(__ret__, 'last_modified_time'),
        parameters=pulumi.get(__ret__, 'parameters'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_distribution_tenant_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDistributionTenantResult]:
    """
    The distribution tenant.


    :param builtins.str id: The ID of the distribution tenant.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cloudfront:getDistributionTenant', __args__, opts=opts, typ=GetDistributionTenantResult)
    return __ret__.apply(lambda __response__: GetDistributionTenantResult(
        arn=pulumi.get(__response__, 'arn'),
        connection_group_id=pulumi.get(__response__, 'connection_group_id'),
        created_time=pulumi.get(__response__, 'created_time'),
        customizations=pulumi.get(__response__, 'customizations'),
        distribution_id=pulumi.get(__response__, 'distribution_id'),
        domain_results=pulumi.get(__response__, 'domain_results'),
        domains=pulumi.get(__response__, 'domains'),
        e_tag=pulumi.get(__response__, 'e_tag'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        last_modified_time=pulumi.get(__response__, 'last_modified_time'),
        parameters=pulumi.get(__response__, 'parameters'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
