# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetConnectionGroupResult',
    'AwaitableGetConnectionGroupResult',
    'get_connection_group',
    'get_connection_group_output',
]

@pulumi.output_type
class GetConnectionGroupResult:
    def __init__(__self__, anycast_ip_list_id=None, arn=None, created_time=None, e_tag=None, enabled=None, id=None, ipv6_enabled=None, is_default=None, last_modified_time=None, routing_endpoint=None, status=None, tags=None):
        if anycast_ip_list_id and not isinstance(anycast_ip_list_id, str):
            raise TypeError("Expected argument 'anycast_ip_list_id' to be a str")
        pulumi.set(__self__, "anycast_ip_list_id", anycast_ip_list_id)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_time and not isinstance(created_time, str):
            raise TypeError("Expected argument 'created_time' to be a str")
        pulumi.set(__self__, "created_time", created_time)
        if e_tag and not isinstance(e_tag, str):
            raise TypeError("Expected argument 'e_tag' to be a str")
        pulumi.set(__self__, "e_tag", e_tag)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipv6_enabled and not isinstance(ipv6_enabled, bool):
            raise TypeError("Expected argument 'ipv6_enabled' to be a bool")
        pulumi.set(__self__, "ipv6_enabled", ipv6_enabled)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if last_modified_time and not isinstance(last_modified_time, str):
            raise TypeError("Expected argument 'last_modified_time' to be a str")
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        if routing_endpoint and not isinstance(routing_endpoint, str):
            raise TypeError("Expected argument 'routing_endpoint' to be a str")
        pulumi.set(__self__, "routing_endpoint", routing_endpoint)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="anycastIpListId")
    def anycast_ip_list_id(self) -> Optional[builtins.str]:
        """
        The ID of the Anycast static IP list.
        """
        return pulumi.get(self, "anycast_ip_list_id")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the connection group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[builtins.str]:
        """
        The date and time when the connection group was created.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> Optional[builtins.str]:
        """
        The current version of the connection group.
        """
        return pulumi.get(self, "e_tag")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Whether the connection group is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the connection group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> Optional[builtins.bool]:
        """
        IPv6 is enabled for the connection group.
        """
        return pulumi.get(self, "ipv6_enabled")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[builtins.bool]:
        """
        Whether the connection group is the default connection group for the distribution tenants.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[builtins.str]:
        """
        The date and time when the connection group was updated.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="routingEndpoint")
    def routing_endpoint(self) -> Optional[builtins.str]:
        """
        The routing endpoint (also known as the DNS name) that is assigned to the connection group, such as d111111abcdef8.cloudfront.net.
        """
        return pulumi.get(self, "routing_endpoint")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        The status of the connection group.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A complex type that contains zero or more ``Tag`` elements.
        """
        return pulumi.get(self, "tags")


class AwaitableGetConnectionGroupResult(GetConnectionGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionGroupResult(
            anycast_ip_list_id=self.anycast_ip_list_id,
            arn=self.arn,
            created_time=self.created_time,
            e_tag=self.e_tag,
            enabled=self.enabled,
            id=self.id,
            ipv6_enabled=self.ipv6_enabled,
            is_default=self.is_default,
            last_modified_time=self.last_modified_time,
            routing_endpoint=self.routing_endpoint,
            status=self.status,
            tags=self.tags)


def get_connection_group(id: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionGroupResult:
    """
    The connection group for your distribution tenants. When you first create a distribution tenant and you don't specify a connection group, CloudFront will automatically create a default connection group for you. When you create a new distribution tenant and don't specify a connection group, the default one will be associated with your distribution tenant.


    :param builtins.str id: The ID of the connection group.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cloudfront:getConnectionGroup', __args__, opts=opts, typ=GetConnectionGroupResult).value

    return AwaitableGetConnectionGroupResult(
        anycast_ip_list_id=pulumi.get(__ret__, 'anycast_ip_list_id'),
        arn=pulumi.get(__ret__, 'arn'),
        created_time=pulumi.get(__ret__, 'created_time'),
        e_tag=pulumi.get(__ret__, 'e_tag'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        ipv6_enabled=pulumi.get(__ret__, 'ipv6_enabled'),
        is_default=pulumi.get(__ret__, 'is_default'),
        last_modified_time=pulumi.get(__ret__, 'last_modified_time'),
        routing_endpoint=pulumi.get(__ret__, 'routing_endpoint'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_connection_group_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConnectionGroupResult]:
    """
    The connection group for your distribution tenants. When you first create a distribution tenant and you don't specify a connection group, CloudFront will automatically create a default connection group for you. When you create a new distribution tenant and don't specify a connection group, the default one will be associated with your distribution tenant.


    :param builtins.str id: The ID of the connection group.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cloudfront:getConnectionGroup', __args__, opts=opts, typ=GetConnectionGroupResult)
    return __ret__.apply(lambda __response__: GetConnectionGroupResult(
        anycast_ip_list_id=pulumi.get(__response__, 'anycast_ip_list_id'),
        arn=pulumi.get(__response__, 'arn'),
        created_time=pulumi.get(__response__, 'created_time'),
        e_tag=pulumi.get(__response__, 'e_tag'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        ipv6_enabled=pulumi.get(__response__, 'ipv6_enabled'),
        is_default=pulumi.get(__response__, 'is_default'),
        last_modified_time=pulumi.get(__response__, 'last_modified_time'),
        routing_endpoint=pulumi.get(__response__, 'routing_endpoint'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
