# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCloudFrontOriginAccessIdentityResult',
    'AwaitableGetCloudFrontOriginAccessIdentityResult',
    'get_cloud_front_origin_access_identity',
    'get_cloud_front_origin_access_identity_output',
]

@pulumi.output_type
class GetCloudFrontOriginAccessIdentityResult:
    def __init__(__self__, cloud_front_origin_access_identity_config=None, id=None, s3_canonical_user_id=None):
        if cloud_front_origin_access_identity_config and not isinstance(cloud_front_origin_access_identity_config, dict):
            raise TypeError("Expected argument 'cloud_front_origin_access_identity_config' to be a dict")
        pulumi.set(__self__, "cloud_front_origin_access_identity_config", cloud_front_origin_access_identity_config)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if s3_canonical_user_id and not isinstance(s3_canonical_user_id, str):
            raise TypeError("Expected argument 's3_canonical_user_id' to be a str")
        pulumi.set(__self__, "s3_canonical_user_id", s3_canonical_user_id)

    @property
    @pulumi.getter(name="cloudFrontOriginAccessIdentityConfig")
    def cloud_front_origin_access_identity_config(self) -> Optional['outputs.CloudFrontOriginAccessIdentityConfig']:
        """
        The current configuration information for the identity.
        """
        return pulumi.get(self, "cloud_front_origin_access_identity_config")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID for the origin access identity, for example, `E74FTE3AJFJ256A` .
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="s3CanonicalUserId")
    def s3_canonical_user_id(self) -> Optional[builtins.str]:
        """
        The Amazon S3 canonical user ID for the origin access identity, used when giving the origin access identity read permission to an object in Amazon S3. For example: `b970b42360b81c8ddbd79d2f5df0069ba9033c8a79655752abe380cd6d63ba8bcf23384d568fcf89fc49700b5e11a0fd` .
        """
        return pulumi.get(self, "s3_canonical_user_id")


class AwaitableGetCloudFrontOriginAccessIdentityResult(GetCloudFrontOriginAccessIdentityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudFrontOriginAccessIdentityResult(
            cloud_front_origin_access_identity_config=self.cloud_front_origin_access_identity_config,
            id=self.id,
            s3_canonical_user_id=self.s3_canonical_user_id)


def get_cloud_front_origin_access_identity(id: Optional[builtins.str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudFrontOriginAccessIdentityResult:
    """
    The request to create a new origin access identity (OAI). An origin access identity is a special CloudFront user that you can associate with Amazon S3 origins, so that you can secure all or just some of your Amazon S3 content. For more information, see [Restricting Access to Amazon S3 Content by Using an Origin Access Identity](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html) in the *Amazon CloudFront Developer Guide*.


    :param builtins.str id: The ID for the origin access identity, for example, `E74FTE3AJFJ256A` .
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cloudfront:getCloudFrontOriginAccessIdentity', __args__, opts=opts, typ=GetCloudFrontOriginAccessIdentityResult).value

    return AwaitableGetCloudFrontOriginAccessIdentityResult(
        cloud_front_origin_access_identity_config=pulumi.get(__ret__, 'cloud_front_origin_access_identity_config'),
        id=pulumi.get(__ret__, 'id'),
        s3_canonical_user_id=pulumi.get(__ret__, 's3_canonical_user_id'))
def get_cloud_front_origin_access_identity_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudFrontOriginAccessIdentityResult]:
    """
    The request to create a new origin access identity (OAI). An origin access identity is a special CloudFront user that you can associate with Amazon S3 origins, so that you can secure all or just some of your Amazon S3 content. For more information, see [Restricting Access to Amazon S3 Content by Using an Origin Access Identity](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html) in the *Amazon CloudFront Developer Guide*.


    :param builtins.str id: The ID for the origin access identity, for example, `E74FTE3AJFJ256A` .
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cloudfront:getCloudFrontOriginAccessIdentity', __args__, opts=opts, typ=GetCloudFrontOriginAccessIdentityResult)
    return __ret__.apply(lambda __response__: GetCloudFrontOriginAccessIdentityResult(
        cloud_front_origin_access_identity_config=pulumi.get(__response__, 'cloud_front_origin_access_identity_config'),
        id=pulumi.get(__response__, 'id'),
        s3_canonical_user_id=pulumi.get(__response__, 's3_canonical_user_id')))
