# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['DistributionTenantArgs', 'DistributionTenant']

@pulumi.input_type
class DistributionTenantArgs:
    def __init__(__self__, *,
                 distribution_id: pulumi.Input[builtins.str],
                 domains: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 connection_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 customizations: Optional[pulumi.Input['DistributionTenantCustomizationsArgs']] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 managed_certificate_request: Optional[pulumi.Input['DistributionTenantManagedCertificateRequestArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTenantParameterArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a DistributionTenant resource.
        :param pulumi.Input[builtins.str] distribution_id: The ID of the multi-tenant distribution.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] domains: The domains associated with the distribution tenant.
        :param pulumi.Input[builtins.str] connection_group_id: The ID of the connection group for the distribution tenant. If you don't specify a connection group, CloudFront uses the default connection group.
        :param pulumi.Input['DistributionTenantCustomizationsArgs'] customizations: Customizations for the distribution tenant. For each distribution tenant, you can specify the geographic restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and WAF web ACL. These are specific values that you can override or disable from the multi-tenant distribution that was used to create the distribution tenant.
        :param pulumi.Input[builtins.bool] enabled: Indicates whether the distribution tenant is in an enabled state. If disabled, the distribution tenant won't serve traffic.
        :param pulumi.Input['DistributionTenantManagedCertificateRequestArgs'] managed_certificate_request: An object that represents the request for the Amazon CloudFront managed ACM certificate.
        :param pulumi.Input[builtins.str] name: The name of the distribution tenant.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionTenantParameterArgs']]] parameters: A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A complex type that contains zero or more ``Tag`` elements.
        """
        pulumi.set(__self__, "distribution_id", distribution_id)
        pulumi.set(__self__, "domains", domains)
        if connection_group_id is not None:
            pulumi.set(__self__, "connection_group_id", connection_group_id)
        if customizations is not None:
            pulumi.set(__self__, "customizations", customizations)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if managed_certificate_request is not None:
            pulumi.set(__self__, "managed_certificate_request", managed_certificate_request)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="distributionId")
    def distribution_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the multi-tenant distribution.
        """
        return pulumi.get(self, "distribution_id")

    @distribution_id.setter
    def distribution_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "distribution_id", value)

    @property
    @pulumi.getter
    def domains(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The domains associated with the distribution tenant.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "domains", value)

    @property
    @pulumi.getter(name="connectionGroupId")
    def connection_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the connection group for the distribution tenant. If you don't specify a connection group, CloudFront uses the default connection group.
        """
        return pulumi.get(self, "connection_group_id")

    @connection_group_id.setter
    def connection_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_group_id", value)

    @property
    @pulumi.getter
    def customizations(self) -> Optional[pulumi.Input['DistributionTenantCustomizationsArgs']]:
        """
        Customizations for the distribution tenant. For each distribution tenant, you can specify the geographic restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and WAF web ACL. These are specific values that you can override or disable from the multi-tenant distribution that was used to create the distribution tenant.
        """
        return pulumi.get(self, "customizations")

    @customizations.setter
    def customizations(self, value: Optional[pulumi.Input['DistributionTenantCustomizationsArgs']]):
        pulumi.set(self, "customizations", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the distribution tenant is in an enabled state. If disabled, the distribution tenant won't serve traffic.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="managedCertificateRequest")
    def managed_certificate_request(self) -> Optional[pulumi.Input['DistributionTenantManagedCertificateRequestArgs']]:
        """
        An object that represents the request for the Amazon CloudFront managed ACM certificate.
        """
        return pulumi.get(self, "managed_certificate_request")

    @managed_certificate_request.setter
    def managed_certificate_request(self, value: Optional[pulumi.Input['DistributionTenantManagedCertificateRequestArgs']]):
        pulumi.set(self, "managed_certificate_request", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the distribution tenant.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTenantParameterArgs']]]]:
        """
        A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTenantParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A complex type that contains zero or more ``Tag`` elements.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:cloudfront:DistributionTenant")
class DistributionTenant(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 customizations: Optional[pulumi.Input[Union['DistributionTenantCustomizationsArgs', 'DistributionTenantCustomizationsArgsDict']]] = None,
                 distribution_id: Optional[pulumi.Input[builtins.str]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 managed_certificate_request: Optional[pulumi.Input[Union['DistributionTenantManagedCertificateRequestArgs', 'DistributionTenantManagedCertificateRequestArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DistributionTenantParameterArgs', 'DistributionTenantParameterArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        The distribution tenant.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] connection_group_id: The ID of the connection group for the distribution tenant. If you don't specify a connection group, CloudFront uses the default connection group.
        :param pulumi.Input[Union['DistributionTenantCustomizationsArgs', 'DistributionTenantCustomizationsArgsDict']] customizations: Customizations for the distribution tenant. For each distribution tenant, you can specify the geographic restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and WAF web ACL. These are specific values that you can override or disable from the multi-tenant distribution that was used to create the distribution tenant.
        :param pulumi.Input[builtins.str] distribution_id: The ID of the multi-tenant distribution.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] domains: The domains associated with the distribution tenant.
        :param pulumi.Input[builtins.bool] enabled: Indicates whether the distribution tenant is in an enabled state. If disabled, the distribution tenant won't serve traffic.
        :param pulumi.Input[Union['DistributionTenantManagedCertificateRequestArgs', 'DistributionTenantManagedCertificateRequestArgsDict']] managed_certificate_request: An object that represents the request for the Amazon CloudFront managed ACM certificate.
        :param pulumi.Input[builtins.str] name: The name of the distribution tenant.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DistributionTenantParameterArgs', 'DistributionTenantParameterArgsDict']]]] parameters: A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A complex type that contains zero or more ``Tag`` elements.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DistributionTenantArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The distribution tenant.

        :param str resource_name: The name of the resource.
        :param DistributionTenantArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DistributionTenantArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 customizations: Optional[pulumi.Input[Union['DistributionTenantCustomizationsArgs', 'DistributionTenantCustomizationsArgsDict']]] = None,
                 distribution_id: Optional[pulumi.Input[builtins.str]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 managed_certificate_request: Optional[pulumi.Input[Union['DistributionTenantManagedCertificateRequestArgs', 'DistributionTenantManagedCertificateRequestArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DistributionTenantParameterArgs', 'DistributionTenantParameterArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DistributionTenantArgs.__new__(DistributionTenantArgs)

            __props__.__dict__["connection_group_id"] = connection_group_id
            __props__.__dict__["customizations"] = customizations
            if distribution_id is None and not opts.urn:
                raise TypeError("Missing required property 'distribution_id'")
            __props__.__dict__["distribution_id"] = distribution_id
            if domains is None and not opts.urn:
                raise TypeError("Missing required property 'domains'")
            __props__.__dict__["domains"] = domains
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["managed_certificate_request"] = managed_certificate_request
            __props__.__dict__["name"] = name
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["domain_results"] = None
            __props__.__dict__["e_tag"] = None
            __props__.__dict__["last_modified_time"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DistributionTenant, __self__).__init__(
            'aws-native:cloudfront:DistributionTenant',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DistributionTenant':
        """
        Get an existing DistributionTenant resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DistributionTenantArgs.__new__(DistributionTenantArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["connection_group_id"] = None
        __props__.__dict__["created_time"] = None
        __props__.__dict__["customizations"] = None
        __props__.__dict__["distribution_id"] = None
        __props__.__dict__["domain_results"] = None
        __props__.__dict__["domains"] = None
        __props__.__dict__["e_tag"] = None
        __props__.__dict__["enabled"] = None
        __props__.__dict__["last_modified_time"] = None
        __props__.__dict__["managed_certificate_request"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["parameters"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        return DistributionTenant(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the distribution tenant.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the distribution tenant.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="connectionGroupId")
    def connection_group_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the connection group for the distribution tenant. If you don't specify a connection group, CloudFront uses the default connection group.
        """
        return pulumi.get(self, "connection_group_id")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[builtins.str]:
        """
        The date and time when the distribution tenant was created.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def customizations(self) -> pulumi.Output[Optional['outputs.DistributionTenantCustomizations']]:
        """
        Customizations for the distribution tenant. For each distribution tenant, you can specify the geographic restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and WAF web ACL. These are specific values that you can override or disable from the multi-tenant distribution that was used to create the distribution tenant.
        """
        return pulumi.get(self, "customizations")

    @property
    @pulumi.getter(name="distributionId")
    def distribution_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the multi-tenant distribution.
        """
        return pulumi.get(self, "distribution_id")

    @property
    @pulumi.getter(name="domainResults")
    def domain_results(self) -> pulumi.Output[Sequence['outputs.DistributionTenantDomainResult']]:
        return pulumi.get(self, "domain_results")

    @property
    @pulumi.getter
    def domains(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The domains associated with the distribution tenant.
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> pulumi.Output[builtins.str]:
        """
        The current version of the distribution tenant.
        """
        return pulumi.get(self, "e_tag")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether the distribution tenant is in an enabled state. If disabled, the distribution tenant won't serve traffic.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[builtins.str]:
        """
        The date and time when the distribution tenant was updated.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="managedCertificateRequest")
    def managed_certificate_request(self) -> pulumi.Output[Optional['outputs.DistributionTenantManagedCertificateRequest']]:
        """
        An object that represents the request for the Amazon CloudFront managed ACM certificate.
        """
        return pulumi.get(self, "managed_certificate_request")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the distribution tenant.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Sequence['outputs.DistributionTenantParameter']]]:
        """
        A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The status of the distribution tenant.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A complex type that contains zero or more ``Tag`` elements.
        """
        return pulumi.get(self, "tags")

