# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['DistributionArgs', 'Distribution']

@pulumi.input_type
class DistributionArgs:
    def __init__(__self__, *,
                 distribution_config: pulumi.Input['DistributionConfigArgs'],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Distribution resource.
        :param pulumi.Input['DistributionConfigArgs'] distribution_config: The distribution's configuration.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A complex type that contains zero or more ``Tag`` elements.
        """
        pulumi.set(__self__, "distribution_config", distribution_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="distributionConfig")
    def distribution_config(self) -> pulumi.Input['DistributionConfigArgs']:
        """
        The distribution's configuration.
        """
        return pulumi.get(self, "distribution_config")

    @distribution_config.setter
    def distribution_config(self, value: pulumi.Input['DistributionConfigArgs']):
        pulumi.set(self, "distribution_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A complex type that contains zero or more ``Tag`` elements.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:cloudfront:Distribution")
class Distribution(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 distribution_config: Optional[pulumi.Input[Union['DistributionConfigArgs', 'DistributionConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        A distribution tells CloudFront where you want content to be delivered from, and the details about how to track and manage content delivery.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DistributionConfigArgs', 'DistributionConfigArgsDict']] distribution_config: The distribution's configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A complex type that contains zero or more ``Tag`` elements.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DistributionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A distribution tells CloudFront where you want content to be delivered from, and the details about how to track and manage content delivery.

        :param str resource_name: The name of the resource.
        :param DistributionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DistributionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 distribution_config: Optional[pulumi.Input[Union['DistributionConfigArgs', 'DistributionConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DistributionArgs.__new__(DistributionArgs)

            if distribution_config is None and not opts.urn:
                raise TypeError("Missing required property 'distribution_config'")
            __props__.__dict__["distribution_config"] = distribution_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["domain_name"] = None
        super(Distribution, __self__).__init__(
            'aws-native:cloudfront:Distribution',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Distribution':
        """
        Get an existing Distribution resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DistributionArgs.__new__(DistributionArgs)

        __props__.__dict__["aws_id"] = None
        __props__.__dict__["distribution_config"] = None
        __props__.__dict__["domain_name"] = None
        __props__.__dict__["tags"] = None
        return Distribution(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The distribution's identifier. For example: `E1U5RQF7T870K0` .
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="distributionConfig")
    def distribution_config(self) -> pulumi.Output['outputs.DistributionConfig']:
        """
        The distribution's configuration.
        """
        return pulumi.get(self, "distribution_config")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[builtins.str]:
        """
        The domain name of the resource, such as `d111111abcdef8.cloudfront.net` .
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A complex type that contains zero or more ``Tag`` elements.
        """
        return pulumi.get(self, "tags")

