# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['ConnectionGroupArgs', 'ConnectionGroup']

@pulumi.input_type
class ConnectionGroupArgs:
    def __init__(__self__, *,
                 anycast_ip_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ipv6_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a ConnectionGroup resource.
        :param pulumi.Input[builtins.str] anycast_ip_list_id: The ID of the Anycast static IP list.
        :param pulumi.Input[builtins.bool] enabled: Whether the connection group is enabled.
        :param pulumi.Input[builtins.bool] ipv6_enabled: IPv6 is enabled for the connection group.
        :param pulumi.Input[builtins.str] name: The name of the connection group.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A complex type that contains zero or more ``Tag`` elements.
        """
        if anycast_ip_list_id is not None:
            pulumi.set(__self__, "anycast_ip_list_id", anycast_ip_list_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ipv6_enabled is not None:
            pulumi.set(__self__, "ipv6_enabled", ipv6_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="anycastIpListId")
    def anycast_ip_list_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Anycast static IP list.
        """
        return pulumi.get(self, "anycast_ip_list_id")

    @anycast_ip_list_id.setter
    def anycast_ip_list_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "anycast_ip_list_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the connection group is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        IPv6 is enabled for the connection group.
        """
        return pulumi.get(self, "ipv6_enabled")

    @ipv6_enabled.setter
    def ipv6_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ipv6_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the connection group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A complex type that contains zero or more ``Tag`` elements.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:cloudfront:ConnectionGroup")
class ConnectionGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anycast_ip_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ipv6_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        The connection group for your distribution tenants. When you first create a distribution tenant and you don't specify a connection group, CloudFront will automatically create a default connection group for you. When you create a new distribution tenant and don't specify a connection group, the default one will be associated with your distribution tenant.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] anycast_ip_list_id: The ID of the Anycast static IP list.
        :param pulumi.Input[builtins.bool] enabled: Whether the connection group is enabled.
        :param pulumi.Input[builtins.bool] ipv6_enabled: IPv6 is enabled for the connection group.
        :param pulumi.Input[builtins.str] name: The name of the connection group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A complex type that contains zero or more ``Tag`` elements.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ConnectionGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The connection group for your distribution tenants. When you first create a distribution tenant and you don't specify a connection group, CloudFront will automatically create a default connection group for you. When you create a new distribution tenant and don't specify a connection group, the default one will be associated with your distribution tenant.

        :param str resource_name: The name of the resource.
        :param ConnectionGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anycast_ip_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ipv6_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionGroupArgs.__new__(ConnectionGroupArgs)

            __props__.__dict__["anycast_ip_list_id"] = anycast_ip_list_id
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["ipv6_enabled"] = ipv6_enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["e_tag"] = None
            __props__.__dict__["is_default"] = None
            __props__.__dict__["last_modified_time"] = None
            __props__.__dict__["routing_endpoint"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ConnectionGroup, __self__).__init__(
            'aws-native:cloudfront:ConnectionGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ConnectionGroup':
        """
        Get an existing ConnectionGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ConnectionGroupArgs.__new__(ConnectionGroupArgs)

        __props__.__dict__["anycast_ip_list_id"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["created_time"] = None
        __props__.__dict__["e_tag"] = None
        __props__.__dict__["enabled"] = None
        __props__.__dict__["ipv6_enabled"] = None
        __props__.__dict__["is_default"] = None
        __props__.__dict__["last_modified_time"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["routing_endpoint"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        return ConnectionGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="anycastIpListId")
    def anycast_ip_list_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the Anycast static IP list.
        """
        return pulumi.get(self, "anycast_ip_list_id")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the connection group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the connection group.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[builtins.str]:
        """
        The date and time when the connection group was created.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> pulumi.Output[builtins.str]:
        """
        The current version of the connection group.
        """
        return pulumi.get(self, "e_tag")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the connection group is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        IPv6 is enabled for the connection group.
        """
        return pulumi.get(self, "ipv6_enabled")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the connection group is the default connection group for the distribution tenants.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[builtins.str]:
        """
        The date and time when the connection group was updated.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the connection group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="routingEndpoint")
    def routing_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The routing endpoint (also known as the DNS name) that is assigned to the connection group, such as d111111abcdef8.cloudfront.net.
        """
        return pulumi.get(self, "routing_endpoint")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The status of the connection group.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A complex type that contains zero or more ``Tag`` elements.
        """
        return pulumi.get(self, "tags")

