# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'CachePolicyConfigArgs',
    'CachePolicyConfigArgsDict',
    'CachePolicyCookiesConfigArgs',
    'CachePolicyCookiesConfigArgsDict',
    'CachePolicyHeadersConfigArgs',
    'CachePolicyHeadersConfigArgsDict',
    'CachePolicyParametersInCacheKeyAndForwardedToOriginArgs',
    'CachePolicyParametersInCacheKeyAndForwardedToOriginArgsDict',
    'CachePolicyQueryStringsConfigArgs',
    'CachePolicyQueryStringsConfigArgsDict',
    'CloudFrontOriginAccessIdentityConfigArgs',
    'CloudFrontOriginAccessIdentityConfigArgsDict',
    'ContinuousDeploymentPolicyConfigSingleHeaderPolicyConfigPropertiesArgs',
    'ContinuousDeploymentPolicyConfigSingleHeaderPolicyConfigPropertiesArgsDict',
    'ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigPropertiesArgs',
    'ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigPropertiesArgsDict',
    'ContinuousDeploymentPolicyConfigArgs',
    'ContinuousDeploymentPolicyConfigArgsDict',
    'ContinuousDeploymentPolicySessionStickinessConfigArgs',
    'ContinuousDeploymentPolicySessionStickinessConfigArgsDict',
    'ContinuousDeploymentPolicySingleHeaderConfigArgs',
    'ContinuousDeploymentPolicySingleHeaderConfigArgsDict',
    'ContinuousDeploymentPolicySingleWeightConfigArgs',
    'ContinuousDeploymentPolicySingleWeightConfigArgsDict',
    'ContinuousDeploymentPolicyTrafficConfigArgs',
    'ContinuousDeploymentPolicyTrafficConfigArgsDict',
    'DistributionCacheBehaviorArgs',
    'DistributionCacheBehaviorArgsDict',
    'DistributionConfigTenantConfigPropertiesArgs',
    'DistributionConfigTenantConfigPropertiesArgsDict',
    'DistributionConfigArgs',
    'DistributionConfigArgsDict',
    'DistributionCookiesArgs',
    'DistributionCookiesArgsDict',
    'DistributionCustomErrorResponseArgs',
    'DistributionCustomErrorResponseArgsDict',
    'DistributionCustomOriginConfigArgs',
    'DistributionCustomOriginConfigArgsDict',
    'DistributionDefaultCacheBehaviorArgs',
    'DistributionDefaultCacheBehaviorArgsDict',
    'DistributionForwardedValuesArgs',
    'DistributionForwardedValuesArgsDict',
    'DistributionFunctionAssociationArgs',
    'DistributionFunctionAssociationArgsDict',
    'DistributionGeoRestrictionArgs',
    'DistributionGeoRestrictionArgsDict',
    'DistributionGrpcConfigArgs',
    'DistributionGrpcConfigArgsDict',
    'DistributionLambdaFunctionAssociationArgs',
    'DistributionLambdaFunctionAssociationArgsDict',
    'DistributionLegacyCustomOriginArgs',
    'DistributionLegacyCustomOriginArgsDict',
    'DistributionLegacyS3OriginArgs',
    'DistributionLegacyS3OriginArgsDict',
    'DistributionLoggingArgs',
    'DistributionLoggingArgsDict',
    'DistributionOriginCustomHeaderArgs',
    'DistributionOriginCustomHeaderArgsDict',
    'DistributionOriginGroupFailoverCriteriaArgs',
    'DistributionOriginGroupFailoverCriteriaArgsDict',
    'DistributionOriginGroupMembersArgs',
    'DistributionOriginGroupMembersArgsDict',
    'DistributionOriginGroupMemberArgs',
    'DistributionOriginGroupMemberArgsDict',
    'DistributionOriginGroupsArgs',
    'DistributionOriginGroupsArgsDict',
    'DistributionOriginGroupArgs',
    'DistributionOriginGroupArgsDict',
    'DistributionOriginShieldArgs',
    'DistributionOriginShieldArgsDict',
    'DistributionOriginArgs',
    'DistributionOriginArgsDict',
    'DistributionParameterDefinitionDefinitionPropertiesStringSchemaPropertiesArgs',
    'DistributionParameterDefinitionDefinitionPropertiesStringSchemaPropertiesArgsDict',
    'DistributionParameterDefinitionDefinitionPropertiesArgs',
    'DistributionParameterDefinitionDefinitionPropertiesArgsDict',
    'DistributionParameterDefinitionArgs',
    'DistributionParameterDefinitionArgsDict',
    'DistributionRestrictionsArgs',
    'DistributionRestrictionsArgsDict',
    'DistributionS3OriginConfigArgs',
    'DistributionS3OriginConfigArgsDict',
    'DistributionStatusCodesArgs',
    'DistributionStatusCodesArgsDict',
    'DistributionTenantCertificateArgs',
    'DistributionTenantCertificateArgsDict',
    'DistributionTenantCustomizationsArgs',
    'DistributionTenantCustomizationsArgsDict',
    'DistributionTenantGeoRestrictionCustomizationArgs',
    'DistributionTenantGeoRestrictionCustomizationArgsDict',
    'DistributionTenantManagedCertificateRequestArgs',
    'DistributionTenantManagedCertificateRequestArgsDict',
    'DistributionTenantParameterArgs',
    'DistributionTenantParameterArgsDict',
    'DistributionTenantWebAclCustomizationArgs',
    'DistributionTenantWebAclCustomizationArgsDict',
    'DistributionViewerCertificateArgs',
    'DistributionViewerCertificateArgsDict',
    'DistributionVpcOriginConfigArgs',
    'DistributionVpcOriginConfigArgsDict',
    'FunctionConfigArgs',
    'FunctionConfigArgsDict',
    'FunctionKeyValueStoreAssociationArgs',
    'FunctionKeyValueStoreAssociationArgsDict',
    'FunctionMetadataArgs',
    'FunctionMetadataArgsDict',
    'KeyGroupConfigArgs',
    'KeyGroupConfigArgsDict',
    'KeyValueStoreImportSourceArgs',
    'KeyValueStoreImportSourceArgsDict',
    'MonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs',
    'MonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgsDict',
    'MonitoringSubscriptionArgs',
    'MonitoringSubscriptionArgsDict',
    'OriginAccessControlConfigArgs',
    'OriginAccessControlConfigArgsDict',
    'OriginRequestPolicyConfigArgs',
    'OriginRequestPolicyConfigArgsDict',
    'OriginRequestPolicyCookiesConfigArgs',
    'OriginRequestPolicyCookiesConfigArgsDict',
    'OriginRequestPolicyHeadersConfigArgs',
    'OriginRequestPolicyHeadersConfigArgsDict',
    'OriginRequestPolicyQueryStringsConfigArgs',
    'OriginRequestPolicyQueryStringsConfigArgsDict',
    'PublicKeyConfigArgs',
    'PublicKeyConfigArgsDict',
    'RealtimeLogConfigEndPointArgs',
    'RealtimeLogConfigEndPointArgsDict',
    'RealtimeLogConfigKinesisStreamConfigArgs',
    'RealtimeLogConfigKinesisStreamConfigArgsDict',
    'ResponseHeadersPolicyAccessControlAllowHeadersArgs',
    'ResponseHeadersPolicyAccessControlAllowHeadersArgsDict',
    'ResponseHeadersPolicyAccessControlAllowMethodsArgs',
    'ResponseHeadersPolicyAccessControlAllowMethodsArgsDict',
    'ResponseHeadersPolicyAccessControlAllowOriginsArgs',
    'ResponseHeadersPolicyAccessControlAllowOriginsArgsDict',
    'ResponseHeadersPolicyAccessControlExposeHeadersArgs',
    'ResponseHeadersPolicyAccessControlExposeHeadersArgsDict',
    'ResponseHeadersPolicyConfigArgs',
    'ResponseHeadersPolicyConfigArgsDict',
    'ResponseHeadersPolicyContentSecurityPolicyArgs',
    'ResponseHeadersPolicyContentSecurityPolicyArgsDict',
    'ResponseHeadersPolicyContentTypeOptionsArgs',
    'ResponseHeadersPolicyContentTypeOptionsArgsDict',
    'ResponseHeadersPolicyCorsConfigArgs',
    'ResponseHeadersPolicyCorsConfigArgsDict',
    'ResponseHeadersPolicyCustomHeadersConfigArgs',
    'ResponseHeadersPolicyCustomHeadersConfigArgsDict',
    'ResponseHeadersPolicyCustomHeaderArgs',
    'ResponseHeadersPolicyCustomHeaderArgsDict',
    'ResponseHeadersPolicyFrameOptionsArgs',
    'ResponseHeadersPolicyFrameOptionsArgsDict',
    'ResponseHeadersPolicyReferrerPolicyArgs',
    'ResponseHeadersPolicyReferrerPolicyArgsDict',
    'ResponseHeadersPolicyRemoveHeadersConfigArgs',
    'ResponseHeadersPolicyRemoveHeadersConfigArgsDict',
    'ResponseHeadersPolicyRemoveHeaderArgs',
    'ResponseHeadersPolicyRemoveHeaderArgsDict',
    'ResponseHeadersPolicySecurityHeadersConfigArgs',
    'ResponseHeadersPolicySecurityHeadersConfigArgsDict',
    'ResponseHeadersPolicyServerTimingHeadersConfigArgs',
    'ResponseHeadersPolicyServerTimingHeadersConfigArgsDict',
    'ResponseHeadersPolicyStrictTransportSecurityArgs',
    'ResponseHeadersPolicyStrictTransportSecurityArgsDict',
    'ResponseHeadersPolicyXssProtectionArgs',
    'ResponseHeadersPolicyXssProtectionArgsDict',
    'VpcOriginEndpointConfigArgs',
    'VpcOriginEndpointConfigArgsDict',
]

MYPY = False

if not MYPY:
    class CachePolicyConfigArgsDict(TypedDict):
        """
        A cache policy configuration.
         This configuration determines the following:
          +  The values that CloudFront includes in the cache key. These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
          +  The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront cache.
          
         The headers, cookies, and query strings that are included in the cache key are also included in requests that CloudFront sends to the origin. CloudFront sends a request when it can't find a valid object in its cache that matches the request's cache key. If you want to send values to the origin but *not* include them in the cache key, use ``OriginRequestPolicy``.
        """
        default_ttl: pulumi.Input[builtins.float]
        """
        The default amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. CloudFront uses this value as the object's time to live (TTL) only when the origin does *not* send ``Cache-Control`` or ``Expires`` headers with the object. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
         The default value for this field is 86400 seconds (one day). If the value of ``MinTTL`` is more than 86400 seconds, then the default value for this field is the same as the value of ``MinTTL``.
        """
        max_ttl: pulumi.Input[builtins.float]
        """
        The maximum amount of time, in seconds, that objects stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. CloudFront uses this value only when the origin sends ``Cache-Control`` or ``Expires`` headers with the object. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
         The default value for this field is 31536000 seconds (one year). If the value of ``MinTTL`` or ``DefaultTTL`` is more than 31536000 seconds, then the default value for this field is the same as the value of ``DefaultTTL``.
        """
        min_ttl: pulumi.Input[builtins.float]
        """
        The minimum amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        name: pulumi.Input[builtins.str]
        """
        A unique name to identify the cache policy.
        """
        parameters_in_cache_key_and_forwarded_to_origin: pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginArgsDict']
        """
        The HTTP headers, cookies, and URL query strings to include in the cache key. The values included in the cache key are also included in requests that CloudFront sends to the origin.
        """
        comment: NotRequired[pulumi.Input[builtins.str]]
        """
        A comment to describe the cache policy. The comment cannot be longer than 128 characters.
        """
elif False:
    CachePolicyConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CachePolicyConfigArgs:
    def __init__(__self__, *,
                 default_ttl: pulumi.Input[builtins.float],
                 max_ttl: pulumi.Input[builtins.float],
                 min_ttl: pulumi.Input[builtins.float],
                 name: pulumi.Input[builtins.str],
                 parameters_in_cache_key_and_forwarded_to_origin: pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginArgs'],
                 comment: Optional[pulumi.Input[builtins.str]] = None):
        """
        A cache policy configuration.
         This configuration determines the following:
          +  The values that CloudFront includes in the cache key. These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
          +  The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront cache.
          
         The headers, cookies, and query strings that are included in the cache key are also included in requests that CloudFront sends to the origin. CloudFront sends a request when it can't find a valid object in its cache that matches the request's cache key. If you want to send values to the origin but *not* include them in the cache key, use ``OriginRequestPolicy``.
        :param pulumi.Input[builtins.float] default_ttl: The default amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. CloudFront uses this value as the object's time to live (TTL) only when the origin does *not* send ``Cache-Control`` or ``Expires`` headers with the object. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
                The default value for this field is 86400 seconds (one day). If the value of ``MinTTL`` is more than 86400 seconds, then the default value for this field is the same as the value of ``MinTTL``.
        :param pulumi.Input[builtins.float] max_ttl: The maximum amount of time, in seconds, that objects stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. CloudFront uses this value only when the origin sends ``Cache-Control`` or ``Expires`` headers with the object. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
                The default value for this field is 31536000 seconds (one year). If the value of ``MinTTL`` or ``DefaultTTL`` is more than 31536000 seconds, then the default value for this field is the same as the value of ``DefaultTTL``.
        :param pulumi.Input[builtins.float] min_ttl: The minimum amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.str] name: A unique name to identify the cache policy.
        :param pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginArgs'] parameters_in_cache_key_and_forwarded_to_origin: The HTTP headers, cookies, and URL query strings to include in the cache key. The values included in the cache key are also included in requests that CloudFront sends to the origin.
        :param pulumi.Input[builtins.str] comment: A comment to describe the cache policy. The comment cannot be longer than 128 characters.
        """
        pulumi.set(__self__, "default_ttl", default_ttl)
        pulumi.set(__self__, "max_ttl", max_ttl)
        pulumi.set(__self__, "min_ttl", min_ttl)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameters_in_cache_key_and_forwarded_to_origin", parameters_in_cache_key_and_forwarded_to_origin)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> pulumi.Input[builtins.float]:
        """
        The default amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. CloudFront uses this value as the object's time to live (TTL) only when the origin does *not* send ``Cache-Control`` or ``Expires`` headers with the object. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
         The default value for this field is 86400 seconds (one day). If the value of ``MinTTL`` is more than 86400 seconds, then the default value for this field is the same as the value of ``MinTTL``.
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "default_ttl", value)

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> pulumi.Input[builtins.float]:
        """
        The maximum amount of time, in seconds, that objects stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. CloudFront uses this value only when the origin sends ``Cache-Control`` or ``Expires`` headers with the object. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
         The default value for this field is 31536000 seconds (one year). If the value of ``MinTTL`` or ``DefaultTTL`` is more than 31536000 seconds, then the default value for this field is the same as the value of ``DefaultTTL``.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "max_ttl", value)

    @property
    @pulumi.getter(name="minTtl")
    def min_ttl(self) -> pulumi.Input[builtins.float]:
        """
        The minimum amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "min_ttl")

    @min_ttl.setter
    def min_ttl(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "min_ttl", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        A unique name to identify the cache policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parametersInCacheKeyAndForwardedToOrigin")
    def parameters_in_cache_key_and_forwarded_to_origin(self) -> pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginArgs']:
        """
        The HTTP headers, cookies, and URL query strings to include in the cache key. The values included in the cache key are also included in requests that CloudFront sends to the origin.
        """
        return pulumi.get(self, "parameters_in_cache_key_and_forwarded_to_origin")

    @parameters_in_cache_key_and_forwarded_to_origin.setter
    def parameters_in_cache_key_and_forwarded_to_origin(self, value: pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginArgs']):
        pulumi.set(self, "parameters_in_cache_key_and_forwarded_to_origin", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A comment to describe the cache policy. The comment cannot be longer than 128 characters.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment", value)


if not MYPY:
    class CachePolicyCookiesConfigArgsDict(TypedDict):
        """
        An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and in requests that CloudFront sends to the origin.
        """
        cookie_behavior: pulumi.Input[builtins.str]
        """
        Determines whether any cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin. Valid values are:
          +  ``none`` – No cookies in viewer requests are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any cookies that are listed in an ``OriginRequestPolicy``*are* included in origin requests.
          +  ``whitelist`` – Only the cookies in viewer requests that are listed in the ``CookieNames`` type are included in the cache key and in requests that CloudFront sends to the origin.
          +  ``allExcept`` – All cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin, *except* for those that are listed in the ``CookieNames`` type, which are not included.
          +  ``all`` – All cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin.
        """
        cookies: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Contains a list of cookie names.
        """
elif False:
    CachePolicyCookiesConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CachePolicyCookiesConfigArgs:
    def __init__(__self__, *,
                 cookie_behavior: pulumi.Input[builtins.str],
                 cookies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and in requests that CloudFront sends to the origin.
        :param pulumi.Input[builtins.str] cookie_behavior: Determines whether any cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin. Valid values are:
                 +  ``none`` – No cookies in viewer requests are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any cookies that are listed in an ``OriginRequestPolicy``*are* included in origin requests.
                 +  ``whitelist`` – Only the cookies in viewer requests that are listed in the ``CookieNames`` type are included in the cache key and in requests that CloudFront sends to the origin.
                 +  ``allExcept`` – All cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin, *except* for those that are listed in the ``CookieNames`` type, which are not included.
                 +  ``all`` – All cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cookies: Contains a list of cookie names.
        """
        pulumi.set(__self__, "cookie_behavior", cookie_behavior)
        if cookies is not None:
            pulumi.set(__self__, "cookies", cookies)

    @property
    @pulumi.getter(name="cookieBehavior")
    def cookie_behavior(self) -> pulumi.Input[builtins.str]:
        """
        Determines whether any cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin. Valid values are:
          +  ``none`` – No cookies in viewer requests are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any cookies that are listed in an ``OriginRequestPolicy``*are* included in origin requests.
          +  ``whitelist`` – Only the cookies in viewer requests that are listed in the ``CookieNames`` type are included in the cache key and in requests that CloudFront sends to the origin.
          +  ``allExcept`` – All cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin, *except* for those that are listed in the ``CookieNames`` type, which are not included.
          +  ``all`` – All cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin.
        """
        return pulumi.get(self, "cookie_behavior")

    @cookie_behavior.setter
    def cookie_behavior(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cookie_behavior", value)

    @property
    @pulumi.getter
    def cookies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Contains a list of cookie names.
        """
        return pulumi.get(self, "cookies")

    @cookies.setter
    def cookies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "cookies", value)


if not MYPY:
    class CachePolicyHeadersConfigArgsDict(TypedDict):
        """
        An object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and in requests that CloudFront sends to the origin.
        """
        header_behavior: pulumi.Input[builtins.str]
        """
        Determines whether any HTTP headers are included in the cache key and in requests that CloudFront sends to the origin. Valid values are:
          +  ``none`` – No HTTP headers are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any headers that are listed in an ``OriginRequestPolicy``*are* included in origin requests.
          +  ``whitelist`` – Only the HTTP headers that are listed in the ``Headers`` type are included in the cache key and in requests that CloudFront sends to the origin.
        """
        headers: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Contains a list of HTTP header names.
        """
elif False:
    CachePolicyHeadersConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CachePolicyHeadersConfigArgs:
    def __init__(__self__, *,
                 header_behavior: pulumi.Input[builtins.str],
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        An object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and in requests that CloudFront sends to the origin.
        :param pulumi.Input[builtins.str] header_behavior: Determines whether any HTTP headers are included in the cache key and in requests that CloudFront sends to the origin. Valid values are:
                 +  ``none`` – No HTTP headers are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any headers that are listed in an ``OriginRequestPolicy``*are* included in origin requests.
                 +  ``whitelist`` – Only the HTTP headers that are listed in the ``Headers`` type are included in the cache key and in requests that CloudFront sends to the origin.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] headers: Contains a list of HTTP header names.
        """
        pulumi.set(__self__, "header_behavior", header_behavior)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)

    @property
    @pulumi.getter(name="headerBehavior")
    def header_behavior(self) -> pulumi.Input[builtins.str]:
        """
        Determines whether any HTTP headers are included in the cache key and in requests that CloudFront sends to the origin. Valid values are:
          +  ``none`` – No HTTP headers are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any headers that are listed in an ``OriginRequestPolicy``*are* included in origin requests.
          +  ``whitelist`` – Only the HTTP headers that are listed in the ``Headers`` type are included in the cache key and in requests that CloudFront sends to the origin.
        """
        return pulumi.get(self, "header_behavior")

    @header_behavior.setter
    def header_behavior(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "header_behavior", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Contains a list of HTTP header names.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "headers", value)


if not MYPY:
    class CachePolicyParametersInCacheKeyAndForwardedToOriginArgsDict(TypedDict):
        """
        This object determines the values that CloudFront includes in the cache key. These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
         The headers, cookies, and query strings that are included in the cache key are also included in requests that CloudFront sends to the origin. CloudFront sends a request when it can't find an object in its cache that matches the request's cache key. If you want to send values to the origin but *not* include them in the cache key, use ``OriginRequestPolicy``.
        """
        cookies_config: pulumi.Input['CachePolicyCookiesConfigArgsDict']
        """
        An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and in requests that CloudFront sends to the origin.
        """
        enable_accept_encoding_gzip: pulumi.Input[builtins.bool]
        """
        A flag that can affect whether the ``Accept-Encoding`` HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
         This field is related to the ``EnableAcceptEncodingBrotli`` field. If one or both of these fields is ``true``*and* the viewer request includes the ``Accept-Encoding`` header, then CloudFront does the following:
          +  Normalizes the value of the viewer's ``Accept-Encoding`` header
          +  Includes the normalized header in the cache key
          +  Includes the normalized header in the request to the origin, if a request is necessary
          
         For more information, see [Compression support](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects) in the *Amazon CloudFront Developer Guide*.
         If you set this value to ``true``, and this cache behavior also has an origin request policy attached, do not include the ``Accept-Encoding`` header in the origin request policy. CloudFront always includes the ``Accept-Encoding`` header in origin requests when the value of this field is ``true``, so including this header in an origin request policy has no effect.
         If both of these fields are ``false``, then CloudFront treats the ``Accept-Encoding`` header the same as any other HTTP header in the viewer request. By default, it's not included in the cache key and it's not included in origin requests. In this case, you can manually add ``Accept-Encoding`` to the headers whitelist like any other HTTP header.
        """
        headers_config: pulumi.Input['CachePolicyHeadersConfigArgsDict']
        """
        An object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and in requests that CloudFront sends to the origin.
        """
        query_strings_config: pulumi.Input['CachePolicyQueryStringsConfigArgsDict']
        """
        An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and in requests that CloudFront sends to the origin.
        """
        enable_accept_encoding_brotli: NotRequired[pulumi.Input[builtins.bool]]
        """
        A flag that can affect whether the ``Accept-Encoding`` HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
         This field is related to the ``EnableAcceptEncodingGzip`` field. If one or both of these fields is ``true``*and* the viewer request includes the ``Accept-Encoding`` header, then CloudFront does the following:
          +  Normalizes the value of the viewer's ``Accept-Encoding`` header
          +  Includes the normalized header in the cache key
          +  Includes the normalized header in the request to the origin, if a request is necessary
          
         For more information, see [Compression support](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects) in the *Amazon CloudFront Developer Guide*.
         If you set this value to ``true``, and this cache behavior also has an origin request policy attached, do not include the ``Accept-Encoding`` header in the origin request policy. CloudFront always includes the ``Accept-Encoding`` header in origin requests when the value of this field is ``true``, so including this header in an origin request policy has no effect.
         If both of these fields are ``false``, then CloudFront treats the ``Accept-Encoding`` header the same as any other HTTP header in the viewer request. By default, it's not included in the cache key and it's not included in origin requests. In this case, you can manually add ``Accept-Encoding`` to the headers whitelist like any other HTTP header.
        """
elif False:
    CachePolicyParametersInCacheKeyAndForwardedToOriginArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CachePolicyParametersInCacheKeyAndForwardedToOriginArgs:
    def __init__(__self__, *,
                 cookies_config: pulumi.Input['CachePolicyCookiesConfigArgs'],
                 enable_accept_encoding_gzip: pulumi.Input[builtins.bool],
                 headers_config: pulumi.Input['CachePolicyHeadersConfigArgs'],
                 query_strings_config: pulumi.Input['CachePolicyQueryStringsConfigArgs'],
                 enable_accept_encoding_brotli: Optional[pulumi.Input[builtins.bool]] = None):
        """
        This object determines the values that CloudFront includes in the cache key. These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
         The headers, cookies, and query strings that are included in the cache key are also included in requests that CloudFront sends to the origin. CloudFront sends a request when it can't find an object in its cache that matches the request's cache key. If you want to send values to the origin but *not* include them in the cache key, use ``OriginRequestPolicy``.
        :param pulumi.Input['CachePolicyCookiesConfigArgs'] cookies_config: An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and in requests that CloudFront sends to the origin.
        :param pulumi.Input[builtins.bool] enable_accept_encoding_gzip: A flag that can affect whether the ``Accept-Encoding`` HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
                This field is related to the ``EnableAcceptEncodingBrotli`` field. If one or both of these fields is ``true``*and* the viewer request includes the ``Accept-Encoding`` header, then CloudFront does the following:
                 +  Normalizes the value of the viewer's ``Accept-Encoding`` header
                 +  Includes the normalized header in the cache key
                 +  Includes the normalized header in the request to the origin, if a request is necessary
                 
                For more information, see [Compression support](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects) in the *Amazon CloudFront Developer Guide*.
                If you set this value to ``true``, and this cache behavior also has an origin request policy attached, do not include the ``Accept-Encoding`` header in the origin request policy. CloudFront always includes the ``Accept-Encoding`` header in origin requests when the value of this field is ``true``, so including this header in an origin request policy has no effect.
                If both of these fields are ``false``, then CloudFront treats the ``Accept-Encoding`` header the same as any other HTTP header in the viewer request. By default, it's not included in the cache key and it's not included in origin requests. In this case, you can manually add ``Accept-Encoding`` to the headers whitelist like any other HTTP header.
        :param pulumi.Input['CachePolicyHeadersConfigArgs'] headers_config: An object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and in requests that CloudFront sends to the origin.
        :param pulumi.Input['CachePolicyQueryStringsConfigArgs'] query_strings_config: An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and in requests that CloudFront sends to the origin.
        :param pulumi.Input[builtins.bool] enable_accept_encoding_brotli: A flag that can affect whether the ``Accept-Encoding`` HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
                This field is related to the ``EnableAcceptEncodingGzip`` field. If one or both of these fields is ``true``*and* the viewer request includes the ``Accept-Encoding`` header, then CloudFront does the following:
                 +  Normalizes the value of the viewer's ``Accept-Encoding`` header
                 +  Includes the normalized header in the cache key
                 +  Includes the normalized header in the request to the origin, if a request is necessary
                 
                For more information, see [Compression support](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects) in the *Amazon CloudFront Developer Guide*.
                If you set this value to ``true``, and this cache behavior also has an origin request policy attached, do not include the ``Accept-Encoding`` header in the origin request policy. CloudFront always includes the ``Accept-Encoding`` header in origin requests when the value of this field is ``true``, so including this header in an origin request policy has no effect.
                If both of these fields are ``false``, then CloudFront treats the ``Accept-Encoding`` header the same as any other HTTP header in the viewer request. By default, it's not included in the cache key and it's not included in origin requests. In this case, you can manually add ``Accept-Encoding`` to the headers whitelist like any other HTTP header.
        """
        pulumi.set(__self__, "cookies_config", cookies_config)
        pulumi.set(__self__, "enable_accept_encoding_gzip", enable_accept_encoding_gzip)
        pulumi.set(__self__, "headers_config", headers_config)
        pulumi.set(__self__, "query_strings_config", query_strings_config)
        if enable_accept_encoding_brotli is not None:
            pulumi.set(__self__, "enable_accept_encoding_brotli", enable_accept_encoding_brotli)

    @property
    @pulumi.getter(name="cookiesConfig")
    def cookies_config(self) -> pulumi.Input['CachePolicyCookiesConfigArgs']:
        """
        An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and in requests that CloudFront sends to the origin.
        """
        return pulumi.get(self, "cookies_config")

    @cookies_config.setter
    def cookies_config(self, value: pulumi.Input['CachePolicyCookiesConfigArgs']):
        pulumi.set(self, "cookies_config", value)

    @property
    @pulumi.getter(name="enableAcceptEncodingGzip")
    def enable_accept_encoding_gzip(self) -> pulumi.Input[builtins.bool]:
        """
        A flag that can affect whether the ``Accept-Encoding`` HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
         This field is related to the ``EnableAcceptEncodingBrotli`` field. If one or both of these fields is ``true``*and* the viewer request includes the ``Accept-Encoding`` header, then CloudFront does the following:
          +  Normalizes the value of the viewer's ``Accept-Encoding`` header
          +  Includes the normalized header in the cache key
          +  Includes the normalized header in the request to the origin, if a request is necessary
          
         For more information, see [Compression support](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects) in the *Amazon CloudFront Developer Guide*.
         If you set this value to ``true``, and this cache behavior also has an origin request policy attached, do not include the ``Accept-Encoding`` header in the origin request policy. CloudFront always includes the ``Accept-Encoding`` header in origin requests when the value of this field is ``true``, so including this header in an origin request policy has no effect.
         If both of these fields are ``false``, then CloudFront treats the ``Accept-Encoding`` header the same as any other HTTP header in the viewer request. By default, it's not included in the cache key and it's not included in origin requests. In this case, you can manually add ``Accept-Encoding`` to the headers whitelist like any other HTTP header.
        """
        return pulumi.get(self, "enable_accept_encoding_gzip")

    @enable_accept_encoding_gzip.setter
    def enable_accept_encoding_gzip(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enable_accept_encoding_gzip", value)

    @property
    @pulumi.getter(name="headersConfig")
    def headers_config(self) -> pulumi.Input['CachePolicyHeadersConfigArgs']:
        """
        An object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and in requests that CloudFront sends to the origin.
        """
        return pulumi.get(self, "headers_config")

    @headers_config.setter
    def headers_config(self, value: pulumi.Input['CachePolicyHeadersConfigArgs']):
        pulumi.set(self, "headers_config", value)

    @property
    @pulumi.getter(name="queryStringsConfig")
    def query_strings_config(self) -> pulumi.Input['CachePolicyQueryStringsConfigArgs']:
        """
        An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and in requests that CloudFront sends to the origin.
        """
        return pulumi.get(self, "query_strings_config")

    @query_strings_config.setter
    def query_strings_config(self, value: pulumi.Input['CachePolicyQueryStringsConfigArgs']):
        pulumi.set(self, "query_strings_config", value)

    @property
    @pulumi.getter(name="enableAcceptEncodingBrotli")
    def enable_accept_encoding_brotli(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A flag that can affect whether the ``Accept-Encoding`` HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
         This field is related to the ``EnableAcceptEncodingGzip`` field. If one or both of these fields is ``true``*and* the viewer request includes the ``Accept-Encoding`` header, then CloudFront does the following:
          +  Normalizes the value of the viewer's ``Accept-Encoding`` header
          +  Includes the normalized header in the cache key
          +  Includes the normalized header in the request to the origin, if a request is necessary
          
         For more information, see [Compression support](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects) in the *Amazon CloudFront Developer Guide*.
         If you set this value to ``true``, and this cache behavior also has an origin request policy attached, do not include the ``Accept-Encoding`` header in the origin request policy. CloudFront always includes the ``Accept-Encoding`` header in origin requests when the value of this field is ``true``, so including this header in an origin request policy has no effect.
         If both of these fields are ``false``, then CloudFront treats the ``Accept-Encoding`` header the same as any other HTTP header in the viewer request. By default, it's not included in the cache key and it's not included in origin requests. In this case, you can manually add ``Accept-Encoding`` to the headers whitelist like any other HTTP header.
        """
        return pulumi.get(self, "enable_accept_encoding_brotli")

    @enable_accept_encoding_brotli.setter
    def enable_accept_encoding_brotli(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_accept_encoding_brotli", value)


if not MYPY:
    class CachePolicyQueryStringsConfigArgsDict(TypedDict):
        """
        An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and in requests that CloudFront sends to the origin.
        """
        query_string_behavior: pulumi.Input[builtins.str]
        """
        Determines whether any URL query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin. Valid values are:
          +  ``none`` – No query strings in viewer requests are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any query strings that are listed in an ``OriginRequestPolicy``*are* included in origin requests.
          +  ``whitelist`` – Only the query strings in viewer requests that are listed in the ``QueryStringNames`` type are included in the cache key and in requests that CloudFront sends to the origin.
          +  ``allExcept`` – All query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin, *except* those that are listed in the ``QueryStringNames`` type, which are not included.
          +  ``all`` – All query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin.
        """
        query_strings: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Contains a list of query string names.
        """
elif False:
    CachePolicyQueryStringsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CachePolicyQueryStringsConfigArgs:
    def __init__(__self__, *,
                 query_string_behavior: pulumi.Input[builtins.str],
                 query_strings: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and in requests that CloudFront sends to the origin.
        :param pulumi.Input[builtins.str] query_string_behavior: Determines whether any URL query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin. Valid values are:
                 +  ``none`` – No query strings in viewer requests are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any query strings that are listed in an ``OriginRequestPolicy``*are* included in origin requests.
                 +  ``whitelist`` – Only the query strings in viewer requests that are listed in the ``QueryStringNames`` type are included in the cache key and in requests that CloudFront sends to the origin.
                 +  ``allExcept`` – All query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin, *except* those that are listed in the ``QueryStringNames`` type, which are not included.
                 +  ``all`` – All query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] query_strings: Contains a list of query string names.
        """
        pulumi.set(__self__, "query_string_behavior", query_string_behavior)
        if query_strings is not None:
            pulumi.set(__self__, "query_strings", query_strings)

    @property
    @pulumi.getter(name="queryStringBehavior")
    def query_string_behavior(self) -> pulumi.Input[builtins.str]:
        """
        Determines whether any URL query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin. Valid values are:
          +  ``none`` – No query strings in viewer requests are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any query strings that are listed in an ``OriginRequestPolicy``*are* included in origin requests.
          +  ``whitelist`` – Only the query strings in viewer requests that are listed in the ``QueryStringNames`` type are included in the cache key and in requests that CloudFront sends to the origin.
          +  ``allExcept`` – All query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin, *except* those that are listed in the ``QueryStringNames`` type, which are not included.
          +  ``all`` – All query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin.
        """
        return pulumi.get(self, "query_string_behavior")

    @query_string_behavior.setter
    def query_string_behavior(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "query_string_behavior", value)

    @property
    @pulumi.getter(name="queryStrings")
    def query_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Contains a list of query string names.
        """
        return pulumi.get(self, "query_strings")

    @query_strings.setter
    def query_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "query_strings", value)


if not MYPY:
    class CloudFrontOriginAccessIdentityConfigArgsDict(TypedDict):
        """
        Origin access identity configuration. Send a ``GET`` request to the ``/CloudFront API version/CloudFront/identity ID/config`` resource.
        """
        comment: pulumi.Input[builtins.str]
        """
        A comment to describe the origin access identity. The comment cannot be longer than 128 characters.
        """
elif False:
    CloudFrontOriginAccessIdentityConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CloudFrontOriginAccessIdentityConfigArgs:
    def __init__(__self__, *,
                 comment: pulumi.Input[builtins.str]):
        """
        Origin access identity configuration. Send a ``GET`` request to the ``/CloudFront API version/CloudFront/identity ID/config`` resource.
        :param pulumi.Input[builtins.str] comment: A comment to describe the origin access identity. The comment cannot be longer than 128 characters.
        """
        pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Input[builtins.str]:
        """
        A comment to describe the origin access identity. The comment cannot be longer than 128 characters.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "comment", value)


if not MYPY:
    class ContinuousDeploymentPolicyConfigSingleHeaderPolicyConfigPropertiesArgsDict(TypedDict):
        """
        This configuration determines which HTTP requests are sent to the staging distribution. If the HTTP request contains a header and value that matches what you specify here, the request is sent to the staging distribution. Otherwise the request is sent to the primary distribution.
        """
        header: pulumi.Input[builtins.str]
        value: pulumi.Input[builtins.str]
elif False:
    ContinuousDeploymentPolicyConfigSingleHeaderPolicyConfigPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContinuousDeploymentPolicyConfigSingleHeaderPolicyConfigPropertiesArgs:
    def __init__(__self__, *,
                 header: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        This configuration determines which HTTP requests are sent to the staging distribution. If the HTTP request contains a header and value that matches what you specify here, the request is sent to the staging distribution. Otherwise the request is sent to the primary distribution.
        """
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def header(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "header")

    @header.setter
    def header(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "header", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigPropertiesArgsDict(TypedDict):
        """
        This configuration determines the percentage of HTTP requests that are sent to the staging distribution.
        """
        weight: pulumi.Input[builtins.float]
        session_stickiness_config: NotRequired[pulumi.Input['ContinuousDeploymentPolicySessionStickinessConfigArgsDict']]
elif False:
    ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigPropertiesArgs:
    def __init__(__self__, *,
                 weight: pulumi.Input[builtins.float],
                 session_stickiness_config: Optional[pulumi.Input['ContinuousDeploymentPolicySessionStickinessConfigArgs']] = None):
        """
        This configuration determines the percentage of HTTP requests that are sent to the staging distribution.
        """
        pulumi.set(__self__, "weight", weight)
        if session_stickiness_config is not None:
            pulumi.set(__self__, "session_stickiness_config", session_stickiness_config)

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Input[builtins.float]:
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "weight", value)

    @property
    @pulumi.getter(name="sessionStickinessConfig")
    def session_stickiness_config(self) -> Optional[pulumi.Input['ContinuousDeploymentPolicySessionStickinessConfigArgs']]:
        return pulumi.get(self, "session_stickiness_config")

    @session_stickiness_config.setter
    def session_stickiness_config(self, value: Optional[pulumi.Input['ContinuousDeploymentPolicySessionStickinessConfigArgs']]):
        pulumi.set(self, "session_stickiness_config", value)


if not MYPY:
    class ContinuousDeploymentPolicyConfigArgsDict(TypedDict):
        """
        Contains the configuration for a continuous deployment policy.
        """
        enabled: pulumi.Input[builtins.bool]
        """
        A Boolean that indicates whether this continuous deployment policy is enabled (in effect). When this value is ``true``, this policy is enabled and in effect. When this value is ``false``, this policy is not enabled and has no effect.
        """
        staging_distribution_dns_names: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The CloudFront domain name of the staging distribution. For example: ``d111111abcdef8.cloudfront.net``.
        """
        single_header_policy_config: NotRequired[pulumi.Input['ContinuousDeploymentPolicyConfigSingleHeaderPolicyConfigPropertiesArgsDict']]
        """
        This configuration determines which HTTP requests are sent to the staging distribution. If the HTTP request contains a header and value that matches what you specify here, the request is sent to the staging distribution. Otherwise the request is sent to the primary distribution.
        """
        single_weight_policy_config: NotRequired[pulumi.Input['ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigPropertiesArgsDict']]
        """
        This configuration determines the percentage of HTTP requests that are sent to the staging distribution.
        """
        traffic_config: NotRequired[pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgsDict']]
        """
        Contains the parameters for routing production traffic from your primary to staging distributions.
        """
        type: NotRequired[pulumi.Input['ContinuousDeploymentPolicyConfigType']]
        """
        The type of traffic configuration.
        """
elif False:
    ContinuousDeploymentPolicyConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContinuousDeploymentPolicyConfigArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 staging_distribution_dns_names: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 single_header_policy_config: Optional[pulumi.Input['ContinuousDeploymentPolicyConfigSingleHeaderPolicyConfigPropertiesArgs']] = None,
                 single_weight_policy_config: Optional[pulumi.Input['ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigPropertiesArgs']] = None,
                 traffic_config: Optional[pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgs']] = None,
                 type: Optional[pulumi.Input['ContinuousDeploymentPolicyConfigType']] = None):
        """
        Contains the configuration for a continuous deployment policy.
        :param pulumi.Input[builtins.bool] enabled: A Boolean that indicates whether this continuous deployment policy is enabled (in effect). When this value is ``true``, this policy is enabled and in effect. When this value is ``false``, this policy is not enabled and has no effect.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] staging_distribution_dns_names: The CloudFront domain name of the staging distribution. For example: ``d111111abcdef8.cloudfront.net``.
        :param pulumi.Input['ContinuousDeploymentPolicyConfigSingleHeaderPolicyConfigPropertiesArgs'] single_header_policy_config: This configuration determines which HTTP requests are sent to the staging distribution. If the HTTP request contains a header and value that matches what you specify here, the request is sent to the staging distribution. Otherwise the request is sent to the primary distribution.
        :param pulumi.Input['ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigPropertiesArgs'] single_weight_policy_config: This configuration determines the percentage of HTTP requests that are sent to the staging distribution.
        :param pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgs'] traffic_config: Contains the parameters for routing production traffic from your primary to staging distributions.
        :param pulumi.Input['ContinuousDeploymentPolicyConfigType'] type: The type of traffic configuration.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "staging_distribution_dns_names", staging_distribution_dns_names)
        if single_header_policy_config is not None:
            pulumi.set(__self__, "single_header_policy_config", single_header_policy_config)
        if single_weight_policy_config is not None:
            pulumi.set(__self__, "single_weight_policy_config", single_weight_policy_config)
        if traffic_config is not None:
            pulumi.set(__self__, "traffic_config", traffic_config)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        A Boolean that indicates whether this continuous deployment policy is enabled (in effect). When this value is ``true``, this policy is enabled and in effect. When this value is ``false``, this policy is not enabled and has no effect.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="stagingDistributionDnsNames")
    def staging_distribution_dns_names(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The CloudFront domain name of the staging distribution. For example: ``d111111abcdef8.cloudfront.net``.
        """
        return pulumi.get(self, "staging_distribution_dns_names")

    @staging_distribution_dns_names.setter
    def staging_distribution_dns_names(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "staging_distribution_dns_names", value)

    @property
    @pulumi.getter(name="singleHeaderPolicyConfig")
    def single_header_policy_config(self) -> Optional[pulumi.Input['ContinuousDeploymentPolicyConfigSingleHeaderPolicyConfigPropertiesArgs']]:
        """
        This configuration determines which HTTP requests are sent to the staging distribution. If the HTTP request contains a header and value that matches what you specify here, the request is sent to the staging distribution. Otherwise the request is sent to the primary distribution.
        """
        return pulumi.get(self, "single_header_policy_config")

    @single_header_policy_config.setter
    def single_header_policy_config(self, value: Optional[pulumi.Input['ContinuousDeploymentPolicyConfigSingleHeaderPolicyConfigPropertiesArgs']]):
        pulumi.set(self, "single_header_policy_config", value)

    @property
    @pulumi.getter(name="singleWeightPolicyConfig")
    def single_weight_policy_config(self) -> Optional[pulumi.Input['ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigPropertiesArgs']]:
        """
        This configuration determines the percentage of HTTP requests that are sent to the staging distribution.
        """
        return pulumi.get(self, "single_weight_policy_config")

    @single_weight_policy_config.setter
    def single_weight_policy_config(self, value: Optional[pulumi.Input['ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigPropertiesArgs']]):
        pulumi.set(self, "single_weight_policy_config", value)

    @property
    @pulumi.getter(name="trafficConfig")
    def traffic_config(self) -> Optional[pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgs']]:
        """
        Contains the parameters for routing production traffic from your primary to staging distributions.
        """
        return pulumi.get(self, "traffic_config")

    @traffic_config.setter
    def traffic_config(self, value: Optional[pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgs']]):
        pulumi.set(self, "traffic_config", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ContinuousDeploymentPolicyConfigType']]:
        """
        The type of traffic configuration.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ContinuousDeploymentPolicyConfigType']]):
        pulumi.set(self, "type", value)


if not MYPY:
    class ContinuousDeploymentPolicySessionStickinessConfigArgsDict(TypedDict):
        """
        Session stickiness provides the ability to define multiple requests from a single viewer as a single session. This prevents the potentially inconsistent experience of sending some of a given user's requests to your staging distribution, while others are sent to your primary distribution. Define the session duration using TTL values.
        """
        idle_ttl: pulumi.Input[builtins.int]
        """
        The amount of time after which you want sessions to cease if no requests are received. Allowed values are 300–3600 seconds (5–60 minutes).
        """
        maximum_ttl: pulumi.Input[builtins.int]
        """
        The maximum amount of time to consider requests from the viewer as being part of the same session. Allowed values are 300–3600 seconds (5–60 minutes).
        """
elif False:
    ContinuousDeploymentPolicySessionStickinessConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContinuousDeploymentPolicySessionStickinessConfigArgs:
    def __init__(__self__, *,
                 idle_ttl: pulumi.Input[builtins.int],
                 maximum_ttl: pulumi.Input[builtins.int]):
        """
        Session stickiness provides the ability to define multiple requests from a single viewer as a single session. This prevents the potentially inconsistent experience of sending some of a given user's requests to your staging distribution, while others are sent to your primary distribution. Define the session duration using TTL values.
        :param pulumi.Input[builtins.int] idle_ttl: The amount of time after which you want sessions to cease if no requests are received. Allowed values are 300–3600 seconds (5–60 minutes).
        :param pulumi.Input[builtins.int] maximum_ttl: The maximum amount of time to consider requests from the viewer as being part of the same session. Allowed values are 300–3600 seconds (5–60 minutes).
        """
        pulumi.set(__self__, "idle_ttl", idle_ttl)
        pulumi.set(__self__, "maximum_ttl", maximum_ttl)

    @property
    @pulumi.getter(name="idleTtl")
    def idle_ttl(self) -> pulumi.Input[builtins.int]:
        """
        The amount of time after which you want sessions to cease if no requests are received. Allowed values are 300–3600 seconds (5–60 minutes).
        """
        return pulumi.get(self, "idle_ttl")

    @idle_ttl.setter
    def idle_ttl(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "idle_ttl", value)

    @property
    @pulumi.getter(name="maximumTtl")
    def maximum_ttl(self) -> pulumi.Input[builtins.int]:
        """
        The maximum amount of time to consider requests from the viewer as being part of the same session. Allowed values are 300–3600 seconds (5–60 minutes).
        """
        return pulumi.get(self, "maximum_ttl")

    @maximum_ttl.setter
    def maximum_ttl(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "maximum_ttl", value)


if not MYPY:
    class ContinuousDeploymentPolicySingleHeaderConfigArgsDict(TypedDict):
        """
        Determines which HTTP requests are sent to the staging distribution.
        """
        header: pulumi.Input[builtins.str]
        """
        The request header name that you want CloudFront to send to your staging distribution. The header must contain the prefix ``aws-cf-cd-``.
        """
        value: pulumi.Input[builtins.str]
        """
        The request header value.
        """
elif False:
    ContinuousDeploymentPolicySingleHeaderConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContinuousDeploymentPolicySingleHeaderConfigArgs:
    def __init__(__self__, *,
                 header: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        Determines which HTTP requests are sent to the staging distribution.
        :param pulumi.Input[builtins.str] header: The request header name that you want CloudFront to send to your staging distribution. The header must contain the prefix ``aws-cf-cd-``.
        :param pulumi.Input[builtins.str] value: The request header value.
        """
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def header(self) -> pulumi.Input[builtins.str]:
        """
        The request header name that you want CloudFront to send to your staging distribution. The header must contain the prefix ``aws-cf-cd-``.
        """
        return pulumi.get(self, "header")

    @header.setter
    def header(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "header", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        The request header value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ContinuousDeploymentPolicySingleWeightConfigArgsDict(TypedDict):
        """
        This configuration determines the percentage of HTTP requests that are sent to the staging distribution.
        """
        weight: pulumi.Input[builtins.float]
        """
        The percentage of traffic to send to a staging distribution, expressed as a decimal number between 0 and 0.15. For example, a value of 0.10 means 10% of traffic is sent to the staging distribution.
        """
        session_stickiness_config: NotRequired[pulumi.Input['ContinuousDeploymentPolicySessionStickinessConfigArgsDict']]
        """
        Session stickiness provides the ability to define multiple requests from a single viewer as a single session. This prevents the potentially inconsistent experience of sending some of a given user's requests to your staging distribution, while others are sent to your primary distribution. Define the session duration using TTL values.
        """
elif False:
    ContinuousDeploymentPolicySingleWeightConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContinuousDeploymentPolicySingleWeightConfigArgs:
    def __init__(__self__, *,
                 weight: pulumi.Input[builtins.float],
                 session_stickiness_config: Optional[pulumi.Input['ContinuousDeploymentPolicySessionStickinessConfigArgs']] = None):
        """
        This configuration determines the percentage of HTTP requests that are sent to the staging distribution.
        :param pulumi.Input[builtins.float] weight: The percentage of traffic to send to a staging distribution, expressed as a decimal number between 0 and 0.15. For example, a value of 0.10 means 10% of traffic is sent to the staging distribution.
        :param pulumi.Input['ContinuousDeploymentPolicySessionStickinessConfigArgs'] session_stickiness_config: Session stickiness provides the ability to define multiple requests from a single viewer as a single session. This prevents the potentially inconsistent experience of sending some of a given user's requests to your staging distribution, while others are sent to your primary distribution. Define the session duration using TTL values.
        """
        pulumi.set(__self__, "weight", weight)
        if session_stickiness_config is not None:
            pulumi.set(__self__, "session_stickiness_config", session_stickiness_config)

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Input[builtins.float]:
        """
        The percentage of traffic to send to a staging distribution, expressed as a decimal number between 0 and 0.15. For example, a value of 0.10 means 10% of traffic is sent to the staging distribution.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "weight", value)

    @property
    @pulumi.getter(name="sessionStickinessConfig")
    def session_stickiness_config(self) -> Optional[pulumi.Input['ContinuousDeploymentPolicySessionStickinessConfigArgs']]:
        """
        Session stickiness provides the ability to define multiple requests from a single viewer as a single session. This prevents the potentially inconsistent experience of sending some of a given user's requests to your staging distribution, while others are sent to your primary distribution. Define the session duration using TTL values.
        """
        return pulumi.get(self, "session_stickiness_config")

    @session_stickiness_config.setter
    def session_stickiness_config(self, value: Optional[pulumi.Input['ContinuousDeploymentPolicySessionStickinessConfigArgs']]):
        pulumi.set(self, "session_stickiness_config", value)


if not MYPY:
    class ContinuousDeploymentPolicyTrafficConfigArgsDict(TypedDict):
        """
        The traffic configuration of your continuous deployment.
        """
        type: pulumi.Input['ContinuousDeploymentPolicyTrafficConfigType']
        """
        The type of traffic configuration.
        """
        single_header_config: NotRequired[pulumi.Input['ContinuousDeploymentPolicySingleHeaderConfigArgsDict']]
        """
        Determines which HTTP requests are sent to the staging distribution.
        """
        single_weight_config: NotRequired[pulumi.Input['ContinuousDeploymentPolicySingleWeightConfigArgsDict']]
        """
        Contains the percentage of traffic to send to the staging distribution.
        """
elif False:
    ContinuousDeploymentPolicyTrafficConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContinuousDeploymentPolicyTrafficConfigArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['ContinuousDeploymentPolicyTrafficConfigType'],
                 single_header_config: Optional[pulumi.Input['ContinuousDeploymentPolicySingleHeaderConfigArgs']] = None,
                 single_weight_config: Optional[pulumi.Input['ContinuousDeploymentPolicySingleWeightConfigArgs']] = None):
        """
        The traffic configuration of your continuous deployment.
        :param pulumi.Input['ContinuousDeploymentPolicyTrafficConfigType'] type: The type of traffic configuration.
        :param pulumi.Input['ContinuousDeploymentPolicySingleHeaderConfigArgs'] single_header_config: Determines which HTTP requests are sent to the staging distribution.
        :param pulumi.Input['ContinuousDeploymentPolicySingleWeightConfigArgs'] single_weight_config: Contains the percentage of traffic to send to the staging distribution.
        """
        pulumi.set(__self__, "type", type)
        if single_header_config is not None:
            pulumi.set(__self__, "single_header_config", single_header_config)
        if single_weight_config is not None:
            pulumi.set(__self__, "single_weight_config", single_weight_config)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['ContinuousDeploymentPolicyTrafficConfigType']:
        """
        The type of traffic configuration.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['ContinuousDeploymentPolicyTrafficConfigType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="singleHeaderConfig")
    def single_header_config(self) -> Optional[pulumi.Input['ContinuousDeploymentPolicySingleHeaderConfigArgs']]:
        """
        Determines which HTTP requests are sent to the staging distribution.
        """
        return pulumi.get(self, "single_header_config")

    @single_header_config.setter
    def single_header_config(self, value: Optional[pulumi.Input['ContinuousDeploymentPolicySingleHeaderConfigArgs']]):
        pulumi.set(self, "single_header_config", value)

    @property
    @pulumi.getter(name="singleWeightConfig")
    def single_weight_config(self) -> Optional[pulumi.Input['ContinuousDeploymentPolicySingleWeightConfigArgs']]:
        """
        Contains the percentage of traffic to send to the staging distribution.
        """
        return pulumi.get(self, "single_weight_config")

    @single_weight_config.setter
    def single_weight_config(self, value: Optional[pulumi.Input['ContinuousDeploymentPolicySingleWeightConfigArgs']]):
        pulumi.set(self, "single_weight_config", value)


if not MYPY:
    class DistributionCacheBehaviorArgsDict(TypedDict):
        """
        A complex type that describes how CloudFront processes requests.
         You must create at least as many cache behaviors (including the default cache behavior) as you have origins if you want CloudFront to serve objects from all of the origins. Each cache behavior specifies the one origin from which you want CloudFront to get objects. If you have two origins and only the default cache behavior, the default cache behavior will cause CloudFront to get objects from one of the origins, but the other origin is never used.
         For the current quota (formerly known as limit) on the number of cache behaviors that you can add to a distribution, see [Quotas](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html) in the *Amazon CloudFront Developer Guide*.
         If you don't want to specify any cache behaviors, include only an empty ``CacheBehaviors`` element. Don't specify an empty individual ``CacheBehavior`` element, because this is invalid. For more information, see [CacheBehaviors](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CacheBehaviors.html). 
         To delete all cache behaviors in an existing distribution, update the distribution configuration and include only an empty ``CacheBehaviors`` element.
         To add, change, or remove one or more cache behaviors, update the distribution configuration and specify all of the cache behaviors that you want to include in the updated distribution.
         For more information about cache behaviors, see [Cache Behavior Settings](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesCacheBehavior) in the *Amazon CloudFront Developer Guide*.
        """
        path_pattern: pulumi.Input[builtins.str]
        """
        The pattern (for example, ``images/*.jpg``) that specifies which requests to apply the behavior to. When CloudFront receives a viewer request, the requested path is compared with path patterns in the order in which cache behaviors are listed in the distribution.
          You can optionally include a slash (``/``) at the beginning of the path pattern. For example, ``/images/*.jpg``. CloudFront behavior is the same with or without the leading ``/``.
          The path pattern for the default cache behavior is ``*`` and cannot be changed. If the request for an object does not match the path pattern for any cache behaviors, CloudFront applies the behavior in the default cache behavior.
         For more information, see [Path Pattern](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesPathPattern) in the *Amazon CloudFront Developer Guide*.
        """
        target_origin_id: pulumi.Input[builtins.str]
        """
        The value of ``ID`` for the origin that you want CloudFront to route requests to when they match this cache behavior.
        """
        viewer_protocol_policy: pulumi.Input[builtins.str]
        """
        The protocol that viewers can use to access the files in the origin specified by ``TargetOriginId`` when a request matches the path pattern in ``PathPattern``. You can specify the following options:
          +  ``allow-all``: Viewers can use HTTP or HTTPS.
          +  ``redirect-to-https``: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.
          +  ``https-only``: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).
          
         For more information about requiring the HTTPS protocol, see [Requiring HTTPS Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html) in the *Amazon CloudFront Developer Guide*.
          The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see [Managing Cache Expiration](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        allowed_methods: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin. There are three choices:
          +  CloudFront forwards only ``GET`` and ``HEAD`` requests.
          +  CloudFront forwards only ``GET``, ``HEAD``, and ``OPTIONS`` requests.
          +  CloudFront forwards ``GET, HEAD, OPTIONS, PUT, PATCH, POST``, and ``DELETE`` requests.
          
         If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
        """
        cache_policy_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The unique identifier of the cache policy that is attached to this cache behavior. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         A ``CacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
        """
        cached_methods: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods. There are two choices:
          +  CloudFront caches responses to ``GET`` and ``HEAD`` requests.
          +  CloudFront caches responses to ``GET``, ``HEAD``, and ``OPTIONS`` requests.
          
         If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
        """
        compress: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify true; if not, specify false. For more information, see [Serving Compressed Files](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html) in the *Amazon CloudFront Developer Guide*.
        """
        default_ttl: NotRequired[pulumi.Input[builtins.float]]
        """
        This field is deprecated. We recommend that you use the ``DefaultTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        field_level_encryption_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The value of ``ID`` for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for this cache behavior.
        """
        forwarded_values: NotRequired[pulumi.Input['DistributionForwardedValuesArgsDict']]
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see [Working with policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html) in the *Amazon CloudFront Developer Guide*.
         If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
         A ``CacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
         A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
        """
        function_associations: NotRequired[pulumi.Input[Sequence[pulumi.Input['DistributionFunctionAssociationArgsDict']]]]
        """
        A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must be published to the ``LIVE`` stage to associate them with a cache behavior.
        """
        grpc_config: NotRequired[pulumi.Input['DistributionGrpcConfigArgsDict']]
        """
        The gRPC configuration for your cache behavior.
        """
        lambda_function_associations: NotRequired[pulumi.Input[Sequence[pulumi.Input['DistributionLambdaFunctionAssociationArgsDict']]]]
        """
        A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
        """
        max_ttl: NotRequired[pulumi.Input[builtins.float]]
        """
        This field is deprecated. We recommend that you use the ``MaxTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        min_ttl: NotRequired[pulumi.Input[builtins.float]]
        """
        This field is deprecated. We recommend that you use the ``MinTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
         You must specify ``0`` for ``MinTTL`` if you configure CloudFront to forward all headers to your origin (under ``Headers``, if you specify ``1`` for ``Quantity`` and ``*`` for ``Name``).
        """
        origin_request_policy_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The unique identifier of the origin request policy that is attached to this cache behavior. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
        """
        realtime_log_config_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior. For more information, see [Real-time logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html) in the *Amazon CloudFront Developer Guide*.
        """
        response_headers_policy_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The identifier for a response headers policy.
        """
        smooth_streaming: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior. If so, specify ``true``; if not, specify ``false``. If you specify ``true`` for ``SmoothStreaming``, you can still distribute other content using this cache behavior if the content matches the value of ``PathPattern``.
        """
        trusted_key_groups: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
         When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        trusted_signers: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        We recommend using ``TrustedKeyGroups`` instead of ``TrustedSigners``.
          A list of AWS-account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.
         When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in the trusted signer's AWS-account. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
elif False:
    DistributionCacheBehaviorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionCacheBehaviorArgs:
    def __init__(__self__, *,
                 path_pattern: pulumi.Input[builtins.str],
                 target_origin_id: pulumi.Input[builtins.str],
                 viewer_protocol_policy: pulumi.Input[builtins.str],
                 allowed_methods: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 cache_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 cached_methods: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 compress: Optional[pulumi.Input[builtins.bool]] = None,
                 default_ttl: Optional[pulumi.Input[builtins.float]] = None,
                 field_level_encryption_id: Optional[pulumi.Input[builtins.str]] = None,
                 forwarded_values: Optional[pulumi.Input['DistributionForwardedValuesArgs']] = None,
                 function_associations: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionFunctionAssociationArgs']]]] = None,
                 grpc_config: Optional[pulumi.Input['DistributionGrpcConfigArgs']] = None,
                 lambda_function_associations: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionLambdaFunctionAssociationArgs']]]] = None,
                 max_ttl: Optional[pulumi.Input[builtins.float]] = None,
                 min_ttl: Optional[pulumi.Input[builtins.float]] = None,
                 origin_request_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 realtime_log_config_arn: Optional[pulumi.Input[builtins.str]] = None,
                 response_headers_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 smooth_streaming: Optional[pulumi.Input[builtins.bool]] = None,
                 trusted_key_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 trusted_signers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        A complex type that describes how CloudFront processes requests.
         You must create at least as many cache behaviors (including the default cache behavior) as you have origins if you want CloudFront to serve objects from all of the origins. Each cache behavior specifies the one origin from which you want CloudFront to get objects. If you have two origins and only the default cache behavior, the default cache behavior will cause CloudFront to get objects from one of the origins, but the other origin is never used.
         For the current quota (formerly known as limit) on the number of cache behaviors that you can add to a distribution, see [Quotas](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html) in the *Amazon CloudFront Developer Guide*.
         If you don't want to specify any cache behaviors, include only an empty ``CacheBehaviors`` element. Don't specify an empty individual ``CacheBehavior`` element, because this is invalid. For more information, see [CacheBehaviors](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CacheBehaviors.html). 
         To delete all cache behaviors in an existing distribution, update the distribution configuration and include only an empty ``CacheBehaviors`` element.
         To add, change, or remove one or more cache behaviors, update the distribution configuration and specify all of the cache behaviors that you want to include in the updated distribution.
         For more information about cache behaviors, see [Cache Behavior Settings](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesCacheBehavior) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.str] path_pattern: The pattern (for example, ``images/*.jpg``) that specifies which requests to apply the behavior to. When CloudFront receives a viewer request, the requested path is compared with path patterns in the order in which cache behaviors are listed in the distribution.
                 You can optionally include a slash (``/``) at the beginning of the path pattern. For example, ``/images/*.jpg``. CloudFront behavior is the same with or without the leading ``/``.
                 The path pattern for the default cache behavior is ``*`` and cannot be changed. If the request for an object does not match the path pattern for any cache behaviors, CloudFront applies the behavior in the default cache behavior.
                For more information, see [Path Pattern](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesPathPattern) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.str] target_origin_id: The value of ``ID`` for the origin that you want CloudFront to route requests to when they match this cache behavior.
        :param pulumi.Input[builtins.str] viewer_protocol_policy: The protocol that viewers can use to access the files in the origin specified by ``TargetOriginId`` when a request matches the path pattern in ``PathPattern``. You can specify the following options:
                 +  ``allow-all``: Viewers can use HTTP or HTTPS.
                 +  ``redirect-to-https``: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.
                 +  ``https-only``: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).
                 
                For more information about requiring the HTTPS protocol, see [Requiring HTTPS Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html) in the *Amazon CloudFront Developer Guide*.
                 The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see [Managing Cache Expiration](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_methods: A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin. There are three choices:
                 +  CloudFront forwards only ``GET`` and ``HEAD`` requests.
                 +  CloudFront forwards only ``GET``, ``HEAD``, and ``OPTIONS`` requests.
                 +  CloudFront forwards ``GET, HEAD, OPTIONS, PUT, PATCH, POST``, and ``DELETE`` requests.
                 
                If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
        :param pulumi.Input[builtins.str] cache_policy_id: The unique identifier of the cache policy that is attached to this cache behavior. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                A ``CacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cached_methods: A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods. There are two choices:
                 +  CloudFront caches responses to ``GET`` and ``HEAD`` requests.
                 +  CloudFront caches responses to ``GET``, ``HEAD``, and ``OPTIONS`` requests.
                 
                If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
        :param pulumi.Input[builtins.bool] compress: Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify true; if not, specify false. For more information, see [Serving Compressed Files](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.float] default_ttl: This field is deprecated. We recommend that you use the ``DefaultTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.str] field_level_encryption_id: The value of ``ID`` for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for this cache behavior.
        :param pulumi.Input['DistributionForwardedValuesArgs'] forwarded_values: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see [Working with policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html) in the *Amazon CloudFront Developer Guide*.
                If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
                A ``CacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
                A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionFunctionAssociationArgs']]] function_associations: A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must be published to the ``LIVE`` stage to associate them with a cache behavior.
        :param pulumi.Input['DistributionGrpcConfigArgs'] grpc_config: The gRPC configuration for your cache behavior.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionLambdaFunctionAssociationArgs']]] lambda_function_associations: A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
        :param pulumi.Input[builtins.float] max_ttl: This field is deprecated. We recommend that you use the ``MaxTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.float] min_ttl: This field is deprecated. We recommend that you use the ``MinTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
                You must specify ``0`` for ``MinTTL`` if you configure CloudFront to forward all headers to your origin (under ``Headers``, if you specify ``1`` for ``Quantity`` and ``*`` for ``Name``).
        :param pulumi.Input[builtins.str] origin_request_policy_id: The unique identifier of the origin request policy that is attached to this cache behavior. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.str] realtime_log_config_arn: The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior. For more information, see [Real-time logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.str] response_headers_policy_id: The identifier for a response headers policy.
        :param pulumi.Input[builtins.bool] smooth_streaming: Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior. If so, specify ``true``; if not, specify ``false``. If you specify ``true`` for ``SmoothStreaming``, you can still distribute other content using this cache behavior if the content matches the value of ``PathPattern``.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] trusted_key_groups: A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
                When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] trusted_signers: We recommend using ``TrustedKeyGroups`` instead of ``TrustedSigners``.
                 A list of AWS-account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.
                When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in the trusted signer's AWS-account. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        pulumi.set(__self__, "path_pattern", path_pattern)
        pulumi.set(__self__, "target_origin_id", target_origin_id)
        pulumi.set(__self__, "viewer_protocol_policy", viewer_protocol_policy)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if cache_policy_id is not None:
            pulumi.set(__self__, "cache_policy_id", cache_policy_id)
        if cached_methods is not None:
            pulumi.set(__self__, "cached_methods", cached_methods)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if field_level_encryption_id is not None:
            pulumi.set(__self__, "field_level_encryption_id", field_level_encryption_id)
        if forwarded_values is not None:
            pulumi.set(__self__, "forwarded_values", forwarded_values)
        if function_associations is not None:
            pulumi.set(__self__, "function_associations", function_associations)
        if grpc_config is not None:
            pulumi.set(__self__, "grpc_config", grpc_config)
        if lambda_function_associations is not None:
            pulumi.set(__self__, "lambda_function_associations", lambda_function_associations)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if min_ttl is not None:
            pulumi.set(__self__, "min_ttl", min_ttl)
        if origin_request_policy_id is not None:
            pulumi.set(__self__, "origin_request_policy_id", origin_request_policy_id)
        if realtime_log_config_arn is not None:
            pulumi.set(__self__, "realtime_log_config_arn", realtime_log_config_arn)
        if response_headers_policy_id is not None:
            pulumi.set(__self__, "response_headers_policy_id", response_headers_policy_id)
        if smooth_streaming is not None:
            pulumi.set(__self__, "smooth_streaming", smooth_streaming)
        if trusted_key_groups is not None:
            pulumi.set(__self__, "trusted_key_groups", trusted_key_groups)
        if trusted_signers is not None:
            pulumi.set(__self__, "trusted_signers", trusted_signers)

    @property
    @pulumi.getter(name="pathPattern")
    def path_pattern(self) -> pulumi.Input[builtins.str]:
        """
        The pattern (for example, ``images/*.jpg``) that specifies which requests to apply the behavior to. When CloudFront receives a viewer request, the requested path is compared with path patterns in the order in which cache behaviors are listed in the distribution.
          You can optionally include a slash (``/``) at the beginning of the path pattern. For example, ``/images/*.jpg``. CloudFront behavior is the same with or without the leading ``/``.
          The path pattern for the default cache behavior is ``*`` and cannot be changed. If the request for an object does not match the path pattern for any cache behaviors, CloudFront applies the behavior in the default cache behavior.
         For more information, see [Path Pattern](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesPathPattern) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "path_pattern")

    @path_pattern.setter
    def path_pattern(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "path_pattern", value)

    @property
    @pulumi.getter(name="targetOriginId")
    def target_origin_id(self) -> pulumi.Input[builtins.str]:
        """
        The value of ``ID`` for the origin that you want CloudFront to route requests to when they match this cache behavior.
        """
        return pulumi.get(self, "target_origin_id")

    @target_origin_id.setter
    def target_origin_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_origin_id", value)

    @property
    @pulumi.getter(name="viewerProtocolPolicy")
    def viewer_protocol_policy(self) -> pulumi.Input[builtins.str]:
        """
        The protocol that viewers can use to access the files in the origin specified by ``TargetOriginId`` when a request matches the path pattern in ``PathPattern``. You can specify the following options:
          +  ``allow-all``: Viewers can use HTTP or HTTPS.
          +  ``redirect-to-https``: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.
          +  ``https-only``: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).
          
         For more information about requiring the HTTPS protocol, see [Requiring HTTPS Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html) in the *Amazon CloudFront Developer Guide*.
          The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see [Managing Cache Expiration](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "viewer_protocol_policy")

    @viewer_protocol_policy.setter
    def viewer_protocol_policy(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "viewer_protocol_policy", value)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin. There are three choices:
          +  CloudFront forwards only ``GET`` and ``HEAD`` requests.
          +  CloudFront forwards only ``GET``, ``HEAD``, and ``OPTIONS`` requests.
          +  CloudFront forwards ``GET, HEAD, OPTIONS, PUT, PATCH, POST``, and ``DELETE`` requests.
          
         If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
        """
        return pulumi.get(self, "allowed_methods")

    @allowed_methods.setter
    def allowed_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_methods", value)

    @property
    @pulumi.getter(name="cachePolicyId")
    def cache_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier of the cache policy that is attached to this cache behavior. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         A ``CacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
        """
        return pulumi.get(self, "cache_policy_id")

    @cache_policy_id.setter
    def cache_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cache_policy_id", value)

    @property
    @pulumi.getter(name="cachedMethods")
    def cached_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods. There are two choices:
          +  CloudFront caches responses to ``GET`` and ``HEAD`` requests.
          +  CloudFront caches responses to ``GET``, ``HEAD``, and ``OPTIONS`` requests.
          
         If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
        """
        return pulumi.get(self, "cached_methods")

    @cached_methods.setter
    def cached_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "cached_methods", value)

    @property
    @pulumi.getter
    def compress(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify true; if not, specify false. For more information, see [Serving Compressed Files](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "compress")

    @compress.setter
    def compress(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "compress", value)

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        This field is deprecated. We recommend that you use the ``DefaultTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "default_ttl", value)

    @property
    @pulumi.getter(name="fieldLevelEncryptionId")
    def field_level_encryption_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value of ``ID`` for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for this cache behavior.
        """
        return pulumi.get(self, "field_level_encryption_id")

    @field_level_encryption_id.setter
    def field_level_encryption_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "field_level_encryption_id", value)

    @property
    @pulumi.getter(name="forwardedValues")
    def forwarded_values(self) -> Optional[pulumi.Input['DistributionForwardedValuesArgs']]:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see [Working with policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html) in the *Amazon CloudFront Developer Guide*.
         If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
         A ``CacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
         A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
        """
        return pulumi.get(self, "forwarded_values")

    @forwarded_values.setter
    def forwarded_values(self, value: Optional[pulumi.Input['DistributionForwardedValuesArgs']]):
        pulumi.set(self, "forwarded_values", value)

    @property
    @pulumi.getter(name="functionAssociations")
    def function_associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionFunctionAssociationArgs']]]]:
        """
        A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must be published to the ``LIVE`` stage to associate them with a cache behavior.
        """
        return pulumi.get(self, "function_associations")

    @function_associations.setter
    def function_associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionFunctionAssociationArgs']]]]):
        pulumi.set(self, "function_associations", value)

    @property
    @pulumi.getter(name="grpcConfig")
    def grpc_config(self) -> Optional[pulumi.Input['DistributionGrpcConfigArgs']]:
        """
        The gRPC configuration for your cache behavior.
        """
        return pulumi.get(self, "grpc_config")

    @grpc_config.setter
    def grpc_config(self, value: Optional[pulumi.Input['DistributionGrpcConfigArgs']]):
        pulumi.set(self, "grpc_config", value)

    @property
    @pulumi.getter(name="lambdaFunctionAssociations")
    def lambda_function_associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionLambdaFunctionAssociationArgs']]]]:
        """
        A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
        """
        return pulumi.get(self, "lambda_function_associations")

    @lambda_function_associations.setter
    def lambda_function_associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionLambdaFunctionAssociationArgs']]]]):
        pulumi.set(self, "lambda_function_associations", value)

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        This field is deprecated. We recommend that you use the ``MaxTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max_ttl", value)

    @property
    @pulumi.getter(name="minTtl")
    def min_ttl(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        This field is deprecated. We recommend that you use the ``MinTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
         You must specify ``0`` for ``MinTTL`` if you configure CloudFront to forward all headers to your origin (under ``Headers``, if you specify ``1`` for ``Quantity`` and ``*`` for ``Name``).
        """
        return pulumi.get(self, "min_ttl")

    @min_ttl.setter
    def min_ttl(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "min_ttl", value)

    @property
    @pulumi.getter(name="originRequestPolicyId")
    def origin_request_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier of the origin request policy that is attached to this cache behavior. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_request_policy_id")

    @origin_request_policy_id.setter
    def origin_request_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "origin_request_policy_id", value)

    @property
    @pulumi.getter(name="realtimeLogConfigArn")
    def realtime_log_config_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior. For more information, see [Real-time logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "realtime_log_config_arn")

    @realtime_log_config_arn.setter
    def realtime_log_config_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "realtime_log_config_arn", value)

    @property
    @pulumi.getter(name="responseHeadersPolicyId")
    def response_headers_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier for a response headers policy.
        """
        return pulumi.get(self, "response_headers_policy_id")

    @response_headers_policy_id.setter
    def response_headers_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "response_headers_policy_id", value)

    @property
    @pulumi.getter(name="smoothStreaming")
    def smooth_streaming(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior. If so, specify ``true``; if not, specify ``false``. If you specify ``true`` for ``SmoothStreaming``, you can still distribute other content using this cache behavior if the content matches the value of ``PathPattern``.
        """
        return pulumi.get(self, "smooth_streaming")

    @smooth_streaming.setter
    def smooth_streaming(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "smooth_streaming", value)

    @property
    @pulumi.getter(name="trustedKeyGroups")
    def trusted_key_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
         When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "trusted_key_groups")

    @trusted_key_groups.setter
    def trusted_key_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "trusted_key_groups", value)

    @property
    @pulumi.getter(name="trustedSigners")
    def trusted_signers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        We recommend using ``TrustedKeyGroups`` instead of ``TrustedSigners``.
          A list of AWS-account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.
         When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in the trusted signer's AWS-account. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "trusted_signers")

    @trusted_signers.setter
    def trusted_signers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "trusted_signers", value)


if not MYPY:
    class DistributionConfigTenantConfigPropertiesArgsDict(TypedDict):
        """
        A distribution tenant configuration.
        """
        parameter_definitions: NotRequired[pulumi.Input[Sequence[pulumi.Input['DistributionParameterDefinitionArgsDict']]]]
elif False:
    DistributionConfigTenantConfigPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionConfigTenantConfigPropertiesArgs:
    def __init__(__self__, *,
                 parameter_definitions: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionParameterDefinitionArgs']]]] = None):
        """
        A distribution tenant configuration.
        """
        if parameter_definitions is not None:
            pulumi.set(__self__, "parameter_definitions", parameter_definitions)

    @property
    @pulumi.getter(name="parameterDefinitions")
    def parameter_definitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionParameterDefinitionArgs']]]]:
        return pulumi.get(self, "parameter_definitions")

    @parameter_definitions.setter
    def parameter_definitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionParameterDefinitionArgs']]]]):
        pulumi.set(self, "parameter_definitions", value)


if not MYPY:
    class DistributionConfigArgsDict(TypedDict):
        """
        A distribution configuration.
        """
        default_cache_behavior: pulumi.Input['DistributionDefaultCacheBehaviorArgsDict']
        """
        A complex type that describes the default cache behavior if you don't specify a ``CacheBehavior`` element or if files don't match any of the values of ``PathPattern`` in ``CacheBehavior`` elements. You must create exactly one default cache behavior.
        """
        enabled: pulumi.Input[builtins.bool]
        """
        From this field, you can enable or disable the selected distribution.
        """
        aliases: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution.
        """
        anycast_ip_list_id: NotRequired[pulumi.Input[builtins.str]]
        """
        ID of the Anycast static IP list that is associated with the distribution.
        """
        cache_behaviors: NotRequired[pulumi.Input[Sequence[pulumi.Input['DistributionCacheBehaviorArgsDict']]]]
        """
        A complex type that contains zero or more ``CacheBehavior`` elements.
        """
        cnames: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        An alias for the CF distribution's domain name.
          This property is legacy. We recommend that you use [Aliases](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-aliases) instead.
        """
        comment: NotRequired[pulumi.Input[builtins.str]]
        """
        A comment to describe the distribution. The comment cannot be longer than 128 characters.
        """
        connection_mode: NotRequired[pulumi.Input['DistributionConnectionMode']]
        """
        The connection mode to filter distributions by.
        """
        continuous_deployment_policy_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The identifier of a continuous deployment policy. For more information, see ``CreateContinuousDeploymentPolicy``.
        """
        custom_error_responses: NotRequired[pulumi.Input[Sequence[pulumi.Input['DistributionCustomErrorResponseArgsDict']]]]
        """
        A complex type that controls the following:
          +  Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.
          +  How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
          
         For more information about custom error pages, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
        """
        custom_origin: NotRequired[pulumi.Input['DistributionLegacyCustomOriginArgsDict']]
        """
        The user-defined HTTP server that serves as the origin for content that CF distributes.
          This property is legacy. We recommend that you use [Origin](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html) instead.
        """
        default_root_object: NotRequired[pulumi.Input[builtins.str]]
        """
        When a viewer requests the root URL for your distribution, the default root object is the object that you want CloudFront to request from your origin. For example, if your root URL is ``https://www.example.com``, you can specify CloudFront to return the ``index.html`` file as the default root object. You can specify a default root object so that viewers see a specific file or object, instead of another object in your distribution (for example, ``https://www.example.com/product-description.html``). A default root object avoids exposing the contents of your distribution.
         You can specify the object name or a path to the object name (for example, ``index.html`` or ``exampleFolderName/index.html``). Your string can't begin with a forward slash (``/``). Only specify the object name or the path to the object.
         If you don't want to specify a default root object when you create a distribution, include an empty ``DefaultRootObject`` element.
         To delete the default root object from an existing distribution, update the distribution configuration and include an empty ``DefaultRootObject`` element.
         To replace the default root object, update the distribution configuration and specify the new object.
         For more information about the default root object, see [Specify a default root object](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html) in the *Amazon CloudFront Developer Guide*.
        """
        http_version: NotRequired[pulumi.Input[builtins.str]]
        """
        (Optional) Specify the HTTP version(s) that you want viewers to use to communicate with CF. The default value for new distributions is ``http1.1``.
         For viewers and CF to use HTTP/2, viewers must support TLSv1.2 or later, and must support Server Name Indication (SNI).
         For viewers and CF to use HTTP/3, viewers must support TLSv1.3 and Server Name Indication (SNI). CF supports HTTP/3 connection migration to allow the viewer to switch networks without losing connection. For more information about connection migration, see [Connection Migration](https://docs.aws.amazon.com/https://www.rfc-editor.org/rfc/rfc9000.html#name-connection-migration) at RFC 9000. For more information about supported TLSv1.3 ciphers, see [Supported protocols and ciphers between viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html).
        """
        ipv6_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution, specify ``true``. If you specify ``false``, CloudFront responds to IPv6 DNS requests with the DNS response code ``NOERROR`` and with no IP addresses. This allows viewers to submit a second request, for an IPv4 address for your distribution.
         In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content. However, if you're using signed URLs or signed cookies to restrict access to your content, and if you're using a custom policy that includes the ``IpAddress`` parameter to restrict the IP addresses that can access your content, don't enable IPv6. If you want to restrict access to some content by IP address and not restrict access to other content (or restrict access but not by IP address), you can create two distributions. For more information, see [Creating a Signed URL Using a Custom Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html) in the *Amazon CloudFront Developer Guide*.
         If you're using an R53AWSIntlong alias resource record set to route traffic to your CloudFront distribution, you need to create a second alias resource record set when both of the following are true:
          +  You enable IPv6 for the distribution
          +  You're using alternate domain names in the URLs for your objects
          
         For more information, see [Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html) in the *Developer Guide*.
         If you created a CNAME resource record set, either with R53AWSIntlong or with another DNS service, you don't need to make any changes. A CNAME record will route traffic to your distribution regardless of the IP address format of the viewer request.
        """
        logging: NotRequired[pulumi.Input['DistributionLoggingArgsDict']]
        """
        A complex type that controls whether access logs are written for the distribution.
         For more information about logging, see [Access Logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html) in the *Amazon CloudFront Developer Guide*.
        """
        origin_groups: NotRequired[pulumi.Input['DistributionOriginGroupsArgsDict']]
        """
        A complex type that contains information about origin groups for this distribution.
         Specify a value for either the ``Origins`` or ``OriginGroups`` property.
        """
        origins: NotRequired[pulumi.Input[Sequence[pulumi.Input['DistributionOriginArgsDict']]]]
        """
        A complex type that contains information about origins for this distribution.
         Specify a value for either the ``Origins`` or ``OriginGroups`` property.
        """
        price_class: NotRequired[pulumi.Input[builtins.str]]
        """
        The price class that corresponds with the maximum price that you want to pay for CloudFront service. If you specify ``PriceClass_All``, CloudFront responds to requests for your objects from all CloudFront edge locations.
         If you specify a price class other than ``PriceClass_All``, CloudFront serves your objects from the CloudFront edge location that has the lowest latency among the edge locations in your price class. Viewers who are in or near regions that are excluded from your specified price class may encounter slower performance.
         For more information about price classes, see [Choosing the Price Class for a CloudFront Distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html) in the *Amazon CloudFront Developer Guide*. For information about CloudFront pricing, including how price classes (such as Price Class 100) map to CloudFront regions, see [Amazon CloudFront Pricing](https://docs.aws.amazon.com/cloudfront/pricing/).
        """
        restrictions: NotRequired[pulumi.Input['DistributionRestrictionsArgsDict']]
        """
        A complex type that identifies ways in which you want to restrict distribution of your content.
        """
        s3_origin: NotRequired[pulumi.Input['DistributionLegacyS3OriginArgsDict']]
        """
        The origin as an S3 bucket.
          This property is legacy. We recommend that you use [Origin](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html) instead.
        """
        staging: NotRequired[pulumi.Input[builtins.bool]]
        """
        A Boolean that indicates whether this is a staging distribution. When this value is ``true``, this is a staging distribution. When this value is ``false``, this is not a staging distribution.
        """
        tenant_config: NotRequired[pulumi.Input['DistributionConfigTenantConfigPropertiesArgsDict']]
        """
        A distribution tenant configuration.
        """
        viewer_certificate: NotRequired[pulumi.Input['DistributionViewerCertificateArgsDict']]
        """
        A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
        """
        web_acl_id: NotRequired[pulumi.Input[builtins.str]]
        """
        A unique identifier that specifies the WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of WAF, use the ACL ARN, for example ``arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111``. To specify a web ACL created using WAF Classic, use the ACL ID, for example ``a1b2c3d4-5678-90ab-cdef-EXAMPLE11111``.
         WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to CloudFront, and lets you control access to your content. Based on conditions that you specify, such as the IP addresses that requests originate from or the values of query strings, CloudFront responds to requests either with the requested content or with an HTTP 403 status code (Forbidden). You can also configure CloudFront to return a custom error page when a request is blocked. For more information about WAF, see the [Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html).
        """
elif False:
    DistributionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionConfigArgs:
    def __init__(__self__, *,
                 default_cache_behavior: pulumi.Input['DistributionDefaultCacheBehaviorArgs'],
                 enabled: pulumi.Input[builtins.bool],
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 anycast_ip_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 cache_behaviors: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCacheBehaviorArgs']]]] = None,
                 cnames: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 connection_mode: Optional[pulumi.Input['DistributionConnectionMode']] = None,
                 continuous_deployment_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 custom_error_responses: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCustomErrorResponseArgs']]]] = None,
                 custom_origin: Optional[pulumi.Input['DistributionLegacyCustomOriginArgs']] = None,
                 default_root_object: Optional[pulumi.Input[builtins.str]] = None,
                 http_version: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 logging: Optional[pulumi.Input['DistributionLoggingArgs']] = None,
                 origin_groups: Optional[pulumi.Input['DistributionOriginGroupsArgs']] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginArgs']]]] = None,
                 price_class: Optional[pulumi.Input[builtins.str]] = None,
                 restrictions: Optional[pulumi.Input['DistributionRestrictionsArgs']] = None,
                 s3_origin: Optional[pulumi.Input['DistributionLegacyS3OriginArgs']] = None,
                 staging: Optional[pulumi.Input[builtins.bool]] = None,
                 tenant_config: Optional[pulumi.Input['DistributionConfigTenantConfigPropertiesArgs']] = None,
                 viewer_certificate: Optional[pulumi.Input['DistributionViewerCertificateArgs']] = None,
                 web_acl_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        A distribution configuration.
        :param pulumi.Input['DistributionDefaultCacheBehaviorArgs'] default_cache_behavior: A complex type that describes the default cache behavior if you don't specify a ``CacheBehavior`` element or if files don't match any of the values of ``PathPattern`` in ``CacheBehavior`` elements. You must create exactly one default cache behavior.
        :param pulumi.Input[builtins.bool] enabled: From this field, you can enable or disable the selected distribution.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] aliases: A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution.
        :param pulumi.Input[builtins.str] anycast_ip_list_id: ID of the Anycast static IP list that is associated with the distribution.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionCacheBehaviorArgs']]] cache_behaviors: A complex type that contains zero or more ``CacheBehavior`` elements.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cnames: An alias for the CF distribution's domain name.
                 This property is legacy. We recommend that you use [Aliases](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-aliases) instead.
        :param pulumi.Input[builtins.str] comment: A comment to describe the distribution. The comment cannot be longer than 128 characters.
        :param pulumi.Input['DistributionConnectionMode'] connection_mode: The connection mode to filter distributions by.
        :param pulumi.Input[builtins.str] continuous_deployment_policy_id: The identifier of a continuous deployment policy. For more information, see ``CreateContinuousDeploymentPolicy``.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionCustomErrorResponseArgs']]] custom_error_responses: A complex type that controls the following:
                 +  Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.
                 +  How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
                 
                For more information about custom error pages, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input['DistributionLegacyCustomOriginArgs'] custom_origin: The user-defined HTTP server that serves as the origin for content that CF distributes.
                 This property is legacy. We recommend that you use [Origin](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html) instead.
        :param pulumi.Input[builtins.str] default_root_object: When a viewer requests the root URL for your distribution, the default root object is the object that you want CloudFront to request from your origin. For example, if your root URL is ``https://www.example.com``, you can specify CloudFront to return the ``index.html`` file as the default root object. You can specify a default root object so that viewers see a specific file or object, instead of another object in your distribution (for example, ``https://www.example.com/product-description.html``). A default root object avoids exposing the contents of your distribution.
                You can specify the object name or a path to the object name (for example, ``index.html`` or ``exampleFolderName/index.html``). Your string can't begin with a forward slash (``/``). Only specify the object name or the path to the object.
                If you don't want to specify a default root object when you create a distribution, include an empty ``DefaultRootObject`` element.
                To delete the default root object from an existing distribution, update the distribution configuration and include an empty ``DefaultRootObject`` element.
                To replace the default root object, update the distribution configuration and specify the new object.
                For more information about the default root object, see [Specify a default root object](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.str] http_version: (Optional) Specify the HTTP version(s) that you want viewers to use to communicate with CF. The default value for new distributions is ``http1.1``.
                For viewers and CF to use HTTP/2, viewers must support TLSv1.2 or later, and must support Server Name Indication (SNI).
                For viewers and CF to use HTTP/3, viewers must support TLSv1.3 and Server Name Indication (SNI). CF supports HTTP/3 connection migration to allow the viewer to switch networks without losing connection. For more information about connection migration, see [Connection Migration](https://docs.aws.amazon.com/https://www.rfc-editor.org/rfc/rfc9000.html#name-connection-migration) at RFC 9000. For more information about supported TLSv1.3 ciphers, see [Supported protocols and ciphers between viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html).
        :param pulumi.Input[builtins.bool] ipv6_enabled: If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution, specify ``true``. If you specify ``false``, CloudFront responds to IPv6 DNS requests with the DNS response code ``NOERROR`` and with no IP addresses. This allows viewers to submit a second request, for an IPv4 address for your distribution.
                In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content. However, if you're using signed URLs or signed cookies to restrict access to your content, and if you're using a custom policy that includes the ``IpAddress`` parameter to restrict the IP addresses that can access your content, don't enable IPv6. If you want to restrict access to some content by IP address and not restrict access to other content (or restrict access but not by IP address), you can create two distributions. For more information, see [Creating a Signed URL Using a Custom Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html) in the *Amazon CloudFront Developer Guide*.
                If you're using an R53AWSIntlong alias resource record set to route traffic to your CloudFront distribution, you need to create a second alias resource record set when both of the following are true:
                 +  You enable IPv6 for the distribution
                 +  You're using alternate domain names in the URLs for your objects
                 
                For more information, see [Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html) in the *Developer Guide*.
                If you created a CNAME resource record set, either with R53AWSIntlong or with another DNS service, you don't need to make any changes. A CNAME record will route traffic to your distribution regardless of the IP address format of the viewer request.
        :param pulumi.Input['DistributionLoggingArgs'] logging: A complex type that controls whether access logs are written for the distribution.
                For more information about logging, see [Access Logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input['DistributionOriginGroupsArgs'] origin_groups: A complex type that contains information about origin groups for this distribution.
                Specify a value for either the ``Origins`` or ``OriginGroups`` property.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionOriginArgs']]] origins: A complex type that contains information about origins for this distribution.
                Specify a value for either the ``Origins`` or ``OriginGroups`` property.
        :param pulumi.Input[builtins.str] price_class: The price class that corresponds with the maximum price that you want to pay for CloudFront service. If you specify ``PriceClass_All``, CloudFront responds to requests for your objects from all CloudFront edge locations.
                If you specify a price class other than ``PriceClass_All``, CloudFront serves your objects from the CloudFront edge location that has the lowest latency among the edge locations in your price class. Viewers who are in or near regions that are excluded from your specified price class may encounter slower performance.
                For more information about price classes, see [Choosing the Price Class for a CloudFront Distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html) in the *Amazon CloudFront Developer Guide*. For information about CloudFront pricing, including how price classes (such as Price Class 100) map to CloudFront regions, see [Amazon CloudFront Pricing](https://docs.aws.amazon.com/cloudfront/pricing/).
        :param pulumi.Input['DistributionRestrictionsArgs'] restrictions: A complex type that identifies ways in which you want to restrict distribution of your content.
        :param pulumi.Input['DistributionLegacyS3OriginArgs'] s3_origin: The origin as an S3 bucket.
                 This property is legacy. We recommend that you use [Origin](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html) instead.
        :param pulumi.Input[builtins.bool] staging: A Boolean that indicates whether this is a staging distribution. When this value is ``true``, this is a staging distribution. When this value is ``false``, this is not a staging distribution.
        :param pulumi.Input['DistributionConfigTenantConfigPropertiesArgs'] tenant_config: A distribution tenant configuration.
        :param pulumi.Input['DistributionViewerCertificateArgs'] viewer_certificate: A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
        :param pulumi.Input[builtins.str] web_acl_id: A unique identifier that specifies the WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of WAF, use the ACL ARN, for example ``arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111``. To specify a web ACL created using WAF Classic, use the ACL ID, for example ``a1b2c3d4-5678-90ab-cdef-EXAMPLE11111``.
                WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to CloudFront, and lets you control access to your content. Based on conditions that you specify, such as the IP addresses that requests originate from or the values of query strings, CloudFront responds to requests either with the requested content or with an HTTP 403 status code (Forbidden). You can also configure CloudFront to return a custom error page when a request is blocked. For more information about WAF, see the [Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html).
        """
        pulumi.set(__self__, "default_cache_behavior", default_cache_behavior)
        pulumi.set(__self__, "enabled", enabled)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if anycast_ip_list_id is not None:
            pulumi.set(__self__, "anycast_ip_list_id", anycast_ip_list_id)
        if cache_behaviors is not None:
            pulumi.set(__self__, "cache_behaviors", cache_behaviors)
        if cnames is not None:
            pulumi.set(__self__, "cnames", cnames)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if connection_mode is not None:
            pulumi.set(__self__, "connection_mode", connection_mode)
        if continuous_deployment_policy_id is not None:
            pulumi.set(__self__, "continuous_deployment_policy_id", continuous_deployment_policy_id)
        if custom_error_responses is not None:
            pulumi.set(__self__, "custom_error_responses", custom_error_responses)
        if custom_origin is not None:
            pulumi.set(__self__, "custom_origin", custom_origin)
        if default_root_object is not None:
            pulumi.set(__self__, "default_root_object", default_root_object)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if ipv6_enabled is not None:
            pulumi.set(__self__, "ipv6_enabled", ipv6_enabled)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if origin_groups is not None:
            pulumi.set(__self__, "origin_groups", origin_groups)
        if origins is not None:
            pulumi.set(__self__, "origins", origins)
        if price_class is not None:
            pulumi.set(__self__, "price_class", price_class)
        if restrictions is not None:
            pulumi.set(__self__, "restrictions", restrictions)
        if s3_origin is not None:
            pulumi.set(__self__, "s3_origin", s3_origin)
        if staging is not None:
            pulumi.set(__self__, "staging", staging)
        if tenant_config is not None:
            pulumi.set(__self__, "tenant_config", tenant_config)
        if viewer_certificate is not None:
            pulumi.set(__self__, "viewer_certificate", viewer_certificate)
        if web_acl_id is not None:
            pulumi.set(__self__, "web_acl_id", web_acl_id)

    @property
    @pulumi.getter(name="defaultCacheBehavior")
    def default_cache_behavior(self) -> pulumi.Input['DistributionDefaultCacheBehaviorArgs']:
        """
        A complex type that describes the default cache behavior if you don't specify a ``CacheBehavior`` element or if files don't match any of the values of ``PathPattern`` in ``CacheBehavior`` elements. You must create exactly one default cache behavior.
        """
        return pulumi.get(self, "default_cache_behavior")

    @default_cache_behavior.setter
    def default_cache_behavior(self, value: pulumi.Input['DistributionDefaultCacheBehaviorArgs']):
        pulumi.set(self, "default_cache_behavior", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        From this field, you can enable or disable the selected distribution.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution.
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "aliases", value)

    @property
    @pulumi.getter(name="anycastIpListId")
    def anycast_ip_list_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the Anycast static IP list that is associated with the distribution.
        """
        return pulumi.get(self, "anycast_ip_list_id")

    @anycast_ip_list_id.setter
    def anycast_ip_list_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "anycast_ip_list_id", value)

    @property
    @pulumi.getter(name="cacheBehaviors")
    def cache_behaviors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCacheBehaviorArgs']]]]:
        """
        A complex type that contains zero or more ``CacheBehavior`` elements.
        """
        return pulumi.get(self, "cache_behaviors")

    @cache_behaviors.setter
    def cache_behaviors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCacheBehaviorArgs']]]]):
        pulumi.set(self, "cache_behaviors", value)

    @property
    @pulumi.getter
    def cnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An alias for the CF distribution's domain name.
          This property is legacy. We recommend that you use [Aliases](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-aliases) instead.
        """
        return pulumi.get(self, "cnames")

    @cnames.setter
    def cnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "cnames", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A comment to describe the distribution. The comment cannot be longer than 128 characters.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="connectionMode")
    def connection_mode(self) -> Optional[pulumi.Input['DistributionConnectionMode']]:
        """
        The connection mode to filter distributions by.
        """
        return pulumi.get(self, "connection_mode")

    @connection_mode.setter
    def connection_mode(self, value: Optional[pulumi.Input['DistributionConnectionMode']]):
        pulumi.set(self, "connection_mode", value)

    @property
    @pulumi.getter(name="continuousDeploymentPolicyId")
    def continuous_deployment_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of a continuous deployment policy. For more information, see ``CreateContinuousDeploymentPolicy``.
        """
        return pulumi.get(self, "continuous_deployment_policy_id")

    @continuous_deployment_policy_id.setter
    def continuous_deployment_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "continuous_deployment_policy_id", value)

    @property
    @pulumi.getter(name="customErrorResponses")
    def custom_error_responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCustomErrorResponseArgs']]]]:
        """
        A complex type that controls the following:
          +  Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.
          +  How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
          
         For more information about custom error pages, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "custom_error_responses")

    @custom_error_responses.setter
    def custom_error_responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCustomErrorResponseArgs']]]]):
        pulumi.set(self, "custom_error_responses", value)

    @property
    @pulumi.getter(name="customOrigin")
    def custom_origin(self) -> Optional[pulumi.Input['DistributionLegacyCustomOriginArgs']]:
        """
        The user-defined HTTP server that serves as the origin for content that CF distributes.
          This property is legacy. We recommend that you use [Origin](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html) instead.
        """
        return pulumi.get(self, "custom_origin")

    @custom_origin.setter
    def custom_origin(self, value: Optional[pulumi.Input['DistributionLegacyCustomOriginArgs']]):
        pulumi.set(self, "custom_origin", value)

    @property
    @pulumi.getter(name="defaultRootObject")
    def default_root_object(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When a viewer requests the root URL for your distribution, the default root object is the object that you want CloudFront to request from your origin. For example, if your root URL is ``https://www.example.com``, you can specify CloudFront to return the ``index.html`` file as the default root object. You can specify a default root object so that viewers see a specific file or object, instead of another object in your distribution (for example, ``https://www.example.com/product-description.html``). A default root object avoids exposing the contents of your distribution.
         You can specify the object name or a path to the object name (for example, ``index.html`` or ``exampleFolderName/index.html``). Your string can't begin with a forward slash (``/``). Only specify the object name or the path to the object.
         If you don't want to specify a default root object when you create a distribution, include an empty ``DefaultRootObject`` element.
         To delete the default root object from an existing distribution, update the distribution configuration and include an empty ``DefaultRootObject`` element.
         To replace the default root object, update the distribution configuration and specify the new object.
         For more information about the default root object, see [Specify a default root object](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "default_root_object")

    @default_root_object.setter
    def default_root_object(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_root_object", value)

    @property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional) Specify the HTTP version(s) that you want viewers to use to communicate with CF. The default value for new distributions is ``http1.1``.
         For viewers and CF to use HTTP/2, viewers must support TLSv1.2 or later, and must support Server Name Indication (SNI).
         For viewers and CF to use HTTP/3, viewers must support TLSv1.3 and Server Name Indication (SNI). CF supports HTTP/3 connection migration to allow the viewer to switch networks without losing connection. For more information about connection migration, see [Connection Migration](https://docs.aws.amazon.com/https://www.rfc-editor.org/rfc/rfc9000.html#name-connection-migration) at RFC 9000. For more information about supported TLSv1.3 ciphers, see [Supported protocols and ciphers between viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html).
        """
        return pulumi.get(self, "http_version")

    @http_version.setter
    def http_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "http_version", value)

    @property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution, specify ``true``. If you specify ``false``, CloudFront responds to IPv6 DNS requests with the DNS response code ``NOERROR`` and with no IP addresses. This allows viewers to submit a second request, for an IPv4 address for your distribution.
         In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content. However, if you're using signed URLs or signed cookies to restrict access to your content, and if you're using a custom policy that includes the ``IpAddress`` parameter to restrict the IP addresses that can access your content, don't enable IPv6. If you want to restrict access to some content by IP address and not restrict access to other content (or restrict access but not by IP address), you can create two distributions. For more information, see [Creating a Signed URL Using a Custom Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html) in the *Amazon CloudFront Developer Guide*.
         If you're using an R53AWSIntlong alias resource record set to route traffic to your CloudFront distribution, you need to create a second alias resource record set when both of the following are true:
          +  You enable IPv6 for the distribution
          +  You're using alternate domain names in the URLs for your objects
          
         For more information, see [Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html) in the *Developer Guide*.
         If you created a CNAME resource record set, either with R53AWSIntlong or with another DNS service, you don't need to make any changes. A CNAME record will route traffic to your distribution regardless of the IP address format of the viewer request.
        """
        return pulumi.get(self, "ipv6_enabled")

    @ipv6_enabled.setter
    def ipv6_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ipv6_enabled", value)

    @property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['DistributionLoggingArgs']]:
        """
        A complex type that controls whether access logs are written for the distribution.
         For more information about logging, see [Access Logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['DistributionLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @property
    @pulumi.getter(name="originGroups")
    def origin_groups(self) -> Optional[pulumi.Input['DistributionOriginGroupsArgs']]:
        """
        A complex type that contains information about origin groups for this distribution.
         Specify a value for either the ``Origins`` or ``OriginGroups`` property.
        """
        return pulumi.get(self, "origin_groups")

    @origin_groups.setter
    def origin_groups(self, value: Optional[pulumi.Input['DistributionOriginGroupsArgs']]):
        pulumi.set(self, "origin_groups", value)

    @property
    @pulumi.getter
    def origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginArgs']]]]:
        """
        A complex type that contains information about origins for this distribution.
         Specify a value for either the ``Origins`` or ``OriginGroups`` property.
        """
        return pulumi.get(self, "origins")

    @origins.setter
    def origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginArgs']]]]):
        pulumi.set(self, "origins", value)

    @property
    @pulumi.getter(name="priceClass")
    def price_class(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The price class that corresponds with the maximum price that you want to pay for CloudFront service. If you specify ``PriceClass_All``, CloudFront responds to requests for your objects from all CloudFront edge locations.
         If you specify a price class other than ``PriceClass_All``, CloudFront serves your objects from the CloudFront edge location that has the lowest latency among the edge locations in your price class. Viewers who are in or near regions that are excluded from your specified price class may encounter slower performance.
         For more information about price classes, see [Choosing the Price Class for a CloudFront Distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html) in the *Amazon CloudFront Developer Guide*. For information about CloudFront pricing, including how price classes (such as Price Class 100) map to CloudFront regions, see [Amazon CloudFront Pricing](https://docs.aws.amazon.com/cloudfront/pricing/).
        """
        return pulumi.get(self, "price_class")

    @price_class.setter
    def price_class(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "price_class", value)

    @property
    @pulumi.getter
    def restrictions(self) -> Optional[pulumi.Input['DistributionRestrictionsArgs']]:
        """
        A complex type that identifies ways in which you want to restrict distribution of your content.
        """
        return pulumi.get(self, "restrictions")

    @restrictions.setter
    def restrictions(self, value: Optional[pulumi.Input['DistributionRestrictionsArgs']]):
        pulumi.set(self, "restrictions", value)

    @property
    @pulumi.getter(name="s3Origin")
    def s3_origin(self) -> Optional[pulumi.Input['DistributionLegacyS3OriginArgs']]:
        """
        The origin as an S3 bucket.
          This property is legacy. We recommend that you use [Origin](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html) instead.
        """
        return pulumi.get(self, "s3_origin")

    @s3_origin.setter
    def s3_origin(self, value: Optional[pulumi.Input['DistributionLegacyS3OriginArgs']]):
        pulumi.set(self, "s3_origin", value)

    @property
    @pulumi.getter
    def staging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A Boolean that indicates whether this is a staging distribution. When this value is ``true``, this is a staging distribution. When this value is ``false``, this is not a staging distribution.
        """
        return pulumi.get(self, "staging")

    @staging.setter
    def staging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "staging", value)

    @property
    @pulumi.getter(name="tenantConfig")
    def tenant_config(self) -> Optional[pulumi.Input['DistributionConfigTenantConfigPropertiesArgs']]:
        """
        A distribution tenant configuration.
        """
        return pulumi.get(self, "tenant_config")

    @tenant_config.setter
    def tenant_config(self, value: Optional[pulumi.Input['DistributionConfigTenantConfigPropertiesArgs']]):
        pulumi.set(self, "tenant_config", value)

    @property
    @pulumi.getter(name="viewerCertificate")
    def viewer_certificate(self) -> Optional[pulumi.Input['DistributionViewerCertificateArgs']]:
        """
        A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
        """
        return pulumi.get(self, "viewer_certificate")

    @viewer_certificate.setter
    def viewer_certificate(self, value: Optional[pulumi.Input['DistributionViewerCertificateArgs']]):
        pulumi.set(self, "viewer_certificate", value)

    @property
    @pulumi.getter(name="webAclId")
    def web_acl_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier that specifies the WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of WAF, use the ACL ARN, for example ``arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111``. To specify a web ACL created using WAF Classic, use the ACL ID, for example ``a1b2c3d4-5678-90ab-cdef-EXAMPLE11111``.
         WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to CloudFront, and lets you control access to your content. Based on conditions that you specify, such as the IP addresses that requests originate from or the values of query strings, CloudFront responds to requests either with the requested content or with an HTTP 403 status code (Forbidden). You can also configure CloudFront to return a custom error page when a request is blocked. For more information about WAF, see the [Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html).
        """
        return pulumi.get(self, "web_acl_id")

    @web_acl_id.setter
    def web_acl_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "web_acl_id", value)


if not MYPY:
    class DistributionCookiesArgsDict(TypedDict):
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones. For more information about forwarding cookies to the origin, see [How CloudFront Forwards, Caches, and Logs Cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html) in the *Amazon CloudFront Developer Guide*.
        """
        forward: pulumi.Input[builtins.str]
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send cookies to the origin but not include them in the cache key, use origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of cookies specified in the ``WhitelistedNames`` complex type.
         Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3 origin, specify none for the ``Forward`` element.
        """
        whitelisted_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         Required if you specify ``whitelist`` for the value of ``Forward``. A complex type that specifies how many different cookies you want CloudFront to forward to the origin for this cache behavior and, if you want to forward selected cookies, the names of those cookies.
         If you specify ``all`` or ``none`` for the value of ``Forward``, omit ``WhitelistedNames``. If you change the value of ``Forward`` from ``whitelist`` to ``all`` or ``none`` and you don't delete the ``WhitelistedNames`` element and its child elements, CloudFront deletes them automatically.
         For the current limit on the number of cookie names that you can whitelist for each cache behavior, see [CloudFront Limits](https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront) in the *General Reference*.
        """
elif False:
    DistributionCookiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionCookiesArgs:
    def __init__(__self__, *,
                 forward: pulumi.Input[builtins.str],
                 whitelisted_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones. For more information about forwarding cookies to the origin, see [How CloudFront Forwards, Caches, and Logs Cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.str] forward: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
                If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
                If you want to send cookies to the origin but not include them in the cache key, use origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
                Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of cookies specified in the ``WhitelistedNames`` complex type.
                Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3 origin, specify none for the ``Forward`` element.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] whitelisted_names: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
                If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
                If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
                Required if you specify ``whitelist`` for the value of ``Forward``. A complex type that specifies how many different cookies you want CloudFront to forward to the origin for this cache behavior and, if you want to forward selected cookies, the names of those cookies.
                If you specify ``all`` or ``none`` for the value of ``Forward``, omit ``WhitelistedNames``. If you change the value of ``Forward`` from ``whitelist`` to ``all`` or ``none`` and you don't delete the ``WhitelistedNames`` element and its child elements, CloudFront deletes them automatically.
                For the current limit on the number of cookie names that you can whitelist for each cache behavior, see [CloudFront Limits](https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront) in the *General Reference*.
        """
        pulumi.set(__self__, "forward", forward)
        if whitelisted_names is not None:
            pulumi.set(__self__, "whitelisted_names", whitelisted_names)

    @property
    @pulumi.getter
    def forward(self) -> pulumi.Input[builtins.str]:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send cookies to the origin but not include them in the cache key, use origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of cookies specified in the ``WhitelistedNames`` complex type.
         Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3 origin, specify none for the ``Forward`` element.
        """
        return pulumi.get(self, "forward")

    @forward.setter
    def forward(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "forward", value)

    @property
    @pulumi.getter(name="whitelistedNames")
    def whitelisted_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         Required if you specify ``whitelist`` for the value of ``Forward``. A complex type that specifies how many different cookies you want CloudFront to forward to the origin for this cache behavior and, if you want to forward selected cookies, the names of those cookies.
         If you specify ``all`` or ``none`` for the value of ``Forward``, omit ``WhitelistedNames``. If you change the value of ``Forward`` from ``whitelist`` to ``all`` or ``none`` and you don't delete the ``WhitelistedNames`` element and its child elements, CloudFront deletes them automatically.
         For the current limit on the number of cookie names that you can whitelist for each cache behavior, see [CloudFront Limits](https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront) in the *General Reference*.
        """
        return pulumi.get(self, "whitelisted_names")

    @whitelisted_names.setter
    def whitelisted_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "whitelisted_names", value)


if not MYPY:
    class DistributionCustomErrorResponseArgsDict(TypedDict):
        """
        A complex type that controls:
          +  Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.
          +  How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
          
         For more information about custom error pages, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
        """
        error_code: pulumi.Input[builtins.int]
        """
        The HTTP status code for which you want to specify a custom error page and/or a caching duration.
        """
        error_caching_min_ttl: NotRequired[pulumi.Input[builtins.float]]
        """
        The minimum amount of time, in seconds, that you want CloudFront to cache the HTTP status code specified in ``ErrorCode``. When this time period has elapsed, CloudFront queries your origin to see whether the problem that caused the error has been resolved and the requested object is now available.
         For more information, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
        """
        response_code: NotRequired[pulumi.Input[builtins.int]]
        """
        The HTTP status code that you want CloudFront to return to the viewer along with the custom error page. There are a variety of reasons that you might want CloudFront to return a status code different from the status code that your origin returned to CloudFront, for example:
          +  Some Internet devices (some firewalls and corporate proxies, for example) intercept HTTP 4xx and 5xx and prevent the response from being returned to the viewer. If you substitute ``200``, the response typically won't be intercepted.
          +  If you don't care about distinguishing among different client errors or server errors, you can specify ``400`` or ``500`` as the ``ResponseCode`` for all 4xx or 5xx errors.
          +  You might want to return a ``200`` status code (OK) and static website so your customers don't know that your website is down.
          
         If you specify a value for ``ResponseCode``, you must also specify a value for ``ResponsePagePath``.
        """
        response_page_path: NotRequired[pulumi.Input[builtins.str]]
        """
        The path to the custom error page that you want CloudFront to return to a viewer when your origin returns the HTTP status code specified by ``ErrorCode``, for example, ``/4xx-errors/403-forbidden.html``. If you want to store your objects and your custom error pages in different locations, your distribution must include a cache behavior for which the following is true:
          +  The value of ``PathPattern`` matches the path to your custom error messages. For example, suppose you saved custom error pages for 4xx errors in an Amazon S3 bucket in a directory named ``/4xx-errors``. Your distribution must include a cache behavior for which the path pattern routes requests for your custom error pages to that location, for example, ``/4xx-errors/*``.
          +  The value of ``TargetOriginId`` specifies the value of the ``ID`` element for the origin that contains your custom error pages.
          
         If you specify a value for ``ResponsePagePath``, you must also specify a value for ``ResponseCode``.
         We recommend that you store custom error pages in an Amazon S3 bucket. If you store custom error pages on an HTTP server and the server starts to return 5xx errors, CloudFront can't get the files that you want to return to viewers because the origin server is unavailable.
        """
elif False:
    DistributionCustomErrorResponseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionCustomErrorResponseArgs:
    def __init__(__self__, *,
                 error_code: pulumi.Input[builtins.int],
                 error_caching_min_ttl: Optional[pulumi.Input[builtins.float]] = None,
                 response_code: Optional[pulumi.Input[builtins.int]] = None,
                 response_page_path: Optional[pulumi.Input[builtins.str]] = None):
        """
        A complex type that controls:
          +  Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.
          +  How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
          
         For more information about custom error pages, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.int] error_code: The HTTP status code for which you want to specify a custom error page and/or a caching duration.
        :param pulumi.Input[builtins.float] error_caching_min_ttl: The minimum amount of time, in seconds, that you want CloudFront to cache the HTTP status code specified in ``ErrorCode``. When this time period has elapsed, CloudFront queries your origin to see whether the problem that caused the error has been resolved and the requested object is now available.
                For more information, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.int] response_code: The HTTP status code that you want CloudFront to return to the viewer along with the custom error page. There are a variety of reasons that you might want CloudFront to return a status code different from the status code that your origin returned to CloudFront, for example:
                 +  Some Internet devices (some firewalls and corporate proxies, for example) intercept HTTP 4xx and 5xx and prevent the response from being returned to the viewer. If you substitute ``200``, the response typically won't be intercepted.
                 +  If you don't care about distinguishing among different client errors or server errors, you can specify ``400`` or ``500`` as the ``ResponseCode`` for all 4xx or 5xx errors.
                 +  You might want to return a ``200`` status code (OK) and static website so your customers don't know that your website is down.
                 
                If you specify a value for ``ResponseCode``, you must also specify a value for ``ResponsePagePath``.
        :param pulumi.Input[builtins.str] response_page_path: The path to the custom error page that you want CloudFront to return to a viewer when your origin returns the HTTP status code specified by ``ErrorCode``, for example, ``/4xx-errors/403-forbidden.html``. If you want to store your objects and your custom error pages in different locations, your distribution must include a cache behavior for which the following is true:
                 +  The value of ``PathPattern`` matches the path to your custom error messages. For example, suppose you saved custom error pages for 4xx errors in an Amazon S3 bucket in a directory named ``/4xx-errors``. Your distribution must include a cache behavior for which the path pattern routes requests for your custom error pages to that location, for example, ``/4xx-errors/*``.
                 +  The value of ``TargetOriginId`` specifies the value of the ``ID`` element for the origin that contains your custom error pages.
                 
                If you specify a value for ``ResponsePagePath``, you must also specify a value for ``ResponseCode``.
                We recommend that you store custom error pages in an Amazon S3 bucket. If you store custom error pages on an HTTP server and the server starts to return 5xx errors, CloudFront can't get the files that you want to return to viewers because the origin server is unavailable.
        """
        pulumi.set(__self__, "error_code", error_code)
        if error_caching_min_ttl is not None:
            pulumi.set(__self__, "error_caching_min_ttl", error_caching_min_ttl)
        if response_code is not None:
            pulumi.set(__self__, "response_code", response_code)
        if response_page_path is not None:
            pulumi.set(__self__, "response_page_path", response_page_path)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> pulumi.Input[builtins.int]:
        """
        The HTTP status code for which you want to specify a custom error page and/or a caching duration.
        """
        return pulumi.get(self, "error_code")

    @error_code.setter
    def error_code(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "error_code", value)

    @property
    @pulumi.getter(name="errorCachingMinTtl")
    def error_caching_min_ttl(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The minimum amount of time, in seconds, that you want CloudFront to cache the HTTP status code specified in ``ErrorCode``. When this time period has elapsed, CloudFront queries your origin to see whether the problem that caused the error has been resolved and the requested object is now available.
         For more information, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "error_caching_min_ttl")

    @error_caching_min_ttl.setter
    def error_caching_min_ttl(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "error_caching_min_ttl", value)

    @property
    @pulumi.getter(name="responseCode")
    def response_code(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The HTTP status code that you want CloudFront to return to the viewer along with the custom error page. There are a variety of reasons that you might want CloudFront to return a status code different from the status code that your origin returned to CloudFront, for example:
          +  Some Internet devices (some firewalls and corporate proxies, for example) intercept HTTP 4xx and 5xx and prevent the response from being returned to the viewer. If you substitute ``200``, the response typically won't be intercepted.
          +  If you don't care about distinguishing among different client errors or server errors, you can specify ``400`` or ``500`` as the ``ResponseCode`` for all 4xx or 5xx errors.
          +  You might want to return a ``200`` status code (OK) and static website so your customers don't know that your website is down.
          
         If you specify a value for ``ResponseCode``, you must also specify a value for ``ResponsePagePath``.
        """
        return pulumi.get(self, "response_code")

    @response_code.setter
    def response_code(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "response_code", value)

    @property
    @pulumi.getter(name="responsePagePath")
    def response_page_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path to the custom error page that you want CloudFront to return to a viewer when your origin returns the HTTP status code specified by ``ErrorCode``, for example, ``/4xx-errors/403-forbidden.html``. If you want to store your objects and your custom error pages in different locations, your distribution must include a cache behavior for which the following is true:
          +  The value of ``PathPattern`` matches the path to your custom error messages. For example, suppose you saved custom error pages for 4xx errors in an Amazon S3 bucket in a directory named ``/4xx-errors``. Your distribution must include a cache behavior for which the path pattern routes requests for your custom error pages to that location, for example, ``/4xx-errors/*``.
          +  The value of ``TargetOriginId`` specifies the value of the ``ID`` element for the origin that contains your custom error pages.
          
         If you specify a value for ``ResponsePagePath``, you must also specify a value for ``ResponseCode``.
         We recommend that you store custom error pages in an Amazon S3 bucket. If you store custom error pages on an HTTP server and the server starts to return 5xx errors, CloudFront can't get the files that you want to return to viewers because the origin server is unavailable.
        """
        return pulumi.get(self, "response_page_path")

    @response_page_path.setter
    def response_page_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "response_page_path", value)


if not MYPY:
    class DistributionCustomOriginConfigArgsDict(TypedDict):
        """
        A custom origin. A custom origin is any origin that is *not* an Amazon S3 bucket, with one exception. An Amazon S3 bucket that is [configured with static website hosting](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html)*is* a custom origin.
        """
        origin_protocol_policy: pulumi.Input[builtins.str]
        """
        Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. Valid values are:
          +  ``http-only`` – CloudFront always uses HTTP to connect to the origin.
          +  ``match-viewer`` – CloudFront connects to the origin using the same protocol that the viewer used to connect to CloudFront.
          +  ``https-only`` – CloudFront always uses HTTPS to connect to the origin.
        """
        http_port: NotRequired[pulumi.Input[builtins.int]]
        """
        The HTTP port that CloudFront uses to connect to the origin. Specify the HTTP port that the origin listens on.
        """
        https_port: NotRequired[pulumi.Input[builtins.int]]
        """
        The HTTPS port that CloudFront uses to connect to the origin. Specify the HTTPS port that the origin listens on.
        """
        origin_keepalive_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 5 seconds.
         For more information, see [Keep-alive timeout (custom origins only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout) in the *Amazon CloudFront Developer Guide*.
        """
        origin_read_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as the *origin response timeout*. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 30 seconds.
         For more information, see [Response timeout (custom origins only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout) in the *Amazon CloudFront Developer Guide*.
        """
        origin_ssl_protocols: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS. Valid values include ``SSLv3``, ``TLSv1``, ``TLSv1.1``, and ``TLSv1.2``.
         For more information, see [Minimum Origin SSL Protocol](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols) in the *Amazon CloudFront Developer Guide*.
        """
elif False:
    DistributionCustomOriginConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionCustomOriginConfigArgs:
    def __init__(__self__, *,
                 origin_protocol_policy: pulumi.Input[builtins.str],
                 http_port: Optional[pulumi.Input[builtins.int]] = None,
                 https_port: Optional[pulumi.Input[builtins.int]] = None,
                 origin_keepalive_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 origin_read_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 origin_ssl_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        A custom origin. A custom origin is any origin that is *not* an Amazon S3 bucket, with one exception. An Amazon S3 bucket that is [configured with static website hosting](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html)*is* a custom origin.
        :param pulumi.Input[builtins.str] origin_protocol_policy: Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. Valid values are:
                 +  ``http-only`` – CloudFront always uses HTTP to connect to the origin.
                 +  ``match-viewer`` – CloudFront connects to the origin using the same protocol that the viewer used to connect to CloudFront.
                 +  ``https-only`` – CloudFront always uses HTTPS to connect to the origin.
        :param pulumi.Input[builtins.int] http_port: The HTTP port that CloudFront uses to connect to the origin. Specify the HTTP port that the origin listens on.
        :param pulumi.Input[builtins.int] https_port: The HTTPS port that CloudFront uses to connect to the origin. Specify the HTTPS port that the origin listens on.
        :param pulumi.Input[builtins.int] origin_keepalive_timeout: Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 5 seconds.
                For more information, see [Keep-alive timeout (custom origins only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.int] origin_read_timeout: Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as the *origin response timeout*. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 30 seconds.
                For more information, see [Response timeout (custom origins only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] origin_ssl_protocols: Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS. Valid values include ``SSLv3``, ``TLSv1``, ``TLSv1.1``, and ``TLSv1.2``.
                For more information, see [Minimum Origin SSL Protocol](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols) in the *Amazon CloudFront Developer Guide*.
        """
        pulumi.set(__self__, "origin_protocol_policy", origin_protocol_policy)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if https_port is not None:
            pulumi.set(__self__, "https_port", https_port)
        if origin_keepalive_timeout is not None:
            pulumi.set(__self__, "origin_keepalive_timeout", origin_keepalive_timeout)
        if origin_read_timeout is not None:
            pulumi.set(__self__, "origin_read_timeout", origin_read_timeout)
        if origin_ssl_protocols is not None:
            pulumi.set(__self__, "origin_ssl_protocols", origin_ssl_protocols)

    @property
    @pulumi.getter(name="originProtocolPolicy")
    def origin_protocol_policy(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. Valid values are:
          +  ``http-only`` – CloudFront always uses HTTP to connect to the origin.
          +  ``match-viewer`` – CloudFront connects to the origin using the same protocol that the viewer used to connect to CloudFront.
          +  ``https-only`` – CloudFront always uses HTTPS to connect to the origin.
        """
        return pulumi.get(self, "origin_protocol_policy")

    @origin_protocol_policy.setter
    def origin_protocol_policy(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "origin_protocol_policy", value)

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The HTTP port that CloudFront uses to connect to the origin. Specify the HTTP port that the origin listens on.
        """
        return pulumi.get(self, "http_port")

    @http_port.setter
    def http_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "http_port", value)

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The HTTPS port that CloudFront uses to connect to the origin. Specify the HTTPS port that the origin listens on.
        """
        return pulumi.get(self, "https_port")

    @https_port.setter
    def https_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "https_port", value)

    @property
    @pulumi.getter(name="originKeepaliveTimeout")
    def origin_keepalive_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 5 seconds.
         For more information, see [Keep-alive timeout (custom origins only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_keepalive_timeout")

    @origin_keepalive_timeout.setter
    def origin_keepalive_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "origin_keepalive_timeout", value)

    @property
    @pulumi.getter(name="originReadTimeout")
    def origin_read_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as the *origin response timeout*. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 30 seconds.
         For more information, see [Response timeout (custom origins only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_read_timeout")

    @origin_read_timeout.setter
    def origin_read_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "origin_read_timeout", value)

    @property
    @pulumi.getter(name="originSslProtocols")
    def origin_ssl_protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS. Valid values include ``SSLv3``, ``TLSv1``, ``TLSv1.1``, and ``TLSv1.2``.
         For more information, see [Minimum Origin SSL Protocol](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_ssl_protocols")

    @origin_ssl_protocols.setter
    def origin_ssl_protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "origin_ssl_protocols", value)


if not MYPY:
    class DistributionDefaultCacheBehaviorArgsDict(TypedDict):
        """
        A complex type that describes the default cache behavior if you don't specify a ``CacheBehavior`` element or if request URLs don't match any of the values of ``PathPattern`` in ``CacheBehavior`` elements. You must create exactly one default cache behavior.
        """
        target_origin_id: pulumi.Input[builtins.str]
        """
        The value of ``ID`` for the origin that you want CloudFront to route requests to when they use the default cache behavior.
        """
        viewer_protocol_policy: pulumi.Input[builtins.str]
        """
        The protocol that viewers can use to access the files in the origin specified by ``TargetOriginId`` when a request matches the path pattern in ``PathPattern``. You can specify the following options:
          +  ``allow-all``: Viewers can use HTTP or HTTPS.
          +  ``redirect-to-https``: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.
          +  ``https-only``: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).
          
         For more information about requiring the HTTPS protocol, see [Requiring HTTPS Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html) in the *Amazon CloudFront Developer Guide*.
          The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see [Managing Cache Expiration](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        allowed_methods: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin. There are three choices:
          +  CloudFront forwards only ``GET`` and ``HEAD`` requests.
          +  CloudFront forwards only ``GET``, ``HEAD``, and ``OPTIONS`` requests.
          +  CloudFront forwards ``GET, HEAD, OPTIONS, PUT, PATCH, POST``, and ``DELETE`` requests.
          
         If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
        """
        cache_policy_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The unique identifier of the cache policy that is attached to the default cache behavior. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         A ``DefaultCacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
        """
        cached_methods: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods. There are two choices:
          +  CloudFront caches responses to ``GET`` and ``HEAD`` requests.
          +  CloudFront caches responses to ``GET``, ``HEAD``, and ``OPTIONS`` requests.
          
         If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
        """
        compress: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify ``true``; if not, specify ``false``. For more information, see [Serving Compressed Files](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html) in the *Amazon CloudFront Developer Guide*.
        """
        default_ttl: NotRequired[pulumi.Input[builtins.float]]
        """
        This field is deprecated. We recommend that you use the ``DefaultTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        field_level_encryption_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The value of ``ID`` for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for the default cache behavior.
        """
        forwarded_values: NotRequired[pulumi.Input['DistributionForwardedValuesArgsDict']]
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see [Working with policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html) in the *Amazon CloudFront Developer Guide*.
         If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
         A ``DefaultCacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
         A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
        """
        function_associations: NotRequired[pulumi.Input[Sequence[pulumi.Input['DistributionFunctionAssociationArgsDict']]]]
        """
        A list of CloudFront functions that are associated with this cache behavior. Your functions must be published to the ``LIVE`` stage to associate them with a cache behavior.
        """
        grpc_config: NotRequired[pulumi.Input['DistributionGrpcConfigArgsDict']]
        """
        The gRPC configuration for your cache behavior.
        """
        lambda_function_associations: NotRequired[pulumi.Input[Sequence[pulumi.Input['DistributionLambdaFunctionAssociationArgsDict']]]]
        """
        A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
        """
        max_ttl: NotRequired[pulumi.Input[builtins.float]]
        """
        This field is deprecated. We recommend that you use the ``MaxTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        min_ttl: NotRequired[pulumi.Input[builtins.float]]
        """
        This field is deprecated. We recommend that you use the ``MinTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
         You must specify ``0`` for ``MinTTL`` if you configure CloudFront to forward all headers to your origin (under ``Headers``, if you specify ``1`` for ``Quantity`` and ``*`` for ``Name``).
        """
        origin_request_policy_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The unique identifier of the origin request policy that is attached to the default cache behavior. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
        """
        realtime_log_config_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior. For more information, see [Real-time logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html) in the *Amazon CloudFront Developer Guide*.
        """
        response_headers_policy_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The identifier for a response headers policy.
        """
        smooth_streaming: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior. If so, specify ``true``; if not, specify ``false``. If you specify ``true`` for ``SmoothStreaming``, you can still distribute other content using this cache behavior if the content matches the value of ``PathPattern``.
        """
        trusted_key_groups: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
         When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        trusted_signers: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        We recommend using ``TrustedKeyGroups`` instead of ``TrustedSigners``.
          A list of AWS-account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.
         When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in a trusted signer's AWS-account. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
elif False:
    DistributionDefaultCacheBehaviorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionDefaultCacheBehaviorArgs:
    def __init__(__self__, *,
                 target_origin_id: pulumi.Input[builtins.str],
                 viewer_protocol_policy: pulumi.Input[builtins.str],
                 allowed_methods: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 cache_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 cached_methods: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 compress: Optional[pulumi.Input[builtins.bool]] = None,
                 default_ttl: Optional[pulumi.Input[builtins.float]] = None,
                 field_level_encryption_id: Optional[pulumi.Input[builtins.str]] = None,
                 forwarded_values: Optional[pulumi.Input['DistributionForwardedValuesArgs']] = None,
                 function_associations: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionFunctionAssociationArgs']]]] = None,
                 grpc_config: Optional[pulumi.Input['DistributionGrpcConfigArgs']] = None,
                 lambda_function_associations: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionLambdaFunctionAssociationArgs']]]] = None,
                 max_ttl: Optional[pulumi.Input[builtins.float]] = None,
                 min_ttl: Optional[pulumi.Input[builtins.float]] = None,
                 origin_request_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 realtime_log_config_arn: Optional[pulumi.Input[builtins.str]] = None,
                 response_headers_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 smooth_streaming: Optional[pulumi.Input[builtins.bool]] = None,
                 trusted_key_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 trusted_signers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        A complex type that describes the default cache behavior if you don't specify a ``CacheBehavior`` element or if request URLs don't match any of the values of ``PathPattern`` in ``CacheBehavior`` elements. You must create exactly one default cache behavior.
        :param pulumi.Input[builtins.str] target_origin_id: The value of ``ID`` for the origin that you want CloudFront to route requests to when they use the default cache behavior.
        :param pulumi.Input[builtins.str] viewer_protocol_policy: The protocol that viewers can use to access the files in the origin specified by ``TargetOriginId`` when a request matches the path pattern in ``PathPattern``. You can specify the following options:
                 +  ``allow-all``: Viewers can use HTTP or HTTPS.
                 +  ``redirect-to-https``: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.
                 +  ``https-only``: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).
                 
                For more information about requiring the HTTPS protocol, see [Requiring HTTPS Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html) in the *Amazon CloudFront Developer Guide*.
                 The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see [Managing Cache Expiration](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_methods: A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin. There are three choices:
                 +  CloudFront forwards only ``GET`` and ``HEAD`` requests.
                 +  CloudFront forwards only ``GET``, ``HEAD``, and ``OPTIONS`` requests.
                 +  CloudFront forwards ``GET, HEAD, OPTIONS, PUT, PATCH, POST``, and ``DELETE`` requests.
                 
                If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
        :param pulumi.Input[builtins.str] cache_policy_id: The unique identifier of the cache policy that is attached to the default cache behavior. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                A ``DefaultCacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cached_methods: A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods. There are two choices:
                 +  CloudFront caches responses to ``GET`` and ``HEAD`` requests.
                 +  CloudFront caches responses to ``GET``, ``HEAD``, and ``OPTIONS`` requests.
                 
                If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
        :param pulumi.Input[builtins.bool] compress: Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify ``true``; if not, specify ``false``. For more information, see [Serving Compressed Files](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.float] default_ttl: This field is deprecated. We recommend that you use the ``DefaultTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.str] field_level_encryption_id: The value of ``ID`` for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for the default cache behavior.
        :param pulumi.Input['DistributionForwardedValuesArgs'] forwarded_values: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see [Working with policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html) in the *Amazon CloudFront Developer Guide*.
                If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
                A ``DefaultCacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
                A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionFunctionAssociationArgs']]] function_associations: A list of CloudFront functions that are associated with this cache behavior. Your functions must be published to the ``LIVE`` stage to associate them with a cache behavior.
        :param pulumi.Input['DistributionGrpcConfigArgs'] grpc_config: The gRPC configuration for your cache behavior.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionLambdaFunctionAssociationArgs']]] lambda_function_associations: A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
        :param pulumi.Input[builtins.float] max_ttl: This field is deprecated. We recommend that you use the ``MaxTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.float] min_ttl: This field is deprecated. We recommend that you use the ``MinTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
                You must specify ``0`` for ``MinTTL`` if you configure CloudFront to forward all headers to your origin (under ``Headers``, if you specify ``1`` for ``Quantity`` and ``*`` for ``Name``).
        :param pulumi.Input[builtins.str] origin_request_policy_id: The unique identifier of the origin request policy that is attached to the default cache behavior. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.str] realtime_log_config_arn: The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior. For more information, see [Real-time logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.str] response_headers_policy_id: The identifier for a response headers policy.
        :param pulumi.Input[builtins.bool] smooth_streaming: Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior. If so, specify ``true``; if not, specify ``false``. If you specify ``true`` for ``SmoothStreaming``, you can still distribute other content using this cache behavior if the content matches the value of ``PathPattern``.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] trusted_key_groups: A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
                When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] trusted_signers: We recommend using ``TrustedKeyGroups`` instead of ``TrustedSigners``.
                 A list of AWS-account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.
                When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in a trusted signer's AWS-account. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        pulumi.set(__self__, "target_origin_id", target_origin_id)
        pulumi.set(__self__, "viewer_protocol_policy", viewer_protocol_policy)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if cache_policy_id is not None:
            pulumi.set(__self__, "cache_policy_id", cache_policy_id)
        if cached_methods is not None:
            pulumi.set(__self__, "cached_methods", cached_methods)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if field_level_encryption_id is not None:
            pulumi.set(__self__, "field_level_encryption_id", field_level_encryption_id)
        if forwarded_values is not None:
            pulumi.set(__self__, "forwarded_values", forwarded_values)
        if function_associations is not None:
            pulumi.set(__self__, "function_associations", function_associations)
        if grpc_config is not None:
            pulumi.set(__self__, "grpc_config", grpc_config)
        if lambda_function_associations is not None:
            pulumi.set(__self__, "lambda_function_associations", lambda_function_associations)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if min_ttl is not None:
            pulumi.set(__self__, "min_ttl", min_ttl)
        if origin_request_policy_id is not None:
            pulumi.set(__self__, "origin_request_policy_id", origin_request_policy_id)
        if realtime_log_config_arn is not None:
            pulumi.set(__self__, "realtime_log_config_arn", realtime_log_config_arn)
        if response_headers_policy_id is not None:
            pulumi.set(__self__, "response_headers_policy_id", response_headers_policy_id)
        if smooth_streaming is not None:
            pulumi.set(__self__, "smooth_streaming", smooth_streaming)
        if trusted_key_groups is not None:
            pulumi.set(__self__, "trusted_key_groups", trusted_key_groups)
        if trusted_signers is not None:
            pulumi.set(__self__, "trusted_signers", trusted_signers)

    @property
    @pulumi.getter(name="targetOriginId")
    def target_origin_id(self) -> pulumi.Input[builtins.str]:
        """
        The value of ``ID`` for the origin that you want CloudFront to route requests to when they use the default cache behavior.
        """
        return pulumi.get(self, "target_origin_id")

    @target_origin_id.setter
    def target_origin_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_origin_id", value)

    @property
    @pulumi.getter(name="viewerProtocolPolicy")
    def viewer_protocol_policy(self) -> pulumi.Input[builtins.str]:
        """
        The protocol that viewers can use to access the files in the origin specified by ``TargetOriginId`` when a request matches the path pattern in ``PathPattern``. You can specify the following options:
          +  ``allow-all``: Viewers can use HTTP or HTTPS.
          +  ``redirect-to-https``: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.
          +  ``https-only``: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).
          
         For more information about requiring the HTTPS protocol, see [Requiring HTTPS Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html) in the *Amazon CloudFront Developer Guide*.
          The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see [Managing Cache Expiration](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "viewer_protocol_policy")

    @viewer_protocol_policy.setter
    def viewer_protocol_policy(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "viewer_protocol_policy", value)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin. There are three choices:
          +  CloudFront forwards only ``GET`` and ``HEAD`` requests.
          +  CloudFront forwards only ``GET``, ``HEAD``, and ``OPTIONS`` requests.
          +  CloudFront forwards ``GET, HEAD, OPTIONS, PUT, PATCH, POST``, and ``DELETE`` requests.
          
         If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
        """
        return pulumi.get(self, "allowed_methods")

    @allowed_methods.setter
    def allowed_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_methods", value)

    @property
    @pulumi.getter(name="cachePolicyId")
    def cache_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier of the cache policy that is attached to the default cache behavior. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         A ``DefaultCacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
        """
        return pulumi.get(self, "cache_policy_id")

    @cache_policy_id.setter
    def cache_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cache_policy_id", value)

    @property
    @pulumi.getter(name="cachedMethods")
    def cached_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods. There are two choices:
          +  CloudFront caches responses to ``GET`` and ``HEAD`` requests.
          +  CloudFront caches responses to ``GET``, ``HEAD``, and ``OPTIONS`` requests.
          
         If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
        """
        return pulumi.get(self, "cached_methods")

    @cached_methods.setter
    def cached_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "cached_methods", value)

    @property
    @pulumi.getter
    def compress(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify ``true``; if not, specify ``false``. For more information, see [Serving Compressed Files](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "compress")

    @compress.setter
    def compress(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "compress", value)

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        This field is deprecated. We recommend that you use the ``DefaultTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "default_ttl", value)

    @property
    @pulumi.getter(name="fieldLevelEncryptionId")
    def field_level_encryption_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value of ``ID`` for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for the default cache behavior.
        """
        return pulumi.get(self, "field_level_encryption_id")

    @field_level_encryption_id.setter
    def field_level_encryption_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "field_level_encryption_id", value)

    @property
    @pulumi.getter(name="forwardedValues")
    def forwarded_values(self) -> Optional[pulumi.Input['DistributionForwardedValuesArgs']]:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see [Working with policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html) in the *Amazon CloudFront Developer Guide*.
         If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
         A ``DefaultCacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
         A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
        """
        return pulumi.get(self, "forwarded_values")

    @forwarded_values.setter
    def forwarded_values(self, value: Optional[pulumi.Input['DistributionForwardedValuesArgs']]):
        pulumi.set(self, "forwarded_values", value)

    @property
    @pulumi.getter(name="functionAssociations")
    def function_associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionFunctionAssociationArgs']]]]:
        """
        A list of CloudFront functions that are associated with this cache behavior. Your functions must be published to the ``LIVE`` stage to associate them with a cache behavior.
        """
        return pulumi.get(self, "function_associations")

    @function_associations.setter
    def function_associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionFunctionAssociationArgs']]]]):
        pulumi.set(self, "function_associations", value)

    @property
    @pulumi.getter(name="grpcConfig")
    def grpc_config(self) -> Optional[pulumi.Input['DistributionGrpcConfigArgs']]:
        """
        The gRPC configuration for your cache behavior.
        """
        return pulumi.get(self, "grpc_config")

    @grpc_config.setter
    def grpc_config(self, value: Optional[pulumi.Input['DistributionGrpcConfigArgs']]):
        pulumi.set(self, "grpc_config", value)

    @property
    @pulumi.getter(name="lambdaFunctionAssociations")
    def lambda_function_associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionLambdaFunctionAssociationArgs']]]]:
        """
        A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
        """
        return pulumi.get(self, "lambda_function_associations")

    @lambda_function_associations.setter
    def lambda_function_associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionLambdaFunctionAssociationArgs']]]]):
        pulumi.set(self, "lambda_function_associations", value)

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        This field is deprecated. We recommend that you use the ``MaxTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max_ttl", value)

    @property
    @pulumi.getter(name="minTtl")
    def min_ttl(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        This field is deprecated. We recommend that you use the ``MinTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
         You must specify ``0`` for ``MinTTL`` if you configure CloudFront to forward all headers to your origin (under ``Headers``, if you specify ``1`` for ``Quantity`` and ``*`` for ``Name``).
        """
        return pulumi.get(self, "min_ttl")

    @min_ttl.setter
    def min_ttl(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "min_ttl", value)

    @property
    @pulumi.getter(name="originRequestPolicyId")
    def origin_request_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier of the origin request policy that is attached to the default cache behavior. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_request_policy_id")

    @origin_request_policy_id.setter
    def origin_request_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "origin_request_policy_id", value)

    @property
    @pulumi.getter(name="realtimeLogConfigArn")
    def realtime_log_config_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior. For more information, see [Real-time logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "realtime_log_config_arn")

    @realtime_log_config_arn.setter
    def realtime_log_config_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "realtime_log_config_arn", value)

    @property
    @pulumi.getter(name="responseHeadersPolicyId")
    def response_headers_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier for a response headers policy.
        """
        return pulumi.get(self, "response_headers_policy_id")

    @response_headers_policy_id.setter
    def response_headers_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "response_headers_policy_id", value)

    @property
    @pulumi.getter(name="smoothStreaming")
    def smooth_streaming(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior. If so, specify ``true``; if not, specify ``false``. If you specify ``true`` for ``SmoothStreaming``, you can still distribute other content using this cache behavior if the content matches the value of ``PathPattern``.
        """
        return pulumi.get(self, "smooth_streaming")

    @smooth_streaming.setter
    def smooth_streaming(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "smooth_streaming", value)

    @property
    @pulumi.getter(name="trustedKeyGroups")
    def trusted_key_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
         When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "trusted_key_groups")

    @trusted_key_groups.setter
    def trusted_key_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "trusted_key_groups", value)

    @property
    @pulumi.getter(name="trustedSigners")
    def trusted_signers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        We recommend using ``TrustedKeyGroups`` instead of ``TrustedSigners``.
          A list of AWS-account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.
         When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in a trusted signer's AWS-account. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "trusted_signers")

    @trusted_signers.setter
    def trusted_signers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "trusted_signers", value)


if not MYPY:
    class DistributionForwardedValuesArgsDict(TypedDict):
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
        """
        query_string: pulumi.Input[builtins.bool]
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include query strings in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         Indicates whether you want CloudFront to forward query strings to the origin that is associated with this cache behavior and cache based on the query string parameters. CloudFront behavior depends on the value of ``QueryString`` and on the values that you specify for ``QueryStringCacheKeys``, if any:
         If you specify true for ``QueryString`` and you don't specify any values for ``QueryStringCacheKeys``, CloudFront forwards all query string parameters to the origin and caches based on all query string parameters. Depending on how many query string parameters and values you have, this can adversely affect performance because CloudFront must forward more requests to the origin.
         If you specify true for ``QueryString`` and you specify one or more values for ``QueryStringCacheKeys``, CloudFront forwards all query string parameters to the origin, but it only caches based on the query string parameters that you specify.
         If you specify false for ``QueryString``, CloudFront doesn't forward any query string parameters to the origin, and doesn't cache based on query string parameters.
         For more information, see [Configuring CloudFront to Cache Based on Query String Parameters](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html) in the *Amazon CloudFront Developer Guide*.
        """
        cookies: NotRequired[pulumi.Input['DistributionCookiesArgsDict']]
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones. For more information about forwarding cookies to the origin, see [How CloudFront Forwards, Caches, and Logs Cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html) in the *Amazon CloudFront Developer Guide*.
        """
        headers: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include headers in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send headers to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         A complex type that specifies the ``Headers``, if any, that you want CloudFront to forward to the origin for this cache behavior (whitelisted headers). For the headers that you specify, CloudFront also caches separate versions of a specified object that is based on the header values in viewer requests.
         For more information, see [Caching Content Based on Request Headers](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html) in the *Amazon CloudFront Developer Guide*.
        """
        query_string_cache_keys: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include query strings in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         A complex type that contains information about the query string parameters that you want CloudFront to use for caching for this cache behavior.
        """
elif False:
    DistributionForwardedValuesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionForwardedValuesArgs:
    def __init__(__self__, *,
                 query_string: pulumi.Input[builtins.bool],
                 cookies: Optional[pulumi.Input['DistributionCookiesArgs']] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 query_string_cache_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
        :param pulumi.Input[builtins.bool] query_string: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
                If you want to include query strings in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
                If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
                Indicates whether you want CloudFront to forward query strings to the origin that is associated with this cache behavior and cache based on the query string parameters. CloudFront behavior depends on the value of ``QueryString`` and on the values that you specify for ``QueryStringCacheKeys``, if any:
                If you specify true for ``QueryString`` and you don't specify any values for ``QueryStringCacheKeys``, CloudFront forwards all query string parameters to the origin and caches based on all query string parameters. Depending on how many query string parameters and values you have, this can adversely affect performance because CloudFront must forward more requests to the origin.
                If you specify true for ``QueryString`` and you specify one or more values for ``QueryStringCacheKeys``, CloudFront forwards all query string parameters to the origin, but it only caches based on the query string parameters that you specify.
                If you specify false for ``QueryString``, CloudFront doesn't forward any query string parameters to the origin, and doesn't cache based on query string parameters.
                For more information, see [Configuring CloudFront to Cache Based on Query String Parameters](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input['DistributionCookiesArgs'] cookies: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
                If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
                If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
                A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones. For more information about forwarding cookies to the origin, see [How CloudFront Forwards, Caches, and Logs Cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] headers: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
                If you want to include headers in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
                If you want to send headers to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
                A complex type that specifies the ``Headers``, if any, that you want CloudFront to forward to the origin for this cache behavior (whitelisted headers). For the headers that you specify, CloudFront also caches separate versions of a specified object that is based on the header values in viewer requests.
                For more information, see [Caching Content Based on Request Headers](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] query_string_cache_keys: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
                If you want to include query strings in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
                If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
                A complex type that contains information about the query string parameters that you want CloudFront to use for caching for this cache behavior.
        """
        pulumi.set(__self__, "query_string", query_string)
        if cookies is not None:
            pulumi.set(__self__, "cookies", cookies)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_string_cache_keys is not None:
            pulumi.set(__self__, "query_string_cache_keys", query_string_cache_keys)

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> pulumi.Input[builtins.bool]:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include query strings in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         Indicates whether you want CloudFront to forward query strings to the origin that is associated with this cache behavior and cache based on the query string parameters. CloudFront behavior depends on the value of ``QueryString`` and on the values that you specify for ``QueryStringCacheKeys``, if any:
         If you specify true for ``QueryString`` and you don't specify any values for ``QueryStringCacheKeys``, CloudFront forwards all query string parameters to the origin and caches based on all query string parameters. Depending on how many query string parameters and values you have, this can adversely affect performance because CloudFront must forward more requests to the origin.
         If you specify true for ``QueryString`` and you specify one or more values for ``QueryStringCacheKeys``, CloudFront forwards all query string parameters to the origin, but it only caches based on the query string parameters that you specify.
         If you specify false for ``QueryString``, CloudFront doesn't forward any query string parameters to the origin, and doesn't cache based on query string parameters.
         For more information, see [Configuring CloudFront to Cache Based on Query String Parameters](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "query_string")

    @query_string.setter
    def query_string(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "query_string", value)

    @property
    @pulumi.getter
    def cookies(self) -> Optional[pulumi.Input['DistributionCookiesArgs']]:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones. For more information about forwarding cookies to the origin, see [How CloudFront Forwards, Caches, and Logs Cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "cookies")

    @cookies.setter
    def cookies(self, value: Optional[pulumi.Input['DistributionCookiesArgs']]):
        pulumi.set(self, "cookies", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include headers in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send headers to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         A complex type that specifies the ``Headers``, if any, that you want CloudFront to forward to the origin for this cache behavior (whitelisted headers). For the headers that you specify, CloudFront also caches separate versions of a specified object that is based on the header values in viewer requests.
         For more information, see [Caching Content Based on Request Headers](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="queryStringCacheKeys")
    def query_string_cache_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include query strings in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         A complex type that contains information about the query string parameters that you want CloudFront to use for caching for this cache behavior.
        """
        return pulumi.get(self, "query_string_cache_keys")

    @query_string_cache_keys.setter
    def query_string_cache_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "query_string_cache_keys", value)


if not MYPY:
    class DistributionFunctionAssociationArgsDict(TypedDict):
        """
        A CloudFront function that is associated with a cache behavior in a CloudFront distribution.
        """
        event_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The event type of the function, either ``viewer-request`` or ``viewer-response``. You cannot use origin-facing event types (``origin-request`` and ``origin-response``) with a CloudFront function.
        """
        function_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the function.
        """
elif False:
    DistributionFunctionAssociationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionFunctionAssociationArgs:
    def __init__(__self__, *,
                 event_type: Optional[pulumi.Input[builtins.str]] = None,
                 function_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        A CloudFront function that is associated with a cache behavior in a CloudFront distribution.
        :param pulumi.Input[builtins.str] event_type: The event type of the function, either ``viewer-request`` or ``viewer-response``. You cannot use origin-facing event types (``origin-request`` and ``origin-response``) with a CloudFront function.
        :param pulumi.Input[builtins.str] function_arn: The Amazon Resource Name (ARN) of the function.
        """
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if function_arn is not None:
            pulumi.set(__self__, "function_arn", function_arn)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The event type of the function, either ``viewer-request`` or ``viewer-response``. You cannot use origin-facing event types (``origin-request`` and ``origin-response``) with a CloudFront function.
        """
        return pulumi.get(self, "event_type")

    @event_type.setter
    def event_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_type", value)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the function.
        """
        return pulumi.get(self, "function_arn")

    @function_arn.setter
    def function_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "function_arn", value)


if not MYPY:
    class DistributionGeoRestrictionArgsDict(TypedDict):
        """
        A complex type that controls the countries in which your content is distributed. CF determines the location of your users using ``MaxMind`` GeoIP databases. To disable geo restriction, remove the [Restrictions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions) property from your stack template.
        """
        restriction_type: pulumi.Input[builtins.str]
        """
        The method that you want to use to restrict distribution of your content by country:
          +  ``none``: No geo restriction is enabled, meaning access to content is not restricted by client geo location.
          +  ``blacklist``: The ``Location`` elements specify the countries in which you don't want CloudFront to distribute your content.
          +  ``whitelist``: The ``Location`` elements specify the countries in which you want CloudFront to distribute your content.
        """
        locations: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A complex type that contains a ``Location`` element for each country in which you want CloudFront either to distribute your content (``whitelist``) or not distribute your content (``blacklist``).
         The ``Location`` element is a two-letter, uppercase country code for a country that you want to include in your ``blacklist`` or ``whitelist``. Include one ``Location`` element for each country.
         CloudFront and ``MaxMind`` both use ``ISO 3166`` country codes. For the current list of countries and the corresponding codes, see ``ISO 3166-1-alpha-2`` code on the *International Organization for Standardization* website. You can also refer to the country list on the CloudFront console, which includes both country names and codes.
        """
elif False:
    DistributionGeoRestrictionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionGeoRestrictionArgs:
    def __init__(__self__, *,
                 restriction_type: pulumi.Input[builtins.str],
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        A complex type that controls the countries in which your content is distributed. CF determines the location of your users using ``MaxMind`` GeoIP databases. To disable geo restriction, remove the [Restrictions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions) property from your stack template.
        :param pulumi.Input[builtins.str] restriction_type: The method that you want to use to restrict distribution of your content by country:
                 +  ``none``: No geo restriction is enabled, meaning access to content is not restricted by client geo location.
                 +  ``blacklist``: The ``Location`` elements specify the countries in which you don't want CloudFront to distribute your content.
                 +  ``whitelist``: The ``Location`` elements specify the countries in which you want CloudFront to distribute your content.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] locations: A complex type that contains a ``Location`` element for each country in which you want CloudFront either to distribute your content (``whitelist``) or not distribute your content (``blacklist``).
                The ``Location`` element is a two-letter, uppercase country code for a country that you want to include in your ``blacklist`` or ``whitelist``. Include one ``Location`` element for each country.
                CloudFront and ``MaxMind`` both use ``ISO 3166`` country codes. For the current list of countries and the corresponding codes, see ``ISO 3166-1-alpha-2`` code on the *International Organization for Standardization* website. You can also refer to the country list on the CloudFront console, which includes both country names and codes.
        """
        pulumi.set(__self__, "restriction_type", restriction_type)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)

    @property
    @pulumi.getter(name="restrictionType")
    def restriction_type(self) -> pulumi.Input[builtins.str]:
        """
        The method that you want to use to restrict distribution of your content by country:
          +  ``none``: No geo restriction is enabled, meaning access to content is not restricted by client geo location.
          +  ``blacklist``: The ``Location`` elements specify the countries in which you don't want CloudFront to distribute your content.
          +  ``whitelist``: The ``Location`` elements specify the countries in which you want CloudFront to distribute your content.
        """
        return pulumi.get(self, "restriction_type")

    @restriction_type.setter
    def restriction_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "restriction_type", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A complex type that contains a ``Location`` element for each country in which you want CloudFront either to distribute your content (``whitelist``) or not distribute your content (``blacklist``).
         The ``Location`` element is a two-letter, uppercase country code for a country that you want to include in your ``blacklist`` or ``whitelist``. Include one ``Location`` element for each country.
         CloudFront and ``MaxMind`` both use ``ISO 3166`` country codes. For the current list of countries and the corresponding codes, see ``ISO 3166-1-alpha-2`` code on the *International Organization for Standardization* website. You can also refer to the country list on the CloudFront console, which includes both country names and codes.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "locations", value)


if not MYPY:
    class DistributionGrpcConfigArgsDict(TypedDict):
        """
        Amazon CloudFront supports gRPC, an open-source remote procedure call (RPC) framework built on HTTP/2. gRPC offers bi-directional streaming and binary protocol that buffers payloads, making it suitable for applications that require low latency communications.
         To enable your distribution to handle gRPC requests, you must include HTTP/2 as one of the supported ``HTTP`` versions and allow ``HTTP`` methods, including ``POST``.
         For more information, see [Using gRPC with CloudFront distributions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-using-grpc.html) in the *Amazon CloudFront Developer Guide*.
        """
        enabled: pulumi.Input[builtins.bool]
        """
        Enables your CloudFront distribution to receive gRPC requests and to proxy them directly to your origins.
        """
elif False:
    DistributionGrpcConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionGrpcConfigArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool]):
        """
        Amazon CloudFront supports gRPC, an open-source remote procedure call (RPC) framework built on HTTP/2. gRPC offers bi-directional streaming and binary protocol that buffers payloads, making it suitable for applications that require low latency communications.
         To enable your distribution to handle gRPC requests, you must include HTTP/2 as one of the supported ``HTTP`` versions and allow ``HTTP`` methods, including ``POST``.
         For more information, see [Using gRPC with CloudFront distributions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-using-grpc.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.bool] enabled: Enables your CloudFront distribution to receive gRPC requests and to proxy them directly to your origins.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Enables your CloudFront distribution to receive gRPC requests and to proxy them directly to your origins.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class DistributionLambdaFunctionAssociationArgsDict(TypedDict):
        """
        A complex type that contains a Lambda@Edge function association.
        """
        event_type: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the event type that triggers a Lambda@Edge function invocation. You can specify the following values:
          +  ``viewer-request``: The function executes when CloudFront receives a request from a viewer and before it checks to see whether the requested object is in the edge cache.
          +  ``origin-request``: The function executes only when CloudFront sends a request to your origin. When the requested object is in the edge cache, the function doesn't execute.
          +  ``origin-response``: The function executes after CloudFront receives a response from the origin and before it caches the object in the response. When the requested object is in the edge cache, the function doesn't execute.
          +  ``viewer-response``: The function executes before CloudFront returns the requested object to the viewer. The function executes regardless of whether the object was already in the edge cache.
         If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
        """
        include_body: NotRequired[pulumi.Input[builtins.bool]]
        """
        A flag that allows a Lambda@Edge function to have read access to the body content. For more information, see [Accessing the Request Body by Choosing the Include Body Option](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html) in the Amazon CloudFront Developer Guide.
        """
        lambda_function_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of the Lambda@Edge function. You must specify the ARN of a function version; you can't specify an alias or $LATEST.
        """
elif False:
    DistributionLambdaFunctionAssociationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionLambdaFunctionAssociationArgs:
    def __init__(__self__, *,
                 event_type: Optional[pulumi.Input[builtins.str]] = None,
                 include_body: Optional[pulumi.Input[builtins.bool]] = None,
                 lambda_function_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        A complex type that contains a Lambda@Edge function association.
        :param pulumi.Input[builtins.str] event_type: Specifies the event type that triggers a Lambda@Edge function invocation. You can specify the following values:
                 +  ``viewer-request``: The function executes when CloudFront receives a request from a viewer and before it checks to see whether the requested object is in the edge cache.
                 +  ``origin-request``: The function executes only when CloudFront sends a request to your origin. When the requested object is in the edge cache, the function doesn't execute.
                 +  ``origin-response``: The function executes after CloudFront receives a response from the origin and before it caches the object in the response. When the requested object is in the edge cache, the function doesn't execute.
                 +  ``viewer-response``: The function executes before CloudFront returns the requested object to the viewer. The function executes regardless of whether the object was already in the edge cache.
                If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
        :param pulumi.Input[builtins.bool] include_body: A flag that allows a Lambda@Edge function to have read access to the body content. For more information, see [Accessing the Request Body by Choosing the Include Body Option](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html) in the Amazon CloudFront Developer Guide.
        :param pulumi.Input[builtins.str] lambda_function_arn: The ARN of the Lambda@Edge function. You must specify the ARN of a function version; you can't specify an alias or $LATEST.
        """
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if include_body is not None:
            pulumi.set(__self__, "include_body", include_body)
        if lambda_function_arn is not None:
            pulumi.set(__self__, "lambda_function_arn", lambda_function_arn)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the event type that triggers a Lambda@Edge function invocation. You can specify the following values:
          +  ``viewer-request``: The function executes when CloudFront receives a request from a viewer and before it checks to see whether the requested object is in the edge cache.
          +  ``origin-request``: The function executes only when CloudFront sends a request to your origin. When the requested object is in the edge cache, the function doesn't execute.
          +  ``origin-response``: The function executes after CloudFront receives a response from the origin and before it caches the object in the response. When the requested object is in the edge cache, the function doesn't execute.
          +  ``viewer-response``: The function executes before CloudFront returns the requested object to the viewer. The function executes regardless of whether the object was already in the edge cache.
         If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
        """
        return pulumi.get(self, "event_type")

    @event_type.setter
    def event_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_type", value)

    @property
    @pulumi.getter(name="includeBody")
    def include_body(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A flag that allows a Lambda@Edge function to have read access to the body content. For more information, see [Accessing the Request Body by Choosing the Include Body Option](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html) in the Amazon CloudFront Developer Guide.
        """
        return pulumi.get(self, "include_body")

    @include_body.setter
    def include_body(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "include_body", value)

    @property
    @pulumi.getter(name="lambdaFunctionArn")
    def lambda_function_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the Lambda@Edge function. You must specify the ARN of a function version; you can't specify an alias or $LATEST.
        """
        return pulumi.get(self, "lambda_function_arn")

    @lambda_function_arn.setter
    def lambda_function_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lambda_function_arn", value)


if not MYPY:
    class DistributionLegacyCustomOriginArgsDict(TypedDict):
        """
        A custom origin. A custom origin is any origin that is *not* an S3 bucket, with one exception. An S3 bucket that is [configured with static website hosting](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html)*is* a custom origin.
          This property is legacy. We recommend that you use [Origin](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html) instead.
        """
        dns_name: pulumi.Input[builtins.str]
        """
        The domain name assigned to your CF distribution.
        """
        origin_protocol_policy: pulumi.Input[builtins.str]
        """
        Specifies the protocol (HTTP or HTTPS) that CF uses to connect to the origin.
        """
        origin_ssl_protocols: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The minimum SSL/TLS protocol version that CF uses when communicating with your origin server over HTTPs.
         For more information, see [Minimum Origin SSL Protocol](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols) in the *Developer Guide*.
        """
        http_port: NotRequired[pulumi.Input[builtins.int]]
        """
        The HTTP port that CF uses to connect to the origin. Specify the HTTP port that the origin listens on.
        """
        https_port: NotRequired[pulumi.Input[builtins.int]]
        """
        The HTTPS port that CF uses to connect to the origin. Specify the HTTPS port that the origin listens on.
        """
elif False:
    DistributionLegacyCustomOriginArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionLegacyCustomOriginArgs:
    def __init__(__self__, *,
                 dns_name: pulumi.Input[builtins.str],
                 origin_protocol_policy: pulumi.Input[builtins.str],
                 origin_ssl_protocols: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 http_port: Optional[pulumi.Input[builtins.int]] = None,
                 https_port: Optional[pulumi.Input[builtins.int]] = None):
        """
        A custom origin. A custom origin is any origin that is *not* an S3 bucket, with one exception. An S3 bucket that is [configured with static website hosting](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html)*is* a custom origin.
          This property is legacy. We recommend that you use [Origin](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html) instead.
        :param pulumi.Input[builtins.str] dns_name: The domain name assigned to your CF distribution.
        :param pulumi.Input[builtins.str] origin_protocol_policy: Specifies the protocol (HTTP or HTTPS) that CF uses to connect to the origin.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] origin_ssl_protocols: The minimum SSL/TLS protocol version that CF uses when communicating with your origin server over HTTPs.
                For more information, see [Minimum Origin SSL Protocol](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols) in the *Developer Guide*.
        :param pulumi.Input[builtins.int] http_port: The HTTP port that CF uses to connect to the origin. Specify the HTTP port that the origin listens on.
        :param pulumi.Input[builtins.int] https_port: The HTTPS port that CF uses to connect to the origin. Specify the HTTPS port that the origin listens on.
        """
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "origin_protocol_policy", origin_protocol_policy)
        pulumi.set(__self__, "origin_ssl_protocols", origin_ssl_protocols)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if https_port is not None:
            pulumi.set(__self__, "https_port", https_port)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Input[builtins.str]:
        """
        The domain name assigned to your CF distribution.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="originProtocolPolicy")
    def origin_protocol_policy(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the protocol (HTTP or HTTPS) that CF uses to connect to the origin.
        """
        return pulumi.get(self, "origin_protocol_policy")

    @origin_protocol_policy.setter
    def origin_protocol_policy(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "origin_protocol_policy", value)

    @property
    @pulumi.getter(name="originSslProtocols")
    def origin_ssl_protocols(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The minimum SSL/TLS protocol version that CF uses when communicating with your origin server over HTTPs.
         For more information, see [Minimum Origin SSL Protocol](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols) in the *Developer Guide*.
        """
        return pulumi.get(self, "origin_ssl_protocols")

    @origin_ssl_protocols.setter
    def origin_ssl_protocols(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "origin_ssl_protocols", value)

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The HTTP port that CF uses to connect to the origin. Specify the HTTP port that the origin listens on.
        """
        return pulumi.get(self, "http_port")

    @http_port.setter
    def http_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "http_port", value)

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The HTTPS port that CF uses to connect to the origin. Specify the HTTPS port that the origin listens on.
        """
        return pulumi.get(self, "https_port")

    @https_port.setter
    def https_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "https_port", value)


if not MYPY:
    class DistributionLegacyS3OriginArgsDict(TypedDict):
        """
        The origin as an S3 bucket. 
          This property is legacy. We recommend that you use [Origin](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html) instead.
        """
        dns_name: pulumi.Input[builtins.str]
        """
        The domain name assigned to your CF distribution.
        """
        origin_access_identity: NotRequired[pulumi.Input[builtins.str]]
        """
        The CF origin access identity to associate with the distribution. Use an origin access identity to configure the distribution so that end users can only access objects in an S3 through CF.
          This property is legacy. We recommend that you use [OriginAccessControl](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originaccesscontrol.html) instead.
        """
elif False:
    DistributionLegacyS3OriginArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionLegacyS3OriginArgs:
    def __init__(__self__, *,
                 dns_name: pulumi.Input[builtins.str],
                 origin_access_identity: Optional[pulumi.Input[builtins.str]] = None):
        """
        The origin as an S3 bucket. 
          This property is legacy. We recommend that you use [Origin](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html) instead.
        :param pulumi.Input[builtins.str] dns_name: The domain name assigned to your CF distribution.
        :param pulumi.Input[builtins.str] origin_access_identity: The CF origin access identity to associate with the distribution. Use an origin access identity to configure the distribution so that end users can only access objects in an S3 through CF.
                 This property is legacy. We recommend that you use [OriginAccessControl](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originaccesscontrol.html) instead.
        """
        pulumi.set(__self__, "dns_name", dns_name)
        if origin_access_identity is not None:
            pulumi.set(__self__, "origin_access_identity", origin_access_identity)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Input[builtins.str]:
        """
        The domain name assigned to your CF distribution.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="originAccessIdentity")
    def origin_access_identity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CF origin access identity to associate with the distribution. Use an origin access identity to configure the distribution so that end users can only access objects in an S3 through CF.
          This property is legacy. We recommend that you use [OriginAccessControl](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originaccesscontrol.html) instead.
        """
        return pulumi.get(self, "origin_access_identity")

    @origin_access_identity.setter
    def origin_access_identity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "origin_access_identity", value)


if not MYPY:
    class DistributionLoggingArgsDict(TypedDict):
        """
        A complex type that specifies whether access logs are written for the distribution.
          If you already enabled standard logging (legacy) and you want to enable standard logging (v2) to send your access logs to Amazon S3, we recommend that you specify a *different* Amazon S3 bucket or use a *separate path* in the same bucket (for example, use a log prefix or partitioning). This helps you keep track of which log files are associated with which logging subscription and prevents log files from overwriting each other. For more information, see [Standard logging (access logs)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html) in the *Amazon CloudFront Developer Guide*.
        """
        bucket: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon S3 bucket to store the access logs in, for example, ``amzn-s3-demo-bucket.s3.amazonaws.com``.
        """
        include_cookies: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether you want CloudFront to include cookies in access logs, specify ``true`` for ``IncludeCookies``. If you choose to include cookies in logs, CloudFront logs all cookies regardless of how you configure the cache behaviors for this distribution. If you don't want to include cookies when you create a distribution or if you want to disable include cookies for an existing distribution, specify ``false`` for ``IncludeCookies``.
        """
        prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        An optional string that you want CloudFront to prefix to the access log ``filenames`` for this distribution, for example, ``myprefix/``. If you want to enable logging, but you don't want to specify a prefix, you still must include an empty ``Prefix`` element in the ``Logging`` element.
        """
elif False:
    DistributionLoggingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionLoggingArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 include_cookies: Optional[pulumi.Input[builtins.bool]] = None,
                 prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        A complex type that specifies whether access logs are written for the distribution.
          If you already enabled standard logging (legacy) and you want to enable standard logging (v2) to send your access logs to Amazon S3, we recommend that you specify a *different* Amazon S3 bucket or use a *separate path* in the same bucket (for example, use a log prefix or partitioning). This helps you keep track of which log files are associated with which logging subscription and prevents log files from overwriting each other. For more information, see [Standard logging (access logs)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.str] bucket: The Amazon S3 bucket to store the access logs in, for example, ``amzn-s3-demo-bucket.s3.amazonaws.com``.
        :param pulumi.Input[builtins.bool] include_cookies: Specifies whether you want CloudFront to include cookies in access logs, specify ``true`` for ``IncludeCookies``. If you choose to include cookies in logs, CloudFront logs all cookies regardless of how you configure the cache behaviors for this distribution. If you don't want to include cookies when you create a distribution or if you want to disable include cookies for an existing distribution, specify ``false`` for ``IncludeCookies``.
        :param pulumi.Input[builtins.str] prefix: An optional string that you want CloudFront to prefix to the access log ``filenames`` for this distribution, for example, ``myprefix/``. If you want to enable logging, but you don't want to specify a prefix, you still must include an empty ``Prefix`` element in the ``Logging`` element.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if include_cookies is not None:
            pulumi.set(__self__, "include_cookies", include_cookies)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon S3 bucket to store the access logs in, for example, ``amzn-s3-demo-bucket.s3.amazonaws.com``.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="includeCookies")
    def include_cookies(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether you want CloudFront to include cookies in access logs, specify ``true`` for ``IncludeCookies``. If you choose to include cookies in logs, CloudFront logs all cookies regardless of how you configure the cache behaviors for this distribution. If you don't want to include cookies when you create a distribution or if you want to disable include cookies for an existing distribution, specify ``false`` for ``IncludeCookies``.
        """
        return pulumi.get(self, "include_cookies")

    @include_cookies.setter
    def include_cookies(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "include_cookies", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional string that you want CloudFront to prefix to the access log ``filenames`` for this distribution, for example, ``myprefix/``. If you want to enable logging, but you don't want to specify a prefix, you still must include an empty ``Prefix`` element in the ``Logging`` element.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prefix", value)


if not MYPY:
    class DistributionOriginCustomHeaderArgsDict(TypedDict):
        """
        A complex type that contains ``HeaderName`` and ``HeaderValue`` elements, if any, for this distribution.
        """
        header_name: pulumi.Input[builtins.str]
        """
        The name of a header that you want CloudFront to send to your origin. For more information, see [Adding Custom Headers to Origin Requests](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html) in the *Amazon CloudFront Developer Guide*.
        """
        header_value: pulumi.Input[builtins.str]
        """
        The value for the header that you specified in the ``HeaderName`` field.
        """
elif False:
    DistributionOriginCustomHeaderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionOriginCustomHeaderArgs:
    def __init__(__self__, *,
                 header_name: pulumi.Input[builtins.str],
                 header_value: pulumi.Input[builtins.str]):
        """
        A complex type that contains ``HeaderName`` and ``HeaderValue`` elements, if any, for this distribution.
        :param pulumi.Input[builtins.str] header_name: The name of a header that you want CloudFront to send to your origin. For more information, see [Adding Custom Headers to Origin Requests](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.str] header_value: The value for the header that you specified in the ``HeaderName`` field.
        """
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "header_value", header_value)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of a header that you want CloudFront to send to your origin. For more information, see [Adding Custom Headers to Origin Requests](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "header_name", value)

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> pulumi.Input[builtins.str]:
        """
        The value for the header that you specified in the ``HeaderName`` field.
        """
        return pulumi.get(self, "header_value")

    @header_value.setter
    def header_value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "header_value", value)


if not MYPY:
    class DistributionOriginGroupFailoverCriteriaArgsDict(TypedDict):
        """
        A complex data type that includes information about the failover criteria for an origin group, including the status codes for which CloudFront will failover from the primary origin to the second origin.
        """
        status_codes: pulumi.Input['DistributionStatusCodesArgsDict']
        """
        The status codes that, when returned from the primary origin, will trigger CloudFront to failover to the second origin.
        """
elif False:
    DistributionOriginGroupFailoverCriteriaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionOriginGroupFailoverCriteriaArgs:
    def __init__(__self__, *,
                 status_codes: pulumi.Input['DistributionStatusCodesArgs']):
        """
        A complex data type that includes information about the failover criteria for an origin group, including the status codes for which CloudFront will failover from the primary origin to the second origin.
        :param pulumi.Input['DistributionStatusCodesArgs'] status_codes: The status codes that, when returned from the primary origin, will trigger CloudFront to failover to the second origin.
        """
        pulumi.set(__self__, "status_codes", status_codes)

    @property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> pulumi.Input['DistributionStatusCodesArgs']:
        """
        The status codes that, when returned from the primary origin, will trigger CloudFront to failover to the second origin.
        """
        return pulumi.get(self, "status_codes")

    @status_codes.setter
    def status_codes(self, value: pulumi.Input['DistributionStatusCodesArgs']):
        pulumi.set(self, "status_codes", value)


if not MYPY:
    class DistributionOriginGroupMembersArgsDict(TypedDict):
        """
        A complex data type for the origins included in an origin group.
        """
        items: pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupMemberArgsDict']]]
        """
        Items (origins) in an origin group.
        """
        quantity: pulumi.Input[builtins.int]
        """
        The number of origins in an origin group.
        """
elif False:
    DistributionOriginGroupMembersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionOriginGroupMembersArgs:
    def __init__(__self__, *,
                 items: pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupMemberArgs']]],
                 quantity: pulumi.Input[builtins.int]):
        """
        A complex data type for the origins included in an origin group.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupMemberArgs']]] items: Items (origins) in an origin group.
        :param pulumi.Input[builtins.int] quantity: The number of origins in an origin group.
        """
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def items(self) -> pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupMemberArgs']]]:
        """
        Items (origins) in an origin group.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupMemberArgs']]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def quantity(self) -> pulumi.Input[builtins.int]:
        """
        The number of origins in an origin group.
        """
        return pulumi.get(self, "quantity")

    @quantity.setter
    def quantity(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "quantity", value)


if not MYPY:
    class DistributionOriginGroupMemberArgsDict(TypedDict):
        """
        An origin in an origin group.
        """
        origin_id: pulumi.Input[builtins.str]
        """
        The ID for an origin in an origin group.
        """
elif False:
    DistributionOriginGroupMemberArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionOriginGroupMemberArgs:
    def __init__(__self__, *,
                 origin_id: pulumi.Input[builtins.str]):
        """
        An origin in an origin group.
        :param pulumi.Input[builtins.str] origin_id: The ID for an origin in an origin group.
        """
        pulumi.set(__self__, "origin_id", origin_id)

    @property
    @pulumi.getter(name="originId")
    def origin_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID for an origin in an origin group.
        """
        return pulumi.get(self, "origin_id")

    @origin_id.setter
    def origin_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "origin_id", value)


if not MYPY:
    class DistributionOriginGroupsArgsDict(TypedDict):
        """
        A complex data type for the origin groups specified for a distribution.
        """
        quantity: pulumi.Input[builtins.int]
        """
        The number of origin groups.
        """
        items: NotRequired[pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupArgsDict']]]]
        """
        The items (origin groups) in a distribution.
        """
elif False:
    DistributionOriginGroupsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionOriginGroupsArgs:
    def __init__(__self__, *,
                 quantity: pulumi.Input[builtins.int],
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupArgs']]]] = None):
        """
        A complex data type for the origin groups specified for a distribution.
        :param pulumi.Input[builtins.int] quantity: The number of origin groups.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupArgs']]] items: The items (origin groups) in a distribution.
        """
        pulumi.set(__self__, "quantity", quantity)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def quantity(self) -> pulumi.Input[builtins.int]:
        """
        The number of origin groups.
        """
        return pulumi.get(self, "quantity")

    @quantity.setter
    def quantity(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "quantity", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupArgs']]]]:
        """
        The items (origin groups) in a distribution.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupArgs']]]]):
        pulumi.set(self, "items", value)


if not MYPY:
    class DistributionOriginGroupArgsDict(TypedDict):
        """
        An origin group includes two origins (a primary origin and a secondary origin to failover to) and a failover criteria that you specify. You create an origin group to support origin failover in CloudFront. When you create or update a distribution, you can specify the origin group instead of a single origin, and CloudFront will failover from the primary origin to the secondary origin under the failover conditions that you've chosen.
         Optionally, you can choose selection criteria for your origin group to specify how your origins are selected when your distribution routes viewer requests.
        """
        failover_criteria: pulumi.Input['DistributionOriginGroupFailoverCriteriaArgsDict']
        """
        A complex type that contains information about the failover criteria for an origin group.
        """
        id: pulumi.Input[builtins.str]
        """
        The origin group's ID.
        """
        members: pulumi.Input['DistributionOriginGroupMembersArgsDict']
        """
        A complex type that contains information about the origins in an origin group.
        """
        selection_criteria: NotRequired[pulumi.Input['DistributionOriginGroupSelectionCriteria']]
        """
        The selection criteria for the origin group. For more information, see [Create an origin group](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/high_availability_origin_failover.html#concept_origin_groups.creating) in the *Amazon CloudFront Developer Guide*.
        """
elif False:
    DistributionOriginGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionOriginGroupArgs:
    def __init__(__self__, *,
                 failover_criteria: pulumi.Input['DistributionOriginGroupFailoverCriteriaArgs'],
                 id: pulumi.Input[builtins.str],
                 members: pulumi.Input['DistributionOriginGroupMembersArgs'],
                 selection_criteria: Optional[pulumi.Input['DistributionOriginGroupSelectionCriteria']] = None):
        """
        An origin group includes two origins (a primary origin and a secondary origin to failover to) and a failover criteria that you specify. You create an origin group to support origin failover in CloudFront. When you create or update a distribution, you can specify the origin group instead of a single origin, and CloudFront will failover from the primary origin to the secondary origin under the failover conditions that you've chosen.
         Optionally, you can choose selection criteria for your origin group to specify how your origins are selected when your distribution routes viewer requests.
        :param pulumi.Input['DistributionOriginGroupFailoverCriteriaArgs'] failover_criteria: A complex type that contains information about the failover criteria for an origin group.
        :param pulumi.Input[builtins.str] id: The origin group's ID.
        :param pulumi.Input['DistributionOriginGroupMembersArgs'] members: A complex type that contains information about the origins in an origin group.
        :param pulumi.Input['DistributionOriginGroupSelectionCriteria'] selection_criteria: The selection criteria for the origin group. For more information, see [Create an origin group](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/high_availability_origin_failover.html#concept_origin_groups.creating) in the *Amazon CloudFront Developer Guide*.
        """
        pulumi.set(__self__, "failover_criteria", failover_criteria)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "members", members)
        if selection_criteria is not None:
            pulumi.set(__self__, "selection_criteria", selection_criteria)

    @property
    @pulumi.getter(name="failoverCriteria")
    def failover_criteria(self) -> pulumi.Input['DistributionOriginGroupFailoverCriteriaArgs']:
        """
        A complex type that contains information about the failover criteria for an origin group.
        """
        return pulumi.get(self, "failover_criteria")

    @failover_criteria.setter
    def failover_criteria(self, value: pulumi.Input['DistributionOriginGroupFailoverCriteriaArgs']):
        pulumi.set(self, "failover_criteria", value)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[builtins.str]:
        """
        The origin group's ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def members(self) -> pulumi.Input['DistributionOriginGroupMembersArgs']:
        """
        A complex type that contains information about the origins in an origin group.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: pulumi.Input['DistributionOriginGroupMembersArgs']):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter(name="selectionCriteria")
    def selection_criteria(self) -> Optional[pulumi.Input['DistributionOriginGroupSelectionCriteria']]:
        """
        The selection criteria for the origin group. For more information, see [Create an origin group](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/high_availability_origin_failover.html#concept_origin_groups.creating) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "selection_criteria")

    @selection_criteria.setter
    def selection_criteria(self, value: Optional[pulumi.Input['DistributionOriginGroupSelectionCriteria']]):
        pulumi.set(self, "selection_criteria", value)


if not MYPY:
    class DistributionOriginShieldArgsDict(TypedDict):
        """
        CloudFront Origin Shield.
         Using Origin Shield can help reduce the load on your origin. For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the *Amazon CloudFront Developer Guide*.
        """
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        A flag that specifies whether Origin Shield is enabled.
         When it's enabled, CloudFront routes all requests through Origin Shield, which can help protect your origin. When it's disabled, CloudFront might send requests directly to your origin from multiple edge locations or regional edge caches.
        """
        origin_shield_region: NotRequired[pulumi.Input[builtins.str]]
        """
        The AWS-Region for Origin Shield.
         Specify the AWS-Region that has the lowest latency to your origin. To specify a region, use the region code, not the region name. For example, specify the US East (Ohio) region as ``us-east-2``.
         When you enable CloudFront Origin Shield, you must specify the AWS-Region for Origin Shield. For the list of AWS-Regions that you can specify, and for help choosing the best Region for your origin, see [Choosing the for Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region) in the *Amazon CloudFront Developer Guide*.
        """
elif False:
    DistributionOriginShieldArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionOriginShieldArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 origin_shield_region: Optional[pulumi.Input[builtins.str]] = None):
        """
        CloudFront Origin Shield.
         Using Origin Shield can help reduce the load on your origin. For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.bool] enabled: A flag that specifies whether Origin Shield is enabled.
                When it's enabled, CloudFront routes all requests through Origin Shield, which can help protect your origin. When it's disabled, CloudFront might send requests directly to your origin from multiple edge locations or regional edge caches.
        :param pulumi.Input[builtins.str] origin_shield_region: The AWS-Region for Origin Shield.
                Specify the AWS-Region that has the lowest latency to your origin. To specify a region, use the region code, not the region name. For example, specify the US East (Ohio) region as ``us-east-2``.
                When you enable CloudFront Origin Shield, you must specify the AWS-Region for Origin Shield. For the list of AWS-Regions that you can specify, and for help choosing the best Region for your origin, see [Choosing the for Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region) in the *Amazon CloudFront Developer Guide*.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if origin_shield_region is not None:
            pulumi.set(__self__, "origin_shield_region", origin_shield_region)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A flag that specifies whether Origin Shield is enabled.
         When it's enabled, CloudFront routes all requests through Origin Shield, which can help protect your origin. When it's disabled, CloudFront might send requests directly to your origin from multiple edge locations or regional edge caches.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="originShieldRegion")
    def origin_shield_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS-Region for Origin Shield.
         Specify the AWS-Region that has the lowest latency to your origin. To specify a region, use the region code, not the region name. For example, specify the US East (Ohio) region as ``us-east-2``.
         When you enable CloudFront Origin Shield, you must specify the AWS-Region for Origin Shield. For the list of AWS-Regions that you can specify, and for help choosing the best Region for your origin, see [Choosing the for Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_shield_region")

    @origin_shield_region.setter
    def origin_shield_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "origin_shield_region", value)


if not MYPY:
    class DistributionOriginArgsDict(TypedDict):
        """
        An origin.
         An origin is the location where content is stored, and from which CloudFront gets content to serve to viewers. To specify an origin:
          +  Use ``S3OriginConfig`` to specify an Amazon S3 bucket that is not configured with static website hosting.
          +  Use ``VpcOriginConfig`` to specify a VPC origin.
          +  Use ``CustomOriginConfig`` to specify all other kinds of origins, including:
          +  An Amazon S3 bucket that is configured with static website hosting
          +  An Elastic Load Balancing load balancer
          +  An EMPlong endpoint
          +  An EMSlong container
          +  Any other HTTP server, running on an Amazon EC2 instance or any other kind of host
          
          
         For the current maximum number of origins that you can specify per distribution, see [General Quotas on Web Distributions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html#limits-web-distributions) in the *Amazon CloudFront Developer Guide* (quotas were formerly referred to as limits).
        """
        domain_name: pulumi.Input[builtins.str]
        """
        The domain name for the origin.
         For more information, see [Origin Domain Name](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName) in the *Amazon CloudFront Developer Guide*.
        """
        id: pulumi.Input[builtins.str]
        """
        A unique identifier for the origin. This value must be unique within the distribution.
         Use this value to specify the ``TargetOriginId`` in a ``CacheBehavior`` or ``DefaultCacheBehavior``.
        """
        connection_attempts: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of times that CloudFront attempts to connect to the origin. The minimum number is 1, the maximum is 3, and the default (if you don't specify otherwise) is 3.
         For a custom origin (including an Amazon S3 bucket that's configured with static website hosting), this value also specifies the number of times that CloudFront attempts to get a response from the origin, in the case of an [Origin Response Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout).
         For more information, see [Origin Connection Attempts](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts) in the *Amazon CloudFront Developer Guide*.
        """
        connection_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds that CloudFront waits when trying to establish a connection to the origin. The minimum timeout is 1 second, the maximum is 10 seconds, and the default (if you don't specify otherwise) is 10 seconds.
         For more information, see [Origin Connection Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout) in the *Amazon CloudFront Developer Guide*.
        """
        custom_origin_config: NotRequired[pulumi.Input['DistributionCustomOriginConfigArgsDict']]
        """
        Use this type to specify an origin that is not an Amazon S3 bucket, with one exception. If the Amazon S3 bucket is configured with static website hosting, use this type. If the Amazon S3 bucket is not configured with static website hosting, use the ``S3OriginConfig`` type instead.
        """
        origin_access_control_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The unique identifier of an origin access control for this origin.
         For more information, see [Restricting access to an Amazon S3 origin](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html) in the *Amazon CloudFront Developer Guide*.
        """
        origin_custom_headers: NotRequired[pulumi.Input[Sequence[pulumi.Input['DistributionOriginCustomHeaderArgsDict']]]]
        """
        A list of HTTP header names and values that CloudFront adds to the requests that it sends to the origin.
         For more information, see [Adding Custom Headers to Origin Requests](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html) in the *Amazon CloudFront Developer Guide*.
        """
        origin_path: NotRequired[pulumi.Input[builtins.str]]
        """
        An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
         For more information, see [Origin Path](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath) in the *Amazon CloudFront Developer Guide*.
        """
        origin_shield: NotRequired[pulumi.Input['DistributionOriginShieldArgsDict']]
        """
        CloudFront Origin Shield. Using Origin Shield can help reduce the load on your origin.
         For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the *Amazon CloudFront Developer Guide*.
        """
        s3_origin_config: NotRequired[pulumi.Input['DistributionS3OriginConfigArgsDict']]
        """
        Use this type to specify an origin that is an Amazon S3 bucket that is not configured with static website hosting. To specify any other type of origin, including an Amazon S3 bucket that is configured with static website hosting, use the ``CustomOriginConfig`` type instead.
        """
        vpc_origin_config: NotRequired[pulumi.Input['DistributionVpcOriginConfigArgsDict']]
        """
        The VPC origin configuration.
        """
elif False:
    DistributionOriginArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionOriginArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[builtins.str],
                 id: pulumi.Input[builtins.str],
                 connection_attempts: Optional[pulumi.Input[builtins.int]] = None,
                 connection_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 custom_origin_config: Optional[pulumi.Input['DistributionCustomOriginConfigArgs']] = None,
                 origin_access_control_id: Optional[pulumi.Input[builtins.str]] = None,
                 origin_custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginCustomHeaderArgs']]]] = None,
                 origin_path: Optional[pulumi.Input[builtins.str]] = None,
                 origin_shield: Optional[pulumi.Input['DistributionOriginShieldArgs']] = None,
                 s3_origin_config: Optional[pulumi.Input['DistributionS3OriginConfigArgs']] = None,
                 vpc_origin_config: Optional[pulumi.Input['DistributionVpcOriginConfigArgs']] = None):
        """
        An origin.
         An origin is the location where content is stored, and from which CloudFront gets content to serve to viewers. To specify an origin:
          +  Use ``S3OriginConfig`` to specify an Amazon S3 bucket that is not configured with static website hosting.
          +  Use ``VpcOriginConfig`` to specify a VPC origin.
          +  Use ``CustomOriginConfig`` to specify all other kinds of origins, including:
          +  An Amazon S3 bucket that is configured with static website hosting
          +  An Elastic Load Balancing load balancer
          +  An EMPlong endpoint
          +  An EMSlong container
          +  Any other HTTP server, running on an Amazon EC2 instance or any other kind of host
          
          
         For the current maximum number of origins that you can specify per distribution, see [General Quotas on Web Distributions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html#limits-web-distributions) in the *Amazon CloudFront Developer Guide* (quotas were formerly referred to as limits).
        :param pulumi.Input[builtins.str] domain_name: The domain name for the origin.
                For more information, see [Origin Domain Name](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.str] id: A unique identifier for the origin. This value must be unique within the distribution.
                Use this value to specify the ``TargetOriginId`` in a ``CacheBehavior`` or ``DefaultCacheBehavior``.
        :param pulumi.Input[builtins.int] connection_attempts: The number of times that CloudFront attempts to connect to the origin. The minimum number is 1, the maximum is 3, and the default (if you don't specify otherwise) is 3.
                For a custom origin (including an Amazon S3 bucket that's configured with static website hosting), this value also specifies the number of times that CloudFront attempts to get a response from the origin, in the case of an [Origin Response Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout).
                For more information, see [Origin Connection Attempts](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.int] connection_timeout: The number of seconds that CloudFront waits when trying to establish a connection to the origin. The minimum timeout is 1 second, the maximum is 10 seconds, and the default (if you don't specify otherwise) is 10 seconds.
                For more information, see [Origin Connection Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input['DistributionCustomOriginConfigArgs'] custom_origin_config: Use this type to specify an origin that is not an Amazon S3 bucket, with one exception. If the Amazon S3 bucket is configured with static website hosting, use this type. If the Amazon S3 bucket is not configured with static website hosting, use the ``S3OriginConfig`` type instead.
        :param pulumi.Input[builtins.str] origin_access_control_id: The unique identifier of an origin access control for this origin.
                For more information, see [Restricting access to an Amazon S3 origin](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionOriginCustomHeaderArgs']]] origin_custom_headers: A list of HTTP header names and values that CloudFront adds to the requests that it sends to the origin.
                For more information, see [Adding Custom Headers to Origin Requests](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.str] origin_path: An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
                For more information, see [Origin Path](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input['DistributionOriginShieldArgs'] origin_shield: CloudFront Origin Shield. Using Origin Shield can help reduce the load on your origin.
                For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input['DistributionS3OriginConfigArgs'] s3_origin_config: Use this type to specify an origin that is an Amazon S3 bucket that is not configured with static website hosting. To specify any other type of origin, including an Amazon S3 bucket that is configured with static website hosting, use the ``CustomOriginConfig`` type instead.
        :param pulumi.Input['DistributionVpcOriginConfigArgs'] vpc_origin_config: The VPC origin configuration.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "id", id)
        if connection_attempts is not None:
            pulumi.set(__self__, "connection_attempts", connection_attempts)
        if connection_timeout is not None:
            pulumi.set(__self__, "connection_timeout", connection_timeout)
        if custom_origin_config is not None:
            pulumi.set(__self__, "custom_origin_config", custom_origin_config)
        if origin_access_control_id is not None:
            pulumi.set(__self__, "origin_access_control_id", origin_access_control_id)
        if origin_custom_headers is not None:
            pulumi.set(__self__, "origin_custom_headers", origin_custom_headers)
        if origin_path is not None:
            pulumi.set(__self__, "origin_path", origin_path)
        if origin_shield is not None:
            pulumi.set(__self__, "origin_shield", origin_shield)
        if s3_origin_config is not None:
            pulumi.set(__self__, "s3_origin_config", s3_origin_config)
        if vpc_origin_config is not None:
            pulumi.set(__self__, "vpc_origin_config", vpc_origin_config)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[builtins.str]:
        """
        The domain name for the origin.
         For more information, see [Origin Domain Name](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[builtins.str]:
        """
        A unique identifier for the origin. This value must be unique within the distribution.
         Use this value to specify the ``TargetOriginId`` in a ``CacheBehavior`` or ``DefaultCacheBehavior``.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="connectionAttempts")
    def connection_attempts(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of times that CloudFront attempts to connect to the origin. The minimum number is 1, the maximum is 3, and the default (if you don't specify otherwise) is 3.
         For a custom origin (including an Amazon S3 bucket that's configured with static website hosting), this value also specifies the number of times that CloudFront attempts to get a response from the origin, in the case of an [Origin Response Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout).
         For more information, see [Origin Connection Attempts](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "connection_attempts")

    @connection_attempts.setter
    def connection_attempts(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "connection_attempts", value)

    @property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds that CloudFront waits when trying to establish a connection to the origin. The minimum timeout is 1 second, the maximum is 10 seconds, and the default (if you don't specify otherwise) is 10 seconds.
         For more information, see [Origin Connection Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "connection_timeout")

    @connection_timeout.setter
    def connection_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "connection_timeout", value)

    @property
    @pulumi.getter(name="customOriginConfig")
    def custom_origin_config(self) -> Optional[pulumi.Input['DistributionCustomOriginConfigArgs']]:
        """
        Use this type to specify an origin that is not an Amazon S3 bucket, with one exception. If the Amazon S3 bucket is configured with static website hosting, use this type. If the Amazon S3 bucket is not configured with static website hosting, use the ``S3OriginConfig`` type instead.
        """
        return pulumi.get(self, "custom_origin_config")

    @custom_origin_config.setter
    def custom_origin_config(self, value: Optional[pulumi.Input['DistributionCustomOriginConfigArgs']]):
        pulumi.set(self, "custom_origin_config", value)

    @property
    @pulumi.getter(name="originAccessControlId")
    def origin_access_control_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier of an origin access control for this origin.
         For more information, see [Restricting access to an Amazon S3 origin](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_access_control_id")

    @origin_access_control_id.setter
    def origin_access_control_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "origin_access_control_id", value)

    @property
    @pulumi.getter(name="originCustomHeaders")
    def origin_custom_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginCustomHeaderArgs']]]]:
        """
        A list of HTTP header names and values that CloudFront adds to the requests that it sends to the origin.
         For more information, see [Adding Custom Headers to Origin Requests](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_custom_headers")

    @origin_custom_headers.setter
    def origin_custom_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginCustomHeaderArgs']]]]):
        pulumi.set(self, "origin_custom_headers", value)

    @property
    @pulumi.getter(name="originPath")
    def origin_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
         For more information, see [Origin Path](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_path")

    @origin_path.setter
    def origin_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "origin_path", value)

    @property
    @pulumi.getter(name="originShield")
    def origin_shield(self) -> Optional[pulumi.Input['DistributionOriginShieldArgs']]:
        """
        CloudFront Origin Shield. Using Origin Shield can help reduce the load on your origin.
         For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_shield")

    @origin_shield.setter
    def origin_shield(self, value: Optional[pulumi.Input['DistributionOriginShieldArgs']]):
        pulumi.set(self, "origin_shield", value)

    @property
    @pulumi.getter(name="s3OriginConfig")
    def s3_origin_config(self) -> Optional[pulumi.Input['DistributionS3OriginConfigArgs']]:
        """
        Use this type to specify an origin that is an Amazon S3 bucket that is not configured with static website hosting. To specify any other type of origin, including an Amazon S3 bucket that is configured with static website hosting, use the ``CustomOriginConfig`` type instead.
        """
        return pulumi.get(self, "s3_origin_config")

    @s3_origin_config.setter
    def s3_origin_config(self, value: Optional[pulumi.Input['DistributionS3OriginConfigArgs']]):
        pulumi.set(self, "s3_origin_config", value)

    @property
    @pulumi.getter(name="vpcOriginConfig")
    def vpc_origin_config(self) -> Optional[pulumi.Input['DistributionVpcOriginConfigArgs']]:
        """
        The VPC origin configuration.
        """
        return pulumi.get(self, "vpc_origin_config")

    @vpc_origin_config.setter
    def vpc_origin_config(self, value: Optional[pulumi.Input['DistributionVpcOriginConfigArgs']]):
        pulumi.set(self, "vpc_origin_config", value)


if not MYPY:
    class DistributionParameterDefinitionDefinitionPropertiesStringSchemaPropertiesArgsDict(TypedDict):
        required: pulumi.Input[builtins.bool]
        comment: NotRequired[pulumi.Input[builtins.str]]
        default_value: NotRequired[pulumi.Input[builtins.str]]
elif False:
    DistributionParameterDefinitionDefinitionPropertiesStringSchemaPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionParameterDefinitionDefinitionPropertiesStringSchemaPropertiesArgs:
    def __init__(__self__, *,
                 required: pulumi.Input[builtins.bool],
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 default_value: Optional[pulumi.Input[builtins.str]] = None):
        pulumi.set(__self__, "required", required)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)

    @property
    @pulumi.getter
    def required(self) -> pulumi.Input[builtins.bool]:
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "required", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_value", value)


if not MYPY:
    class DistributionParameterDefinitionDefinitionPropertiesArgsDict(TypedDict):
        """
        The value that you assigned to the parameter.
        """
        string_schema: NotRequired[pulumi.Input['DistributionParameterDefinitionDefinitionPropertiesStringSchemaPropertiesArgsDict']]
elif False:
    DistributionParameterDefinitionDefinitionPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionParameterDefinitionDefinitionPropertiesArgs:
    def __init__(__self__, *,
                 string_schema: Optional[pulumi.Input['DistributionParameterDefinitionDefinitionPropertiesStringSchemaPropertiesArgs']] = None):
        """
        The value that you assigned to the parameter.
        """
        if string_schema is not None:
            pulumi.set(__self__, "string_schema", string_schema)

    @property
    @pulumi.getter(name="stringSchema")
    def string_schema(self) -> Optional[pulumi.Input['DistributionParameterDefinitionDefinitionPropertiesStringSchemaPropertiesArgs']]:
        return pulumi.get(self, "string_schema")

    @string_schema.setter
    def string_schema(self, value: Optional[pulumi.Input['DistributionParameterDefinitionDefinitionPropertiesStringSchemaPropertiesArgs']]):
        pulumi.set(self, "string_schema", value)


if not MYPY:
    class DistributionParameterDefinitionArgsDict(TypedDict):
        """
        A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
        """
        definition: pulumi.Input['DistributionParameterDefinitionDefinitionPropertiesArgsDict']
        """
        The value that you assigned to the parameter.
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the parameter.
        """
elif False:
    DistributionParameterDefinitionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionParameterDefinitionArgs:
    def __init__(__self__, *,
                 definition: pulumi.Input['DistributionParameterDefinitionDefinitionPropertiesArgs'],
                 name: pulumi.Input[builtins.str]):
        """
        A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
        :param pulumi.Input['DistributionParameterDefinitionDefinitionPropertiesArgs'] definition: The value that you assigned to the parameter.
        :param pulumi.Input[builtins.str] name: The name of the parameter.
        """
        pulumi.set(__self__, "definition", definition)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def definition(self) -> pulumi.Input['DistributionParameterDefinitionDefinitionPropertiesArgs']:
        """
        The value that you assigned to the parameter.
        """
        return pulumi.get(self, "definition")

    @definition.setter
    def definition(self, value: pulumi.Input['DistributionParameterDefinitionDefinitionPropertiesArgs']):
        pulumi.set(self, "definition", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class DistributionRestrictionsArgsDict(TypedDict):
        """
        A complex type that identifies ways in which you want to restrict distribution of your content.
        """
        geo_restriction: pulumi.Input['DistributionGeoRestrictionArgsDict']
        """
        A complex type that controls the countries in which your content is distributed. CF determines the location of your users using ``MaxMind`` GeoIP databases. To disable geo restriction, remove the [Restrictions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions) property from your stack template.
        """
elif False:
    DistributionRestrictionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionRestrictionsArgs:
    def __init__(__self__, *,
                 geo_restriction: pulumi.Input['DistributionGeoRestrictionArgs']):
        """
        A complex type that identifies ways in which you want to restrict distribution of your content.
        :param pulumi.Input['DistributionGeoRestrictionArgs'] geo_restriction: A complex type that controls the countries in which your content is distributed. CF determines the location of your users using ``MaxMind`` GeoIP databases. To disable geo restriction, remove the [Restrictions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions) property from your stack template.
        """
        pulumi.set(__self__, "geo_restriction", geo_restriction)

    @property
    @pulumi.getter(name="geoRestriction")
    def geo_restriction(self) -> pulumi.Input['DistributionGeoRestrictionArgs']:
        """
        A complex type that controls the countries in which your content is distributed. CF determines the location of your users using ``MaxMind`` GeoIP databases. To disable geo restriction, remove the [Restrictions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions) property from your stack template.
        """
        return pulumi.get(self, "geo_restriction")

    @geo_restriction.setter
    def geo_restriction(self, value: pulumi.Input['DistributionGeoRestrictionArgs']):
        pulumi.set(self, "geo_restriction", value)


if not MYPY:
    class DistributionS3OriginConfigArgsDict(TypedDict):
        """
        A complex type that contains information about the Amazon S3 origin. If the origin is a custom origin or an S3 bucket that is configured as a website endpoint, use the ``CustomOriginConfig`` element instead.
        """
        origin_access_identity: NotRequired[pulumi.Input[builtins.str]]
        """
        If you're using origin access control (OAC) instead of origin access identity, specify an empty ``OriginAccessIdentity`` element. For more information, see [Restricting access to an](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html) in the *Amazon CloudFront Developer Guide*.
          The CloudFront origin access identity to associate with the origin. Use an origin access identity to configure the origin so that viewers can *only* access objects in an Amazon S3 bucket through CloudFront. The format of the value is:
          ``origin-access-identity/cloudfront/ID-of-origin-access-identity`` 
         The ``ID-of-origin-access-identity`` is the value that CloudFront returned in the ``ID`` element when you created the origin access identity.
         If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an empty ``OriginAccessIdentity`` element.
         To delete the origin access identity from an existing distribution, update the distribution configuration and include an empty ``OriginAccessIdentity`` element.
         To replace the origin access identity, update the distribution configuration and specify the new origin access identity.
         For more information about the origin access identity, see [Serving Private Content through CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
elif False:
    DistributionS3OriginConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionS3OriginConfigArgs:
    def __init__(__self__, *,
                 origin_access_identity: Optional[pulumi.Input[builtins.str]] = None):
        """
        A complex type that contains information about the Amazon S3 origin. If the origin is a custom origin or an S3 bucket that is configured as a website endpoint, use the ``CustomOriginConfig`` element instead.
        :param pulumi.Input[builtins.str] origin_access_identity: If you're using origin access control (OAC) instead of origin access identity, specify an empty ``OriginAccessIdentity`` element. For more information, see [Restricting access to an](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html) in the *Amazon CloudFront Developer Guide*.
                 The CloudFront origin access identity to associate with the origin. Use an origin access identity to configure the origin so that viewers can *only* access objects in an Amazon S3 bucket through CloudFront. The format of the value is:
                 ``origin-access-identity/cloudfront/ID-of-origin-access-identity`` 
                The ``ID-of-origin-access-identity`` is the value that CloudFront returned in the ``ID`` element when you created the origin access identity.
                If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an empty ``OriginAccessIdentity`` element.
                To delete the origin access identity from an existing distribution, update the distribution configuration and include an empty ``OriginAccessIdentity`` element.
                To replace the origin access identity, update the distribution configuration and specify the new origin access identity.
                For more information about the origin access identity, see [Serving Private Content through CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        if origin_access_identity is not None:
            pulumi.set(__self__, "origin_access_identity", origin_access_identity)

    @property
    @pulumi.getter(name="originAccessIdentity")
    def origin_access_identity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If you're using origin access control (OAC) instead of origin access identity, specify an empty ``OriginAccessIdentity`` element. For more information, see [Restricting access to an](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html) in the *Amazon CloudFront Developer Guide*.
          The CloudFront origin access identity to associate with the origin. Use an origin access identity to configure the origin so that viewers can *only* access objects in an Amazon S3 bucket through CloudFront. The format of the value is:
          ``origin-access-identity/cloudfront/ID-of-origin-access-identity`` 
         The ``ID-of-origin-access-identity`` is the value that CloudFront returned in the ``ID`` element when you created the origin access identity.
         If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an empty ``OriginAccessIdentity`` element.
         To delete the origin access identity from an existing distribution, update the distribution configuration and include an empty ``OriginAccessIdentity`` element.
         To replace the origin access identity, update the distribution configuration and specify the new origin access identity.
         For more information about the origin access identity, see [Serving Private Content through CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_access_identity")

    @origin_access_identity.setter
    def origin_access_identity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "origin_access_identity", value)


if not MYPY:
    class DistributionStatusCodesArgsDict(TypedDict):
        """
        A complex data type for the status codes that you specify that, when returned by a primary origin, trigger CloudFront to failover to a second origin.
        """
        items: pulumi.Input[Sequence[pulumi.Input[builtins.int]]]
        """
        The items (status codes) for an origin group.
        """
        quantity: pulumi.Input[builtins.int]
        """
        The number of status codes.
        """
elif False:
    DistributionStatusCodesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionStatusCodesArgs:
    def __init__(__self__, *,
                 items: pulumi.Input[Sequence[pulumi.Input[builtins.int]]],
                 quantity: pulumi.Input[builtins.int]):
        """
        A complex data type for the status codes that you specify that, when returned by a primary origin, trigger CloudFront to failover to a second origin.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] items: The items (status codes) for an origin group.
        :param pulumi.Input[builtins.int] quantity: The number of status codes.
        """
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def items(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.int]]]:
        """
        The items (status codes) for an origin group.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.int]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def quantity(self) -> pulumi.Input[builtins.int]:
        """
        The number of status codes.
        """
        return pulumi.get(self, "quantity")

    @quantity.setter
    def quantity(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "quantity", value)


if not MYPY:
    class DistributionTenantCertificateArgsDict(TypedDict):
        """
        The ACMlong (ACM) certificate associated with your distribution.
        """
        arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the ACM certificate.
        """
elif False:
    DistributionTenantCertificateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionTenantCertificateArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        The ACMlong (ACM) certificate associated with your distribution.
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) of the ACM certificate.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the ACM certificate.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)


if not MYPY:
    class DistributionTenantCustomizationsArgsDict(TypedDict):
        """
        Customizations for the distribution tenant. For each distribution tenant, you can specify the geographic restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and WAF web ACL. These are specific values that you can override or disable from the multi-tenant distribution that was used to create the distribution tenant.
        """
        certificate: NotRequired[pulumi.Input['DistributionTenantCertificateArgsDict']]
        """
        The ACMlong (ACM) certificate.
        """
        geo_restrictions: NotRequired[pulumi.Input['DistributionTenantGeoRestrictionCustomizationArgsDict']]
        """
        The geographic restrictions.
        """
        web_acl: NotRequired[pulumi.Input['DistributionTenantWebAclCustomizationArgsDict']]
        """
        The WAF web ACL.
        """
elif False:
    DistributionTenantCustomizationsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionTenantCustomizationsArgs:
    def __init__(__self__, *,
                 certificate: Optional[pulumi.Input['DistributionTenantCertificateArgs']] = None,
                 geo_restrictions: Optional[pulumi.Input['DistributionTenantGeoRestrictionCustomizationArgs']] = None,
                 web_acl: Optional[pulumi.Input['DistributionTenantWebAclCustomizationArgs']] = None):
        """
        Customizations for the distribution tenant. For each distribution tenant, you can specify the geographic restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and WAF web ACL. These are specific values that you can override or disable from the multi-tenant distribution that was used to create the distribution tenant.
        :param pulumi.Input['DistributionTenantCertificateArgs'] certificate: The ACMlong (ACM) certificate.
        :param pulumi.Input['DistributionTenantGeoRestrictionCustomizationArgs'] geo_restrictions: The geographic restrictions.
        :param pulumi.Input['DistributionTenantWebAclCustomizationArgs'] web_acl: The WAF web ACL.
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if geo_restrictions is not None:
            pulumi.set(__self__, "geo_restrictions", geo_restrictions)
        if web_acl is not None:
            pulumi.set(__self__, "web_acl", web_acl)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input['DistributionTenantCertificateArgs']]:
        """
        The ACMlong (ACM) certificate.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input['DistributionTenantCertificateArgs']]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="geoRestrictions")
    def geo_restrictions(self) -> Optional[pulumi.Input['DistributionTenantGeoRestrictionCustomizationArgs']]:
        """
        The geographic restrictions.
        """
        return pulumi.get(self, "geo_restrictions")

    @geo_restrictions.setter
    def geo_restrictions(self, value: Optional[pulumi.Input['DistributionTenantGeoRestrictionCustomizationArgs']]):
        pulumi.set(self, "geo_restrictions", value)

    @property
    @pulumi.getter(name="webAcl")
    def web_acl(self) -> Optional[pulumi.Input['DistributionTenantWebAclCustomizationArgs']]:
        """
        The WAF web ACL.
        """
        return pulumi.get(self, "web_acl")

    @web_acl.setter
    def web_acl(self, value: Optional[pulumi.Input['DistributionTenantWebAclCustomizationArgs']]):
        pulumi.set(self, "web_acl", value)


if not MYPY:
    class DistributionTenantGeoRestrictionCustomizationArgsDict(TypedDict):
        """
        The customizations that you specified for the distribution tenant for geographic restrictions.
        """
        locations: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The locations for geographic restrictions.
        """
        restriction_type: NotRequired[pulumi.Input['DistributionTenantGeoRestrictionCustomizationRestrictionType']]
        """
        The method that you want to use to restrict distribution of your content by country:
          +  ``none``: No geographic restriction is enabled, meaning access to content is not restricted by client geo location.
          +  ``blacklist``: The ``Location`` elements specify the countries in which you don't want CloudFront to distribute your content.
          +  ``whitelist``: The ``Location`` elements specify the countries in which you want CloudFront to distribute your content.
        """
elif False:
    DistributionTenantGeoRestrictionCustomizationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionTenantGeoRestrictionCustomizationArgs:
    def __init__(__self__, *,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 restriction_type: Optional[pulumi.Input['DistributionTenantGeoRestrictionCustomizationRestrictionType']] = None):
        """
        The customizations that you specified for the distribution tenant for geographic restrictions.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] locations: The locations for geographic restrictions.
        :param pulumi.Input['DistributionTenantGeoRestrictionCustomizationRestrictionType'] restriction_type: The method that you want to use to restrict distribution of your content by country:
                 +  ``none``: No geographic restriction is enabled, meaning access to content is not restricted by client geo location.
                 +  ``blacklist``: The ``Location`` elements specify the countries in which you don't want CloudFront to distribute your content.
                 +  ``whitelist``: The ``Location`` elements specify the countries in which you want CloudFront to distribute your content.
        """
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if restriction_type is not None:
            pulumi.set(__self__, "restriction_type", restriction_type)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The locations for geographic restrictions.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter(name="restrictionType")
    def restriction_type(self) -> Optional[pulumi.Input['DistributionTenantGeoRestrictionCustomizationRestrictionType']]:
        """
        The method that you want to use to restrict distribution of your content by country:
          +  ``none``: No geographic restriction is enabled, meaning access to content is not restricted by client geo location.
          +  ``blacklist``: The ``Location`` elements specify the countries in which you don't want CloudFront to distribute your content.
          +  ``whitelist``: The ``Location`` elements specify the countries in which you want CloudFront to distribute your content.
        """
        return pulumi.get(self, "restriction_type")

    @restriction_type.setter
    def restriction_type(self, value: Optional[pulumi.Input['DistributionTenantGeoRestrictionCustomizationRestrictionType']]):
        pulumi.set(self, "restriction_type", value)


if not MYPY:
    class DistributionTenantManagedCertificateRequestArgsDict(TypedDict):
        """
        An object that represents the request for the Amazon CloudFront managed ACM certificate.
        """
        certificate_transparency_logging_preference: NotRequired[pulumi.Input['DistributionTenantManagedCertificateRequestCertificateTransparencyLoggingPreference']]
        """
        You can opt out of certificate transparency logging by specifying the ``disabled`` option. Opt in by specifying ``enabled``. For more information, see [Certificate Transparency Logging](https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency) in the *User Guide*.
        """
        primary_domain_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The primary domain name associated with the CloudFront managed ACM certificate.
        """
        validation_token_host: NotRequired[pulumi.Input['DistributionTenantManagedCertificateRequestValidationTokenHost']]
        """
        Specify how the HTTP validation token will be served when requesting the CloudFront managed ACM certificate.
          +  For ``cloudfront``, CloudFront will automatically serve the validation token. Choose this mode if you can point the domain's DNS to CloudFront immediately.
          +  For ``self-hosted``, you serve the validation token from your existing infrastructure. Choose this mode when you need to maintain current traffic flow while your certificate is being issued. You can place the validation token at the well-known path on your existing web server, wait for ACM to validate and issue the certificate, and then update your DNS to point to CloudFront.
        """
elif False:
    DistributionTenantManagedCertificateRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionTenantManagedCertificateRequestArgs:
    def __init__(__self__, *,
                 certificate_transparency_logging_preference: Optional[pulumi.Input['DistributionTenantManagedCertificateRequestCertificateTransparencyLoggingPreference']] = None,
                 primary_domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 validation_token_host: Optional[pulumi.Input['DistributionTenantManagedCertificateRequestValidationTokenHost']] = None):
        """
        An object that represents the request for the Amazon CloudFront managed ACM certificate.
        :param pulumi.Input['DistributionTenantManagedCertificateRequestCertificateTransparencyLoggingPreference'] certificate_transparency_logging_preference: You can opt out of certificate transparency logging by specifying the ``disabled`` option. Opt in by specifying ``enabled``. For more information, see [Certificate Transparency Logging](https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency) in the *User Guide*.
        :param pulumi.Input[builtins.str] primary_domain_name: The primary domain name associated with the CloudFront managed ACM certificate.
        :param pulumi.Input['DistributionTenantManagedCertificateRequestValidationTokenHost'] validation_token_host: Specify how the HTTP validation token will be served when requesting the CloudFront managed ACM certificate.
                 +  For ``cloudfront``, CloudFront will automatically serve the validation token. Choose this mode if you can point the domain's DNS to CloudFront immediately.
                 +  For ``self-hosted``, you serve the validation token from your existing infrastructure. Choose this mode when you need to maintain current traffic flow while your certificate is being issued. You can place the validation token at the well-known path on your existing web server, wait for ACM to validate and issue the certificate, and then update your DNS to point to CloudFront.
        """
        if certificate_transparency_logging_preference is not None:
            pulumi.set(__self__, "certificate_transparency_logging_preference", certificate_transparency_logging_preference)
        if primary_domain_name is not None:
            pulumi.set(__self__, "primary_domain_name", primary_domain_name)
        if validation_token_host is not None:
            pulumi.set(__self__, "validation_token_host", validation_token_host)

    @property
    @pulumi.getter(name="certificateTransparencyLoggingPreference")
    def certificate_transparency_logging_preference(self) -> Optional[pulumi.Input['DistributionTenantManagedCertificateRequestCertificateTransparencyLoggingPreference']]:
        """
        You can opt out of certificate transparency logging by specifying the ``disabled`` option. Opt in by specifying ``enabled``. For more information, see [Certificate Transparency Logging](https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency) in the *User Guide*.
        """
        return pulumi.get(self, "certificate_transparency_logging_preference")

    @certificate_transparency_logging_preference.setter
    def certificate_transparency_logging_preference(self, value: Optional[pulumi.Input['DistributionTenantManagedCertificateRequestCertificateTransparencyLoggingPreference']]):
        pulumi.set(self, "certificate_transparency_logging_preference", value)

    @property
    @pulumi.getter(name="primaryDomainName")
    def primary_domain_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The primary domain name associated with the CloudFront managed ACM certificate.
        """
        return pulumi.get(self, "primary_domain_name")

    @primary_domain_name.setter
    def primary_domain_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_domain_name", value)

    @property
    @pulumi.getter(name="validationTokenHost")
    def validation_token_host(self) -> Optional[pulumi.Input['DistributionTenantManagedCertificateRequestValidationTokenHost']]:
        """
        Specify how the HTTP validation token will be served when requesting the CloudFront managed ACM certificate.
          +  For ``cloudfront``, CloudFront will automatically serve the validation token. Choose this mode if you can point the domain's DNS to CloudFront immediately.
          +  For ``self-hosted``, you serve the validation token from your existing infrastructure. Choose this mode when you need to maintain current traffic flow while your certificate is being issued. You can place the validation token at the well-known path on your existing web server, wait for ACM to validate and issue the certificate, and then update your DNS to point to CloudFront.
        """
        return pulumi.get(self, "validation_token_host")

    @validation_token_host.setter
    def validation_token_host(self, value: Optional[pulumi.Input['DistributionTenantManagedCertificateRequestValidationTokenHost']]):
        pulumi.set(self, "validation_token_host", value)


if not MYPY:
    class DistributionTenantParameterArgsDict(TypedDict):
        """
        A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The parameter name.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        The parameter value.
        """
elif False:
    DistributionTenantParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionTenantParameterArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
        :param pulumi.Input[builtins.str] name: The parameter name.
        :param pulumi.Input[builtins.str] value: The parameter value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The parameter value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class DistributionTenantWebAclCustomizationArgsDict(TypedDict):
        """
        The WAF web ACL customization specified for the distribution tenant.
        """
        action: NotRequired[pulumi.Input['DistributionTenantWebAclCustomizationAction']]
        """
        The action for the WAF web ACL customization. You can specify ``override`` to specify a separate WAF web ACL for the distribution tenant. If you specify ``disable``, the distribution tenant won't have WAF web ACL protections and won't inherit from the multi-tenant distribution.
        """
        arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the WAF web ACL.
        """
elif False:
    DistributionTenantWebAclCustomizationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionTenantWebAclCustomizationArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['DistributionTenantWebAclCustomizationAction']] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        The WAF web ACL customization specified for the distribution tenant.
        :param pulumi.Input['DistributionTenantWebAclCustomizationAction'] action: The action for the WAF web ACL customization. You can specify ``override`` to specify a separate WAF web ACL for the distribution tenant. If you specify ``disable``, the distribution tenant won't have WAF web ACL protections and won't inherit from the multi-tenant distribution.
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) of the WAF web ACL.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['DistributionTenantWebAclCustomizationAction']]:
        """
        The action for the WAF web ACL customization. You can specify ``override`` to specify a separate WAF web ACL for the distribution tenant. If you specify ``disable``, the distribution tenant won't have WAF web ACL protections and won't inherit from the multi-tenant distribution.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['DistributionTenantWebAclCustomizationAction']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the WAF web ACL.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)


if not MYPY:
    class DistributionViewerCertificateArgsDict(TypedDict):
        """
        A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
         If the distribution doesn't use ``Aliases`` (also known as alternate domain names or CNAMEs)—that is, if the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net``—set ``CloudFrontDefaultCertificate`` to ``true`` and leave all other fields empty.
         If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), use the fields in this type to specify the following settings:
          +  Which viewers the distribution accepts HTTPS connections from: only viewers that support [server name indication (SNI)](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Server_Name_Indication) (recommended), or all viewers including those that don't support SNI.
          +  To accept HTTPS connections from only viewers that support SNI, set ``SSLSupportMethod`` to ``sni-only``. This is recommended. Most browsers and clients support SNI. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
          +  To accept HTTPS connections from all viewers, including those that don't support SNI, set ``SSLSupportMethod`` to ``vip``. This is not recommended, and results in additional monthly charges from CloudFront. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
          
          +  The minimum SSL/TLS protocol version that the distribution can use to communicate with viewers. To specify a minimum version, choose a value for ``MinimumProtocolVersion``. For more information, see [Security Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy) in the *Amazon CloudFront Developer Guide*.
          +  The location of the SSL/TLS certificate, [(ACM)](https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html) (recommended) or [(IAM)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html). You specify the location by setting a value in one of the following fields (not both):
          +  ``ACMCertificateArn`` (In CloudFormation, this field name is ``AcmCertificateArn``. Note the different capitalization.)
          +  ``IAMCertificateId`` (In CloudFormation, this field name is ``IamCertificateId``. Note the different capitalization.)
          
          
         All distributions support HTTPS connections from viewers. To require viewers to use HTTPS only, or to redirect them from HTTP to HTTPS, use ``ViewerProtocolPolicy`` in the ``CacheBehavior`` or ``DefaultCacheBehavior``. To specify how CloudFront should use SSL/TLS to communicate with your custom origin, use ``CustomOriginConfig``.
         For more information, see [Using HTTPS with CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https.html) and [Using Alternate Domain Names and HTTPS](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-alternate-domain-names.html) in the *Amazon CloudFront Developer Guide*.
        """
        acm_certificate_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        In CloudFormation, this field name is ``AcmCertificateArn``. Note the different capitalization.
          If the distribution uses ``Aliases`` (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in [(ACM)](https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html), provide the Amazon Resource Name (ARN) of the ACM certificate. CloudFront only supports ACM certificates in the US East (N. Virginia) Region (``us-east-1``).
         If you specify an ACM certificate ARN, you must also specify values for ``MinimumProtocolVersion`` and ``SSLSupportMethod``. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
        """
        cloud_front_default_certificate: NotRequired[pulumi.Input[builtins.bool]]
        """
        If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net``, set this field to ``true``.
         If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), omit this field and specify values for the following fields:
          +  ``AcmCertificateArn`` or ``IamCertificateId`` (specify a value for one, not both) 
          +   ``MinimumProtocolVersion`` 
          +   ``SslSupportMethod``
        """
        iam_certificate_id: NotRequired[pulumi.Input[builtins.str]]
        """
        In CloudFormation, this field name is ``IamCertificateId``. Note the different capitalization.
          If the distribution uses ``Aliases`` (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in [(IAM)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html), provide the ID of the IAM certificate.
         If you specify an IAM certificate ID, you must also specify values for ``MinimumProtocolVersion`` and ``SSLSupportMethod``. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
        """
        minimum_protocol_version: NotRequired[pulumi.Input[builtins.str]]
        """
        If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), specify the security policy that you want CloudFront to use for HTTPS connections with viewers. The security policy determines two settings:
          +  The minimum SSL/TLS protocol that CloudFront can use to communicate with viewers.
          +  The ciphers that CloudFront can use to encrypt the content that it returns to viewers.
          
         For more information, see [Security Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy) and [Supported Protocols and Ciphers Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html#secure-connections-supported-ciphers) in the *Amazon CloudFront Developer Guide*.
          On the CloudFront console, this setting is called *Security Policy*.
          When you're using SNI only (you set ``SSLSupportMethod`` to ``sni-only``), you must specify ``TLSv1`` or higher. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
         If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net`` (you set ``CloudFrontDefaultCertificate`` to ``true``), CloudFront automatically sets the security policy to ``TLSv1`` regardless of the value that you set here.
        """
        ssl_support_method: NotRequired[pulumi.Input[builtins.str]]
        """
        In CloudFormation, this field name is ``SslSupportMethod``. Note the different capitalization.
          If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), specify which viewers the distribution accepts HTTPS connections from.
          +  ``sni-only`` – The distribution accepts HTTPS connections from only viewers that support [server name indication (SNI)](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Server_Name_Indication). This is recommended. Most browsers and clients support SNI.
          +  ``vip`` – The distribution accepts HTTPS connections from all viewers including those that don't support SNI. This is not recommended, and results in additional monthly charges from CloudFront.
          +  ``static-ip`` - Do not specify this value unless your distribution has been enabled for this feature by the CloudFront team. If you have a use case that requires static IP addresses for a distribution, contact CloudFront through the [Center](https://docs.aws.amazon.com/support/home).
          
         If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net``, don't set a value for this field.
        """
elif False:
    DistributionViewerCertificateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionViewerCertificateArgs:
    def __init__(__self__, *,
                 acm_certificate_arn: Optional[pulumi.Input[builtins.str]] = None,
                 cloud_front_default_certificate: Optional[pulumi.Input[builtins.bool]] = None,
                 iam_certificate_id: Optional[pulumi.Input[builtins.str]] = None,
                 minimum_protocol_version: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_support_method: Optional[pulumi.Input[builtins.str]] = None):
        """
        A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
         If the distribution doesn't use ``Aliases`` (also known as alternate domain names or CNAMEs)—that is, if the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net``—set ``CloudFrontDefaultCertificate`` to ``true`` and leave all other fields empty.
         If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), use the fields in this type to specify the following settings:
          +  Which viewers the distribution accepts HTTPS connections from: only viewers that support [server name indication (SNI)](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Server_Name_Indication) (recommended), or all viewers including those that don't support SNI.
          +  To accept HTTPS connections from only viewers that support SNI, set ``SSLSupportMethod`` to ``sni-only``. This is recommended. Most browsers and clients support SNI. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
          +  To accept HTTPS connections from all viewers, including those that don't support SNI, set ``SSLSupportMethod`` to ``vip``. This is not recommended, and results in additional monthly charges from CloudFront. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
          
          +  The minimum SSL/TLS protocol version that the distribution can use to communicate with viewers. To specify a minimum version, choose a value for ``MinimumProtocolVersion``. For more information, see [Security Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy) in the *Amazon CloudFront Developer Guide*.
          +  The location of the SSL/TLS certificate, [(ACM)](https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html) (recommended) or [(IAM)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html). You specify the location by setting a value in one of the following fields (not both):
          +  ``ACMCertificateArn`` (In CloudFormation, this field name is ``AcmCertificateArn``. Note the different capitalization.)
          +  ``IAMCertificateId`` (In CloudFormation, this field name is ``IamCertificateId``. Note the different capitalization.)
          
          
         All distributions support HTTPS connections from viewers. To require viewers to use HTTPS only, or to redirect them from HTTP to HTTPS, use ``ViewerProtocolPolicy`` in the ``CacheBehavior`` or ``DefaultCacheBehavior``. To specify how CloudFront should use SSL/TLS to communicate with your custom origin, use ``CustomOriginConfig``.
         For more information, see [Using HTTPS with CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https.html) and [Using Alternate Domain Names and HTTPS](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-alternate-domain-names.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.str] acm_certificate_arn: In CloudFormation, this field name is ``AcmCertificateArn``. Note the different capitalization.
                 If the distribution uses ``Aliases`` (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in [(ACM)](https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html), provide the Amazon Resource Name (ARN) of the ACM certificate. CloudFront only supports ACM certificates in the US East (N. Virginia) Region (``us-east-1``).
                If you specify an ACM certificate ARN, you must also specify values for ``MinimumProtocolVersion`` and ``SSLSupportMethod``. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
        :param pulumi.Input[builtins.bool] cloud_front_default_certificate: If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net``, set this field to ``true``.
                If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), omit this field and specify values for the following fields:
                 +  ``AcmCertificateArn`` or ``IamCertificateId`` (specify a value for one, not both) 
                 +   ``MinimumProtocolVersion`` 
                 +   ``SslSupportMethod``
        :param pulumi.Input[builtins.str] iam_certificate_id: In CloudFormation, this field name is ``IamCertificateId``. Note the different capitalization.
                 If the distribution uses ``Aliases`` (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in [(IAM)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html), provide the ID of the IAM certificate.
                If you specify an IAM certificate ID, you must also specify values for ``MinimumProtocolVersion`` and ``SSLSupportMethod``. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
        :param pulumi.Input[builtins.str] minimum_protocol_version: If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), specify the security policy that you want CloudFront to use for HTTPS connections with viewers. The security policy determines two settings:
                 +  The minimum SSL/TLS protocol that CloudFront can use to communicate with viewers.
                 +  The ciphers that CloudFront can use to encrypt the content that it returns to viewers.
                 
                For more information, see [Security Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy) and [Supported Protocols and Ciphers Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html#secure-connections-supported-ciphers) in the *Amazon CloudFront Developer Guide*.
                 On the CloudFront console, this setting is called *Security Policy*.
                 When you're using SNI only (you set ``SSLSupportMethod`` to ``sni-only``), you must specify ``TLSv1`` or higher. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
                If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net`` (you set ``CloudFrontDefaultCertificate`` to ``true``), CloudFront automatically sets the security policy to ``TLSv1`` regardless of the value that you set here.
        :param pulumi.Input[builtins.str] ssl_support_method: In CloudFormation, this field name is ``SslSupportMethod``. Note the different capitalization.
                 If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), specify which viewers the distribution accepts HTTPS connections from.
                 +  ``sni-only`` – The distribution accepts HTTPS connections from only viewers that support [server name indication (SNI)](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Server_Name_Indication). This is recommended. Most browsers and clients support SNI.
                 +  ``vip`` – The distribution accepts HTTPS connections from all viewers including those that don't support SNI. This is not recommended, and results in additional monthly charges from CloudFront.
                 +  ``static-ip`` - Do not specify this value unless your distribution has been enabled for this feature by the CloudFront team. If you have a use case that requires static IP addresses for a distribution, contact CloudFront through the [Center](https://docs.aws.amazon.com/support/home).
                 
                If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net``, don't set a value for this field.
        """
        if acm_certificate_arn is not None:
            pulumi.set(__self__, "acm_certificate_arn", acm_certificate_arn)
        if cloud_front_default_certificate is not None:
            pulumi.set(__self__, "cloud_front_default_certificate", cloud_front_default_certificate)
        if iam_certificate_id is not None:
            pulumi.set(__self__, "iam_certificate_id", iam_certificate_id)
        if minimum_protocol_version is not None:
            pulumi.set(__self__, "minimum_protocol_version", minimum_protocol_version)
        if ssl_support_method is not None:
            pulumi.set(__self__, "ssl_support_method", ssl_support_method)

    @property
    @pulumi.getter(name="acmCertificateArn")
    def acm_certificate_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        In CloudFormation, this field name is ``AcmCertificateArn``. Note the different capitalization.
          If the distribution uses ``Aliases`` (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in [(ACM)](https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html), provide the Amazon Resource Name (ARN) of the ACM certificate. CloudFront only supports ACM certificates in the US East (N. Virginia) Region (``us-east-1``).
         If you specify an ACM certificate ARN, you must also specify values for ``MinimumProtocolVersion`` and ``SSLSupportMethod``. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
        """
        return pulumi.get(self, "acm_certificate_arn")

    @acm_certificate_arn.setter
    def acm_certificate_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acm_certificate_arn", value)

    @property
    @pulumi.getter(name="cloudFrontDefaultCertificate")
    def cloud_front_default_certificate(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net``, set this field to ``true``.
         If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), omit this field and specify values for the following fields:
          +  ``AcmCertificateArn`` or ``IamCertificateId`` (specify a value for one, not both) 
          +   ``MinimumProtocolVersion`` 
          +   ``SslSupportMethod``
        """
        return pulumi.get(self, "cloud_front_default_certificate")

    @cloud_front_default_certificate.setter
    def cloud_front_default_certificate(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cloud_front_default_certificate", value)

    @property
    @pulumi.getter(name="iamCertificateId")
    def iam_certificate_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        In CloudFormation, this field name is ``IamCertificateId``. Note the different capitalization.
          If the distribution uses ``Aliases`` (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in [(IAM)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html), provide the ID of the IAM certificate.
         If you specify an IAM certificate ID, you must also specify values for ``MinimumProtocolVersion`` and ``SSLSupportMethod``. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
        """
        return pulumi.get(self, "iam_certificate_id")

    @iam_certificate_id.setter
    def iam_certificate_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_certificate_id", value)

    @property
    @pulumi.getter(name="minimumProtocolVersion")
    def minimum_protocol_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), specify the security policy that you want CloudFront to use for HTTPS connections with viewers. The security policy determines two settings:
          +  The minimum SSL/TLS protocol that CloudFront can use to communicate with viewers.
          +  The ciphers that CloudFront can use to encrypt the content that it returns to viewers.
          
         For more information, see [Security Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy) and [Supported Protocols and Ciphers Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html#secure-connections-supported-ciphers) in the *Amazon CloudFront Developer Guide*.
          On the CloudFront console, this setting is called *Security Policy*.
          When you're using SNI only (you set ``SSLSupportMethod`` to ``sni-only``), you must specify ``TLSv1`` or higher. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
         If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net`` (you set ``CloudFrontDefaultCertificate`` to ``true``), CloudFront automatically sets the security policy to ``TLSv1`` regardless of the value that you set here.
        """
        return pulumi.get(self, "minimum_protocol_version")

    @minimum_protocol_version.setter
    def minimum_protocol_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "minimum_protocol_version", value)

    @property
    @pulumi.getter(name="sslSupportMethod")
    def ssl_support_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        In CloudFormation, this field name is ``SslSupportMethod``. Note the different capitalization.
          If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), specify which viewers the distribution accepts HTTPS connections from.
          +  ``sni-only`` – The distribution accepts HTTPS connections from only viewers that support [server name indication (SNI)](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Server_Name_Indication). This is recommended. Most browsers and clients support SNI.
          +  ``vip`` – The distribution accepts HTTPS connections from all viewers including those that don't support SNI. This is not recommended, and results in additional monthly charges from CloudFront.
          +  ``static-ip`` - Do not specify this value unless your distribution has been enabled for this feature by the CloudFront team. If you have a use case that requires static IP addresses for a distribution, contact CloudFront through the [Center](https://docs.aws.amazon.com/support/home).
          
         If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net``, don't set a value for this field.
        """
        return pulumi.get(self, "ssl_support_method")

    @ssl_support_method.setter
    def ssl_support_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_support_method", value)


if not MYPY:
    class DistributionVpcOriginConfigArgsDict(TypedDict):
        """
        An Amazon CloudFront VPC origin configuration.
        """
        vpc_origin_id: pulumi.Input[builtins.str]
        """
        The VPC origin ID.
        """
        origin_keepalive_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 5 seconds.
         For more information, see [Keep-alive timeout (custom origins only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout) in the *Amazon CloudFront Developer Guide*.
        """
        origin_read_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as the *origin response timeout*. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 30 seconds.
         For more information, see [Response timeout (custom origins only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout) in the *Amazon CloudFront Developer Guide*.
        """
elif False:
    DistributionVpcOriginConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DistributionVpcOriginConfigArgs:
    def __init__(__self__, *,
                 vpc_origin_id: pulumi.Input[builtins.str],
                 origin_keepalive_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 origin_read_timeout: Optional[pulumi.Input[builtins.int]] = None):
        """
        An Amazon CloudFront VPC origin configuration.
        :param pulumi.Input[builtins.str] vpc_origin_id: The VPC origin ID.
        :param pulumi.Input[builtins.int] origin_keepalive_timeout: Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 5 seconds.
                For more information, see [Keep-alive timeout (custom origins only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.int] origin_read_timeout: Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as the *origin response timeout*. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 30 seconds.
                For more information, see [Response timeout (custom origins only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout) in the *Amazon CloudFront Developer Guide*.
        """
        pulumi.set(__self__, "vpc_origin_id", vpc_origin_id)
        if origin_keepalive_timeout is not None:
            pulumi.set(__self__, "origin_keepalive_timeout", origin_keepalive_timeout)
        if origin_read_timeout is not None:
            pulumi.set(__self__, "origin_read_timeout", origin_read_timeout)

    @property
    @pulumi.getter(name="vpcOriginId")
    def vpc_origin_id(self) -> pulumi.Input[builtins.str]:
        """
        The VPC origin ID.
        """
        return pulumi.get(self, "vpc_origin_id")

    @vpc_origin_id.setter
    def vpc_origin_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vpc_origin_id", value)

    @property
    @pulumi.getter(name="originKeepaliveTimeout")
    def origin_keepalive_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 5 seconds.
         For more information, see [Keep-alive timeout (custom origins only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_keepalive_timeout")

    @origin_keepalive_timeout.setter
    def origin_keepalive_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "origin_keepalive_timeout", value)

    @property
    @pulumi.getter(name="originReadTimeout")
    def origin_read_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as the *origin response timeout*. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 30 seconds.
         For more information, see [Response timeout (custom origins only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_read_timeout")

    @origin_read_timeout.setter
    def origin_read_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "origin_read_timeout", value)


if not MYPY:
    class FunctionConfigArgsDict(TypedDict):
        """
        Contains configuration information about a CloudFront function.
        """
        comment: pulumi.Input[builtins.str]
        """
        A comment to describe the function.
        """
        runtime: pulumi.Input[builtins.str]
        """
        The function's runtime environment version.
        """
        key_value_store_associations: NotRequired[pulumi.Input[Sequence[pulumi.Input['FunctionKeyValueStoreAssociationArgsDict']]]]
        """
        The configuration for the key value store associations.
        """
elif False:
    FunctionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FunctionConfigArgs:
    def __init__(__self__, *,
                 comment: pulumi.Input[builtins.str],
                 runtime: pulumi.Input[builtins.str],
                 key_value_store_associations: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionKeyValueStoreAssociationArgs']]]] = None):
        """
        Contains configuration information about a CloudFront function.
        :param pulumi.Input[builtins.str] comment: A comment to describe the function.
        :param pulumi.Input[builtins.str] runtime: The function's runtime environment version.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionKeyValueStoreAssociationArgs']]] key_value_store_associations: The configuration for the key value store associations.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "runtime", runtime)
        if key_value_store_associations is not None:
            pulumi.set(__self__, "key_value_store_associations", key_value_store_associations)

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Input[builtins.str]:
        """
        A comment to describe the function.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Input[builtins.str]:
        """
        The function's runtime environment version.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="keyValueStoreAssociations")
    def key_value_store_associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionKeyValueStoreAssociationArgs']]]]:
        """
        The configuration for the key value store associations.
        """
        return pulumi.get(self, "key_value_store_associations")

    @key_value_store_associations.setter
    def key_value_store_associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionKeyValueStoreAssociationArgs']]]]):
        pulumi.set(self, "key_value_store_associations", value)


if not MYPY:
    class FunctionKeyValueStoreAssociationArgsDict(TypedDict):
        """
        The key value store association.
        """
        key_value_store_arn: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of the key value store association.
        """
elif False:
    FunctionKeyValueStoreAssociationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FunctionKeyValueStoreAssociationArgs:
    def __init__(__self__, *,
                 key_value_store_arn: pulumi.Input[builtins.str]):
        """
        The key value store association.
        :param pulumi.Input[builtins.str] key_value_store_arn: The Amazon Resource Name (ARN) of the key value store association.
        """
        pulumi.set(__self__, "key_value_store_arn", key_value_store_arn)

    @property
    @pulumi.getter(name="keyValueStoreArn")
    def key_value_store_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the key value store association.
        """
        return pulumi.get(self, "key_value_store_arn")

    @key_value_store_arn.setter
    def key_value_store_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key_value_store_arn", value)


if not MYPY:
    class FunctionMetadataArgsDict(TypedDict):
        """
        Contains metadata about a CloudFront function.
        """
        function_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the function. The ARN uniquely identifies the function.
        """
elif False:
    FunctionMetadataArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FunctionMetadataArgs:
    def __init__(__self__, *,
                 function_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        Contains metadata about a CloudFront function.
        :param pulumi.Input[builtins.str] function_arn: The Amazon Resource Name (ARN) of the function. The ARN uniquely identifies the function.
        """
        if function_arn is not None:
            pulumi.set(__self__, "function_arn", function_arn)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the function. The ARN uniquely identifies the function.
        """
        return pulumi.get(self, "function_arn")

    @function_arn.setter
    def function_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "function_arn", value)


if not MYPY:
    class KeyGroupConfigArgsDict(TypedDict):
        """
        A key group configuration.
         A key group contains a list of public keys that you can use with [CloudFront signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html).
        """
        items: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        A list of the identifiers of the public keys in the key group.
        """
        name: pulumi.Input[builtins.str]
        """
        A name to identify the key group.
        """
        comment: NotRequired[pulumi.Input[builtins.str]]
        """
        A comment to describe the key group. The comment cannot be longer than 128 characters.
        """
elif False:
    KeyGroupConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KeyGroupConfigArgs:
    def __init__(__self__, *,
                 items: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 name: pulumi.Input[builtins.str],
                 comment: Optional[pulumi.Input[builtins.str]] = None):
        """
        A key group configuration.
         A key group contains a list of public keys that you can use with [CloudFront signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] items: A list of the identifiers of the public keys in the key group.
        :param pulumi.Input[builtins.str] name: A name to identify the key group.
        :param pulumi.Input[builtins.str] comment: A comment to describe the key group. The comment cannot be longer than 128 characters.
        """
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter
    def items(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of the identifiers of the public keys in the key group.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        A name to identify the key group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A comment to describe the key group. The comment cannot be longer than 128 characters.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment", value)


if not MYPY:
    class KeyValueStoreImportSourceArgsDict(TypedDict):
        """
        The import source for the key value store.
        """
        source_arn: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of the import source for the key value store.
        """
        source_type: pulumi.Input[builtins.str]
        """
        The source type of the import source for the key value store.
        """
elif False:
    KeyValueStoreImportSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KeyValueStoreImportSourceArgs:
    def __init__(__self__, *,
                 source_arn: pulumi.Input[builtins.str],
                 source_type: pulumi.Input[builtins.str]):
        """
        The import source for the key value store.
        :param pulumi.Input[builtins.str] source_arn: The Amazon Resource Name (ARN) of the import source for the key value store.
        :param pulumi.Input[builtins.str] source_type: The source type of the import source for the key value store.
        """
        pulumi.set(__self__, "source_arn", source_arn)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the import source for the key value store.
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_arn", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[builtins.str]:
        """
        The source type of the import source for the key value store.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_type", value)


if not MYPY:
    class MonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgsDict(TypedDict):
        """
        A subscription configuration for additional CloudWatch metrics.
        """
        realtime_metrics_subscription_status: pulumi.Input['MonitoringSubscriptionRealtimeMetricsSubscriptionConfigRealtimeMetricsSubscriptionStatus']
        """
        A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
        """
elif False:
    MonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs:
    def __init__(__self__, *,
                 realtime_metrics_subscription_status: pulumi.Input['MonitoringSubscriptionRealtimeMetricsSubscriptionConfigRealtimeMetricsSubscriptionStatus']):
        """
        A subscription configuration for additional CloudWatch metrics.
        :param pulumi.Input['MonitoringSubscriptionRealtimeMetricsSubscriptionConfigRealtimeMetricsSubscriptionStatus'] realtime_metrics_subscription_status: A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
        """
        pulumi.set(__self__, "realtime_metrics_subscription_status", realtime_metrics_subscription_status)

    @property
    @pulumi.getter(name="realtimeMetricsSubscriptionStatus")
    def realtime_metrics_subscription_status(self) -> pulumi.Input['MonitoringSubscriptionRealtimeMetricsSubscriptionConfigRealtimeMetricsSubscriptionStatus']:
        """
        A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
        """
        return pulumi.get(self, "realtime_metrics_subscription_status")

    @realtime_metrics_subscription_status.setter
    def realtime_metrics_subscription_status(self, value: pulumi.Input['MonitoringSubscriptionRealtimeMetricsSubscriptionConfigRealtimeMetricsSubscriptionStatus']):
        pulumi.set(self, "realtime_metrics_subscription_status", value)


if not MYPY:
    class MonitoringSubscriptionArgsDict(TypedDict):
        """
        A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
        """
        realtime_metrics_subscription_config: NotRequired[pulumi.Input['MonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgsDict']]
        """
        A subscription configuration for additional CloudWatch metrics.
        """
elif False:
    MonitoringSubscriptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MonitoringSubscriptionArgs:
    def __init__(__self__, *,
                 realtime_metrics_subscription_config: Optional[pulumi.Input['MonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs']] = None):
        """
        A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
        :param pulumi.Input['MonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs'] realtime_metrics_subscription_config: A subscription configuration for additional CloudWatch metrics.
        """
        if realtime_metrics_subscription_config is not None:
            pulumi.set(__self__, "realtime_metrics_subscription_config", realtime_metrics_subscription_config)

    @property
    @pulumi.getter(name="realtimeMetricsSubscriptionConfig")
    def realtime_metrics_subscription_config(self) -> Optional[pulumi.Input['MonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs']]:
        """
        A subscription configuration for additional CloudWatch metrics.
        """
        return pulumi.get(self, "realtime_metrics_subscription_config")

    @realtime_metrics_subscription_config.setter
    def realtime_metrics_subscription_config(self, value: Optional[pulumi.Input['MonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs']]):
        pulumi.set(self, "realtime_metrics_subscription_config", value)


if not MYPY:
    class OriginAccessControlConfigArgsDict(TypedDict):
        """
        Creates a new origin access control in CloudFront. After you create an origin access control, you can add it to an origin in a CloudFront distribution so that CloudFront sends authenticated (signed) requests to the origin.
         This makes it possible to block public access to the origin, allowing viewers (users) to access the origin's content only through CloudFront.
         For more information about using a CloudFront origin access control, see [Restricting access to an origin](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html) in the *Amazon CloudFront Developer Guide*.
        """
        name: pulumi.Input[builtins.str]
        """
        A name to identify the origin access control. You can specify up to 64 characters.
        """
        origin_access_control_origin_type: pulumi.Input[builtins.str]
        """
        The type of origin that this origin access control is for.
        """
        signing_behavior: pulumi.Input[builtins.str]
        """
        Specifies which requests CloudFront signs (adds authentication information to). Specify ``always`` for the most common use case. For more information, see [origin access control advanced settings](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html#oac-advanced-settings) in the *Amazon CloudFront Developer Guide*.
         This field can have one of the following values:
          +  ``always`` – CloudFront signs all origin requests, overwriting the ``Authorization`` header from the viewer request if one exists.
          +  ``never`` – CloudFront doesn't sign any origin requests. This value turns off origin access control for all origins in all distributions that use this origin access control.
          +  ``no-override`` – If the viewer request doesn't contain the ``Authorization`` header, then CloudFront signs the origin request. If the viewer request contains the ``Authorization`` header, then CloudFront doesn't sign the origin request and instead passes along the ``Authorization`` header from the viewer request. *WARNING: To pass along the Authorization header from the viewer request, you must add the Authorization header to a cache policy for all cache behaviors that use origins associated with this origin access control.*
        """
        signing_protocol: pulumi.Input[builtins.str]
        """
        The signing protocol of the origin access control, which determines how CloudFront signs (authenticates) requests. The only valid value is ``sigv4``.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
        """
        A description of the origin access control.
        """
elif False:
    OriginAccessControlConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OriginAccessControlConfigArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 origin_access_control_origin_type: pulumi.Input[builtins.str],
                 signing_behavior: pulumi.Input[builtins.str],
                 signing_protocol: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        Creates a new origin access control in CloudFront. After you create an origin access control, you can add it to an origin in a CloudFront distribution so that CloudFront sends authenticated (signed) requests to the origin.
         This makes it possible to block public access to the origin, allowing viewers (users) to access the origin's content only through CloudFront.
         For more information about using a CloudFront origin access control, see [Restricting access to an origin](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.str] name: A name to identify the origin access control. You can specify up to 64 characters.
        :param pulumi.Input[builtins.str] origin_access_control_origin_type: The type of origin that this origin access control is for.
        :param pulumi.Input[builtins.str] signing_behavior: Specifies which requests CloudFront signs (adds authentication information to). Specify ``always`` for the most common use case. For more information, see [origin access control advanced settings](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html#oac-advanced-settings) in the *Amazon CloudFront Developer Guide*.
                This field can have one of the following values:
                 +  ``always`` – CloudFront signs all origin requests, overwriting the ``Authorization`` header from the viewer request if one exists.
                 +  ``never`` – CloudFront doesn't sign any origin requests. This value turns off origin access control for all origins in all distributions that use this origin access control.
                 +  ``no-override`` – If the viewer request doesn't contain the ``Authorization`` header, then CloudFront signs the origin request. If the viewer request contains the ``Authorization`` header, then CloudFront doesn't sign the origin request and instead passes along the ``Authorization`` header from the viewer request. *WARNING: To pass along the Authorization header from the viewer request, you must add the Authorization header to a cache policy for all cache behaviors that use origins associated with this origin access control.*
        :param pulumi.Input[builtins.str] signing_protocol: The signing protocol of the origin access control, which determines how CloudFront signs (authenticates) requests. The only valid value is ``sigv4``.
        :param pulumi.Input[builtins.str] description: A description of the origin access control.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "origin_access_control_origin_type", origin_access_control_origin_type)
        pulumi.set(__self__, "signing_behavior", signing_behavior)
        pulumi.set(__self__, "signing_protocol", signing_protocol)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        A name to identify the origin access control. You can specify up to 64 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="originAccessControlOriginType")
    def origin_access_control_origin_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of origin that this origin access control is for.
        """
        return pulumi.get(self, "origin_access_control_origin_type")

    @origin_access_control_origin_type.setter
    def origin_access_control_origin_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "origin_access_control_origin_type", value)

    @property
    @pulumi.getter(name="signingBehavior")
    def signing_behavior(self) -> pulumi.Input[builtins.str]:
        """
        Specifies which requests CloudFront signs (adds authentication information to). Specify ``always`` for the most common use case. For more information, see [origin access control advanced settings](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html#oac-advanced-settings) in the *Amazon CloudFront Developer Guide*.
         This field can have one of the following values:
          +  ``always`` – CloudFront signs all origin requests, overwriting the ``Authorization`` header from the viewer request if one exists.
          +  ``never`` – CloudFront doesn't sign any origin requests. This value turns off origin access control for all origins in all distributions that use this origin access control.
          +  ``no-override`` – If the viewer request doesn't contain the ``Authorization`` header, then CloudFront signs the origin request. If the viewer request contains the ``Authorization`` header, then CloudFront doesn't sign the origin request and instead passes along the ``Authorization`` header from the viewer request. *WARNING: To pass along the Authorization header from the viewer request, you must add the Authorization header to a cache policy for all cache behaviors that use origins associated with this origin access control.*
        """
        return pulumi.get(self, "signing_behavior")

    @signing_behavior.setter
    def signing_behavior(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "signing_behavior", value)

    @property
    @pulumi.getter(name="signingProtocol")
    def signing_protocol(self) -> pulumi.Input[builtins.str]:
        """
        The signing protocol of the origin access control, which determines how CloudFront signs (authenticates) requests. The only valid value is ``sigv4``.
        """
        return pulumi.get(self, "signing_protocol")

    @signing_protocol.setter
    def signing_protocol(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "signing_protocol", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the origin access control.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class OriginRequestPolicyConfigArgsDict(TypedDict):
        """
        An origin request policy configuration.
         This configuration determines the values that CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends to the origin includes the following:
          +  The request body and the URL path (without the domain name) from the viewer request.
          +  The headers that CloudFront automatically includes in every origin request, including ``Host``, ``User-Agent``, and ``X-Amz-Cf-Id``.
          +  All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request policy. These can include items from the viewer request and, in the case of headers, additional ones that are added by CloudFront.
          
         CloudFront sends a request when it can't find an object in its cache that matches the request. If you want to send values to the origin and also include them in the cache key, use ``CachePolicy``.
        """
        cookies_config: pulumi.Input['OriginRequestPolicyCookiesConfigArgsDict']
        """
        The cookies from viewer requests to include in origin requests.
        """
        headers_config: pulumi.Input['OriginRequestPolicyHeadersConfigArgsDict']
        """
        The HTTP headers to include in origin requests. These can include headers from viewer requests and additional headers added by CloudFront.
        """
        name: pulumi.Input[builtins.str]
        """
        A unique name to identify the origin request policy.
        """
        query_strings_config: pulumi.Input['OriginRequestPolicyQueryStringsConfigArgsDict']
        """
        The URL query strings from viewer requests to include in origin requests.
        """
        comment: NotRequired[pulumi.Input[builtins.str]]
        """
        A comment to describe the origin request policy. The comment cannot be longer than 128 characters.
        """
elif False:
    OriginRequestPolicyConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OriginRequestPolicyConfigArgs:
    def __init__(__self__, *,
                 cookies_config: pulumi.Input['OriginRequestPolicyCookiesConfigArgs'],
                 headers_config: pulumi.Input['OriginRequestPolicyHeadersConfigArgs'],
                 name: pulumi.Input[builtins.str],
                 query_strings_config: pulumi.Input['OriginRequestPolicyQueryStringsConfigArgs'],
                 comment: Optional[pulumi.Input[builtins.str]] = None):
        """
        An origin request policy configuration.
         This configuration determines the values that CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends to the origin includes the following:
          +  The request body and the URL path (without the domain name) from the viewer request.
          +  The headers that CloudFront automatically includes in every origin request, including ``Host``, ``User-Agent``, and ``X-Amz-Cf-Id``.
          +  All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request policy. These can include items from the viewer request and, in the case of headers, additional ones that are added by CloudFront.
          
         CloudFront sends a request when it can't find an object in its cache that matches the request. If you want to send values to the origin and also include them in the cache key, use ``CachePolicy``.
        :param pulumi.Input['OriginRequestPolicyCookiesConfigArgs'] cookies_config: The cookies from viewer requests to include in origin requests.
        :param pulumi.Input['OriginRequestPolicyHeadersConfigArgs'] headers_config: The HTTP headers to include in origin requests. These can include headers from viewer requests and additional headers added by CloudFront.
        :param pulumi.Input[builtins.str] name: A unique name to identify the origin request policy.
        :param pulumi.Input['OriginRequestPolicyQueryStringsConfigArgs'] query_strings_config: The URL query strings from viewer requests to include in origin requests.
        :param pulumi.Input[builtins.str] comment: A comment to describe the origin request policy. The comment cannot be longer than 128 characters.
        """
        pulumi.set(__self__, "cookies_config", cookies_config)
        pulumi.set(__self__, "headers_config", headers_config)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "query_strings_config", query_strings_config)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter(name="cookiesConfig")
    def cookies_config(self) -> pulumi.Input['OriginRequestPolicyCookiesConfigArgs']:
        """
        The cookies from viewer requests to include in origin requests.
        """
        return pulumi.get(self, "cookies_config")

    @cookies_config.setter
    def cookies_config(self, value: pulumi.Input['OriginRequestPolicyCookiesConfigArgs']):
        pulumi.set(self, "cookies_config", value)

    @property
    @pulumi.getter(name="headersConfig")
    def headers_config(self) -> pulumi.Input['OriginRequestPolicyHeadersConfigArgs']:
        """
        The HTTP headers to include in origin requests. These can include headers from viewer requests and additional headers added by CloudFront.
        """
        return pulumi.get(self, "headers_config")

    @headers_config.setter
    def headers_config(self, value: pulumi.Input['OriginRequestPolicyHeadersConfigArgs']):
        pulumi.set(self, "headers_config", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        A unique name to identify the origin request policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="queryStringsConfig")
    def query_strings_config(self) -> pulumi.Input['OriginRequestPolicyQueryStringsConfigArgs']:
        """
        The URL query strings from viewer requests to include in origin requests.
        """
        return pulumi.get(self, "query_strings_config")

    @query_strings_config.setter
    def query_strings_config(self, value: pulumi.Input['OriginRequestPolicyQueryStringsConfigArgs']):
        pulumi.set(self, "query_strings_config", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A comment to describe the origin request policy. The comment cannot be longer than 128 characters.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment", value)


if not MYPY:
    class OriginRequestPolicyCookiesConfigArgsDict(TypedDict):
        """
        An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in requests that CloudFront sends to the origin.
        """
        cookie_behavior: pulumi.Input[builtins.str]
        """
        Determines whether cookies in viewer requests are included in requests that CloudFront sends to the origin. Valid values are:
          +  ``none`` – No cookies in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any cookies that are listed in a ``CachePolicy``*are* included in origin requests.
          +  ``whitelist`` – Only the cookies in viewer requests that are listed in the ``CookieNames`` type are included in requests that CloudFront sends to the origin.
          +  ``all`` – All cookies in viewer requests are included in requests that CloudFront sends to the origin.
          +  ``allExcept`` – All cookies in viewer requests are included in requests that CloudFront sends to the origin, *except* for those listed in the ``CookieNames`` type, which are not included.
        """
        cookies: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Contains a list of cookie names.
        """
elif False:
    OriginRequestPolicyCookiesConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OriginRequestPolicyCookiesConfigArgs:
    def __init__(__self__, *,
                 cookie_behavior: pulumi.Input[builtins.str],
                 cookies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in requests that CloudFront sends to the origin.
        :param pulumi.Input[builtins.str] cookie_behavior: Determines whether cookies in viewer requests are included in requests that CloudFront sends to the origin. Valid values are:
                 +  ``none`` – No cookies in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any cookies that are listed in a ``CachePolicy``*are* included in origin requests.
                 +  ``whitelist`` – Only the cookies in viewer requests that are listed in the ``CookieNames`` type are included in requests that CloudFront sends to the origin.
                 +  ``all`` – All cookies in viewer requests are included in requests that CloudFront sends to the origin.
                 +  ``allExcept`` – All cookies in viewer requests are included in requests that CloudFront sends to the origin, *except* for those listed in the ``CookieNames`` type, which are not included.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cookies: Contains a list of cookie names.
        """
        pulumi.set(__self__, "cookie_behavior", cookie_behavior)
        if cookies is not None:
            pulumi.set(__self__, "cookies", cookies)

    @property
    @pulumi.getter(name="cookieBehavior")
    def cookie_behavior(self) -> pulumi.Input[builtins.str]:
        """
        Determines whether cookies in viewer requests are included in requests that CloudFront sends to the origin. Valid values are:
          +  ``none`` – No cookies in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any cookies that are listed in a ``CachePolicy``*are* included in origin requests.
          +  ``whitelist`` – Only the cookies in viewer requests that are listed in the ``CookieNames`` type are included in requests that CloudFront sends to the origin.
          +  ``all`` – All cookies in viewer requests are included in requests that CloudFront sends to the origin.
          +  ``allExcept`` – All cookies in viewer requests are included in requests that CloudFront sends to the origin, *except* for those listed in the ``CookieNames`` type, which are not included.
        """
        return pulumi.get(self, "cookie_behavior")

    @cookie_behavior.setter
    def cookie_behavior(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cookie_behavior", value)

    @property
    @pulumi.getter
    def cookies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Contains a list of cookie names.
        """
        return pulumi.get(self, "cookies")

    @cookies.setter
    def cookies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "cookies", value)


if not MYPY:
    class OriginRequestPolicyHeadersConfigArgsDict(TypedDict):
        """
        An object that determines whether any HTTP headers (and if so, which headers) are included in requests that CloudFront sends to the origin.
        """
        header_behavior: pulumi.Input[builtins.str]
        """
        Determines whether any HTTP headers are included in requests that CloudFront sends to the origin. Valid values are:
          +  ``none`` – No HTTP headers in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any headers that are listed in a ``CachePolicy``*are* included in origin requests.
          +  ``whitelist`` – Only the HTTP headers that are listed in the ``Headers`` type are included in requests that CloudFront sends to the origin.
          +  ``allViewer`` – All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin.
          +  ``allViewerAndWhitelistCloudFront`` – All HTTP headers in viewer requests and the additional CloudFront headers that are listed in the ``Headers`` type are included in requests that CloudFront sends to the origin. The additional headers are added by CloudFront.
          +  ``allExcept`` – All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin, *except* for those listed in the ``Headers`` type, which are not included.
        """
        headers: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Contains a list of HTTP header names.
        """
elif False:
    OriginRequestPolicyHeadersConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OriginRequestPolicyHeadersConfigArgs:
    def __init__(__self__, *,
                 header_behavior: pulumi.Input[builtins.str],
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        An object that determines whether any HTTP headers (and if so, which headers) are included in requests that CloudFront sends to the origin.
        :param pulumi.Input[builtins.str] header_behavior: Determines whether any HTTP headers are included in requests that CloudFront sends to the origin. Valid values are:
                 +  ``none`` – No HTTP headers in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any headers that are listed in a ``CachePolicy``*are* included in origin requests.
                 +  ``whitelist`` – Only the HTTP headers that are listed in the ``Headers`` type are included in requests that CloudFront sends to the origin.
                 +  ``allViewer`` – All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin.
                 +  ``allViewerAndWhitelistCloudFront`` – All HTTP headers in viewer requests and the additional CloudFront headers that are listed in the ``Headers`` type are included in requests that CloudFront sends to the origin. The additional headers are added by CloudFront.
                 +  ``allExcept`` – All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin, *except* for those listed in the ``Headers`` type, which are not included.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] headers: Contains a list of HTTP header names.
        """
        pulumi.set(__self__, "header_behavior", header_behavior)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)

    @property
    @pulumi.getter(name="headerBehavior")
    def header_behavior(self) -> pulumi.Input[builtins.str]:
        """
        Determines whether any HTTP headers are included in requests that CloudFront sends to the origin. Valid values are:
          +  ``none`` – No HTTP headers in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any headers that are listed in a ``CachePolicy``*are* included in origin requests.
          +  ``whitelist`` – Only the HTTP headers that are listed in the ``Headers`` type are included in requests that CloudFront sends to the origin.
          +  ``allViewer`` – All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin.
          +  ``allViewerAndWhitelistCloudFront`` – All HTTP headers in viewer requests and the additional CloudFront headers that are listed in the ``Headers`` type are included in requests that CloudFront sends to the origin. The additional headers are added by CloudFront.
          +  ``allExcept`` – All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin, *except* for those listed in the ``Headers`` type, which are not included.
        """
        return pulumi.get(self, "header_behavior")

    @header_behavior.setter
    def header_behavior(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "header_behavior", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Contains a list of HTTP header names.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "headers", value)


if not MYPY:
    class OriginRequestPolicyQueryStringsConfigArgsDict(TypedDict):
        """
        An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in requests that CloudFront sends to the origin.
        """
        query_string_behavior: pulumi.Input[builtins.str]
        """
        Determines whether any URL query strings in viewer requests are included in requests that CloudFront sends to the origin. Valid values are:
          +  ``none`` – No query strings in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any query strings that are listed in a ``CachePolicy``*are* included in origin requests.
          +  ``whitelist`` – Only the query strings in viewer requests that are listed in the ``QueryStringNames`` type are included in requests that CloudFront sends to the origin.
          +  ``all`` – All query strings in viewer requests are included in requests that CloudFront sends to the origin.
          +  ``allExcept`` – All query strings in viewer requests are included in requests that CloudFront sends to the origin, *except* for those listed in the ``QueryStringNames`` type, which are not included.
        """
        query_strings: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Contains a list of query string names.
        """
elif False:
    OriginRequestPolicyQueryStringsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OriginRequestPolicyQueryStringsConfigArgs:
    def __init__(__self__, *,
                 query_string_behavior: pulumi.Input[builtins.str],
                 query_strings: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in requests that CloudFront sends to the origin.
        :param pulumi.Input[builtins.str] query_string_behavior: Determines whether any URL query strings in viewer requests are included in requests that CloudFront sends to the origin. Valid values are:
                 +  ``none`` – No query strings in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any query strings that are listed in a ``CachePolicy``*are* included in origin requests.
                 +  ``whitelist`` – Only the query strings in viewer requests that are listed in the ``QueryStringNames`` type are included in requests that CloudFront sends to the origin.
                 +  ``all`` – All query strings in viewer requests are included in requests that CloudFront sends to the origin.
                 +  ``allExcept`` – All query strings in viewer requests are included in requests that CloudFront sends to the origin, *except* for those listed in the ``QueryStringNames`` type, which are not included.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] query_strings: Contains a list of query string names.
        """
        pulumi.set(__self__, "query_string_behavior", query_string_behavior)
        if query_strings is not None:
            pulumi.set(__self__, "query_strings", query_strings)

    @property
    @pulumi.getter(name="queryStringBehavior")
    def query_string_behavior(self) -> pulumi.Input[builtins.str]:
        """
        Determines whether any URL query strings in viewer requests are included in requests that CloudFront sends to the origin. Valid values are:
          +  ``none`` – No query strings in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to ``none``, any query strings that are listed in a ``CachePolicy``*are* included in origin requests.
          +  ``whitelist`` – Only the query strings in viewer requests that are listed in the ``QueryStringNames`` type are included in requests that CloudFront sends to the origin.
          +  ``all`` – All query strings in viewer requests are included in requests that CloudFront sends to the origin.
          +  ``allExcept`` – All query strings in viewer requests are included in requests that CloudFront sends to the origin, *except* for those listed in the ``QueryStringNames`` type, which are not included.
        """
        return pulumi.get(self, "query_string_behavior")

    @query_string_behavior.setter
    def query_string_behavior(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "query_string_behavior", value)

    @property
    @pulumi.getter(name="queryStrings")
    def query_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Contains a list of query string names.
        """
        return pulumi.get(self, "query_strings")

    @query_strings.setter
    def query_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "query_strings", value)


if not MYPY:
    class PublicKeyConfigArgsDict(TypedDict):
        """
        Configuration information about a public key that you can use with [signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html), or with [field-level encryption](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
        """
        caller_reference: pulumi.Input[builtins.str]
        """
        A string included in the request to help make sure that the request can't be replayed.
        """
        encoded_key: pulumi.Input[builtins.str]
        """
        The public key that you can use with [signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html), or with [field-level encryption](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
        """
        name: pulumi.Input[builtins.str]
        """
        A name to help identify the public key.
        """
        comment: NotRequired[pulumi.Input[builtins.str]]
        """
        A comment to describe the public key. The comment cannot be longer than 128 characters.
        """
elif False:
    PublicKeyConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PublicKeyConfigArgs:
    def __init__(__self__, *,
                 caller_reference: pulumi.Input[builtins.str],
                 encoded_key: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 comment: Optional[pulumi.Input[builtins.str]] = None):
        """
        Configuration information about a public key that you can use with [signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html), or with [field-level encryption](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
        :param pulumi.Input[builtins.str] caller_reference: A string included in the request to help make sure that the request can't be replayed.
        :param pulumi.Input[builtins.str] encoded_key: The public key that you can use with [signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html), or with [field-level encryption](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
        :param pulumi.Input[builtins.str] name: A name to help identify the public key.
        :param pulumi.Input[builtins.str] comment: A comment to describe the public key. The comment cannot be longer than 128 characters.
        """
        pulumi.set(__self__, "caller_reference", caller_reference)
        pulumi.set(__self__, "encoded_key", encoded_key)
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter(name="callerReference")
    def caller_reference(self) -> pulumi.Input[builtins.str]:
        """
        A string included in the request to help make sure that the request can't be replayed.
        """
        return pulumi.get(self, "caller_reference")

    @caller_reference.setter
    def caller_reference(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "caller_reference", value)

    @property
    @pulumi.getter(name="encodedKey")
    def encoded_key(self) -> pulumi.Input[builtins.str]:
        """
        The public key that you can use with [signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html), or with [field-level encryption](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
        """
        return pulumi.get(self, "encoded_key")

    @encoded_key.setter
    def encoded_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "encoded_key", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        A name to help identify the public key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A comment to describe the public key. The comment cannot be longer than 128 characters.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment", value)


if not MYPY:
    class RealtimeLogConfigEndPointArgsDict(TypedDict):
        """
        Contains information about the Amazon Kinesis data stream where you are sending real-time log data for this real-time log configuration.
        """
        kinesis_stream_config: pulumi.Input['RealtimeLogConfigKinesisStreamConfigArgsDict']
        """
        Contains information about the Amazon Kinesis data stream where you are sending real-time log data in a real-time log configuration.
        """
        stream_type: pulumi.Input[builtins.str]
        """
        The type of data stream where you are sending real-time log data. The only valid value is ``Kinesis``.
        """
elif False:
    RealtimeLogConfigEndPointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RealtimeLogConfigEndPointArgs:
    def __init__(__self__, *,
                 kinesis_stream_config: pulumi.Input['RealtimeLogConfigKinesisStreamConfigArgs'],
                 stream_type: pulumi.Input[builtins.str]):
        """
        Contains information about the Amazon Kinesis data stream where you are sending real-time log data for this real-time log configuration.
        :param pulumi.Input['RealtimeLogConfigKinesisStreamConfigArgs'] kinesis_stream_config: Contains information about the Amazon Kinesis data stream where you are sending real-time log data in a real-time log configuration.
        :param pulumi.Input[builtins.str] stream_type: The type of data stream where you are sending real-time log data. The only valid value is ``Kinesis``.
        """
        pulumi.set(__self__, "kinesis_stream_config", kinesis_stream_config)
        pulumi.set(__self__, "stream_type", stream_type)

    @property
    @pulumi.getter(name="kinesisStreamConfig")
    def kinesis_stream_config(self) -> pulumi.Input['RealtimeLogConfigKinesisStreamConfigArgs']:
        """
        Contains information about the Amazon Kinesis data stream where you are sending real-time log data in a real-time log configuration.
        """
        return pulumi.get(self, "kinesis_stream_config")

    @kinesis_stream_config.setter
    def kinesis_stream_config(self, value: pulumi.Input['RealtimeLogConfigKinesisStreamConfigArgs']):
        pulumi.set(self, "kinesis_stream_config", value)

    @property
    @pulumi.getter(name="streamType")
    def stream_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of data stream where you are sending real-time log data. The only valid value is ``Kinesis``.
        """
        return pulumi.get(self, "stream_type")

    @stream_type.setter
    def stream_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "stream_type", value)


if not MYPY:
    class RealtimeLogConfigKinesisStreamConfigArgsDict(TypedDict):
        """
        Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
        """
        role_arn: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of an IAMlong (IAM) role that CloudFront can use to send real-time log data to your Kinesis data stream.
         For more information the IAM role, see [Real-time log configuration IAM role](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role) in the *Amazon CloudFront Developer Guide*.
        """
        stream_arn: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending real-time log data.
        """
elif False:
    RealtimeLogConfigKinesisStreamConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RealtimeLogConfigKinesisStreamConfigArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[builtins.str],
                 stream_arn: pulumi.Input[builtins.str]):
        """
        Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of an IAMlong (IAM) role that CloudFront can use to send real-time log data to your Kinesis data stream.
                For more information the IAM role, see [Real-time log configuration IAM role](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role) in the *Amazon CloudFront Developer Guide*.
        :param pulumi.Input[builtins.str] stream_arn: The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending real-time log data.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "stream_arn", stream_arn)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of an IAMlong (IAM) role that CloudFront can use to send real-time log data to your Kinesis data stream.
         For more information the IAM role, see [Real-time log configuration IAM role](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending real-time log data.
        """
        return pulumi.get(self, "stream_arn")

    @stream_arn.setter
    def stream_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "stream_arn", value)


if not MYPY:
    class ResponseHeadersPolicyAccessControlAllowHeadersArgsDict(TypedDict):
        """
        A list of HTTP header names that CloudFront includes as values for the ``Access-Control-Allow-Headers`` HTTP response header.
         For more information about the ``Access-Control-Allow-Headers`` HTTP response header, see [Access-Control-Allow-Headers](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers) in the MDN Web Docs.
        """
        items: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The list of HTTP header names. You can specify ``*`` to allow all headers.
        """
elif False:
    ResponseHeadersPolicyAccessControlAllowHeadersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponseHeadersPolicyAccessControlAllowHeadersArgs:
    def __init__(__self__, *,
                 items: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        A list of HTTP header names that CloudFront includes as values for the ``Access-Control-Allow-Headers`` HTTP response header.
         For more information about the ``Access-Control-Allow-Headers`` HTTP response header, see [Access-Control-Allow-Headers](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers) in the MDN Web Docs.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] items: The list of HTTP header names. You can specify ``*`` to allow all headers.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The list of HTTP header names. You can specify ``*`` to allow all headers.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "items", value)


if not MYPY:
    class ResponseHeadersPolicyAccessControlAllowMethodsArgsDict(TypedDict):
        """
        A list of HTTP methods that CloudFront includes as values for the ``Access-Control-Allow-Methods`` HTTP response header.
         For more information about the ``Access-Control-Allow-Methods`` HTTP response header, see [Access-Control-Allow-Methods](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods) in the MDN Web Docs.
        """
        items: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The list of HTTP methods. Valid values are:
          +   ``GET`` 
          +   ``DELETE`` 
          +   ``HEAD`` 
          +   ``OPTIONS`` 
          +   ``PATCH`` 
          +   ``POST`` 
          +   ``PUT`` 
          +   ``ALL`` 
          
         ``ALL`` is a special value that includes all of the listed HTTP methods.
        """
elif False:
    ResponseHeadersPolicyAccessControlAllowMethodsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponseHeadersPolicyAccessControlAllowMethodsArgs:
    def __init__(__self__, *,
                 items: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        A list of HTTP methods that CloudFront includes as values for the ``Access-Control-Allow-Methods`` HTTP response header.
         For more information about the ``Access-Control-Allow-Methods`` HTTP response header, see [Access-Control-Allow-Methods](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods) in the MDN Web Docs.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] items: The list of HTTP methods. Valid values are:
                 +   ``GET`` 
                 +   ``DELETE`` 
                 +   ``HEAD`` 
                 +   ``OPTIONS`` 
                 +   ``PATCH`` 
                 +   ``POST`` 
                 +   ``PUT`` 
                 +   ``ALL`` 
                 
                ``ALL`` is a special value that includes all of the listed HTTP methods.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The list of HTTP methods. Valid values are:
          +   ``GET`` 
          +   ``DELETE`` 
          +   ``HEAD`` 
          +   ``OPTIONS`` 
          +   ``PATCH`` 
          +   ``POST`` 
          +   ``PUT`` 
          +   ``ALL`` 
          
         ``ALL`` is a special value that includes all of the listed HTTP methods.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "items", value)


if not MYPY:
    class ResponseHeadersPolicyAccessControlAllowOriginsArgsDict(TypedDict):
        """
        A list of origins (domain names) that CloudFront can use as the value for the ``Access-Control-Allow-Origin`` HTTP response header.
         For more information about the ``Access-Control-Allow-Origin`` HTTP response header, see [Access-Control-Allow-Origin](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin) in the MDN Web Docs.
        """
        items: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The list of origins (domain names). You can specify ``*`` to allow all origins.
        """
elif False:
    ResponseHeadersPolicyAccessControlAllowOriginsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponseHeadersPolicyAccessControlAllowOriginsArgs:
    def __init__(__self__, *,
                 items: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        A list of origins (domain names) that CloudFront can use as the value for the ``Access-Control-Allow-Origin`` HTTP response header.
         For more information about the ``Access-Control-Allow-Origin`` HTTP response header, see [Access-Control-Allow-Origin](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin) in the MDN Web Docs.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] items: The list of origins (domain names). You can specify ``*`` to allow all origins.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The list of origins (domain names). You can specify ``*`` to allow all origins.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "items", value)


if not MYPY:
    class ResponseHeadersPolicyAccessControlExposeHeadersArgsDict(TypedDict):
        """
        A list of HTTP headers that CloudFront includes as values for the ``Access-Control-Expose-Headers`` HTTP response header.
         For more information about the ``Access-Control-Expose-Headers`` HTTP response header, see [Access-Control-Expose-Headers](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers) in the MDN Web Docs.
        """
        items: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The list of HTTP headers. You can specify ``*`` to expose all headers.
        """
elif False:
    ResponseHeadersPolicyAccessControlExposeHeadersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponseHeadersPolicyAccessControlExposeHeadersArgs:
    def __init__(__self__, *,
                 items: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        A list of HTTP headers that CloudFront includes as values for the ``Access-Control-Expose-Headers`` HTTP response header.
         For more information about the ``Access-Control-Expose-Headers`` HTTP response header, see [Access-Control-Expose-Headers](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers) in the MDN Web Docs.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] items: The list of HTTP headers. You can specify ``*`` to expose all headers.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The list of HTTP headers. You can specify ``*`` to expose all headers.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "items", value)


if not MYPY:
    class ResponseHeadersPolicyConfigArgsDict(TypedDict):
        """
        A response headers policy configuration.
         A response headers policy configuration contains metadata about the response headers policy, and configurations for sets of HTTP response headers.
        """
        name: pulumi.Input[builtins.str]
        """
        A name to identify the response headers policy.
         The name must be unique for response headers policies in this AWS-account.
        """
        comment: NotRequired[pulumi.Input[builtins.str]]
        """
        A comment to describe the response headers policy.
         The comment cannot be longer than 128 characters.
        """
        cors_config: NotRequired[pulumi.Input['ResponseHeadersPolicyCorsConfigArgsDict']]
        """
        A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS).
        """
        custom_headers_config: NotRequired[pulumi.Input['ResponseHeadersPolicyCustomHeadersConfigArgsDict']]
        """
        A configuration for a set of custom HTTP response headers.
        """
        remove_headers_config: NotRequired[pulumi.Input['ResponseHeadersPolicyRemoveHeadersConfigArgsDict']]
        """
        A configuration for a set of HTTP headers to remove from the HTTP response.
        """
        security_headers_config: NotRequired[pulumi.Input['ResponseHeadersPolicySecurityHeadersConfigArgsDict']]
        """
        A configuration for a set of security-related HTTP response headers.
        """
        server_timing_headers_config: NotRequired[pulumi.Input['ResponseHeadersPolicyServerTimingHeadersConfigArgsDict']]
        """
        A configuration for enabling the ``Server-Timing`` header in HTTP responses sent from CloudFront.
        """
elif False:
    ResponseHeadersPolicyConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponseHeadersPolicyConfigArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 cors_config: Optional[pulumi.Input['ResponseHeadersPolicyCorsConfigArgs']] = None,
                 custom_headers_config: Optional[pulumi.Input['ResponseHeadersPolicyCustomHeadersConfigArgs']] = None,
                 remove_headers_config: Optional[pulumi.Input['ResponseHeadersPolicyRemoveHeadersConfigArgs']] = None,
                 security_headers_config: Optional[pulumi.Input['ResponseHeadersPolicySecurityHeadersConfigArgs']] = None,
                 server_timing_headers_config: Optional[pulumi.Input['ResponseHeadersPolicyServerTimingHeadersConfigArgs']] = None):
        """
        A response headers policy configuration.
         A response headers policy configuration contains metadata about the response headers policy, and configurations for sets of HTTP response headers.
        :param pulumi.Input[builtins.str] name: A name to identify the response headers policy.
                The name must be unique for response headers policies in this AWS-account.
        :param pulumi.Input[builtins.str] comment: A comment to describe the response headers policy.
                The comment cannot be longer than 128 characters.
        :param pulumi.Input['ResponseHeadersPolicyCorsConfigArgs'] cors_config: A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS).
        :param pulumi.Input['ResponseHeadersPolicyCustomHeadersConfigArgs'] custom_headers_config: A configuration for a set of custom HTTP response headers.
        :param pulumi.Input['ResponseHeadersPolicyRemoveHeadersConfigArgs'] remove_headers_config: A configuration for a set of HTTP headers to remove from the HTTP response.
        :param pulumi.Input['ResponseHeadersPolicySecurityHeadersConfigArgs'] security_headers_config: A configuration for a set of security-related HTTP response headers.
        :param pulumi.Input['ResponseHeadersPolicyServerTimingHeadersConfigArgs'] server_timing_headers_config: A configuration for enabling the ``Server-Timing`` header in HTTP responses sent from CloudFront.
        """
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if cors_config is not None:
            pulumi.set(__self__, "cors_config", cors_config)
        if custom_headers_config is not None:
            pulumi.set(__self__, "custom_headers_config", custom_headers_config)
        if remove_headers_config is not None:
            pulumi.set(__self__, "remove_headers_config", remove_headers_config)
        if security_headers_config is not None:
            pulumi.set(__self__, "security_headers_config", security_headers_config)
        if server_timing_headers_config is not None:
            pulumi.set(__self__, "server_timing_headers_config", server_timing_headers_config)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        A name to identify the response headers policy.
         The name must be unique for response headers policies in this AWS-account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A comment to describe the response headers policy.
         The comment cannot be longer than 128 characters.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="corsConfig")
    def cors_config(self) -> Optional[pulumi.Input['ResponseHeadersPolicyCorsConfigArgs']]:
        """
        A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS).
        """
        return pulumi.get(self, "cors_config")

    @cors_config.setter
    def cors_config(self, value: Optional[pulumi.Input['ResponseHeadersPolicyCorsConfigArgs']]):
        pulumi.set(self, "cors_config", value)

    @property
    @pulumi.getter(name="customHeadersConfig")
    def custom_headers_config(self) -> Optional[pulumi.Input['ResponseHeadersPolicyCustomHeadersConfigArgs']]:
        """
        A configuration for a set of custom HTTP response headers.
        """
        return pulumi.get(self, "custom_headers_config")

    @custom_headers_config.setter
    def custom_headers_config(self, value: Optional[pulumi.Input['ResponseHeadersPolicyCustomHeadersConfigArgs']]):
        pulumi.set(self, "custom_headers_config", value)

    @property
    @pulumi.getter(name="removeHeadersConfig")
    def remove_headers_config(self) -> Optional[pulumi.Input['ResponseHeadersPolicyRemoveHeadersConfigArgs']]:
        """
        A configuration for a set of HTTP headers to remove from the HTTP response.
        """
        return pulumi.get(self, "remove_headers_config")

    @remove_headers_config.setter
    def remove_headers_config(self, value: Optional[pulumi.Input['ResponseHeadersPolicyRemoveHeadersConfigArgs']]):
        pulumi.set(self, "remove_headers_config", value)

    @property
    @pulumi.getter(name="securityHeadersConfig")
    def security_headers_config(self) -> Optional[pulumi.Input['ResponseHeadersPolicySecurityHeadersConfigArgs']]:
        """
        A configuration for a set of security-related HTTP response headers.
        """
        return pulumi.get(self, "security_headers_config")

    @security_headers_config.setter
    def security_headers_config(self, value: Optional[pulumi.Input['ResponseHeadersPolicySecurityHeadersConfigArgs']]):
        pulumi.set(self, "security_headers_config", value)

    @property
    @pulumi.getter(name="serverTimingHeadersConfig")
    def server_timing_headers_config(self) -> Optional[pulumi.Input['ResponseHeadersPolicyServerTimingHeadersConfigArgs']]:
        """
        A configuration for enabling the ``Server-Timing`` header in HTTP responses sent from CloudFront.
        """
        return pulumi.get(self, "server_timing_headers_config")

    @server_timing_headers_config.setter
    def server_timing_headers_config(self, value: Optional[pulumi.Input['ResponseHeadersPolicyServerTimingHeadersConfigArgs']]):
        pulumi.set(self, "server_timing_headers_config", value)


if not MYPY:
    class ResponseHeadersPolicyContentSecurityPolicyArgsDict(TypedDict):
        """
        The policy directives and their values that CloudFront includes as values for the ``Content-Security-Policy`` HTTP response header.
         For more information about the ``Content-Security-Policy`` HTTP response header, see [Content-Security-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy) in the MDN Web Docs.
        """
        content_security_policy: pulumi.Input[builtins.str]
        """
        The policy directives and their values that CloudFront includes as values for the ``Content-Security-Policy`` HTTP response header.
         For more information about the ``Content-Security-Policy`` HTTP response header, see [Content-Security-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy) in the MDN Web Docs.
        """
        override: pulumi.Input[builtins.bool]
        """
        A Boolean that determines whether CloudFront overrides the ``Content-Security-Policy`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
elif False:
    ResponseHeadersPolicyContentSecurityPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponseHeadersPolicyContentSecurityPolicyArgs:
    def __init__(__self__, *,
                 content_security_policy: pulumi.Input[builtins.str],
                 override: pulumi.Input[builtins.bool]):
        """
        The policy directives and their values that CloudFront includes as values for the ``Content-Security-Policy`` HTTP response header.
         For more information about the ``Content-Security-Policy`` HTTP response header, see [Content-Security-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy) in the MDN Web Docs.
        :param pulumi.Input[builtins.str] content_security_policy: The policy directives and their values that CloudFront includes as values for the ``Content-Security-Policy`` HTTP response header.
                For more information about the ``Content-Security-Policy`` HTTP response header, see [Content-Security-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy) in the MDN Web Docs.
        :param pulumi.Input[builtins.bool] override: A Boolean that determines whether CloudFront overrides the ``Content-Security-Policy`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        pulumi.set(__self__, "content_security_policy", content_security_policy)
        pulumi.set(__self__, "override", override)

    @property
    @pulumi.getter(name="contentSecurityPolicy")
    def content_security_policy(self) -> pulumi.Input[builtins.str]:
        """
        The policy directives and their values that CloudFront includes as values for the ``Content-Security-Policy`` HTTP response header.
         For more information about the ``Content-Security-Policy`` HTTP response header, see [Content-Security-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy) in the MDN Web Docs.
        """
        return pulumi.get(self, "content_security_policy")

    @content_security_policy.setter
    def content_security_policy(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "content_security_policy", value)

    @property
    @pulumi.getter
    def override(self) -> pulumi.Input[builtins.bool]:
        """
        A Boolean that determines whether CloudFront overrides the ``Content-Security-Policy`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        return pulumi.get(self, "override")

    @override.setter
    def override(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "override", value)


if not MYPY:
    class ResponseHeadersPolicyContentTypeOptionsArgsDict(TypedDict):
        """
        Determines whether CloudFront includes the ``X-Content-Type-Options`` HTTP response header with its value set to ``nosniff``.
         For more information about the ``X-Content-Type-Options`` HTTP response header, see [X-Content-Type-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options) in the MDN Web Docs.
        """
        override: pulumi.Input[builtins.bool]
        """
        A Boolean that determines whether CloudFront overrides the ``X-Content-Type-Options`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
elif False:
    ResponseHeadersPolicyContentTypeOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponseHeadersPolicyContentTypeOptionsArgs:
    def __init__(__self__, *,
                 override: pulumi.Input[builtins.bool]):
        """
        Determines whether CloudFront includes the ``X-Content-Type-Options`` HTTP response header with its value set to ``nosniff``.
         For more information about the ``X-Content-Type-Options`` HTTP response header, see [X-Content-Type-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options) in the MDN Web Docs.
        :param pulumi.Input[builtins.bool] override: A Boolean that determines whether CloudFront overrides the ``X-Content-Type-Options`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        pulumi.set(__self__, "override", override)

    @property
    @pulumi.getter
    def override(self) -> pulumi.Input[builtins.bool]:
        """
        A Boolean that determines whether CloudFront overrides the ``X-Content-Type-Options`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        return pulumi.get(self, "override")

    @override.setter
    def override(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "override", value)


if not MYPY:
    class ResponseHeadersPolicyCorsConfigArgsDict(TypedDict):
        """
        A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS). CloudFront adds these headers to HTTP responses that it sends for CORS requests that match a cache behavior associated with this response headers policy.
         For more information about CORS, see [Cross-Origin Resource Sharing (CORS)](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) in the MDN Web Docs.
        """
        access_control_allow_credentials: pulumi.Input[builtins.bool]
        """
        A Boolean that CloudFront uses as the value for the ``Access-Control-Allow-Credentials`` HTTP response header.
         For more information about the ``Access-Control-Allow-Credentials`` HTTP response header, see [Access-Control-Allow-Credentials](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials) in the MDN Web Docs.
        """
        access_control_allow_headers: pulumi.Input['ResponseHeadersPolicyAccessControlAllowHeadersArgsDict']
        """
        A list of HTTP header names that CloudFront includes as values for the ``Access-Control-Allow-Headers`` HTTP response header.
         For more information about the ``Access-Control-Allow-Headers`` HTTP response header, see [Access-Control-Allow-Headers](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers) in the MDN Web Docs.
        """
        access_control_allow_methods: pulumi.Input['ResponseHeadersPolicyAccessControlAllowMethodsArgsDict']
        """
        A list of HTTP methods that CloudFront includes as values for the ``Access-Control-Allow-Methods`` HTTP response header.
         For more information about the ``Access-Control-Allow-Methods`` HTTP response header, see [Access-Control-Allow-Methods](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods) in the MDN Web Docs.
        """
        access_control_allow_origins: pulumi.Input['ResponseHeadersPolicyAccessControlAllowOriginsArgsDict']
        """
        A list of origins (domain names) that CloudFront can use as the value for the ``Access-Control-Allow-Origin`` HTTP response header.
         For more information about the ``Access-Control-Allow-Origin`` HTTP response header, see [Access-Control-Allow-Origin](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin) in the MDN Web Docs.
        """
        origin_override: pulumi.Input[builtins.bool]
        """
        A Boolean that determines whether CloudFront overrides HTTP response headers received from the origin with the ones specified in this response headers policy.
        """
        access_control_expose_headers: NotRequired[pulumi.Input['ResponseHeadersPolicyAccessControlExposeHeadersArgsDict']]
        """
        A list of HTTP headers that CloudFront includes as values for the ``Access-Control-Expose-Headers`` HTTP response header.
         For more information about the ``Access-Control-Expose-Headers`` HTTP response header, see [Access-Control-Expose-Headers](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers) in the MDN Web Docs.
        """
        access_control_max_age_sec: NotRequired[pulumi.Input[builtins.int]]
        """
        A number that CloudFront uses as the value for the ``Access-Control-Max-Age`` HTTP response header.
         For more information about the ``Access-Control-Max-Age`` HTTP response header, see [Access-Control-Max-Age](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Max-Age) in the MDN Web Docs.
        """
elif False:
    ResponseHeadersPolicyCorsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponseHeadersPolicyCorsConfigArgs:
    def __init__(__self__, *,
                 access_control_allow_credentials: pulumi.Input[builtins.bool],
                 access_control_allow_headers: pulumi.Input['ResponseHeadersPolicyAccessControlAllowHeadersArgs'],
                 access_control_allow_methods: pulumi.Input['ResponseHeadersPolicyAccessControlAllowMethodsArgs'],
                 access_control_allow_origins: pulumi.Input['ResponseHeadersPolicyAccessControlAllowOriginsArgs'],
                 origin_override: pulumi.Input[builtins.bool],
                 access_control_expose_headers: Optional[pulumi.Input['ResponseHeadersPolicyAccessControlExposeHeadersArgs']] = None,
                 access_control_max_age_sec: Optional[pulumi.Input[builtins.int]] = None):
        """
        A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS). CloudFront adds these headers to HTTP responses that it sends for CORS requests that match a cache behavior associated with this response headers policy.
         For more information about CORS, see [Cross-Origin Resource Sharing (CORS)](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) in the MDN Web Docs.
        :param pulumi.Input[builtins.bool] access_control_allow_credentials: A Boolean that CloudFront uses as the value for the ``Access-Control-Allow-Credentials`` HTTP response header.
                For more information about the ``Access-Control-Allow-Credentials`` HTTP response header, see [Access-Control-Allow-Credentials](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials) in the MDN Web Docs.
        :param pulumi.Input['ResponseHeadersPolicyAccessControlAllowHeadersArgs'] access_control_allow_headers: A list of HTTP header names that CloudFront includes as values for the ``Access-Control-Allow-Headers`` HTTP response header.
                For more information about the ``Access-Control-Allow-Headers`` HTTP response header, see [Access-Control-Allow-Headers](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers) in the MDN Web Docs.
        :param pulumi.Input['ResponseHeadersPolicyAccessControlAllowMethodsArgs'] access_control_allow_methods: A list of HTTP methods that CloudFront includes as values for the ``Access-Control-Allow-Methods`` HTTP response header.
                For more information about the ``Access-Control-Allow-Methods`` HTTP response header, see [Access-Control-Allow-Methods](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods) in the MDN Web Docs.
        :param pulumi.Input['ResponseHeadersPolicyAccessControlAllowOriginsArgs'] access_control_allow_origins: A list of origins (domain names) that CloudFront can use as the value for the ``Access-Control-Allow-Origin`` HTTP response header.
                For more information about the ``Access-Control-Allow-Origin`` HTTP response header, see [Access-Control-Allow-Origin](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin) in the MDN Web Docs.
        :param pulumi.Input[builtins.bool] origin_override: A Boolean that determines whether CloudFront overrides HTTP response headers received from the origin with the ones specified in this response headers policy.
        :param pulumi.Input['ResponseHeadersPolicyAccessControlExposeHeadersArgs'] access_control_expose_headers: A list of HTTP headers that CloudFront includes as values for the ``Access-Control-Expose-Headers`` HTTP response header.
                For more information about the ``Access-Control-Expose-Headers`` HTTP response header, see [Access-Control-Expose-Headers](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers) in the MDN Web Docs.
        :param pulumi.Input[builtins.int] access_control_max_age_sec: A number that CloudFront uses as the value for the ``Access-Control-Max-Age`` HTTP response header.
                For more information about the ``Access-Control-Max-Age`` HTTP response header, see [Access-Control-Max-Age](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Max-Age) in the MDN Web Docs.
        """
        pulumi.set(__self__, "access_control_allow_credentials", access_control_allow_credentials)
        pulumi.set(__self__, "access_control_allow_headers", access_control_allow_headers)
        pulumi.set(__self__, "access_control_allow_methods", access_control_allow_methods)
        pulumi.set(__self__, "access_control_allow_origins", access_control_allow_origins)
        pulumi.set(__self__, "origin_override", origin_override)
        if access_control_expose_headers is not None:
            pulumi.set(__self__, "access_control_expose_headers", access_control_expose_headers)
        if access_control_max_age_sec is not None:
            pulumi.set(__self__, "access_control_max_age_sec", access_control_max_age_sec)

    @property
    @pulumi.getter(name="accessControlAllowCredentials")
    def access_control_allow_credentials(self) -> pulumi.Input[builtins.bool]:
        """
        A Boolean that CloudFront uses as the value for the ``Access-Control-Allow-Credentials`` HTTP response header.
         For more information about the ``Access-Control-Allow-Credentials`` HTTP response header, see [Access-Control-Allow-Credentials](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials) in the MDN Web Docs.
        """
        return pulumi.get(self, "access_control_allow_credentials")

    @access_control_allow_credentials.setter
    def access_control_allow_credentials(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "access_control_allow_credentials", value)

    @property
    @pulumi.getter(name="accessControlAllowHeaders")
    def access_control_allow_headers(self) -> pulumi.Input['ResponseHeadersPolicyAccessControlAllowHeadersArgs']:
        """
        A list of HTTP header names that CloudFront includes as values for the ``Access-Control-Allow-Headers`` HTTP response header.
         For more information about the ``Access-Control-Allow-Headers`` HTTP response header, see [Access-Control-Allow-Headers](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers) in the MDN Web Docs.
        """
        return pulumi.get(self, "access_control_allow_headers")

    @access_control_allow_headers.setter
    def access_control_allow_headers(self, value: pulumi.Input['ResponseHeadersPolicyAccessControlAllowHeadersArgs']):
        pulumi.set(self, "access_control_allow_headers", value)

    @property
    @pulumi.getter(name="accessControlAllowMethods")
    def access_control_allow_methods(self) -> pulumi.Input['ResponseHeadersPolicyAccessControlAllowMethodsArgs']:
        """
        A list of HTTP methods that CloudFront includes as values for the ``Access-Control-Allow-Methods`` HTTP response header.
         For more information about the ``Access-Control-Allow-Methods`` HTTP response header, see [Access-Control-Allow-Methods](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods) in the MDN Web Docs.
        """
        return pulumi.get(self, "access_control_allow_methods")

    @access_control_allow_methods.setter
    def access_control_allow_methods(self, value: pulumi.Input['ResponseHeadersPolicyAccessControlAllowMethodsArgs']):
        pulumi.set(self, "access_control_allow_methods", value)

    @property
    @pulumi.getter(name="accessControlAllowOrigins")
    def access_control_allow_origins(self) -> pulumi.Input['ResponseHeadersPolicyAccessControlAllowOriginsArgs']:
        """
        A list of origins (domain names) that CloudFront can use as the value for the ``Access-Control-Allow-Origin`` HTTP response header.
         For more information about the ``Access-Control-Allow-Origin`` HTTP response header, see [Access-Control-Allow-Origin](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin) in the MDN Web Docs.
        """
        return pulumi.get(self, "access_control_allow_origins")

    @access_control_allow_origins.setter
    def access_control_allow_origins(self, value: pulumi.Input['ResponseHeadersPolicyAccessControlAllowOriginsArgs']):
        pulumi.set(self, "access_control_allow_origins", value)

    @property
    @pulumi.getter(name="originOverride")
    def origin_override(self) -> pulumi.Input[builtins.bool]:
        """
        A Boolean that determines whether CloudFront overrides HTTP response headers received from the origin with the ones specified in this response headers policy.
        """
        return pulumi.get(self, "origin_override")

    @origin_override.setter
    def origin_override(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "origin_override", value)

    @property
    @pulumi.getter(name="accessControlExposeHeaders")
    def access_control_expose_headers(self) -> Optional[pulumi.Input['ResponseHeadersPolicyAccessControlExposeHeadersArgs']]:
        """
        A list of HTTP headers that CloudFront includes as values for the ``Access-Control-Expose-Headers`` HTTP response header.
         For more information about the ``Access-Control-Expose-Headers`` HTTP response header, see [Access-Control-Expose-Headers](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers) in the MDN Web Docs.
        """
        return pulumi.get(self, "access_control_expose_headers")

    @access_control_expose_headers.setter
    def access_control_expose_headers(self, value: Optional[pulumi.Input['ResponseHeadersPolicyAccessControlExposeHeadersArgs']]):
        pulumi.set(self, "access_control_expose_headers", value)

    @property
    @pulumi.getter(name="accessControlMaxAgeSec")
    def access_control_max_age_sec(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        A number that CloudFront uses as the value for the ``Access-Control-Max-Age`` HTTP response header.
         For more information about the ``Access-Control-Max-Age`` HTTP response header, see [Access-Control-Max-Age](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Max-Age) in the MDN Web Docs.
        """
        return pulumi.get(self, "access_control_max_age_sec")

    @access_control_max_age_sec.setter
    def access_control_max_age_sec(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "access_control_max_age_sec", value)


if not MYPY:
    class ResponseHeadersPolicyCustomHeadersConfigArgsDict(TypedDict):
        """
        A list of HTTP response header names and their values. CloudFront includes these headers in HTTP responses that it sends for requests that match a cache behavior that's associated with this response headers policy.
        """
        items: pulumi.Input[Sequence[pulumi.Input['ResponseHeadersPolicyCustomHeaderArgsDict']]]
        """
        The list of HTTP response headers and their values.
        """
elif False:
    ResponseHeadersPolicyCustomHeadersConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponseHeadersPolicyCustomHeadersConfigArgs:
    def __init__(__self__, *,
                 items: pulumi.Input[Sequence[pulumi.Input['ResponseHeadersPolicyCustomHeaderArgs']]]):
        """
        A list of HTTP response header names and their values. CloudFront includes these headers in HTTP responses that it sends for requests that match a cache behavior that's associated with this response headers policy.
        :param pulumi.Input[Sequence[pulumi.Input['ResponseHeadersPolicyCustomHeaderArgs']]] items: The list of HTTP response headers and their values.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> pulumi.Input[Sequence[pulumi.Input['ResponseHeadersPolicyCustomHeaderArgs']]]:
        """
        The list of HTTP response headers and their values.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: pulumi.Input[Sequence[pulumi.Input['ResponseHeadersPolicyCustomHeaderArgs']]]):
        pulumi.set(self, "items", value)


if not MYPY:
    class ResponseHeadersPolicyCustomHeaderArgsDict(TypedDict):
        """
        An HTTP response header name and its value. CloudFront includes this header in HTTP responses that it sends for requests that match a cache behavior that's associated with this response headers policy.
        """
        header: pulumi.Input[builtins.str]
        """
        The HTTP response header name.
        """
        override: pulumi.Input[builtins.bool]
        """
        A Boolean that determines whether CloudFront overrides a response header with the same name received from the origin with the header specified here.
        """
        value: pulumi.Input[builtins.str]
        """
        The value for the HTTP response header.
        """
elif False:
    ResponseHeadersPolicyCustomHeaderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponseHeadersPolicyCustomHeaderArgs:
    def __init__(__self__, *,
                 header: pulumi.Input[builtins.str],
                 override: pulumi.Input[builtins.bool],
                 value: pulumi.Input[builtins.str]):
        """
        An HTTP response header name and its value. CloudFront includes this header in HTTP responses that it sends for requests that match a cache behavior that's associated with this response headers policy.
        :param pulumi.Input[builtins.str] header: The HTTP response header name.
        :param pulumi.Input[builtins.bool] override: A Boolean that determines whether CloudFront overrides a response header with the same name received from the origin with the header specified here.
        :param pulumi.Input[builtins.str] value: The value for the HTTP response header.
        """
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "override", override)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def header(self) -> pulumi.Input[builtins.str]:
        """
        The HTTP response header name.
        """
        return pulumi.get(self, "header")

    @header.setter
    def header(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "header", value)

    @property
    @pulumi.getter
    def override(self) -> pulumi.Input[builtins.bool]:
        """
        A Boolean that determines whether CloudFront overrides a response header with the same name received from the origin with the header specified here.
        """
        return pulumi.get(self, "override")

    @override.setter
    def override(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "override", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        The value for the HTTP response header.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ResponseHeadersPolicyFrameOptionsArgsDict(TypedDict):
        """
        Determines whether CloudFront includes the ``X-Frame-Options`` HTTP response header and the header's value.
         For more information about the ``X-Frame-Options`` HTTP response header, see [X-Frame-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options) in the MDN Web Docs.
        """
        frame_option: pulumi.Input[builtins.str]
        """
        The value of the ``X-Frame-Options`` HTTP response header. Valid values are ``DENY`` and ``SAMEORIGIN``.
         For more information about these values, see [X-Frame-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options) in the MDN Web Docs.
        """
        override: pulumi.Input[builtins.bool]
        """
        A Boolean that determines whether CloudFront overrides the ``X-Frame-Options`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
elif False:
    ResponseHeadersPolicyFrameOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponseHeadersPolicyFrameOptionsArgs:
    def __init__(__self__, *,
                 frame_option: pulumi.Input[builtins.str],
                 override: pulumi.Input[builtins.bool]):
        """
        Determines whether CloudFront includes the ``X-Frame-Options`` HTTP response header and the header's value.
         For more information about the ``X-Frame-Options`` HTTP response header, see [X-Frame-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options) in the MDN Web Docs.
        :param pulumi.Input[builtins.str] frame_option: The value of the ``X-Frame-Options`` HTTP response header. Valid values are ``DENY`` and ``SAMEORIGIN``.
                For more information about these values, see [X-Frame-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options) in the MDN Web Docs.
        :param pulumi.Input[builtins.bool] override: A Boolean that determines whether CloudFront overrides the ``X-Frame-Options`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        pulumi.set(__self__, "frame_option", frame_option)
        pulumi.set(__self__, "override", override)

    @property
    @pulumi.getter(name="frameOption")
    def frame_option(self) -> pulumi.Input[builtins.str]:
        """
        The value of the ``X-Frame-Options`` HTTP response header. Valid values are ``DENY`` and ``SAMEORIGIN``.
         For more information about these values, see [X-Frame-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options) in the MDN Web Docs.
        """
        return pulumi.get(self, "frame_option")

    @frame_option.setter
    def frame_option(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "frame_option", value)

    @property
    @pulumi.getter
    def override(self) -> pulumi.Input[builtins.bool]:
        """
        A Boolean that determines whether CloudFront overrides the ``X-Frame-Options`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        return pulumi.get(self, "override")

    @override.setter
    def override(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "override", value)


if not MYPY:
    class ResponseHeadersPolicyReferrerPolicyArgsDict(TypedDict):
        """
        Determines whether CloudFront includes the ``Referrer-Policy`` HTTP response header and the header's value.
         For more information about the ``Referrer-Policy`` HTTP response header, see [Referrer-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy) in the MDN Web Docs.
        """
        override: pulumi.Input[builtins.bool]
        """
        A Boolean that determines whether CloudFront overrides the ``Referrer-Policy`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        referrer_policy: pulumi.Input[builtins.str]
        """
        Determines whether CloudFront includes the ``Referrer-Policy`` HTTP response header and the header's value.
         For more information about the ``Referrer-Policy`` HTTP response header, see [Referrer-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy) in the MDN Web Docs.
        """
elif False:
    ResponseHeadersPolicyReferrerPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponseHeadersPolicyReferrerPolicyArgs:
    def __init__(__self__, *,
                 override: pulumi.Input[builtins.bool],
                 referrer_policy: pulumi.Input[builtins.str]):
        """
        Determines whether CloudFront includes the ``Referrer-Policy`` HTTP response header and the header's value.
         For more information about the ``Referrer-Policy`` HTTP response header, see [Referrer-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy) in the MDN Web Docs.
        :param pulumi.Input[builtins.bool] override: A Boolean that determines whether CloudFront overrides the ``Referrer-Policy`` HTTP response header received from the origin with the one specified in this response headers policy.
        :param pulumi.Input[builtins.str] referrer_policy: Determines whether CloudFront includes the ``Referrer-Policy`` HTTP response header and the header's value.
                For more information about the ``Referrer-Policy`` HTTP response header, see [Referrer-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy) in the MDN Web Docs.
        """
        pulumi.set(__self__, "override", override)
        pulumi.set(__self__, "referrer_policy", referrer_policy)

    @property
    @pulumi.getter
    def override(self) -> pulumi.Input[builtins.bool]:
        """
        A Boolean that determines whether CloudFront overrides the ``Referrer-Policy`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        return pulumi.get(self, "override")

    @override.setter
    def override(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "override", value)

    @property
    @pulumi.getter(name="referrerPolicy")
    def referrer_policy(self) -> pulumi.Input[builtins.str]:
        """
        Determines whether CloudFront includes the ``Referrer-Policy`` HTTP response header and the header's value.
         For more information about the ``Referrer-Policy`` HTTP response header, see [Referrer-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy) in the MDN Web Docs.
        """
        return pulumi.get(self, "referrer_policy")

    @referrer_policy.setter
    def referrer_policy(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "referrer_policy", value)


if not MYPY:
    class ResponseHeadersPolicyRemoveHeadersConfigArgsDict(TypedDict):
        """
        A list of HTTP header names that CloudFront removes from HTTP responses to requests that match the cache behavior that this response headers policy is attached to.
        """
        items: pulumi.Input[Sequence[pulumi.Input['ResponseHeadersPolicyRemoveHeaderArgsDict']]]
        """
        The list of HTTP header names.
        """
elif False:
    ResponseHeadersPolicyRemoveHeadersConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponseHeadersPolicyRemoveHeadersConfigArgs:
    def __init__(__self__, *,
                 items: pulumi.Input[Sequence[pulumi.Input['ResponseHeadersPolicyRemoveHeaderArgs']]]):
        """
        A list of HTTP header names that CloudFront removes from HTTP responses to requests that match the cache behavior that this response headers policy is attached to.
        :param pulumi.Input[Sequence[pulumi.Input['ResponseHeadersPolicyRemoveHeaderArgs']]] items: The list of HTTP header names.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> pulumi.Input[Sequence[pulumi.Input['ResponseHeadersPolicyRemoveHeaderArgs']]]:
        """
        The list of HTTP header names.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: pulumi.Input[Sequence[pulumi.Input['ResponseHeadersPolicyRemoveHeaderArgs']]]):
        pulumi.set(self, "items", value)


if not MYPY:
    class ResponseHeadersPolicyRemoveHeaderArgsDict(TypedDict):
        """
        The name of an HTTP header that CloudFront removes from HTTP responses to requests that match the cache behavior that this response headers policy is attached to.
        """
        header: pulumi.Input[builtins.str]
        """
        The HTTP header name.
        """
elif False:
    ResponseHeadersPolicyRemoveHeaderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponseHeadersPolicyRemoveHeaderArgs:
    def __init__(__self__, *,
                 header: pulumi.Input[builtins.str]):
        """
        The name of an HTTP header that CloudFront removes from HTTP responses to requests that match the cache behavior that this response headers policy is attached to.
        :param pulumi.Input[builtins.str] header: The HTTP header name.
        """
        pulumi.set(__self__, "header", header)

    @property
    @pulumi.getter
    def header(self) -> pulumi.Input[builtins.str]:
        """
        The HTTP header name.
        """
        return pulumi.get(self, "header")

    @header.setter
    def header(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "header", value)


if not MYPY:
    class ResponseHeadersPolicySecurityHeadersConfigArgsDict(TypedDict):
        """
        A configuration for a set of security-related HTTP response headers. CloudFront adds these headers to HTTP responses that it sends for requests that match a cache behavior associated with this response headers policy.
        """
        content_security_policy: NotRequired[pulumi.Input['ResponseHeadersPolicyContentSecurityPolicyArgsDict']]
        """
        The policy directives and their values that CloudFront includes as values for the ``Content-Security-Policy`` HTTP response header.
         For more information about the ``Content-Security-Policy`` HTTP response header, see [Content-Security-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy) in the MDN Web Docs.
        """
        content_type_options: NotRequired[pulumi.Input['ResponseHeadersPolicyContentTypeOptionsArgsDict']]
        """
        Determines whether CloudFront includes the ``X-Content-Type-Options`` HTTP response header with its value set to ``nosniff``.
         For more information about the ``X-Content-Type-Options`` HTTP response header, see [X-Content-Type-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options) in the MDN Web Docs.
        """
        frame_options: NotRequired[pulumi.Input['ResponseHeadersPolicyFrameOptionsArgsDict']]
        """
        Determines whether CloudFront includes the ``X-Frame-Options`` HTTP response header and the header's value.
         For more information about the ``X-Frame-Options`` HTTP response header, see [X-Frame-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options) in the MDN Web Docs.
        """
        referrer_policy: NotRequired[pulumi.Input['ResponseHeadersPolicyReferrerPolicyArgsDict']]
        """
        Determines whether CloudFront includes the ``Referrer-Policy`` HTTP response header and the header's value.
         For more information about the ``Referrer-Policy`` HTTP response header, see [Referrer-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy) in the MDN Web Docs.
        """
        strict_transport_security: NotRequired[pulumi.Input['ResponseHeadersPolicyStrictTransportSecurityArgsDict']]
        """
        Determines whether CloudFront includes the ``Strict-Transport-Security`` HTTP response header and the header's value.
         For more information about the ``Strict-Transport-Security`` HTTP response header, see [Security headers](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/understanding-response-headers-policies.html#understanding-response-headers-policies-security) in the *Amazon CloudFront Developer Guide* and [Strict-Transport-Security](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security) in the MDN Web Docs.
        """
        xss_protection: NotRequired[pulumi.Input['ResponseHeadersPolicyXssProtectionArgsDict']]
        """
        Determines whether CloudFront includes the ``X-XSS-Protection`` HTTP response header and the header's value.
         For more information about the ``X-XSS-Protection`` HTTP response header, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        """
elif False:
    ResponseHeadersPolicySecurityHeadersConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponseHeadersPolicySecurityHeadersConfigArgs:
    def __init__(__self__, *,
                 content_security_policy: Optional[pulumi.Input['ResponseHeadersPolicyContentSecurityPolicyArgs']] = None,
                 content_type_options: Optional[pulumi.Input['ResponseHeadersPolicyContentTypeOptionsArgs']] = None,
                 frame_options: Optional[pulumi.Input['ResponseHeadersPolicyFrameOptionsArgs']] = None,
                 referrer_policy: Optional[pulumi.Input['ResponseHeadersPolicyReferrerPolicyArgs']] = None,
                 strict_transport_security: Optional[pulumi.Input['ResponseHeadersPolicyStrictTransportSecurityArgs']] = None,
                 xss_protection: Optional[pulumi.Input['ResponseHeadersPolicyXssProtectionArgs']] = None):
        """
        A configuration for a set of security-related HTTP response headers. CloudFront adds these headers to HTTP responses that it sends for requests that match a cache behavior associated with this response headers policy.
        :param pulumi.Input['ResponseHeadersPolicyContentSecurityPolicyArgs'] content_security_policy: The policy directives and their values that CloudFront includes as values for the ``Content-Security-Policy`` HTTP response header.
                For more information about the ``Content-Security-Policy`` HTTP response header, see [Content-Security-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy) in the MDN Web Docs.
        :param pulumi.Input['ResponseHeadersPolicyContentTypeOptionsArgs'] content_type_options: Determines whether CloudFront includes the ``X-Content-Type-Options`` HTTP response header with its value set to ``nosniff``.
                For more information about the ``X-Content-Type-Options`` HTTP response header, see [X-Content-Type-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options) in the MDN Web Docs.
        :param pulumi.Input['ResponseHeadersPolicyFrameOptionsArgs'] frame_options: Determines whether CloudFront includes the ``X-Frame-Options`` HTTP response header and the header's value.
                For more information about the ``X-Frame-Options`` HTTP response header, see [X-Frame-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options) in the MDN Web Docs.
        :param pulumi.Input['ResponseHeadersPolicyReferrerPolicyArgs'] referrer_policy: Determines whether CloudFront includes the ``Referrer-Policy`` HTTP response header and the header's value.
                For more information about the ``Referrer-Policy`` HTTP response header, see [Referrer-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy) in the MDN Web Docs.
        :param pulumi.Input['ResponseHeadersPolicyStrictTransportSecurityArgs'] strict_transport_security: Determines whether CloudFront includes the ``Strict-Transport-Security`` HTTP response header and the header's value.
                For more information about the ``Strict-Transport-Security`` HTTP response header, see [Security headers](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/understanding-response-headers-policies.html#understanding-response-headers-policies-security) in the *Amazon CloudFront Developer Guide* and [Strict-Transport-Security](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security) in the MDN Web Docs.
        :param pulumi.Input['ResponseHeadersPolicyXssProtectionArgs'] xss_protection: Determines whether CloudFront includes the ``X-XSS-Protection`` HTTP response header and the header's value.
                For more information about the ``X-XSS-Protection`` HTTP response header, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        """
        if content_security_policy is not None:
            pulumi.set(__self__, "content_security_policy", content_security_policy)
        if content_type_options is not None:
            pulumi.set(__self__, "content_type_options", content_type_options)
        if frame_options is not None:
            pulumi.set(__self__, "frame_options", frame_options)
        if referrer_policy is not None:
            pulumi.set(__self__, "referrer_policy", referrer_policy)
        if strict_transport_security is not None:
            pulumi.set(__self__, "strict_transport_security", strict_transport_security)
        if xss_protection is not None:
            pulumi.set(__self__, "xss_protection", xss_protection)

    @property
    @pulumi.getter(name="contentSecurityPolicy")
    def content_security_policy(self) -> Optional[pulumi.Input['ResponseHeadersPolicyContentSecurityPolicyArgs']]:
        """
        The policy directives and their values that CloudFront includes as values for the ``Content-Security-Policy`` HTTP response header.
         For more information about the ``Content-Security-Policy`` HTTP response header, see [Content-Security-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy) in the MDN Web Docs.
        """
        return pulumi.get(self, "content_security_policy")

    @content_security_policy.setter
    def content_security_policy(self, value: Optional[pulumi.Input['ResponseHeadersPolicyContentSecurityPolicyArgs']]):
        pulumi.set(self, "content_security_policy", value)

    @property
    @pulumi.getter(name="contentTypeOptions")
    def content_type_options(self) -> Optional[pulumi.Input['ResponseHeadersPolicyContentTypeOptionsArgs']]:
        """
        Determines whether CloudFront includes the ``X-Content-Type-Options`` HTTP response header with its value set to ``nosniff``.
         For more information about the ``X-Content-Type-Options`` HTTP response header, see [X-Content-Type-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options) in the MDN Web Docs.
        """
        return pulumi.get(self, "content_type_options")

    @content_type_options.setter
    def content_type_options(self, value: Optional[pulumi.Input['ResponseHeadersPolicyContentTypeOptionsArgs']]):
        pulumi.set(self, "content_type_options", value)

    @property
    @pulumi.getter(name="frameOptions")
    def frame_options(self) -> Optional[pulumi.Input['ResponseHeadersPolicyFrameOptionsArgs']]:
        """
        Determines whether CloudFront includes the ``X-Frame-Options`` HTTP response header and the header's value.
         For more information about the ``X-Frame-Options`` HTTP response header, see [X-Frame-Options](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options) in the MDN Web Docs.
        """
        return pulumi.get(self, "frame_options")

    @frame_options.setter
    def frame_options(self, value: Optional[pulumi.Input['ResponseHeadersPolicyFrameOptionsArgs']]):
        pulumi.set(self, "frame_options", value)

    @property
    @pulumi.getter(name="referrerPolicy")
    def referrer_policy(self) -> Optional[pulumi.Input['ResponseHeadersPolicyReferrerPolicyArgs']]:
        """
        Determines whether CloudFront includes the ``Referrer-Policy`` HTTP response header and the header's value.
         For more information about the ``Referrer-Policy`` HTTP response header, see [Referrer-Policy](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy) in the MDN Web Docs.
        """
        return pulumi.get(self, "referrer_policy")

    @referrer_policy.setter
    def referrer_policy(self, value: Optional[pulumi.Input['ResponseHeadersPolicyReferrerPolicyArgs']]):
        pulumi.set(self, "referrer_policy", value)

    @property
    @pulumi.getter(name="strictTransportSecurity")
    def strict_transport_security(self) -> Optional[pulumi.Input['ResponseHeadersPolicyStrictTransportSecurityArgs']]:
        """
        Determines whether CloudFront includes the ``Strict-Transport-Security`` HTTP response header and the header's value.
         For more information about the ``Strict-Transport-Security`` HTTP response header, see [Security headers](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/understanding-response-headers-policies.html#understanding-response-headers-policies-security) in the *Amazon CloudFront Developer Guide* and [Strict-Transport-Security](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security) in the MDN Web Docs.
        """
        return pulumi.get(self, "strict_transport_security")

    @strict_transport_security.setter
    def strict_transport_security(self, value: Optional[pulumi.Input['ResponseHeadersPolicyStrictTransportSecurityArgs']]):
        pulumi.set(self, "strict_transport_security", value)

    @property
    @pulumi.getter(name="xssProtection")
    def xss_protection(self) -> Optional[pulumi.Input['ResponseHeadersPolicyXssProtectionArgs']]:
        """
        Determines whether CloudFront includes the ``X-XSS-Protection`` HTTP response header and the header's value.
         For more information about the ``X-XSS-Protection`` HTTP response header, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        """
        return pulumi.get(self, "xss_protection")

    @xss_protection.setter
    def xss_protection(self, value: Optional[pulumi.Input['ResponseHeadersPolicyXssProtectionArgs']]):
        pulumi.set(self, "xss_protection", value)


if not MYPY:
    class ResponseHeadersPolicyServerTimingHeadersConfigArgsDict(TypedDict):
        """
        A configuration for enabling the ``Server-Timing`` header in HTTP responses sent from CloudFront.
        """
        enabled: pulumi.Input[builtins.bool]
        """
        A Boolean that determines whether CloudFront adds the ``Server-Timing`` header to HTTP responses that it sends in response to requests that match a cache behavior that's associated with this response headers policy.
        """
        sampling_rate: NotRequired[pulumi.Input[builtins.float]]
        """
        A number 0–100 (inclusive) that specifies the percentage of responses that you want CloudFront to add the ``Server-Timing`` header to. When you set the sampling rate to 100, CloudFront adds the ``Server-Timing`` header to the HTTP response for every request that matches the cache behavior that this response headers policy is attached to. When you set it to 50, CloudFront adds the header to 50% of the responses for requests that match the cache behavior. You can set the sampling rate to any number 0–100 with up to four decimal places.
        """
elif False:
    ResponseHeadersPolicyServerTimingHeadersConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponseHeadersPolicyServerTimingHeadersConfigArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 sampling_rate: Optional[pulumi.Input[builtins.float]] = None):
        """
        A configuration for enabling the ``Server-Timing`` header in HTTP responses sent from CloudFront.
        :param pulumi.Input[builtins.bool] enabled: A Boolean that determines whether CloudFront adds the ``Server-Timing`` header to HTTP responses that it sends in response to requests that match a cache behavior that's associated with this response headers policy.
        :param pulumi.Input[builtins.float] sampling_rate: A number 0–100 (inclusive) that specifies the percentage of responses that you want CloudFront to add the ``Server-Timing`` header to. When you set the sampling rate to 100, CloudFront adds the ``Server-Timing`` header to the HTTP response for every request that matches the cache behavior that this response headers policy is attached to. When you set it to 50, CloudFront adds the header to 50% of the responses for requests that match the cache behavior. You can set the sampling rate to any number 0–100 with up to four decimal places.
        """
        pulumi.set(__self__, "enabled", enabled)
        if sampling_rate is not None:
            pulumi.set(__self__, "sampling_rate", sampling_rate)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        A Boolean that determines whether CloudFront adds the ``Server-Timing`` header to HTTP responses that it sends in response to requests that match a cache behavior that's associated with this response headers policy.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        A number 0–100 (inclusive) that specifies the percentage of responses that you want CloudFront to add the ``Server-Timing`` header to. When you set the sampling rate to 100, CloudFront adds the ``Server-Timing`` header to the HTTP response for every request that matches the cache behavior that this response headers policy is attached to. When you set it to 50, CloudFront adds the header to 50% of the responses for requests that match the cache behavior. You can set the sampling rate to any number 0–100 with up to four decimal places.
        """
        return pulumi.get(self, "sampling_rate")

    @sampling_rate.setter
    def sampling_rate(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "sampling_rate", value)


if not MYPY:
    class ResponseHeadersPolicyStrictTransportSecurityArgsDict(TypedDict):
        """
        Determines whether CloudFront includes the ``Strict-Transport-Security`` HTTP response header and the header's value.
         For more information about the ``Strict-Transport-Security`` HTTP response header, see [Strict-Transport-Security](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security) in the MDN Web Docs.
        """
        access_control_max_age_sec: pulumi.Input[builtins.int]
        """
        A number that CloudFront uses as the value for the ``max-age`` directive in the ``Strict-Transport-Security`` HTTP response header.
        """
        override: pulumi.Input[builtins.bool]
        """
        A Boolean that determines whether CloudFront overrides the ``Strict-Transport-Security`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        include_subdomains: NotRequired[pulumi.Input[builtins.bool]]
        """
        A Boolean that determines whether CloudFront includes the ``includeSubDomains`` directive in the ``Strict-Transport-Security`` HTTP response header.
        """
        preload: NotRequired[pulumi.Input[builtins.bool]]
        """
        A Boolean that determines whether CloudFront includes the ``preload`` directive in the ``Strict-Transport-Security`` HTTP response header.
        """
elif False:
    ResponseHeadersPolicyStrictTransportSecurityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponseHeadersPolicyStrictTransportSecurityArgs:
    def __init__(__self__, *,
                 access_control_max_age_sec: pulumi.Input[builtins.int],
                 override: pulumi.Input[builtins.bool],
                 include_subdomains: Optional[pulumi.Input[builtins.bool]] = None,
                 preload: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Determines whether CloudFront includes the ``Strict-Transport-Security`` HTTP response header and the header's value.
         For more information about the ``Strict-Transport-Security`` HTTP response header, see [Strict-Transport-Security](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security) in the MDN Web Docs.
        :param pulumi.Input[builtins.int] access_control_max_age_sec: A number that CloudFront uses as the value for the ``max-age`` directive in the ``Strict-Transport-Security`` HTTP response header.
        :param pulumi.Input[builtins.bool] override: A Boolean that determines whether CloudFront overrides the ``Strict-Transport-Security`` HTTP response header received from the origin with the one specified in this response headers policy.
        :param pulumi.Input[builtins.bool] include_subdomains: A Boolean that determines whether CloudFront includes the ``includeSubDomains`` directive in the ``Strict-Transport-Security`` HTTP response header.
        :param pulumi.Input[builtins.bool] preload: A Boolean that determines whether CloudFront includes the ``preload`` directive in the ``Strict-Transport-Security`` HTTP response header.
        """
        pulumi.set(__self__, "access_control_max_age_sec", access_control_max_age_sec)
        pulumi.set(__self__, "override", override)
        if include_subdomains is not None:
            pulumi.set(__self__, "include_subdomains", include_subdomains)
        if preload is not None:
            pulumi.set(__self__, "preload", preload)

    @property
    @pulumi.getter(name="accessControlMaxAgeSec")
    def access_control_max_age_sec(self) -> pulumi.Input[builtins.int]:
        """
        A number that CloudFront uses as the value for the ``max-age`` directive in the ``Strict-Transport-Security`` HTTP response header.
        """
        return pulumi.get(self, "access_control_max_age_sec")

    @access_control_max_age_sec.setter
    def access_control_max_age_sec(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "access_control_max_age_sec", value)

    @property
    @pulumi.getter
    def override(self) -> pulumi.Input[builtins.bool]:
        """
        A Boolean that determines whether CloudFront overrides the ``Strict-Transport-Security`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        return pulumi.get(self, "override")

    @override.setter
    def override(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "override", value)

    @property
    @pulumi.getter(name="includeSubdomains")
    def include_subdomains(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A Boolean that determines whether CloudFront includes the ``includeSubDomains`` directive in the ``Strict-Transport-Security`` HTTP response header.
        """
        return pulumi.get(self, "include_subdomains")

    @include_subdomains.setter
    def include_subdomains(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "include_subdomains", value)

    @property
    @pulumi.getter
    def preload(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A Boolean that determines whether CloudFront includes the ``preload`` directive in the ``Strict-Transport-Security`` HTTP response header.
        """
        return pulumi.get(self, "preload")

    @preload.setter
    def preload(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "preload", value)


if not MYPY:
    class ResponseHeadersPolicyXssProtectionArgsDict(TypedDict):
        """
        Determines whether CloudFront includes the ``X-XSS-Protection`` HTTP response header and the header's value.
         For more information about the ``X-XSS-Protection`` HTTP response header, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        """
        override: pulumi.Input[builtins.bool]
        """
        A Boolean that determines whether CloudFront overrides the ``X-XSS-Protection`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        protection: pulumi.Input[builtins.bool]
        """
        A Boolean that determines the value of the ``X-XSS-Protection`` HTTP response header. When this setting is ``true``, the value of the ``X-XSS-Protection`` header is ``1``. When this setting is ``false``, the value of the ``X-XSS-Protection`` header is ``0``.
         For more information about these settings, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        """
        mode_block: NotRequired[pulumi.Input[builtins.bool]]
        """
        A Boolean that determines whether CloudFront includes the ``mode=block`` directive in the ``X-XSS-Protection`` header.
         For more information about this directive, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        """
        report_uri: NotRequired[pulumi.Input[builtins.str]]
        """
        A reporting URI, which CloudFront uses as the value of the ``report`` directive in the ``X-XSS-Protection`` header.
         You cannot specify a ``ReportUri`` when ``ModeBlock`` is ``true``.
         For more information about using a reporting URL, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        """
elif False:
    ResponseHeadersPolicyXssProtectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponseHeadersPolicyXssProtectionArgs:
    def __init__(__self__, *,
                 override: pulumi.Input[builtins.bool],
                 protection: pulumi.Input[builtins.bool],
                 mode_block: Optional[pulumi.Input[builtins.bool]] = None,
                 report_uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        Determines whether CloudFront includes the ``X-XSS-Protection`` HTTP response header and the header's value.
         For more information about the ``X-XSS-Protection`` HTTP response header, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        :param pulumi.Input[builtins.bool] override: A Boolean that determines whether CloudFront overrides the ``X-XSS-Protection`` HTTP response header received from the origin with the one specified in this response headers policy.
        :param pulumi.Input[builtins.bool] protection: A Boolean that determines the value of the ``X-XSS-Protection`` HTTP response header. When this setting is ``true``, the value of the ``X-XSS-Protection`` header is ``1``. When this setting is ``false``, the value of the ``X-XSS-Protection`` header is ``0``.
                For more information about these settings, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        :param pulumi.Input[builtins.bool] mode_block: A Boolean that determines whether CloudFront includes the ``mode=block`` directive in the ``X-XSS-Protection`` header.
                For more information about this directive, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        :param pulumi.Input[builtins.str] report_uri: A reporting URI, which CloudFront uses as the value of the ``report`` directive in the ``X-XSS-Protection`` header.
                You cannot specify a ``ReportUri`` when ``ModeBlock`` is ``true``.
                For more information about using a reporting URL, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        """
        pulumi.set(__self__, "override", override)
        pulumi.set(__self__, "protection", protection)
        if mode_block is not None:
            pulumi.set(__self__, "mode_block", mode_block)
        if report_uri is not None:
            pulumi.set(__self__, "report_uri", report_uri)

    @property
    @pulumi.getter
    def override(self) -> pulumi.Input[builtins.bool]:
        """
        A Boolean that determines whether CloudFront overrides the ``X-XSS-Protection`` HTTP response header received from the origin with the one specified in this response headers policy.
        """
        return pulumi.get(self, "override")

    @override.setter
    def override(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "override", value)

    @property
    @pulumi.getter
    def protection(self) -> pulumi.Input[builtins.bool]:
        """
        A Boolean that determines the value of the ``X-XSS-Protection`` HTTP response header. When this setting is ``true``, the value of the ``X-XSS-Protection`` header is ``1``. When this setting is ``false``, the value of the ``X-XSS-Protection`` header is ``0``.
         For more information about these settings, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        """
        return pulumi.get(self, "protection")

    @protection.setter
    def protection(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "protection", value)

    @property
    @pulumi.getter(name="modeBlock")
    def mode_block(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A Boolean that determines whether CloudFront includes the ``mode=block`` directive in the ``X-XSS-Protection`` header.
         For more information about this directive, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        """
        return pulumi.get(self, "mode_block")

    @mode_block.setter
    def mode_block(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "mode_block", value)

    @property
    @pulumi.getter(name="reportUri")
    def report_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A reporting URI, which CloudFront uses as the value of the ``report`` directive in the ``X-XSS-Protection`` header.
         You cannot specify a ``ReportUri`` when ``ModeBlock`` is ``true``.
         For more information about using a reporting URL, see [X-XSS-Protection](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
        """
        return pulumi.get(self, "report_uri")

    @report_uri.setter
    def report_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "report_uri", value)


if not MYPY:
    class VpcOriginEndpointConfigArgsDict(TypedDict):
        """
        An Amazon CloudFront VPC origin endpoint configuration.
        """
        arn: pulumi.Input[builtins.str]
        """
        The ARN of the CloudFront VPC origin endpoint configuration.
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the CloudFront VPC origin endpoint configuration.
        """
        http_port: NotRequired[pulumi.Input[builtins.int]]
        """
        The HTTP port for the CloudFront VPC origin endpoint configuration. The default value is ``80``.
        """
        https_port: NotRequired[pulumi.Input[builtins.int]]
        """
        The HTTPS port of the CloudFront VPC origin endpoint configuration. The default value is ``443``.
        """
        origin_protocol_policy: NotRequired[pulumi.Input[builtins.str]]
        """
        The origin protocol policy for the CloudFront VPC origin endpoint configuration.
        """
        origin_ssl_protocols: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS. Valid values include ``SSLv3``, ``TLSv1``, ``TLSv1.1``, and ``TLSv1.2``.
         For more information, see [Minimum Origin SSL Protocol](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols) in the *Amazon CloudFront Developer Guide*.
        """
elif False:
    VpcOriginEndpointConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VpcOriginEndpointConfigArgs:
    def __init__(__self__, *,
                 arn: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 http_port: Optional[pulumi.Input[builtins.int]] = None,
                 https_port: Optional[pulumi.Input[builtins.int]] = None,
                 origin_protocol_policy: Optional[pulumi.Input[builtins.str]] = None,
                 origin_ssl_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        An Amazon CloudFront VPC origin endpoint configuration.
        :param pulumi.Input[builtins.str] arn: The ARN of the CloudFront VPC origin endpoint configuration.
        :param pulumi.Input[builtins.str] name: The name of the CloudFront VPC origin endpoint configuration.
        :param pulumi.Input[builtins.int] http_port: The HTTP port for the CloudFront VPC origin endpoint configuration. The default value is ``80``.
        :param pulumi.Input[builtins.int] https_port: The HTTPS port of the CloudFront VPC origin endpoint configuration. The default value is ``443``.
        :param pulumi.Input[builtins.str] origin_protocol_policy: The origin protocol policy for the CloudFront VPC origin endpoint configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] origin_ssl_protocols: Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS. Valid values include ``SSLv3``, ``TLSv1``, ``TLSv1.1``, and ``TLSv1.2``.
                For more information, see [Minimum Origin SSL Protocol](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols) in the *Amazon CloudFront Developer Guide*.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "name", name)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if https_port is not None:
            pulumi.set(__self__, "https_port", https_port)
        if origin_protocol_policy is not None:
            pulumi.set(__self__, "origin_protocol_policy", origin_protocol_policy)
        if origin_ssl_protocols is not None:
            pulumi.set(__self__, "origin_ssl_protocols", origin_ssl_protocols)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the CloudFront VPC origin endpoint configuration.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the CloudFront VPC origin endpoint configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The HTTP port for the CloudFront VPC origin endpoint configuration. The default value is ``80``.
        """
        return pulumi.get(self, "http_port")

    @http_port.setter
    def http_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "http_port", value)

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The HTTPS port of the CloudFront VPC origin endpoint configuration. The default value is ``443``.
        """
        return pulumi.get(self, "https_port")

    @https_port.setter
    def https_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "https_port", value)

    @property
    @pulumi.getter(name="originProtocolPolicy")
    def origin_protocol_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The origin protocol policy for the CloudFront VPC origin endpoint configuration.
        """
        return pulumi.get(self, "origin_protocol_policy")

    @origin_protocol_policy.setter
    def origin_protocol_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "origin_protocol_policy", value)

    @property
    @pulumi.getter(name="originSslProtocols")
    def origin_ssl_protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS. Valid values include ``SSLv3``, ``TLSv1``, ``TLSv1.1``, and ``TLSv1.2``.
         For more information, see [Minimum Origin SSL Protocol](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_ssl_protocols")

    @origin_ssl_protocols.setter
    def origin_ssl_protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "origin_ssl_protocols", value)


