# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ResourceVersionArgs', 'ResourceVersion']

@pulumi.input_type
class ResourceVersionArgs:
    def __init__(__self__, *,
                 schema_handler_package: pulumi.Input[builtins.str],
                 type_name: pulumi.Input[builtins.str],
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 logging_config: Optional[pulumi.Input['ResourceVersionLoggingConfigArgs']] = None):
        """
        The set of arguments for constructing a ResourceVersion resource.
        :param pulumi.Input[builtins.str] schema_handler_package: A url to the S3 bucket containing the schema handler package that contains the schema, event handlers, and associated files for the type you want to register.
               
               For information on generating a schema handler package for the type you want to register, see submit in the CloudFormation CLI User Guide.
        :param pulumi.Input[builtins.str] type_name: The name of the type being registered.
               
               We recommend that type names adhere to the following pattern: company_or_organization::service::type.
        :param pulumi.Input[builtins.str] execution_role_arn: The Amazon Resource Name (ARN) of the IAM execution role to use to register the type. If your resource type calls AWS APIs in any of its handlers, you must create an IAM execution role that includes the necessary permissions to call those AWS APIs, and provision that execution role in your account. CloudFormation then assumes that execution role to provide your resource type with the appropriate credentials.
        :param pulumi.Input['ResourceVersionLoggingConfigArgs'] logging_config: Specifies logging configuration information for a type.
        """
        pulumi.set(__self__, "schema_handler_package", schema_handler_package)
        pulumi.set(__self__, "type_name", type_name)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)

    @property
    @pulumi.getter(name="schemaHandlerPackage")
    def schema_handler_package(self) -> pulumi.Input[builtins.str]:
        """
        A url to the S3 bucket containing the schema handler package that contains the schema, event handlers, and associated files for the type you want to register.

        For information on generating a schema handler package for the type you want to register, see submit in the CloudFormation CLI User Guide.
        """
        return pulumi.get(self, "schema_handler_package")

    @schema_handler_package.setter
    def schema_handler_package(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "schema_handler_package", value)

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the type being registered.

        We recommend that type names adhere to the following pattern: company_or_organization::service::type.
        """
        return pulumi.get(self, "type_name")

    @type_name.setter
    def type_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type_name", value)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the IAM execution role to use to register the type. If your resource type calls AWS APIs in any of its handlers, you must create an IAM execution role that includes the necessary permissions to call those AWS APIs, and provision that execution role in your account. CloudFormation then assumes that execution role to provide your resource type with the appropriate credentials.
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['ResourceVersionLoggingConfigArgs']]:
        """
        Specifies logging configuration information for a type.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['ResourceVersionLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)


@pulumi.type_token("aws-native:cloudformation:ResourceVersion")
class ResourceVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 logging_config: Optional[pulumi.Input[Union['ResourceVersionLoggingConfigArgs', 'ResourceVersionLoggingConfigArgsDict']]] = None,
                 schema_handler_package: Optional[pulumi.Input[builtins.str]] = None,
                 type_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A resource that has been registered in the CloudFormation Registry.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        resource_version = aws_native.cloudformation.ResourceVersion("resourceVersion",
            type_name="My::Sample::Resource",
            schema_handler_package="s3://my-sample-resourceversion-bucket/my-sample-resource.zip")
        resource_default_version = aws_native.cloudformation.ResourceDefaultVersion("resourceDefaultVersion", type_version_arn=resource_version.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        resource_version = aws_native.cloudformation.ResourceVersion("resourceVersion",
            type_name="My::Sample::Resource",
            schema_handler_package="s3://my-sample-resourceversion-bucket/my-sample-resource.zip")
        resource_default_version = aws_native.cloudformation.ResourceDefaultVersion("resourceDefaultVersion", type_version_arn=resource_version.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        resource_version = aws_native.cloudformation.ResourceVersion("resourceVersion",
            type_name="My::Sample::Resource",
            schema_handler_package="s3://my-sample-resourceversion-bucket/my-sample-resource.zip")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        resource_version = aws_native.cloudformation.ResourceVersion("resourceVersion",
            type_name="My::Sample::Resource",
            schema_handler_package="s3://my-sample-resourceversion-bucket/my-sample-resource.zip")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        resource_version = aws_native.cloudformation.ResourceVersion("resourceVersion",
            type_name="My::Sample::Resource",
            schema_handler_package="s3://my-sample-resourceversion-bucket/my-sample-resource.zip")
        resource_default_version = aws_native.cloudformation.ResourceDefaultVersion("resourceDefaultVersion", type_version_arn=resource_version.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        resource_version = aws_native.cloudformation.ResourceVersion("resourceVersion",
            type_name="My::Sample::Resource",
            schema_handler_package="s3://my-sample-resourceversion-bucket/my-sample-resource.zip")
        resource_default_version = aws_native.cloudformation.ResourceDefaultVersion("resourceDefaultVersion", type_version_arn=resource_version.id)

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] execution_role_arn: The Amazon Resource Name (ARN) of the IAM execution role to use to register the type. If your resource type calls AWS APIs in any of its handlers, you must create an IAM execution role that includes the necessary permissions to call those AWS APIs, and provision that execution role in your account. CloudFormation then assumes that execution role to provide your resource type with the appropriate credentials.
        :param pulumi.Input[Union['ResourceVersionLoggingConfigArgs', 'ResourceVersionLoggingConfigArgsDict']] logging_config: Specifies logging configuration information for a type.
        :param pulumi.Input[builtins.str] schema_handler_package: A url to the S3 bucket containing the schema handler package that contains the schema, event handlers, and associated files for the type you want to register.
               
               For information on generating a schema handler package for the type you want to register, see submit in the CloudFormation CLI User Guide.
        :param pulumi.Input[builtins.str] type_name: The name of the type being registered.
               
               We recommend that type names adhere to the following pattern: company_or_organization::service::type.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResourceVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A resource that has been registered in the CloudFormation Registry.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        resource_version = aws_native.cloudformation.ResourceVersion("resourceVersion",
            type_name="My::Sample::Resource",
            schema_handler_package="s3://my-sample-resourceversion-bucket/my-sample-resource.zip")
        resource_default_version = aws_native.cloudformation.ResourceDefaultVersion("resourceDefaultVersion", type_version_arn=resource_version.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        resource_version = aws_native.cloudformation.ResourceVersion("resourceVersion",
            type_name="My::Sample::Resource",
            schema_handler_package="s3://my-sample-resourceversion-bucket/my-sample-resource.zip")
        resource_default_version = aws_native.cloudformation.ResourceDefaultVersion("resourceDefaultVersion", type_version_arn=resource_version.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        resource_version = aws_native.cloudformation.ResourceVersion("resourceVersion",
            type_name="My::Sample::Resource",
            schema_handler_package="s3://my-sample-resourceversion-bucket/my-sample-resource.zip")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        resource_version = aws_native.cloudformation.ResourceVersion("resourceVersion",
            type_name="My::Sample::Resource",
            schema_handler_package="s3://my-sample-resourceversion-bucket/my-sample-resource.zip")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        resource_version = aws_native.cloudformation.ResourceVersion("resourceVersion",
            type_name="My::Sample::Resource",
            schema_handler_package="s3://my-sample-resourceversion-bucket/my-sample-resource.zip")
        resource_default_version = aws_native.cloudformation.ResourceDefaultVersion("resourceDefaultVersion", type_version_arn=resource_version.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        resource_version = aws_native.cloudformation.ResourceVersion("resourceVersion",
            type_name="My::Sample::Resource",
            schema_handler_package="s3://my-sample-resourceversion-bucket/my-sample-resource.zip")
        resource_default_version = aws_native.cloudformation.ResourceDefaultVersion("resourceDefaultVersion", type_version_arn=resource_version.id)

        ```

        :param str resource_name: The name of the resource.
        :param ResourceVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 logging_config: Optional[pulumi.Input[Union['ResourceVersionLoggingConfigArgs', 'ResourceVersionLoggingConfigArgsDict']]] = None,
                 schema_handler_package: Optional[pulumi.Input[builtins.str]] = None,
                 type_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceVersionArgs.__new__(ResourceVersionArgs)

            __props__.__dict__["execution_role_arn"] = execution_role_arn
            __props__.__dict__["logging_config"] = logging_config
            if schema_handler_package is None and not opts.urn:
                raise TypeError("Missing required property 'schema_handler_package'")
            __props__.__dict__["schema_handler_package"] = schema_handler_package
            if type_name is None and not opts.urn:
                raise TypeError("Missing required property 'type_name'")
            __props__.__dict__["type_name"] = type_name
            __props__.__dict__["arn"] = None
            __props__.__dict__["is_default_version"] = None
            __props__.__dict__["provisioning_type"] = None
            __props__.__dict__["type_arn"] = None
            __props__.__dict__["version_id"] = None
            __props__.__dict__["visibility"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["executionRoleArn", "loggingConfig", "schemaHandlerPackage", "typeName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ResourceVersion, __self__).__init__(
            'aws-native:cloudformation:ResourceVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ResourceVersion':
        """
        Get an existing ResourceVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ResourceVersionArgs.__new__(ResourceVersionArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["execution_role_arn"] = None
        __props__.__dict__["is_default_version"] = None
        __props__.__dict__["logging_config"] = None
        __props__.__dict__["provisioning_type"] = None
        __props__.__dict__["schema_handler_package"] = None
        __props__.__dict__["type_arn"] = None
        __props__.__dict__["type_name"] = None
        __props__.__dict__["version_id"] = None
        __props__.__dict__["visibility"] = None
        return ResourceVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the type, here the ResourceVersion. This is used to uniquely identify a ResourceVersion resource
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the IAM execution role to use to register the type. If your resource type calls AWS APIs in any of its handlers, you must create an IAM execution role that includes the necessary permissions to call those AWS APIs, and provision that execution role in your account. CloudFormation then assumes that execution role to provide your resource type with the appropriate credentials.
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter(name="isDefaultVersion")
    def is_default_version(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates if this type version is the current default version
        """
        return pulumi.get(self, "is_default_version")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> pulumi.Output[Optional['outputs.ResourceVersionLoggingConfig']]:
        """
        Specifies logging configuration information for a type.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter(name="provisioningType")
    def provisioning_type(self) -> pulumi.Output['ResourceVersionProvisioningType']:
        """
        The provisioning behavior of the type. AWS CloudFormation determines the provisioning type during registration, based on the types of handlers in the schema handler package submitted.
        """
        return pulumi.get(self, "provisioning_type")

    @property
    @pulumi.getter(name="schemaHandlerPackage")
    def schema_handler_package(self) -> pulumi.Output[builtins.str]:
        """
        A url to the S3 bucket containing the schema handler package that contains the schema, event handlers, and associated files for the type you want to register.

        For information on generating a schema handler package for the type you want to register, see submit in the CloudFormation CLI User Guide.
        """
        return pulumi.get(self, "schema_handler_package")

    @property
    @pulumi.getter(name="typeArn")
    def type_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the type without the versionID.
        """
        return pulumi.get(self, "type_arn")

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the type being registered.

        We recommend that type names adhere to the following pattern: company_or_organization::service::type.
        """
        return pulumi.get(self, "type_name")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the version of the type represented by this resource instance.
        """
        return pulumi.get(self, "version_id")

    @property
    @pulumi.getter
    def visibility(self) -> pulumi.Output['ResourceVersionVisibility']:
        """
        The scope at which the type is visible and usable in CloudFormation operations.

        Valid values include:

        PRIVATE: The type is only visible and usable within the account in which it is registered. Currently, AWS CloudFormation marks any types you register as PRIVATE.

        PUBLIC: The type is publically visible and usable within any Amazon account.
        """
        return pulumi.get(self, "visibility")

