# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GuardHookS3Location',
    'HookVersionLoggingConfig',
    'LambdaHookHookTarget',
    'ManagedExecutionProperties',
    'OptionsProperties',
    'ResourceVersionLoggingConfig',
    'StackFiltersProperties',
    'StackFiltersPropertiesStackNamesProperties',
    'StackFiltersPropertiesStackRolesProperties',
    'StackOutput',
    'StackSetAutoDeployment',
    'StackSetDeploymentTargets',
    'StackSetOperationPreferences',
    'StackSetParameter',
    'StackSetStackInstances',
    'TargetFilters0Properties',
    'TargetFilters1Properties',
    'TypeActivationLoggingConfig',
]

@pulumi.output_type
class GuardHookS3Location(dict):
    """
    S3 Source Location for the Guard files.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "versionId":
            suggest = "version_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuardHookS3Location. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuardHookS3Location.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuardHookS3Location.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 uri: builtins.str,
                 version_id: Optional[builtins.str] = None):
        """
        S3 Source Location for the Guard files.
        :param builtins.str uri: S3 uri of Guard files.
        :param builtins.str version_id: S3 object version
        """
        pulumi.set(__self__, "uri", uri)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        S3 uri of Guard files.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[builtins.str]:
        """
        S3 object version
        """
        return pulumi.get(self, "version_id")


@pulumi.output_type
class HookVersionLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupName":
            suggest = "log_group_name"
        elif key == "logRoleArn":
            suggest = "log_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HookVersionLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HookVersionLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HookVersionLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_name: Optional[builtins.str] = None,
                 log_role_arn: Optional[builtins.str] = None):
        """
        :param builtins.str log_group_name: The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        :param builtins.str log_role_arn: The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
        if log_group_name is not None:
            pulumi.set(__self__, "log_group_name", log_group_name)
        if log_role_arn is not None:
            pulumi.set(__self__, "log_role_arn", log_role_arn)

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> Optional[builtins.str]:
        """
        The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        """
        return pulumi.get(self, "log_group_name")

    @property
    @pulumi.getter(name="logRoleArn")
    def log_role_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
        return pulumi.get(self, "log_role_arn")


@pulumi.output_type
class LambdaHookHookTarget(dict):
    """
    Hook targets are the destination where hooks will be invoked against.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "invocationPoint":
            suggest = "invocation_point"
        elif key == "targetName":
            suggest = "target_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LambdaHookHookTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LambdaHookHookTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LambdaHookHookTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: 'LambdaHookAction',
                 invocation_point: 'LambdaHookInvocationPoint',
                 target_name: builtins.str):
        """
        Hook targets are the destination where hooks will be invoked against.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "invocation_point", invocation_point)
        pulumi.set(__self__, "target_name", target_name)

    @property
    @pulumi.getter
    def action(self) -> 'LambdaHookAction':
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="invocationPoint")
    def invocation_point(self) -> 'LambdaHookInvocationPoint':
        return pulumi.get(self, "invocation_point")

    @property
    @pulumi.getter(name="targetName")
    def target_name(self) -> builtins.str:
        return pulumi.get(self, "target_name")


@pulumi.output_type
class ManagedExecutionProperties(dict):
    """
    Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
    """
    def __init__(__self__, *,
                 active: Optional[builtins.bool] = None):
        """
        Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
        :param builtins.bool active: When `true` , StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order.
               
               > If there are already running or queued operations, StackSets queues all incoming operations even if they are non-conflicting.
               > 
               > You can't modify your stack set's execution configuration while there are running or queued operations for that stack set. 
               
               When `false` (default), StackSets performs one operation at a time in request order.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)

    @property
    @pulumi.getter
    def active(self) -> Optional[builtins.bool]:
        """
        When `true` , StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order.

        > If there are already running or queued operations, StackSets queues all incoming operations even if they are non-conflicting.
        > 
        > You can't modify your stack set's execution configuration while there are running or queued operations for that stack set. 

        When `false` (default), StackSets performs one operation at a time in request order.
        """
        return pulumi.get(self, "active")


@pulumi.output_type
class OptionsProperties(dict):
    """
    Specifies the S3 location of your input parameters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputParams":
            suggest = "input_params"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OptionsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OptionsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OptionsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_params: Optional['outputs.GuardHookS3Location'] = None):
        """
        Specifies the S3 location of your input parameters.
        :param 'GuardHookS3Location' input_params: Specifies the S3 location where your input parameters are located.
        """
        if input_params is not None:
            pulumi.set(__self__, "input_params", input_params)

    @property
    @pulumi.getter(name="inputParams")
    def input_params(self) -> Optional['outputs.GuardHookS3Location']:
        """
        Specifies the S3 location where your input parameters are located.
        """
        return pulumi.get(self, "input_params")


@pulumi.output_type
class ResourceVersionLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupName":
            suggest = "log_group_name"
        elif key == "logRoleArn":
            suggest = "log_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceVersionLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceVersionLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceVersionLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_name: Optional[builtins.str] = None,
                 log_role_arn: Optional[builtins.str] = None):
        """
        :param builtins.str log_group_name: The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        :param builtins.str log_role_arn: The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
        if log_group_name is not None:
            pulumi.set(__self__, "log_group_name", log_group_name)
        if log_role_arn is not None:
            pulumi.set(__self__, "log_role_arn", log_role_arn)

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> Optional[builtins.str]:
        """
        The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        """
        return pulumi.get(self, "log_group_name")

    @property
    @pulumi.getter(name="logRoleArn")
    def log_role_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
        return pulumi.get(self, "log_role_arn")


@pulumi.output_type
class StackFiltersProperties(dict):
    """
    Filters to allow hooks to target specific stack attributes
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filteringCriteria":
            suggest = "filtering_criteria"
        elif key == "stackNames":
            suggest = "stack_names"
        elif key == "stackRoles":
            suggest = "stack_roles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackFiltersProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackFiltersProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackFiltersProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filtering_criteria: 'LambdaHookStackFiltersPropertiesFilteringCriteria',
                 stack_names: Optional['outputs.StackFiltersPropertiesStackNamesProperties'] = None,
                 stack_roles: Optional['outputs.StackFiltersPropertiesStackRolesProperties'] = None):
        """
        Filters to allow hooks to target specific stack attributes
        :param 'LambdaHookStackFiltersPropertiesFilteringCriteria' filtering_criteria: Attribute to specify the filtering behavior. ANY will make the Hook pass if one filter matches. ALL will make the Hook pass if all filters match
        :param 'StackFiltersPropertiesStackNamesProperties' stack_names: List of stack names as filters
        :param 'StackFiltersPropertiesStackRolesProperties' stack_roles: List of stack roles that are performing the stack operations.
        """
        pulumi.set(__self__, "filtering_criteria", filtering_criteria)
        if stack_names is not None:
            pulumi.set(__self__, "stack_names", stack_names)
        if stack_roles is not None:
            pulumi.set(__self__, "stack_roles", stack_roles)

    @property
    @pulumi.getter(name="filteringCriteria")
    def filtering_criteria(self) -> 'LambdaHookStackFiltersPropertiesFilteringCriteria':
        """
        Attribute to specify the filtering behavior. ANY will make the Hook pass if one filter matches. ALL will make the Hook pass if all filters match
        """
        return pulumi.get(self, "filtering_criteria")

    @property
    @pulumi.getter(name="stackNames")
    def stack_names(self) -> Optional['outputs.StackFiltersPropertiesStackNamesProperties']:
        """
        List of stack names as filters
        """
        return pulumi.get(self, "stack_names")

    @property
    @pulumi.getter(name="stackRoles")
    def stack_roles(self) -> Optional['outputs.StackFiltersPropertiesStackRolesProperties']:
        """
        List of stack roles that are performing the stack operations.
        """
        return pulumi.get(self, "stack_roles")


@pulumi.output_type
class StackFiltersPropertiesStackNamesProperties(dict):
    """
    List of stack names as filters
    """
    def __init__(__self__, *,
                 exclude: Optional[Sequence[builtins.str]] = None,
                 include: Optional[Sequence[builtins.str]] = None):
        """
        List of stack names as filters
        :param Sequence[builtins.str] exclude: List of stack names that the hook is going to be excluded from
        :param Sequence[builtins.str] include: List of stack names that the hook is going to target
        """
        if exclude is not None:
            pulumi.set(__self__, "exclude", exclude)
        if include is not None:
            pulumi.set(__self__, "include", include)

    @property
    @pulumi.getter
    def exclude(self) -> Optional[Sequence[builtins.str]]:
        """
        List of stack names that the hook is going to be excluded from
        """
        return pulumi.get(self, "exclude")

    @property
    @pulumi.getter
    def include(self) -> Optional[Sequence[builtins.str]]:
        """
        List of stack names that the hook is going to target
        """
        return pulumi.get(self, "include")


@pulumi.output_type
class StackFiltersPropertiesStackRolesProperties(dict):
    """
    List of stack roles that are performing the stack operations.
    """
    def __init__(__self__, *,
                 exclude: Optional[Sequence[builtins.str]] = None,
                 include: Optional[Sequence[builtins.str]] = None):
        """
        List of stack roles that are performing the stack operations.
        :param Sequence[builtins.str] exclude: List of stack roles that the hook is going to be excluded from
        :param Sequence[builtins.str] include: List of stack roles that the hook is going to target
        """
        if exclude is not None:
            pulumi.set(__self__, "exclude", exclude)
        if include is not None:
            pulumi.set(__self__, "include", include)

    @property
    @pulumi.getter
    def exclude(self) -> Optional[Sequence[builtins.str]]:
        """
        List of stack roles that the hook is going to be excluded from
        """
        return pulumi.get(self, "exclude")

    @property
    @pulumi.getter
    def include(self) -> Optional[Sequence[builtins.str]]:
        """
        List of stack roles that the hook is going to target
        """
        return pulumi.get(self, "include")


@pulumi.output_type
class StackOutput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exportName":
            suggest = "export_name"
        elif key == "outputKey":
            suggest = "output_key"
        elif key == "outputValue":
            suggest = "output_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[builtins.str] = None,
                 export_name: Optional[builtins.str] = None,
                 output_key: Optional[builtins.str] = None,
                 output_value: Optional[builtins.str] = None):
        """
        :param builtins.str description: User defined description associated with the output.
        :param builtins.str export_name: The name of the export associated with the output.
        :param builtins.str output_key: The key associated with the output.
        :param builtins.str output_value: The value associated with the output.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if export_name is not None:
            pulumi.set(__self__, "export_name", export_name)
        if output_key is not None:
            pulumi.set(__self__, "output_key", output_key)
        if output_value is not None:
            pulumi.set(__self__, "output_value", output_value)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        User defined description associated with the output.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="exportName")
    def export_name(self) -> Optional[builtins.str]:
        """
        The name of the export associated with the output.
        """
        return pulumi.get(self, "export_name")

    @property
    @pulumi.getter(name="outputKey")
    def output_key(self) -> Optional[builtins.str]:
        """
        The key associated with the output.
        """
        return pulumi.get(self, "output_key")

    @property
    @pulumi.getter(name="outputValue")
    def output_value(self) -> Optional[builtins.str]:
        """
        The value associated with the output.
        """
        return pulumi.get(self, "output_value")


@pulumi.output_type
class StackSetAutoDeployment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retainStacksOnAccountRemoval":
            suggest = "retain_stacks_on_account_removal"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackSetAutoDeployment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackSetAutoDeployment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackSetAutoDeployment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 retain_stacks_on_account_removal: Optional[builtins.bool] = None):
        """
        :param builtins.bool enabled: If set to true, StackSets automatically deploys additional stack instances to AWS Organizations accounts that are added to a target organization or organizational unit (OU) in the specified Regions. If an account is removed from a target organization or OU, StackSets deletes stack instances from the account in the specified Regions.
        :param builtins.bool retain_stacks_on_account_removal: If set to true, stack resources are retained when an account is removed from a target organization or OU. If set to false, stack resources are deleted. Specify only if Enabled is set to True.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if retain_stacks_on_account_removal is not None:
            pulumi.set(__self__, "retain_stacks_on_account_removal", retain_stacks_on_account_removal)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        If set to true, StackSets automatically deploys additional stack instances to AWS Organizations accounts that are added to a target organization or organizational unit (OU) in the specified Regions. If an account is removed from a target organization or OU, StackSets deletes stack instances from the account in the specified Regions.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="retainStacksOnAccountRemoval")
    def retain_stacks_on_account_removal(self) -> Optional[builtins.bool]:
        """
        If set to true, stack resources are retained when an account is removed from a target organization or OU. If set to false, stack resources are deleted. Specify only if Enabled is set to True.
        """
        return pulumi.get(self, "retain_stacks_on_account_removal")


@pulumi.output_type
class StackSetDeploymentTargets(dict):
    """
     The AWS OrganizationalUnitIds or Accounts for which to create stack instances in the specified Regions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountFilterType":
            suggest = "account_filter_type"
        elif key == "accountsUrl":
            suggest = "accounts_url"
        elif key == "organizationalUnitIds":
            suggest = "organizational_unit_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackSetDeploymentTargets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackSetDeploymentTargets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackSetDeploymentTargets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_filter_type: Optional['StackSetDeploymentTargetsAccountFilterType'] = None,
                 accounts: Optional[Sequence[builtins.str]] = None,
                 accounts_url: Optional[builtins.str] = None,
                 organizational_unit_ids: Optional[Sequence[builtins.str]] = None):
        """
         The AWS OrganizationalUnitIds or Accounts for which to create stack instances in the specified Regions.
        :param 'StackSetDeploymentTargetsAccountFilterType' account_filter_type: The filter type you want to apply on organizational units and accounts.
        :param Sequence[builtins.str] accounts: AWS accounts that you want to create stack instances in the specified Region(s) for.
        :param builtins.str accounts_url: Returns the value of the AccountsUrl property.
        :param Sequence[builtins.str] organizational_unit_ids: The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
        """
        if account_filter_type is not None:
            pulumi.set(__self__, "account_filter_type", account_filter_type)
        if accounts is not None:
            pulumi.set(__self__, "accounts", accounts)
        if accounts_url is not None:
            pulumi.set(__self__, "accounts_url", accounts_url)
        if organizational_unit_ids is not None:
            pulumi.set(__self__, "organizational_unit_ids", organizational_unit_ids)

    @property
    @pulumi.getter(name="accountFilterType")
    def account_filter_type(self) -> Optional['StackSetDeploymentTargetsAccountFilterType']:
        """
        The filter type you want to apply on organizational units and accounts.
        """
        return pulumi.get(self, "account_filter_type")

    @property
    @pulumi.getter
    def accounts(self) -> Optional[Sequence[builtins.str]]:
        """
        AWS accounts that you want to create stack instances in the specified Region(s) for.
        """
        return pulumi.get(self, "accounts")

    @property
    @pulumi.getter(name="accountsUrl")
    def accounts_url(self) -> Optional[builtins.str]:
        """
        Returns the value of the AccountsUrl property.
        """
        return pulumi.get(self, "accounts_url")

    @property
    @pulumi.getter(name="organizationalUnitIds")
    def organizational_unit_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
        """
        return pulumi.get(self, "organizational_unit_ids")


@pulumi.output_type
class StackSetOperationPreferences(dict):
    """
    The user-specified preferences for how AWS CloudFormation performs a stack set operation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "concurrencyMode":
            suggest = "concurrency_mode"
        elif key == "failureToleranceCount":
            suggest = "failure_tolerance_count"
        elif key == "failureTolerancePercentage":
            suggest = "failure_tolerance_percentage"
        elif key == "maxConcurrentCount":
            suggest = "max_concurrent_count"
        elif key == "maxConcurrentPercentage":
            suggest = "max_concurrent_percentage"
        elif key == "regionConcurrencyType":
            suggest = "region_concurrency_type"
        elif key == "regionOrder":
            suggest = "region_order"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackSetOperationPreferences. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackSetOperationPreferences.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackSetOperationPreferences.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 concurrency_mode: Optional['StackSetConcurrencyMode'] = None,
                 failure_tolerance_count: Optional[builtins.int] = None,
                 failure_tolerance_percentage: Optional[builtins.int] = None,
                 max_concurrent_count: Optional[builtins.int] = None,
                 max_concurrent_percentage: Optional[builtins.int] = None,
                 region_concurrency_type: Optional['StackSetRegionConcurrencyType'] = None,
                 region_order: Optional[Sequence[builtins.str]] = None):
        """
        The user-specified preferences for how AWS CloudFormation performs a stack set operation.
        :param 'StackSetConcurrencyMode' concurrency_mode: Specifies how the concurrency level behaves during the operation execution.
               
               - `STRICT_FAILURE_TOLERANCE` : This option dynamically lowers the concurrency level to ensure the number of failed accounts never exceeds the value of `FailureToleranceCount` +1. The initial actual concurrency is set to the lower of either the value of the `MaxConcurrentCount` , or the value of `FailureToleranceCount` +1. The actual concurrency is then reduced proportionally by the number of failures. This is the default behavior.
               
               If failure tolerance or Maximum concurrent accounts are set to percentages, the behavior is similar.
               - `SOFT_FAILURE_TOLERANCE` : This option decouples `FailureToleranceCount` from the actual concurrency. This allows stack set operations to run at the concurrency level set by the `MaxConcurrentCount` value, or `MaxConcurrentPercentage` , regardless of the number of failures.
        :param builtins.int failure_tolerance_count: The number of accounts, per Region, for which this operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.
               
               Conditional: You must specify either `FailureToleranceCount` or `FailureTolerancePercentage` (but not both).
        :param builtins.int failure_tolerance_percentage: The percentage of accounts, per Region, for which this stack operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.
               
               When calculating the number of accounts based on the specified percentage, CloudFormation rounds *down* to the next whole number.
               
               Conditional: You must specify either `FailureToleranceCount` or `FailureTolerancePercentage` , but not both.
        :param builtins.int max_concurrent_count: The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `FailureToleranceCount` . `MaxConcurrentCount` is at most one more than the `FailureToleranceCount` .
               
               Note that this setting lets you specify the *maximum* for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
               
               Conditional: You must specify either `MaxConcurrentCount` or `MaxConcurrentPercentage` , but not both.
        :param builtins.int max_concurrent_percentage: The maximum percentage of accounts in which to perform this operation at one time.
               
               When calculating the number of accounts based on the specified percentage, CloudFormation rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, CloudFormation sets the number as one instead.
               
               Note that this setting lets you specify the *maximum* for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
               
               Conditional: You must specify either `MaxConcurrentCount` or `MaxConcurrentPercentage` , but not both.
        :param 'StackSetRegionConcurrencyType' region_concurrency_type: The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.
        :param Sequence[builtins.str] region_order: The order of the Regions where you want to perform the stack operation.
        """
        if concurrency_mode is not None:
            pulumi.set(__self__, "concurrency_mode", concurrency_mode)
        if failure_tolerance_count is not None:
            pulumi.set(__self__, "failure_tolerance_count", failure_tolerance_count)
        if failure_tolerance_percentage is not None:
            pulumi.set(__self__, "failure_tolerance_percentage", failure_tolerance_percentage)
        if max_concurrent_count is not None:
            pulumi.set(__self__, "max_concurrent_count", max_concurrent_count)
        if max_concurrent_percentage is not None:
            pulumi.set(__self__, "max_concurrent_percentage", max_concurrent_percentage)
        if region_concurrency_type is not None:
            pulumi.set(__self__, "region_concurrency_type", region_concurrency_type)
        if region_order is not None:
            pulumi.set(__self__, "region_order", region_order)

    @property
    @pulumi.getter(name="concurrencyMode")
    def concurrency_mode(self) -> Optional['StackSetConcurrencyMode']:
        """
        Specifies how the concurrency level behaves during the operation execution.

        - `STRICT_FAILURE_TOLERANCE` : This option dynamically lowers the concurrency level to ensure the number of failed accounts never exceeds the value of `FailureToleranceCount` +1. The initial actual concurrency is set to the lower of either the value of the `MaxConcurrentCount` , or the value of `FailureToleranceCount` +1. The actual concurrency is then reduced proportionally by the number of failures. This is the default behavior.

        If failure tolerance or Maximum concurrent accounts are set to percentages, the behavior is similar.
        - `SOFT_FAILURE_TOLERANCE` : This option decouples `FailureToleranceCount` from the actual concurrency. This allows stack set operations to run at the concurrency level set by the `MaxConcurrentCount` value, or `MaxConcurrentPercentage` , regardless of the number of failures.
        """
        return pulumi.get(self, "concurrency_mode")

    @property
    @pulumi.getter(name="failureToleranceCount")
    def failure_tolerance_count(self) -> Optional[builtins.int]:
        """
        The number of accounts, per Region, for which this operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.

        Conditional: You must specify either `FailureToleranceCount` or `FailureTolerancePercentage` (but not both).
        """
        return pulumi.get(self, "failure_tolerance_count")

    @property
    @pulumi.getter(name="failureTolerancePercentage")
    def failure_tolerance_percentage(self) -> Optional[builtins.int]:
        """
        The percentage of accounts, per Region, for which this stack operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.

        When calculating the number of accounts based on the specified percentage, CloudFormation rounds *down* to the next whole number.

        Conditional: You must specify either `FailureToleranceCount` or `FailureTolerancePercentage` , but not both.
        """
        return pulumi.get(self, "failure_tolerance_percentage")

    @property
    @pulumi.getter(name="maxConcurrentCount")
    def max_concurrent_count(self) -> Optional[builtins.int]:
        """
        The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `FailureToleranceCount` . `MaxConcurrentCount` is at most one more than the `FailureToleranceCount` .

        Note that this setting lets you specify the *maximum* for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.

        Conditional: You must specify either `MaxConcurrentCount` or `MaxConcurrentPercentage` , but not both.
        """
        return pulumi.get(self, "max_concurrent_count")

    @property
    @pulumi.getter(name="maxConcurrentPercentage")
    def max_concurrent_percentage(self) -> Optional[builtins.int]:
        """
        The maximum percentage of accounts in which to perform this operation at one time.

        When calculating the number of accounts based on the specified percentage, CloudFormation rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, CloudFormation sets the number as one instead.

        Note that this setting lets you specify the *maximum* for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.

        Conditional: You must specify either `MaxConcurrentCount` or `MaxConcurrentPercentage` , but not both.
        """
        return pulumi.get(self, "max_concurrent_percentage")

    @property
    @pulumi.getter(name="regionConcurrencyType")
    def region_concurrency_type(self) -> Optional['StackSetRegionConcurrencyType']:
        """
        The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.
        """
        return pulumi.get(self, "region_concurrency_type")

    @property
    @pulumi.getter(name="regionOrder")
    def region_order(self) -> Optional[Sequence[builtins.str]]:
        """
        The order of the Regions where you want to perform the stack operation.
        """
        return pulumi.get(self, "region_order")


@pulumi.output_type
class StackSetParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterKey":
            suggest = "parameter_key"
        elif key == "parameterValue":
            suggest = "parameter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackSetParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackSetParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackSetParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameter_key: builtins.str,
                 parameter_value: builtins.str):
        """
        :param builtins.str parameter_key: The key associated with the parameter. If you don't specify a key and value for a particular parameter, AWS CloudFormation uses the default value that is specified in your template.
        :param builtins.str parameter_value: The input value associated with the parameter.
        """
        pulumi.set(__self__, "parameter_key", parameter_key)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="parameterKey")
    def parameter_key(self) -> builtins.str:
        """
        The key associated with the parameter. If you don't specify a key and value for a particular parameter, AWS CloudFormation uses the default value that is specified in your template.
        """
        return pulumi.get(self, "parameter_key")

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> builtins.str:
        """
        The input value associated with the parameter.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class StackSetStackInstances(dict):
    """
    Stack instances in some specific accounts and Regions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentTargets":
            suggest = "deployment_targets"
        elif key == "parameterOverrides":
            suggest = "parameter_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackSetStackInstances. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackSetStackInstances.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackSetStackInstances.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployment_targets: 'outputs.StackSetDeploymentTargets',
                 regions: Sequence[builtins.str],
                 parameter_overrides: Optional[Sequence['outputs.StackSetParameter']] = None):
        """
        Stack instances in some specific accounts and Regions.
        :param 'StackSetDeploymentTargets' deployment_targets: The AWS `OrganizationalUnitIds` or `Accounts` for which to create stack instances in the specified Regions.
        :param Sequence[builtins.str] regions: The names of one or more Regions where you want to create stack instances using the specified AWS account(s).
        :param Sequence['StackSetParameter'] parameter_overrides: A list of stack set parameters whose values you want to override in the selected stack instances.
        """
        pulumi.set(__self__, "deployment_targets", deployment_targets)
        pulumi.set(__self__, "regions", regions)
        if parameter_overrides is not None:
            pulumi.set(__self__, "parameter_overrides", parameter_overrides)

    @property
    @pulumi.getter(name="deploymentTargets")
    def deployment_targets(self) -> 'outputs.StackSetDeploymentTargets':
        """
        The AWS `OrganizationalUnitIds` or `Accounts` for which to create stack instances in the specified Regions.
        """
        return pulumi.get(self, "deployment_targets")

    @property
    @pulumi.getter
    def regions(self) -> Sequence[builtins.str]:
        """
        The names of one or more Regions where you want to create stack instances using the specified AWS account(s).
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="parameterOverrides")
    def parameter_overrides(self) -> Optional[Sequence['outputs.StackSetParameter']]:
        """
        A list of stack set parameters whose values you want to override in the selected stack instances.
        """
        return pulumi.get(self, "parameter_overrides")


@pulumi.output_type
class TargetFilters0Properties(dict):
    """
    Attribute to specify which targets should invoke the hook
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "invocationPoints":
            suggest = "invocation_points"
        elif key == "targetNames":
            suggest = "target_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetFilters0Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetFilters0Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetFilters0Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Optional[Sequence['LambdaHookAction']] = None,
                 invocation_points: Optional[Sequence['LambdaHookInvocationPoint']] = None,
                 target_names: Optional[Sequence[builtins.str]] = None):
        """
        Attribute to specify which targets should invoke the hook
        :param Sequence['LambdaHookAction'] actions: List of actions that the hook is going to target
        :param Sequence['LambdaHookInvocationPoint'] invocation_points: List of invocation points that the hook is going to target
        :param Sequence[builtins.str] target_names: List of type names that the hook is going to target
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if invocation_points is not None:
            pulumi.set(__self__, "invocation_points", invocation_points)
        if target_names is not None:
            pulumi.set(__self__, "target_names", target_names)

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence['LambdaHookAction']]:
        """
        List of actions that the hook is going to target
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="invocationPoints")
    def invocation_points(self) -> Optional[Sequence['LambdaHookInvocationPoint']]:
        """
        List of invocation points that the hook is going to target
        """
        return pulumi.get(self, "invocation_points")

    @property
    @pulumi.getter(name="targetNames")
    def target_names(self) -> Optional[Sequence[builtins.str]]:
        """
        List of type names that the hook is going to target
        """
        return pulumi.get(self, "target_names")


@pulumi.output_type
class TargetFilters1Properties(dict):
    """
    Attribute to specify which targets should invoke the hook
    """
    def __init__(__self__, *,
                 targets: Sequence['outputs.LambdaHookHookTarget']):
        """
        Attribute to specify which targets should invoke the hook
        :param Sequence['LambdaHookHookTarget'] targets: List of hook targets
        """
        pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter
    def targets(self) -> Sequence['outputs.LambdaHookHookTarget']:
        """
        List of hook targets
        """
        return pulumi.get(self, "targets")


@pulumi.output_type
class TypeActivationLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupName":
            suggest = "log_group_name"
        elif key == "logRoleArn":
            suggest = "log_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TypeActivationLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TypeActivationLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TypeActivationLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_name: Optional[builtins.str] = None,
                 log_role_arn: Optional[builtins.str] = None):
        """
        :param builtins.str log_group_name: The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        :param builtins.str log_role_arn: The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
        if log_group_name is not None:
            pulumi.set(__self__, "log_group_name", log_group_name)
        if log_role_arn is not None:
            pulumi.set(__self__, "log_role_arn", log_role_arn)

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> Optional[builtins.str]:
        """
        The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        """
        return pulumi.get(self, "log_group_name")

    @property
    @pulumi.getter(name="logRoleArn")
    def log_role_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
        return pulumi.get(self, "log_role_arn")


