# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['LambdaHookArgs', 'LambdaHook']

@pulumi.input_type
class LambdaHookArgs:
    def __init__(__self__, *,
                 alias: pulumi.Input[builtins.str],
                 execution_role: pulumi.Input[builtins.str],
                 failure_mode: pulumi.Input['LambdaHookFailureMode'],
                 hook_status: pulumi.Input['LambdaHookHookStatus'],
                 lambda_function: pulumi.Input[builtins.str],
                 target_operations: pulumi.Input[Sequence[pulumi.Input['LambdaHookTargetOperation']]],
                 stack_filters: Optional[pulumi.Input['StackFiltersPropertiesArgs']] = None,
                 target_filters: Optional[pulumi.Input[Union['TargetFilters0PropertiesArgs', 'TargetFilters1PropertiesArgs']]] = None):
        """
        The set of arguments for constructing a LambdaHook resource.
        :param pulumi.Input[builtins.str] alias: The typename alias for the hook.
        :param pulumi.Input[builtins.str] execution_role: The execution role ARN assumed by Hooks to invoke Lambda.
        :param pulumi.Input['LambdaHookFailureMode'] failure_mode: Attribute to specify CloudFormation behavior on hook failure.
        :param pulumi.Input['LambdaHookHookStatus'] hook_status: Attribute to specify which stacks this hook applies to or should get invoked for
        :param pulumi.Input[builtins.str] lambda_function: Amazon Resource Name (ARN), Partial ARN, name, version, or alias of the Lambda function to invoke with this hook.
        :param pulumi.Input[Sequence[pulumi.Input['LambdaHookTargetOperation']]] target_operations: Which operations should this Hook run against? Resource changes, stacks or change sets.
        :param pulumi.Input['StackFiltersPropertiesArgs'] stack_filters: Filters to allow hooks to target specific stack attributes
        :param pulumi.Input[Union['TargetFilters0PropertiesArgs', 'TargetFilters1PropertiesArgs']] target_filters: Attribute to specify which targets should invoke the hook
        """
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "execution_role", execution_role)
        pulumi.set(__self__, "failure_mode", failure_mode)
        pulumi.set(__self__, "hook_status", hook_status)
        pulumi.set(__self__, "lambda_function", lambda_function)
        pulumi.set(__self__, "target_operations", target_operations)
        if stack_filters is not None:
            pulumi.set(__self__, "stack_filters", stack_filters)
        if target_filters is not None:
            pulumi.set(__self__, "target_filters", target_filters)

    @property
    @pulumi.getter
    def alias(self) -> pulumi.Input[builtins.str]:
        """
        The typename alias for the hook.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> pulumi.Input[builtins.str]:
        """
        The execution role ARN assumed by Hooks to invoke Lambda.
        """
        return pulumi.get(self, "execution_role")

    @execution_role.setter
    def execution_role(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "execution_role", value)

    @property
    @pulumi.getter(name="failureMode")
    def failure_mode(self) -> pulumi.Input['LambdaHookFailureMode']:
        """
        Attribute to specify CloudFormation behavior on hook failure.
        """
        return pulumi.get(self, "failure_mode")

    @failure_mode.setter
    def failure_mode(self, value: pulumi.Input['LambdaHookFailureMode']):
        pulumi.set(self, "failure_mode", value)

    @property
    @pulumi.getter(name="hookStatus")
    def hook_status(self) -> pulumi.Input['LambdaHookHookStatus']:
        """
        Attribute to specify which stacks this hook applies to or should get invoked for
        """
        return pulumi.get(self, "hook_status")

    @hook_status.setter
    def hook_status(self, value: pulumi.Input['LambdaHookHookStatus']):
        pulumi.set(self, "hook_status", value)

    @property
    @pulumi.getter(name="lambdaFunction")
    def lambda_function(self) -> pulumi.Input[builtins.str]:
        """
        Amazon Resource Name (ARN), Partial ARN, name, version, or alias of the Lambda function to invoke with this hook.
        """
        return pulumi.get(self, "lambda_function")

    @lambda_function.setter
    def lambda_function(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "lambda_function", value)

    @property
    @pulumi.getter(name="targetOperations")
    def target_operations(self) -> pulumi.Input[Sequence[pulumi.Input['LambdaHookTargetOperation']]]:
        """
        Which operations should this Hook run against? Resource changes, stacks or change sets.
        """
        return pulumi.get(self, "target_operations")

    @target_operations.setter
    def target_operations(self, value: pulumi.Input[Sequence[pulumi.Input['LambdaHookTargetOperation']]]):
        pulumi.set(self, "target_operations", value)

    @property
    @pulumi.getter(name="stackFilters")
    def stack_filters(self) -> Optional[pulumi.Input['StackFiltersPropertiesArgs']]:
        """
        Filters to allow hooks to target specific stack attributes
        """
        return pulumi.get(self, "stack_filters")

    @stack_filters.setter
    def stack_filters(self, value: Optional[pulumi.Input['StackFiltersPropertiesArgs']]):
        pulumi.set(self, "stack_filters", value)

    @property
    @pulumi.getter(name="targetFilters")
    def target_filters(self) -> Optional[pulumi.Input[Union['TargetFilters0PropertiesArgs', 'TargetFilters1PropertiesArgs']]]:
        """
        Attribute to specify which targets should invoke the hook
        """
        return pulumi.get(self, "target_filters")

    @target_filters.setter
    def target_filters(self, value: Optional[pulumi.Input[Union['TargetFilters0PropertiesArgs', 'TargetFilters1PropertiesArgs']]]):
        pulumi.set(self, "target_filters", value)


@pulumi.type_token("aws-native:cloudformation:LambdaHook")
class LambdaHook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[builtins.str]] = None,
                 execution_role: Optional[pulumi.Input[builtins.str]] = None,
                 failure_mode: Optional[pulumi.Input['LambdaHookFailureMode']] = None,
                 hook_status: Optional[pulumi.Input['LambdaHookHookStatus']] = None,
                 lambda_function: Optional[pulumi.Input[builtins.str]] = None,
                 stack_filters: Optional[pulumi.Input[Union['StackFiltersPropertiesArgs', 'StackFiltersPropertiesArgsDict']]] = None,
                 target_filters: Optional[pulumi.Input[Union[Union['TargetFilters0PropertiesArgs', 'TargetFilters0PropertiesArgsDict'], Union['TargetFilters1PropertiesArgs', 'TargetFilters1PropertiesArgsDict']]]] = None,
                 target_operations: Optional[pulumi.Input[Sequence[pulumi.Input['LambdaHookTargetOperation']]]] = None,
                 __props__=None):
        """
        This is a CloudFormation resource for the first-party AWS::Hooks::LambdaHook.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] alias: The typename alias for the hook.
        :param pulumi.Input[builtins.str] execution_role: The execution role ARN assumed by Hooks to invoke Lambda.
        :param pulumi.Input['LambdaHookFailureMode'] failure_mode: Attribute to specify CloudFormation behavior on hook failure.
        :param pulumi.Input['LambdaHookHookStatus'] hook_status: Attribute to specify which stacks this hook applies to or should get invoked for
        :param pulumi.Input[builtins.str] lambda_function: Amazon Resource Name (ARN), Partial ARN, name, version, or alias of the Lambda function to invoke with this hook.
        :param pulumi.Input[Union['StackFiltersPropertiesArgs', 'StackFiltersPropertiesArgsDict']] stack_filters: Filters to allow hooks to target specific stack attributes
        :param pulumi.Input[Union[Union['TargetFilters0PropertiesArgs', 'TargetFilters0PropertiesArgsDict'], Union['TargetFilters1PropertiesArgs', 'TargetFilters1PropertiesArgsDict']]] target_filters: Attribute to specify which targets should invoke the hook
        :param pulumi.Input[Sequence[pulumi.Input['LambdaHookTargetOperation']]] target_operations: Which operations should this Hook run against? Resource changes, stacks or change sets.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LambdaHookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This is a CloudFormation resource for the first-party AWS::Hooks::LambdaHook.

        :param str resource_name: The name of the resource.
        :param LambdaHookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LambdaHookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[builtins.str]] = None,
                 execution_role: Optional[pulumi.Input[builtins.str]] = None,
                 failure_mode: Optional[pulumi.Input['LambdaHookFailureMode']] = None,
                 hook_status: Optional[pulumi.Input['LambdaHookHookStatus']] = None,
                 lambda_function: Optional[pulumi.Input[builtins.str]] = None,
                 stack_filters: Optional[pulumi.Input[Union['StackFiltersPropertiesArgs', 'StackFiltersPropertiesArgsDict']]] = None,
                 target_filters: Optional[pulumi.Input[Union[Union['TargetFilters0PropertiesArgs', 'TargetFilters0PropertiesArgsDict'], Union['TargetFilters1PropertiesArgs', 'TargetFilters1PropertiesArgsDict']]]] = None,
                 target_operations: Optional[pulumi.Input[Sequence[pulumi.Input['LambdaHookTargetOperation']]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LambdaHookArgs.__new__(LambdaHookArgs)

            if alias is None and not opts.urn:
                raise TypeError("Missing required property 'alias'")
            __props__.__dict__["alias"] = alias
            if execution_role is None and not opts.urn:
                raise TypeError("Missing required property 'execution_role'")
            __props__.__dict__["execution_role"] = execution_role
            if failure_mode is None and not opts.urn:
                raise TypeError("Missing required property 'failure_mode'")
            __props__.__dict__["failure_mode"] = failure_mode
            if hook_status is None and not opts.urn:
                raise TypeError("Missing required property 'hook_status'")
            __props__.__dict__["hook_status"] = hook_status
            if lambda_function is None and not opts.urn:
                raise TypeError("Missing required property 'lambda_function'")
            __props__.__dict__["lambda_function"] = lambda_function
            __props__.__dict__["stack_filters"] = stack_filters
            __props__.__dict__["target_filters"] = target_filters
            if target_operations is None and not opts.urn:
                raise TypeError("Missing required property 'target_operations'")
            __props__.__dict__["target_operations"] = target_operations
            __props__.__dict__["hook_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["alias"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(LambdaHook, __self__).__init__(
            'aws-native:cloudformation:LambdaHook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'LambdaHook':
        """
        Get an existing LambdaHook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = LambdaHookArgs.__new__(LambdaHookArgs)

        __props__.__dict__["alias"] = None
        __props__.__dict__["execution_role"] = None
        __props__.__dict__["failure_mode"] = None
        __props__.__dict__["hook_arn"] = None
        __props__.__dict__["hook_status"] = None
        __props__.__dict__["lambda_function"] = None
        __props__.__dict__["stack_filters"] = None
        __props__.__dict__["target_filters"] = None
        __props__.__dict__["target_operations"] = None
        return LambdaHook(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def alias(self) -> pulumi.Output[builtins.str]:
        """
        The typename alias for the hook.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> pulumi.Output[builtins.str]:
        """
        The execution role ARN assumed by Hooks to invoke Lambda.
        """
        return pulumi.get(self, "execution_role")

    @property
    @pulumi.getter(name="failureMode")
    def failure_mode(self) -> pulumi.Output['LambdaHookFailureMode']:
        """
        Attribute to specify CloudFormation behavior on hook failure.
        """
        return pulumi.get(self, "failure_mode")

    @property
    @pulumi.getter(name="hookArn")
    def hook_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the activated hook
        """
        return pulumi.get(self, "hook_arn")

    @property
    @pulumi.getter(name="hookStatus")
    def hook_status(self) -> pulumi.Output['LambdaHookHookStatus']:
        """
        Attribute to specify which stacks this hook applies to or should get invoked for
        """
        return pulumi.get(self, "hook_status")

    @property
    @pulumi.getter(name="lambdaFunction")
    def lambda_function(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN), Partial ARN, name, version, or alias of the Lambda function to invoke with this hook.
        """
        return pulumi.get(self, "lambda_function")

    @property
    @pulumi.getter(name="stackFilters")
    def stack_filters(self) -> pulumi.Output[Optional['outputs.StackFiltersProperties']]:
        """
        Filters to allow hooks to target specific stack attributes
        """
        return pulumi.get(self, "stack_filters")

    @property
    @pulumi.getter(name="targetFilters")
    def target_filters(self) -> pulumi.Output[Optional[Any]]:
        """
        Attribute to specify which targets should invoke the hook
        """
        return pulumi.get(self, "target_filters")

    @property
    @pulumi.getter(name="targetOperations")
    def target_operations(self) -> pulumi.Output[Sequence['LambdaHookTargetOperation']]:
        """
        Which operations should this Hook run against? Resource changes, stacks or change sets.
        """
        return pulumi.get(self, "target_operations")

