# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetLambdaHookResult',
    'AwaitableGetLambdaHookResult',
    'get_lambda_hook',
    'get_lambda_hook_output',
]

@pulumi.output_type
class GetLambdaHookResult:
    def __init__(__self__, execution_role=None, failure_mode=None, hook_arn=None, hook_status=None, lambda_function=None, stack_filters=None, target_filters=None, target_operations=None):
        if execution_role and not isinstance(execution_role, str):
            raise TypeError("Expected argument 'execution_role' to be a str")
        pulumi.set(__self__, "execution_role", execution_role)
        if failure_mode and not isinstance(failure_mode, str):
            raise TypeError("Expected argument 'failure_mode' to be a str")
        pulumi.set(__self__, "failure_mode", failure_mode)
        if hook_arn and not isinstance(hook_arn, str):
            raise TypeError("Expected argument 'hook_arn' to be a str")
        pulumi.set(__self__, "hook_arn", hook_arn)
        if hook_status and not isinstance(hook_status, str):
            raise TypeError("Expected argument 'hook_status' to be a str")
        pulumi.set(__self__, "hook_status", hook_status)
        if lambda_function and not isinstance(lambda_function, str):
            raise TypeError("Expected argument 'lambda_function' to be a str")
        pulumi.set(__self__, "lambda_function", lambda_function)
        if stack_filters and not isinstance(stack_filters, dict):
            raise TypeError("Expected argument 'stack_filters' to be a dict")
        pulumi.set(__self__, "stack_filters", stack_filters)
        if target_filters and not isinstance(target_filters, dict):
            raise TypeError("Expected argument 'target_filters' to be a dict")
        pulumi.set(__self__, "target_filters", target_filters)
        if target_operations and not isinstance(target_operations, list):
            raise TypeError("Expected argument 'target_operations' to be a list")
        pulumi.set(__self__, "target_operations", target_operations)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> Optional[builtins.str]:
        """
        The execution role ARN assumed by Hooks to invoke Lambda.
        """
        return pulumi.get(self, "execution_role")

    @property
    @pulumi.getter(name="failureMode")
    def failure_mode(self) -> Optional['LambdaHookFailureMode']:
        """
        Attribute to specify CloudFormation behavior on hook failure.
        """
        return pulumi.get(self, "failure_mode")

    @property
    @pulumi.getter(name="hookArn")
    def hook_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the activated hook
        """
        return pulumi.get(self, "hook_arn")

    @property
    @pulumi.getter(name="hookStatus")
    def hook_status(self) -> Optional['LambdaHookHookStatus']:
        """
        Attribute to specify which stacks this hook applies to or should get invoked for
        """
        return pulumi.get(self, "hook_status")

    @property
    @pulumi.getter(name="lambdaFunction")
    def lambda_function(self) -> Optional[builtins.str]:
        """
        Amazon Resource Name (ARN), Partial ARN, name, version, or alias of the Lambda function to invoke with this hook.
        """
        return pulumi.get(self, "lambda_function")

    @property
    @pulumi.getter(name="stackFilters")
    def stack_filters(self) -> Optional['outputs.StackFiltersProperties']:
        """
        Filters to allow hooks to target specific stack attributes
        """
        return pulumi.get(self, "stack_filters")

    @property
    @pulumi.getter(name="targetFilters")
    def target_filters(self) -> Optional[Any]:
        """
        Attribute to specify which targets should invoke the hook
        """
        return pulumi.get(self, "target_filters")

    @property
    @pulumi.getter(name="targetOperations")
    def target_operations(self) -> Optional[Sequence['LambdaHookTargetOperation']]:
        """
        Which operations should this Hook run against? Resource changes, stacks or change sets.
        """
        return pulumi.get(self, "target_operations")


class AwaitableGetLambdaHookResult(GetLambdaHookResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLambdaHookResult(
            execution_role=self.execution_role,
            failure_mode=self.failure_mode,
            hook_arn=self.hook_arn,
            hook_status=self.hook_status,
            lambda_function=self.lambda_function,
            stack_filters=self.stack_filters,
            target_filters=self.target_filters,
            target_operations=self.target_operations)


def get_lambda_hook(hook_arn: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLambdaHookResult:
    """
    This is a CloudFormation resource for the first-party AWS::Hooks::LambdaHook.


    :param builtins.str hook_arn: The Amazon Resource Name (ARN) of the activated hook
    """
    __args__ = dict()
    __args__['hookArn'] = hook_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cloudformation:getLambdaHook', __args__, opts=opts, typ=GetLambdaHookResult).value

    return AwaitableGetLambdaHookResult(
        execution_role=pulumi.get(__ret__, 'execution_role'),
        failure_mode=pulumi.get(__ret__, 'failure_mode'),
        hook_arn=pulumi.get(__ret__, 'hook_arn'),
        hook_status=pulumi.get(__ret__, 'hook_status'),
        lambda_function=pulumi.get(__ret__, 'lambda_function'),
        stack_filters=pulumi.get(__ret__, 'stack_filters'),
        target_filters=pulumi.get(__ret__, 'target_filters'),
        target_operations=pulumi.get(__ret__, 'target_operations'))
def get_lambda_hook_output(hook_arn: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLambdaHookResult]:
    """
    This is a CloudFormation resource for the first-party AWS::Hooks::LambdaHook.


    :param builtins.str hook_arn: The Amazon Resource Name (ARN) of the activated hook
    """
    __args__ = dict()
    __args__['hookArn'] = hook_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cloudformation:getLambdaHook', __args__, opts=opts, typ=GetLambdaHookResult)
    return __ret__.apply(lambda __response__: GetLambdaHookResult(
        execution_role=pulumi.get(__response__, 'execution_role'),
        failure_mode=pulumi.get(__response__, 'failure_mode'),
        hook_arn=pulumi.get(__response__, 'hook_arn'),
        hook_status=pulumi.get(__response__, 'hook_status'),
        lambda_function=pulumi.get(__response__, 'lambda_function'),
        stack_filters=pulumi.get(__response__, 'stack_filters'),
        target_filters=pulumi.get(__response__, 'target_filters'),
        target_operations=pulumi.get(__response__, 'target_operations')))
