# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CustomResourceEmulatorArgs', 'CustomResourceEmulator']

@pulumi.input_type
class CustomResourceEmulatorArgs:
    def __init__(__self__, *,
                 bucket_key_prefix: pulumi.Input[builtins.str],
                 bucket_name: pulumi.Input[builtins.str],
                 custom_resource_properties: pulumi.Input[Mapping[str, Any]],
                 resource_type: pulumi.Input[builtins.str],
                 service_token: pulumi.Input[builtins.str],
                 stack_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CustomResourceEmulator resource.
        :param pulumi.Input[builtins.str] bucket_key_prefix: The prefix to use for the bucket key when storing the response from the Custom Resource provider.
        :param pulumi.Input[builtins.str] bucket_name: The name of the S3 bucket to use for storing the response from the Custom Resource.
               
               The IAM principal configured for the provider must have `s3:PutObject`, `s3:HeadObject` and `s3:GetObject` permissions on this bucket.
        :param pulumi.Input[Mapping[str, Any]] custom_resource_properties: The properties to pass as an input to the Custom Resource.
               The properties are passed as a map of key-value pairs whereas all primitive values (number, boolean) are converted to strings for CloudFormation interoperability.
        :param pulumi.Input[builtins.str] resource_type: The CloudFormation type of the Custom Resource. For example, `Custom::MyCustomResource`.
               This is required for CloudFormation interoperability.
        :param pulumi.Input[builtins.str] service_token: The service token to use for the Custom Resource. The service token is invoked when the resource is created, updated, or deleted.
               This can be a Lambda Function ARN with optional version or alias identifiers.
               
               The IAM principal configured for the provider must have `lambda:InvokeFunction` permissions on this service token.
        :param pulumi.Input[builtins.str] stack_id: A stand-in value for the CloudFormation stack ID. This is required for CloudFormation interoperability.
               If not provided, the Pulumi Stack ID is used.
        """
        pulumi.set(__self__, "bucket_key_prefix", bucket_key_prefix)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "custom_resource_properties", custom_resource_properties)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "service_token", service_token)
        if stack_id is not None:
            pulumi.set(__self__, "stack_id", stack_id)

    @property
    @pulumi.getter(name="bucketKeyPrefix")
    def bucket_key_prefix(self) -> pulumi.Input[builtins.str]:
        """
        The prefix to use for the bucket key when storing the response from the Custom Resource provider.
        """
        return pulumi.get(self, "bucket_key_prefix")

    @bucket_key_prefix.setter
    def bucket_key_prefix(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket_key_prefix", value)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the S3 bucket to use for storing the response from the Custom Resource.

        The IAM principal configured for the provider must have `s3:PutObject`, `s3:HeadObject` and `s3:GetObject` permissions on this bucket.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="customResourceProperties")
    def custom_resource_properties(self) -> pulumi.Input[Mapping[str, Any]]:
        """
        The properties to pass as an input to the Custom Resource.
        The properties are passed as a map of key-value pairs whereas all primitive values (number, boolean) are converted to strings for CloudFormation interoperability.
        """
        return pulumi.get(self, "custom_resource_properties")

    @custom_resource_properties.setter
    def custom_resource_properties(self, value: pulumi.Input[Mapping[str, Any]]):
        pulumi.set(self, "custom_resource_properties", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[builtins.str]:
        """
        The CloudFormation type of the Custom Resource. For example, `Custom::MyCustomResource`.
        This is required for CloudFormation interoperability.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="serviceToken")
    def service_token(self) -> pulumi.Input[builtins.str]:
        """
        The service token to use for the Custom Resource. The service token is invoked when the resource is created, updated, or deleted.
        This can be a Lambda Function ARN with optional version or alias identifiers.

        The IAM principal configured for the provider must have `lambda:InvokeFunction` permissions on this service token.
        """
        return pulumi.get(self, "service_token")

    @service_token.setter
    def service_token(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_token", value)

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A stand-in value for the CloudFormation stack ID. This is required for CloudFormation interoperability.
        If not provided, the Pulumi Stack ID is used.
        """
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stack_id", value)


@pulumi.type_token("aws-native:cloudformation:CustomResourceEmulator")
class CustomResourceEmulator(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_key_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 custom_resource_properties: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 service_token: Optional[pulumi.Input[builtins.str]] = None,
                 stack_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The Custom Resource Emulator allows you to use AWS CloudFormation Custom Resources directly in your Pulumi programs. It provides a way to invoke AWS Lambda functions that implement custom provisioning logic following the CloudFormation Custom Resource protocol.

        > **Note**: Currently, only Lambda-backed Custom Resources are supported. SNS-backed Custom Resources are not supported at this time.

        ## Example Usage

        A full example of creating a CloudFormation Custom Resource Lambda function and using it in Pulumi can be found [here](https://github.com/pulumi/pulumi-aws-native/tree/master/examples/cfn-custom-resource).

        ## About CloudFormation Custom Resources

        CloudFormation Custom Resources allow you to write custom provisioning logic for resources that aren't directly available as AWS CloudFormation resource types. Common use cases include:

        - Implementing complex provisioning logic
        - Performing custom validations or transformations
        - Integrating with third-party services
        - Implementing organization-specific infrastructure patterns

        For more information about CloudFormation Custom Resources, see [Custom Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-custom-resources.html) in the AWS CloudFormation User Guide.

        ## Permissions

        The IAM principal used by your Pulumi program must have the following permissions:

        1. `lambda:InvokeFunction` on the Lambda function specified in `serviceToken`
        2. S3 permissions on the bucket specified in `bucketName`:
           - `s3:PutObject`
           - `s3:GetObject`
           - `s3:HeadObject`

        ## Lambda Function Requirements

        The Lambda function specified in `serviceToken` must implement the CloudFormation Custom Resource lifecycle.
        For detailed information about implementing Lambda-backed Custom Resources, see [AWS Lambda-backed Custom Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-custom-resources-lambda.html) in the AWS CloudFormation User Guide.

        ## Timeouts

        Custom Resources have a default timeout of 60 minutes, matching the CloudFormation timeout for custom resource operations. You can customize it using the [`customTimeouts`](https://www.pulumi.com/docs/iac/concepts/options/customtimeouts/) resource option.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bucket_key_prefix: The prefix to use for the bucket key when storing the response from the Custom Resource provider.
        :param pulumi.Input[builtins.str] bucket_name: The name of the S3 bucket to use for storing the response from the Custom Resource.
               
               The IAM principal configured for the provider must have `s3:PutObject`, `s3:HeadObject` and `s3:GetObject` permissions on this bucket.
        :param pulumi.Input[Mapping[str, Any]] custom_resource_properties: The properties to pass as an input to the Custom Resource.
               The properties are passed as a map of key-value pairs whereas all primitive values (number, boolean) are converted to strings for CloudFormation interoperability.
        :param pulumi.Input[builtins.str] resource_type: The CloudFormation type of the Custom Resource. For example, `Custom::MyCustomResource`.
               This is required for CloudFormation interoperability.
        :param pulumi.Input[builtins.str] service_token: The service token to use for the Custom Resource. The service token is invoked when the resource is created, updated, or deleted.
               This can be a Lambda Function ARN with optional version or alias identifiers.
               
               The IAM principal configured for the provider must have `lambda:InvokeFunction` permissions on this service token.
        :param pulumi.Input[builtins.str] stack_id: A stand-in value for the CloudFormation stack ID. This is required for CloudFormation interoperability.
               If not provided, the Pulumi Stack ID is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomResourceEmulatorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Custom Resource Emulator allows you to use AWS CloudFormation Custom Resources directly in your Pulumi programs. It provides a way to invoke AWS Lambda functions that implement custom provisioning logic following the CloudFormation Custom Resource protocol.

        > **Note**: Currently, only Lambda-backed Custom Resources are supported. SNS-backed Custom Resources are not supported at this time.

        ## Example Usage

        A full example of creating a CloudFormation Custom Resource Lambda function and using it in Pulumi can be found [here](https://github.com/pulumi/pulumi-aws-native/tree/master/examples/cfn-custom-resource).

        ## About CloudFormation Custom Resources

        CloudFormation Custom Resources allow you to write custom provisioning logic for resources that aren't directly available as AWS CloudFormation resource types. Common use cases include:

        - Implementing complex provisioning logic
        - Performing custom validations or transformations
        - Integrating with third-party services
        - Implementing organization-specific infrastructure patterns

        For more information about CloudFormation Custom Resources, see [Custom Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-custom-resources.html) in the AWS CloudFormation User Guide.

        ## Permissions

        The IAM principal used by your Pulumi program must have the following permissions:

        1. `lambda:InvokeFunction` on the Lambda function specified in `serviceToken`
        2. S3 permissions on the bucket specified in `bucketName`:
           - `s3:PutObject`
           - `s3:GetObject`
           - `s3:HeadObject`

        ## Lambda Function Requirements

        The Lambda function specified in `serviceToken` must implement the CloudFormation Custom Resource lifecycle.
        For detailed information about implementing Lambda-backed Custom Resources, see [AWS Lambda-backed Custom Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-custom-resources-lambda.html) in the AWS CloudFormation User Guide.

        ## Timeouts

        Custom Resources have a default timeout of 60 minutes, matching the CloudFormation timeout for custom resource operations. You can customize it using the [`customTimeouts`](https://www.pulumi.com/docs/iac/concepts/options/customtimeouts/) resource option.

        :param str resource_name: The name of the resource.
        :param CustomResourceEmulatorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomResourceEmulatorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_key_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 custom_resource_properties: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 service_token: Optional[pulumi.Input[builtins.str]] = None,
                 stack_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomResourceEmulatorArgs.__new__(CustomResourceEmulatorArgs)

            if bucket_key_prefix is None and not opts.urn:
                raise TypeError("Missing required property 'bucket_key_prefix'")
            __props__.__dict__["bucket_key_prefix"] = bucket_key_prefix
            if bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 'bucket_name'")
            __props__.__dict__["bucket_name"] = bucket_name
            if custom_resource_properties is None and not opts.urn:
                raise TypeError("Missing required property 'custom_resource_properties'")
            __props__.__dict__["custom_resource_properties"] = custom_resource_properties
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            if service_token is None and not opts.urn:
                raise TypeError("Missing required property 'service_token'")
            __props__.__dict__["service_token"] = service_token
            __props__.__dict__["stack_id"] = stack_id
            __props__.__dict__["bucket"] = None
            __props__.__dict__["data"] = None
            __props__.__dict__["no_echo"] = None
            __props__.__dict__["physical_resource_id"] = None
        super(CustomResourceEmulator, __self__).__init__(
            'aws-native:cloudformation:CustomResourceEmulator',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'CustomResourceEmulator':
        """
        Get an existing CustomResourceEmulator resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CustomResourceEmulatorArgs.__new__(CustomResourceEmulatorArgs)

        __props__.__dict__["bucket"] = None
        __props__.__dict__["data"] = None
        __props__.__dict__["no_echo"] = None
        __props__.__dict__["physical_resource_id"] = None
        __props__.__dict__["resource_type"] = None
        __props__.__dict__["service_token"] = None
        __props__.__dict__["stack_id"] = None
        return CustomResourceEmulator(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[builtins.str]:
        """
        The name of the S3 bucket to use for storing the response from the Custom Resource.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def data(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        The response data returned by invoking the Custom Resource.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="noEcho")
    def no_echo(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the response data contains sensitive information that should be marked as secret and not logged.
        """
        return pulumi.get(self, "no_echo")

    @property
    @pulumi.getter(name="physicalResourceId")
    def physical_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The name or unique identifier that corresponds to the `PhysicalResourceId` included in the Custom Resource response. If no `PhysicalResourceId` is provided in the response, a random ID will be generated.
        """
        return pulumi.get(self, "physical_resource_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[builtins.str]:
        """
        The CloudFormation type of the Custom Resource provider. For example, `Custom::MyCustomResource`.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="serviceToken")
    def service_token(self) -> pulumi.Output[builtins.str]:
        """
        The service token, such as a Lambda function ARN, that is invoked when the resource is created, updated, or deleted.
        """
        return pulumi.get(self, "service_token")

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Output[builtins.str]:
        """
        A stand-in value for the CloudFormation stack ID.
        """
        return pulumi.get(self, "stack_id")

