# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GuardHookS3LocationArgs',
    'GuardHookS3LocationArgsDict',
    'HookVersionLoggingConfigArgs',
    'HookVersionLoggingConfigArgsDict',
    'LambdaHookHookTargetArgs',
    'LambdaHookHookTargetArgsDict',
    'ManagedExecutionPropertiesArgs',
    'ManagedExecutionPropertiesArgsDict',
    'OptionsPropertiesArgs',
    'OptionsPropertiesArgsDict',
    'ResourceVersionLoggingConfigArgs',
    'ResourceVersionLoggingConfigArgsDict',
    'StackFiltersPropertiesStackNamesPropertiesArgs',
    'StackFiltersPropertiesStackNamesPropertiesArgsDict',
    'StackFiltersPropertiesStackRolesPropertiesArgs',
    'StackFiltersPropertiesStackRolesPropertiesArgsDict',
    'StackFiltersPropertiesArgs',
    'StackFiltersPropertiesArgsDict',
    'StackSetAutoDeploymentArgs',
    'StackSetAutoDeploymentArgsDict',
    'StackSetDeploymentTargetsArgs',
    'StackSetDeploymentTargetsArgsDict',
    'StackSetOperationPreferencesArgs',
    'StackSetOperationPreferencesArgsDict',
    'StackSetParameterArgs',
    'StackSetParameterArgsDict',
    'StackSetStackInstancesArgs',
    'StackSetStackInstancesArgsDict',
    'TargetFilters0PropertiesArgs',
    'TargetFilters0PropertiesArgsDict',
    'TargetFilters1PropertiesArgs',
    'TargetFilters1PropertiesArgsDict',
    'TypeActivationLoggingConfigArgs',
    'TypeActivationLoggingConfigArgsDict',
]

MYPY = False

if not MYPY:
    class GuardHookS3LocationArgsDict(TypedDict):
        """
        S3 Source Location for the Guard files.
        """
        uri: pulumi.Input[builtins.str]
        """
        S3 uri of Guard files.
        """
        version_id: NotRequired[pulumi.Input[builtins.str]]
        """
        S3 object version
        """
elif False:
    GuardHookS3LocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GuardHookS3LocationArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[builtins.str],
                 version_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        S3 Source Location for the Guard files.
        :param pulumi.Input[builtins.str] uri: S3 uri of Guard files.
        :param pulumi.Input[builtins.str] version_id: S3 object version
        """
        pulumi.set(__self__, "uri", uri)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[builtins.str]:
        """
        S3 uri of Guard files.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        S3 object version
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version_id", value)


if not MYPY:
    class HookVersionLoggingConfigArgsDict(TypedDict):
        log_group_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        """
        log_role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
elif False:
    HookVersionLoggingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HookVersionLoggingConfigArgs:
    def __init__(__self__, *,
                 log_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 log_role_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] log_group_name: The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        :param pulumi.Input[builtins.str] log_role_arn: The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
        if log_group_name is not None:
            pulumi.set(__self__, "log_group_name", log_group_name)
        if log_role_arn is not None:
            pulumi.set(__self__, "log_role_arn", log_role_arn)

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        """
        return pulumi.get(self, "log_group_name")

    @log_group_name.setter
    def log_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_group_name", value)

    @property
    @pulumi.getter(name="logRoleArn")
    def log_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
        return pulumi.get(self, "log_role_arn")

    @log_role_arn.setter
    def log_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_role_arn", value)


if not MYPY:
    class LambdaHookHookTargetArgsDict(TypedDict):
        """
        Hook targets are the destination where hooks will be invoked against.
        """
        action: pulumi.Input['LambdaHookAction']
        invocation_point: pulumi.Input['LambdaHookInvocationPoint']
        target_name: pulumi.Input[builtins.str]
elif False:
    LambdaHookHookTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LambdaHookHookTargetArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['LambdaHookAction'],
                 invocation_point: pulumi.Input['LambdaHookInvocationPoint'],
                 target_name: pulumi.Input[builtins.str]):
        """
        Hook targets are the destination where hooks will be invoked against.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "invocation_point", invocation_point)
        pulumi.set(__self__, "target_name", target_name)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input['LambdaHookAction']:
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['LambdaHookAction']):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="invocationPoint")
    def invocation_point(self) -> pulumi.Input['LambdaHookInvocationPoint']:
        return pulumi.get(self, "invocation_point")

    @invocation_point.setter
    def invocation_point(self, value: pulumi.Input['LambdaHookInvocationPoint']):
        pulumi.set(self, "invocation_point", value)

    @property
    @pulumi.getter(name="targetName")
    def target_name(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "target_name")

    @target_name.setter
    def target_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_name", value)


if not MYPY:
    class ManagedExecutionPropertiesArgsDict(TypedDict):
        """
        Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
        """
        active: NotRequired[pulumi.Input[builtins.bool]]
        """
        When `true` , StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order.

        > If there are already running or queued operations, StackSets queues all incoming operations even if they are non-conflicting.
        > 
        > You can't modify your stack set's execution configuration while there are running or queued operations for that stack set. 

        When `false` (default), StackSets performs one operation at a time in request order.
        """
elif False:
    ManagedExecutionPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedExecutionPropertiesArgs:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
        :param pulumi.Input[builtins.bool] active: When `true` , StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order.
               
               > If there are already running or queued operations, StackSets queues all incoming operations even if they are non-conflicting.
               > 
               > You can't modify your stack set's execution configuration while there are running or queued operations for that stack set. 
               
               When `false` (default), StackSets performs one operation at a time in request order.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When `true` , StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order.

        > If there are already running or queued operations, StackSets queues all incoming operations even if they are non-conflicting.
        > 
        > You can't modify your stack set's execution configuration while there are running or queued operations for that stack set. 

        When `false` (default), StackSets performs one operation at a time in request order.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)


if not MYPY:
    class OptionsPropertiesArgsDict(TypedDict):
        """
        Specifies the S3 location of your input parameters.
        """
        input_params: NotRequired[pulumi.Input['GuardHookS3LocationArgsDict']]
        """
        Specifies the S3 location where your input parameters are located.
        """
elif False:
    OptionsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OptionsPropertiesArgs:
    def __init__(__self__, *,
                 input_params: Optional[pulumi.Input['GuardHookS3LocationArgs']] = None):
        """
        Specifies the S3 location of your input parameters.
        :param pulumi.Input['GuardHookS3LocationArgs'] input_params: Specifies the S3 location where your input parameters are located.
        """
        if input_params is not None:
            pulumi.set(__self__, "input_params", input_params)

    @property
    @pulumi.getter(name="inputParams")
    def input_params(self) -> Optional[pulumi.Input['GuardHookS3LocationArgs']]:
        """
        Specifies the S3 location where your input parameters are located.
        """
        return pulumi.get(self, "input_params")

    @input_params.setter
    def input_params(self, value: Optional[pulumi.Input['GuardHookS3LocationArgs']]):
        pulumi.set(self, "input_params", value)


if not MYPY:
    class ResourceVersionLoggingConfigArgsDict(TypedDict):
        log_group_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        """
        log_role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
elif False:
    ResourceVersionLoggingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceVersionLoggingConfigArgs:
    def __init__(__self__, *,
                 log_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 log_role_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] log_group_name: The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        :param pulumi.Input[builtins.str] log_role_arn: The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
        if log_group_name is not None:
            pulumi.set(__self__, "log_group_name", log_group_name)
        if log_role_arn is not None:
            pulumi.set(__self__, "log_role_arn", log_role_arn)

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        """
        return pulumi.get(self, "log_group_name")

    @log_group_name.setter
    def log_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_group_name", value)

    @property
    @pulumi.getter(name="logRoleArn")
    def log_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
        return pulumi.get(self, "log_role_arn")

    @log_role_arn.setter
    def log_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_role_arn", value)


if not MYPY:
    class StackFiltersPropertiesStackNamesPropertiesArgsDict(TypedDict):
        """
        List of stack names as filters
        """
        exclude: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of stack names that the hook is going to be excluded from
        """
        include: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of stack names that the hook is going to target
        """
elif False:
    StackFiltersPropertiesStackNamesPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StackFiltersPropertiesStackNamesPropertiesArgs:
    def __init__(__self__, *,
                 exclude: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 include: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        List of stack names as filters
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] exclude: List of stack names that the hook is going to be excluded from
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] include: List of stack names that the hook is going to target
        """
        if exclude is not None:
            pulumi.set(__self__, "exclude", exclude)
        if include is not None:
            pulumi.set(__self__, "include", include)

    @property
    @pulumi.getter
    def exclude(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of stack names that the hook is going to be excluded from
        """
        return pulumi.get(self, "exclude")

    @exclude.setter
    def exclude(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "exclude", value)

    @property
    @pulumi.getter
    def include(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of stack names that the hook is going to target
        """
        return pulumi.get(self, "include")

    @include.setter
    def include(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "include", value)


if not MYPY:
    class StackFiltersPropertiesStackRolesPropertiesArgsDict(TypedDict):
        """
        List of stack roles that are performing the stack operations.
        """
        exclude: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of stack roles that the hook is going to be excluded from
        """
        include: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of stack roles that the hook is going to target
        """
elif False:
    StackFiltersPropertiesStackRolesPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StackFiltersPropertiesStackRolesPropertiesArgs:
    def __init__(__self__, *,
                 exclude: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 include: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        List of stack roles that are performing the stack operations.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] exclude: List of stack roles that the hook is going to be excluded from
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] include: List of stack roles that the hook is going to target
        """
        if exclude is not None:
            pulumi.set(__self__, "exclude", exclude)
        if include is not None:
            pulumi.set(__self__, "include", include)

    @property
    @pulumi.getter
    def exclude(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of stack roles that the hook is going to be excluded from
        """
        return pulumi.get(self, "exclude")

    @exclude.setter
    def exclude(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "exclude", value)

    @property
    @pulumi.getter
    def include(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of stack roles that the hook is going to target
        """
        return pulumi.get(self, "include")

    @include.setter
    def include(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "include", value)


if not MYPY:
    class StackFiltersPropertiesArgsDict(TypedDict):
        """
        Filters to allow hooks to target specific stack attributes
        """
        filtering_criteria: pulumi.Input['LambdaHookStackFiltersPropertiesFilteringCriteria']
        """
        Attribute to specify the filtering behavior. ANY will make the Hook pass if one filter matches. ALL will make the Hook pass if all filters match
        """
        stack_names: NotRequired[pulumi.Input['StackFiltersPropertiesStackNamesPropertiesArgsDict']]
        """
        List of stack names as filters
        """
        stack_roles: NotRequired[pulumi.Input['StackFiltersPropertiesStackRolesPropertiesArgsDict']]
        """
        List of stack roles that are performing the stack operations.
        """
elif False:
    StackFiltersPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StackFiltersPropertiesArgs:
    def __init__(__self__, *,
                 filtering_criteria: pulumi.Input['LambdaHookStackFiltersPropertiesFilteringCriteria'],
                 stack_names: Optional[pulumi.Input['StackFiltersPropertiesStackNamesPropertiesArgs']] = None,
                 stack_roles: Optional[pulumi.Input['StackFiltersPropertiesStackRolesPropertiesArgs']] = None):
        """
        Filters to allow hooks to target specific stack attributes
        :param pulumi.Input['LambdaHookStackFiltersPropertiesFilteringCriteria'] filtering_criteria: Attribute to specify the filtering behavior. ANY will make the Hook pass if one filter matches. ALL will make the Hook pass if all filters match
        :param pulumi.Input['StackFiltersPropertiesStackNamesPropertiesArgs'] stack_names: List of stack names as filters
        :param pulumi.Input['StackFiltersPropertiesStackRolesPropertiesArgs'] stack_roles: List of stack roles that are performing the stack operations.
        """
        pulumi.set(__self__, "filtering_criteria", filtering_criteria)
        if stack_names is not None:
            pulumi.set(__self__, "stack_names", stack_names)
        if stack_roles is not None:
            pulumi.set(__self__, "stack_roles", stack_roles)

    @property
    @pulumi.getter(name="filteringCriteria")
    def filtering_criteria(self) -> pulumi.Input['LambdaHookStackFiltersPropertiesFilteringCriteria']:
        """
        Attribute to specify the filtering behavior. ANY will make the Hook pass if one filter matches. ALL will make the Hook pass if all filters match
        """
        return pulumi.get(self, "filtering_criteria")

    @filtering_criteria.setter
    def filtering_criteria(self, value: pulumi.Input['LambdaHookStackFiltersPropertiesFilteringCriteria']):
        pulumi.set(self, "filtering_criteria", value)

    @property
    @pulumi.getter(name="stackNames")
    def stack_names(self) -> Optional[pulumi.Input['StackFiltersPropertiesStackNamesPropertiesArgs']]:
        """
        List of stack names as filters
        """
        return pulumi.get(self, "stack_names")

    @stack_names.setter
    def stack_names(self, value: Optional[pulumi.Input['StackFiltersPropertiesStackNamesPropertiesArgs']]):
        pulumi.set(self, "stack_names", value)

    @property
    @pulumi.getter(name="stackRoles")
    def stack_roles(self) -> Optional[pulumi.Input['StackFiltersPropertiesStackRolesPropertiesArgs']]:
        """
        List of stack roles that are performing the stack operations.
        """
        return pulumi.get(self, "stack_roles")

    @stack_roles.setter
    def stack_roles(self, value: Optional[pulumi.Input['StackFiltersPropertiesStackRolesPropertiesArgs']]):
        pulumi.set(self, "stack_roles", value)


if not MYPY:
    class StackSetAutoDeploymentArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        If set to true, StackSets automatically deploys additional stack instances to AWS Organizations accounts that are added to a target organization or organizational unit (OU) in the specified Regions. If an account is removed from a target organization or OU, StackSets deletes stack instances from the account in the specified Regions.
        """
        retain_stacks_on_account_removal: NotRequired[pulumi.Input[builtins.bool]]
        """
        If set to true, stack resources are retained when an account is removed from a target organization or OU. If set to false, stack resources are deleted. Specify only if Enabled is set to True.
        """
elif False:
    StackSetAutoDeploymentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StackSetAutoDeploymentArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 retain_stacks_on_account_removal: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: If set to true, StackSets automatically deploys additional stack instances to AWS Organizations accounts that are added to a target organization or organizational unit (OU) in the specified Regions. If an account is removed from a target organization or OU, StackSets deletes stack instances from the account in the specified Regions.
        :param pulumi.Input[builtins.bool] retain_stacks_on_account_removal: If set to true, stack resources are retained when an account is removed from a target organization or OU. If set to false, stack resources are deleted. Specify only if Enabled is set to True.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if retain_stacks_on_account_removal is not None:
            pulumi.set(__self__, "retain_stacks_on_account_removal", retain_stacks_on_account_removal)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to true, StackSets automatically deploys additional stack instances to AWS Organizations accounts that are added to a target organization or organizational unit (OU) in the specified Regions. If an account is removed from a target organization or OU, StackSets deletes stack instances from the account in the specified Regions.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="retainStacksOnAccountRemoval")
    def retain_stacks_on_account_removal(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to true, stack resources are retained when an account is removed from a target organization or OU. If set to false, stack resources are deleted. Specify only if Enabled is set to True.
        """
        return pulumi.get(self, "retain_stacks_on_account_removal")

    @retain_stacks_on_account_removal.setter
    def retain_stacks_on_account_removal(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "retain_stacks_on_account_removal", value)


if not MYPY:
    class StackSetDeploymentTargetsArgsDict(TypedDict):
        """
         The AWS OrganizationalUnitIds or Accounts for which to create stack instances in the specified Regions.
        """
        account_filter_type: NotRequired[pulumi.Input['StackSetDeploymentTargetsAccountFilterType']]
        """
        The filter type you want to apply on organizational units and accounts.
        """
        accounts: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        AWS accounts that you want to create stack instances in the specified Region(s) for.
        """
        accounts_url: NotRequired[pulumi.Input[builtins.str]]
        """
        Returns the value of the AccountsUrl property.
        """
        organizational_unit_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
        """
elif False:
    StackSetDeploymentTargetsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StackSetDeploymentTargetsArgs:
    def __init__(__self__, *,
                 account_filter_type: Optional[pulumi.Input['StackSetDeploymentTargetsAccountFilterType']] = None,
                 accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 accounts_url: Optional[pulumi.Input[builtins.str]] = None,
                 organizational_unit_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
         The AWS OrganizationalUnitIds or Accounts for which to create stack instances in the specified Regions.
        :param pulumi.Input['StackSetDeploymentTargetsAccountFilterType'] account_filter_type: The filter type you want to apply on organizational units and accounts.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] accounts: AWS accounts that you want to create stack instances in the specified Region(s) for.
        :param pulumi.Input[builtins.str] accounts_url: Returns the value of the AccountsUrl property.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] organizational_unit_ids: The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
        """
        if account_filter_type is not None:
            pulumi.set(__self__, "account_filter_type", account_filter_type)
        if accounts is not None:
            pulumi.set(__self__, "accounts", accounts)
        if accounts_url is not None:
            pulumi.set(__self__, "accounts_url", accounts_url)
        if organizational_unit_ids is not None:
            pulumi.set(__self__, "organizational_unit_ids", organizational_unit_ids)

    @property
    @pulumi.getter(name="accountFilterType")
    def account_filter_type(self) -> Optional[pulumi.Input['StackSetDeploymentTargetsAccountFilterType']]:
        """
        The filter type you want to apply on organizational units and accounts.
        """
        return pulumi.get(self, "account_filter_type")

    @account_filter_type.setter
    def account_filter_type(self, value: Optional[pulumi.Input['StackSetDeploymentTargetsAccountFilterType']]):
        pulumi.set(self, "account_filter_type", value)

    @property
    @pulumi.getter
    def accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        AWS accounts that you want to create stack instances in the specified Region(s) for.
        """
        return pulumi.get(self, "accounts")

    @accounts.setter
    def accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "accounts", value)

    @property
    @pulumi.getter(name="accountsUrl")
    def accounts_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Returns the value of the AccountsUrl property.
        """
        return pulumi.get(self, "accounts_url")

    @accounts_url.setter
    def accounts_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "accounts_url", value)

    @property
    @pulumi.getter(name="organizationalUnitIds")
    def organizational_unit_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
        """
        return pulumi.get(self, "organizational_unit_ids")

    @organizational_unit_ids.setter
    def organizational_unit_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "organizational_unit_ids", value)


if not MYPY:
    class StackSetOperationPreferencesArgsDict(TypedDict):
        """
        The user-specified preferences for how AWS CloudFormation performs a stack set operation.
        """
        concurrency_mode: NotRequired[pulumi.Input['StackSetConcurrencyMode']]
        """
        Specifies how the concurrency level behaves during the operation execution.

        - `STRICT_FAILURE_TOLERANCE` : This option dynamically lowers the concurrency level to ensure the number of failed accounts never exceeds the value of `FailureToleranceCount` +1. The initial actual concurrency is set to the lower of either the value of the `MaxConcurrentCount` , or the value of `FailureToleranceCount` +1. The actual concurrency is then reduced proportionally by the number of failures. This is the default behavior.

        If failure tolerance or Maximum concurrent accounts are set to percentages, the behavior is similar.
        - `SOFT_FAILURE_TOLERANCE` : This option decouples `FailureToleranceCount` from the actual concurrency. This allows stack set operations to run at the concurrency level set by the `MaxConcurrentCount` value, or `MaxConcurrentPercentage` , regardless of the number of failures.
        """
        failure_tolerance_count: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of accounts, per Region, for which this operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.

        Conditional: You must specify either `FailureToleranceCount` or `FailureTolerancePercentage` (but not both).
        """
        failure_tolerance_percentage: NotRequired[pulumi.Input[builtins.int]]
        """
        The percentage of accounts, per Region, for which this stack operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.

        When calculating the number of accounts based on the specified percentage, CloudFormation rounds *down* to the next whole number.

        Conditional: You must specify either `FailureToleranceCount` or `FailureTolerancePercentage` , but not both.
        """
        max_concurrent_count: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `FailureToleranceCount` . `MaxConcurrentCount` is at most one more than the `FailureToleranceCount` .

        Note that this setting lets you specify the *maximum* for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.

        Conditional: You must specify either `MaxConcurrentCount` or `MaxConcurrentPercentage` , but not both.
        """
        max_concurrent_percentage: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum percentage of accounts in which to perform this operation at one time.

        When calculating the number of accounts based on the specified percentage, CloudFormation rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, CloudFormation sets the number as one instead.

        Note that this setting lets you specify the *maximum* for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.

        Conditional: You must specify either `MaxConcurrentCount` or `MaxConcurrentPercentage` , but not both.
        """
        region_concurrency_type: NotRequired[pulumi.Input['StackSetRegionConcurrencyType']]
        """
        The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.
        """
        region_order: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The order of the Regions where you want to perform the stack operation.
        """
elif False:
    StackSetOperationPreferencesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StackSetOperationPreferencesArgs:
    def __init__(__self__, *,
                 concurrency_mode: Optional[pulumi.Input['StackSetConcurrencyMode']] = None,
                 failure_tolerance_count: Optional[pulumi.Input[builtins.int]] = None,
                 failure_tolerance_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 max_concurrent_count: Optional[pulumi.Input[builtins.int]] = None,
                 max_concurrent_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 region_concurrency_type: Optional[pulumi.Input['StackSetRegionConcurrencyType']] = None,
                 region_order: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The user-specified preferences for how AWS CloudFormation performs a stack set operation.
        :param pulumi.Input['StackSetConcurrencyMode'] concurrency_mode: Specifies how the concurrency level behaves during the operation execution.
               
               - `STRICT_FAILURE_TOLERANCE` : This option dynamically lowers the concurrency level to ensure the number of failed accounts never exceeds the value of `FailureToleranceCount` +1. The initial actual concurrency is set to the lower of either the value of the `MaxConcurrentCount` , or the value of `FailureToleranceCount` +1. The actual concurrency is then reduced proportionally by the number of failures. This is the default behavior.
               
               If failure tolerance or Maximum concurrent accounts are set to percentages, the behavior is similar.
               - `SOFT_FAILURE_TOLERANCE` : This option decouples `FailureToleranceCount` from the actual concurrency. This allows stack set operations to run at the concurrency level set by the `MaxConcurrentCount` value, or `MaxConcurrentPercentage` , regardless of the number of failures.
        :param pulumi.Input[builtins.int] failure_tolerance_count: The number of accounts, per Region, for which this operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.
               
               Conditional: You must specify either `FailureToleranceCount` or `FailureTolerancePercentage` (but not both).
        :param pulumi.Input[builtins.int] failure_tolerance_percentage: The percentage of accounts, per Region, for which this stack operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.
               
               When calculating the number of accounts based on the specified percentage, CloudFormation rounds *down* to the next whole number.
               
               Conditional: You must specify either `FailureToleranceCount` or `FailureTolerancePercentage` , but not both.
        :param pulumi.Input[builtins.int] max_concurrent_count: The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `FailureToleranceCount` . `MaxConcurrentCount` is at most one more than the `FailureToleranceCount` .
               
               Note that this setting lets you specify the *maximum* for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
               
               Conditional: You must specify either `MaxConcurrentCount` or `MaxConcurrentPercentage` , but not both.
        :param pulumi.Input[builtins.int] max_concurrent_percentage: The maximum percentage of accounts in which to perform this operation at one time.
               
               When calculating the number of accounts based on the specified percentage, CloudFormation rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, CloudFormation sets the number as one instead.
               
               Note that this setting lets you specify the *maximum* for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
               
               Conditional: You must specify either `MaxConcurrentCount` or `MaxConcurrentPercentage` , but not both.
        :param pulumi.Input['StackSetRegionConcurrencyType'] region_concurrency_type: The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] region_order: The order of the Regions where you want to perform the stack operation.
        """
        if concurrency_mode is not None:
            pulumi.set(__self__, "concurrency_mode", concurrency_mode)
        if failure_tolerance_count is not None:
            pulumi.set(__self__, "failure_tolerance_count", failure_tolerance_count)
        if failure_tolerance_percentage is not None:
            pulumi.set(__self__, "failure_tolerance_percentage", failure_tolerance_percentage)
        if max_concurrent_count is not None:
            pulumi.set(__self__, "max_concurrent_count", max_concurrent_count)
        if max_concurrent_percentage is not None:
            pulumi.set(__self__, "max_concurrent_percentage", max_concurrent_percentage)
        if region_concurrency_type is not None:
            pulumi.set(__self__, "region_concurrency_type", region_concurrency_type)
        if region_order is not None:
            pulumi.set(__self__, "region_order", region_order)

    @property
    @pulumi.getter(name="concurrencyMode")
    def concurrency_mode(self) -> Optional[pulumi.Input['StackSetConcurrencyMode']]:
        """
        Specifies how the concurrency level behaves during the operation execution.

        - `STRICT_FAILURE_TOLERANCE` : This option dynamically lowers the concurrency level to ensure the number of failed accounts never exceeds the value of `FailureToleranceCount` +1. The initial actual concurrency is set to the lower of either the value of the `MaxConcurrentCount` , or the value of `FailureToleranceCount` +1. The actual concurrency is then reduced proportionally by the number of failures. This is the default behavior.

        If failure tolerance or Maximum concurrent accounts are set to percentages, the behavior is similar.
        - `SOFT_FAILURE_TOLERANCE` : This option decouples `FailureToleranceCount` from the actual concurrency. This allows stack set operations to run at the concurrency level set by the `MaxConcurrentCount` value, or `MaxConcurrentPercentage` , regardless of the number of failures.
        """
        return pulumi.get(self, "concurrency_mode")

    @concurrency_mode.setter
    def concurrency_mode(self, value: Optional[pulumi.Input['StackSetConcurrencyMode']]):
        pulumi.set(self, "concurrency_mode", value)

    @property
    @pulumi.getter(name="failureToleranceCount")
    def failure_tolerance_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of accounts, per Region, for which this operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.

        Conditional: You must specify either `FailureToleranceCount` or `FailureTolerancePercentage` (but not both).
        """
        return pulumi.get(self, "failure_tolerance_count")

    @failure_tolerance_count.setter
    def failure_tolerance_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "failure_tolerance_count", value)

    @property
    @pulumi.getter(name="failureTolerancePercentage")
    def failure_tolerance_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The percentage of accounts, per Region, for which this stack operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.

        When calculating the number of accounts based on the specified percentage, CloudFormation rounds *down* to the next whole number.

        Conditional: You must specify either `FailureToleranceCount` or `FailureTolerancePercentage` , but not both.
        """
        return pulumi.get(self, "failure_tolerance_percentage")

    @failure_tolerance_percentage.setter
    def failure_tolerance_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "failure_tolerance_percentage", value)

    @property
    @pulumi.getter(name="maxConcurrentCount")
    def max_concurrent_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `FailureToleranceCount` . `MaxConcurrentCount` is at most one more than the `FailureToleranceCount` .

        Note that this setting lets you specify the *maximum* for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.

        Conditional: You must specify either `MaxConcurrentCount` or `MaxConcurrentPercentage` , but not both.
        """
        return pulumi.get(self, "max_concurrent_count")

    @max_concurrent_count.setter
    def max_concurrent_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_concurrent_count", value)

    @property
    @pulumi.getter(name="maxConcurrentPercentage")
    def max_concurrent_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum percentage of accounts in which to perform this operation at one time.

        When calculating the number of accounts based on the specified percentage, CloudFormation rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, CloudFormation sets the number as one instead.

        Note that this setting lets you specify the *maximum* for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.

        Conditional: You must specify either `MaxConcurrentCount` or `MaxConcurrentPercentage` , but not both.
        """
        return pulumi.get(self, "max_concurrent_percentage")

    @max_concurrent_percentage.setter
    def max_concurrent_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_concurrent_percentage", value)

    @property
    @pulumi.getter(name="regionConcurrencyType")
    def region_concurrency_type(self) -> Optional[pulumi.Input['StackSetRegionConcurrencyType']]:
        """
        The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.
        """
        return pulumi.get(self, "region_concurrency_type")

    @region_concurrency_type.setter
    def region_concurrency_type(self, value: Optional[pulumi.Input['StackSetRegionConcurrencyType']]):
        pulumi.set(self, "region_concurrency_type", value)

    @property
    @pulumi.getter(name="regionOrder")
    def region_order(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The order of the Regions where you want to perform the stack operation.
        """
        return pulumi.get(self, "region_order")

    @region_order.setter
    def region_order(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "region_order", value)


if not MYPY:
    class StackSetParameterArgsDict(TypedDict):
        parameter_key: pulumi.Input[builtins.str]
        """
        The key associated with the parameter. If you don't specify a key and value for a particular parameter, AWS CloudFormation uses the default value that is specified in your template.
        """
        parameter_value: pulumi.Input[builtins.str]
        """
        The input value associated with the parameter.
        """
elif False:
    StackSetParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StackSetParameterArgs:
    def __init__(__self__, *,
                 parameter_key: pulumi.Input[builtins.str],
                 parameter_value: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] parameter_key: The key associated with the parameter. If you don't specify a key and value for a particular parameter, AWS CloudFormation uses the default value that is specified in your template.
        :param pulumi.Input[builtins.str] parameter_value: The input value associated with the parameter.
        """
        pulumi.set(__self__, "parameter_key", parameter_key)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="parameterKey")
    def parameter_key(self) -> pulumi.Input[builtins.str]:
        """
        The key associated with the parameter. If you don't specify a key and value for a particular parameter, AWS CloudFormation uses the default value that is specified in your template.
        """
        return pulumi.get(self, "parameter_key")

    @parameter_key.setter
    def parameter_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parameter_key", value)

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> pulumi.Input[builtins.str]:
        """
        The input value associated with the parameter.
        """
        return pulumi.get(self, "parameter_value")

    @parameter_value.setter
    def parameter_value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parameter_value", value)


if not MYPY:
    class StackSetStackInstancesArgsDict(TypedDict):
        """
        Stack instances in some specific accounts and Regions.
        """
        deployment_targets: pulumi.Input['StackSetDeploymentTargetsArgsDict']
        """
        The AWS `OrganizationalUnitIds` or `Accounts` for which to create stack instances in the specified Regions.
        """
        regions: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The names of one or more Regions where you want to create stack instances using the specified AWS account(s).
        """
        parameter_overrides: NotRequired[pulumi.Input[Sequence[pulumi.Input['StackSetParameterArgsDict']]]]
        """
        A list of stack set parameters whose values you want to override in the selected stack instances.
        """
elif False:
    StackSetStackInstancesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StackSetStackInstancesArgs:
    def __init__(__self__, *,
                 deployment_targets: pulumi.Input['StackSetDeploymentTargetsArgs'],
                 regions: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 parameter_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['StackSetParameterArgs']]]] = None):
        """
        Stack instances in some specific accounts and Regions.
        :param pulumi.Input['StackSetDeploymentTargetsArgs'] deployment_targets: The AWS `OrganizationalUnitIds` or `Accounts` for which to create stack instances in the specified Regions.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] regions: The names of one or more Regions where you want to create stack instances using the specified AWS account(s).
        :param pulumi.Input[Sequence[pulumi.Input['StackSetParameterArgs']]] parameter_overrides: A list of stack set parameters whose values you want to override in the selected stack instances.
        """
        pulumi.set(__self__, "deployment_targets", deployment_targets)
        pulumi.set(__self__, "regions", regions)
        if parameter_overrides is not None:
            pulumi.set(__self__, "parameter_overrides", parameter_overrides)

    @property
    @pulumi.getter(name="deploymentTargets")
    def deployment_targets(self) -> pulumi.Input['StackSetDeploymentTargetsArgs']:
        """
        The AWS `OrganizationalUnitIds` or `Accounts` for which to create stack instances in the specified Regions.
        """
        return pulumi.get(self, "deployment_targets")

    @deployment_targets.setter
    def deployment_targets(self, value: pulumi.Input['StackSetDeploymentTargetsArgs']):
        pulumi.set(self, "deployment_targets", value)

    @property
    @pulumi.getter
    def regions(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The names of one or more Regions where you want to create stack instances using the specified AWS account(s).
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "regions", value)

    @property
    @pulumi.getter(name="parameterOverrides")
    def parameter_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackSetParameterArgs']]]]:
        """
        A list of stack set parameters whose values you want to override in the selected stack instances.
        """
        return pulumi.get(self, "parameter_overrides")

    @parameter_overrides.setter
    def parameter_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackSetParameterArgs']]]]):
        pulumi.set(self, "parameter_overrides", value)


if not MYPY:
    class TargetFilters0PropertiesArgsDict(TypedDict):
        """
        Attribute to specify which targets should invoke the hook
        """
        actions: NotRequired[pulumi.Input[Sequence[pulumi.Input['LambdaHookAction']]]]
        """
        List of actions that the hook is going to target
        """
        invocation_points: NotRequired[pulumi.Input[Sequence[pulumi.Input['LambdaHookInvocationPoint']]]]
        """
        List of invocation points that the hook is going to target
        """
        target_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of type names that the hook is going to target
        """
elif False:
    TargetFilters0PropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TargetFilters0PropertiesArgs:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['LambdaHookAction']]]] = None,
                 invocation_points: Optional[pulumi.Input[Sequence[pulumi.Input['LambdaHookInvocationPoint']]]] = None,
                 target_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Attribute to specify which targets should invoke the hook
        :param pulumi.Input[Sequence[pulumi.Input['LambdaHookAction']]] actions: List of actions that the hook is going to target
        :param pulumi.Input[Sequence[pulumi.Input['LambdaHookInvocationPoint']]] invocation_points: List of invocation points that the hook is going to target
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_names: List of type names that the hook is going to target
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if invocation_points is not None:
            pulumi.set(__self__, "invocation_points", invocation_points)
        if target_names is not None:
            pulumi.set(__self__, "target_names", target_names)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LambdaHookAction']]]]:
        """
        List of actions that the hook is going to target
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LambdaHookAction']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="invocationPoints")
    def invocation_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LambdaHookInvocationPoint']]]]:
        """
        List of invocation points that the hook is going to target
        """
        return pulumi.get(self, "invocation_points")

    @invocation_points.setter
    def invocation_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LambdaHookInvocationPoint']]]]):
        pulumi.set(self, "invocation_points", value)

    @property
    @pulumi.getter(name="targetNames")
    def target_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of type names that the hook is going to target
        """
        return pulumi.get(self, "target_names")

    @target_names.setter
    def target_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "target_names", value)


if not MYPY:
    class TargetFilters1PropertiesArgsDict(TypedDict):
        """
        Attribute to specify which targets should invoke the hook
        """
        targets: pulumi.Input[Sequence[pulumi.Input['LambdaHookHookTargetArgsDict']]]
        """
        List of hook targets
        """
elif False:
    TargetFilters1PropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TargetFilters1PropertiesArgs:
    def __init__(__self__, *,
                 targets: pulumi.Input[Sequence[pulumi.Input['LambdaHookHookTargetArgs']]]):
        """
        Attribute to specify which targets should invoke the hook
        :param pulumi.Input[Sequence[pulumi.Input['LambdaHookHookTargetArgs']]] targets: List of hook targets
        """
        pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter
    def targets(self) -> pulumi.Input[Sequence[pulumi.Input['LambdaHookHookTargetArgs']]]:
        """
        List of hook targets
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: pulumi.Input[Sequence[pulumi.Input['LambdaHookHookTargetArgs']]]):
        pulumi.set(self, "targets", value)


if not MYPY:
    class TypeActivationLoggingConfigArgsDict(TypedDict):
        log_group_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        """
        log_role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
elif False:
    TypeActivationLoggingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TypeActivationLoggingConfigArgs:
    def __init__(__self__, *,
                 log_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 log_role_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] log_group_name: The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        :param pulumi.Input[builtins.str] log_role_arn: The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
        if log_group_name is not None:
            pulumi.set(__self__, "log_group_name", log_group_name)
        if log_role_arn is not None:
            pulumi.set(__self__, "log_role_arn", log_role_arn)

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        """
        return pulumi.get(self, "log_group_name")

    @log_group_name.setter
    def log_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_group_name", value)

    @property
    @pulumi.getter(name="logRoleArn")
    def log_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
        return pulumi.get(self, "log_role_arn")

    @log_role_arn.setter
    def log_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_role_arn", value)


