# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetTrainingDatasetResult',
    'AwaitableGetTrainingDatasetResult',
    'get_training_dataset',
    'get_training_dataset_output',
]

@pulumi.output_type
class GetTrainingDatasetResult:
    def __init__(__self__, status=None, tags=None, training_dataset_arn=None):
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if training_dataset_arn and not isinstance(training_dataset_arn, str):
            raise TypeError("Expected argument 'training_dataset_arn' to be a str")
        pulumi.set(__self__, "training_dataset_arn", training_dataset_arn)

    @property
    @pulumi.getter
    def status(self) -> Optional['TrainingDatasetStatus']:
        """
        The status of the training dataset.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An arbitrary set of tags (key-value pairs) for this cleanrooms-ml training dataset.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trainingDatasetArn")
    def training_dataset_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the training dataset.
        """
        return pulumi.get(self, "training_dataset_arn")


class AwaitableGetTrainingDatasetResult(GetTrainingDatasetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTrainingDatasetResult(
            status=self.status,
            tags=self.tags,
            training_dataset_arn=self.training_dataset_arn)


def get_training_dataset(training_dataset_arn: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTrainingDatasetResult:
    """
    Definition of AWS::CleanRoomsML::TrainingDataset Resource Type


    :param builtins.str training_dataset_arn: The Amazon Resource Name (ARN) of the training dataset.
    """
    __args__ = dict()
    __args__['trainingDatasetArn'] = training_dataset_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cleanroomsml:getTrainingDataset', __args__, opts=opts, typ=GetTrainingDatasetResult).value

    return AwaitableGetTrainingDatasetResult(
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        training_dataset_arn=pulumi.get(__ret__, 'training_dataset_arn'))
def get_training_dataset_output(training_dataset_arn: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTrainingDatasetResult]:
    """
    Definition of AWS::CleanRoomsML::TrainingDataset Resource Type


    :param builtins.str training_dataset_arn: The Amazon Resource Name (ARN) of the training dataset.
    """
    __args__ = dict()
    __args__['trainingDatasetArn'] = training_dataset_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cleanroomsml:getTrainingDataset', __args__, opts=opts, typ=GetTrainingDatasetResult)
    return __ret__.apply(lambda __response__: GetTrainingDatasetResult(
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        training_dataset_arn=pulumi.get(__response__, 'training_dataset_arn')))
