# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'TrainingDatasetColumnSchemaArgs',
    'TrainingDatasetColumnSchemaArgsDict',
    'TrainingDatasetDataSourceArgs',
    'TrainingDatasetDataSourceArgsDict',
    'TrainingDatasetDatasetInputConfigArgs',
    'TrainingDatasetDatasetInputConfigArgsDict',
    'TrainingDatasetDatasetArgs',
    'TrainingDatasetDatasetArgsDict',
    'TrainingDatasetGlueDataSourceArgs',
    'TrainingDatasetGlueDataSourceArgsDict',
]

MYPY = False

if not MYPY:
    class TrainingDatasetColumnSchemaArgsDict(TypedDict):
        column_name: pulumi.Input[builtins.str]
        """
        The name of a column.
        """
        column_types: pulumi.Input[Sequence[pulumi.Input['TrainingDatasetColumnType']]]
        """
        The data type of column.
        """
elif False:
    TrainingDatasetColumnSchemaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TrainingDatasetColumnSchemaArgs:
    def __init__(__self__, *,
                 column_name: pulumi.Input[builtins.str],
                 column_types: pulumi.Input[Sequence[pulumi.Input['TrainingDatasetColumnType']]]):
        """
        :param pulumi.Input[builtins.str] column_name: The name of a column.
        :param pulumi.Input[Sequence[pulumi.Input['TrainingDatasetColumnType']]] column_types: The data type of column.
        """
        pulumi.set(__self__, "column_name", column_name)
        pulumi.set(__self__, "column_types", column_types)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of a column.
        """
        return pulumi.get(self, "column_name")

    @column_name.setter
    def column_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "column_name", value)

    @property
    @pulumi.getter(name="columnTypes")
    def column_types(self) -> pulumi.Input[Sequence[pulumi.Input['TrainingDatasetColumnType']]]:
        """
        The data type of column.
        """
        return pulumi.get(self, "column_types")

    @column_types.setter
    def column_types(self, value: pulumi.Input[Sequence[pulumi.Input['TrainingDatasetColumnType']]]):
        pulumi.set(self, "column_types", value)


if not MYPY:
    class TrainingDatasetDataSourceArgsDict(TypedDict):
        glue_data_source: pulumi.Input['TrainingDatasetGlueDataSourceArgsDict']
        """
        A GlueDataSource object that defines the catalog ID, database name, and table name for the training data.
        """
elif False:
    TrainingDatasetDataSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TrainingDatasetDataSourceArgs:
    def __init__(__self__, *,
                 glue_data_source: pulumi.Input['TrainingDatasetGlueDataSourceArgs']):
        """
        :param pulumi.Input['TrainingDatasetGlueDataSourceArgs'] glue_data_source: A GlueDataSource object that defines the catalog ID, database name, and table name for the training data.
        """
        pulumi.set(__self__, "glue_data_source", glue_data_source)

    @property
    @pulumi.getter(name="glueDataSource")
    def glue_data_source(self) -> pulumi.Input['TrainingDatasetGlueDataSourceArgs']:
        """
        A GlueDataSource object that defines the catalog ID, database name, and table name for the training data.
        """
        return pulumi.get(self, "glue_data_source")

    @glue_data_source.setter
    def glue_data_source(self, value: pulumi.Input['TrainingDatasetGlueDataSourceArgs']):
        pulumi.set(self, "glue_data_source", value)


if not MYPY:
    class TrainingDatasetDatasetInputConfigArgsDict(TypedDict):
        data_source: pulumi.Input['TrainingDatasetDataSourceArgsDict']
        """
        A DataSource object that specifies the Glue data source for the training data.
        """
        schema: pulumi.Input[Sequence[pulumi.Input['TrainingDatasetColumnSchemaArgsDict']]]
        """
        The schema information for the training data.
        """
elif False:
    TrainingDatasetDatasetInputConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TrainingDatasetDatasetInputConfigArgs:
    def __init__(__self__, *,
                 data_source: pulumi.Input['TrainingDatasetDataSourceArgs'],
                 schema: pulumi.Input[Sequence[pulumi.Input['TrainingDatasetColumnSchemaArgs']]]):
        """
        :param pulumi.Input['TrainingDatasetDataSourceArgs'] data_source: A DataSource object that specifies the Glue data source for the training data.
        :param pulumi.Input[Sequence[pulumi.Input['TrainingDatasetColumnSchemaArgs']]] schema: The schema information for the training data.
        """
        pulumi.set(__self__, "data_source", data_source)
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> pulumi.Input['TrainingDatasetDataSourceArgs']:
        """
        A DataSource object that specifies the Glue data source for the training data.
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: pulumi.Input['TrainingDatasetDataSourceArgs']):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Input[Sequence[pulumi.Input['TrainingDatasetColumnSchemaArgs']]]:
        """
        The schema information for the training data.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[Sequence[pulumi.Input['TrainingDatasetColumnSchemaArgs']]]):
        pulumi.set(self, "schema", value)


if not MYPY:
    class TrainingDatasetDatasetArgsDict(TypedDict):
        input_config: pulumi.Input['TrainingDatasetDatasetInputConfigArgsDict']
        """
        A DatasetInputConfig object that defines the data source and schema mapping.
        """
        type: pulumi.Input['TrainingDatasetDatasetType']
        """
        What type of information is found in the dataset.
        """
elif False:
    TrainingDatasetDatasetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TrainingDatasetDatasetArgs:
    def __init__(__self__, *,
                 input_config: pulumi.Input['TrainingDatasetDatasetInputConfigArgs'],
                 type: pulumi.Input['TrainingDatasetDatasetType']):
        """
        :param pulumi.Input['TrainingDatasetDatasetInputConfigArgs'] input_config: A DatasetInputConfig object that defines the data source and schema mapping.
        :param pulumi.Input['TrainingDatasetDatasetType'] type: What type of information is found in the dataset.
        """
        pulumi.set(__self__, "input_config", input_config)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="inputConfig")
    def input_config(self) -> pulumi.Input['TrainingDatasetDatasetInputConfigArgs']:
        """
        A DatasetInputConfig object that defines the data source and schema mapping.
        """
        return pulumi.get(self, "input_config")

    @input_config.setter
    def input_config(self, value: pulumi.Input['TrainingDatasetDatasetInputConfigArgs']):
        pulumi.set(self, "input_config", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['TrainingDatasetDatasetType']:
        """
        What type of information is found in the dataset.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['TrainingDatasetDatasetType']):
        pulumi.set(self, "type", value)


if not MYPY:
    class TrainingDatasetGlueDataSourceArgsDict(TypedDict):
        database_name: pulumi.Input[builtins.str]
        """
        The Glue database that contains the training data.
        """
        table_name: pulumi.Input[builtins.str]
        """
        The Glue table that contains the training data.
        """
        catalog_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Glue catalog that contains the training data.
        """
elif False:
    TrainingDatasetGlueDataSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TrainingDatasetGlueDataSourceArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[builtins.str],
                 table_name: pulumi.Input[builtins.str],
                 catalog_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] database_name: The Glue database that contains the training data.
        :param pulumi.Input[builtins.str] table_name: The Glue table that contains the training data.
        :param pulumi.Input[builtins.str] catalog_id: The Glue catalog that contains the training data.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "table_name", table_name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[builtins.str]:
        """
        The Glue database that contains the training data.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[builtins.str]:
        """
        The Glue table that contains the training data.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Glue catalog that contains the training data.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "catalog_id", value)


