# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetMembershipResult',
    'AwaitableGetMembershipResult',
    'get_membership',
    'get_membership_output',
]

@pulumi.output_type
class GetMembershipResult:
    def __init__(__self__, arn=None, collaboration_arn=None, collaboration_creator_account_id=None, default_job_result_configuration=None, default_result_configuration=None, job_log_status=None, membership_identifier=None, payment_configuration=None, query_log_status=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if collaboration_arn and not isinstance(collaboration_arn, str):
            raise TypeError("Expected argument 'collaboration_arn' to be a str")
        pulumi.set(__self__, "collaboration_arn", collaboration_arn)
        if collaboration_creator_account_id and not isinstance(collaboration_creator_account_id, str):
            raise TypeError("Expected argument 'collaboration_creator_account_id' to be a str")
        pulumi.set(__self__, "collaboration_creator_account_id", collaboration_creator_account_id)
        if default_job_result_configuration and not isinstance(default_job_result_configuration, dict):
            raise TypeError("Expected argument 'default_job_result_configuration' to be a dict")
        pulumi.set(__self__, "default_job_result_configuration", default_job_result_configuration)
        if default_result_configuration and not isinstance(default_result_configuration, dict):
            raise TypeError("Expected argument 'default_result_configuration' to be a dict")
        pulumi.set(__self__, "default_result_configuration", default_result_configuration)
        if job_log_status and not isinstance(job_log_status, str):
            raise TypeError("Expected argument 'job_log_status' to be a str")
        pulumi.set(__self__, "job_log_status", job_log_status)
        if membership_identifier and not isinstance(membership_identifier, str):
            raise TypeError("Expected argument 'membership_identifier' to be a str")
        pulumi.set(__self__, "membership_identifier", membership_identifier)
        if payment_configuration and not isinstance(payment_configuration, dict):
            raise TypeError("Expected argument 'payment_configuration' to be a dict")
        pulumi.set(__self__, "payment_configuration", payment_configuration)
        if query_log_status and not isinstance(query_log_status, str):
            raise TypeError("Expected argument 'query_log_status' to be a str")
        pulumi.set(__self__, "query_log_status", query_log_status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        Returns the Amazon Resource Name (ARN) of the specified membership.

        Example: `arn:aws:cleanrooms:us-east-1:111122223333:membership/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="collaborationArn")
    def collaboration_arn(self) -> Optional[builtins.str]:
        """
        Returns the Amazon Resource Name (ARN) of the specified collaboration.

        Example: `arn:aws:cleanrooms:us-east-1:111122223333:collaboration/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`
        """
        return pulumi.get(self, "collaboration_arn")

    @property
    @pulumi.getter(name="collaborationCreatorAccountId")
    def collaboration_creator_account_id(self) -> Optional[builtins.str]:
        """
        Returns the unique identifier of the specified collaboration creator account.

        Example: `a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`
        """
        return pulumi.get(self, "collaboration_creator_account_id")

    @property
    @pulumi.getter(name="defaultJobResultConfiguration")
    def default_job_result_configuration(self) -> Optional['outputs.MembershipProtectedJobResultConfiguration']:
        """
        The default job result configuration for the membership.
        """
        return pulumi.get(self, "default_job_result_configuration")

    @property
    @pulumi.getter(name="defaultResultConfiguration")
    def default_result_configuration(self) -> Optional['outputs.MembershipProtectedQueryResultConfiguration']:
        """
        The default protected query result configuration as specified by the member who can receive results.
        """
        return pulumi.get(self, "default_result_configuration")

    @property
    @pulumi.getter(name="jobLogStatus")
    def job_log_status(self) -> Optional['MembershipJobLogStatus']:
        """
        An indicator as to whether job logging has been enabled or disabled for the collaboration.

        When `ENABLED` , AWS Clean Rooms logs details about jobs run within this collaboration and those logs can be viewed in Amazon CloudWatch Logs. The default value is `DISABLED` .
        """
        return pulumi.get(self, "job_log_status")

    @property
    @pulumi.getter(name="membershipIdentifier")
    def membership_identifier(self) -> Optional[builtins.str]:
        """
        Returns the unique identifier of the specified membership.

        Example: `a1b2c3d4-5678-90ab-cdef-EXAMPLE22222`
        """
        return pulumi.get(self, "membership_identifier")

    @property
    @pulumi.getter(name="paymentConfiguration")
    def payment_configuration(self) -> Optional['outputs.MembershipPaymentConfiguration']:
        """
        The payment responsibilities accepted by the collaboration member.
        """
        return pulumi.get(self, "payment_configuration")

    @property
    @pulumi.getter(name="queryLogStatus")
    def query_log_status(self) -> Optional['MembershipQueryLogStatus']:
        """
        An indicator as to whether query logging has been enabled or disabled for the membership.

        When `ENABLED` , AWS Clean Rooms logs details about queries run within this collaboration and those logs can be viewed in Amazon CloudWatch Logs. The default value is `DISABLED` .
        """
        return pulumi.get(self, "query_log_status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An arbitrary set of tags (key-value pairs) for this cleanrooms membership.
        """
        return pulumi.get(self, "tags")


class AwaitableGetMembershipResult(GetMembershipResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMembershipResult(
            arn=self.arn,
            collaboration_arn=self.collaboration_arn,
            collaboration_creator_account_id=self.collaboration_creator_account_id,
            default_job_result_configuration=self.default_job_result_configuration,
            default_result_configuration=self.default_result_configuration,
            job_log_status=self.job_log_status,
            membership_identifier=self.membership_identifier,
            payment_configuration=self.payment_configuration,
            query_log_status=self.query_log_status,
            tags=self.tags)


def get_membership(membership_identifier: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMembershipResult:
    """
    Represents an AWS account that is a part of a collaboration


    :param builtins.str membership_identifier: Returns the unique identifier of the specified membership.
           
           Example: `a1b2c3d4-5678-90ab-cdef-EXAMPLE22222`
    """
    __args__ = dict()
    __args__['membershipIdentifier'] = membership_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cleanrooms:getMembership', __args__, opts=opts, typ=GetMembershipResult).value

    return AwaitableGetMembershipResult(
        arn=pulumi.get(__ret__, 'arn'),
        collaboration_arn=pulumi.get(__ret__, 'collaboration_arn'),
        collaboration_creator_account_id=pulumi.get(__ret__, 'collaboration_creator_account_id'),
        default_job_result_configuration=pulumi.get(__ret__, 'default_job_result_configuration'),
        default_result_configuration=pulumi.get(__ret__, 'default_result_configuration'),
        job_log_status=pulumi.get(__ret__, 'job_log_status'),
        membership_identifier=pulumi.get(__ret__, 'membership_identifier'),
        payment_configuration=pulumi.get(__ret__, 'payment_configuration'),
        query_log_status=pulumi.get(__ret__, 'query_log_status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_membership_output(membership_identifier: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMembershipResult]:
    """
    Represents an AWS account that is a part of a collaboration


    :param builtins.str membership_identifier: Returns the unique identifier of the specified membership.
           
           Example: `a1b2c3d4-5678-90ab-cdef-EXAMPLE22222`
    """
    __args__ = dict()
    __args__['membershipIdentifier'] = membership_identifier
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cleanrooms:getMembership', __args__, opts=opts, typ=GetMembershipResult)
    return __ret__.apply(lambda __response__: GetMembershipResult(
        arn=pulumi.get(__response__, 'arn'),
        collaboration_arn=pulumi.get(__response__, 'collaboration_arn'),
        collaboration_creator_account_id=pulumi.get(__response__, 'collaboration_creator_account_id'),
        default_job_result_configuration=pulumi.get(__response__, 'default_job_result_configuration'),
        default_result_configuration=pulumi.get(__response__, 'default_result_configuration'),
        job_log_status=pulumi.get(__response__, 'job_log_status'),
        membership_identifier=pulumi.get(__response__, 'membership_identifier'),
        payment_configuration=pulumi.get(__response__, 'payment_configuration'),
        query_log_status=pulumi.get(__response__, 'query_log_status'),
        tags=pulumi.get(__response__, 'tags')))
