# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetConfiguredTableResult',
    'AwaitableGetConfiguredTableResult',
    'get_configured_table',
    'get_configured_table_output',
]

@pulumi.output_type
class GetConfiguredTableResult:
    def __init__(__self__, analysis_method=None, analysis_rules=None, arn=None, configured_table_identifier=None, description=None, name=None, selected_analysis_methods=None, tags=None):
        if analysis_method and not isinstance(analysis_method, str):
            raise TypeError("Expected argument 'analysis_method' to be a str")
        pulumi.set(__self__, "analysis_method", analysis_method)
        if analysis_rules and not isinstance(analysis_rules, list):
            raise TypeError("Expected argument 'analysis_rules' to be a list")
        pulumi.set(__self__, "analysis_rules", analysis_rules)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if configured_table_identifier and not isinstance(configured_table_identifier, str):
            raise TypeError("Expected argument 'configured_table_identifier' to be a str")
        pulumi.set(__self__, "configured_table_identifier", configured_table_identifier)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if selected_analysis_methods and not isinstance(selected_analysis_methods, list):
            raise TypeError("Expected argument 'selected_analysis_methods' to be a list")
        pulumi.set(__self__, "selected_analysis_methods", selected_analysis_methods)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="analysisMethod")
    def analysis_method(self) -> Optional['ConfiguredTableAnalysisMethod']:
        """
        The analysis method for the configured table.

        `DIRECT_QUERY` allows SQL queries to be run directly on this table.

        `DIRECT_JOB` allows PySpark jobs to be run directly on this table.

        `MULTIPLE` allows both SQL queries and PySpark jobs to be run directly on this table.
        """
        return pulumi.get(self, "analysis_method")

    @property
    @pulumi.getter(name="analysisRules")
    def analysis_rules(self) -> Optional[Sequence['outputs.ConfiguredTableAnalysisRule']]:
        """
        The analysis rule that was created for the configured table.
        """
        return pulumi.get(self, "analysis_rules")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        Returns the Amazon Resource Name (ARN) of the specified configured table.

        Example: `arn:aws:cleanrooms:us-east-1:111122223333:configuredtable/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="configuredTableIdentifier")
    def configured_table_identifier(self) -> Optional[builtins.str]:
        """
        Returns the unique identifier of the specified configured table.

        Example: `a1b2c3d4-5678-90ab-cdef-EXAMPLE33333`
        """
        return pulumi.get(self, "configured_table_identifier")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description for the configured table.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        A name for the configured table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="selectedAnalysisMethods")
    def selected_analysis_methods(self) -> Optional[Sequence['ConfiguredTableSelectedAnalysisMethod']]:
        """
        The selected analysis methods for the configured table.
        """
        return pulumi.get(self, "selected_analysis_methods")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An arbitrary set of tags (key-value pairs) for this cleanrooms collaboration.
        """
        return pulumi.get(self, "tags")


class AwaitableGetConfiguredTableResult(GetConfiguredTableResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConfiguredTableResult(
            analysis_method=self.analysis_method,
            analysis_rules=self.analysis_rules,
            arn=self.arn,
            configured_table_identifier=self.configured_table_identifier,
            description=self.description,
            name=self.name,
            selected_analysis_methods=self.selected_analysis_methods,
            tags=self.tags)


def get_configured_table(configured_table_identifier: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConfiguredTableResult:
    """
    Represents a table that can be associated with collaborations


    :param builtins.str configured_table_identifier: Returns the unique identifier of the specified configured table.
           
           Example: `a1b2c3d4-5678-90ab-cdef-EXAMPLE33333`
    """
    __args__ = dict()
    __args__['configuredTableIdentifier'] = configured_table_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cleanrooms:getConfiguredTable', __args__, opts=opts, typ=GetConfiguredTableResult).value

    return AwaitableGetConfiguredTableResult(
        analysis_method=pulumi.get(__ret__, 'analysis_method'),
        analysis_rules=pulumi.get(__ret__, 'analysis_rules'),
        arn=pulumi.get(__ret__, 'arn'),
        configured_table_identifier=pulumi.get(__ret__, 'configured_table_identifier'),
        description=pulumi.get(__ret__, 'description'),
        name=pulumi.get(__ret__, 'name'),
        selected_analysis_methods=pulumi.get(__ret__, 'selected_analysis_methods'),
        tags=pulumi.get(__ret__, 'tags'))
def get_configured_table_output(configured_table_identifier: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConfiguredTableResult]:
    """
    Represents a table that can be associated with collaborations


    :param builtins.str configured_table_identifier: Returns the unique identifier of the specified configured table.
           
           Example: `a1b2c3d4-5678-90ab-cdef-EXAMPLE33333`
    """
    __args__ = dict()
    __args__['configuredTableIdentifier'] = configured_table_identifier
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cleanrooms:getConfiguredTable', __args__, opts=opts, typ=GetConfiguredTableResult)
    return __ret__.apply(lambda __response__: GetConfiguredTableResult(
        analysis_method=pulumi.get(__response__, 'analysis_method'),
        analysis_rules=pulumi.get(__response__, 'analysis_rules'),
        arn=pulumi.get(__response__, 'arn'),
        configured_table_identifier=pulumi.get(__response__, 'configured_table_identifier'),
        description=pulumi.get(__response__, 'description'),
        name=pulumi.get(__response__, 'name'),
        selected_analysis_methods=pulumi.get(__response__, 'selected_analysis_methods'),
        tags=pulumi.get(__response__, 'tags')))
