# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ConfiguredTableAssociationArgs', 'ConfiguredTableAssociation']

@pulumi.input_type
class ConfiguredTableAssociationArgs:
    def __init__(__self__, *,
                 configured_table_identifier: pulumi.Input[builtins.str],
                 membership_identifier: pulumi.Input[builtins.str],
                 role_arn: pulumi.Input[builtins.str],
                 configured_table_association_analysis_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ConfiguredTableAssociationAnalysisRuleArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a ConfiguredTableAssociation resource.
        :param pulumi.Input[builtins.str] configured_table_identifier: A unique identifier for the configured table to be associated to. Currently accepts a configured table ID.
        :param pulumi.Input[builtins.str] membership_identifier: The unique ID for the membership this configured table association belongs to.
        :param pulumi.Input[builtins.str] role_arn: The service will assume this role to access catalog metadata and query the table.
        :param pulumi.Input[Sequence[pulumi.Input['ConfiguredTableAssociationAnalysisRuleArgs']]] configured_table_association_analysis_rules: An analysis rule for a configured table association. This analysis rule specifies how data from the table can be used within its associated collaboration. In the console, the `ConfiguredTableAssociationAnalysisRule` is referred to as the *collaboration analysis rule* .
        :param pulumi.Input[builtins.str] description: A description of the configured table association.
        :param pulumi.Input[builtins.str] name: The name of the configured table association, in lowercase. The table is identified by this name when running protected queries against the underlying data.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An arbitrary set of tags (key-value pairs) for this cleanrooms collaboration.
        """
        pulumi.set(__self__, "configured_table_identifier", configured_table_identifier)
        pulumi.set(__self__, "membership_identifier", membership_identifier)
        pulumi.set(__self__, "role_arn", role_arn)
        if configured_table_association_analysis_rules is not None:
            pulumi.set(__self__, "configured_table_association_analysis_rules", configured_table_association_analysis_rules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="configuredTableIdentifier")
    def configured_table_identifier(self) -> pulumi.Input[builtins.str]:
        """
        A unique identifier for the configured table to be associated to. Currently accepts a configured table ID.
        """
        return pulumi.get(self, "configured_table_identifier")

    @configured_table_identifier.setter
    def configured_table_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "configured_table_identifier", value)

    @property
    @pulumi.getter(name="membershipIdentifier")
    def membership_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The unique ID for the membership this configured table association belongs to.
        """
        return pulumi.get(self, "membership_identifier")

    @membership_identifier.setter
    def membership_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "membership_identifier", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The service will assume this role to access catalog metadata and query the table.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="configuredTableAssociationAnalysisRules")
    def configured_table_association_analysis_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfiguredTableAssociationAnalysisRuleArgs']]]]:
        """
        An analysis rule for a configured table association. This analysis rule specifies how data from the table can be used within its associated collaboration. In the console, the `ConfiguredTableAssociationAnalysisRule` is referred to as the *collaboration analysis rule* .
        """
        return pulumi.get(self, "configured_table_association_analysis_rules")

    @configured_table_association_analysis_rules.setter
    def configured_table_association_analysis_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfiguredTableAssociationAnalysisRuleArgs']]]]):
        pulumi.set(self, "configured_table_association_analysis_rules", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the configured table association.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the configured table association, in lowercase. The table is identified by this name when running protected queries against the underlying data.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An arbitrary set of tags (key-value pairs) for this cleanrooms collaboration.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:cleanrooms:ConfiguredTableAssociation")
class ConfiguredTableAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configured_table_association_analysis_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfiguredTableAssociationAnalysisRuleArgs', 'ConfiguredTableAssociationAnalysisRuleArgsDict']]]]] = None,
                 configured_table_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 membership_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Represents a table that can be queried within a collaboration

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfiguredTableAssociationAnalysisRuleArgs', 'ConfiguredTableAssociationAnalysisRuleArgsDict']]]] configured_table_association_analysis_rules: An analysis rule for a configured table association. This analysis rule specifies how data from the table can be used within its associated collaboration. In the console, the `ConfiguredTableAssociationAnalysisRule` is referred to as the *collaboration analysis rule* .
        :param pulumi.Input[builtins.str] configured_table_identifier: A unique identifier for the configured table to be associated to. Currently accepts a configured table ID.
        :param pulumi.Input[builtins.str] description: A description of the configured table association.
        :param pulumi.Input[builtins.str] membership_identifier: The unique ID for the membership this configured table association belongs to.
        :param pulumi.Input[builtins.str] name: The name of the configured table association, in lowercase. The table is identified by this name when running protected queries against the underlying data.
        :param pulumi.Input[builtins.str] role_arn: The service will assume this role to access catalog metadata and query the table.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An arbitrary set of tags (key-value pairs) for this cleanrooms collaboration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfiguredTableAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a table that can be queried within a collaboration

        :param str resource_name: The name of the resource.
        :param ConfiguredTableAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfiguredTableAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configured_table_association_analysis_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfiguredTableAssociationAnalysisRuleArgs', 'ConfiguredTableAssociationAnalysisRuleArgsDict']]]]] = None,
                 configured_table_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 membership_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfiguredTableAssociationArgs.__new__(ConfiguredTableAssociationArgs)

            __props__.__dict__["configured_table_association_analysis_rules"] = configured_table_association_analysis_rules
            if configured_table_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'configured_table_identifier'")
            __props__.__dict__["configured_table_identifier"] = configured_table_identifier
            __props__.__dict__["description"] = description
            if membership_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'membership_identifier'")
            __props__.__dict__["membership_identifier"] = membership_identifier
            __props__.__dict__["name"] = name
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["configured_table_association_identifier"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["configuredTableIdentifier", "membershipIdentifier", "name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ConfiguredTableAssociation, __self__).__init__(
            'aws-native:cleanrooms:ConfiguredTableAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ConfiguredTableAssociation':
        """
        Get an existing ConfiguredTableAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ConfiguredTableAssociationArgs.__new__(ConfiguredTableAssociationArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["configured_table_association_analysis_rules"] = None
        __props__.__dict__["configured_table_association_identifier"] = None
        __props__.__dict__["configured_table_identifier"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["membership_identifier"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["tags"] = None
        return ConfiguredTableAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Returns the Amazon Resource Name (ARN) of the specified configured table association.

        Example: `arn:aws:cleanrooms:us-east-1:111122223333:configuredtable/a1b2c3d4-5678-90ab-cdef-EXAMPLE33333`
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="configuredTableAssociationAnalysisRules")
    def configured_table_association_analysis_rules(self) -> pulumi.Output[Optional[Sequence['outputs.ConfiguredTableAssociationAnalysisRule']]]:
        """
        An analysis rule for a configured table association. This analysis rule specifies how data from the table can be used within its associated collaboration. In the console, the `ConfiguredTableAssociationAnalysisRule` is referred to as the *collaboration analysis rule* .
        """
        return pulumi.get(self, "configured_table_association_analysis_rules")

    @property
    @pulumi.getter(name="configuredTableAssociationIdentifier")
    def configured_table_association_identifier(self) -> pulumi.Output[builtins.str]:
        """
        Returns the unique identifier of the specified configured table association.

        Example: `a1b2c3d4-5678-90ab-cdef-EXAMPLE33333`
        """
        return pulumi.get(self, "configured_table_association_identifier")

    @property
    @pulumi.getter(name="configuredTableIdentifier")
    def configured_table_identifier(self) -> pulumi.Output[builtins.str]:
        """
        A unique identifier for the configured table to be associated to. Currently accepts a configured table ID.
        """
        return pulumi.get(self, "configured_table_identifier")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the configured table association.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="membershipIdentifier")
    def membership_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The unique ID for the membership this configured table association belongs to.
        """
        return pulumi.get(self, "membership_identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the configured table association, in lowercase. The table is identified by this name when running protected queries against the underlying data.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[builtins.str]:
        """
        The service will assume this role to access catalog metadata and query the table.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An arbitrary set of tags (key-value pairs) for this cleanrooms collaboration.
        """
        return pulumi.get(self, "tags")

