# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ConfiguredTableArgs', 'ConfiguredTable']

@pulumi.input_type
class ConfiguredTableArgs:
    def __init__(__self__, *,
                 allowed_columns: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 analysis_method: pulumi.Input['ConfiguredTableAnalysisMethod'],
                 table_reference: pulumi.Input[Union['ConfiguredTableTableReference0PropertiesArgs', 'ConfiguredTableTableReference1PropertiesArgs', 'ConfiguredTableTableReference2PropertiesArgs']],
                 analysis_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ConfiguredTableAnalysisRuleArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 selected_analysis_methods: Optional[pulumi.Input[Sequence[pulumi.Input['ConfiguredTableSelectedAnalysisMethod']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a ConfiguredTable resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_columns: The columns within the underlying AWS Glue table that can be utilized within collaborations.
        :param pulumi.Input['ConfiguredTableAnalysisMethod'] analysis_method: The analysis method for the configured table.
               
               `DIRECT_QUERY` allows SQL queries to be run directly on this table.
               
               `DIRECT_JOB` allows PySpark jobs to be run directly on this table.
               
               `MULTIPLE` allows both SQL queries and PySpark jobs to be run directly on this table.
        :param pulumi.Input[Union['ConfiguredTableTableReference0PropertiesArgs', 'ConfiguredTableTableReference1PropertiesArgs', 'ConfiguredTableTableReference2PropertiesArgs']] table_reference: The table that this configured table represents.
        :param pulumi.Input[Sequence[pulumi.Input['ConfiguredTableAnalysisRuleArgs']]] analysis_rules: The analysis rule that was created for the configured table.
        :param pulumi.Input[builtins.str] description: A description for the configured table.
        :param pulumi.Input[builtins.str] name: A name for the configured table.
        :param pulumi.Input[Sequence[pulumi.Input['ConfiguredTableSelectedAnalysisMethod']]] selected_analysis_methods: The selected analysis methods for the configured table.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An arbitrary set of tags (key-value pairs) for this cleanrooms collaboration.
        """
        pulumi.set(__self__, "allowed_columns", allowed_columns)
        pulumi.set(__self__, "analysis_method", analysis_method)
        pulumi.set(__self__, "table_reference", table_reference)
        if analysis_rules is not None:
            pulumi.set(__self__, "analysis_rules", analysis_rules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if selected_analysis_methods is not None:
            pulumi.set(__self__, "selected_analysis_methods", selected_analysis_methods)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="allowedColumns")
    def allowed_columns(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The columns within the underlying AWS Glue table that can be utilized within collaborations.
        """
        return pulumi.get(self, "allowed_columns")

    @allowed_columns.setter
    def allowed_columns(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "allowed_columns", value)

    @property
    @pulumi.getter(name="analysisMethod")
    def analysis_method(self) -> pulumi.Input['ConfiguredTableAnalysisMethod']:
        """
        The analysis method for the configured table.

        `DIRECT_QUERY` allows SQL queries to be run directly on this table.

        `DIRECT_JOB` allows PySpark jobs to be run directly on this table.

        `MULTIPLE` allows both SQL queries and PySpark jobs to be run directly on this table.
        """
        return pulumi.get(self, "analysis_method")

    @analysis_method.setter
    def analysis_method(self, value: pulumi.Input['ConfiguredTableAnalysisMethod']):
        pulumi.set(self, "analysis_method", value)

    @property
    @pulumi.getter(name="tableReference")
    def table_reference(self) -> pulumi.Input[Union['ConfiguredTableTableReference0PropertiesArgs', 'ConfiguredTableTableReference1PropertiesArgs', 'ConfiguredTableTableReference2PropertiesArgs']]:
        """
        The table that this configured table represents.
        """
        return pulumi.get(self, "table_reference")

    @table_reference.setter
    def table_reference(self, value: pulumi.Input[Union['ConfiguredTableTableReference0PropertiesArgs', 'ConfiguredTableTableReference1PropertiesArgs', 'ConfiguredTableTableReference2PropertiesArgs']]):
        pulumi.set(self, "table_reference", value)

    @property
    @pulumi.getter(name="analysisRules")
    def analysis_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfiguredTableAnalysisRuleArgs']]]]:
        """
        The analysis rule that was created for the configured table.
        """
        return pulumi.get(self, "analysis_rules")

    @analysis_rules.setter
    def analysis_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfiguredTableAnalysisRuleArgs']]]]):
        pulumi.set(self, "analysis_rules", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the configured table.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name for the configured table.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="selectedAnalysisMethods")
    def selected_analysis_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfiguredTableSelectedAnalysisMethod']]]]:
        """
        The selected analysis methods for the configured table.
        """
        return pulumi.get(self, "selected_analysis_methods")

    @selected_analysis_methods.setter
    def selected_analysis_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfiguredTableSelectedAnalysisMethod']]]]):
        pulumi.set(self, "selected_analysis_methods", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An arbitrary set of tags (key-value pairs) for this cleanrooms collaboration.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:cleanrooms:ConfiguredTable")
class ConfiguredTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_columns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 analysis_method: Optional[pulumi.Input['ConfiguredTableAnalysisMethod']] = None,
                 analysis_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfiguredTableAnalysisRuleArgs', 'ConfiguredTableAnalysisRuleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 selected_analysis_methods: Optional[pulumi.Input[Sequence[pulumi.Input['ConfiguredTableSelectedAnalysisMethod']]]] = None,
                 table_reference: Optional[pulumi.Input[Union[Union['ConfiguredTableTableReference0PropertiesArgs', 'ConfiguredTableTableReference0PropertiesArgsDict'], Union['ConfiguredTableTableReference1PropertiesArgs', 'ConfiguredTableTableReference1PropertiesArgsDict'], Union['ConfiguredTableTableReference2PropertiesArgs', 'ConfiguredTableTableReference2PropertiesArgsDict']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Represents a table that can be associated with collaborations

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_columns: The columns within the underlying AWS Glue table that can be utilized within collaborations.
        :param pulumi.Input['ConfiguredTableAnalysisMethod'] analysis_method: The analysis method for the configured table.
               
               `DIRECT_QUERY` allows SQL queries to be run directly on this table.
               
               `DIRECT_JOB` allows PySpark jobs to be run directly on this table.
               
               `MULTIPLE` allows both SQL queries and PySpark jobs to be run directly on this table.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfiguredTableAnalysisRuleArgs', 'ConfiguredTableAnalysisRuleArgsDict']]]] analysis_rules: The analysis rule that was created for the configured table.
        :param pulumi.Input[builtins.str] description: A description for the configured table.
        :param pulumi.Input[builtins.str] name: A name for the configured table.
        :param pulumi.Input[Sequence[pulumi.Input['ConfiguredTableSelectedAnalysisMethod']]] selected_analysis_methods: The selected analysis methods for the configured table.
        :param pulumi.Input[Union[Union['ConfiguredTableTableReference0PropertiesArgs', 'ConfiguredTableTableReference0PropertiesArgsDict'], Union['ConfiguredTableTableReference1PropertiesArgs', 'ConfiguredTableTableReference1PropertiesArgsDict'], Union['ConfiguredTableTableReference2PropertiesArgs', 'ConfiguredTableTableReference2PropertiesArgsDict']]] table_reference: The table that this configured table represents.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An arbitrary set of tags (key-value pairs) for this cleanrooms collaboration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfiguredTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a table that can be associated with collaborations

        :param str resource_name: The name of the resource.
        :param ConfiguredTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfiguredTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_columns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 analysis_method: Optional[pulumi.Input['ConfiguredTableAnalysisMethod']] = None,
                 analysis_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfiguredTableAnalysisRuleArgs', 'ConfiguredTableAnalysisRuleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 selected_analysis_methods: Optional[pulumi.Input[Sequence[pulumi.Input['ConfiguredTableSelectedAnalysisMethod']]]] = None,
                 table_reference: Optional[pulumi.Input[Union[Union['ConfiguredTableTableReference0PropertiesArgs', 'ConfiguredTableTableReference0PropertiesArgsDict'], Union['ConfiguredTableTableReference1PropertiesArgs', 'ConfiguredTableTableReference1PropertiesArgsDict'], Union['ConfiguredTableTableReference2PropertiesArgs', 'ConfiguredTableTableReference2PropertiesArgsDict']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfiguredTableArgs.__new__(ConfiguredTableArgs)

            if allowed_columns is None and not opts.urn:
                raise TypeError("Missing required property 'allowed_columns'")
            __props__.__dict__["allowed_columns"] = allowed_columns
            if analysis_method is None and not opts.urn:
                raise TypeError("Missing required property 'analysis_method'")
            __props__.__dict__["analysis_method"] = analysis_method
            __props__.__dict__["analysis_rules"] = analysis_rules
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["selected_analysis_methods"] = selected_analysis_methods
            if table_reference is None and not opts.urn:
                raise TypeError("Missing required property 'table_reference'")
            __props__.__dict__["table_reference"] = table_reference
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["configured_table_identifier"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["allowedColumns[*]", "tableReference"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ConfiguredTable, __self__).__init__(
            'aws-native:cleanrooms:ConfiguredTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ConfiguredTable':
        """
        Get an existing ConfiguredTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ConfiguredTableArgs.__new__(ConfiguredTableArgs)

        __props__.__dict__["allowed_columns"] = None
        __props__.__dict__["analysis_method"] = None
        __props__.__dict__["analysis_rules"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["configured_table_identifier"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["selected_analysis_methods"] = None
        __props__.__dict__["table_reference"] = None
        __props__.__dict__["tags"] = None
        return ConfiguredTable(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedColumns")
    def allowed_columns(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The columns within the underlying AWS Glue table that can be utilized within collaborations.
        """
        return pulumi.get(self, "allowed_columns")

    @property
    @pulumi.getter(name="analysisMethod")
    def analysis_method(self) -> pulumi.Output['ConfiguredTableAnalysisMethod']:
        """
        The analysis method for the configured table.

        `DIRECT_QUERY` allows SQL queries to be run directly on this table.

        `DIRECT_JOB` allows PySpark jobs to be run directly on this table.

        `MULTIPLE` allows both SQL queries and PySpark jobs to be run directly on this table.
        """
        return pulumi.get(self, "analysis_method")

    @property
    @pulumi.getter(name="analysisRules")
    def analysis_rules(self) -> pulumi.Output[Optional[Sequence['outputs.ConfiguredTableAnalysisRule']]]:
        """
        The analysis rule that was created for the configured table.
        """
        return pulumi.get(self, "analysis_rules")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Returns the Amazon Resource Name (ARN) of the specified configured table.

        Example: `arn:aws:cleanrooms:us-east-1:111122223333:configuredtable/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="configuredTableIdentifier")
    def configured_table_identifier(self) -> pulumi.Output[builtins.str]:
        """
        Returns the unique identifier of the specified configured table.

        Example: `a1b2c3d4-5678-90ab-cdef-EXAMPLE33333`
        """
        return pulumi.get(self, "configured_table_identifier")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description for the configured table.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A name for the configured table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="selectedAnalysisMethods")
    def selected_analysis_methods(self) -> pulumi.Output[Optional[Sequence['ConfiguredTableSelectedAnalysisMethod']]]:
        """
        The selected analysis methods for the configured table.
        """
        return pulumi.get(self, "selected_analysis_methods")

    @property
    @pulumi.getter(name="tableReference")
    def table_reference(self) -> pulumi.Output[Any]:
        """
        The table that this configured table represents.
        """
        return pulumi.get(self, "table_reference")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An arbitrary set of tags (key-value pairs) for this cleanrooms collaboration.
        """
        return pulumi.get(self, "tags")

