# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['AnalysisTemplateArgs', 'AnalysisTemplate']

@pulumi.input_type
class AnalysisTemplateArgs:
    def __init__(__self__, *,
                 format: pulumi.Input['AnalysisTemplateFormat'],
                 membership_identifier: pulumi.Input[builtins.str],
                 source: pulumi.Input[Union['AnalysisTemplateAnalysisSource0PropertiesArgs', 'AnalysisTemplateAnalysisSource1PropertiesArgs']],
                 analysis_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['AnalysisTemplateAnalysisParameterArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[pulumi.Input['AnalysisTemplateAnalysisSchemaArgs']] = None,
                 source_metadata: Optional[pulumi.Input['AnalysisTemplateAnalysisSourceMetadataPropertiesArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a AnalysisTemplate resource.
        :param pulumi.Input['AnalysisTemplateFormat'] format: The format of the analysis template.
        :param pulumi.Input[builtins.str] membership_identifier: The identifier for a membership resource.
        :param pulumi.Input[Union['AnalysisTemplateAnalysisSource0PropertiesArgs', 'AnalysisTemplateAnalysisSource1PropertiesArgs']] source: The source of the analysis template.
        :param pulumi.Input[Sequence[pulumi.Input['AnalysisTemplateAnalysisParameterArgs']]] analysis_parameters: The member who can query can provide this placeholder for a literal data value in an analysis template
        :param pulumi.Input[builtins.str] description: The description of the analysis template.
        :param pulumi.Input[builtins.str] name: The name of the analysis template.
        :param pulumi.Input['AnalysisTemplateAnalysisSchemaArgs'] schema: The entire schema object.
        :param pulumi.Input['AnalysisTemplateAnalysisSourceMetadataPropertiesArgs'] source_metadata: The source metadata for the analysis template.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An arbitrary set of tags (key-value pairs) for this cleanrooms analysis template.
        """
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "membership_identifier", membership_identifier)
        pulumi.set(__self__, "source", source)
        if analysis_parameters is not None:
            pulumi.set(__self__, "analysis_parameters", analysis_parameters)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if source_metadata is not None:
            pulumi.set(__self__, "source_metadata", source_metadata)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def format(self) -> pulumi.Input['AnalysisTemplateFormat']:
        """
        The format of the analysis template.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: pulumi.Input['AnalysisTemplateFormat']):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="membershipIdentifier")
    def membership_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The identifier for a membership resource.
        """
        return pulumi.get(self, "membership_identifier")

    @membership_identifier.setter
    def membership_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "membership_identifier", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[Union['AnalysisTemplateAnalysisSource0PropertiesArgs', 'AnalysisTemplateAnalysisSource1PropertiesArgs']]:
        """
        The source of the analysis template.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[Union['AnalysisTemplateAnalysisSource0PropertiesArgs', 'AnalysisTemplateAnalysisSource1PropertiesArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="analysisParameters")
    def analysis_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AnalysisTemplateAnalysisParameterArgs']]]]:
        """
        The member who can query can provide this placeholder for a literal data value in an analysis template
        """
        return pulumi.get(self, "analysis_parameters")

    @analysis_parameters.setter
    def analysis_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AnalysisTemplateAnalysisParameterArgs']]]]):
        pulumi.set(self, "analysis_parameters", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the analysis template.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the analysis template.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input['AnalysisTemplateAnalysisSchemaArgs']]:
        """
        The entire schema object.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input['AnalysisTemplateAnalysisSchemaArgs']]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter(name="sourceMetadata")
    def source_metadata(self) -> Optional[pulumi.Input['AnalysisTemplateAnalysisSourceMetadataPropertiesArgs']]:
        """
        The source metadata for the analysis template.
        """
        return pulumi.get(self, "source_metadata")

    @source_metadata.setter
    def source_metadata(self, value: Optional[pulumi.Input['AnalysisTemplateAnalysisSourceMetadataPropertiesArgs']]):
        pulumi.set(self, "source_metadata", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An arbitrary set of tags (key-value pairs) for this cleanrooms analysis template.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:cleanrooms:AnalysisTemplate")
class AnalysisTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analysis_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AnalysisTemplateAnalysisParameterArgs', 'AnalysisTemplateAnalysisParameterArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 format: Optional[pulumi.Input['AnalysisTemplateFormat']] = None,
                 membership_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[pulumi.Input[Union['AnalysisTemplateAnalysisSchemaArgs', 'AnalysisTemplateAnalysisSchemaArgsDict']]] = None,
                 source: Optional[pulumi.Input[Union[Union['AnalysisTemplateAnalysisSource0PropertiesArgs', 'AnalysisTemplateAnalysisSource0PropertiesArgsDict'], Union['AnalysisTemplateAnalysisSource1PropertiesArgs', 'AnalysisTemplateAnalysisSource1PropertiesArgsDict']]]] = None,
                 source_metadata: Optional[pulumi.Input[Union['AnalysisTemplateAnalysisSourceMetadataPropertiesArgs', 'AnalysisTemplateAnalysisSourceMetadataPropertiesArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Represents a stored analysis within a collaboration

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AnalysisTemplateAnalysisParameterArgs', 'AnalysisTemplateAnalysisParameterArgsDict']]]] analysis_parameters: The member who can query can provide this placeholder for a literal data value in an analysis template
        :param pulumi.Input[builtins.str] description: The description of the analysis template.
        :param pulumi.Input['AnalysisTemplateFormat'] format: The format of the analysis template.
        :param pulumi.Input[builtins.str] membership_identifier: The identifier for a membership resource.
        :param pulumi.Input[builtins.str] name: The name of the analysis template.
        :param pulumi.Input[Union['AnalysisTemplateAnalysisSchemaArgs', 'AnalysisTemplateAnalysisSchemaArgsDict']] schema: The entire schema object.
        :param pulumi.Input[Union[Union['AnalysisTemplateAnalysisSource0PropertiesArgs', 'AnalysisTemplateAnalysisSource0PropertiesArgsDict'], Union['AnalysisTemplateAnalysisSource1PropertiesArgs', 'AnalysisTemplateAnalysisSource1PropertiesArgsDict']]] source: The source of the analysis template.
        :param pulumi.Input[Union['AnalysisTemplateAnalysisSourceMetadataPropertiesArgs', 'AnalysisTemplateAnalysisSourceMetadataPropertiesArgsDict']] source_metadata: The source metadata for the analysis template.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An arbitrary set of tags (key-value pairs) for this cleanrooms analysis template.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AnalysisTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a stored analysis within a collaboration

        :param str resource_name: The name of the resource.
        :param AnalysisTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AnalysisTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analysis_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AnalysisTemplateAnalysisParameterArgs', 'AnalysisTemplateAnalysisParameterArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 format: Optional[pulumi.Input['AnalysisTemplateFormat']] = None,
                 membership_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[pulumi.Input[Union['AnalysisTemplateAnalysisSchemaArgs', 'AnalysisTemplateAnalysisSchemaArgsDict']]] = None,
                 source: Optional[pulumi.Input[Union[Union['AnalysisTemplateAnalysisSource0PropertiesArgs', 'AnalysisTemplateAnalysisSource0PropertiesArgsDict'], Union['AnalysisTemplateAnalysisSource1PropertiesArgs', 'AnalysisTemplateAnalysisSource1PropertiesArgsDict']]]] = None,
                 source_metadata: Optional[pulumi.Input[Union['AnalysisTemplateAnalysisSourceMetadataPropertiesArgs', 'AnalysisTemplateAnalysisSourceMetadataPropertiesArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AnalysisTemplateArgs.__new__(AnalysisTemplateArgs)

            __props__.__dict__["analysis_parameters"] = analysis_parameters
            __props__.__dict__["description"] = description
            if format is None and not opts.urn:
                raise TypeError("Missing required property 'format'")
            __props__.__dict__["format"] = format
            if membership_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'membership_identifier'")
            __props__.__dict__["membership_identifier"] = membership_identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["schema"] = schema
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["source_metadata"] = source_metadata
            __props__.__dict__["tags"] = tags
            __props__.__dict__["analysis_template_identifier"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["collaboration_arn"] = None
            __props__.__dict__["collaboration_identifier"] = None
            __props__.__dict__["membership_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["analysisParameters[*]", "format", "membershipIdentifier", "name", "schema", "source"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(AnalysisTemplate, __self__).__init__(
            'aws-native:cleanrooms:AnalysisTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AnalysisTemplate':
        """
        Get an existing AnalysisTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AnalysisTemplateArgs.__new__(AnalysisTemplateArgs)

        __props__.__dict__["analysis_parameters"] = None
        __props__.__dict__["analysis_template_identifier"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["collaboration_arn"] = None
        __props__.__dict__["collaboration_identifier"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["format"] = None
        __props__.__dict__["membership_arn"] = None
        __props__.__dict__["membership_identifier"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["schema"] = None
        __props__.__dict__["source"] = None
        __props__.__dict__["source_metadata"] = None
        __props__.__dict__["tags"] = None
        return AnalysisTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="analysisParameters")
    def analysis_parameters(self) -> pulumi.Output[Optional[Sequence['outputs.AnalysisTemplateAnalysisParameter']]]:
        """
        The member who can query can provide this placeholder for a literal data value in an analysis template
        """
        return pulumi.get(self, "analysis_parameters")

    @property
    @pulumi.getter(name="analysisTemplateIdentifier")
    def analysis_template_identifier(self) -> pulumi.Output[builtins.str]:
        """
        Returns the identifier for the analysis template.

        Example: `a1b2c3d4-5678-90ab-cdef-EXAMPLE2222`
        """
        return pulumi.get(self, "analysis_template_identifier")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Returns the Amazon Resource Name (ARN) of the analysis template.

        Example: `arn:aws:cleanrooms:us-east-1:111122223333:membership/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111/analysistemplates/a1b2c3d4-5678-90ab-cdef-EXAMPLE2222`
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="collaborationArn")
    def collaboration_arn(self) -> pulumi.Output[builtins.str]:
        """
        Returns the unique ARN for the analysis template’s associated collaboration.

        Example: `arn:aws:cleanrooms:us-east-1:111122223333:collaboration/a1b2c3d4-5678-90ab-cdef-EXAMPLE33333`
        """
        return pulumi.get(self, "collaboration_arn")

    @property
    @pulumi.getter(name="collaborationIdentifier")
    def collaboration_identifier(self) -> pulumi.Output[builtins.str]:
        """
        Returns the unique ID for the associated collaboration of the analysis template.

        Example: `a1b2c3d4-5678-90ab-cdef-EXAMPLE33333`
        """
        return pulumi.get(self, "collaboration_identifier")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the analysis template.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def format(self) -> pulumi.Output['AnalysisTemplateFormat']:
        """
        The format of the analysis template.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="membershipArn")
    def membership_arn(self) -> pulumi.Output[builtins.str]:
        """
        Returns the Amazon Resource Name (ARN) of the member who created the analysis template.

        Example: `arn:aws:cleanrooms:us-east-1:111122223333:membership/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`
        """
        return pulumi.get(self, "membership_arn")

    @property
    @pulumi.getter(name="membershipIdentifier")
    def membership_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The identifier for a membership resource.
        """
        return pulumi.get(self, "membership_identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the analysis template.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Output[Optional['outputs.AnalysisTemplateAnalysisSchema']]:
        """
        The entire schema object.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[Any]:
        """
        The source of the analysis template.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceMetadata")
    def source_metadata(self) -> pulumi.Output[Optional['outputs.AnalysisTemplateAnalysisSourceMetadataProperties']]:
        """
        The source metadata for the analysis template.
        """
        return pulumi.get(self, "source_metadata")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An arbitrary set of tags (key-value pairs) for this cleanrooms analysis template.
        """
        return pulumi.get(self, "tags")

