# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetCustomActionResult',
    'AwaitableGetCustomActionResult',
    'get_custom_action',
    'get_custom_action_output',
]

@pulumi.output_type
class GetCustomActionResult:
    def __init__(__self__, alias_name=None, attachments=None, custom_action_arn=None, definition=None, tags=None):
        if alias_name and not isinstance(alias_name, str):
            raise TypeError("Expected argument 'alias_name' to be a str")
        pulumi.set(__self__, "alias_name", alias_name)
        if attachments and not isinstance(attachments, list):
            raise TypeError("Expected argument 'attachments' to be a list")
        pulumi.set(__self__, "attachments", attachments)
        if custom_action_arn and not isinstance(custom_action_arn, str):
            raise TypeError("Expected argument 'custom_action_arn' to be a str")
        pulumi.set(__self__, "custom_action_arn", custom_action_arn)
        if definition and not isinstance(definition, dict):
            raise TypeError("Expected argument 'definition' to be a dict")
        pulumi.set(__self__, "definition", definition)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="aliasName")
    def alias_name(self) -> Optional[builtins.str]:
        """
        The name used to invoke this action in a chat channel. For example, `@Amazon Q run my-alias` .
        """
        return pulumi.get(self, "alias_name")

    @property
    @pulumi.getter
    def attachments(self) -> Optional[Sequence['outputs.CustomActionAttachment']]:
        """
        Defines when this custom action button should be attached to a notification.
        """
        return pulumi.get(self, "attachments")

    @property
    @pulumi.getter(name="customActionArn")
    def custom_action_arn(self) -> Optional[builtins.str]:
        """
        The fully defined ARN of the custom action.
        """
        return pulumi.get(self, "custom_action_arn")

    @property
    @pulumi.getter
    def definition(self) -> Optional['outputs.CustomActionDefinition']:
        """
        The definition of the command to run when invoked as an alias or as an action button.
        """
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags to add to the configuration.
        """
        return pulumi.get(self, "tags")


class AwaitableGetCustomActionResult(GetCustomActionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomActionResult(
            alias_name=self.alias_name,
            attachments=self.attachments,
            custom_action_arn=self.custom_action_arn,
            definition=self.definition,
            tags=self.tags)


def get_custom_action(custom_action_arn: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomActionResult:
    """
    Definition of AWS::Chatbot::CustomAction Resource Type


    :param builtins.str custom_action_arn: The fully defined ARN of the custom action.
    """
    __args__ = dict()
    __args__['customActionArn'] = custom_action_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:chatbot:getCustomAction', __args__, opts=opts, typ=GetCustomActionResult).value

    return AwaitableGetCustomActionResult(
        alias_name=pulumi.get(__ret__, 'alias_name'),
        attachments=pulumi.get(__ret__, 'attachments'),
        custom_action_arn=pulumi.get(__ret__, 'custom_action_arn'),
        definition=pulumi.get(__ret__, 'definition'),
        tags=pulumi.get(__ret__, 'tags'))
def get_custom_action_output(custom_action_arn: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCustomActionResult]:
    """
    Definition of AWS::Chatbot::CustomAction Resource Type


    :param builtins.str custom_action_arn: The fully defined ARN of the custom action.
    """
    __args__ = dict()
    __args__['customActionArn'] = custom_action_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:chatbot:getCustomAction', __args__, opts=opts, typ=GetCustomActionResult)
    return __ret__.apply(lambda __response__: GetCustomActionResult(
        alias_name=pulumi.get(__response__, 'alias_name'),
        attachments=pulumi.get(__response__, 'attachments'),
        custom_action_arn=pulumi.get(__response__, 'custom_action_arn'),
        definition=pulumi.get(__response__, 'definition'),
        tags=pulumi.get(__response__, 'tags')))
