# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['CustomActionArgs', 'CustomAction']

@pulumi.input_type
class CustomActionArgs:
    def __init__(__self__, *,
                 definition: pulumi.Input['CustomActionDefinitionArgs'],
                 action_name: Optional[pulumi.Input[builtins.str]] = None,
                 alias_name: Optional[pulumi.Input[builtins.str]] = None,
                 attachments: Optional[pulumi.Input[Sequence[pulumi.Input['CustomActionAttachmentArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a CustomAction resource.
        :param pulumi.Input['CustomActionDefinitionArgs'] definition: The definition of the command to run when invoked as an alias or as an action button.
        :param pulumi.Input[builtins.str] action_name: The name of the custom action. This name is included in the Amazon Resource Name (ARN).
        :param pulumi.Input[builtins.str] alias_name: The name used to invoke this action in a chat channel. For example, `@Amazon Q run my-alias` .
        :param pulumi.Input[Sequence[pulumi.Input['CustomActionAttachmentArgs']]] attachments: Defines when this custom action button should be attached to a notification.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags to add to the configuration.
        """
        pulumi.set(__self__, "definition", definition)
        if action_name is not None:
            pulumi.set(__self__, "action_name", action_name)
        if alias_name is not None:
            pulumi.set(__self__, "alias_name", alias_name)
        if attachments is not None:
            pulumi.set(__self__, "attachments", attachments)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def definition(self) -> pulumi.Input['CustomActionDefinitionArgs']:
        """
        The definition of the command to run when invoked as an alias or as an action button.
        """
        return pulumi.get(self, "definition")

    @definition.setter
    def definition(self, value: pulumi.Input['CustomActionDefinitionArgs']):
        pulumi.set(self, "definition", value)

    @property
    @pulumi.getter(name="actionName")
    def action_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the custom action. This name is included in the Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "action_name")

    @action_name.setter
    def action_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action_name", value)

    @property
    @pulumi.getter(name="aliasName")
    def alias_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name used to invoke this action in a chat channel. For example, `@Amazon Q run my-alias` .
        """
        return pulumi.get(self, "alias_name")

    @alias_name.setter
    def alias_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alias_name", value)

    @property
    @pulumi.getter
    def attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomActionAttachmentArgs']]]]:
        """
        Defines when this custom action button should be attached to a notification.
        """
        return pulumi.get(self, "attachments")

    @attachments.setter
    def attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomActionAttachmentArgs']]]]):
        pulumi.set(self, "attachments", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags to add to the configuration.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:chatbot:CustomAction")
class CustomAction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_name: Optional[pulumi.Input[builtins.str]] = None,
                 alias_name: Optional[pulumi.Input[builtins.str]] = None,
                 attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomActionAttachmentArgs', 'CustomActionAttachmentArgsDict']]]]] = None,
                 definition: Optional[pulumi.Input[Union['CustomActionDefinitionArgs', 'CustomActionDefinitionArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::Chatbot::CustomAction Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action_name: The name of the custom action. This name is included in the Amazon Resource Name (ARN).
        :param pulumi.Input[builtins.str] alias_name: The name used to invoke this action in a chat channel. For example, `@Amazon Q run my-alias` .
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomActionAttachmentArgs', 'CustomActionAttachmentArgsDict']]]] attachments: Defines when this custom action button should be attached to a notification.
        :param pulumi.Input[Union['CustomActionDefinitionArgs', 'CustomActionDefinitionArgsDict']] definition: The definition of the command to run when invoked as an alias or as an action button.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags to add to the configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomActionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Chatbot::CustomAction Resource Type

        :param str resource_name: The name of the resource.
        :param CustomActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_name: Optional[pulumi.Input[builtins.str]] = None,
                 alias_name: Optional[pulumi.Input[builtins.str]] = None,
                 attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomActionAttachmentArgs', 'CustomActionAttachmentArgsDict']]]]] = None,
                 definition: Optional[pulumi.Input[Union['CustomActionDefinitionArgs', 'CustomActionDefinitionArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomActionArgs.__new__(CustomActionArgs)

            __props__.__dict__["action_name"] = action_name
            __props__.__dict__["alias_name"] = alias_name
            __props__.__dict__["attachments"] = attachments
            if definition is None and not opts.urn:
                raise TypeError("Missing required property 'definition'")
            __props__.__dict__["definition"] = definition
            __props__.__dict__["tags"] = tags
            __props__.__dict__["custom_action_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["actionName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(CustomAction, __self__).__init__(
            'aws-native:chatbot:CustomAction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'CustomAction':
        """
        Get an existing CustomAction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CustomActionArgs.__new__(CustomActionArgs)

        __props__.__dict__["action_name"] = None
        __props__.__dict__["alias_name"] = None
        __props__.__dict__["attachments"] = None
        __props__.__dict__["custom_action_arn"] = None
        __props__.__dict__["definition"] = None
        __props__.__dict__["tags"] = None
        return CustomAction(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="actionName")
    def action_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the custom action. This name is included in the Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "action_name")

    @property
    @pulumi.getter(name="aliasName")
    def alias_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name used to invoke this action in a chat channel. For example, `@Amazon Q run my-alias` .
        """
        return pulumi.get(self, "alias_name")

    @property
    @pulumi.getter
    def attachments(self) -> pulumi.Output[Optional[Sequence['outputs.CustomActionAttachment']]]:
        """
        Defines when this custom action button should be attached to a notification.
        """
        return pulumi.get(self, "attachments")

    @property
    @pulumi.getter(name="customActionArn")
    def custom_action_arn(self) -> pulumi.Output[builtins.str]:
        """
        The fully defined ARN of the custom action.
        """
        return pulumi.get(self, "custom_action_arn")

    @property
    @pulumi.getter
    def definition(self) -> pulumi.Output['outputs.CustomActionDefinition']:
        """
        The definition of the command to run when invoked as an alias or as an action button.
        """
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags to add to the configuration.
        """
        return pulumi.get(self, "tags")

