# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAccountResult',
    'AwaitableGetAccountResult',
    'get_account',
    'get_account_output',
]

@pulumi.output_type
class GetAccountResult:
    def __init__(__self__, account_id=None, expiry_events_configuration=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if expiry_events_configuration and not isinstance(expiry_events_configuration, dict):
            raise TypeError("Expected argument 'expiry_events_configuration' to be a dict")
        pulumi.set(__self__, "expiry_events_configuration", expiry_events_configuration)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[builtins.str]:
        """
        ID of the AWS account that owns the certificate.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="expiryEventsConfiguration")
    def expiry_events_configuration(self) -> Optional['outputs.AccountExpiryEventsConfiguration']:
        """
        Object containing expiration events options associated with an AWS account . For more information, see [ExpiryEventsConfiguration](https://docs.aws.amazon.com/acm/latest/APIReference/API_ExpiryEventsConfiguration.html) in the API reference.
        """
        return pulumi.get(self, "expiry_events_configuration")


class AwaitableGetAccountResult(GetAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountResult(
            account_id=self.account_id,
            expiry_events_configuration=self.expiry_events_configuration)


def get_account(account_id: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountResult:
    """
    Resource schema for AWS::CertificateManager::Account.


    :param builtins.str account_id: ID of the AWS account that owns the certificate.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:certificatemanager:getAccount', __args__, opts=opts, typ=GetAccountResult).value

    return AwaitableGetAccountResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        expiry_events_configuration=pulumi.get(__ret__, 'expiry_events_configuration'))
def get_account_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountResult]:
    """
    Resource schema for AWS::CertificateManager::Account.


    :param builtins.str account_id: ID of the AWS account that owns the certificate.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:certificatemanager:getAccount', __args__, opts=opts, typ=GetAccountResult)
    return __ret__.apply(lambda __response__: GetAccountResult(
        account_id=pulumi.get(__response__, 'account_id'),
        expiry_events_configuration=pulumi.get(__response__, 'expiry_events_configuration')))
