# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TypeArgs', 'Type']

@pulumi.input_type
class TypeArgs:
    def __init__(__self__, *,
                 fields: pulumi.Input[Sequence[pulumi.Input['TypeFieldArgs']]],
                 keyspace_name: pulumi.Input[builtins.str],
                 type_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Type resource.
        :param pulumi.Input[Sequence[pulumi.Input['TypeFieldArgs']]] fields: Field definitions of the User-Defined Type
        :param pulumi.Input[builtins.str] keyspace_name: Name of the Keyspace which contains the User-Defined Type.
        :param pulumi.Input[builtins.str] type_name: Name of the User-Defined Type.
        """
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "keyspace_name", keyspace_name)
        if type_name is not None:
            pulumi.set(__self__, "type_name", type_name)

    @property
    @pulumi.getter
    def fields(self) -> pulumi.Input[Sequence[pulumi.Input['TypeFieldArgs']]]:
        """
        Field definitions of the User-Defined Type
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: pulumi.Input[Sequence[pulumi.Input['TypeFieldArgs']]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter(name="keyspaceName")
    def keyspace_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the Keyspace which contains the User-Defined Type.
        """
        return pulumi.get(self, "keyspace_name")

    @keyspace_name.setter
    def keyspace_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "keyspace_name", value)

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the User-Defined Type.
        """
        return pulumi.get(self, "type_name")

    @type_name.setter
    def type_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type_name", value)


@pulumi.type_token("aws-native:cassandra:Type")
class Type(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TypeFieldArgs', 'TypeFieldArgsDict']]]]] = None,
                 keyspace_name: Optional[pulumi.Input[builtins.str]] = None,
                 type_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource schema for AWS::Cassandra::Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TypeFieldArgs', 'TypeFieldArgsDict']]]] fields: Field definitions of the User-Defined Type
        :param pulumi.Input[builtins.str] keyspace_name: Name of the Keyspace which contains the User-Defined Type.
        :param pulumi.Input[builtins.str] type_name: Name of the User-Defined Type.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TypeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::Cassandra::Type

        :param str resource_name: The name of the resource.
        :param TypeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TypeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TypeFieldArgs', 'TypeFieldArgsDict']]]]] = None,
                 keyspace_name: Optional[pulumi.Input[builtins.str]] = None,
                 type_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TypeArgs.__new__(TypeArgs)

            if fields is None and not opts.urn:
                raise TypeError("Missing required property 'fields'")
            __props__.__dict__["fields"] = fields
            if keyspace_name is None and not opts.urn:
                raise TypeError("Missing required property 'keyspace_name'")
            __props__.__dict__["keyspace_name"] = keyspace_name
            __props__.__dict__["type_name"] = type_name
            __props__.__dict__["direct_parent_types"] = None
            __props__.__dict__["direct_referring_tables"] = None
            __props__.__dict__["keyspace_arn"] = None
            __props__.__dict__["last_modified_timestamp"] = None
            __props__.__dict__["max_nesting_depth"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["fields[*]", "keyspaceName", "typeName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Type, __self__).__init__(
            'aws-native:cassandra:Type',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Type':
        """
        Get an existing Type resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TypeArgs.__new__(TypeArgs)

        __props__.__dict__["direct_parent_types"] = None
        __props__.__dict__["direct_referring_tables"] = None
        __props__.__dict__["fields"] = None
        __props__.__dict__["keyspace_arn"] = None
        __props__.__dict__["keyspace_name"] = None
        __props__.__dict__["last_modified_timestamp"] = None
        __props__.__dict__["max_nesting_depth"] = None
        __props__.__dict__["type_name"] = None
        return Type(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="directParentTypes")
    def direct_parent_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of parent User-Defined Types that directly reference the User-Defined Type in their fields.
        """
        return pulumi.get(self, "direct_parent_types")

    @property
    @pulumi.getter(name="directReferringTables")
    def direct_referring_tables(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of Tables that directly reference the User-Defined Type in their columns.
        """
        return pulumi.get(self, "direct_referring_tables")

    @property
    @pulumi.getter
    def fields(self) -> pulumi.Output[Sequence['outputs.TypeField']]:
        """
        Field definitions of the User-Defined Type
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="keyspaceArn")
    def keyspace_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Keyspace which contains the User-Defined Type.
        """
        return pulumi.get(self, "keyspace_arn")

    @property
    @pulumi.getter(name="keyspaceName")
    def keyspace_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Keyspace which contains the User-Defined Type.
        """
        return pulumi.get(self, "keyspace_name")

    @property
    @pulumi.getter(name="lastModifiedTimestamp")
    def last_modified_timestamp(self) -> pulumi.Output[builtins.float]:
        """
        Timestamp of the last time the User-Defined Type's meta data was modified.
        """
        return pulumi.get(self, "last_modified_timestamp")

    @property
    @pulumi.getter(name="maxNestingDepth")
    def max_nesting_depth(self) -> pulumi.Output[builtins.int]:
        """
        Maximum nesting depth of the User-Defined Type across the field types.
        """
        return pulumi.get(self, "max_nesting_depth")

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the User-Defined Type.
        """
        return pulumi.get(self, "type_name")

