# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetTableResult',
    'AwaitableGetTableResult',
    'get_table',
    'get_table_output',
]

@pulumi.output_type
class GetTableResult:
    def __init__(__self__, billing_mode=None, default_time_to_live=None, encryption_specification=None, point_in_time_recovery_enabled=None, regular_columns=None, tags=None):
        if billing_mode and not isinstance(billing_mode, dict):
            raise TypeError("Expected argument 'billing_mode' to be a dict")
        pulumi.set(__self__, "billing_mode", billing_mode)
        if default_time_to_live and not isinstance(default_time_to_live, int):
            raise TypeError("Expected argument 'default_time_to_live' to be a int")
        pulumi.set(__self__, "default_time_to_live", default_time_to_live)
        if encryption_specification and not isinstance(encryption_specification, dict):
            raise TypeError("Expected argument 'encryption_specification' to be a dict")
        pulumi.set(__self__, "encryption_specification", encryption_specification)
        if point_in_time_recovery_enabled and not isinstance(point_in_time_recovery_enabled, bool):
            raise TypeError("Expected argument 'point_in_time_recovery_enabled' to be a bool")
        pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        if regular_columns and not isinstance(regular_columns, list):
            raise TypeError("Expected argument 'regular_columns' to be a list")
        pulumi.set(__self__, "regular_columns", regular_columns)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> Optional['outputs.TableBillingMode']:
        """
        The billing mode for the table, which determines how you'll be charged for reads and writes:

        - *On-demand mode* (default) - You pay based on the actual reads and writes your application performs.
        - *Provisioned mode* - Lets you specify the number of reads and writes per second that you need for your application.

        If you don't specify a value for this property, then the table will use on-demand mode.
        """
        return pulumi.get(self, "billing_mode")

    @property
    @pulumi.getter(name="defaultTimeToLive")
    def default_time_to_live(self) -> Optional[builtins.int]:
        """
        Default TTL (Time To Live) in seconds, where zero is disabled. If the value is greater than zero, TTL is enabled for the entire table and an expiration timestamp is added to each column.
        """
        return pulumi.get(self, "default_time_to_live")

    @property
    @pulumi.getter(name="encryptionSpecification")
    def encryption_specification(self) -> Optional['outputs.TableEncryptionSpecification']:
        """
        The encryption at rest options for the table.

        - *AWS owned key* (default) - The key is owned by Amazon Keyspaces .
        - *Customer managed key* - The key is stored in your account and is created, owned, and managed by you.

        > If you choose encryption with a customer managed key, you must specify a valid customer managed KMS key with permissions granted to Amazon Keyspaces.

        For more information, see [Encryption at rest in Amazon Keyspaces](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html) in the *Amazon Keyspaces Developer Guide* .
        """
        return pulumi.get(self, "encryption_specification")

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> Optional[builtins.bool]:
        """
        Indicates whether point in time recovery is enabled (true) or disabled (false) on the table
        """
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @property
    @pulumi.getter(name="regularColumns")
    def regular_columns(self) -> Optional[Sequence['outputs.TableColumn']]:
        """
        Non-key columns of the table
        """
        return pulumi.get(self, "regular_columns")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource
        """
        return pulumi.get(self, "tags")


class AwaitableGetTableResult(GetTableResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTableResult(
            billing_mode=self.billing_mode,
            default_time_to_live=self.default_time_to_live,
            encryption_specification=self.encryption_specification,
            point_in_time_recovery_enabled=self.point_in_time_recovery_enabled,
            regular_columns=self.regular_columns,
            tags=self.tags)


def get_table(keyspace_name: Optional[builtins.str] = None,
              table_name: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTableResult:
    """
    Resource schema for AWS::Cassandra::Table


    :param builtins.str keyspace_name: Name for Cassandra keyspace
    :param builtins.str table_name: Name for Cassandra table
    """
    __args__ = dict()
    __args__['keyspaceName'] = keyspace_name
    __args__['tableName'] = table_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cassandra:getTable', __args__, opts=opts, typ=GetTableResult).value

    return AwaitableGetTableResult(
        billing_mode=pulumi.get(__ret__, 'billing_mode'),
        default_time_to_live=pulumi.get(__ret__, 'default_time_to_live'),
        encryption_specification=pulumi.get(__ret__, 'encryption_specification'),
        point_in_time_recovery_enabled=pulumi.get(__ret__, 'point_in_time_recovery_enabled'),
        regular_columns=pulumi.get(__ret__, 'regular_columns'),
        tags=pulumi.get(__ret__, 'tags'))
def get_table_output(keyspace_name: Optional[pulumi.Input[builtins.str]] = None,
                     table_name: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTableResult]:
    """
    Resource schema for AWS::Cassandra::Table


    :param builtins.str keyspace_name: Name for Cassandra keyspace
    :param builtins.str table_name: Name for Cassandra table
    """
    __args__ = dict()
    __args__['keyspaceName'] = keyspace_name
    __args__['tableName'] = table_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cassandra:getTable', __args__, opts=opts, typ=GetTableResult)
    return __ret__.apply(lambda __response__: GetTableResult(
        billing_mode=pulumi.get(__response__, 'billing_mode'),
        default_time_to_live=pulumi.get(__response__, 'default_time_to_live'),
        encryption_specification=pulumi.get(__response__, 'encryption_specification'),
        point_in_time_recovery_enabled=pulumi.get(__response__, 'point_in_time_recovery_enabled'),
        regular_columns=pulumi.get(__response__, 'regular_columns'),
        tags=pulumi.get(__response__, 'tags')))
