# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = ['PromptVersionArgs', 'PromptVersion']

@pulumi.input_type
class PromptVersionArgs:
    def __init__(__self__, *,
                 prompt_arn: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a PromptVersion resource.
        :param pulumi.Input[builtins.str] prompt_arn: ARN of a prompt resource possibly with a version
        :param pulumi.Input[builtins.str] description: Description for a prompt version resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags attached to the prompt version and their values.
        """
        pulumi.set(__self__, "prompt_arn", prompt_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="promptArn")
    def prompt_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of a prompt resource possibly with a version
        """
        return pulumi.get(self, "prompt_arn")

    @prompt_arn.setter
    def prompt_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "prompt_arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description for a prompt version resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags attached to the prompt version and their values.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:bedrock:PromptVersion")
class PromptVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 prompt_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Definition of AWS::Bedrock::PromptVersion Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description for a prompt version resource.
        :param pulumi.Input[builtins.str] prompt_arn: ARN of a prompt resource possibly with a version
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags attached to the prompt version and their values.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PromptVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Bedrock::PromptVersion Resource Type

        :param str resource_name: The name of the resource.
        :param PromptVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PromptVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 prompt_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PromptVersionArgs.__new__(PromptVersionArgs)

            __props__.__dict__["description"] = description
            if prompt_arn is None and not opts.urn:
                raise TypeError("Missing required property 'prompt_arn'")
            __props__.__dict__["prompt_arn"] = prompt_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["customer_encryption_key_arn"] = None
            __props__.__dict__["default_variant"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["prompt_id"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["variants"] = None
            __props__.__dict__["version"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["description", "promptArn", "tags.*"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(PromptVersion, __self__).__init__(
            'aws-native:bedrock:PromptVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'PromptVersion':
        """
        Get an existing PromptVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PromptVersionArgs.__new__(PromptVersionArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["customer_encryption_key_arn"] = None
        __props__.__dict__["default_variant"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["prompt_arn"] = None
        __props__.__dict__["prompt_id"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["updated_at"] = None
        __props__.__dict__["variants"] = None
        __props__.__dict__["version"] = None
        return PromptVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of a prompt version resource
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> pulumi.Output[builtins.str]:
        """
        A KMS key ARN
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @property
    @pulumi.getter(name="defaultVariant")
    def default_variant(self) -> pulumi.Output[builtins.str]:
        """
        Name for a variant.
        """
        return pulumi.get(self, "default_variant")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description for a prompt version resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name for a prompt resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="promptArn")
    def prompt_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of a prompt resource possibly with a version
        """
        return pulumi.get(self, "prompt_arn")

    @property
    @pulumi.getter(name="promptId")
    def prompt_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier for a Prompt
        """
        return pulumi.get(self, "prompt_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of tags attached to the prompt version and their values.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def variants(self) -> pulumi.Output[Sequence['outputs.PromptVersionPromptVariant']]:
        """
        List of prompt variants
        """
        return pulumi.get(self, "variants")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        Version.
        """
        return pulumi.get(self, "version")

