# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['PromptArgs', 'Prompt']

@pulumi.input_type
class PromptArgs:
    def __init__(__self__, *,
                 customer_encryption_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 default_variant: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 variants: Optional[pulumi.Input[Sequence[pulumi.Input['PromptVariantArgs']]]] = None):
        """
        The set of arguments for constructing a Prompt resource.
        :param pulumi.Input[builtins.str] customer_encryption_key_arn: A KMS key ARN
        :param pulumi.Input[builtins.str] default_variant: Name for a variant.
        :param pulumi.Input[builtins.str] description: Name for a prompt resource.
        :param pulumi.Input[builtins.str] name: Name for a prompt resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:
               
               - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
               - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        :param pulumi.Input[Sequence[pulumi.Input['PromptVariantArgs']]] variants: List of prompt variants
        """
        if customer_encryption_key_arn is not None:
            pulumi.set(__self__, "customer_encryption_key_arn", customer_encryption_key_arn)
        if default_variant is not None:
            pulumi.set(__self__, "default_variant", default_variant)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if variants is not None:
            pulumi.set(__self__, "variants", variants)

    @property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A KMS key ARN
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @customer_encryption_key_arn.setter
    def customer_encryption_key_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_encryption_key_arn", value)

    @property
    @pulumi.getter(name="defaultVariant")
    def default_variant(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name for a variant.
        """
        return pulumi.get(self, "default_variant")

    @default_variant.setter
    def default_variant(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_variant", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name for a prompt resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name for a prompt resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:

        - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
        - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def variants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PromptVariantArgs']]]]:
        """
        List of prompt variants
        """
        return pulumi.get(self, "variants")

    @variants.setter
    def variants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PromptVariantArgs']]]]):
        pulumi.set(self, "variants", value)


@pulumi.type_token("aws-native:bedrock:Prompt")
class Prompt(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_encryption_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 default_variant: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 variants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PromptVariantArgs', 'PromptVariantArgsDict']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::Bedrock::Prompt Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] customer_encryption_key_arn: A KMS key ARN
        :param pulumi.Input[builtins.str] default_variant: Name for a variant.
        :param pulumi.Input[builtins.str] description: Name for a prompt resource.
        :param pulumi.Input[builtins.str] name: Name for a prompt resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:
               
               - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
               - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        :param pulumi.Input[Sequence[pulumi.Input[Union['PromptVariantArgs', 'PromptVariantArgsDict']]]] variants: List of prompt variants
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PromptArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Bedrock::Prompt Resource Type

        :param str resource_name: The name of the resource.
        :param PromptArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PromptArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_encryption_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 default_variant: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 variants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PromptVariantArgs', 'PromptVariantArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PromptArgs.__new__(PromptArgs)

            __props__.__dict__["customer_encryption_key_arn"] = customer_encryption_key_arn
            __props__.__dict__["default_variant"] = default_variant
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["variants"] = variants
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["version"] = None
        super(Prompt, __self__).__init__(
            'aws-native:bedrock:Prompt',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Prompt':
        """
        Get an existing Prompt resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PromptArgs.__new__(PromptArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["customer_encryption_key_arn"] = None
        __props__.__dict__["default_variant"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["updated_at"] = None
        __props__.__dict__["variants"] = None
        __props__.__dict__["version"] = None
        return Prompt(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of a prompt resource possibly with a version
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier for a Prompt
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A KMS key ARN
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @property
    @pulumi.getter(name="defaultVariant")
    def default_variant(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name for a variant.
        """
        return pulumi.get(self, "default_variant")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name for a prompt resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name for a prompt resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:

        - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
        - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def variants(self) -> pulumi.Output[Optional[Sequence['outputs.PromptVariant']]]:
        """
        List of prompt variants
        """
        return pulumi.get(self, "variants")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        Draft Version.
        """
        return pulumi.get(self, "version")

