# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetPromptVersionResult',
    'AwaitableGetPromptVersionResult',
    'get_prompt_version',
    'get_prompt_version_output',
]

@pulumi.output_type
class GetPromptVersionResult:
    def __init__(__self__, arn=None, created_at=None, customer_encryption_key_arn=None, default_variant=None, name=None, prompt_id=None, updated_at=None, variants=None, version=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if customer_encryption_key_arn and not isinstance(customer_encryption_key_arn, str):
            raise TypeError("Expected argument 'customer_encryption_key_arn' to be a str")
        pulumi.set(__self__, "customer_encryption_key_arn", customer_encryption_key_arn)
        if default_variant and not isinstance(default_variant, str):
            raise TypeError("Expected argument 'default_variant' to be a str")
        pulumi.set(__self__, "default_variant", default_variant)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if prompt_id and not isinstance(prompt_id, str):
            raise TypeError("Expected argument 'prompt_id' to be a str")
        pulumi.set(__self__, "prompt_id", prompt_id)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if variants and not isinstance(variants, list):
            raise TypeError("Expected argument 'variants' to be a list")
        pulumi.set(__self__, "variants", variants)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        ARN of a prompt version resource
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> Optional[builtins.str]:
        """
        A KMS key ARN
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @property
    @pulumi.getter(name="defaultVariant")
    def default_variant(self) -> Optional[builtins.str]:
        """
        Name for a variant.
        """
        return pulumi.get(self, "default_variant")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name for a prompt resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="promptId")
    def prompt_id(self) -> Optional[builtins.str]:
        """
        Identifier for a Prompt
        """
        return pulumi.get(self, "prompt_id")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[builtins.str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def variants(self) -> Optional[Sequence['outputs.PromptVersionPromptVariant']]:
        """
        List of prompt variants
        """
        return pulumi.get(self, "variants")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        Version.
        """
        return pulumi.get(self, "version")


class AwaitableGetPromptVersionResult(GetPromptVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPromptVersionResult(
            arn=self.arn,
            created_at=self.created_at,
            customer_encryption_key_arn=self.customer_encryption_key_arn,
            default_variant=self.default_variant,
            name=self.name,
            prompt_id=self.prompt_id,
            updated_at=self.updated_at,
            variants=self.variants,
            version=self.version)


def get_prompt_version(arn: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPromptVersionResult:
    """
    Definition of AWS::Bedrock::PromptVersion Resource Type


    :param builtins.str arn: ARN of a prompt version resource
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:bedrock:getPromptVersion', __args__, opts=opts, typ=GetPromptVersionResult).value

    return AwaitableGetPromptVersionResult(
        arn=pulumi.get(__ret__, 'arn'),
        created_at=pulumi.get(__ret__, 'created_at'),
        customer_encryption_key_arn=pulumi.get(__ret__, 'customer_encryption_key_arn'),
        default_variant=pulumi.get(__ret__, 'default_variant'),
        name=pulumi.get(__ret__, 'name'),
        prompt_id=pulumi.get(__ret__, 'prompt_id'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        variants=pulumi.get(__ret__, 'variants'),
        version=pulumi.get(__ret__, 'version'))
def get_prompt_version_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPromptVersionResult]:
    """
    Definition of AWS::Bedrock::PromptVersion Resource Type


    :param builtins.str arn: ARN of a prompt version resource
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:bedrock:getPromptVersion', __args__, opts=opts, typ=GetPromptVersionResult)
    return __ret__.apply(lambda __response__: GetPromptVersionResult(
        arn=pulumi.get(__response__, 'arn'),
        created_at=pulumi.get(__response__, 'created_at'),
        customer_encryption_key_arn=pulumi.get(__response__, 'customer_encryption_key_arn'),
        default_variant=pulumi.get(__response__, 'default_variant'),
        name=pulumi.get(__response__, 'name'),
        prompt_id=pulumi.get(__response__, 'prompt_id'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        variants=pulumi.get(__response__, 'variants'),
        version=pulumi.get(__response__, 'version')))
