# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetFlowVersionResult',
    'AwaitableGetFlowVersionResult',
    'get_flow_version',
    'get_flow_version_output',
]

@pulumi.output_type
class GetFlowVersionResult:
    def __init__(__self__, created_at=None, customer_encryption_key_arn=None, definition=None, execution_role_arn=None, flow_id=None, name=None, status=None, version=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if customer_encryption_key_arn and not isinstance(customer_encryption_key_arn, str):
            raise TypeError("Expected argument 'customer_encryption_key_arn' to be a str")
        pulumi.set(__self__, "customer_encryption_key_arn", customer_encryption_key_arn)
        if definition and not isinstance(definition, dict):
            raise TypeError("Expected argument 'definition' to be a dict")
        pulumi.set(__self__, "definition", definition)
        if execution_role_arn and not isinstance(execution_role_arn, str):
            raise TypeError("Expected argument 'execution_role_arn' to be a str")
        pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if flow_id and not isinstance(flow_id, str):
            raise TypeError("Expected argument 'flow_id' to be a str")
        pulumi.set(__self__, "flow_id", flow_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> Optional[builtins.str]:
        """
        A KMS key ARN
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @property
    @pulumi.getter
    def definition(self) -> Optional['outputs.FlowVersionFlowDefinition']:
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[builtins.str]:
        """
        ARN of a IAM role
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter(name="flowId")
    def flow_id(self) -> Optional[builtins.str]:
        """
        Identifier for a Flow
        """
        return pulumi.get(self, "flow_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name for the flow
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional['FlowVersionFlowStatus']:
        """
        The status of the flow.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        Numerical Version.
        """
        return pulumi.get(self, "version")


class AwaitableGetFlowVersionResult(GetFlowVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlowVersionResult(
            created_at=self.created_at,
            customer_encryption_key_arn=self.customer_encryption_key_arn,
            definition=self.definition,
            execution_role_arn=self.execution_role_arn,
            flow_id=self.flow_id,
            name=self.name,
            status=self.status,
            version=self.version)


def get_flow_version(flow_arn: Optional[builtins.str] = None,
                     version: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlowVersionResult:
    """
    Definition of AWS::Bedrock::FlowVersion Resource Type


    :param builtins.str flow_arn: Arn representation of the Flow
    :param builtins.str version: Numerical Version.
    """
    __args__ = dict()
    __args__['flowArn'] = flow_arn
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:bedrock:getFlowVersion', __args__, opts=opts, typ=GetFlowVersionResult).value

    return AwaitableGetFlowVersionResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        customer_encryption_key_arn=pulumi.get(__ret__, 'customer_encryption_key_arn'),
        definition=pulumi.get(__ret__, 'definition'),
        execution_role_arn=pulumi.get(__ret__, 'execution_role_arn'),
        flow_id=pulumi.get(__ret__, 'flow_id'),
        name=pulumi.get(__ret__, 'name'),
        status=pulumi.get(__ret__, 'status'),
        version=pulumi.get(__ret__, 'version'))
def get_flow_version_output(flow_arn: Optional[pulumi.Input[builtins.str]] = None,
                            version: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlowVersionResult]:
    """
    Definition of AWS::Bedrock::FlowVersion Resource Type


    :param builtins.str flow_arn: Arn representation of the Flow
    :param builtins.str version: Numerical Version.
    """
    __args__ = dict()
    __args__['flowArn'] = flow_arn
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:bedrock:getFlowVersion', __args__, opts=opts, typ=GetFlowVersionResult)
    return __ret__.apply(lambda __response__: GetFlowVersionResult(
        created_at=pulumi.get(__response__, 'created_at'),
        customer_encryption_key_arn=pulumi.get(__response__, 'customer_encryption_key_arn'),
        definition=pulumi.get(__response__, 'definition'),
        execution_role_arn=pulumi.get(__response__, 'execution_role_arn'),
        flow_id=pulumi.get(__response__, 'flow_id'),
        name=pulumi.get(__response__, 'name'),
        status=pulumi.get(__response__, 'status'),
        version=pulumi.get(__response__, 'version')))
