# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetFlowAliasResult',
    'AwaitableGetFlowAliasResult',
    'get_flow_alias',
    'get_flow_alias_output',
]

@pulumi.output_type
class GetFlowAliasResult:
    def __init__(__self__, arn=None, concurrency_configuration=None, created_at=None, description=None, flow_id=None, id=None, name=None, routing_configuration=None, tags=None, updated_at=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if concurrency_configuration and not isinstance(concurrency_configuration, dict):
            raise TypeError("Expected argument 'concurrency_configuration' to be a dict")
        pulumi.set(__self__, "concurrency_configuration", concurrency_configuration)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if flow_id and not isinstance(flow_id, str):
            raise TypeError("Expected argument 'flow_id' to be a str")
        pulumi.set(__self__, "flow_id", flow_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if routing_configuration and not isinstance(routing_configuration, list):
            raise TypeError("Expected argument 'routing_configuration' to be a list")
        pulumi.set(__self__, "routing_configuration", routing_configuration)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        Arn of the Flow Alias
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="concurrencyConfiguration")
    def concurrency_configuration(self) -> Optional['outputs.FlowAliasConcurrencyConfiguration']:
        """
        The configuration that specifies how nodes in the flow are executed concurrently.
        """
        return pulumi.get(self, "concurrency_configuration")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Description of the Resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="flowId")
    def flow_id(self) -> Optional[builtins.str]:
        """
        Identifier for a flow resource.
        """
        return pulumi.get(self, "flow_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Id for a Flow Alias generated at the server side.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name for a resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="routingConfiguration")
    def routing_configuration(self) -> Optional[Sequence['outputs.FlowAliasRoutingConfigurationListItem']]:
        """
        Routing configuration for a Flow alias.
        """
        return pulumi.get(self, "routing_configuration")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:

        - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
        - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[builtins.str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetFlowAliasResult(GetFlowAliasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlowAliasResult(
            arn=self.arn,
            concurrency_configuration=self.concurrency_configuration,
            created_at=self.created_at,
            description=self.description,
            flow_id=self.flow_id,
            id=self.id,
            name=self.name,
            routing_configuration=self.routing_configuration,
            tags=self.tags,
            updated_at=self.updated_at)


def get_flow_alias(arn: Optional[builtins.str] = None,
                   flow_arn: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlowAliasResult:
    """
    Definition of AWS::Bedrock::FlowAlias Resource Type


    :param builtins.str arn: Arn of the Flow Alias
    :param builtins.str flow_arn: Arn representation of the Flow
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['flowArn'] = flow_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:bedrock:getFlowAlias', __args__, opts=opts, typ=GetFlowAliasResult).value

    return AwaitableGetFlowAliasResult(
        arn=pulumi.get(__ret__, 'arn'),
        concurrency_configuration=pulumi.get(__ret__, 'concurrency_configuration'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        flow_id=pulumi.get(__ret__, 'flow_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        routing_configuration=pulumi.get(__ret__, 'routing_configuration'),
        tags=pulumi.get(__ret__, 'tags'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_flow_alias_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                          flow_arn: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlowAliasResult]:
    """
    Definition of AWS::Bedrock::FlowAlias Resource Type


    :param builtins.str arn: Arn of the Flow Alias
    :param builtins.str flow_arn: Arn representation of the Flow
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['flowArn'] = flow_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:bedrock:getFlowAlias', __args__, opts=opts, typ=GetFlowAliasResult)
    return __ret__.apply(lambda __response__: GetFlowAliasResult(
        arn=pulumi.get(__response__, 'arn'),
        concurrency_configuration=pulumi.get(__response__, 'concurrency_configuration'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        flow_id=pulumi.get(__response__, 'flow_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        routing_configuration=pulumi.get(__response__, 'routing_configuration'),
        tags=pulumi.get(__response__, 'tags'),
        updated_at=pulumi.get(__response__, 'updated_at')))
