# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetFlowResult',
    'AwaitableGetFlowResult',
    'get_flow',
    'get_flow_output',
]

@pulumi.output_type
class GetFlowResult:
    def __init__(__self__, arn=None, created_at=None, customer_encryption_key_arn=None, definition=None, description=None, execution_role_arn=None, id=None, name=None, status=None, tags=None, test_alias_tags=None, updated_at=None, validations=None, version=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if customer_encryption_key_arn and not isinstance(customer_encryption_key_arn, str):
            raise TypeError("Expected argument 'customer_encryption_key_arn' to be a str")
        pulumi.set(__self__, "customer_encryption_key_arn", customer_encryption_key_arn)
        if definition and not isinstance(definition, dict):
            raise TypeError("Expected argument 'definition' to be a dict")
        pulumi.set(__self__, "definition", definition)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if execution_role_arn and not isinstance(execution_role_arn, str):
            raise TypeError("Expected argument 'execution_role_arn' to be a str")
        pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if test_alias_tags and not isinstance(test_alias_tags, dict):
            raise TypeError("Expected argument 'test_alias_tags' to be a dict")
        pulumi.set(__self__, "test_alias_tags", test_alias_tags)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if validations and not isinstance(validations, list):
            raise TypeError("Expected argument 'validations' to be a list")
        pulumi.set(__self__, "validations", validations)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        Arn representation of the Flow
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> Optional[builtins.str]:
        """
        A KMS key ARN
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @property
    @pulumi.getter
    def definition(self) -> Optional['outputs.FlowDefinition']:
        """
        The definition of the nodes and connections between the nodes in the flow.
        """
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Description of the flow
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[builtins.str]:
        """
        ARN of a IAM role
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Identifier for a Flow
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name for the flow
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional['FlowStatus']:
        """
        The status of the flow. The following statuses are possible:

        - NotPrepared – The flow has been created or updated, but hasn't been prepared. If you just created the flow, you can't test it. If you updated the flow, the `DRAFT` version won't contain the latest changes for testing. Send a [PrepareFlow](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html) request to package the latest changes into the `DRAFT` version.
        - Preparing – The flow is being prepared so that the `DRAFT` version contains the latest changes for testing.
        - Prepared – The flow is prepared and the `DRAFT` version contains the latest changes for testing.
        - Failed – The last API operation that you invoked on the flow failed. Send a [GetFlow](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html) request and check the error message in the `validations` field.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:

        - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
        - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="testAliasTags")
    def test_alias_tags(self) -> Optional[Mapping[str, builtins.str]]:
        return pulumi.get(self, "test_alias_tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[builtins.str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def validations(self) -> Optional[Sequence['outputs.FlowValidation']]:
        return pulumi.get(self, "validations")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        Draft Version.
        """
        return pulumi.get(self, "version")


class AwaitableGetFlowResult(GetFlowResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlowResult(
            arn=self.arn,
            created_at=self.created_at,
            customer_encryption_key_arn=self.customer_encryption_key_arn,
            definition=self.definition,
            description=self.description,
            execution_role_arn=self.execution_role_arn,
            id=self.id,
            name=self.name,
            status=self.status,
            tags=self.tags,
            test_alias_tags=self.test_alias_tags,
            updated_at=self.updated_at,
            validations=self.validations,
            version=self.version)


def get_flow(arn: Optional[builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlowResult:
    """
    Definition of AWS::Bedrock::Flow Resource Type


    :param builtins.str arn: Arn representation of the Flow
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:bedrock:getFlow', __args__, opts=opts, typ=GetFlowResult).value

    return AwaitableGetFlowResult(
        arn=pulumi.get(__ret__, 'arn'),
        created_at=pulumi.get(__ret__, 'created_at'),
        customer_encryption_key_arn=pulumi.get(__ret__, 'customer_encryption_key_arn'),
        definition=pulumi.get(__ret__, 'definition'),
        description=pulumi.get(__ret__, 'description'),
        execution_role_arn=pulumi.get(__ret__, 'execution_role_arn'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        test_alias_tags=pulumi.get(__ret__, 'test_alias_tags'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        validations=pulumi.get(__ret__, 'validations'),
        version=pulumi.get(__ret__, 'version'))
def get_flow_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlowResult]:
    """
    Definition of AWS::Bedrock::Flow Resource Type


    :param builtins.str arn: Arn representation of the Flow
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:bedrock:getFlow', __args__, opts=opts, typ=GetFlowResult)
    return __ret__.apply(lambda __response__: GetFlowResult(
        arn=pulumi.get(__response__, 'arn'),
        created_at=pulumi.get(__response__, 'created_at'),
        customer_encryption_key_arn=pulumi.get(__response__, 'customer_encryption_key_arn'),
        definition=pulumi.get(__response__, 'definition'),
        description=pulumi.get(__response__, 'description'),
        execution_role_arn=pulumi.get(__response__, 'execution_role_arn'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        test_alias_tags=pulumi.get(__response__, 'test_alias_tags'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        validations=pulumi.get(__response__, 'validations'),
        version=pulumi.get(__response__, 'version')))
