# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetBlueprintResult',
    'AwaitableGetBlueprintResult',
    'get_blueprint',
    'get_blueprint_output',
]

@pulumi.output_type
class GetBlueprintResult:
    def __init__(__self__, blueprint_arn=None, blueprint_stage=None, creation_time=None, kms_encryption_context=None, kms_key_id=None, last_modified_time=None, schema=None, tags=None):
        if blueprint_arn and not isinstance(blueprint_arn, str):
            raise TypeError("Expected argument 'blueprint_arn' to be a str")
        pulumi.set(__self__, "blueprint_arn", blueprint_arn)
        if blueprint_stage and not isinstance(blueprint_stage, str):
            raise TypeError("Expected argument 'blueprint_stage' to be a str")
        pulumi.set(__self__, "blueprint_stage", blueprint_stage)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if kms_encryption_context and not isinstance(kms_encryption_context, dict):
            raise TypeError("Expected argument 'kms_encryption_context' to be a dict")
        pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if last_modified_time and not isinstance(last_modified_time, str):
            raise TypeError("Expected argument 'last_modified_time' to be a str")
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        if schema and not isinstance(schema, dict):
            raise TypeError("Expected argument 'schema' to be a dict")
        pulumi.set(__self__, "schema", schema)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="blueprintArn")
    def blueprint_arn(self) -> Optional[builtins.str]:
        """
        ARN of a Blueprint
        """
        return pulumi.get(self, "blueprint_arn")

    @property
    @pulumi.getter(name="blueprintStage")
    def blueprint_stage(self) -> Optional['BlueprintStage']:
        """
        Stage of the Blueprint
        """
        return pulumi.get(self, "blueprint_stage")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[builtins.str]:
        """
        Creation timestamp
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[Mapping[str, builtins.str]]:
        """
        KMS encryption context
        """
        return pulumi.get(self, "kms_encryption_context")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        KMS key identifier
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[builtins.str]:
        """
        Last modified timestamp
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter
    def schema(self) -> Optional[Any]:
        """
        Schema of the blueprint

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Bedrock::Blueprint` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        List of Tags
        """
        return pulumi.get(self, "tags")


class AwaitableGetBlueprintResult(GetBlueprintResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBlueprintResult(
            blueprint_arn=self.blueprint_arn,
            blueprint_stage=self.blueprint_stage,
            creation_time=self.creation_time,
            kms_encryption_context=self.kms_encryption_context,
            kms_key_id=self.kms_key_id,
            last_modified_time=self.last_modified_time,
            schema=self.schema,
            tags=self.tags)


def get_blueprint(blueprint_arn: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBlueprintResult:
    """
    Definition of AWS::Bedrock::Blueprint Resource Type


    :param builtins.str blueprint_arn: ARN of a Blueprint
    """
    __args__ = dict()
    __args__['blueprintArn'] = blueprint_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:bedrock:getBlueprint', __args__, opts=opts, typ=GetBlueprintResult).value

    return AwaitableGetBlueprintResult(
        blueprint_arn=pulumi.get(__ret__, 'blueprint_arn'),
        blueprint_stage=pulumi.get(__ret__, 'blueprint_stage'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        kms_encryption_context=pulumi.get(__ret__, 'kms_encryption_context'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        last_modified_time=pulumi.get(__ret__, 'last_modified_time'),
        schema=pulumi.get(__ret__, 'schema'),
        tags=pulumi.get(__ret__, 'tags'))
def get_blueprint_output(blueprint_arn: Optional[pulumi.Input[builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBlueprintResult]:
    """
    Definition of AWS::Bedrock::Blueprint Resource Type


    :param builtins.str blueprint_arn: ARN of a Blueprint
    """
    __args__ = dict()
    __args__['blueprintArn'] = blueprint_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:bedrock:getBlueprint', __args__, opts=opts, typ=GetBlueprintResult)
    return __ret__.apply(lambda __response__: GetBlueprintResult(
        blueprint_arn=pulumi.get(__response__, 'blueprint_arn'),
        blueprint_stage=pulumi.get(__response__, 'blueprint_stage'),
        creation_time=pulumi.get(__response__, 'creation_time'),
        kms_encryption_context=pulumi.get(__response__, 'kms_encryption_context'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        last_modified_time=pulumi.get(__response__, 'last_modified_time'),
        schema=pulumi.get(__response__, 'schema'),
        tags=pulumi.get(__response__, 'tags')))
