# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetApplicationInferenceProfileResult',
    'AwaitableGetApplicationInferenceProfileResult',
    'get_application_inference_profile',
    'get_application_inference_profile_output',
]

@pulumi.output_type
class GetApplicationInferenceProfileResult:
    def __init__(__self__, created_at=None, inference_profile_arn=None, inference_profile_id=None, inference_profile_identifier=None, models=None, status=None, tags=None, type=None, updated_at=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if inference_profile_arn and not isinstance(inference_profile_arn, str):
            raise TypeError("Expected argument 'inference_profile_arn' to be a str")
        pulumi.set(__self__, "inference_profile_arn", inference_profile_arn)
        if inference_profile_id and not isinstance(inference_profile_id, str):
            raise TypeError("Expected argument 'inference_profile_id' to be a str")
        pulumi.set(__self__, "inference_profile_id", inference_profile_id)
        if inference_profile_identifier and not isinstance(inference_profile_identifier, str):
            raise TypeError("Expected argument 'inference_profile_identifier' to be a str")
        pulumi.set(__self__, "inference_profile_identifier", inference_profile_identifier)
        if models and not isinstance(models, list):
            raise TypeError("Expected argument 'models' to be a list")
        pulumi.set(__self__, "models", models)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        Time Stamp
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="inferenceProfileArn")
    def inference_profile_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the inference profile.
        """
        return pulumi.get(self, "inference_profile_arn")

    @property
    @pulumi.getter(name="inferenceProfileId")
    def inference_profile_id(self) -> Optional[builtins.str]:
        """
        The unique identifier of the inference profile.
        """
        return pulumi.get(self, "inference_profile_id")

    @property
    @pulumi.getter(name="inferenceProfileIdentifier")
    def inference_profile_identifier(self) -> Optional[builtins.str]:
        """
        Inference profile identifier. Supports both system-defined inference profile ids, and inference profile ARNs.
        """
        return pulumi.get(self, "inference_profile_identifier")

    @property
    @pulumi.getter
    def models(self) -> Optional[Sequence['outputs.ApplicationInferenceProfileInferenceProfileModel']]:
        """
        List of model configuration
        """
        return pulumi.get(self, "models")

    @property
    @pulumi.getter
    def status(self) -> Optional['ApplicationInferenceProfileInferenceProfileStatus']:
        """
        The status of the inference profile. `ACTIVE` means that the inference profile is ready to be used.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        List of Tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> Optional['ApplicationInferenceProfileInferenceProfileType']:
        """
        The type of the inference profile. The following types are possible:

        - `SYSTEM_DEFINED` – The inference profile is defined by Amazon Bedrock. You can route inference requests across regions with these inference profiles.
        - `APPLICATION` – The inference profile was created by a user. This type of inference profile can track metrics and costs when invoking the model in it. The inference profile may route requests to one or multiple regions.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[builtins.str]:
        """
        Time Stamp
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetApplicationInferenceProfileResult(GetApplicationInferenceProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationInferenceProfileResult(
            created_at=self.created_at,
            inference_profile_arn=self.inference_profile_arn,
            inference_profile_id=self.inference_profile_id,
            inference_profile_identifier=self.inference_profile_identifier,
            models=self.models,
            status=self.status,
            tags=self.tags,
            type=self.type,
            updated_at=self.updated_at)


def get_application_inference_profile(inference_profile_identifier: Optional[builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationInferenceProfileResult:
    """
    Definition of AWS::Bedrock::ApplicationInferenceProfile Resource Type


    :param builtins.str inference_profile_identifier: Inference profile identifier. Supports both system-defined inference profile ids, and inference profile ARNs.
    """
    __args__ = dict()
    __args__['inferenceProfileIdentifier'] = inference_profile_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:bedrock:getApplicationInferenceProfile', __args__, opts=opts, typ=GetApplicationInferenceProfileResult).value

    return AwaitableGetApplicationInferenceProfileResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        inference_profile_arn=pulumi.get(__ret__, 'inference_profile_arn'),
        inference_profile_id=pulumi.get(__ret__, 'inference_profile_id'),
        inference_profile_identifier=pulumi.get(__ret__, 'inference_profile_identifier'),
        models=pulumi.get(__ret__, 'models'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_application_inference_profile_output(inference_profile_identifier: Optional[pulumi.Input[builtins.str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApplicationInferenceProfileResult]:
    """
    Definition of AWS::Bedrock::ApplicationInferenceProfile Resource Type


    :param builtins.str inference_profile_identifier: Inference profile identifier. Supports both system-defined inference profile ids, and inference profile ARNs.
    """
    __args__ = dict()
    __args__['inferenceProfileIdentifier'] = inference_profile_identifier
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:bedrock:getApplicationInferenceProfile', __args__, opts=opts, typ=GetApplicationInferenceProfileResult)
    return __ret__.apply(lambda __response__: GetApplicationInferenceProfileResult(
        created_at=pulumi.get(__response__, 'created_at'),
        inference_profile_arn=pulumi.get(__response__, 'inference_profile_arn'),
        inference_profile_id=pulumi.get(__response__, 'inference_profile_id'),
        inference_profile_identifier=pulumi.get(__response__, 'inference_profile_identifier'),
        models=pulumi.get(__response__, 'models'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type'),
        updated_at=pulumi.get(__response__, 'updated_at')))
