# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetAgentAliasResult',
    'AwaitableGetAgentAliasResult',
    'get_agent_alias',
    'get_agent_alias_output',
]

@pulumi.output_type
class GetAgentAliasResult:
    def __init__(__self__, agent_alias_arn=None, agent_alias_history_events=None, agent_alias_id=None, agent_alias_name=None, agent_alias_status=None, created_at=None, description=None, routing_configuration=None, tags=None, updated_at=None):
        if agent_alias_arn and not isinstance(agent_alias_arn, str):
            raise TypeError("Expected argument 'agent_alias_arn' to be a str")
        pulumi.set(__self__, "agent_alias_arn", agent_alias_arn)
        if agent_alias_history_events and not isinstance(agent_alias_history_events, list):
            raise TypeError("Expected argument 'agent_alias_history_events' to be a list")
        pulumi.set(__self__, "agent_alias_history_events", agent_alias_history_events)
        if agent_alias_id and not isinstance(agent_alias_id, str):
            raise TypeError("Expected argument 'agent_alias_id' to be a str")
        pulumi.set(__self__, "agent_alias_id", agent_alias_id)
        if agent_alias_name and not isinstance(agent_alias_name, str):
            raise TypeError("Expected argument 'agent_alias_name' to be a str")
        pulumi.set(__self__, "agent_alias_name", agent_alias_name)
        if agent_alias_status and not isinstance(agent_alias_status, str):
            raise TypeError("Expected argument 'agent_alias_status' to be a str")
        pulumi.set(__self__, "agent_alias_status", agent_alias_status)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if routing_configuration and not isinstance(routing_configuration, list):
            raise TypeError("Expected argument 'routing_configuration' to be a list")
        pulumi.set(__self__, "routing_configuration", routing_configuration)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="agentAliasArn")
    def agent_alias_arn(self) -> Optional[builtins.str]:
        """
        Arn representation of the Agent Alias.
        """
        return pulumi.get(self, "agent_alias_arn")

    @property
    @pulumi.getter(name="agentAliasHistoryEvents")
    def agent_alias_history_events(self) -> Optional[Sequence['outputs.AgentAliasHistoryEvent']]:
        """
        The list of history events for an alias for an Agent.
        """
        return pulumi.get(self, "agent_alias_history_events")

    @property
    @pulumi.getter(name="agentAliasId")
    def agent_alias_id(self) -> Optional[builtins.str]:
        """
        Id for an Agent Alias generated at the server side.
        """
        return pulumi.get(self, "agent_alias_id")

    @property
    @pulumi.getter(name="agentAliasName")
    def agent_alias_name(self) -> Optional[builtins.str]:
        """
        Name for a resource.
        """
        return pulumi.get(self, "agent_alias_name")

    @property
    @pulumi.getter(name="agentAliasStatus")
    def agent_alias_status(self) -> Optional['AgentAliasStatus']:
        """
        The status of the alias of the agent and whether it is ready for use. The following statuses are possible:

        - CREATING – The agent alias is being created.
        - PREPARED – The agent alias is finished being created or updated and is ready to be invoked.
        - FAILED – The agent alias API operation failed.
        - UPDATING – The agent alias is being updated.
        - DELETING – The agent alias is being deleted.
        - DISSOCIATED - The agent alias has no version associated with it.
        """
        return pulumi.get(self, "agent_alias_status")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Description of the Resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="routingConfiguration")
    def routing_configuration(self) -> Optional[Sequence['outputs.AgentAliasRoutingConfigurationListItem']]:
        """
        Routing configuration for an Agent alias.
        """
        return pulumi.get(self, "routing_configuration")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:

        - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
        - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[builtins.str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetAgentAliasResult(GetAgentAliasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAgentAliasResult(
            agent_alias_arn=self.agent_alias_arn,
            agent_alias_history_events=self.agent_alias_history_events,
            agent_alias_id=self.agent_alias_id,
            agent_alias_name=self.agent_alias_name,
            agent_alias_status=self.agent_alias_status,
            created_at=self.created_at,
            description=self.description,
            routing_configuration=self.routing_configuration,
            tags=self.tags,
            updated_at=self.updated_at)


def get_agent_alias(agent_alias_id: Optional[builtins.str] = None,
                    agent_id: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAgentAliasResult:
    """
    Definition of AWS::Bedrock::AgentAlias Resource Type


    :param builtins.str agent_alias_id: Id for an Agent Alias generated at the server side.
    :param builtins.str agent_id: Identifier for a resource.
    """
    __args__ = dict()
    __args__['agentAliasId'] = agent_alias_id
    __args__['agentId'] = agent_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:bedrock:getAgentAlias', __args__, opts=opts, typ=GetAgentAliasResult).value

    return AwaitableGetAgentAliasResult(
        agent_alias_arn=pulumi.get(__ret__, 'agent_alias_arn'),
        agent_alias_history_events=pulumi.get(__ret__, 'agent_alias_history_events'),
        agent_alias_id=pulumi.get(__ret__, 'agent_alias_id'),
        agent_alias_name=pulumi.get(__ret__, 'agent_alias_name'),
        agent_alias_status=pulumi.get(__ret__, 'agent_alias_status'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        routing_configuration=pulumi.get(__ret__, 'routing_configuration'),
        tags=pulumi.get(__ret__, 'tags'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_agent_alias_output(agent_alias_id: Optional[pulumi.Input[builtins.str]] = None,
                           agent_id: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAgentAliasResult]:
    """
    Definition of AWS::Bedrock::AgentAlias Resource Type


    :param builtins.str agent_alias_id: Id for an Agent Alias generated at the server side.
    :param builtins.str agent_id: Identifier for a resource.
    """
    __args__ = dict()
    __args__['agentAliasId'] = agent_alias_id
    __args__['agentId'] = agent_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:bedrock:getAgentAlias', __args__, opts=opts, typ=GetAgentAliasResult)
    return __ret__.apply(lambda __response__: GetAgentAliasResult(
        agent_alias_arn=pulumi.get(__response__, 'agent_alias_arn'),
        agent_alias_history_events=pulumi.get(__response__, 'agent_alias_history_events'),
        agent_alias_id=pulumi.get(__response__, 'agent_alias_id'),
        agent_alias_name=pulumi.get(__response__, 'agent_alias_name'),
        agent_alias_status=pulumi.get(__response__, 'agent_alias_status'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        routing_configuration=pulumi.get(__response__, 'routing_configuration'),
        tags=pulumi.get(__response__, 'tags'),
        updated_at=pulumi.get(__response__, 'updated_at')))
