# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['FlowAliasArgs', 'FlowAlias']

@pulumi.input_type
class FlowAliasArgs:
    def __init__(__self__, *,
                 flow_arn: pulumi.Input[builtins.str],
                 routing_configuration: pulumi.Input[Sequence[pulumi.Input['FlowAliasRoutingConfigurationListItemArgs']]],
                 concurrency_configuration: Optional[pulumi.Input['FlowAliasConcurrencyConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a FlowAlias resource.
        :param pulumi.Input[builtins.str] flow_arn: Arn representation of the Flow
        :param pulumi.Input[Sequence[pulumi.Input['FlowAliasRoutingConfigurationListItemArgs']]] routing_configuration: Routing configuration for a Flow alias.
        :param pulumi.Input['FlowAliasConcurrencyConfigurationArgs'] concurrency_configuration: The configuration that specifies how nodes in the flow are executed concurrently.
        :param pulumi.Input[builtins.str] description: Description of the Resource.
        :param pulumi.Input[builtins.str] name: Name for a resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:
               
               - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
               - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        """
        pulumi.set(__self__, "flow_arn", flow_arn)
        pulumi.set(__self__, "routing_configuration", routing_configuration)
        if concurrency_configuration is not None:
            pulumi.set(__self__, "concurrency_configuration", concurrency_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="flowArn")
    def flow_arn(self) -> pulumi.Input[builtins.str]:
        """
        Arn representation of the Flow
        """
        return pulumi.get(self, "flow_arn")

    @flow_arn.setter
    def flow_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "flow_arn", value)

    @property
    @pulumi.getter(name="routingConfiguration")
    def routing_configuration(self) -> pulumi.Input[Sequence[pulumi.Input['FlowAliasRoutingConfigurationListItemArgs']]]:
        """
        Routing configuration for a Flow alias.
        """
        return pulumi.get(self, "routing_configuration")

    @routing_configuration.setter
    def routing_configuration(self, value: pulumi.Input[Sequence[pulumi.Input['FlowAliasRoutingConfigurationListItemArgs']]]):
        pulumi.set(self, "routing_configuration", value)

    @property
    @pulumi.getter(name="concurrencyConfiguration")
    def concurrency_configuration(self) -> Optional[pulumi.Input['FlowAliasConcurrencyConfigurationArgs']]:
        """
        The configuration that specifies how nodes in the flow are executed concurrently.
        """
        return pulumi.get(self, "concurrency_configuration")

    @concurrency_configuration.setter
    def concurrency_configuration(self, value: Optional[pulumi.Input['FlowAliasConcurrencyConfigurationArgs']]):
        pulumi.set(self, "concurrency_configuration", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the Resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name for a resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:

        - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
        - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:bedrock:FlowAlias")
class FlowAlias(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 concurrency_configuration: Optional[pulumi.Input[Union['FlowAliasConcurrencyConfigurationArgs', 'FlowAliasConcurrencyConfigurationArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 flow_arn: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_configuration: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FlowAliasRoutingConfigurationListItemArgs', 'FlowAliasRoutingConfigurationListItemArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Definition of AWS::Bedrock::FlowAlias Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FlowAliasConcurrencyConfigurationArgs', 'FlowAliasConcurrencyConfigurationArgsDict']] concurrency_configuration: The configuration that specifies how nodes in the flow are executed concurrently.
        :param pulumi.Input[builtins.str] description: Description of the Resource.
        :param pulumi.Input[builtins.str] flow_arn: Arn representation of the Flow
        :param pulumi.Input[builtins.str] name: Name for a resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FlowAliasRoutingConfigurationListItemArgs', 'FlowAliasRoutingConfigurationListItemArgsDict']]]] routing_configuration: Routing configuration for a Flow alias.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:
               
               - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
               - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlowAliasArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Bedrock::FlowAlias Resource Type

        :param str resource_name: The name of the resource.
        :param FlowAliasArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlowAliasArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 concurrency_configuration: Optional[pulumi.Input[Union['FlowAliasConcurrencyConfigurationArgs', 'FlowAliasConcurrencyConfigurationArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 flow_arn: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_configuration: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FlowAliasRoutingConfigurationListItemArgs', 'FlowAliasRoutingConfigurationListItemArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlowAliasArgs.__new__(FlowAliasArgs)

            __props__.__dict__["concurrency_configuration"] = concurrency_configuration
            __props__.__dict__["description"] = description
            if flow_arn is None and not opts.urn:
                raise TypeError("Missing required property 'flow_arn'")
            __props__.__dict__["flow_arn"] = flow_arn
            __props__.__dict__["name"] = name
            if routing_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'routing_configuration'")
            __props__.__dict__["routing_configuration"] = routing_configuration
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["flow_id"] = None
            __props__.__dict__["updated_at"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["flowArn"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(FlowAlias, __self__).__init__(
            'aws-native:bedrock:FlowAlias',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'FlowAlias':
        """
        Get an existing FlowAlias resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FlowAliasArgs.__new__(FlowAliasArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["concurrency_configuration"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["flow_arn"] = None
        __props__.__dict__["flow_id"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["routing_configuration"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["updated_at"] = None
        return FlowAlias(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Arn of the Flow Alias
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        Id for a Flow Alias generated at the server side.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="concurrencyConfiguration")
    def concurrency_configuration(self) -> pulumi.Output[Optional['outputs.FlowAliasConcurrencyConfiguration']]:
        """
        The configuration that specifies how nodes in the flow are executed concurrently.
        """
        return pulumi.get(self, "concurrency_configuration")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the Resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="flowArn")
    def flow_arn(self) -> pulumi.Output[builtins.str]:
        """
        Arn representation of the Flow
        """
        return pulumi.get(self, "flow_arn")

    @property
    @pulumi.getter(name="flowId")
    def flow_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier for a flow resource.
        """
        return pulumi.get(self, "flow_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name for a resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="routingConfiguration")
    def routing_configuration(self) -> pulumi.Output[Sequence['outputs.FlowAliasRoutingConfigurationListItem']]:
        """
        Routing configuration for a Flow alias.
        """
        return pulumi.get(self, "routing_configuration")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:

        - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
        - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "updated_at")

