# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['DataAutomationProjectArgs', 'DataAutomationProject']

@pulumi.input_type
class DataAutomationProjectArgs:
    def __init__(__self__, *,
                 custom_output_configuration: Optional[pulumi.Input['DataAutomationProjectCustomOutputConfigurationArgs']] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 override_configuration: Optional[pulumi.Input['DataAutomationProjectOverrideConfigurationArgs']] = None,
                 project_description: Optional[pulumi.Input[builtins.str]] = None,
                 project_name: Optional[pulumi.Input[builtins.str]] = None,
                 standard_output_configuration: Optional[pulumi.Input['DataAutomationProjectStandardOutputConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a DataAutomationProject resource.
        :param pulumi.Input['DataAutomationProjectCustomOutputConfigurationArgs'] custom_output_configuration: Blueprints to apply to objects processed by the project.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] kms_encryption_context: KMS encryption context
        :param pulumi.Input[builtins.str] kms_key_id: KMS key identifier
        :param pulumi.Input['DataAutomationProjectOverrideConfigurationArgs'] override_configuration: Additional settings for the project.
        :param pulumi.Input[builtins.str] project_description: Description of the DataAutomationProject
        :param pulumi.Input[builtins.str] project_name: Name of the DataAutomationProject
        :param pulumi.Input['DataAutomationProjectStandardOutputConfigurationArgs'] standard_output_configuration: The project's standard output configuration.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: List of Tags
        """
        if custom_output_configuration is not None:
            pulumi.set(__self__, "custom_output_configuration", custom_output_configuration)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if override_configuration is not None:
            pulumi.set(__self__, "override_configuration", override_configuration)
        if project_description is not None:
            pulumi.set(__self__, "project_description", project_description)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if standard_output_configuration is not None:
            pulumi.set(__self__, "standard_output_configuration", standard_output_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="customOutputConfiguration")
    def custom_output_configuration(self) -> Optional[pulumi.Input['DataAutomationProjectCustomOutputConfigurationArgs']]:
        """
        Blueprints to apply to objects processed by the project.
        """
        return pulumi.get(self, "custom_output_configuration")

    @custom_output_configuration.setter
    def custom_output_configuration(self, value: Optional[pulumi.Input['DataAutomationProjectCustomOutputConfigurationArgs']]):
        pulumi.set(self, "custom_output_configuration", value)

    @property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        KMS encryption context
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        KMS key identifier
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="overrideConfiguration")
    def override_configuration(self) -> Optional[pulumi.Input['DataAutomationProjectOverrideConfigurationArgs']]:
        """
        Additional settings for the project.
        """
        return pulumi.get(self, "override_configuration")

    @override_configuration.setter
    def override_configuration(self, value: Optional[pulumi.Input['DataAutomationProjectOverrideConfigurationArgs']]):
        pulumi.set(self, "override_configuration", value)

    @property
    @pulumi.getter(name="projectDescription")
    def project_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the DataAutomationProject
        """
        return pulumi.get(self, "project_description")

    @project_description.setter
    def project_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_description", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the DataAutomationProject
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="standardOutputConfiguration")
    def standard_output_configuration(self) -> Optional[pulumi.Input['DataAutomationProjectStandardOutputConfigurationArgs']]:
        """
        The project's standard output configuration.
        """
        return pulumi.get(self, "standard_output_configuration")

    @standard_output_configuration.setter
    def standard_output_configuration(self, value: Optional[pulumi.Input['DataAutomationProjectStandardOutputConfigurationArgs']]):
        pulumi.set(self, "standard_output_configuration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        List of Tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:bedrock:DataAutomationProject")
class DataAutomationProject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_output_configuration: Optional[pulumi.Input[Union['DataAutomationProjectCustomOutputConfigurationArgs', 'DataAutomationProjectCustomOutputConfigurationArgsDict']]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 override_configuration: Optional[pulumi.Input[Union['DataAutomationProjectOverrideConfigurationArgs', 'DataAutomationProjectOverrideConfigurationArgsDict']]] = None,
                 project_description: Optional[pulumi.Input[builtins.str]] = None,
                 project_name: Optional[pulumi.Input[builtins.str]] = None,
                 standard_output_configuration: Optional[pulumi.Input[Union['DataAutomationProjectStandardOutputConfigurationArgs', 'DataAutomationProjectStandardOutputConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::Bedrock::DataAutomationProject Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DataAutomationProjectCustomOutputConfigurationArgs', 'DataAutomationProjectCustomOutputConfigurationArgsDict']] custom_output_configuration: Blueprints to apply to objects processed by the project.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] kms_encryption_context: KMS encryption context
        :param pulumi.Input[builtins.str] kms_key_id: KMS key identifier
        :param pulumi.Input[Union['DataAutomationProjectOverrideConfigurationArgs', 'DataAutomationProjectOverrideConfigurationArgsDict']] override_configuration: Additional settings for the project.
        :param pulumi.Input[builtins.str] project_description: Description of the DataAutomationProject
        :param pulumi.Input[builtins.str] project_name: Name of the DataAutomationProject
        :param pulumi.Input[Union['DataAutomationProjectStandardOutputConfigurationArgs', 'DataAutomationProjectStandardOutputConfigurationArgsDict']] standard_output_configuration: The project's standard output configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: List of Tags
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DataAutomationProjectArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Bedrock::DataAutomationProject Resource Type

        :param str resource_name: The name of the resource.
        :param DataAutomationProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataAutomationProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_output_configuration: Optional[pulumi.Input[Union['DataAutomationProjectCustomOutputConfigurationArgs', 'DataAutomationProjectCustomOutputConfigurationArgsDict']]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 override_configuration: Optional[pulumi.Input[Union['DataAutomationProjectOverrideConfigurationArgs', 'DataAutomationProjectOverrideConfigurationArgsDict']]] = None,
                 project_description: Optional[pulumi.Input[builtins.str]] = None,
                 project_name: Optional[pulumi.Input[builtins.str]] = None,
                 standard_output_configuration: Optional[pulumi.Input[Union['DataAutomationProjectStandardOutputConfigurationArgs', 'DataAutomationProjectStandardOutputConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataAutomationProjectArgs.__new__(DataAutomationProjectArgs)

            __props__.__dict__["custom_output_configuration"] = custom_output_configuration
            __props__.__dict__["kms_encryption_context"] = kms_encryption_context
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["override_configuration"] = override_configuration
            __props__.__dict__["project_description"] = project_description
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["standard_output_configuration"] = standard_output_configuration
            __props__.__dict__["tags"] = tags
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["last_modified_time"] = None
            __props__.__dict__["project_arn"] = None
            __props__.__dict__["project_stage"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["projectName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DataAutomationProject, __self__).__init__(
            'aws-native:bedrock:DataAutomationProject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DataAutomationProject':
        """
        Get an existing DataAutomationProject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DataAutomationProjectArgs.__new__(DataAutomationProjectArgs)

        __props__.__dict__["creation_time"] = None
        __props__.__dict__["custom_output_configuration"] = None
        __props__.__dict__["kms_encryption_context"] = None
        __props__.__dict__["kms_key_id"] = None
        __props__.__dict__["last_modified_time"] = None
        __props__.__dict__["override_configuration"] = None
        __props__.__dict__["project_arn"] = None
        __props__.__dict__["project_description"] = None
        __props__.__dict__["project_name"] = None
        __props__.__dict__["project_stage"] = None
        __props__.__dict__["standard_output_configuration"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        return DataAutomationProject(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[builtins.str]:
        """
        Time Stamp
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="customOutputConfiguration")
    def custom_output_configuration(self) -> pulumi.Output[Optional['outputs.DataAutomationProjectCustomOutputConfiguration']]:
        """
        Blueprints to apply to objects processed by the project.
        """
        return pulumi.get(self, "custom_output_configuration")

    @property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        KMS encryption context
        """
        return pulumi.get(self, "kms_encryption_context")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        KMS key identifier
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[builtins.str]:
        """
        Time Stamp
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="overrideConfiguration")
    def override_configuration(self) -> pulumi.Output[Optional['outputs.DataAutomationProjectOverrideConfiguration']]:
        """
        Additional settings for the project.
        """
        return pulumi.get(self, "override_configuration")

    @property
    @pulumi.getter(name="projectArn")
    def project_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of a DataAutomationProject
        """
        return pulumi.get(self, "project_arn")

    @property
    @pulumi.getter(name="projectDescription")
    def project_description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the DataAutomationProject
        """
        return pulumi.get(self, "project_description")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the DataAutomationProject
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="projectStage")
    def project_stage(self) -> pulumi.Output['DataAutomationProjectStage']:
        """
        The project's stage.
        """
        return pulumi.get(self, "project_stage")

    @property
    @pulumi.getter(name="standardOutputConfiguration")
    def standard_output_configuration(self) -> pulumi.Output[Optional['outputs.DataAutomationProjectStandardOutputConfiguration']]:
        """
        The project's standard output configuration.
        """
        return pulumi.get(self, "standard_output_configuration")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['DataAutomationProjectStatus']:
        """
        The project's status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        List of Tags
        """
        return pulumi.get(self, "tags")

