# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['BlueprintArgs', 'Blueprint']

@pulumi.input_type
class BlueprintArgs:
    def __init__(__self__, *,
                 schema: Any,
                 type: pulumi.Input['BlueprintType'],
                 blueprint_name: Optional[pulumi.Input[builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Blueprint resource.
        :param Any schema: Schema of the blueprint
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Bedrock::Blueprint` for more information about the expected schema for this property.
        :param pulumi.Input['BlueprintType'] type: Modality Type
        :param pulumi.Input[builtins.str] blueprint_name: Name of the Blueprint
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] kms_encryption_context: KMS encryption context
        :param pulumi.Input[builtins.str] kms_key_id: KMS key identifier
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: List of Tags
        """
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "type", type)
        if blueprint_name is not None:
            pulumi.set(__self__, "blueprint_name", blueprint_name)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def schema(self) -> Any:
        """
        Schema of the blueprint

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Bedrock::Blueprint` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Any):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['BlueprintType']:
        """
        Modality Type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['BlueprintType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="blueprintName")
    def blueprint_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Blueprint
        """
        return pulumi.get(self, "blueprint_name")

    @blueprint_name.setter
    def blueprint_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "blueprint_name", value)

    @property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        KMS encryption context
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        KMS key identifier
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        List of Tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:bedrock:Blueprint")
class Blueprint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blueprint_name: Optional[pulumi.Input[builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[Any] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 type: Optional[pulumi.Input['BlueprintType']] = None,
                 __props__=None):
        """
        Definition of AWS::Bedrock::Blueprint Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] blueprint_name: Name of the Blueprint
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] kms_encryption_context: KMS encryption context
        :param pulumi.Input[builtins.str] kms_key_id: KMS key identifier
        :param Any schema: Schema of the blueprint
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Bedrock::Blueprint` for more information about the expected schema for this property.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: List of Tags
        :param pulumi.Input['BlueprintType'] type: Modality Type
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BlueprintArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Bedrock::Blueprint Resource Type

        :param str resource_name: The name of the resource.
        :param BlueprintArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BlueprintArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blueprint_name: Optional[pulumi.Input[builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[Any] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 type: Optional[pulumi.Input['BlueprintType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BlueprintArgs.__new__(BlueprintArgs)

            __props__.__dict__["blueprint_name"] = blueprint_name
            __props__.__dict__["kms_encryption_context"] = kms_encryption_context
            __props__.__dict__["kms_key_id"] = kms_key_id
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["blueprint_arn"] = None
            __props__.__dict__["blueprint_stage"] = None
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["last_modified_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["blueprintName", "type"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Blueprint, __self__).__init__(
            'aws-native:bedrock:Blueprint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Blueprint':
        """
        Get an existing Blueprint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = BlueprintArgs.__new__(BlueprintArgs)

        __props__.__dict__["blueprint_arn"] = None
        __props__.__dict__["blueprint_name"] = None
        __props__.__dict__["blueprint_stage"] = None
        __props__.__dict__["creation_time"] = None
        __props__.__dict__["kms_encryption_context"] = None
        __props__.__dict__["kms_key_id"] = None
        __props__.__dict__["last_modified_time"] = None
        __props__.__dict__["schema"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        return Blueprint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="blueprintArn")
    def blueprint_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of a Blueprint
        """
        return pulumi.get(self, "blueprint_arn")

    @property
    @pulumi.getter(name="blueprintName")
    def blueprint_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Blueprint
        """
        return pulumi.get(self, "blueprint_name")

    @property
    @pulumi.getter(name="blueprintStage")
    def blueprint_stage(self) -> pulumi.Output['BlueprintStage']:
        """
        Stage of the Blueprint
        """
        return pulumi.get(self, "blueprint_stage")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[builtins.str]:
        """
        Creation timestamp
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        KMS encryption context
        """
        return pulumi.get(self, "kms_encryption_context")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        KMS key identifier
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[builtins.str]:
        """
        Last modified timestamp
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Output[Any]:
        """
        Schema of the blueprint

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Bedrock::Blueprint` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        List of Tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output['BlueprintType']:
        """
        Modality Type
        """
        return pulumi.get(self, "type")

