# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ComputeEnvironmentComputeResources',
    'ComputeEnvironmentEc2ConfigurationObject',
    'ComputeEnvironmentEksConfiguration',
    'ComputeEnvironmentLaunchTemplateSpecification',
    'ComputeEnvironmentLaunchTemplateSpecificationOverride',
    'ComputeEnvironmentUpdatePolicy',
    'JobDefinitionConsumableResourceProperties',
    'JobDefinitionConsumableResourceRequirement',
    'JobDefinitionContainerProperties',
    'JobDefinitionContainerPropertiesFargatePlatformConfigurationProperties',
    'JobDefinitionDevice',
    'JobDefinitionEcsProperties',
    'JobDefinitionEcsTaskProperties',
    'JobDefinitionEfsAuthorizationConfig',
    'JobDefinitionEfsVolumeConfiguration',
    'JobDefinitionEksContainer',
    'JobDefinitionEksContainerEnvironmentVariable',
    'JobDefinitionEksContainerResourceRequirements',
    'JobDefinitionEksContainerSecurityContext',
    'JobDefinitionEksContainerVolumeMount',
    'JobDefinitionEksEmptyDir',
    'JobDefinitionEksHostPath',
    'JobDefinitionEksMetadata',
    'JobDefinitionEksPersistentVolumeClaim',
    'JobDefinitionEksPodProperties',
    'JobDefinitionEksProperties',
    'JobDefinitionEksSecret',
    'JobDefinitionEksVolume',
    'JobDefinitionEnvironment',
    'JobDefinitionEphemeralStorage',
    'JobDefinitionEvaluateOnExit',
    'JobDefinitionHost',
    'JobDefinitionImagePullSecret',
    'JobDefinitionJobTimeout',
    'JobDefinitionLinuxParameters',
    'JobDefinitionLogConfiguration',
    'JobDefinitionMountPoint',
    'JobDefinitionMultiNodeContainerProperties',
    'JobDefinitionMultiNodeEcsProperties',
    'JobDefinitionMultiNodeEcsTaskProperties',
    'JobDefinitionNetworkConfiguration',
    'JobDefinitionNodeProperties',
    'JobDefinitionNodeRangeProperty',
    'JobDefinitionRepositoryCredentials',
    'JobDefinitionResourceRequirement',
    'JobDefinitionRetryStrategy',
    'JobDefinitionRuntimePlatform',
    'JobDefinitionSecret',
    'JobDefinitionTaskContainerDependency',
    'JobDefinitionTaskContainerProperties',
    'JobDefinitionTaskContainerPropertiesFirelensConfigurationProperties',
    'JobDefinitionTmpfs',
    'JobDefinitionUlimit',
    'JobDefinitionVolume',
    'JobQueueComputeEnvironmentOrder',
    'JobQueueJobStateTimeLimitAction',
    'SchedulingPolicyFairsharePolicy',
    'SchedulingPolicyShareAttributes',
]

@pulumi.output_type
class ComputeEnvironmentComputeResources(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxvCpus":
            suggest = "maxv_cpus"
        elif key == "allocationStrategy":
            suggest = "allocation_strategy"
        elif key == "bidPercentage":
            suggest = "bid_percentage"
        elif key == "desiredvCpus":
            suggest = "desiredv_cpus"
        elif key == "ec2Configuration":
            suggest = "ec2_configuration"
        elif key == "ec2KeyPair":
            suggest = "ec2_key_pair"
        elif key == "imageId":
            suggest = "image_id"
        elif key == "instanceRole":
            suggest = "instance_role"
        elif key == "instanceTypes":
            suggest = "instance_types"
        elif key == "launchTemplate":
            suggest = "launch_template"
        elif key == "minvCpus":
            suggest = "minv_cpus"
        elif key == "placementGroup":
            suggest = "placement_group"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "spotIamFleetRole":
            suggest = "spot_iam_fleet_role"
        elif key == "updateToLatestImageVersion":
            suggest = "update_to_latest_image_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeEnvironmentComputeResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeEnvironmentComputeResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeEnvironmentComputeResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maxv_cpus: builtins.int,
                 subnets: Sequence[builtins.str],
                 type: builtins.str,
                 allocation_strategy: Optional[builtins.str] = None,
                 bid_percentage: Optional[builtins.int] = None,
                 desiredv_cpus: Optional[builtins.int] = None,
                 ec2_configuration: Optional[Sequence['outputs.ComputeEnvironmentEc2ConfigurationObject']] = None,
                 ec2_key_pair: Optional[builtins.str] = None,
                 image_id: Optional[builtins.str] = None,
                 instance_role: Optional[builtins.str] = None,
                 instance_types: Optional[Sequence[builtins.str]] = None,
                 launch_template: Optional['outputs.ComputeEnvironmentLaunchTemplateSpecification'] = None,
                 minv_cpus: Optional[builtins.int] = None,
                 placement_group: Optional[builtins.str] = None,
                 security_group_ids: Optional[Sequence[builtins.str]] = None,
                 spot_iam_fleet_role: Optional[builtins.str] = None,
                 tags: Optional[Mapping[str, builtins.str]] = None,
                 update_to_latest_image_version: Optional[builtins.bool] = None):
        """
        :param builtins.int maxv_cpus: The maximum number of Amazon EC2 vCPUs that an environment can reach.
               
               > With `BEST_FIT_PROGRESSIVE` , `SPOT_CAPACITY_OPTIMIZED` and `SPOT_PRICE_CAPACITY_OPTIMIZED` (recommended) strategies using On-Demand or Spot Instances, and the `BEST_FIT` strategy using Spot Instances, AWS Batch might need to exceed `maxvCpus` to meet your capacity requirements. In this event, AWS Batch never exceeds `maxvCpus` by more than a single instance.
        :param Sequence[builtins.str] subnets: The VPC subnets where the compute resources are launched. Fargate compute resources can contain up to 16 subnets. For Fargate compute resources, providing an empty list will be handled as if this parameter wasn't specified and no change is made. For Amazon EC2 compute resources, providing an empty list removes the VPC subnets from the compute resource. For more information, see [VPCs and subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) in the *Amazon VPC User Guide* .
               
               When updating a compute environment, changing the VPC subnets requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
               
               > AWS Batch on Amazon EC2 and AWS Batch on Amazon EKS support Local Zones. For more information, see [Local Zones](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-local-zones) in the *Amazon EC2 User Guide for Linux Instances* , [Amazon EKS and AWS Local Zones](https://docs.aws.amazon.com/eks/latest/userguide/local-zones.html) in the *Amazon EKS User Guide* and [Amazon ECS clusters in Local Zones, Wavelength Zones, and AWS Outposts](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-regions-zones.html#clusters-local-zones) in the *Amazon ECS Developer Guide* .
               > 
               > AWS Batch on Fargate doesn't currently support Local Zones.
        :param builtins.str type: The type of compute environment: `EC2` , `SPOT` , `FARGATE` , or `FARGATE_SPOT` . For more information, see [Compute environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the *AWS Batch User Guide* .
               
               If you choose `SPOT` , you must also specify an Amazon EC2 Spot Fleet role with the `spotIamFleetRole` parameter. For more information, see [Amazon EC2 spot fleet role](https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html) in the *AWS Batch User Guide* .
               
               When updating compute environment, changing the type of a compute environment requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
               
               When updating the type of a compute environment, changing between `EC2` and `SPOT` or between `FARGATE` and `FARGATE_SPOT` will initiate an infrastructure update, but if you switch between `EC2` and `FARGATE` , AWS CloudFormation will create a new compute environment.
        :param builtins.str allocation_strategy: The allocation strategy to use for the compute resource if not enough instances of the best fitting instance type can be allocated. This might be because of availability of the instance type in the Region or [Amazon EC2 service limits](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html) . For more information, see [Allocation strategies](https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html) in the *AWS Batch User Guide* .
               
               When updating a compute environment, changing the allocation strategy requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* . `BEST_FIT` is not supported when updating a compute environment.
               
               > This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified. 
               
               - **BEST_FIT (default)** - AWS Batch selects an instance type that best fits the needs of the jobs with a preference for the lowest-cost instance type. If additional instances of the selected instance type aren't available, AWS Batch waits for the additional instances to be available. If there aren't enough instances available, or if the user is reaching [Amazon EC2 service limits](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html) then additional jobs aren't run until the currently running jobs have completed. This allocation strategy keeps costs lower but can limit scaling. If you are using Spot Fleets with `BEST_FIT` then the Spot Fleet IAM role must be specified.
               - **BEST_FIT_PROGRESSIVE** - AWS Batch will select additional instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types with a lower cost per unit vCPU. If additional instances of the previously selected instance types aren't available, AWS Batch will select new instance types.
               - **SPOT_CAPACITY_OPTIMIZED** - AWS Batch will select one or more instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types that are less likely to be interrupted. This allocation strategy is only available for Spot Instance compute resources.
               - **SPOT_PRICE_CAPACITY_OPTIMIZED** - The price and capacity optimized allocation strategy looks at both price and capacity to select the Spot Instance pools that are the least likely to be interrupted and have the lowest possible price. This allocation strategy is only available for Spot Instance compute resources.
               
               > We recommend that you use `SPOT_PRICE_CAPACITY_OPTIMIZED` rather than `SPOT_CAPACITY_OPTIMIZED` in most instances.
               
               With `BEST_FIT_PROGRESSIVE` , `SPOT_CAPACITY_OPTIMIZED` , and `SPOT_PRICE_CAPACITY_OPTIMIZED` allocation strategies using On-Demand or Spot Instances, and the `BEST_FIT` strategy using Spot Instances, AWS Batch might need to go above `maxvCpus` to meet your capacity requirements. In this event, AWS Batch never exceeds `maxvCpus` by more than a single instance.
        :param builtins.int bid_percentage: The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your maximum percentage is 20%, the Spot price must be less than 20% of the current On-Demand price for that Amazon EC2 instance. You always pay the lowest (market) price and never more than your maximum percentage. For most use cases, we recommend leaving this field empty.
               
               When updating a compute environment, changing the bid percentage requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        :param builtins.int desiredv_cpus: The desired number of vCPUS in the compute environment. AWS Batch modifies this value between the minimum and maximum values based on job queue demand.
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it. > AWS Batch doesn't support changing the desired number of vCPUs of an existing compute environment. Don't specify this parameter for compute environments using Amazon EKS clusters. > When you update the `desiredvCpus` setting, the value must be between the `minvCpus` and `maxvCpus` values.
               > 
               > Additionally, the updated `desiredvCpus` value must be greater than or equal to the current `desiredvCpus` value. For more information, see [Troubleshooting AWS Batch](https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#error-desired-vcpus-update) in the *AWS Batch User Guide* .
        :param Sequence['ComputeEnvironmentEc2ConfigurationObject'] ec2_configuration: Provides information used to select Amazon Machine Images (AMIs) for Amazon EC2 instances in the compute environment. If `Ec2Configuration` isn't specified, the default is `ECS_AL2` .
               
               When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* . To remove the Amazon EC2 configuration and any custom AMI ID specified in `imageIdOverride` , set this value to an empty string.
               
               One or two values can be provided.
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        :param builtins.str ec2_key_pair: The Amazon EC2 key pair that's used for instances launched in the compute environment. You can use this key pair to log in to your instances with SSH. To remove the Amazon EC2 key pair, set this value to an empty string.
               
               When updating a compute environment, changing the Amazon EC2 key pair requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        :param builtins.str image_id: The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter is overridden by the `imageIdOverride` member of the `Ec2Configuration` structure. To remove the custom AMI ID and use the default AMI ID, set this value to an empty string.
               
               When updating a compute environment, changing the AMI ID requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it. > The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param builtins.str instance_role: The Amazon ECS instance profile applied to Amazon EC2 instances in a compute environment. Required for Amazon EC2 instances. You can specify the short name or full Amazon Resource Name (ARN) of an instance profile. For example, `*ecsInstanceRole*` or `arn:aws:iam:: *<aws_account_id>* :instance-profile/ *ecsInstanceRole*` . For more information, see [Amazon ECS instance role](https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html) in the *AWS Batch User Guide* .
               
               When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        :param Sequence[builtins.str] instance_types: The instances types that can be launched. You can specify instance families to launch any instance type within those families (for example, `c5` or `p3` ), or you can specify specific sizes within a family (such as `c5.8xlarge` ). You can also choose `optimal` to select instance types (from the C4, M4, and R4 instance families) that match the demand of your job queues.
               
               When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it. > When you create a compute environment, the instance types that you select for the compute environment must share the same architecture. For example, you can't mix x86 and ARM instances in the same compute environment. > Currently, `optimal` uses instance types from the C4, M4, and R4 instance families. In Regions that don't have instance types from those instance families, instance types from the C5, M5, and R5 instance families are used.
        :param 'ComputeEnvironmentLaunchTemplateSpecification' launch_template: The launch template to use for your compute resources. Any other compute resource parameters that you specify in a [CreateComputeEnvironment](https://docs.aws.amazon.com/batch/latest/APIReference/API_CreateComputeEnvironment.html) API operation override the same parameters in the launch template. You must specify either the launch template ID or launch template name in the request, but not both. For more information, see [Launch Template Support](https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html) in the ** . Removing the launch template from a compute environment will not remove the AMI specified in the launch template. In order to update the AMI specified in a launch template, the `updateToLatestImageVersion` parameter must be set to `true` .
               
               When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the ** .
               
               > This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param builtins.int minv_cpus: The minimum number of vCPUs that an environment should maintain (even if the compute environment is `DISABLED` ).
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        :param builtins.str placement_group: The Amazon EC2 placement group to associate with your compute resources. If you intend to submit multi-node parallel jobs to your compute environment, you should consider creating a cluster placement group and associate it with your compute resources. This keeps your multi-node parallel job on a logical grouping of instances within a single Availability Zone with high network flow potential. For more information, see [Placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html) in the *Amazon EC2 User Guide for Linux Instances* .
               
               When updating a compute environment, changing the placement group requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        :param Sequence[builtins.str] security_group_ids: The Amazon EC2 security groups that are associated with instances launched in the compute environment. This parameter is required for Fargate compute resources, where it can contain up to 5 security groups. For Fargate compute resources, providing an empty list is handled as if this parameter wasn't specified and no change is made. For Amazon EC2 compute resources, providing an empty list removes the security groups from the compute resource.
               
               When updating a compute environment, changing the Amazon EC2 security groups requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
        :param builtins.str spot_iam_fleet_role: The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a `SPOT` compute environment. This role is required if the allocation strategy set to `BEST_FIT` or if the allocation strategy isn't specified. For more information, see [Amazon EC2 spot fleet role](https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html) in the *AWS Batch User Guide* .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it. > To tag your Spot Instances on creation, the Spot Fleet IAM role specified here must use the newer *AmazonEC2SpotFleetTaggingRole* managed policy. The previously recommended *AmazonEC2SpotFleetRole* managed policy doesn't have the required permissions to tag Spot Instances. For more information, see [Spot instances not tagged on creation](https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#spot-instance-no-tag) in the *AWS Batch User Guide* .
        :param Mapping[str, builtins.str] tags: A key-value pair to associate with a resource.
        :param builtins.bool update_to_latest_image_version: Specifies whether the AMI ID is updated to the latest one that's supported by AWS Batch when the compute environment has an infrastructure update. The default value is `false` .
               
               > An AMI ID can either be specified in the `imageId` or `imageIdOverride` parameters or be determined by the launch template that's specified in the `launchTemplate` parameter. If an AMI ID is specified any of these ways, this parameter is ignored. For more information about to update AMI IDs during an infrastructure update, see [Updating the AMI ID](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html#updating-compute-environments-ami) in the *AWS Batch User Guide* . 
               
               When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
        """
        pulumi.set(__self__, "maxv_cpus", maxv_cpus)
        pulumi.set(__self__, "subnets", subnets)
        pulumi.set(__self__, "type", type)
        if allocation_strategy is not None:
            pulumi.set(__self__, "allocation_strategy", allocation_strategy)
        if bid_percentage is not None:
            pulumi.set(__self__, "bid_percentage", bid_percentage)
        if desiredv_cpus is not None:
            pulumi.set(__self__, "desiredv_cpus", desiredv_cpus)
        if ec2_configuration is not None:
            pulumi.set(__self__, "ec2_configuration", ec2_configuration)
        if ec2_key_pair is not None:
            pulumi.set(__self__, "ec2_key_pair", ec2_key_pair)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_role is not None:
            pulumi.set(__self__, "instance_role", instance_role)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if minv_cpus is not None:
            pulumi.set(__self__, "minv_cpus", minv_cpus)
        if placement_group is not None:
            pulumi.set(__self__, "placement_group", placement_group)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if spot_iam_fleet_role is not None:
            pulumi.set(__self__, "spot_iam_fleet_role", spot_iam_fleet_role)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if update_to_latest_image_version is not None:
            pulumi.set(__self__, "update_to_latest_image_version", update_to_latest_image_version)

    @property
    @pulumi.getter(name="maxvCpus")
    def maxv_cpus(self) -> builtins.int:
        """
        The maximum number of Amazon EC2 vCPUs that an environment can reach.

        > With `BEST_FIT_PROGRESSIVE` , `SPOT_CAPACITY_OPTIMIZED` and `SPOT_PRICE_CAPACITY_OPTIMIZED` (recommended) strategies using On-Demand or Spot Instances, and the `BEST_FIT` strategy using Spot Instances, AWS Batch might need to exceed `maxvCpus` to meet your capacity requirements. In this event, AWS Batch never exceeds `maxvCpus` by more than a single instance.
        """
        return pulumi.get(self, "maxv_cpus")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[builtins.str]:
        """
        The VPC subnets where the compute resources are launched. Fargate compute resources can contain up to 16 subnets. For Fargate compute resources, providing an empty list will be handled as if this parameter wasn't specified and no change is made. For Amazon EC2 compute resources, providing an empty list removes the VPC subnets from the compute resource. For more information, see [VPCs and subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) in the *Amazon VPC User Guide* .

        When updating a compute environment, changing the VPC subnets requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > AWS Batch on Amazon EC2 and AWS Batch on Amazon EKS support Local Zones. For more information, see [Local Zones](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-local-zones) in the *Amazon EC2 User Guide for Linux Instances* , [Amazon EKS and AWS Local Zones](https://docs.aws.amazon.com/eks/latest/userguide/local-zones.html) in the *Amazon EKS User Guide* and [Amazon ECS clusters in Local Zones, Wavelength Zones, and AWS Outposts](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-regions-zones.html#clusters-local-zones) in the *Amazon ECS Developer Guide* .
        > 
        > AWS Batch on Fargate doesn't currently support Local Zones.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of compute environment: `EC2` , `SPOT` , `FARGATE` , or `FARGATE_SPOT` . For more information, see [Compute environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the *AWS Batch User Guide* .

        If you choose `SPOT` , you must also specify an Amazon EC2 Spot Fleet role with the `spotIamFleetRole` parameter. For more information, see [Amazon EC2 spot fleet role](https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html) in the *AWS Batch User Guide* .

        When updating compute environment, changing the type of a compute environment requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        When updating the type of a compute environment, changing between `EC2` and `SPOT` or between `FARGATE` and `FARGATE_SPOT` will initiate an infrastructure update, but if you switch between `EC2` and `FARGATE` , AWS CloudFormation will create a new compute environment.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> Optional[builtins.str]:
        """
        The allocation strategy to use for the compute resource if not enough instances of the best fitting instance type can be allocated. This might be because of availability of the instance type in the Region or [Amazon EC2 service limits](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html) . For more information, see [Allocation strategies](https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html) in the *AWS Batch User Guide* .

        When updating a compute environment, changing the allocation strategy requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* . `BEST_FIT` is not supported when updating a compute environment.

        > This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified. 

        - **BEST_FIT (default)** - AWS Batch selects an instance type that best fits the needs of the jobs with a preference for the lowest-cost instance type. If additional instances of the selected instance type aren't available, AWS Batch waits for the additional instances to be available. If there aren't enough instances available, or if the user is reaching [Amazon EC2 service limits](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html) then additional jobs aren't run until the currently running jobs have completed. This allocation strategy keeps costs lower but can limit scaling. If you are using Spot Fleets with `BEST_FIT` then the Spot Fleet IAM role must be specified.
        - **BEST_FIT_PROGRESSIVE** - AWS Batch will select additional instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types with a lower cost per unit vCPU. If additional instances of the previously selected instance types aren't available, AWS Batch will select new instance types.
        - **SPOT_CAPACITY_OPTIMIZED** - AWS Batch will select one or more instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types that are less likely to be interrupted. This allocation strategy is only available for Spot Instance compute resources.
        - **SPOT_PRICE_CAPACITY_OPTIMIZED** - The price and capacity optimized allocation strategy looks at both price and capacity to select the Spot Instance pools that are the least likely to be interrupted and have the lowest possible price. This allocation strategy is only available for Spot Instance compute resources.

        > We recommend that you use `SPOT_PRICE_CAPACITY_OPTIMIZED` rather than `SPOT_CAPACITY_OPTIMIZED` in most instances.

        With `BEST_FIT_PROGRESSIVE` , `SPOT_CAPACITY_OPTIMIZED` , and `SPOT_PRICE_CAPACITY_OPTIMIZED` allocation strategies using On-Demand or Spot Instances, and the `BEST_FIT` strategy using Spot Instances, AWS Batch might need to go above `maxvCpus` to meet your capacity requirements. In this event, AWS Batch never exceeds `maxvCpus` by more than a single instance.
        """
        return pulumi.get(self, "allocation_strategy")

    @property
    @pulumi.getter(name="bidPercentage")
    def bid_percentage(self) -> Optional[builtins.int]:
        """
        The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your maximum percentage is 20%, the Spot price must be less than 20% of the current On-Demand price for that Amazon EC2 instance. You always pay the lowest (market) price and never more than your maximum percentage. For most use cases, we recommend leaving this field empty.

        When updating a compute environment, changing the bid percentage requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        """
        return pulumi.get(self, "bid_percentage")

    @property
    @pulumi.getter(name="desiredvCpus")
    def desiredv_cpus(self) -> Optional[builtins.int]:
        """
        The desired number of vCPUS in the compute environment. AWS Batch modifies this value between the minimum and maximum values based on job queue demand.

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it. > AWS Batch doesn't support changing the desired number of vCPUs of an existing compute environment. Don't specify this parameter for compute environments using Amazon EKS clusters. > When you update the `desiredvCpus` setting, the value must be between the `minvCpus` and `maxvCpus` values.
        > 
        > Additionally, the updated `desiredvCpus` value must be greater than or equal to the current `desiredvCpus` value. For more information, see [Troubleshooting AWS Batch](https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#error-desired-vcpus-update) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "desiredv_cpus")

    @property
    @pulumi.getter(name="ec2Configuration")
    def ec2_configuration(self) -> Optional[Sequence['outputs.ComputeEnvironmentEc2ConfigurationObject']]:
        """
        Provides information used to select Amazon Machine Images (AMIs) for Amazon EC2 instances in the compute environment. If `Ec2Configuration` isn't specified, the default is `ECS_AL2` .

        When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* . To remove the Amazon EC2 configuration and any custom AMI ID specified in `imageIdOverride` , set this value to an empty string.

        One or two values can be provided.

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        """
        return pulumi.get(self, "ec2_configuration")

    @property
    @pulumi.getter(name="ec2KeyPair")
    def ec2_key_pair(self) -> Optional[builtins.str]:
        """
        The Amazon EC2 key pair that's used for instances launched in the compute environment. You can use this key pair to log in to your instances with SSH. To remove the Amazon EC2 key pair, set this value to an empty string.

        When updating a compute environment, changing the Amazon EC2 key pair requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        """
        return pulumi.get(self, "ec2_key_pair")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[builtins.str]:
        """
        The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter is overridden by the `imageIdOverride` member of the `Ec2Configuration` structure. To remove the custom AMI ID and use the default AMI ID, set this value to an empty string.

        When updating a compute environment, changing the AMI ID requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it. > The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="instanceRole")
    def instance_role(self) -> Optional[builtins.str]:
        """
        The Amazon ECS instance profile applied to Amazon EC2 instances in a compute environment. Required for Amazon EC2 instances. You can specify the short name or full Amazon Resource Name (ARN) of an instance profile. For example, `*ecsInstanceRole*` or `arn:aws:iam:: *<aws_account_id>* :instance-profile/ *ecsInstanceRole*` . For more information, see [Amazon ECS instance role](https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html) in the *AWS Batch User Guide* .

        When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        """
        return pulumi.get(self, "instance_role")

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[Sequence[builtins.str]]:
        """
        The instances types that can be launched. You can specify instance families to launch any instance type within those families (for example, `c5` or `p3` ), or you can specify specific sizes within a family (such as `c5.8xlarge` ). You can also choose `optimal` to select instance types (from the C4, M4, and R4 instance families) that match the demand of your job queues.

        When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it. > When you create a compute environment, the instance types that you select for the compute environment must share the same architecture. For example, you can't mix x86 and ARM instances in the same compute environment. > Currently, `optimal` uses instance types from the C4, M4, and R4 instance families. In Regions that don't have instance types from those instance families, instance types from the C5, M5, and R5 instance families are used.
        """
        return pulumi.get(self, "instance_types")

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional['outputs.ComputeEnvironmentLaunchTemplateSpecification']:
        """
        The launch template to use for your compute resources. Any other compute resource parameters that you specify in a [CreateComputeEnvironment](https://docs.aws.amazon.com/batch/latest/APIReference/API_CreateComputeEnvironment.html) API operation override the same parameters in the launch template. You must specify either the launch template ID or launch template name in the request, but not both. For more information, see [Launch Template Support](https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html) in the ** . Removing the launch template from a compute environment will not remove the AMI specified in the launch template. In order to update the AMI specified in a launch template, the `updateToLatestImageVersion` parameter must be set to `true` .

        When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the ** .

        > This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "launch_template")

    @property
    @pulumi.getter(name="minvCpus")
    def minv_cpus(self) -> Optional[builtins.int]:
        """
        The minimum number of vCPUs that an environment should maintain (even if the compute environment is `DISABLED` ).

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        """
        return pulumi.get(self, "minv_cpus")

    @property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> Optional[builtins.str]:
        """
        The Amazon EC2 placement group to associate with your compute resources. If you intend to submit multi-node parallel jobs to your compute environment, you should consider creating a cluster placement group and associate it with your compute resources. This keeps your multi-node parallel job on a logical grouping of instances within a single Availability Zone with high network flow potential. For more information, see [Placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html) in the *Amazon EC2 User Guide for Linux Instances* .

        When updating a compute environment, changing the placement group requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        """
        return pulumi.get(self, "placement_group")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The Amazon EC2 security groups that are associated with instances launched in the compute environment. This parameter is required for Fargate compute resources, where it can contain up to 5 security groups. For Fargate compute resources, providing an empty list is handled as if this parameter wasn't specified and no change is made. For Amazon EC2 compute resources, providing an empty list removes the security groups from the compute resource.

        When updating a compute environment, changing the Amazon EC2 security groups requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="spotIamFleetRole")
    def spot_iam_fleet_role(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a `SPOT` compute environment. This role is required if the allocation strategy set to `BEST_FIT` or if the allocation strategy isn't specified. For more information, see [Amazon EC2 spot fleet role](https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it. > To tag your Spot Instances on creation, the Spot Fleet IAM role specified here must use the newer *AmazonEC2SpotFleetTaggingRole* managed policy. The previously recommended *AmazonEC2SpotFleetRole* managed policy doesn't have the required permissions to tag Spot Instances. For more information, see [Spot instances not tagged on creation](https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#spot-instance-no-tag) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "spot_iam_fleet_role")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A key-value pair to associate with a resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updateToLatestImageVersion")
    def update_to_latest_image_version(self) -> Optional[builtins.bool]:
        """
        Specifies whether the AMI ID is updated to the latest one that's supported by AWS Batch when the compute environment has an infrastructure update. The default value is `false` .

        > An AMI ID can either be specified in the `imageId` or `imageIdOverride` parameters or be determined by the launch template that's specified in the `launchTemplate` parameter. If an AMI ID is specified any of these ways, this parameter is ignored. For more information about to update AMI IDs during an infrastructure update, see [Updating the AMI ID](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html#updating-compute-environments-ami) in the *AWS Batch User Guide* . 

        When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "update_to_latest_image_version")


@pulumi.output_type
class ComputeEnvironmentEc2ConfigurationObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageType":
            suggest = "image_type"
        elif key == "imageIdOverride":
            suggest = "image_id_override"
        elif key == "imageKubernetesVersion":
            suggest = "image_kubernetes_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeEnvironmentEc2ConfigurationObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeEnvironmentEc2ConfigurationObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeEnvironmentEc2ConfigurationObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_type: builtins.str,
                 image_id_override: Optional[builtins.str] = None,
                 image_kubernetes_version: Optional[builtins.str] = None):
        """
        :param builtins.str image_type: The image type to match with the instance type to select an AMI. The supported values are different for `ECS` and `EKS` resources.
               
               - **ECS** - If the `imageIdOverride` parameter isn't specified, then a recent [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) ( `ECS_AL2` ) is used. If a new image type is specified in an update, but neither an `imageId` nor a `imageIdOverride` parameter is specified, then the latest Amazon ECS optimized AMI for that image type that's supported by AWS Batch is used.
               
               - **ECS_AL2** - [Amazon Linux 2](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) : Default for all non-GPU instance families.
               - **ECS_AL2_NVIDIA** - [Amazon Linux 2 (GPU)](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#gpuami) : Default for all GPU instance families (for example `P4` and `G4` ) and can be used for all non AWS Graviton-based instance types.
               - **ECS_AL2023** - [Amazon Linux 2023](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) : AWS Batch supports Amazon Linux 2023.
               
               > Amazon Linux 2023 does not support `A1` instances.
               - **ECS_AL1** - [Amazon Linux](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#alami) . Amazon Linux has reached the end-of-life of standard support. For more information, see [Amazon Linux AMI](https://docs.aws.amazon.com/amazon-linux-ami/) .
               - **EKS** - If the `imageIdOverride` parameter isn't specified, then a recent [Amazon EKS-optimized Amazon Linux AMI](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html) ( `EKS_AL2` ) is used. If a new image type is specified in an update, but neither an `imageId` nor a `imageIdOverride` parameter is specified, then the latest Amazon EKS optimized AMI for that image type that AWS Batch supports is used.
               
               - **EKS_AL2** - [Amazon Linux 2](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html) : Default for all non-GPU instance families.
               - **EKS_AL2_NVIDIA** - [Amazon Linux 2 (accelerated)](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html) : Default for all GPU instance families (for example, `P4` and `G4` ) and can be used for all non AWS Graviton-based instance types.
        :param builtins.str image_id_override: The AMI ID used for instances launched in the compute environment that match the image type. This setting overrides the `imageId` set in the `computeResource` object.
               
               > The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param builtins.str image_kubernetes_version: The Kubernetes version for the compute environment. If you don't specify a value, the latest version that AWS Batch supports is used.
        """
        pulumi.set(__self__, "image_type", image_type)
        if image_id_override is not None:
            pulumi.set(__self__, "image_id_override", image_id_override)
        if image_kubernetes_version is not None:
            pulumi.set(__self__, "image_kubernetes_version", image_kubernetes_version)

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> builtins.str:
        """
        The image type to match with the instance type to select an AMI. The supported values are different for `ECS` and `EKS` resources.

        - **ECS** - If the `imageIdOverride` parameter isn't specified, then a recent [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) ( `ECS_AL2` ) is used. If a new image type is specified in an update, but neither an `imageId` nor a `imageIdOverride` parameter is specified, then the latest Amazon ECS optimized AMI for that image type that's supported by AWS Batch is used.

        - **ECS_AL2** - [Amazon Linux 2](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) : Default for all non-GPU instance families.
        - **ECS_AL2_NVIDIA** - [Amazon Linux 2 (GPU)](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#gpuami) : Default for all GPU instance families (for example `P4` and `G4` ) and can be used for all non AWS Graviton-based instance types.
        - **ECS_AL2023** - [Amazon Linux 2023](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) : AWS Batch supports Amazon Linux 2023.

        > Amazon Linux 2023 does not support `A1` instances.
        - **ECS_AL1** - [Amazon Linux](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#alami) . Amazon Linux has reached the end-of-life of standard support. For more information, see [Amazon Linux AMI](https://docs.aws.amazon.com/amazon-linux-ami/) .
        - **EKS** - If the `imageIdOverride` parameter isn't specified, then a recent [Amazon EKS-optimized Amazon Linux AMI](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html) ( `EKS_AL2` ) is used. If a new image type is specified in an update, but neither an `imageId` nor a `imageIdOverride` parameter is specified, then the latest Amazon EKS optimized AMI for that image type that AWS Batch supports is used.

        - **EKS_AL2** - [Amazon Linux 2](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html) : Default for all non-GPU instance families.
        - **EKS_AL2_NVIDIA** - [Amazon Linux 2 (accelerated)](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html) : Default for all GPU instance families (for example, `P4` and `G4` ) and can be used for all non AWS Graviton-based instance types.
        """
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="imageIdOverride")
    def image_id_override(self) -> Optional[builtins.str]:
        """
        The AMI ID used for instances launched in the compute environment that match the image type. This setting overrides the `imageId` set in the `computeResource` object.

        > The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "image_id_override")

    @property
    @pulumi.getter(name="imageKubernetesVersion")
    def image_kubernetes_version(self) -> Optional[builtins.str]:
        """
        The Kubernetes version for the compute environment. If you don't specify a value, the latest version that AWS Batch supports is used.
        """
        return pulumi.get(self, "image_kubernetes_version")


@pulumi.output_type
class ComputeEnvironmentEksConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eksClusterArn":
            suggest = "eks_cluster_arn"
        elif key == "kubernetesNamespace":
            suggest = "kubernetes_namespace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeEnvironmentEksConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeEnvironmentEksConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeEnvironmentEksConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eks_cluster_arn: builtins.str,
                 kubernetes_namespace: builtins.str):
        """
        :param builtins.str eks_cluster_arn: The Amazon Resource Name (ARN) of the Amazon EKS cluster. An example is `arn: *aws* :eks: *us-east-1* : *123456789012* :cluster/ *ClusterForBatch*` .
        :param builtins.str kubernetes_namespace: The namespace of the Amazon EKS cluster. AWS Batch manages pods in this namespace. The value can't left empty or null. It must be fewer than 64 characters long, can't be set to `default` , can't start with " `kube-` ," and must match this regular expression: `^[a-z0-9]([-a-z0-9]*[a-z0-9])?$` . For more information, see [Namespaces](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/) in the Kubernetes documentation.
        """
        pulumi.set(__self__, "eks_cluster_arn", eks_cluster_arn)
        pulumi.set(__self__, "kubernetes_namespace", kubernetes_namespace)

    @property
    @pulumi.getter(name="eksClusterArn")
    def eks_cluster_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the Amazon EKS cluster. An example is `arn: *aws* :eks: *us-east-1* : *123456789012* :cluster/ *ClusterForBatch*` .
        """
        return pulumi.get(self, "eks_cluster_arn")

    @property
    @pulumi.getter(name="kubernetesNamespace")
    def kubernetes_namespace(self) -> builtins.str:
        """
        The namespace of the Amazon EKS cluster. AWS Batch manages pods in this namespace. The value can't left empty or null. It must be fewer than 64 characters long, can't be set to `default` , can't start with " `kube-` ," and must match this regular expression: `^[a-z0-9]([-a-z0-9]*[a-z0-9])?$` . For more information, see [Namespaces](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/) in the Kubernetes documentation.
        """
        return pulumi.get(self, "kubernetes_namespace")


@pulumi.output_type
class ComputeEnvironmentLaunchTemplateSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchTemplateId":
            suggest = "launch_template_id"
        elif key == "launchTemplateName":
            suggest = "launch_template_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeEnvironmentLaunchTemplateSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeEnvironmentLaunchTemplateSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeEnvironmentLaunchTemplateSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_template_id: Optional[builtins.str] = None,
                 launch_template_name: Optional[builtins.str] = None,
                 overrides: Optional[Sequence['outputs.ComputeEnvironmentLaunchTemplateSpecificationOverride']] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str launch_template_id: The ID of the launch template.
        :param builtins.str launch_template_name: The name of the launch template.
        :param Sequence['ComputeEnvironmentLaunchTemplateSpecificationOverride'] overrides: A launch template to use in place of the default launch template. You must specify either the launch template ID or launch template name in the request, but not both.
               
               You can specify up to ten (10) launch template overrides that are associated to unique instance types or families for each compute environment.
               
               > To unset all override templates for a compute environment, you can pass an empty array to the [UpdateComputeEnvironment.overrides](https://docs.aws.amazon.com/batch/latest/APIReference/API_UpdateComputeEnvironment.html) parameter, or not include the `overrides` parameter when submitting the `UpdateComputeEnvironment` API operation.
        :param builtins.str version: The version number of the launch template, `$Default` , or `$Latest` .
               
               If the value is `$Default` , the default version of the launch template is used. If the value is `$Latest` , the latest version of the launch template is used.
               
               > If the AMI ID that's used in a compute environment is from the launch template, the AMI isn't changed when the compute environment is updated. It's only changed if the `updateToLatestImageVersion` parameter for the compute environment is set to `true` . During an infrastructure update, if either `$Default` or `$Latest` is specified, AWS Batch re-evaluates the launch template version, and it might use a different version of the launch template. This is the case even if the launch template isn't specified in the update. When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* . 
               
               Default: `$Default`
               
               Latest: `$Latest`
        """
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[builtins.str]:
        """
        The ID of the launch template.
        """
        return pulumi.get(self, "launch_template_id")

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[builtins.str]:
        """
        The name of the launch template.
        """
        return pulumi.get(self, "launch_template_name")

    @property
    @pulumi.getter
    def overrides(self) -> Optional[Sequence['outputs.ComputeEnvironmentLaunchTemplateSpecificationOverride']]:
        """
        A launch template to use in place of the default launch template. You must specify either the launch template ID or launch template name in the request, but not both.

        You can specify up to ten (10) launch template overrides that are associated to unique instance types or families for each compute environment.

        > To unset all override templates for a compute environment, you can pass an empty array to the [UpdateComputeEnvironment.overrides](https://docs.aws.amazon.com/batch/latest/APIReference/API_UpdateComputeEnvironment.html) parameter, or not include the `overrides` parameter when submitting the `UpdateComputeEnvironment` API operation.
        """
        return pulumi.get(self, "overrides")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        The version number of the launch template, `$Default` , or `$Latest` .

        If the value is `$Default` , the default version of the launch template is used. If the value is `$Latest` , the latest version of the launch template is used.

        > If the AMI ID that's used in a compute environment is from the launch template, the AMI isn't changed when the compute environment is updated. It's only changed if the `updateToLatestImageVersion` parameter for the compute environment is set to `true` . During an infrastructure update, if either `$Default` or `$Latest` is specified, AWS Batch re-evaluates the launch template version, and it might use a different version of the launch template. This is the case even if the launch template isn't specified in the update. When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* . 

        Default: `$Default`

        Latest: `$Latest`
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ComputeEnvironmentLaunchTemplateSpecificationOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchTemplateId":
            suggest = "launch_template_id"
        elif key == "launchTemplateName":
            suggest = "launch_template_name"
        elif key == "targetInstanceTypes":
            suggest = "target_instance_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeEnvironmentLaunchTemplateSpecificationOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeEnvironmentLaunchTemplateSpecificationOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeEnvironmentLaunchTemplateSpecificationOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_template_id: Optional[builtins.str] = None,
                 launch_template_name: Optional[builtins.str] = None,
                 target_instance_types: Optional[Sequence[builtins.str]] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str launch_template_id: The ID of the launch template.
               
               *Note:* If you specify the `launchTemplateId` you can't specify the `launchTemplateName` as well.
        :param builtins.str launch_template_name: The name of the launch template.
               
               *Note:* If you specify the `launchTemplateName` you can't specify the `launchTemplateId` as well.
        :param Sequence[builtins.str] target_instance_types: The instance type or family that this override launch template should be applied to.
               
               This parameter is required when defining a launch template override.
               
               Information included in this parameter must meet the following requirements:
               
               - Must be a valid Amazon EC2 instance type or family.
               - `optimal` isn't allowed.
               - `targetInstanceTypes` can target only instance types and families that are included within the [`ComputeResource.instanceTypes`](https://docs.aws.amazon.com/batch/latest/APIReference/API_ComputeResource.html#Batch-Type-ComputeResource-instanceTypes) set. `targetInstanceTypes` doesn't need to include all of the instances from the `instanceType` set, but at least a subset. For example, if `ComputeResource.instanceTypes` includes `[m5, g5]` , `targetInstanceTypes` can include `[m5.2xlarge]` and `[m5.large]` but not `[c5.large]` .
               - `targetInstanceTypes` included within the same launch template override or across launch template overrides can't overlap for the same compute environment. For example, you can't define one launch template override to target an instance family and another define an instance type within this same family.
        :param builtins.str version: The version number of the launch template, `$Default` , or `$Latest` .
               
               If the value is `$Default` , the default version of the launch template is used. If the value is `$Latest` , the latest version of the launch template is used.
               
               > If the AMI ID that's used in a compute environment is from the launch template, the AMI isn't changed when the compute environment is updated. It's only changed if the `updateToLatestImageVersion` parameter for the compute environment is set to `true` . During an infrastructure update, if either `$Default` or `$Latest` is specified, AWS Batch re-evaluates the launch template version, and it might use a different version of the launch template. This is the case even if the launch template isn't specified in the update. When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* . 
               
               Default: `$Default`
               
               Latest: `$Latest`
        """
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if target_instance_types is not None:
            pulumi.set(__self__, "target_instance_types", target_instance_types)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[builtins.str]:
        """
        The ID of the launch template.

        *Note:* If you specify the `launchTemplateId` you can't specify the `launchTemplateName` as well.
        """
        return pulumi.get(self, "launch_template_id")

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[builtins.str]:
        """
        The name of the launch template.

        *Note:* If you specify the `launchTemplateName` you can't specify the `launchTemplateId` as well.
        """
        return pulumi.get(self, "launch_template_name")

    @property
    @pulumi.getter(name="targetInstanceTypes")
    def target_instance_types(self) -> Optional[Sequence[builtins.str]]:
        """
        The instance type or family that this override launch template should be applied to.

        This parameter is required when defining a launch template override.

        Information included in this parameter must meet the following requirements:

        - Must be a valid Amazon EC2 instance type or family.
        - `optimal` isn't allowed.
        - `targetInstanceTypes` can target only instance types and families that are included within the [`ComputeResource.instanceTypes`](https://docs.aws.amazon.com/batch/latest/APIReference/API_ComputeResource.html#Batch-Type-ComputeResource-instanceTypes) set. `targetInstanceTypes` doesn't need to include all of the instances from the `instanceType` set, but at least a subset. For example, if `ComputeResource.instanceTypes` includes `[m5, g5]` , `targetInstanceTypes` can include `[m5.2xlarge]` and `[m5.large]` but not `[c5.large]` .
        - `targetInstanceTypes` included within the same launch template override or across launch template overrides can't overlap for the same compute environment. For example, you can't define one launch template override to target an instance family and another define an instance type within this same family.
        """
        return pulumi.get(self, "target_instance_types")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        The version number of the launch template, `$Default` , or `$Latest` .

        If the value is `$Default` , the default version of the launch template is used. If the value is `$Latest` , the latest version of the launch template is used.

        > If the AMI ID that's used in a compute environment is from the launch template, the AMI isn't changed when the compute environment is updated. It's only changed if the `updateToLatestImageVersion` parameter for the compute environment is set to `true` . During an infrastructure update, if either `$Default` or `$Latest` is specified, AWS Batch re-evaluates the launch template version, and it might use a different version of the launch template. This is the case even if the launch template isn't specified in the update. When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* . 

        Default: `$Default`

        Latest: `$Latest`
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ComputeEnvironmentUpdatePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobExecutionTimeoutMinutes":
            suggest = "job_execution_timeout_minutes"
        elif key == "terminateJobsOnUpdate":
            suggest = "terminate_jobs_on_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeEnvironmentUpdatePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeEnvironmentUpdatePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeEnvironmentUpdatePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_execution_timeout_minutes: Optional[builtins.int] = None,
                 terminate_jobs_on_update: Optional[builtins.bool] = None):
        """
        :param builtins.int job_execution_timeout_minutes: Specifies the job timeout (in minutes) when the compute environment infrastructure is updated. The default value is 30.
        :param builtins.bool terminate_jobs_on_update: Specifies whether jobs are automatically terminated when the compute environment infrastructure is updated. The default value is `false` .
        """
        if job_execution_timeout_minutes is not None:
            pulumi.set(__self__, "job_execution_timeout_minutes", job_execution_timeout_minutes)
        if terminate_jobs_on_update is not None:
            pulumi.set(__self__, "terminate_jobs_on_update", terminate_jobs_on_update)

    @property
    @pulumi.getter(name="jobExecutionTimeoutMinutes")
    def job_execution_timeout_minutes(self) -> Optional[builtins.int]:
        """
        Specifies the job timeout (in minutes) when the compute environment infrastructure is updated. The default value is 30.
        """
        return pulumi.get(self, "job_execution_timeout_minutes")

    @property
    @pulumi.getter(name="terminateJobsOnUpdate")
    def terminate_jobs_on_update(self) -> Optional[builtins.bool]:
        """
        Specifies whether jobs are automatically terminated when the compute environment infrastructure is updated. The default value is `false` .
        """
        return pulumi.get(self, "terminate_jobs_on_update")


@pulumi.output_type
class JobDefinitionConsumableResourceProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumableResourceList":
            suggest = "consumable_resource_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionConsumableResourceProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionConsumableResourceProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionConsumableResourceProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumable_resource_list: Sequence['outputs.JobDefinitionConsumableResourceRequirement']):
        """
        :param Sequence['JobDefinitionConsumableResourceRequirement'] consumable_resource_list: The list of consumable resources required by a job.
        """
        pulumi.set(__self__, "consumable_resource_list", consumable_resource_list)

    @property
    @pulumi.getter(name="consumableResourceList")
    def consumable_resource_list(self) -> Sequence['outputs.JobDefinitionConsumableResourceRequirement']:
        """
        The list of consumable resources required by a job.
        """
        return pulumi.get(self, "consumable_resource_list")


@pulumi.output_type
class JobDefinitionConsumableResourceRequirement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumableResource":
            suggest = "consumable_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionConsumableResourceRequirement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionConsumableResourceRequirement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionConsumableResourceRequirement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumable_resource: builtins.str,
                 quantity: builtins.int):
        """
        :param builtins.str consumable_resource: The ARN of the consumable resource the job definition should consume.
        :param builtins.int quantity: The quantity of the consumable resource that is needed.
        """
        pulumi.set(__self__, "consumable_resource", consumable_resource)
        pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter(name="consumableResource")
    def consumable_resource(self) -> builtins.str:
        """
        The ARN of the consumable resource the job definition should consume.
        """
        return pulumi.get(self, "consumable_resource")

    @property
    @pulumi.getter
    def quantity(self) -> builtins.int:
        """
        The quantity of the consumable resource that is needed.
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class JobDefinitionContainerProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableExecuteCommand":
            suggest = "enable_execute_command"
        elif key == "ephemeralStorage":
            suggest = "ephemeral_storage"
        elif key == "executionRoleArn":
            suggest = "execution_role_arn"
        elif key == "fargatePlatformConfiguration":
            suggest = "fargate_platform_configuration"
        elif key == "jobRoleArn":
            suggest = "job_role_arn"
        elif key == "linuxParameters":
            suggest = "linux_parameters"
        elif key == "logConfiguration":
            suggest = "log_configuration"
        elif key == "mountPoints":
            suggest = "mount_points"
        elif key == "networkConfiguration":
            suggest = "network_configuration"
        elif key == "readonlyRootFilesystem":
            suggest = "readonly_root_filesystem"
        elif key == "repositoryCredentials":
            suggest = "repository_credentials"
        elif key == "resourceRequirements":
            suggest = "resource_requirements"
        elif key == "runtimePlatform":
            suggest = "runtime_platform"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionContainerProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionContainerProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionContainerProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: builtins.str,
                 command: Optional[Sequence[builtins.str]] = None,
                 enable_execute_command: Optional[builtins.bool] = None,
                 environment: Optional[Sequence['outputs.JobDefinitionEnvironment']] = None,
                 ephemeral_storage: Optional['outputs.JobDefinitionEphemeralStorage'] = None,
                 execution_role_arn: Optional[builtins.str] = None,
                 fargate_platform_configuration: Optional['outputs.JobDefinitionContainerPropertiesFargatePlatformConfigurationProperties'] = None,
                 job_role_arn: Optional[builtins.str] = None,
                 linux_parameters: Optional['outputs.JobDefinitionLinuxParameters'] = None,
                 log_configuration: Optional['outputs.JobDefinitionLogConfiguration'] = None,
                 memory: Optional[builtins.int] = None,
                 mount_points: Optional[Sequence['outputs.JobDefinitionMountPoint']] = None,
                 network_configuration: Optional['outputs.JobDefinitionNetworkConfiguration'] = None,
                 privileged: Optional[builtins.bool] = None,
                 readonly_root_filesystem: Optional[builtins.bool] = None,
                 repository_credentials: Optional['outputs.JobDefinitionRepositoryCredentials'] = None,
                 resource_requirements: Optional[Sequence['outputs.JobDefinitionResourceRequirement']] = None,
                 runtime_platform: Optional['outputs.JobDefinitionRuntimePlatform'] = None,
                 secrets: Optional[Sequence['outputs.JobDefinitionSecret']] = None,
                 ulimits: Optional[Sequence['outputs.JobDefinitionUlimit']] = None,
                 user: Optional[builtins.str] = None,
                 vcpus: Optional[builtins.int] = None,
                 volumes: Optional[Sequence['outputs.JobDefinitionVolume']] = None):
        """
        :param builtins.str image: Required. The image used to start a container. This string is passed directly to the Docker daemon. Images in the Docker Hub registry are available by default. Other repositories are specified with `*repository-url* / *image* : *tag*` . It can be 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), underscores (_), colons (:), periods (.), forward slashes (/), and number signs (#). This parameter maps to `Image` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `IMAGE` parameter of [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > Docker image architecture must match the processor architecture of the compute resources that they're scheduled on. For example, ARM-based Docker images can only run on ARM-based compute resources. 
               
               - Images in Amazon ECR Public repositories use the full `registry/repository[:tag]` or `registry/repository[@digest]` naming conventions. For example, `public.ecr.aws/ *registry_alias* / *my-web-app* : *latest*` .
               - Images in Amazon ECR repositories use the full registry and repository URI (for example, `123456789012.dkr.ecr.<region-name>.amazonaws.com/<repository-name>` ).
               - Images in official repositories on Docker Hub use a single name (for example, `ubuntu` or `mongo` ).
               - Images in other repositories on Docker Hub are qualified with an organization name (for example, `amazon/amazon-ecs-agent` ).
               - Images in other online repositories are qualified further by a domain name (for example, `quay.io/assemblyline/ubuntu` ).
        :param Sequence[builtins.str] command: The command that's passed to the container. This parameter maps to `Cmd` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `COMMAND` parameter to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . For more information, see [https://docs.docker.com/engine/reference/builder/#cmd](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd) .
        :param builtins.bool enable_execute_command: Determines whether execute command functionality is turned on for this task. If `true` , execute command functionality is turned on all the containers in the task.
        :param Sequence['JobDefinitionEnvironment'] environment: The environment variables to pass to a container. This parameter maps to `Env` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--env` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > We don't recommend using plaintext environment variables for sensitive information, such as credential data. > Environment variables cannot start with " `AWS_BATCH` ". This naming convention is reserved for variables that AWS Batch sets.
        :param 'JobDefinitionEphemeralStorage' ephemeral_storage: The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
        :param builtins.str execution_role_arn: The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [AWS Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *AWS Batch User Guide* .
        :param 'JobDefinitionContainerPropertiesFargatePlatformConfigurationProperties' fargate_platform_configuration: The platform configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2 resources must not specify this parameter.
        :param builtins.str job_role_arn: The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions. For more information, see [IAM roles for tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param 'JobDefinitionLinuxParameters' linux_parameters: Linux-specific modifications that are applied to the container, such as details for device mappings.
        :param 'JobDefinitionLogConfiguration' log_configuration: The log configuration specification for the container.
               
               This parameter maps to `LogConfig` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--log-driver` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . By default, containers use the same logging driver that the Docker daemon uses. However the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see [Configure logging drivers](https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/) in the Docker documentation.
               
               > AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the [LogConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html) data type). 
               
               This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
               
               > The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param builtins.int memory: This parameter is deprecated, use `resourceRequirements` to specify the memory requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs that run on Amazon EC2 resources, it specifies the memory hard limit (in MiB) for a container. If your container attempts to exceed the specified number, it's terminated. You must specify at least 4 MiB of memory for a job using this parameter. The memory hard limit can be specified in several places. It must be specified for each node at least once.
        :param Sequence['JobDefinitionMountPoint'] mount_points: The mount points for data volumes in your container. This parameter maps to `Volumes` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--volume` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
        :param 'JobDefinitionNetworkConfiguration' network_configuration: The network configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2 resources must not specify this parameter.
        :param builtins.bool privileged: When this parameter is true, the container is given elevated permissions on the host container instance (similar to the `root` user). This parameter maps to `Privileged` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--privileged` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . The default value is false.
               
               > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided, or specified as false.
        :param builtins.bool readonly_root_filesystem: When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--read-only` option to `docker run` .
        :param 'JobDefinitionRepositoryCredentials' repository_credentials: The private repository authentication credentials to use.
        :param Sequence['JobDefinitionResourceRequirement'] resource_requirements: The type and amount of resources to assign to a container. The supported resources include `GPU` , `MEMORY` , and `VCPU` .
        :param 'JobDefinitionRuntimePlatform' runtime_platform: An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
        :param Sequence['JobDefinitionSecret'] secrets: The secrets for the container. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html) in the *AWS Batch User Guide* .
        :param Sequence['JobDefinitionUlimit'] ulimits: A list of `ulimits` to set in the container. This parameter maps to `Ulimits` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--ulimit` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
        :param builtins.str user: The user name to use inside the container. This parameter maps to `User` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--user` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
        :param builtins.int vcpus: This parameter is deprecated, use `resourceRequirements` to specify the vCPU requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs running on Amazon EC2 resources, it specifies the number of vCPUs reserved for the job.
               
               Each vCPU is equivalent to 1,024 CPU shares. This parameter maps to `CpuShares` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . The number of vCPUs must be specified but can be specified in several places. You must specify it at least once for each node.
        :param Sequence['JobDefinitionVolume'] volumes: A list of data volumes used in a job.
        """
        pulumi.set(__self__, "image", image)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if enable_execute_command is not None:
            pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if fargate_platform_configuration is not None:
            pulumi.set(__self__, "fargate_platform_configuration", fargate_platform_configuration)
        if job_role_arn is not None:
            pulumi.set(__self__, "job_role_arn", job_role_arn)
        if linux_parameters is not None:
            pulumi.set(__self__, "linux_parameters", linux_parameters)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if mount_points is not None:
            pulumi.set(__self__, "mount_points", mount_points)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if readonly_root_filesystem is not None:
            pulumi.set(__self__, "readonly_root_filesystem", readonly_root_filesystem)
        if repository_credentials is not None:
            pulumi.set(__self__, "repository_credentials", repository_credentials)
        if resource_requirements is not None:
            pulumi.set(__self__, "resource_requirements", resource_requirements)
        if runtime_platform is not None:
            pulumi.set(__self__, "runtime_platform", runtime_platform)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if ulimits is not None:
            pulumi.set(__self__, "ulimits", ulimits)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if vcpus is not None:
            pulumi.set(__self__, "vcpus", vcpus)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def image(self) -> builtins.str:
        """
        Required. The image used to start a container. This string is passed directly to the Docker daemon. Images in the Docker Hub registry are available by default. Other repositories are specified with `*repository-url* / *image* : *tag*` . It can be 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), underscores (_), colons (:), periods (.), forward slashes (/), and number signs (#). This parameter maps to `Image` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `IMAGE` parameter of [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > Docker image architecture must match the processor architecture of the compute resources that they're scheduled on. For example, ARM-based Docker images can only run on ARM-based compute resources. 

        - Images in Amazon ECR Public repositories use the full `registry/repository[:tag]` or `registry/repository[@digest]` naming conventions. For example, `public.ecr.aws/ *registry_alias* / *my-web-app* : *latest*` .
        - Images in Amazon ECR repositories use the full registry and repository URI (for example, `123456789012.dkr.ecr.<region-name>.amazonaws.com/<repository-name>` ).
        - Images in official repositories on Docker Hub use a single name (for example, `ubuntu` or `mongo` ).
        - Images in other repositories on Docker Hub are qualified with an organization name (for example, `amazon/amazon-ecs-agent` ).
        - Images in other online repositories are qualified further by a domain name (for example, `quay.io/assemblyline/ubuntu` ).
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def command(self) -> Optional[Sequence[builtins.str]]:
        """
        The command that's passed to the container. This parameter maps to `Cmd` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `COMMAND` parameter to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . For more information, see [https://docs.docker.com/engine/reference/builder/#cmd](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd) .
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[builtins.bool]:
        """
        Determines whether execute command functionality is turned on for this task. If `true` , execute command functionality is turned on all the containers in the task.
        """
        return pulumi.get(self, "enable_execute_command")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Sequence['outputs.JobDefinitionEnvironment']]:
        """
        The environment variables to pass to a container. This parameter maps to `Env` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--env` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > We don't recommend using plaintext environment variables for sensitive information, such as credential data. > Environment variables cannot start with " `AWS_BATCH` ". This naming convention is reserved for variables that AWS Batch sets.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional['outputs.JobDefinitionEphemeralStorage']:
        """
        The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
        """
        return pulumi.get(self, "ephemeral_storage")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [AWS Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter(name="fargatePlatformConfiguration")
    def fargate_platform_configuration(self) -> Optional['outputs.JobDefinitionContainerPropertiesFargatePlatformConfigurationProperties']:
        """
        The platform configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2 resources must not specify this parameter.
        """
        return pulumi.get(self, "fargate_platform_configuration")

    @property
    @pulumi.getter(name="jobRoleArn")
    def job_role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions. For more information, see [IAM roles for tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "job_role_arn")

    @property
    @pulumi.getter(name="linuxParameters")
    def linux_parameters(self) -> Optional['outputs.JobDefinitionLinuxParameters']:
        """
        Linux-specific modifications that are applied to the container, such as details for device mappings.
        """
        return pulumi.get(self, "linux_parameters")

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional['outputs.JobDefinitionLogConfiguration']:
        """
        The log configuration specification for the container.

        This parameter maps to `LogConfig` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--log-driver` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . By default, containers use the same logging driver that the Docker daemon uses. However the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see [Configure logging drivers](https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/) in the Docker documentation.

        > AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the [LogConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html) data type). 

        This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`

        > The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "log_configuration")

    @property
    @pulumi.getter
    def memory(self) -> Optional[builtins.int]:
        """
        This parameter is deprecated, use `resourceRequirements` to specify the memory requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs that run on Amazon EC2 resources, it specifies the memory hard limit (in MiB) for a container. If your container attempts to exceed the specified number, it's terminated. You must specify at least 4 MiB of memory for a job using this parameter. The memory hard limit can be specified in several places. It must be specified for each node at least once.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> Optional[Sequence['outputs.JobDefinitionMountPoint']]:
        """
        The mount points for data volumes in your container. This parameter maps to `Volumes` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--volume` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
        """
        return pulumi.get(self, "mount_points")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional['outputs.JobDefinitionNetworkConfiguration']:
        """
        The network configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2 resources must not specify this parameter.
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter
    def privileged(self) -> Optional[builtins.bool]:
        """
        When this parameter is true, the container is given elevated permissions on the host container instance (similar to the `root` user). This parameter maps to `Privileged` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--privileged` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . The default value is false.

        > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided, or specified as false.
        """
        return pulumi.get(self, "privileged")

    @property
    @pulumi.getter(name="readonlyRootFilesystem")
    def readonly_root_filesystem(self) -> Optional[builtins.bool]:
        """
        When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--read-only` option to `docker run` .
        """
        return pulumi.get(self, "readonly_root_filesystem")

    @property
    @pulumi.getter(name="repositoryCredentials")
    def repository_credentials(self) -> Optional['outputs.JobDefinitionRepositoryCredentials']:
        """
        The private repository authentication credentials to use.
        """
        return pulumi.get(self, "repository_credentials")

    @property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> Optional[Sequence['outputs.JobDefinitionResourceRequirement']]:
        """
        The type and amount of resources to assign to a container. The supported resources include `GPU` , `MEMORY` , and `VCPU` .
        """
        return pulumi.get(self, "resource_requirements")

    @property
    @pulumi.getter(name="runtimePlatform")
    def runtime_platform(self) -> Optional['outputs.JobDefinitionRuntimePlatform']:
        """
        An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
        """
        return pulumi.get(self, "runtime_platform")

    @property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.JobDefinitionSecret']]:
        """
        The secrets for the container. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter
    def ulimits(self) -> Optional[Sequence['outputs.JobDefinitionUlimit']]:
        """
        A list of `ulimits` to set in the container. This parameter maps to `Ulimits` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--ulimit` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
        """
        return pulumi.get(self, "ulimits")

    @property
    @pulumi.getter
    def user(self) -> Optional[builtins.str]:
        """
        The user name to use inside the container. This parameter maps to `User` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--user` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def vcpus(self) -> Optional[builtins.int]:
        """
        This parameter is deprecated, use `resourceRequirements` to specify the vCPU requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs running on Amazon EC2 resources, it specifies the number of vCPUs reserved for the job.

        Each vCPU is equivalent to 1,024 CPU shares. This parameter maps to `CpuShares` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . The number of vCPUs must be specified but can be specified in several places. You must specify it at least once for each node.
        """
        return pulumi.get(self, "vcpus")

    @property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.JobDefinitionVolume']]:
        """
        A list of data volumes used in a job.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class JobDefinitionContainerPropertiesFargatePlatformConfigurationProperties(dict):
    """
    The platform configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2 resources must not specify this parameter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "platformVersion":
            suggest = "platform_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionContainerPropertiesFargatePlatformConfigurationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionContainerPropertiesFargatePlatformConfigurationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionContainerPropertiesFargatePlatformConfigurationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 platform_version: Optional[builtins.str] = None):
        """
        The platform configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2 resources must not specify this parameter.
        """
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[builtins.str]:
        return pulumi.get(self, "platform_version")


@pulumi.output_type
class JobDefinitionDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPath":
            suggest = "container_path"
        elif key == "hostPath":
            suggest = "host_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_path: Optional[builtins.str] = None,
                 host_path: Optional[builtins.str] = None,
                 permissions: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str container_path: The path inside the container that's used to expose the host device. By default, the `hostPath` value is used.
        :param builtins.str host_path: The path for the device on the host container instance.
        :param Sequence[builtins.str] permissions: The explicit permissions to provide to the container for the device. By default, the container has permissions for `read` , `write` , and `mknod` for the device.
        """
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[builtins.str]:
        """
        The path inside the container that's used to expose the host device. By default, the `hostPath` value is used.
        """
        return pulumi.get(self, "container_path")

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional[builtins.str]:
        """
        The path for the device on the host container instance.
        """
        return pulumi.get(self, "host_path")

    @property
    @pulumi.getter
    def permissions(self) -> Optional[Sequence[builtins.str]]:
        """
        The explicit permissions to provide to the container for the device. By default, the container has permissions for `read` , `write` , and `mknod` for the device.
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class JobDefinitionEcsProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskProperties":
            suggest = "task_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEcsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEcsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEcsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 task_properties: Sequence['outputs.JobDefinitionEcsTaskProperties']):
        """
        :param Sequence['JobDefinitionEcsTaskProperties'] task_properties: An object that contains the properties for the Amazon ECS task definition of a job.
               
               > This object is currently limited to one task element. However, the task element can run up to 10 containers.
        """
        pulumi.set(__self__, "task_properties", task_properties)

    @property
    @pulumi.getter(name="taskProperties")
    def task_properties(self) -> Sequence['outputs.JobDefinitionEcsTaskProperties']:
        """
        An object that contains the properties for the Amazon ECS task definition of a job.

        > This object is currently limited to one task element. However, the task element can run up to 10 containers.
        """
        return pulumi.get(self, "task_properties")


@pulumi.output_type
class JobDefinitionEcsTaskProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableExecuteCommand":
            suggest = "enable_execute_command"
        elif key == "ephemeralStorage":
            suggest = "ephemeral_storage"
        elif key == "executionRoleArn":
            suggest = "execution_role_arn"
        elif key == "ipcMode":
            suggest = "ipc_mode"
        elif key == "networkConfiguration":
            suggest = "network_configuration"
        elif key == "pidMode":
            suggest = "pid_mode"
        elif key == "platformVersion":
            suggest = "platform_version"
        elif key == "runtimePlatform":
            suggest = "runtime_platform"
        elif key == "taskRoleArn":
            suggest = "task_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEcsTaskProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEcsTaskProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEcsTaskProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 containers: Optional[Sequence['outputs.JobDefinitionTaskContainerProperties']] = None,
                 enable_execute_command: Optional[builtins.bool] = None,
                 ephemeral_storage: Optional['outputs.JobDefinitionEphemeralStorage'] = None,
                 execution_role_arn: Optional[builtins.str] = None,
                 ipc_mode: Optional[builtins.str] = None,
                 network_configuration: Optional['outputs.JobDefinitionNetworkConfiguration'] = None,
                 pid_mode: Optional[builtins.str] = None,
                 platform_version: Optional[builtins.str] = None,
                 runtime_platform: Optional['outputs.JobDefinitionRuntimePlatform'] = None,
                 task_role_arn: Optional[builtins.str] = None,
                 volumes: Optional[Sequence['outputs.JobDefinitionVolume']] = None):
        """
        :param Sequence['JobDefinitionTaskContainerProperties'] containers: This object is a list of containers.
        :param builtins.bool enable_execute_command: Determines whether execute command functionality is turned on for this task. If `true` , execute command functionality is turned on all the containers in the task.
        :param 'JobDefinitionEphemeralStorage' ephemeral_storage: The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
        :param builtins.str execution_role_arn: The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [AWS Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *AWS Batch User Guide* .
        :param builtins.str ipc_mode: The IPC resource namespace to use for the containers in the task. The valid values are `host` , `task` , or `none` .
               
               If `host` is specified, all containers within the tasks that specified the `host` IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance.
               
               If `task` is specified, all containers within the specified `task` share the same IPC resources.
               
               If `none` is specified, the IPC resources within the containers of a task are private, and are not shared with other containers in a task or on the container instance.
               
               If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see [IPC settings](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#ipc-settings---ipc) in the Docker run reference.
        :param 'JobDefinitionNetworkConfiguration' network_configuration: The network configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2 resources must not specify this parameter.
        :param builtins.str pid_mode: The process namespace to use for the containers in the task. The valid values are `host` or `task` . For example, monitoring sidecars might need `pidMode` to access information about other containers running in the same task.
               
               If `host` is specified, all containers within the tasks that specified the `host` PID mode on the same container instance share the process namespace with the host Amazon EC2 instance.
               
               If `task` is specified, all containers within the specified task share the same process namespace.
               
               If no value is specified, the default is a private namespace for each container. For more information, see [PID settings](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#pid-settings---pid) in the Docker run reference.
        :param builtins.str platform_version: The Fargate platform version where the jobs are running. A platform version is specified only for jobs that are running on Fargate resources. If one isn't specified, the `LATEST` platform version is used by default. This uses a recent, approved version of the Fargate platform for compute resources. For more information, see [AWS Fargate platform versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param 'JobDefinitionRuntimePlatform' runtime_platform: An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
        :param builtins.str task_role_arn: The Amazon Resource Name (ARN) that's associated with the Amazon ECS task.
               
               > This is object is comparable to [ContainerProperties:jobRoleArn](https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html) .
        :param Sequence['JobDefinitionVolume'] volumes: A list of volumes that are associated with the job.
        """
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if enable_execute_command is not None:
            pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if ipc_mode is not None:
            pulumi.set(__self__, "ipc_mode", ipc_mode)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if pid_mode is not None:
            pulumi.set(__self__, "pid_mode", pid_mode)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if runtime_platform is not None:
            pulumi.set(__self__, "runtime_platform", runtime_platform)
        if task_role_arn is not None:
            pulumi.set(__self__, "task_role_arn", task_role_arn)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def containers(self) -> Optional[Sequence['outputs.JobDefinitionTaskContainerProperties']]:
        """
        This object is a list of containers.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[builtins.bool]:
        """
        Determines whether execute command functionality is turned on for this task. If `true` , execute command functionality is turned on all the containers in the task.
        """
        return pulumi.get(self, "enable_execute_command")

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional['outputs.JobDefinitionEphemeralStorage']:
        """
        The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
        """
        return pulumi.get(self, "ephemeral_storage")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [AWS Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter(name="ipcMode")
    def ipc_mode(self) -> Optional[builtins.str]:
        """
        The IPC resource namespace to use for the containers in the task. The valid values are `host` , `task` , or `none` .

        If `host` is specified, all containers within the tasks that specified the `host` IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance.

        If `task` is specified, all containers within the specified `task` share the same IPC resources.

        If `none` is specified, the IPC resources within the containers of a task are private, and are not shared with other containers in a task or on the container instance.

        If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see [IPC settings](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#ipc-settings---ipc) in the Docker run reference.
        """
        return pulumi.get(self, "ipc_mode")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional['outputs.JobDefinitionNetworkConfiguration']:
        """
        The network configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2 resources must not specify this parameter.
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter(name="pidMode")
    def pid_mode(self) -> Optional[builtins.str]:
        """
        The process namespace to use for the containers in the task. The valid values are `host` or `task` . For example, monitoring sidecars might need `pidMode` to access information about other containers running in the same task.

        If `host` is specified, all containers within the tasks that specified the `host` PID mode on the same container instance share the process namespace with the host Amazon EC2 instance.

        If `task` is specified, all containers within the specified task share the same process namespace.

        If no value is specified, the default is a private namespace for each container. For more information, see [PID settings](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#pid-settings---pid) in the Docker run reference.
        """
        return pulumi.get(self, "pid_mode")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[builtins.str]:
        """
        The Fargate platform version where the jobs are running. A platform version is specified only for jobs that are running on Fargate resources. If one isn't specified, the `LATEST` platform version is used by default. This uses a recent, approved version of the Fargate platform for compute resources. For more information, see [AWS Fargate platform versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter(name="runtimePlatform")
    def runtime_platform(self) -> Optional['outputs.JobDefinitionRuntimePlatform']:
        """
        An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
        """
        return pulumi.get(self, "runtime_platform")

    @property
    @pulumi.getter(name="taskRoleArn")
    def task_role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) that's associated with the Amazon ECS task.

        > This is object is comparable to [ContainerProperties:jobRoleArn](https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html) .
        """
        return pulumi.get(self, "task_role_arn")

    @property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.JobDefinitionVolume']]:
        """
        A list of volumes that are associated with the job.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class JobDefinitionEfsAuthorizationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessPointId":
            suggest = "access_point_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEfsAuthorizationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEfsAuthorizationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEfsAuthorizationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_point_id: Optional[builtins.str] = None,
                 iam: Optional[builtins.str] = None):
        """
        :param builtins.str access_point_id: The Amazon EFS access point ID to use. If an access point is specified, the root directory value specified in the `EFSVolumeConfiguration` must either be omitted or set to `/` which enforces the path set on the EFS access point. If an access point is used, transit encryption must be enabled in the `EFSVolumeConfiguration` . For more information, see [Working with Amazon EFS access points](https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html) in the *Amazon Elastic File System User Guide* .
        :param builtins.str iam: Whether or not to use the AWS Batch job IAM role defined in a job definition when mounting the Amazon EFS file system. If enabled, transit encryption must be enabled in the `EFSVolumeConfiguration` . If this parameter is omitted, the default value of `DISABLED` is used. For more information, see [Using Amazon EFS access points](https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html#efs-volume-accesspoints) in the *AWS Batch User Guide* . EFS IAM authorization requires that `TransitEncryption` be `ENABLED` and that a `JobRoleArn` is specified.
        """
        if access_point_id is not None:
            pulumi.set(__self__, "access_point_id", access_point_id)
        if iam is not None:
            pulumi.set(__self__, "iam", iam)

    @property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> Optional[builtins.str]:
        """
        The Amazon EFS access point ID to use. If an access point is specified, the root directory value specified in the `EFSVolumeConfiguration` must either be omitted or set to `/` which enforces the path set on the EFS access point. If an access point is used, transit encryption must be enabled in the `EFSVolumeConfiguration` . For more information, see [Working with Amazon EFS access points](https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html) in the *Amazon Elastic File System User Guide* .
        """
        return pulumi.get(self, "access_point_id")

    @property
    @pulumi.getter
    def iam(self) -> Optional[builtins.str]:
        """
        Whether or not to use the AWS Batch job IAM role defined in a job definition when mounting the Amazon EFS file system. If enabled, transit encryption must be enabled in the `EFSVolumeConfiguration` . If this parameter is omitted, the default value of `DISABLED` is used. For more information, see [Using Amazon EFS access points](https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html#efs-volume-accesspoints) in the *AWS Batch User Guide* . EFS IAM authorization requires that `TransitEncryption` be `ENABLED` and that a `JobRoleArn` is specified.
        """
        return pulumi.get(self, "iam")


@pulumi.output_type
class JobDefinitionEfsVolumeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystemId":
            suggest = "file_system_id"
        elif key == "authorizationConfig":
            suggest = "authorization_config"
        elif key == "rootDirectory":
            suggest = "root_directory"
        elif key == "transitEncryption":
            suggest = "transit_encryption"
        elif key == "transitEncryptionPort":
            suggest = "transit_encryption_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEfsVolumeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEfsVolumeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEfsVolumeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system_id: builtins.str,
                 authorization_config: Optional['outputs.JobDefinitionEfsAuthorizationConfig'] = None,
                 root_directory: Optional[builtins.str] = None,
                 transit_encryption: Optional[builtins.str] = None,
                 transit_encryption_port: Optional[builtins.int] = None):
        """
        :param builtins.str file_system_id: The Amazon EFS file system ID to use.
        :param 'JobDefinitionEfsAuthorizationConfig' authorization_config: The authorization configuration details for the Amazon EFS file system.
        :param builtins.str root_directory: The directory within the Amazon EFS file system to mount as the root directory inside the host. If this parameter is omitted, the root of the Amazon EFS volume is used instead. Specifying `/` has the same effect as omitting this parameter. The maximum length is 4,096 characters.
               
               > If an EFS access point is specified in the `authorizationConfig` , the root directory parameter must either be omitted or set to `/` , which enforces the path set on the Amazon EFS access point.
        :param builtins.str transit_encryption: Determines whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is used. If this parameter is omitted, the default value of `DISABLED` is used. For more information, see [Encrypting data in transit](https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html) in the *Amazon Elastic File System User Guide* .
        :param builtins.int transit_encryption_port: The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server. If you don't specify a transit encryption port, it uses the port selection strategy that the Amazon EFS mount helper uses. The value must be between 0 and 65,535. For more information, see [EFS mount helper](https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html) in the *Amazon Elastic File System User Guide* .
        """
        pulumi.set(__self__, "file_system_id", file_system_id)
        if authorization_config is not None:
            pulumi.set(__self__, "authorization_config", authorization_config)
        if root_directory is not None:
            pulumi.set(__self__, "root_directory", root_directory)
        if transit_encryption is not None:
            pulumi.set(__self__, "transit_encryption", transit_encryption)
        if transit_encryption_port is not None:
            pulumi.set(__self__, "transit_encryption_port", transit_encryption_port)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> builtins.str:
        """
        The Amazon EFS file system ID to use.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="authorizationConfig")
    def authorization_config(self) -> Optional['outputs.JobDefinitionEfsAuthorizationConfig']:
        """
        The authorization configuration details for the Amazon EFS file system.
        """
        return pulumi.get(self, "authorization_config")

    @property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> Optional[builtins.str]:
        """
        The directory within the Amazon EFS file system to mount as the root directory inside the host. If this parameter is omitted, the root of the Amazon EFS volume is used instead. Specifying `/` has the same effect as omitting this parameter. The maximum length is 4,096 characters.

        > If an EFS access point is specified in the `authorizationConfig` , the root directory parameter must either be omitted or set to `/` , which enforces the path set on the Amazon EFS access point.
        """
        return pulumi.get(self, "root_directory")

    @property
    @pulumi.getter(name="transitEncryption")
    def transit_encryption(self) -> Optional[builtins.str]:
        """
        Determines whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is used. If this parameter is omitted, the default value of `DISABLED` is used. For more information, see [Encrypting data in transit](https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html) in the *Amazon Elastic File System User Guide* .
        """
        return pulumi.get(self, "transit_encryption")

    @property
    @pulumi.getter(name="transitEncryptionPort")
    def transit_encryption_port(self) -> Optional[builtins.int]:
        """
        The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server. If you don't specify a transit encryption port, it uses the port selection strategy that the Amazon EFS mount helper uses. The value must be between 0 and 65,535. For more information, see [EFS mount helper](https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html) in the *Amazon Elastic File System User Guide* .
        """
        return pulumi.get(self, "transit_encryption_port")


@pulumi.output_type
class JobDefinitionEksContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imagePullPolicy":
            suggest = "image_pull_policy"
        elif key == "securityContext":
            suggest = "security_context"
        elif key == "volumeMounts":
            suggest = "volume_mounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEksContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEksContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEksContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: builtins.str,
                 args: Optional[Sequence[builtins.str]] = None,
                 command: Optional[Sequence[builtins.str]] = None,
                 env: Optional[Sequence['outputs.JobDefinitionEksContainerEnvironmentVariable']] = None,
                 image_pull_policy: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 resources: Optional['outputs.JobDefinitionEksContainerResourceRequirements'] = None,
                 security_context: Optional['outputs.JobDefinitionEksContainerSecurityContext'] = None,
                 volume_mounts: Optional[Sequence['outputs.JobDefinitionEksContainerVolumeMount']] = None):
        """
        :param builtins.str image: The Docker image used to start the container.
        :param Sequence[builtins.str] args: An array of arguments to the entrypoint. If this isn't specified, the `CMD` of the container image is used. This corresponds to the `args` member in the [Entrypoint](https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint) portion of the [Pod](https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/) in Kubernetes. Environment variable references are expanded using the container's environment.
               
               If the referenced environment variable doesn't exist, the reference in the command isn't changed. For example, if the reference is to " `$(NAME1)` " and the `NAME1` environment variable doesn't exist, the command string will remain " `$(NAME1)` ." `$$` is replaced with `$` , and the resulting string isn't expanded. For example, `$$(VAR_NAME)` is passed as `$(VAR_NAME)` whether or not the `VAR_NAME` environment variable exists. For more information, see [Dockerfile reference: CMD](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd) and [Define a command and arguments for a pod](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/) in the *Kubernetes documentation* .
        :param Sequence[builtins.str] command: The entrypoint for the container. This isn't run within a shell. If this isn't specified, the `ENTRYPOINT` of the container image is used. Environment variable references are expanded using the container's environment.
               
               If the referenced environment variable doesn't exist, the reference in the command isn't changed. For example, if the reference is to " `$(NAME1)` " and the `NAME1` environment variable doesn't exist, the command string will remain " `$(NAME1)` ." `$$` is replaced with `$` and the resulting string isn't expanded. For example, `$$(VAR_NAME)` will be passed as `$(VAR_NAME)` whether or not the `VAR_NAME` environment variable exists. The entrypoint can't be updated. For more information, see [ENTRYPOINT](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#entrypoint) in the *Dockerfile reference* and [Define a command and arguments for a container](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/) and [Entrypoint](https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint) in the *Kubernetes documentation* .
        :param Sequence['JobDefinitionEksContainerEnvironmentVariable'] env: The environment variables to pass to a container.
               
               > Environment variables cannot start with " `AWS_BATCH` ". This naming convention is reserved for variables that AWS Batch sets.
        :param builtins.str image_pull_policy: The image pull policy for the container. Supported values are `Always` , `IfNotPresent` , and `Never` . This parameter defaults to `IfNotPresent` . However, if the `:latest` tag is specified, it defaults to `Always` . For more information, see [Updating images](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/containers/images/#updating-images) in the *Kubernetes documentation* .
        :param builtins.str name: The name of the container. If the name isn't specified, the default name " `Default` " is used. Each container in a pod must have a unique name.
        :param 'JobDefinitionEksContainerResourceRequirements' resources: The type and amount of resources to assign to a container. The supported resources include `memory` , `cpu` , and `nvidia.com/gpu` . For more information, see [Resource management for pods and containers](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) in the *Kubernetes documentation* .
        :param 'JobDefinitionEksContainerSecurityContext' security_context: The security context for a job. For more information, see [Configure a security context for a pod or container](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/security-context/) in the *Kubernetes documentation* .
        :param Sequence['JobDefinitionEksContainerVolumeMount'] volume_mounts: The volume mounts for the container. AWS Batch supports `emptyDir` , `hostPath` , and `secret` volume types. For more information about volumes and volume mounts in Kubernetes, see [Volumes](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/) in the *Kubernetes documentation* .
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if security_context is not None:
            pulumi.set(__self__, "security_context", security_context)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @property
    @pulumi.getter
    def image(self) -> builtins.str:
        """
        The Docker image used to start the container.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[builtins.str]]:
        """
        An array of arguments to the entrypoint. If this isn't specified, the `CMD` of the container image is used. This corresponds to the `args` member in the [Entrypoint](https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint) portion of the [Pod](https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/) in Kubernetes. Environment variable references are expanded using the container's environment.

        If the referenced environment variable doesn't exist, the reference in the command isn't changed. For example, if the reference is to " `$(NAME1)` " and the `NAME1` environment variable doesn't exist, the command string will remain " `$(NAME1)` ." `$$` is replaced with `$` , and the resulting string isn't expanded. For example, `$$(VAR_NAME)` is passed as `$(VAR_NAME)` whether or not the `VAR_NAME` environment variable exists. For more information, see [Dockerfile reference: CMD](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd) and [Define a command and arguments for a pod](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def command(self) -> Optional[Sequence[builtins.str]]:
        """
        The entrypoint for the container. This isn't run within a shell. If this isn't specified, the `ENTRYPOINT` of the container image is used. Environment variable references are expanded using the container's environment.

        If the referenced environment variable doesn't exist, the reference in the command isn't changed. For example, if the reference is to " `$(NAME1)` " and the `NAME1` environment variable doesn't exist, the command string will remain " `$(NAME1)` ." `$$` is replaced with `$` and the resulting string isn't expanded. For example, `$$(VAR_NAME)` will be passed as `$(VAR_NAME)` whether or not the `VAR_NAME` environment variable exists. The entrypoint can't be updated. For more information, see [ENTRYPOINT](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#entrypoint) in the *Dockerfile reference* and [Define a command and arguments for a container](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/) and [Entrypoint](https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def env(self) -> Optional[Sequence['outputs.JobDefinitionEksContainerEnvironmentVariable']]:
        """
        The environment variables to pass to a container.

        > Environment variables cannot start with " `AWS_BATCH` ". This naming convention is reserved for variables that AWS Batch sets.
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[builtins.str]:
        """
        The image pull policy for the container. Supported values are `Always` , `IfNotPresent` , and `Never` . This parameter defaults to `IfNotPresent` . However, if the `:latest` tag is specified, it defaults to `Always` . For more information, see [Updating images](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/containers/images/#updating-images) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "image_pull_policy")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the container. If the name isn't specified, the default name " `Default` " is used. Each container in a pod must have a unique name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def resources(self) -> Optional['outputs.JobDefinitionEksContainerResourceRequirements']:
        """
        The type and amount of resources to assign to a container. The supported resources include `memory` , `cpu` , and `nvidia.com/gpu` . For more information, see [Resource management for pods and containers](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> Optional['outputs.JobDefinitionEksContainerSecurityContext']:
        """
        The security context for a job. For more information, see [Configure a security context for a pod or container](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/security-context/) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "security_context")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.JobDefinitionEksContainerVolumeMount']]:
        """
        The volume mounts for the container. AWS Batch supports `emptyDir` , `hostPath` , and `secret` volume types. For more information about volumes and volume mounts in Kubernetes, see [Volumes](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "volume_mounts")


@pulumi.output_type
class JobDefinitionEksContainerEnvironmentVariable(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of the environment variable.
        :param builtins.str value: The value of the environment variable.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class JobDefinitionEksContainerResourceRequirements(dict):
    def __init__(__self__, *,
                 limits: Optional[Mapping[str, builtins.str]] = None,
                 requests: Optional[Mapping[str, builtins.str]] = None):
        """
        :param Mapping[str, builtins.str] limits: The type and quantity of the resources to reserve for the container. The values vary based on the `name` that's specified. Resources can be requested using either the `limits` or the `requests` objects.
               
               - **memory** - The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your container attempts to exceed the memory specified, the container is terminated. You must specify at least 4 MiB of memory for a job. `memory` can be specified in `limits` , `requests` , or both. If `memory` is specified in both places, then the value that's specified in `limits` must be equal to the value that's specified in `requests` .
               
               > To maximize your resource utilization, provide your jobs with as much memory as possible for the specific instance type that you are using. To learn how, see [Memory management](https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html) in the *AWS Batch User Guide* .
               - **cpu** - The number of CPUs that's reserved for the container. Values must be an even multiple of `0.25` . `cpu` can be specified in `limits` , `requests` , or both. If `cpu` is specified in both places, then the value that's specified in `limits` must be at least as large as the value that's specified in `requests` .
               - **nvidia.com/gpu** - The number of GPUs that's reserved for the container. Values must be a whole integer. `memory` can be specified in `limits` , `requests` , or both. If `memory` is specified in both places, then the value that's specified in `limits` must be equal to the value that's specified in `requests` .
        :param Mapping[str, builtins.str] requests: The type and quantity of the resources to request for the container. The values vary based on the `name` that's specified. Resources can be requested by using either the `limits` or the `requests` objects.
               
               - **memory** - The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your container attempts to exceed the memory specified, the container is terminated. You must specify at least 4 MiB of memory for a job. `memory` can be specified in `limits` , `requests` , or both. If `memory` is specified in both, then the value that's specified in `limits` must be equal to the value that's specified in `requests` .
               
               > If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see [Memory management](https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html) in the *AWS Batch User Guide* .
               - **cpu** - The number of CPUs that are reserved for the container. Values must be an even multiple of `0.25` . `cpu` can be specified in `limits` , `requests` , or both. If `cpu` is specified in both, then the value that's specified in `limits` must be at least as large as the value that's specified in `requests` .
               - **nvidia.com/gpu** - The number of GPUs that are reserved for the container. Values must be a whole integer. `nvidia.com/gpu` can be specified in `limits` , `requests` , or both. If `nvidia.com/gpu` is specified in both, then the value that's specified in `limits` must be equal to the value that's specified in `requests` .
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The type and quantity of the resources to reserve for the container. The values vary based on the `name` that's specified. Resources can be requested using either the `limits` or the `requests` objects.

        - **memory** - The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your container attempts to exceed the memory specified, the container is terminated. You must specify at least 4 MiB of memory for a job. `memory` can be specified in `limits` , `requests` , or both. If `memory` is specified in both places, then the value that's specified in `limits` must be equal to the value that's specified in `requests` .

        > To maximize your resource utilization, provide your jobs with as much memory as possible for the specific instance type that you are using. To learn how, see [Memory management](https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html) in the *AWS Batch User Guide* .
        - **cpu** - The number of CPUs that's reserved for the container. Values must be an even multiple of `0.25` . `cpu` can be specified in `limits` , `requests` , or both. If `cpu` is specified in both places, then the value that's specified in `limits` must be at least as large as the value that's specified in `requests` .
        - **nvidia.com/gpu** - The number of GPUs that's reserved for the container. Values must be a whole integer. `memory` can be specified in `limits` , `requests` , or both. If `memory` is specified in both places, then the value that's specified in `limits` must be equal to the value that's specified in `requests` .
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The type and quantity of the resources to request for the container. The values vary based on the `name` that's specified. Resources can be requested by using either the `limits` or the `requests` objects.

        - **memory** - The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your container attempts to exceed the memory specified, the container is terminated. You must specify at least 4 MiB of memory for a job. `memory` can be specified in `limits` , `requests` , or both. If `memory` is specified in both, then the value that's specified in `limits` must be equal to the value that's specified in `requests` .

        > If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see [Memory management](https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html) in the *AWS Batch User Guide* .
        - **cpu** - The number of CPUs that are reserved for the container. Values must be an even multiple of `0.25` . `cpu` can be specified in `limits` , `requests` , or both. If `cpu` is specified in both, then the value that's specified in `limits` must be at least as large as the value that's specified in `requests` .
        - **nvidia.com/gpu** - The number of GPUs that are reserved for the container. Values must be a whole integer. `nvidia.com/gpu` can be specified in `limits` , `requests` , or both. If `nvidia.com/gpu` is specified in both, then the value that's specified in `limits` must be equal to the value that's specified in `requests` .
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class JobDefinitionEksContainerSecurityContext(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowPrivilegeEscalation":
            suggest = "allow_privilege_escalation"
        elif key == "readOnlyRootFilesystem":
            suggest = "read_only_root_filesystem"
        elif key == "runAsGroup":
            suggest = "run_as_group"
        elif key == "runAsNonRoot":
            suggest = "run_as_non_root"
        elif key == "runAsUser":
            suggest = "run_as_user"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEksContainerSecurityContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEksContainerSecurityContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEksContainerSecurityContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_privilege_escalation: Optional[builtins.bool] = None,
                 privileged: Optional[builtins.bool] = None,
                 read_only_root_filesystem: Optional[builtins.bool] = None,
                 run_as_group: Optional[builtins.int] = None,
                 run_as_non_root: Optional[builtins.bool] = None,
                 run_as_user: Optional[builtins.int] = None):
        """
        :param builtins.bool allow_privilege_escalation: Whether or not a container or a Kubernetes pod is allowed to gain more privileges than its parent process. The default value is `false` .
        :param builtins.bool privileged: When this parameter is `true` , the container is given elevated permissions on the host container instance. The level of permissions are similar to the `root` user permissions. The default value is `false` . This parameter maps to `privileged` policy in the [Privileged pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#privileged) in the *Kubernetes documentation* .
        :param builtins.bool read_only_root_filesystem: When this parameter is `true` , the container is given read-only access to its root file system. The default value is `false` . This parameter maps to `ReadOnlyRootFilesystem` policy in the [Volumes and file systems pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems) in the *Kubernetes documentation* .
        :param builtins.int run_as_group: When this parameter is specified, the container is run as the specified group ID ( `gid` ). If this parameter isn't specified, the default is the group that's specified in the image metadata. This parameter maps to `RunAsGroup` and `MustRunAs` policy in the [Users and groups pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation* .
        :param builtins.bool run_as_non_root: When this parameter is specified, the container is run as a user with a `uid` other than 0. If this parameter isn't specified, so such rule is enforced. This parameter maps to `RunAsUser` and `MustRunAsNonRoot` policy in the [Users and groups pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation* .
        :param builtins.int run_as_user: When this parameter is specified, the container is run as the specified user ID ( `uid` ). If this parameter isn't specified, the default is the user that's specified in the image metadata. This parameter maps to `RunAsUser` and `MustRanAs` policy in the [Users and groups pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation* .
        """
        if allow_privilege_escalation is not None:
            pulumi.set(__self__, "allow_privilege_escalation", allow_privilege_escalation)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if read_only_root_filesystem is not None:
            pulumi.set(__self__, "read_only_root_filesystem", read_only_root_filesystem)
        if run_as_group is not None:
            pulumi.set(__self__, "run_as_group", run_as_group)
        if run_as_non_root is not None:
            pulumi.set(__self__, "run_as_non_root", run_as_non_root)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)

    @property
    @pulumi.getter(name="allowPrivilegeEscalation")
    def allow_privilege_escalation(self) -> Optional[builtins.bool]:
        """
        Whether or not a container or a Kubernetes pod is allowed to gain more privileges than its parent process. The default value is `false` .
        """
        return pulumi.get(self, "allow_privilege_escalation")

    @property
    @pulumi.getter
    def privileged(self) -> Optional[builtins.bool]:
        """
        When this parameter is `true` , the container is given elevated permissions on the host container instance. The level of permissions are similar to the `root` user permissions. The default value is `false` . This parameter maps to `privileged` policy in the [Privileged pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#privileged) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "privileged")

    @property
    @pulumi.getter(name="readOnlyRootFilesystem")
    def read_only_root_filesystem(self) -> Optional[builtins.bool]:
        """
        When this parameter is `true` , the container is given read-only access to its root file system. The default value is `false` . This parameter maps to `ReadOnlyRootFilesystem` policy in the [Volumes and file systems pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "read_only_root_filesystem")

    @property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> Optional[builtins.int]:
        """
        When this parameter is specified, the container is run as the specified group ID ( `gid` ). If this parameter isn't specified, the default is the group that's specified in the image metadata. This parameter maps to `RunAsGroup` and `MustRunAs` policy in the [Users and groups pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "run_as_group")

    @property
    @pulumi.getter(name="runAsNonRoot")
    def run_as_non_root(self) -> Optional[builtins.bool]:
        """
        When this parameter is specified, the container is run as a user with a `uid` other than 0. If this parameter isn't specified, so such rule is enforced. This parameter maps to `RunAsUser` and `MustRunAsNonRoot` policy in the [Users and groups pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "run_as_non_root")

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[builtins.int]:
        """
        When this parameter is specified, the container is run as the specified user ID ( `uid` ). If this parameter isn't specified, the default is the user that's specified in the image metadata. This parameter maps to `RunAsUser` and `MustRanAs` policy in the [Users and groups pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "run_as_user")


@pulumi.output_type
class JobDefinitionEksContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "subPath":
            suggest = "sub_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEksContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEksContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEksContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 read_only: Optional[builtins.bool] = None,
                 sub_path: Optional[builtins.str] = None):
        """
        :param builtins.str mount_path: The path on the container where the volume is mounted.
        :param builtins.str name: The name the volume mount. This must match the name of one of the volumes in the pod.
        :param builtins.bool read_only: If this value is `true` , the container has read-only access to the volume. Otherwise, the container can write to the volume. The default value is `false` .
        :param builtins.str sub_path: A sub-path inside the referenced volume instead of its root.
        """
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if sub_path is not None:
            pulumi.set(__self__, "sub_path", sub_path)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[builtins.str]:
        """
        The path on the container where the volume is mounted.
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name the volume mount. This must match the name of one of the volumes in the pod.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[builtins.bool]:
        """
        If this value is `true` , the container has read-only access to the volume. Otherwise, the container can write to the volume. The default value is `false` .
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> Optional[builtins.str]:
        """
        A sub-path inside the referenced volume instead of its root.
        """
        return pulumi.get(self, "sub_path")


@pulumi.output_type
class JobDefinitionEksEmptyDir(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeLimit":
            suggest = "size_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEksEmptyDir. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEksEmptyDir.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEksEmptyDir.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 medium: Optional[builtins.str] = None,
                 size_limit: Optional[builtins.str] = None):
        """
        :param builtins.str medium: The medium to store the volume. The default value is an empty string, which uses the storage of the node.
               
               - **""** - *(Default)* Use the disk storage of the node.
               - **"Memory"** - Use the `tmpfs` volume that's backed by the RAM of the node. Contents of the volume are lost when the node reboots, and any storage on the volume counts against the container's memory limit.
        :param builtins.str size_limit: The maximum size of the volume. By default, there's no maximum size defined.
        """
        if medium is not None:
            pulumi.set(__self__, "medium", medium)
        if size_limit is not None:
            pulumi.set(__self__, "size_limit", size_limit)

    @property
    @pulumi.getter
    def medium(self) -> Optional[builtins.str]:
        """
        The medium to store the volume. The default value is an empty string, which uses the storage of the node.

        - **""** - *(Default)* Use the disk storage of the node.
        - **"Memory"** - Use the `tmpfs` volume that's backed by the RAM of the node. Contents of the volume are lost when the node reboots, and any storage on the volume counts against the container's memory limit.
        """
        return pulumi.get(self, "medium")

    @property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> Optional[builtins.str]:
        """
        The maximum size of the volume. By default, there's no maximum size defined.
        """
        return pulumi.get(self, "size_limit")


@pulumi.output_type
class JobDefinitionEksHostPath(dict):
    def __init__(__self__, *,
                 path: Optional[builtins.str] = None):
        """
        :param builtins.str path: The path of the file or directory on the host to mount into containers on the pod.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        The path of the file or directory on the host to mount into containers on the pod.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class JobDefinitionEksMetadata(dict):
    def __init__(__self__, *,
                 annotations: Optional[Mapping[str, builtins.str]] = None,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 namespace: Optional[builtins.str] = None):
        """
        :param Mapping[str, builtins.str] annotations: Key-value pairs used to attach arbitrary, non-identifying metadata to Kubernetes objects. Valid annotation keys have two segments: an optional prefix and a name, separated by a slash (/).
               
               - The prefix is optional and must be 253 characters or less. If specified, the prefix must be a DNS subdomain− a series of DNS labels separated by dots (.), and it must end with a slash (/).
               - The name segment is required and must be 63 characters or less. It can include alphanumeric characters ([a-z0-9A-Z]), dashes (-), underscores (_), and dots (.), but must begin and end with an alphanumeric character.
               
               > Annotation values must be 255 characters or less. 
               
               Annotations can be added or modified at any time. Each resource can have multiple annotations.
        :param Mapping[str, builtins.str] labels: Key-value pairs used to identify, sort, and organize cube resources. Can contain up to 63 uppercase letters, lowercase letters, numbers, hyphens (-), and underscores (_). Labels can be added or modified at any time. Each resource can have multiple labels, but each key must be unique for a given object.
        :param builtins.str namespace: The namespace of the Amazon EKS cluster. In Kubernetes, namespaces provide a mechanism for isolating groups of resources within a single cluster. Names of resources need to be unique within a namespace, but not across namespaces. AWS Batch places Batch Job pods in this namespace. If this field is provided, the value can't be empty or null. It must meet the following requirements:
               
               - 1-63 characters long
               - Can't be set to default
               - Can't start with `kube`
               - Must match the following regular expression: `^[a-z0-9]([-a-z0-9]*[a-z0-9])?$`
               
               For more information, see [Namespaces](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/) in the *Kubernetes documentation* . This namespace can be different from the `kubernetesNamespace` set in the compute environment's `EksConfiguration` , but must have identical role-based access control (RBAC) roles as the compute environment's `kubernetesNamespace` . For multi-node parallel jobs, the same value must be provided across all the node ranges.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Key-value pairs used to attach arbitrary, non-identifying metadata to Kubernetes objects. Valid annotation keys have two segments: an optional prefix and a name, separated by a slash (/).

        - The prefix is optional and must be 253 characters or less. If specified, the prefix must be a DNS subdomain− a series of DNS labels separated by dots (.), and it must end with a slash (/).
        - The name segment is required and must be 63 characters or less. It can include alphanumeric characters ([a-z0-9A-Z]), dashes (-), underscores (_), and dots (.), but must begin and end with an alphanumeric character.

        > Annotation values must be 255 characters or less. 

        Annotations can be added or modified at any time. Each resource can have multiple annotations.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Key-value pairs used to identify, sort, and organize cube resources. Can contain up to 63 uppercase letters, lowercase letters, numbers, hyphens (-), and underscores (_). Labels can be added or modified at any time. Each resource can have multiple labels, but each key must be unique for a given object.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        The namespace of the Amazon EKS cluster. In Kubernetes, namespaces provide a mechanism for isolating groups of resources within a single cluster. Names of resources need to be unique within a namespace, but not across namespaces. AWS Batch places Batch Job pods in this namespace. If this field is provided, the value can't be empty or null. It must meet the following requirements:

        - 1-63 characters long
        - Can't be set to default
        - Can't start with `kube`
        - Must match the following regular expression: `^[a-z0-9]([-a-z0-9]*[a-z0-9])?$`

        For more information, see [Namespaces](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/) in the *Kubernetes documentation* . This namespace can be different from the `kubernetesNamespace` set in the compute environment's `EksConfiguration` , but must have identical role-based access control (RBAC) roles as the compute environment's `kubernetesNamespace` . For multi-node parallel jobs, the same value must be provided across all the node ranges.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class JobDefinitionEksPersistentVolumeClaim(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "claimName":
            suggest = "claim_name"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEksPersistentVolumeClaim. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEksPersistentVolumeClaim.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEksPersistentVolumeClaim.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 claim_name: builtins.str,
                 read_only: Optional[builtins.bool] = None):
        """
        :param builtins.str claim_name: The name of the `persistentVolumeClaim` bounded to a `persistentVolume` . For more information, see [Persistent Volume Claims](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims) in the *Kubernetes documentation* .
        :param builtins.bool read_only: An optional boolean value indicating if the mount is read only. Default is false. For more information, see [Read Only Mounts](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#read-only-mounts) in the *Kubernetes documentation* .
        """
        pulumi.set(__self__, "claim_name", claim_name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="claimName")
    def claim_name(self) -> builtins.str:
        """
        The name of the `persistentVolumeClaim` bounded to a `persistentVolume` . For more information, see [Persistent Volume Claims](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "claim_name")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[builtins.bool]:
        """
        An optional boolean value indicating if the mount is read only. Default is false. For more information, see [Read Only Mounts](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#read-only-mounts) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class JobDefinitionEksPodProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsPolicy":
            suggest = "dns_policy"
        elif key == "hostNetwork":
            suggest = "host_network"
        elif key == "imagePullSecrets":
            suggest = "image_pull_secrets"
        elif key == "initContainers":
            suggest = "init_containers"
        elif key == "serviceAccountName":
            suggest = "service_account_name"
        elif key == "shareProcessNamespace":
            suggest = "share_process_namespace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEksPodProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEksPodProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEksPodProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 containers: Optional[Sequence['outputs.JobDefinitionEksContainer']] = None,
                 dns_policy: Optional[builtins.str] = None,
                 host_network: Optional[builtins.bool] = None,
                 image_pull_secrets: Optional[Sequence['outputs.JobDefinitionImagePullSecret']] = None,
                 init_containers: Optional[Sequence['outputs.JobDefinitionEksContainer']] = None,
                 metadata: Optional['outputs.JobDefinitionEksMetadata'] = None,
                 service_account_name: Optional[builtins.str] = None,
                 share_process_namespace: Optional[builtins.bool] = None,
                 volumes: Optional[Sequence['outputs.JobDefinitionEksVolume']] = None):
        """
        :param Sequence['JobDefinitionEksContainer'] containers: The properties of the container that's used on the Amazon EKS pod.
               
               > This object is limited to 10 elements.
        :param builtins.str dns_policy: The DNS policy for the pod. The default value is `ClusterFirst` . If the `hostNetwork` parameter is not specified, the default is `ClusterFirstWithHostNet` . `ClusterFirst` indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node. For more information, see [Pod's DNS policy](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy) in the *Kubernetes documentation* .
               
               Valid values: `Default` | `ClusterFirst` | `ClusterFirstWithHostNet`
        :param builtins.bool host_network: Indicates if the pod uses the hosts' network IP address. The default value is `true` . Setting this to `false` enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections. For more information, see [Host namespaces](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces) and [Pod networking](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking) in the *Kubernetes documentation* .
        :param Sequence['JobDefinitionImagePullSecret'] image_pull_secrets: References a Kubernetes secret resource. It holds a list of secrets. These secrets help to gain access to pull an images from a private registry.
               
               `ImagePullSecret$name` is required when this object is used.
        :param Sequence['JobDefinitionEksContainer'] init_containers: These containers run before application containers, always runs to completion, and must complete successfully before the next container starts. These containers are registered with the Amazon EKS Connector agent and persists the registration information in the Kubernetes backend data store. For more information, see [Init Containers](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/workloads/pods/init-containers/) in the *Kubernetes documentation* .
               
               > This object is limited to 10 elements.
        :param 'JobDefinitionEksMetadata' metadata: Metadata about the Kubernetes pod. For more information, see [Understanding Kubernetes Objects](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/kubernetes-objects/) in the *Kubernetes documentation* .
        :param builtins.str service_account_name: The name of the service account that's used to run the pod. For more information, see [Kubernetes service accounts](https://docs.aws.amazon.com/eks/latest/userguide/service-accounts.html) and [Configure a Kubernetes service account to assume an IAM role](https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html) in the *Amazon EKS User Guide* and [Configure service accounts for pods](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/) in the *Kubernetes documentation* .
        :param builtins.bool share_process_namespace: Indicates if the processes in a container are shared, or visible, to other containers in the same pod. For more information, see [Share Process Namespace between Containers in a Pod](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/share-process-namespace/) .
        :param Sequence['JobDefinitionEksVolume'] volumes: Specifies the volumes for a job definition that uses Amazon EKS resources.
        """
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if dns_policy is not None:
            pulumi.set(__self__, "dns_policy", dns_policy)
        if host_network is not None:
            pulumi.set(__self__, "host_network", host_network)
        if image_pull_secrets is not None:
            pulumi.set(__self__, "image_pull_secrets", image_pull_secrets)
        if init_containers is not None:
            pulumi.set(__self__, "init_containers", init_containers)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if service_account_name is not None:
            pulumi.set(__self__, "service_account_name", service_account_name)
        if share_process_namespace is not None:
            pulumi.set(__self__, "share_process_namespace", share_process_namespace)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def containers(self) -> Optional[Sequence['outputs.JobDefinitionEksContainer']]:
        """
        The properties of the container that's used on the Amazon EKS pod.

        > This object is limited to 10 elements.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="dnsPolicy")
    def dns_policy(self) -> Optional[builtins.str]:
        """
        The DNS policy for the pod. The default value is `ClusterFirst` . If the `hostNetwork` parameter is not specified, the default is `ClusterFirstWithHostNet` . `ClusterFirst` indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node. For more information, see [Pod's DNS policy](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy) in the *Kubernetes documentation* .

        Valid values: `Default` | `ClusterFirst` | `ClusterFirstWithHostNet`
        """
        return pulumi.get(self, "dns_policy")

    @property
    @pulumi.getter(name="hostNetwork")
    def host_network(self) -> Optional[builtins.bool]:
        """
        Indicates if the pod uses the hosts' network IP address. The default value is `true` . Setting this to `false` enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections. For more information, see [Host namespaces](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces) and [Pod networking](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "host_network")

    @property
    @pulumi.getter(name="imagePullSecrets")
    def image_pull_secrets(self) -> Optional[Sequence['outputs.JobDefinitionImagePullSecret']]:
        """
        References a Kubernetes secret resource. It holds a list of secrets. These secrets help to gain access to pull an images from a private registry.

        `ImagePullSecret$name` is required when this object is used.
        """
        return pulumi.get(self, "image_pull_secrets")

    @property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Optional[Sequence['outputs.JobDefinitionEksContainer']]:
        """
        These containers run before application containers, always runs to completion, and must complete successfully before the next container starts. These containers are registered with the Amazon EKS Connector agent and persists the registration information in the Kubernetes backend data store. For more information, see [Init Containers](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/workloads/pods/init-containers/) in the *Kubernetes documentation* .

        > This object is limited to 10 elements.
        """
        return pulumi.get(self, "init_containers")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['outputs.JobDefinitionEksMetadata']:
        """
        Metadata about the Kubernetes pod. For more information, see [Understanding Kubernetes Objects](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/kubernetes-objects/) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> Optional[builtins.str]:
        """
        The name of the service account that's used to run the pod. For more information, see [Kubernetes service accounts](https://docs.aws.amazon.com/eks/latest/userguide/service-accounts.html) and [Configure a Kubernetes service account to assume an IAM role](https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html) in the *Amazon EKS User Guide* and [Configure service accounts for pods](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "service_account_name")

    @property
    @pulumi.getter(name="shareProcessNamespace")
    def share_process_namespace(self) -> Optional[builtins.bool]:
        """
        Indicates if the processes in a container are shared, or visible, to other containers in the same pod. For more information, see [Share Process Namespace between Containers in a Pod](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/share-process-namespace/) .
        """
        return pulumi.get(self, "share_process_namespace")

    @property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.JobDefinitionEksVolume']]:
        """
        Specifies the volumes for a job definition that uses Amazon EKS resources.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class JobDefinitionEksProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "podProperties":
            suggest = "pod_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEksProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEksProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEksProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pod_properties: Optional['outputs.JobDefinitionEksPodProperties'] = None):
        """
        :param 'JobDefinitionEksPodProperties' pod_properties: The properties for the Kubernetes pod resources of a job.
        """
        if pod_properties is not None:
            pulumi.set(__self__, "pod_properties", pod_properties)

    @property
    @pulumi.getter(name="podProperties")
    def pod_properties(self) -> Optional['outputs.JobDefinitionEksPodProperties']:
        """
        The properties for the Kubernetes pod resources of a job.
        """
        return pulumi.get(self, "pod_properties")


@pulumi.output_type
class JobDefinitionEksSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretName":
            suggest = "secret_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEksSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEksSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEksSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_name: builtins.str,
                 optional: Optional[builtins.bool] = None):
        """
        :param builtins.str secret_name: The name of the secret. The name must be allowed as a DNS subdomain name. For more information, see [DNS subdomain names](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names) in the *Kubernetes documentation* .
        :param builtins.bool optional: Specifies whether the secret or the secret's keys must be defined.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> builtins.str:
        """
        The name of the secret. The name must be allowed as a DNS subdomain name. For more information, see [DNS subdomain names](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "secret_name")

    @property
    @pulumi.getter
    def optional(self) -> Optional[builtins.bool]:
        """
        Specifies whether the secret or the secret's keys must be defined.
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class JobDefinitionEksVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emptyDir":
            suggest = "empty_dir"
        elif key == "hostPath":
            suggest = "host_path"
        elif key == "persistentVolumeClaim":
            suggest = "persistent_volume_claim"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEksVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEksVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEksVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 empty_dir: Optional['outputs.JobDefinitionEksEmptyDir'] = None,
                 host_path: Optional['outputs.JobDefinitionEksHostPath'] = None,
                 persistent_volume_claim: Optional['outputs.JobDefinitionEksPersistentVolumeClaim'] = None,
                 secret: Optional['outputs.JobDefinitionEksSecret'] = None):
        """
        :param builtins.str name: The name of the volume. The name must be allowed as a DNS subdomain name. For more information, see [DNS subdomain names](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names) in the *Kubernetes documentation* .
        :param 'JobDefinitionEksEmptyDir' empty_dir: Specifies the configuration of a Kubernetes `emptyDir` volume. For more information, see [emptyDir](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#emptydir) in the *Kubernetes documentation* .
        :param 'JobDefinitionEksHostPath' host_path: Specifies the configuration of a Kubernetes `hostPath` volume. For more information, see [hostPath](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#hostpath) in the *Kubernetes documentation* .
        :param 'JobDefinitionEksPersistentVolumeClaim' persistent_volume_claim: Specifies the configuration of a Kubernetes `persistentVolumeClaim` bounded to a `persistentVolume` . For more information, see [Persistent Volume Claims](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims) in the *Kubernetes documentation* .
        :param 'JobDefinitionEksSecret' secret: Specifies the configuration of a Kubernetes `secret` volume. For more information, see [secret](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#secret) in the *Kubernetes documentation* .
        """
        pulumi.set(__self__, "name", name)
        if empty_dir is not None:
            pulumi.set(__self__, "empty_dir", empty_dir)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)
        if persistent_volume_claim is not None:
            pulumi.set(__self__, "persistent_volume_claim", persistent_volume_claim)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the volume. The name must be allowed as a DNS subdomain name. For more information, see [DNS subdomain names](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="emptyDir")
    def empty_dir(self) -> Optional['outputs.JobDefinitionEksEmptyDir']:
        """
        Specifies the configuration of a Kubernetes `emptyDir` volume. For more information, see [emptyDir](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#emptydir) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "empty_dir")

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional['outputs.JobDefinitionEksHostPath']:
        """
        Specifies the configuration of a Kubernetes `hostPath` volume. For more information, see [hostPath](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#hostpath) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "host_path")

    @property
    @pulumi.getter(name="persistentVolumeClaim")
    def persistent_volume_claim(self) -> Optional['outputs.JobDefinitionEksPersistentVolumeClaim']:
        """
        Specifies the configuration of a Kubernetes `persistentVolumeClaim` bounded to a `persistentVolume` . For more information, see [Persistent Volume Claims](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "persistent_volume_claim")

    @property
    @pulumi.getter
    def secret(self) -> Optional['outputs.JobDefinitionEksSecret']:
        """
        Specifies the configuration of a Kubernetes `secret` volume. For more information, see [secret](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#secret) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class JobDefinitionEnvironment(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of the environment variable.
        :param builtins.str value: The value of the environment variable.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class JobDefinitionEphemeralStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeInGiB":
            suggest = "size_in_gi_b"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEphemeralStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEphemeralStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEphemeralStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size_in_gi_b: builtins.int):
        """
        :param builtins.int size_in_gi_b: The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is `21` GiB and the maximum supported value is `200` GiB.
        """
        pulumi.set(__self__, "size_in_gi_b", size_in_gi_b)

    @property
    @pulumi.getter(name="sizeInGiB")
    def size_in_gi_b(self) -> builtins.int:
        """
        The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is `21` GiB and the maximum supported value is `200` GiB.
        """
        return pulumi.get(self, "size_in_gi_b")


@pulumi.output_type
class JobDefinitionEvaluateOnExit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onExitCode":
            suggest = "on_exit_code"
        elif key == "onReason":
            suggest = "on_reason"
        elif key == "onStatusReason":
            suggest = "on_status_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEvaluateOnExit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEvaluateOnExit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEvaluateOnExit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: builtins.str,
                 on_exit_code: Optional[builtins.str] = None,
                 on_reason: Optional[builtins.str] = None,
                 on_status_reason: Optional[builtins.str] = None):
        """
        :param builtins.str action: Specifies the action to take if all of the specified conditions ( `onStatusReason` , `onReason` , and `onExitCode` ) are met. The values aren't case sensitive.
        :param builtins.str on_exit_code: Contains a glob pattern to match against the decimal representation of the `ExitCode` returned for a job. The pattern can be up to 512 characters long. It can contain only numbers, and can end with an asterisk (*) so that only the start of the string needs to be an exact match.
               
               The string can contain up to 512 characters.
        :param builtins.str on_reason: Contains a glob pattern to match against the `Reason` returned for a job. The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white space (including spaces and tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
        :param builtins.str on_status_reason: Contains a glob pattern to match against the `StatusReason` returned for a job. The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white spaces (including spaces or tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
        """
        pulumi.set(__self__, "action", action)
        if on_exit_code is not None:
            pulumi.set(__self__, "on_exit_code", on_exit_code)
        if on_reason is not None:
            pulumi.set(__self__, "on_reason", on_reason)
        if on_status_reason is not None:
            pulumi.set(__self__, "on_status_reason", on_status_reason)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        Specifies the action to take if all of the specified conditions ( `onStatusReason` , `onReason` , and `onExitCode` ) are met. The values aren't case sensitive.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="onExitCode")
    def on_exit_code(self) -> Optional[builtins.str]:
        """
        Contains a glob pattern to match against the decimal representation of the `ExitCode` returned for a job. The pattern can be up to 512 characters long. It can contain only numbers, and can end with an asterisk (*) so that only the start of the string needs to be an exact match.

        The string can contain up to 512 characters.
        """
        return pulumi.get(self, "on_exit_code")

    @property
    @pulumi.getter(name="onReason")
    def on_reason(self) -> Optional[builtins.str]:
        """
        Contains a glob pattern to match against the `Reason` returned for a job. The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white space (including spaces and tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
        """
        return pulumi.get(self, "on_reason")

    @property
    @pulumi.getter(name="onStatusReason")
    def on_status_reason(self) -> Optional[builtins.str]:
        """
        Contains a glob pattern to match against the `StatusReason` returned for a job. The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white spaces (including spaces or tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
        """
        return pulumi.get(self, "on_status_reason")


@pulumi.output_type
class JobDefinitionHost(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourcePath":
            suggest = "source_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionHost. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionHost.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionHost.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_path: Optional[builtins.str] = None):
        """
        :param builtins.str source_path: The path on the host container instance that's presented to the container. If this parameter is empty, then the Docker daemon has assigned a host path for you. If this parameter contains a file location, then the data volume persists at the specified location on the host container instance until you delete it manually. If the source path location doesn't exist on the host container instance, the Docker daemon creates it. If the location does exist, the contents of the source path folder are exported.
               
               > This parameter isn't applicable to jobs that run on Fargate resources. Don't provide this for these jobs.
        """
        if source_path is not None:
            pulumi.set(__self__, "source_path", source_path)

    @property
    @pulumi.getter(name="sourcePath")
    def source_path(self) -> Optional[builtins.str]:
        """
        The path on the host container instance that's presented to the container. If this parameter is empty, then the Docker daemon has assigned a host path for you. If this parameter contains a file location, then the data volume persists at the specified location on the host container instance until you delete it manually. If the source path location doesn't exist on the host container instance, the Docker daemon creates it. If the location does exist, the contents of the source path folder are exported.

        > This parameter isn't applicable to jobs that run on Fargate resources. Don't provide this for these jobs.
        """
        return pulumi.get(self, "source_path")


@pulumi.output_type
class JobDefinitionImagePullSecret(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str name: Provides a unique identifier for the `ImagePullSecret` . This object is required when `EksPodProperties$imagePullSecrets` is used.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Provides a unique identifier for the `ImagePullSecret` . This object is required when `EksPodProperties$imagePullSecrets` is used.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class JobDefinitionJobTimeout(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attemptDurationSeconds":
            suggest = "attempt_duration_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionJobTimeout. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionJobTimeout.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionJobTimeout.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attempt_duration_seconds: Optional[builtins.int] = None):
        """
        :param builtins.int attempt_duration_seconds: The job timeout time (in seconds) that's measured from the job attempt's `startedAt` timestamp. After this time passes, AWS Batch terminates your jobs if they aren't finished. The minimum value for the timeout is 60 seconds.
               
               For array jobs, the timeout applies to the child jobs, not to the parent array job.
               
               For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not to the individual nodes.
        """
        if attempt_duration_seconds is not None:
            pulumi.set(__self__, "attempt_duration_seconds", attempt_duration_seconds)

    @property
    @pulumi.getter(name="attemptDurationSeconds")
    def attempt_duration_seconds(self) -> Optional[builtins.int]:
        """
        The job timeout time (in seconds) that's measured from the job attempt's `startedAt` timestamp. After this time passes, AWS Batch terminates your jobs if they aren't finished. The minimum value for the timeout is 60 seconds.

        For array jobs, the timeout applies to the child jobs, not to the parent array job.

        For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not to the individual nodes.
        """
        return pulumi.get(self, "attempt_duration_seconds")


@pulumi.output_type
class JobDefinitionLinuxParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "initProcessEnabled":
            suggest = "init_process_enabled"
        elif key == "maxSwap":
            suggest = "max_swap"
        elif key == "sharedMemorySize":
            suggest = "shared_memory_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionLinuxParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionLinuxParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionLinuxParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 devices: Optional[Sequence['outputs.JobDefinitionDevice']] = None,
                 init_process_enabled: Optional[builtins.bool] = None,
                 max_swap: Optional[builtins.int] = None,
                 shared_memory_size: Optional[builtins.int] = None,
                 swappiness: Optional[builtins.int] = None,
                 tmpfs: Optional[Sequence['outputs.JobDefinitionTmpfs']] = None):
        """
        :param Sequence['JobDefinitionDevice'] devices: Any of the host devices to expose to the container. This parameter maps to `Devices` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--device` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
        :param builtins.bool init_process_enabled: If true, run an `init` process inside the container that forwards signals and reaps processes. This parameter maps to the `--init` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
        :param builtins.int max_swap: The total amount of swap memory (in MiB) a container can use. This parameter is translated to the `--memory-swap` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) where the value is the sum of the container memory plus the `maxSwap` value. For more information, see [`--memory-swap` details](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/resource_constraints/#--memory-swap-details) in the Docker documentation.
               
               If a `maxSwap` value of `0` is specified, the container doesn't use swap. Accepted values are `0` or any positive integer. If the `maxSwap` parameter is omitted, the container doesn't use the swap configuration for the container instance on which it runs. A `maxSwap` value must be set for the `swappiness` parameter to be used.
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
        :param builtins.int shared_memory_size: The value for the size (in MiB) of the `/dev/shm` volume. This parameter maps to the `--shm-size` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
        :param builtins.int swappiness: You can use this parameter to tune a container's memory swappiness behavior. A `swappiness` value of `0` causes swapping to not occur unless absolutely necessary. A `swappiness` value of `100` causes pages to be swapped aggressively. Valid values are whole numbers between `0` and `100` . If the `swappiness` parameter isn't specified, a default value of `60` is used. If a value isn't specified for `maxSwap` , then this parameter is ignored. If `maxSwap` is set to 0, the container doesn't use swap. This parameter maps to the `--memory-swappiness` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               Consider the following when you use a per-container swap configuration.
               
               - Swap space must be enabled and allocated on the container instance for the containers to use.
               
               > By default, the Amazon ECS optimized AMIs don't have swap enabled. You must enable swap on the instance to use this feature. For more information, see [Instance store swap volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-store-swap-volumes.html) in the *Amazon EC2 User Guide for Linux Instances* or [How do I allocate memory to work as swap space in an Amazon EC2 instance by using a swap file?](https://docs.aws.amazon.com/premiumsupport/knowledge-center/ec2-memory-swap-file/)
               - The swap space parameters are only supported for job definitions using EC2 resources.
               - If the `maxSwap` and `swappiness` parameters are omitted from a job definition, each container has a default `swappiness` value of 60. Moreover, the total swap usage is limited to two times the memory reservation of the container.
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
        :param Sequence['JobDefinitionTmpfs'] tmpfs: The container path, mount options, and size (in MiB) of the `tmpfs` mount. This parameter maps to the `--tmpfs` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide this parameter for this resource type.
        """
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if init_process_enabled is not None:
            pulumi.set(__self__, "init_process_enabled", init_process_enabled)
        if max_swap is not None:
            pulumi.set(__self__, "max_swap", max_swap)
        if shared_memory_size is not None:
            pulumi.set(__self__, "shared_memory_size", shared_memory_size)
        if swappiness is not None:
            pulumi.set(__self__, "swappiness", swappiness)
        if tmpfs is not None:
            pulumi.set(__self__, "tmpfs", tmpfs)

    @property
    @pulumi.getter
    def devices(self) -> Optional[Sequence['outputs.JobDefinitionDevice']]:
        """
        Any of the host devices to expose to the container. This parameter maps to `Devices` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--device` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter(name="initProcessEnabled")
    def init_process_enabled(self) -> Optional[builtins.bool]:
        """
        If true, run an `init` process inside the container that forwards signals and reaps processes. This parameter maps to the `--init` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
        """
        return pulumi.get(self, "init_process_enabled")

    @property
    @pulumi.getter(name="maxSwap")
    def max_swap(self) -> Optional[builtins.int]:
        """
        The total amount of swap memory (in MiB) a container can use. This parameter is translated to the `--memory-swap` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) where the value is the sum of the container memory plus the `maxSwap` value. For more information, see [`--memory-swap` details](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/resource_constraints/#--memory-swap-details) in the Docker documentation.

        If a `maxSwap` value of `0` is specified, the container doesn't use swap. Accepted values are `0` or any positive integer. If the `maxSwap` parameter is omitted, the container doesn't use the swap configuration for the container instance on which it runs. A `maxSwap` value must be set for the `swappiness` parameter to be used.

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
        """
        return pulumi.get(self, "max_swap")

    @property
    @pulumi.getter(name="sharedMemorySize")
    def shared_memory_size(self) -> Optional[builtins.int]:
        """
        The value for the size (in MiB) of the `/dev/shm` volume. This parameter maps to the `--shm-size` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
        """
        return pulumi.get(self, "shared_memory_size")

    @property
    @pulumi.getter
    def swappiness(self) -> Optional[builtins.int]:
        """
        You can use this parameter to tune a container's memory swappiness behavior. A `swappiness` value of `0` causes swapping to not occur unless absolutely necessary. A `swappiness` value of `100` causes pages to be swapped aggressively. Valid values are whole numbers between `0` and `100` . If the `swappiness` parameter isn't specified, a default value of `60` is used. If a value isn't specified for `maxSwap` , then this parameter is ignored. If `maxSwap` is set to 0, the container doesn't use swap. This parameter maps to the `--memory-swappiness` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        Consider the following when you use a per-container swap configuration.

        - Swap space must be enabled and allocated on the container instance for the containers to use.

        > By default, the Amazon ECS optimized AMIs don't have swap enabled. You must enable swap on the instance to use this feature. For more information, see [Instance store swap volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-store-swap-volumes.html) in the *Amazon EC2 User Guide for Linux Instances* or [How do I allocate memory to work as swap space in an Amazon EC2 instance by using a swap file?](https://docs.aws.amazon.com/premiumsupport/knowledge-center/ec2-memory-swap-file/)
        - The swap space parameters are only supported for job definitions using EC2 resources.
        - If the `maxSwap` and `swappiness` parameters are omitted from a job definition, each container has a default `swappiness` value of 60. Moreover, the total swap usage is limited to two times the memory reservation of the container.

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
        """
        return pulumi.get(self, "swappiness")

    @property
    @pulumi.getter
    def tmpfs(self) -> Optional[Sequence['outputs.JobDefinitionTmpfs']]:
        """
        The container path, mount options, and size (in MiB) of the `tmpfs` mount. This parameter maps to the `--tmpfs` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide this parameter for this resource type.
        """
        return pulumi.get(self, "tmpfs")


@pulumi.output_type
class JobDefinitionLogConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logDriver":
            suggest = "log_driver"
        elif key == "secretOptions":
            suggest = "secret_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionLogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionLogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionLogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_driver: builtins.str,
                 options: Optional[Mapping[str, builtins.str]] = None,
                 secret_options: Optional[Sequence['outputs.JobDefinitionSecret']] = None):
        """
        :param builtins.str log_driver: The log driver to use for the container. The valid values that are listed for this parameter are log drivers that the Amazon ECS container agent can communicate with by default.
               
               The supported log drivers are `awslogs` , `fluentd` , `gelf` , `json-file` , `journald` , `logentries` , `syslog` , and `splunk` .
               
               > Jobs that are running on Fargate resources are restricted to the `awslogs` and `splunk` log drivers. 
               
               - **awsfirelens** - Specifies the firelens logging driver. For more information on configuring Firelens, see [Send Amazon ECS logs to an AWS service or AWS Partner](https://docs.aws.amazon.com//AmazonECS/latest/developerguide/using_firelens.html) in the *Amazon Elastic Container Service Developer Guide* .
               - **awslogs** - Specifies the Amazon CloudWatch Logs logging driver. For more information, see [Using the awslogs log driver](https://docs.aws.amazon.com/batch/latest/userguide/using_awslogs.html) in the *AWS Batch User Guide* and [Amazon CloudWatch Logs logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/awslogs/) in the Docker documentation.
               - **fluentd** - Specifies the Fluentd logging driver. For more information including usage and options, see [Fluentd logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/fluentd/) in the *Docker documentation* .
               - **gelf** - Specifies the Graylog Extended Format (GELF) logging driver. For more information including usage and options, see [Graylog Extended Format logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/gelf/) in the *Docker documentation* .
               - **journald** - Specifies the journald logging driver. For more information including usage and options, see [Journald logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/journald/) in the *Docker documentation* .
               - **json-file** - Specifies the JSON file logging driver. For more information including usage and options, see [JSON File logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/json-file/) in the *Docker documentation* .
               - **splunk** - Specifies the Splunk logging driver. For more information including usage and options, see [Splunk logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/splunk/) in the *Docker documentation* .
               - **syslog** - Specifies the syslog logging driver. For more information including usage and options, see [Syslog logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/syslog/) in the *Docker documentation* .
               
               > If you have a custom driver that's not listed earlier that you want to work with the Amazon ECS container agent, you can fork the Amazon ECS container agent project that's [available on GitHub](https://docs.aws.amazon.com/https://github.com/aws/amazon-ecs-agent) and customize it to work with that driver. We encourage you to submit pull requests for changes that you want to have included. However, Amazon Web Services doesn't currently support running modified copies of this software. 
               
               This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
        :param Mapping[str, builtins.str] options: The configuration options to send to the log driver. This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
        :param Sequence['JobDefinitionSecret'] secret_options: The secrets to pass to the log configuration. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html) in the *AWS Batch User Guide* .
        """
        pulumi.set(__self__, "log_driver", log_driver)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if secret_options is not None:
            pulumi.set(__self__, "secret_options", secret_options)

    @property
    @pulumi.getter(name="logDriver")
    def log_driver(self) -> builtins.str:
        """
        The log driver to use for the container. The valid values that are listed for this parameter are log drivers that the Amazon ECS container agent can communicate with by default.

        The supported log drivers are `awslogs` , `fluentd` , `gelf` , `json-file` , `journald` , `logentries` , `syslog` , and `splunk` .

        > Jobs that are running on Fargate resources are restricted to the `awslogs` and `splunk` log drivers. 

        - **awsfirelens** - Specifies the firelens logging driver. For more information on configuring Firelens, see [Send Amazon ECS logs to an AWS service or AWS Partner](https://docs.aws.amazon.com//AmazonECS/latest/developerguide/using_firelens.html) in the *Amazon Elastic Container Service Developer Guide* .
        - **awslogs** - Specifies the Amazon CloudWatch Logs logging driver. For more information, see [Using the awslogs log driver](https://docs.aws.amazon.com/batch/latest/userguide/using_awslogs.html) in the *AWS Batch User Guide* and [Amazon CloudWatch Logs logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/awslogs/) in the Docker documentation.
        - **fluentd** - Specifies the Fluentd logging driver. For more information including usage and options, see [Fluentd logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/fluentd/) in the *Docker documentation* .
        - **gelf** - Specifies the Graylog Extended Format (GELF) logging driver. For more information including usage and options, see [Graylog Extended Format logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/gelf/) in the *Docker documentation* .
        - **journald** - Specifies the journald logging driver. For more information including usage and options, see [Journald logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/journald/) in the *Docker documentation* .
        - **json-file** - Specifies the JSON file logging driver. For more information including usage and options, see [JSON File logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/json-file/) in the *Docker documentation* .
        - **splunk** - Specifies the Splunk logging driver. For more information including usage and options, see [Splunk logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/splunk/) in the *Docker documentation* .
        - **syslog** - Specifies the syslog logging driver. For more information including usage and options, see [Syslog logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/syslog/) in the *Docker documentation* .

        > If you have a custom driver that's not listed earlier that you want to work with the Amazon ECS container agent, you can fork the Amazon ECS container agent project that's [available on GitHub](https://docs.aws.amazon.com/https://github.com/aws/amazon-ecs-agent) and customize it to work with that driver. We encourage you to submit pull requests for changes that you want to have included. However, Amazon Web Services doesn't currently support running modified copies of this software. 

        This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
        """
        return pulumi.get(self, "log_driver")

    @property
    @pulumi.getter
    def options(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The configuration options to send to the log driver. This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="secretOptions")
    def secret_options(self) -> Optional[Sequence['outputs.JobDefinitionSecret']]:
        """
        The secrets to pass to the log configuration. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "secret_options")


@pulumi.output_type
class JobDefinitionMountPoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPath":
            suggest = "container_path"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "sourceVolume":
            suggest = "source_volume"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionMountPoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionMountPoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionMountPoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_path: Optional[builtins.str] = None,
                 read_only: Optional[builtins.bool] = None,
                 source_volume: Optional[builtins.str] = None):
        """
        :param builtins.str container_path: The path on the container where the host volume is mounted.
        :param builtins.bool read_only: If this value is `true` , the container has read-only access to the volume. Otherwise, the container can write to the volume. The default value is `false` .
        :param builtins.str source_volume: The name of the volume to mount.
        """
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if source_volume is not None:
            pulumi.set(__self__, "source_volume", source_volume)

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[builtins.str]:
        """
        The path on the container where the host volume is mounted.
        """
        return pulumi.get(self, "container_path")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[builtins.bool]:
        """
        If this value is `true` , the container has read-only access to the volume. Otherwise, the container can write to the volume. The default value is `false` .
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="sourceVolume")
    def source_volume(self) -> Optional[builtins.str]:
        """
        The name of the volume to mount.
        """
        return pulumi.get(self, "source_volume")


@pulumi.output_type
class JobDefinitionMultiNodeContainerProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableExecuteCommand":
            suggest = "enable_execute_command"
        elif key == "ephemeralStorage":
            suggest = "ephemeral_storage"
        elif key == "executionRoleArn":
            suggest = "execution_role_arn"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "jobRoleArn":
            suggest = "job_role_arn"
        elif key == "linuxParameters":
            suggest = "linux_parameters"
        elif key == "logConfiguration":
            suggest = "log_configuration"
        elif key == "mountPoints":
            suggest = "mount_points"
        elif key == "readonlyRootFilesystem":
            suggest = "readonly_root_filesystem"
        elif key == "repositoryCredentials":
            suggest = "repository_credentials"
        elif key == "resourceRequirements":
            suggest = "resource_requirements"
        elif key == "runtimePlatform":
            suggest = "runtime_platform"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionMultiNodeContainerProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionMultiNodeContainerProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionMultiNodeContainerProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: builtins.str,
                 command: Optional[Sequence[builtins.str]] = None,
                 enable_execute_command: Optional[builtins.bool] = None,
                 environment: Optional[Sequence['outputs.JobDefinitionEnvironment']] = None,
                 ephemeral_storage: Optional['outputs.JobDefinitionEphemeralStorage'] = None,
                 execution_role_arn: Optional[builtins.str] = None,
                 instance_type: Optional[builtins.str] = None,
                 job_role_arn: Optional[builtins.str] = None,
                 linux_parameters: Optional['outputs.JobDefinitionLinuxParameters'] = None,
                 log_configuration: Optional['outputs.JobDefinitionLogConfiguration'] = None,
                 memory: Optional[builtins.int] = None,
                 mount_points: Optional[Sequence['outputs.JobDefinitionMountPoint']] = None,
                 privileged: Optional[builtins.bool] = None,
                 readonly_root_filesystem: Optional[builtins.bool] = None,
                 repository_credentials: Optional['outputs.JobDefinitionRepositoryCredentials'] = None,
                 resource_requirements: Optional[Sequence['outputs.JobDefinitionResourceRequirement']] = None,
                 runtime_platform: Optional['outputs.JobDefinitionRuntimePlatform'] = None,
                 secrets: Optional[Sequence['outputs.JobDefinitionSecret']] = None,
                 ulimits: Optional[Sequence['outputs.JobDefinitionUlimit']] = None,
                 user: Optional[builtins.str] = None,
                 vcpus: Optional[builtins.int] = None,
                 volumes: Optional[Sequence['outputs.JobDefinitionVolume']] = None):
        """
        :param builtins.str image: Required. The image used to start a container. This string is passed directly to the Docker daemon. Images in the Docker Hub registry are available by default. Other repositories are specified with `*repository-url* / *image* : *tag*` . It can be 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), underscores (_), colons (:), periods (.), forward slashes (/), and number signs (#). This parameter maps to `Image` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `IMAGE` parameter of [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > Docker image architecture must match the processor architecture of the compute resources that they're scheduled on. For example, ARM-based Docker images can only run on ARM-based compute resources. 
               
               - Images in Amazon ECR Public repositories use the full `registry/repository[:tag]` or `registry/repository[@digest]` naming conventions. For example, `public.ecr.aws/ *registry_alias* / *my-web-app* : *latest*` .
               - Images in Amazon ECR repositories use the full registry and repository URI (for example, `123456789012.dkr.ecr.<region-name>.amazonaws.com/<repository-name>` ).
               - Images in official repositories on Docker Hub use a single name (for example, `ubuntu` or `mongo` ).
               - Images in other repositories on Docker Hub are qualified with an organization name (for example, `amazon/amazon-ecs-agent` ).
               - Images in other online repositories are qualified further by a domain name (for example, `quay.io/assemblyline/ubuntu` ).
        :param Sequence[builtins.str] command: The command that's passed to the container. This parameter maps to `Cmd` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `COMMAND` parameter to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . For more information, see [https://docs.docker.com/engine/reference/builder/#cmd](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd) .
        :param builtins.bool enable_execute_command: Determines whether execute command functionality is turned on for this task. If `true` , execute command functionality is turned on all the containers in the task.
        :param Sequence['JobDefinitionEnvironment'] environment: The environment variables to pass to a container. This parameter maps to `Env` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--env` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > We don't recommend using plaintext environment variables for sensitive information, such as credential data. > Environment variables cannot start with " `AWS_BATCH` ". This naming convention is reserved for variables that AWS Batch sets.
        :param 'JobDefinitionEphemeralStorage' ephemeral_storage: The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
        :param builtins.str execution_role_arn: The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [AWS Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *AWS Batch User Guide* .
        :param builtins.str instance_type: The instance type to use for a multi-node parallel job. All node groups in a multi-node parallel job must use the same instance type.
               
               > This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
        :param builtins.str job_role_arn: The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions. For more information, see [IAM roles for tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param 'JobDefinitionLinuxParameters' linux_parameters: Linux-specific modifications that are applied to the container, such as details for device mappings.
        :param 'JobDefinitionLogConfiguration' log_configuration: The log configuration specification for the container.
               
               This parameter maps to `LogConfig` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--log-driver` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . By default, containers use the same logging driver that the Docker daemon uses. However the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see [Configure logging drivers](https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/) in the Docker documentation.
               
               > AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the [LogConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html) data type). 
               
               This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
               
               > The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param builtins.int memory: This parameter is deprecated, use `resourceRequirements` to specify the memory requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs that run on Amazon EC2 resources, it specifies the memory hard limit (in MiB) for a container. If your container attempts to exceed the specified number, it's terminated. You must specify at least 4 MiB of memory for a job using this parameter. The memory hard limit can be specified in several places. It must be specified for each node at least once.
        :param Sequence['JobDefinitionMountPoint'] mount_points: The mount points for data volumes in your container.
               
               This parameter maps to `Volumes` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the [--volume](https://docs.aws.amazon.com/) option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .
               
               Windows containers can mount whole directories on the same drive as `$env:ProgramData` . Windows containers can't mount directories on a different drive, and mount point can't be across drives.
        :param builtins.bool privileged: When this parameter is true, the container is given elevated permissions on the host container instance (similar to the `root` user). This parameter maps to `Privileged` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--privileged` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . The default value is false.
               
               > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided, or specified as false.
        :param builtins.bool readonly_root_filesystem: When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--read-only` option to `docker run` .
        :param 'JobDefinitionRepositoryCredentials' repository_credentials: The private repository authentication credentials to use.
        :param Sequence['JobDefinitionResourceRequirement'] resource_requirements: The type and amount of resources to assign to a container. The supported resources include `GPU` , `MEMORY` , and `VCPU` .
        :param 'JobDefinitionRuntimePlatform' runtime_platform: An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
        :param Sequence['JobDefinitionSecret'] secrets: The secrets for the container. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html) in the *AWS Batch User Guide* .
        :param Sequence['JobDefinitionUlimit'] ulimits: A list of `ulimits` to set in the container. This parameter maps to `Ulimits` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--ulimit` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
        :param builtins.str user: The user name to use inside the container. This parameter maps to `User` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--user` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
        :param builtins.int vcpus: This parameter is deprecated, use `resourceRequirements` to specify the vCPU requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs running on Amazon EC2 resources, it specifies the number of vCPUs reserved for the job.
               
               Each vCPU is equivalent to 1,024 CPU shares. This parameter maps to `CpuShares` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . The number of vCPUs must be specified but can be specified in several places. You must specify it at least once for each node.
        :param Sequence['JobDefinitionVolume'] volumes: A list of data volumes used in a job.
        """
        pulumi.set(__self__, "image", image)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if enable_execute_command is not None:
            pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if job_role_arn is not None:
            pulumi.set(__self__, "job_role_arn", job_role_arn)
        if linux_parameters is not None:
            pulumi.set(__self__, "linux_parameters", linux_parameters)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if mount_points is not None:
            pulumi.set(__self__, "mount_points", mount_points)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if readonly_root_filesystem is not None:
            pulumi.set(__self__, "readonly_root_filesystem", readonly_root_filesystem)
        if repository_credentials is not None:
            pulumi.set(__self__, "repository_credentials", repository_credentials)
        if resource_requirements is not None:
            pulumi.set(__self__, "resource_requirements", resource_requirements)
        if runtime_platform is not None:
            pulumi.set(__self__, "runtime_platform", runtime_platform)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if ulimits is not None:
            pulumi.set(__self__, "ulimits", ulimits)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if vcpus is not None:
            pulumi.set(__self__, "vcpus", vcpus)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def image(self) -> builtins.str:
        """
        Required. The image used to start a container. This string is passed directly to the Docker daemon. Images in the Docker Hub registry are available by default. Other repositories are specified with `*repository-url* / *image* : *tag*` . It can be 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), underscores (_), colons (:), periods (.), forward slashes (/), and number signs (#). This parameter maps to `Image` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `IMAGE` parameter of [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > Docker image architecture must match the processor architecture of the compute resources that they're scheduled on. For example, ARM-based Docker images can only run on ARM-based compute resources. 

        - Images in Amazon ECR Public repositories use the full `registry/repository[:tag]` or `registry/repository[@digest]` naming conventions. For example, `public.ecr.aws/ *registry_alias* / *my-web-app* : *latest*` .
        - Images in Amazon ECR repositories use the full registry and repository URI (for example, `123456789012.dkr.ecr.<region-name>.amazonaws.com/<repository-name>` ).
        - Images in official repositories on Docker Hub use a single name (for example, `ubuntu` or `mongo` ).
        - Images in other repositories on Docker Hub are qualified with an organization name (for example, `amazon/amazon-ecs-agent` ).
        - Images in other online repositories are qualified further by a domain name (for example, `quay.io/assemblyline/ubuntu` ).
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def command(self) -> Optional[Sequence[builtins.str]]:
        """
        The command that's passed to the container. This parameter maps to `Cmd` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `COMMAND` parameter to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . For more information, see [https://docs.docker.com/engine/reference/builder/#cmd](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd) .
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[builtins.bool]:
        """
        Determines whether execute command functionality is turned on for this task. If `true` , execute command functionality is turned on all the containers in the task.
        """
        return pulumi.get(self, "enable_execute_command")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Sequence['outputs.JobDefinitionEnvironment']]:
        """
        The environment variables to pass to a container. This parameter maps to `Env` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--env` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > We don't recommend using plaintext environment variables for sensitive information, such as credential data. > Environment variables cannot start with " `AWS_BATCH` ". This naming convention is reserved for variables that AWS Batch sets.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional['outputs.JobDefinitionEphemeralStorage']:
        """
        The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
        """
        return pulumi.get(self, "ephemeral_storage")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [AWS Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[builtins.str]:
        """
        The instance type to use for a multi-node parallel job. All node groups in a multi-node parallel job must use the same instance type.

        > This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="jobRoleArn")
    def job_role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions. For more information, see [IAM roles for tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "job_role_arn")

    @property
    @pulumi.getter(name="linuxParameters")
    def linux_parameters(self) -> Optional['outputs.JobDefinitionLinuxParameters']:
        """
        Linux-specific modifications that are applied to the container, such as details for device mappings.
        """
        return pulumi.get(self, "linux_parameters")

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional['outputs.JobDefinitionLogConfiguration']:
        """
        The log configuration specification for the container.

        This parameter maps to `LogConfig` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--log-driver` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . By default, containers use the same logging driver that the Docker daemon uses. However the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see [Configure logging drivers](https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/) in the Docker documentation.

        > AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the [LogConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html) data type). 

        This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`

        > The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "log_configuration")

    @property
    @pulumi.getter
    def memory(self) -> Optional[builtins.int]:
        """
        This parameter is deprecated, use `resourceRequirements` to specify the memory requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs that run on Amazon EC2 resources, it specifies the memory hard limit (in MiB) for a container. If your container attempts to exceed the specified number, it's terminated. You must specify at least 4 MiB of memory for a job using this parameter. The memory hard limit can be specified in several places. It must be specified for each node at least once.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> Optional[Sequence['outputs.JobDefinitionMountPoint']]:
        """
        The mount points for data volumes in your container.

        This parameter maps to `Volumes` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the [--volume](https://docs.aws.amazon.com/) option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .

        Windows containers can mount whole directories on the same drive as `$env:ProgramData` . Windows containers can't mount directories on a different drive, and mount point can't be across drives.
        """
        return pulumi.get(self, "mount_points")

    @property
    @pulumi.getter
    def privileged(self) -> Optional[builtins.bool]:
        """
        When this parameter is true, the container is given elevated permissions on the host container instance (similar to the `root` user). This parameter maps to `Privileged` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--privileged` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . The default value is false.

        > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided, or specified as false.
        """
        return pulumi.get(self, "privileged")

    @property
    @pulumi.getter(name="readonlyRootFilesystem")
    def readonly_root_filesystem(self) -> Optional[builtins.bool]:
        """
        When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--read-only` option to `docker run` .
        """
        return pulumi.get(self, "readonly_root_filesystem")

    @property
    @pulumi.getter(name="repositoryCredentials")
    def repository_credentials(self) -> Optional['outputs.JobDefinitionRepositoryCredentials']:
        """
        The private repository authentication credentials to use.
        """
        return pulumi.get(self, "repository_credentials")

    @property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> Optional[Sequence['outputs.JobDefinitionResourceRequirement']]:
        """
        The type and amount of resources to assign to a container. The supported resources include `GPU` , `MEMORY` , and `VCPU` .
        """
        return pulumi.get(self, "resource_requirements")

    @property
    @pulumi.getter(name="runtimePlatform")
    def runtime_platform(self) -> Optional['outputs.JobDefinitionRuntimePlatform']:
        """
        An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
        """
        return pulumi.get(self, "runtime_platform")

    @property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.JobDefinitionSecret']]:
        """
        The secrets for the container. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter
    def ulimits(self) -> Optional[Sequence['outputs.JobDefinitionUlimit']]:
        """
        A list of `ulimits` to set in the container. This parameter maps to `Ulimits` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--ulimit` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
        """
        return pulumi.get(self, "ulimits")

    @property
    @pulumi.getter
    def user(self) -> Optional[builtins.str]:
        """
        The user name to use inside the container. This parameter maps to `User` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--user` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def vcpus(self) -> Optional[builtins.int]:
        """
        This parameter is deprecated, use `resourceRequirements` to specify the vCPU requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs running on Amazon EC2 resources, it specifies the number of vCPUs reserved for the job.

        Each vCPU is equivalent to 1,024 CPU shares. This parameter maps to `CpuShares` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . The number of vCPUs must be specified but can be specified in several places. You must specify it at least once for each node.
        """
        return pulumi.get(self, "vcpus")

    @property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.JobDefinitionVolume']]:
        """
        A list of data volumes used in a job.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class JobDefinitionMultiNodeEcsProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskProperties":
            suggest = "task_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionMultiNodeEcsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionMultiNodeEcsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionMultiNodeEcsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 task_properties: Sequence['outputs.JobDefinitionMultiNodeEcsTaskProperties']):
        """
        :param Sequence['JobDefinitionMultiNodeEcsTaskProperties'] task_properties: An object that contains the properties for the Amazon ECS task definition of a job.
               
               > This object is currently limited to one task element. However, the task element can run up to 10 containers.
        """
        pulumi.set(__self__, "task_properties", task_properties)

    @property
    @pulumi.getter(name="taskProperties")
    def task_properties(self) -> Sequence['outputs.JobDefinitionMultiNodeEcsTaskProperties']:
        """
        An object that contains the properties for the Amazon ECS task definition of a job.

        > This object is currently limited to one task element. However, the task element can run up to 10 containers.
        """
        return pulumi.get(self, "task_properties")


@pulumi.output_type
class JobDefinitionMultiNodeEcsTaskProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableExecuteCommand":
            suggest = "enable_execute_command"
        elif key == "executionRoleArn":
            suggest = "execution_role_arn"
        elif key == "ipcMode":
            suggest = "ipc_mode"
        elif key == "pidMode":
            suggest = "pid_mode"
        elif key == "taskRoleArn":
            suggest = "task_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionMultiNodeEcsTaskProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionMultiNodeEcsTaskProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionMultiNodeEcsTaskProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 containers: Optional[Sequence['outputs.JobDefinitionTaskContainerProperties']] = None,
                 enable_execute_command: Optional[builtins.bool] = None,
                 execution_role_arn: Optional[builtins.str] = None,
                 ipc_mode: Optional[builtins.str] = None,
                 pid_mode: Optional[builtins.str] = None,
                 task_role_arn: Optional[builtins.str] = None,
                 volumes: Optional[Sequence['outputs.JobDefinitionVolume']] = None):
        """
        :param Sequence['JobDefinitionTaskContainerProperties'] containers: This object is a list of containers.
        :param builtins.bool enable_execute_command: Determines whether execute command functionality is turned on for this task. If `true` , execute command functionality is turned on all the containers in the task.
        :param builtins.str execution_role_arn: The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [AWS Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *AWS Batch User Guide* .
        :param builtins.str ipc_mode: The IPC resource namespace to use for the containers in the task. The valid values are `host` , `task` , or `none` .
               
               If `host` is specified, all containers within the tasks that specified the `host` IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance.
               
               If `task` is specified, all containers within the specified `task` share the same IPC resources.
               
               If `none` is specified, the IPC resources within the containers of a task are private, and are not shared with other containers in a task or on the container instance.
               
               If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see [IPC settings](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#ipc-settings---ipc) in the Docker run reference.
        :param builtins.str pid_mode: The process namespace to use for the containers in the task. The valid values are `host` or `task` . For example, monitoring sidecars might need `pidMode` to access information about other containers running in the same task.
               
               If `host` is specified, all containers within the tasks that specified the `host` PID mode on the same container instance share the process namespace with the host Amazon EC2 instance.
               
               If `task` is specified, all containers within the specified task share the same process namespace.
               
               If no value is specified, the default is a private namespace for each container. For more information, see [PID settings](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#pid-settings---pid) in the Docker run reference.
        :param builtins.str task_role_arn: The Amazon Resource Name (ARN) that's associated with the Amazon ECS task.
               
               > This is object is comparable to [ContainerProperties:jobRoleArn](https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html) .
        :param Sequence['JobDefinitionVolume'] volumes: A list of volumes that are associated with the job.
        """
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if enable_execute_command is not None:
            pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if ipc_mode is not None:
            pulumi.set(__self__, "ipc_mode", ipc_mode)
        if pid_mode is not None:
            pulumi.set(__self__, "pid_mode", pid_mode)
        if task_role_arn is not None:
            pulumi.set(__self__, "task_role_arn", task_role_arn)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def containers(self) -> Optional[Sequence['outputs.JobDefinitionTaskContainerProperties']]:
        """
        This object is a list of containers.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[builtins.bool]:
        """
        Determines whether execute command functionality is turned on for this task. If `true` , execute command functionality is turned on all the containers in the task.
        """
        return pulumi.get(self, "enable_execute_command")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [AWS Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter(name="ipcMode")
    def ipc_mode(self) -> Optional[builtins.str]:
        """
        The IPC resource namespace to use for the containers in the task. The valid values are `host` , `task` , or `none` .

        If `host` is specified, all containers within the tasks that specified the `host` IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance.

        If `task` is specified, all containers within the specified `task` share the same IPC resources.

        If `none` is specified, the IPC resources within the containers of a task are private, and are not shared with other containers in a task or on the container instance.

        If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see [IPC settings](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#ipc-settings---ipc) in the Docker run reference.
        """
        return pulumi.get(self, "ipc_mode")

    @property
    @pulumi.getter(name="pidMode")
    def pid_mode(self) -> Optional[builtins.str]:
        """
        The process namespace to use for the containers in the task. The valid values are `host` or `task` . For example, monitoring sidecars might need `pidMode` to access information about other containers running in the same task.

        If `host` is specified, all containers within the tasks that specified the `host` PID mode on the same container instance share the process namespace with the host Amazon EC2 instance.

        If `task` is specified, all containers within the specified task share the same process namespace.

        If no value is specified, the default is a private namespace for each container. For more information, see [PID settings](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#pid-settings---pid) in the Docker run reference.
        """
        return pulumi.get(self, "pid_mode")

    @property
    @pulumi.getter(name="taskRoleArn")
    def task_role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) that's associated with the Amazon ECS task.

        > This is object is comparable to [ContainerProperties:jobRoleArn](https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html) .
        """
        return pulumi.get(self, "task_role_arn")

    @property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.JobDefinitionVolume']]:
        """
        A list of volumes that are associated with the job.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class JobDefinitionNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignPublicIp":
            suggest = "assign_public_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assign_public_ip: Optional[builtins.str] = None):
        """
        :param builtins.str assign_public_ip: Indicates whether the job has a public IP address. For a job that's running on Fargate resources in a private subnet to send outbound traffic to the internet (for example, to pull container images), the private subnet requires a NAT gateway be attached to route requests to the internet. For more information, see [Amazon ECS task networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide* . The default value is " `DISABLED` ".
        """
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional[builtins.str]:
        """
        Indicates whether the job has a public IP address. For a job that's running on Fargate resources in a private subnet to send outbound traffic to the internet (for example, to pull container images), the private subnet requires a NAT gateway be attached to route requests to the internet. For more information, see [Amazon ECS task networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide* . The default value is " `DISABLED` ".
        """
        return pulumi.get(self, "assign_public_ip")


@pulumi.output_type
class JobDefinitionNodeProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mainNode":
            suggest = "main_node"
        elif key == "nodeRangeProperties":
            suggest = "node_range_properties"
        elif key == "numNodes":
            suggest = "num_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionNodeProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionNodeProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionNodeProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 main_node: builtins.int,
                 node_range_properties: Sequence['outputs.JobDefinitionNodeRangeProperty'],
                 num_nodes: builtins.int):
        """
        :param builtins.int main_node: Specifies the node index for the main node of a multi-node parallel job. This node index value must be fewer than the number of nodes.
        :param Sequence['JobDefinitionNodeRangeProperty'] node_range_properties: A list of node ranges and their properties that are associated with a multi-node parallel job.
        :param builtins.int num_nodes: The number of nodes that are associated with a multi-node parallel job.
        """
        pulumi.set(__self__, "main_node", main_node)
        pulumi.set(__self__, "node_range_properties", node_range_properties)
        pulumi.set(__self__, "num_nodes", num_nodes)

    @property
    @pulumi.getter(name="mainNode")
    def main_node(self) -> builtins.int:
        """
        Specifies the node index for the main node of a multi-node parallel job. This node index value must be fewer than the number of nodes.
        """
        return pulumi.get(self, "main_node")

    @property
    @pulumi.getter(name="nodeRangeProperties")
    def node_range_properties(self) -> Sequence['outputs.JobDefinitionNodeRangeProperty']:
        """
        A list of node ranges and their properties that are associated with a multi-node parallel job.
        """
        return pulumi.get(self, "node_range_properties")

    @property
    @pulumi.getter(name="numNodes")
    def num_nodes(self) -> builtins.int:
        """
        The number of nodes that are associated with a multi-node parallel job.
        """
        return pulumi.get(self, "num_nodes")


@pulumi.output_type
class JobDefinitionNodeRangeProperty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetNodes":
            suggest = "target_nodes"
        elif key == "consumableResourceProperties":
            suggest = "consumable_resource_properties"
        elif key == "ecsProperties":
            suggest = "ecs_properties"
        elif key == "eksProperties":
            suggest = "eks_properties"
        elif key == "instanceTypes":
            suggest = "instance_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionNodeRangeProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionNodeRangeProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionNodeRangeProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_nodes: builtins.str,
                 consumable_resource_properties: Optional['outputs.JobDefinitionConsumableResourceProperties'] = None,
                 container: Optional['outputs.JobDefinitionMultiNodeContainerProperties'] = None,
                 ecs_properties: Optional['outputs.JobDefinitionMultiNodeEcsProperties'] = None,
                 eks_properties: Optional['outputs.JobDefinitionEksProperties'] = None,
                 instance_types: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str target_nodes: The range of nodes, using node index values. A range of `0:3` indicates nodes with index values of `0` through `3` . If the starting range value is omitted ( `:n` ), then `0` is used to start the range. If the ending range value is omitted ( `n:` ), then the highest possible node index is used to end the range. Your accumulative node ranges must account for all nodes ( `0:n` ). You can nest node ranges (for example, `0:10` and `4:5` ). In this case, the `4:5` range properties override the `0:10` properties.
        :param 'JobDefinitionConsumableResourceProperties' consumable_resource_properties: Contains a list of consumable resources required by a job.
        :param 'JobDefinitionMultiNodeContainerProperties' container: The container details for the node range.
        :param 'JobDefinitionMultiNodeEcsProperties' ecs_properties: This is an object that represents the properties of the node range for a multi-node parallel job.
        :param 'JobDefinitionEksProperties' eks_properties: This is an object that represents the properties of the node range for a multi-node parallel job.
        :param Sequence[builtins.str] instance_types: The instance types of the underlying host infrastructure of a multi-node parallel job.
               
               > This parameter isn't applicable to jobs that are running on Fargate resources.
               > 
               > In addition, this list object is currently limited to one element.
        """
        pulumi.set(__self__, "target_nodes", target_nodes)
        if consumable_resource_properties is not None:
            pulumi.set(__self__, "consumable_resource_properties", consumable_resource_properties)
        if container is not None:
            pulumi.set(__self__, "container", container)
        if ecs_properties is not None:
            pulumi.set(__self__, "ecs_properties", ecs_properties)
        if eks_properties is not None:
            pulumi.set(__self__, "eks_properties", eks_properties)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)

    @property
    @pulumi.getter(name="targetNodes")
    def target_nodes(self) -> builtins.str:
        """
        The range of nodes, using node index values. A range of `0:3` indicates nodes with index values of `0` through `3` . If the starting range value is omitted ( `:n` ), then `0` is used to start the range. If the ending range value is omitted ( `n:` ), then the highest possible node index is used to end the range. Your accumulative node ranges must account for all nodes ( `0:n` ). You can nest node ranges (for example, `0:10` and `4:5` ). In this case, the `4:5` range properties override the `0:10` properties.
        """
        return pulumi.get(self, "target_nodes")

    @property
    @pulumi.getter(name="consumableResourceProperties")
    def consumable_resource_properties(self) -> Optional['outputs.JobDefinitionConsumableResourceProperties']:
        """
        Contains a list of consumable resources required by a job.
        """
        return pulumi.get(self, "consumable_resource_properties")

    @property
    @pulumi.getter
    def container(self) -> Optional['outputs.JobDefinitionMultiNodeContainerProperties']:
        """
        The container details for the node range.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="ecsProperties")
    def ecs_properties(self) -> Optional['outputs.JobDefinitionMultiNodeEcsProperties']:
        """
        This is an object that represents the properties of the node range for a multi-node parallel job.
        """
        return pulumi.get(self, "ecs_properties")

    @property
    @pulumi.getter(name="eksProperties")
    def eks_properties(self) -> Optional['outputs.JobDefinitionEksProperties']:
        """
        This is an object that represents the properties of the node range for a multi-node parallel job.
        """
        return pulumi.get(self, "eks_properties")

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[Sequence[builtins.str]]:
        """
        The instance types of the underlying host infrastructure of a multi-node parallel job.

        > This parameter isn't applicable to jobs that are running on Fargate resources.
        > 
        > In addition, this list object is currently limited to one element.
        """
        return pulumi.get(self, "instance_types")


@pulumi.output_type
class JobDefinitionRepositoryCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialsParameter":
            suggest = "credentials_parameter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionRepositoryCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionRepositoryCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionRepositoryCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials_parameter: builtins.str):
        """
        :param builtins.str credentials_parameter: The Amazon Resource Name (ARN) of the secret containing the private repository credentials.
        """
        pulumi.set(__self__, "credentials_parameter", credentials_parameter)

    @property
    @pulumi.getter(name="credentialsParameter")
    def credentials_parameter(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the secret containing the private repository credentials.
        """
        return pulumi.get(self, "credentials_parameter")


@pulumi.output_type
class JobDefinitionResourceRequirement(dict):
    def __init__(__self__, *,
                 type: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of resource to assign to a container. The supported resources include `GPU` , `MEMORY` , and `VCPU` .
        :param builtins.str value: The quantity of the specified resource to reserve for the container. The values vary based on the `type` specified.
               
               - **type="GPU"** - The number of physical GPUs to reserve for the container. Make sure that the number of GPUs reserved for all containers in a job doesn't exceed the number of available GPUs on the compute resource that the job is launched on.
               
               > GPUs aren't available for jobs that are running on Fargate resources.
               - **type="MEMORY"** - The memory hard limit (in MiB) present to the container. This parameter is supported for jobs that are running on Amazon EC2 resources. If your container attempts to exceed the memory specified, the container is terminated. This parameter maps to `Memory` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--memory` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . You must specify at least 4 MiB of memory for a job. This is required but can be specified in several places for multi-node parallel (MNP) jobs. It must be specified for each node at least once. This parameter maps to `Memory` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--memory` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see [Memory management](https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html) in the *AWS Batch User Guide* . 
               
               For jobs that are running on Fargate resources, then `value` is the hard limit (in MiB), and must match one of the supported values and the `VCPU` values must be one of the values supported for that memory value.
               
               - **value = 512** - `VCPU` = 0.25
               - **value = 1024** - `VCPU` = 0.25 or 0.5
               - **value = 2048** - `VCPU` = 0.25, 0.5, or 1
               - **value = 3072** - `VCPU` = 0.5, or 1
               - **value = 4096** - `VCPU` = 0.5, 1, or 2
               - **value = 5120, 6144, or 7168** - `VCPU` = 1 or 2
               - **value = 8192** - `VCPU` = 1, 2, or 4
               - **value = 9216, 10240, 11264, 12288, 13312, 14336, or 15360** - `VCPU` = 2 or 4
               - **value = 16384** - `VCPU` = 2, 4, or 8
               - **value = 17408, 18432, 19456, 21504, 22528, 23552, 25600, 26624, 27648, 29696, or 30720** - `VCPU` = 4
               - **value = 20480, 24576, or 28672** - `VCPU` = 4 or 8
               - **value = 36864, 45056, 53248, or 61440** - `VCPU` = 8
               - **value = 32768, 40960, 49152, or 57344** - `VCPU` = 8 or 16
               - **value = 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880** - `VCPU` = 16
               - **type="VCPU"** - The number of vCPUs reserved for the container. This parameter maps to `CpuShares` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . Each vCPU is equivalent to 1,024 CPU shares. For Amazon EC2 resources, you must specify at least one vCPU. This is required but can be specified in several places; it must be specified for each node at least once.
               
               The default for the Fargate On-Demand vCPU resource count quota is 6 vCPUs. For more information about Fargate quotas, see [AWS Fargate quotas](https://docs.aws.amazon.com/general/latest/gr/ecs-service.html#service-quotas-fargate) in the *AWS General Reference* .
               
               For jobs that are running on Fargate resources, then `value` must match one of the supported values and the `MEMORY` values must be one of the values supported for that `VCPU` value. The supported values are 0.25, 0.5, 1, 2, 4, 8, and 16
               
               - **value = 0.25** - `MEMORY` = 512, 1024, or 2048
               - **value = 0.5** - `MEMORY` = 1024, 2048, 3072, or 4096
               - **value = 1** - `MEMORY` = 2048, 3072, 4096, 5120, 6144, 7168, or 8192
               - **value = 2** - `MEMORY` = 4096, 5120, 6144, 7168, 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, or 16384
               - **value = 4** - `MEMORY` = 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, 16384, 17408, 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600, 26624, 27648, 28672, 29696, or 30720
               - **value = 8** - `MEMORY` = 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056, 49152, 53248, 57344, or 61440
               - **value = 16** - `MEMORY` = 32768, 40960, 49152, 57344, 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of resource to assign to a container. The supported resources include `GPU` , `MEMORY` , and `VCPU` .
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The quantity of the specified resource to reserve for the container. The values vary based on the `type` specified.

        - **type="GPU"** - The number of physical GPUs to reserve for the container. Make sure that the number of GPUs reserved for all containers in a job doesn't exceed the number of available GPUs on the compute resource that the job is launched on.

        > GPUs aren't available for jobs that are running on Fargate resources.
        - **type="MEMORY"** - The memory hard limit (in MiB) present to the container. This parameter is supported for jobs that are running on Amazon EC2 resources. If your container attempts to exceed the memory specified, the container is terminated. This parameter maps to `Memory` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--memory` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . You must specify at least 4 MiB of memory for a job. This is required but can be specified in several places for multi-node parallel (MNP) jobs. It must be specified for each node at least once. This parameter maps to `Memory` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--memory` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see [Memory management](https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html) in the *AWS Batch User Guide* . 

        For jobs that are running on Fargate resources, then `value` is the hard limit (in MiB), and must match one of the supported values and the `VCPU` values must be one of the values supported for that memory value.

        - **value = 512** - `VCPU` = 0.25
        - **value = 1024** - `VCPU` = 0.25 or 0.5
        - **value = 2048** - `VCPU` = 0.25, 0.5, or 1
        - **value = 3072** - `VCPU` = 0.5, or 1
        - **value = 4096** - `VCPU` = 0.5, 1, or 2
        - **value = 5120, 6144, or 7168** - `VCPU` = 1 or 2
        - **value = 8192** - `VCPU` = 1, 2, or 4
        - **value = 9216, 10240, 11264, 12288, 13312, 14336, or 15360** - `VCPU` = 2 or 4
        - **value = 16384** - `VCPU` = 2, 4, or 8
        - **value = 17408, 18432, 19456, 21504, 22528, 23552, 25600, 26624, 27648, 29696, or 30720** - `VCPU` = 4
        - **value = 20480, 24576, or 28672** - `VCPU` = 4 or 8
        - **value = 36864, 45056, 53248, or 61440** - `VCPU` = 8
        - **value = 32768, 40960, 49152, or 57344** - `VCPU` = 8 or 16
        - **value = 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880** - `VCPU` = 16
        - **type="VCPU"** - The number of vCPUs reserved for the container. This parameter maps to `CpuShares` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . Each vCPU is equivalent to 1,024 CPU shares. For Amazon EC2 resources, you must specify at least one vCPU. This is required but can be specified in several places; it must be specified for each node at least once.

        The default for the Fargate On-Demand vCPU resource count quota is 6 vCPUs. For more information about Fargate quotas, see [AWS Fargate quotas](https://docs.aws.amazon.com/general/latest/gr/ecs-service.html#service-quotas-fargate) in the *AWS General Reference* .

        For jobs that are running on Fargate resources, then `value` must match one of the supported values and the `MEMORY` values must be one of the values supported for that `VCPU` value. The supported values are 0.25, 0.5, 1, 2, 4, 8, and 16

        - **value = 0.25** - `MEMORY` = 512, 1024, or 2048
        - **value = 0.5** - `MEMORY` = 1024, 2048, 3072, or 4096
        - **value = 1** - `MEMORY` = 2048, 3072, 4096, 5120, 6144, 7168, or 8192
        - **value = 2** - `MEMORY` = 4096, 5120, 6144, 7168, 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, or 16384
        - **value = 4** - `MEMORY` = 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, 16384, 17408, 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600, 26624, 27648, 28672, 29696, or 30720
        - **value = 8** - `MEMORY` = 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056, 49152, 53248, 57344, or 61440
        - **value = 16** - `MEMORY` = 32768, 40960, 49152, 57344, 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class JobDefinitionRetryStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluateOnExit":
            suggest = "evaluate_on_exit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionRetryStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionRetryStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionRetryStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attempts: Optional[builtins.int] = None,
                 evaluate_on_exit: Optional[Sequence['outputs.JobDefinitionEvaluateOnExit']] = None):
        """
        :param builtins.int attempts: The number of times to move a job to the `RUNNABLE` status. You can specify between 1 and 10 attempts. If the value of `attempts` is greater than one, the job is retried on failure the same number of attempts as the value.
        :param Sequence['JobDefinitionEvaluateOnExit'] evaluate_on_exit: Array of up to 5 objects that specify the conditions where jobs are retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. If none of the listed conditions match, then the job is retried.
        """
        if attempts is not None:
            pulumi.set(__self__, "attempts", attempts)
        if evaluate_on_exit is not None:
            pulumi.set(__self__, "evaluate_on_exit", evaluate_on_exit)

    @property
    @pulumi.getter
    def attempts(self) -> Optional[builtins.int]:
        """
        The number of times to move a job to the `RUNNABLE` status. You can specify between 1 and 10 attempts. If the value of `attempts` is greater than one, the job is retried on failure the same number of attempts as the value.
        """
        return pulumi.get(self, "attempts")

    @property
    @pulumi.getter(name="evaluateOnExit")
    def evaluate_on_exit(self) -> Optional[Sequence['outputs.JobDefinitionEvaluateOnExit']]:
        """
        Array of up to 5 objects that specify the conditions where jobs are retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. If none of the listed conditions match, then the job is retried.
        """
        return pulumi.get(self, "evaluate_on_exit")


@pulumi.output_type
class JobDefinitionRuntimePlatform(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuArchitecture":
            suggest = "cpu_architecture"
        elif key == "operatingSystemFamily":
            suggest = "operating_system_family"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionRuntimePlatform. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionRuntimePlatform.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionRuntimePlatform.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_architecture: Optional[builtins.str] = None,
                 operating_system_family: Optional[builtins.str] = None):
        """
        :param builtins.str cpu_architecture: The vCPU architecture. The default value is `X86_64` . Valid values are `X86_64` and `ARM64` .
               
               > This parameter must be set to `X86_64` for Windows containers. > Fargate Spot is not supported for `ARM64` and Windows-based containers on Fargate. A job queue will be blocked if a Fargate `ARM64` or Windows job is submitted to a job queue with only Fargate Spot compute environments. However, you can attach both `FARGATE` and `FARGATE_SPOT` compute environments to the same job queue.
        :param builtins.str operating_system_family: The operating system for the compute environment. Valid values are: `LINUX` (default), `WINDOWS_SERVER_2019_CORE` , `WINDOWS_SERVER_2019_FULL` , `WINDOWS_SERVER_2022_CORE` , and `WINDOWS_SERVER_2022_FULL` .
               
               > The following parameters can’t be set for Windows containers: `linuxParameters` , `privileged` , `user` , `ulimits` , `readonlyRootFilesystem` , and `efsVolumeConfiguration` . > The AWS Batch Scheduler checks the compute environments that are attached to the job queue before registering a task definition with Fargate. In this scenario, the job queue is where the job is submitted. If the job requires a Windows container and the first compute environment is `LINUX` , the compute environment is skipped and the next compute environment is checked until a Windows-based compute environment is found. > Fargate Spot is not supported for `ARM64` and Windows-based containers on Fargate. A job queue will be blocked if a Fargate `ARM64` or Windows job is submitted to a job queue with only Fargate Spot compute environments. However, you can attach both `FARGATE` and `FARGATE_SPOT` compute environments to the same job queue.
        """
        if cpu_architecture is not None:
            pulumi.set(__self__, "cpu_architecture", cpu_architecture)
        if operating_system_family is not None:
            pulumi.set(__self__, "operating_system_family", operating_system_family)

    @property
    @pulumi.getter(name="cpuArchitecture")
    def cpu_architecture(self) -> Optional[builtins.str]:
        """
        The vCPU architecture. The default value is `X86_64` . Valid values are `X86_64` and `ARM64` .

        > This parameter must be set to `X86_64` for Windows containers. > Fargate Spot is not supported for `ARM64` and Windows-based containers on Fargate. A job queue will be blocked if a Fargate `ARM64` or Windows job is submitted to a job queue with only Fargate Spot compute environments. However, you can attach both `FARGATE` and `FARGATE_SPOT` compute environments to the same job queue.
        """
        return pulumi.get(self, "cpu_architecture")

    @property
    @pulumi.getter(name="operatingSystemFamily")
    def operating_system_family(self) -> Optional[builtins.str]:
        """
        The operating system for the compute environment. Valid values are: `LINUX` (default), `WINDOWS_SERVER_2019_CORE` , `WINDOWS_SERVER_2019_FULL` , `WINDOWS_SERVER_2022_CORE` , and `WINDOWS_SERVER_2022_FULL` .

        > The following parameters can’t be set for Windows containers: `linuxParameters` , `privileged` , `user` , `ulimits` , `readonlyRootFilesystem` , and `efsVolumeConfiguration` . > The AWS Batch Scheduler checks the compute environments that are attached to the job queue before registering a task definition with Fargate. In this scenario, the job queue is where the job is submitted. If the job requires a Windows container and the first compute environment is `LINUX` , the compute environment is skipped and the next compute environment is checked until a Windows-based compute environment is found. > Fargate Spot is not supported for `ARM64` and Windows-based containers on Fargate. A job queue will be blocked if a Fargate `ARM64` or Windows job is submitted to a job queue with only Fargate Spot compute environments. However, you can attach both `FARGATE` and `FARGATE_SPOT` compute environments to the same job queue.
        """
        return pulumi.get(self, "operating_system_family")


@pulumi.output_type
class JobDefinitionSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueFrom":
            suggest = "value_from"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 value_from: builtins.str):
        """
        :param builtins.str name: The name of the secret.
        :param builtins.str value_from: The secret to expose to the container. The supported values are either the full Amazon Resource Name (ARN) of the AWS Secrets Manager secret or the full ARN of the parameter in the AWS Systems Manager Parameter Store.
               
               > If the AWS Systems Manager Parameter Store parameter exists in the same Region as the job you're launching, then you can use either the full Amazon Resource Name (ARN) or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value_from", value_from)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the secret.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> builtins.str:
        """
        The secret to expose to the container. The supported values are either the full Amazon Resource Name (ARN) of the AWS Secrets Manager secret or the full ARN of the parameter in the AWS Systems Manager Parameter Store.

        > If the AWS Systems Manager Parameter Store parameter exists in the same Region as the job you're launching, then you can use either the full Amazon Resource Name (ARN) or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
        """
        return pulumi.get(self, "value_from")


@pulumi.output_type
class JobDefinitionTaskContainerDependency(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionTaskContainerDependency. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionTaskContainerDependency.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionTaskContainerDependency.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: builtins.str,
                 container_name: builtins.str):
        """
        :param builtins.str condition: The dependency condition of the container. The following are the available conditions and their behavior:
               
               - `START` - This condition emulates the behavior of links and volumes today. It validates that a dependent container is started before permitting other containers to start.
               - `COMPLETE` - This condition validates that a dependent container runs to completion (exits) before permitting other containers to start. This can be useful for nonessential containers that run a script and then exit. This condition can't be set on an essential container.
               - `SUCCESS` - This condition is the same as `COMPLETE` , but it also requires that the container exits with a zero status. This condition can't be set on an essential container.
        :param builtins.str container_name: A unique identifier for the container.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "container_name", container_name)

    @property
    @pulumi.getter
    def condition(self) -> builtins.str:
        """
        The dependency condition of the container. The following are the available conditions and their behavior:

        - `START` - This condition emulates the behavior of links and volumes today. It validates that a dependent container is started before permitting other containers to start.
        - `COMPLETE` - This condition validates that a dependent container runs to completion (exits) before permitting other containers to start. This can be useful for nonessential containers that run a script and then exit. This condition can't be set on an essential container.
        - `SUCCESS` - This condition is the same as `COMPLETE` , but it also requires that the container exits with a zero status. This condition can't be set on an essential container.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> builtins.str:
        """
        A unique identifier for the container.
        """
        return pulumi.get(self, "container_name")


@pulumi.output_type
class JobDefinitionTaskContainerProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOn":
            suggest = "depends_on"
        elif key == "firelensConfiguration":
            suggest = "firelens_configuration"
        elif key == "linuxParameters":
            suggest = "linux_parameters"
        elif key == "logConfiguration":
            suggest = "log_configuration"
        elif key == "mountPoints":
            suggest = "mount_points"
        elif key == "readonlyRootFilesystem":
            suggest = "readonly_root_filesystem"
        elif key == "repositoryCredentials":
            suggest = "repository_credentials"
        elif key == "resourceRequirements":
            suggest = "resource_requirements"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionTaskContainerProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionTaskContainerProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionTaskContainerProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: builtins.str,
                 command: Optional[Sequence[builtins.str]] = None,
                 depends_on: Optional[Sequence['outputs.JobDefinitionTaskContainerDependency']] = None,
                 environment: Optional[Sequence['outputs.JobDefinitionEnvironment']] = None,
                 essential: Optional[builtins.bool] = None,
                 firelens_configuration: Optional['outputs.JobDefinitionTaskContainerPropertiesFirelensConfigurationProperties'] = None,
                 linux_parameters: Optional['outputs.JobDefinitionLinuxParameters'] = None,
                 log_configuration: Optional['outputs.JobDefinitionLogConfiguration'] = None,
                 mount_points: Optional[Sequence['outputs.JobDefinitionMountPoint']] = None,
                 name: Optional[builtins.str] = None,
                 privileged: Optional[builtins.bool] = None,
                 readonly_root_filesystem: Optional[builtins.bool] = None,
                 repository_credentials: Optional['outputs.JobDefinitionRepositoryCredentials'] = None,
                 resource_requirements: Optional[Sequence['outputs.JobDefinitionResourceRequirement']] = None,
                 secrets: Optional[Sequence['outputs.JobDefinitionSecret']] = None,
                 ulimits: Optional[Sequence['outputs.JobDefinitionUlimit']] = None,
                 user: Optional[builtins.str] = None):
        """
        :param builtins.str image: The image used to start a container. This string is passed directly to the Docker daemon. By default, images in the Docker Hub registry are available. Other repositories are specified with either `repository-url/image:tag` or `repository-url/image@digest` . Up to 255 letters (uppercase and lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter maps to `Image` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `IMAGE` parameter of the [*docker run*](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .
        :param Sequence[builtins.str] command: The command that's passed to the container. This parameter maps to `Cmd` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `COMMAND` parameter to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . For more information, see [Dockerfile reference: CMD](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd) .
        :param Sequence['JobDefinitionTaskContainerDependency'] depends_on: A list of containers that this container depends on.
        :param Sequence['JobDefinitionEnvironment'] environment: The environment variables to pass to a container. This parameter maps to Env in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--env` parameter to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > We don't recommend using plaintext environment variables for sensitive information, such as credential data. > Environment variables cannot start with `AWS_BATCH` . This naming convention is reserved for variables that AWS Batch sets.
        :param builtins.bool essential: If the essential parameter of a container is marked as `true` , and that container fails or stops for any reason, all other containers that are part of the task are stopped. If the `essential` parameter of a container is marked as false, its failure doesn't affect the rest of the containers in a task. If this parameter is omitted, a container is assumed to be essential.
               
               All jobs must have at least one essential container. If you have an application that's composed of multiple containers, group containers that are used for a common purpose into components, and separate the different components into multiple task definitions. For more information, see [Application Architecture](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param 'JobDefinitionTaskContainerPropertiesFirelensConfigurationProperties' firelens_configuration: The FireLens configuration for the container. This is used to specify and configure a log router for container logs. For more information, see [Custom log](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html) routing in the *Amazon Elastic Container Service Developer Guide* .
        :param 'JobDefinitionLinuxParameters' linux_parameters: Linux-specific modifications that are applied to the container, such as Linux kernel capabilities. For more information, see [KernelCapabilities](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html) .
        :param 'JobDefinitionLogConfiguration' log_configuration: The log configuration specification for the container.
               
               This parameter maps to `LogConfig` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `--log-driver` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .
               
               By default, containers use the same logging driver that the Docker daemon uses. However the container can use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information about the options for different supported log drivers, see [Configure logging drivers](https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/) in the *Docker documentation* .
               
               > Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon (shown in the `LogConfiguration` data type). Additional log drivers may be available in future releases of the Amazon ECS container agent. 
               
               This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: sudo docker version `--format '{{.Server.APIVersion}}'`
               
               > The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param Sequence['JobDefinitionMountPoint'] mount_points: The mount points for data volumes in your container.
               
               This parameter maps to `Volumes` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the [--volume](https://docs.aws.amazon.com/) option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .
               
               Windows containers can mount whole directories on the same drive as `$env:ProgramData` . Windows containers can't mount directories on a different drive, and mount point can't be across drives.
        :param builtins.str name: The name of a container. The name can be used as a unique identifier to target your `dependsOn` and `Overrides` objects.
        :param builtins.bool privileged: When this parameter is `true` , the container is given elevated privileges on the host container instance (similar to the `root` user). This parameter maps to `Privileged` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `--privileged` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .
               
               > This parameter is not supported for Windows containers or tasks run on Fargate.
        :param builtins.bool readonly_root_filesystem: When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `--read-only` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .
               
               > This parameter is not supported for Windows containers.
        :param 'JobDefinitionRepositoryCredentials' repository_credentials: The private repository authentication credentials to use.
        :param Sequence['JobDefinitionResourceRequirement'] resource_requirements: The type and amount of a resource to assign to a container. The only supported resource is a GPU.
        :param Sequence['JobDefinitionSecret'] secrets: The secrets to pass to the container. For more information, see [Specifying Sensitive Data](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html) in the Amazon Elastic Container Service Developer Guide.
        :param Sequence['JobDefinitionUlimit'] ulimits: A list of `ulimits` to set in the container. If a `ulimit` value is specified in a task definition, it overrides the default values set by Docker. This parameter maps to `Ulimits` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `--ulimit` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .
               
               Amazon ECS tasks hosted on Fargate use the default resource limit values set by the operating system with the exception of the nofile resource limit parameter which Fargate overrides. The `nofile` resource limit sets a restriction on the number of open files that a container can use. The default `nofile` soft limit is `1024` and the default hard limit is `65535` .
               
               This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: sudo docker version `--format '{{.Server.APIVersion}}'`
               
               > This parameter is not supported for Windows containers.
        :param builtins.str user: The user to use inside the container. This parameter maps to User in the Create a container section of the Docker Remote API and the --user option to docker run.
               
               > When running tasks using the `host` network mode, don't run containers using the `root user (UID 0)` . We recommend using a non-root user for better security. 
               
               You can specify the `user` using the following formats. If specifying a UID or GID, you must specify it as a positive integer.
               
               - `user`
               - `user:group`
               - `uid`
               - `uid:gid`
               - `user:gi`
               - `uid:group`
               
               > This parameter is not supported for Windows containers.
        """
        pulumi.set(__self__, "image", image)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if essential is not None:
            pulumi.set(__self__, "essential", essential)
        if firelens_configuration is not None:
            pulumi.set(__self__, "firelens_configuration", firelens_configuration)
        if linux_parameters is not None:
            pulumi.set(__self__, "linux_parameters", linux_parameters)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if mount_points is not None:
            pulumi.set(__self__, "mount_points", mount_points)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if readonly_root_filesystem is not None:
            pulumi.set(__self__, "readonly_root_filesystem", readonly_root_filesystem)
        if repository_credentials is not None:
            pulumi.set(__self__, "repository_credentials", repository_credentials)
        if resource_requirements is not None:
            pulumi.set(__self__, "resource_requirements", resource_requirements)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if ulimits is not None:
            pulumi.set(__self__, "ulimits", ulimits)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def image(self) -> builtins.str:
        """
        The image used to start a container. This string is passed directly to the Docker daemon. By default, images in the Docker Hub registry are available. Other repositories are specified with either `repository-url/image:tag` or `repository-url/image@digest` . Up to 255 letters (uppercase and lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter maps to `Image` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `IMAGE` parameter of the [*docker run*](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def command(self) -> Optional[Sequence[builtins.str]]:
        """
        The command that's passed to the container. This parameter maps to `Cmd` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `COMMAND` parameter to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . For more information, see [Dockerfile reference: CMD](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd) .
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.JobDefinitionTaskContainerDependency']]:
        """
        A list of containers that this container depends on.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Sequence['outputs.JobDefinitionEnvironment']]:
        """
        The environment variables to pass to a container. This parameter maps to Env in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--env` parameter to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > We don't recommend using plaintext environment variables for sensitive information, such as credential data. > Environment variables cannot start with `AWS_BATCH` . This naming convention is reserved for variables that AWS Batch sets.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def essential(self) -> Optional[builtins.bool]:
        """
        If the essential parameter of a container is marked as `true` , and that container fails or stops for any reason, all other containers that are part of the task are stopped. If the `essential` parameter of a container is marked as false, its failure doesn't affect the rest of the containers in a task. If this parameter is omitted, a container is assumed to be essential.

        All jobs must have at least one essential container. If you have an application that's composed of multiple containers, group containers that are used for a common purpose into components, and separate the different components into multiple task definitions. For more information, see [Application Architecture](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "essential")

    @property
    @pulumi.getter(name="firelensConfiguration")
    def firelens_configuration(self) -> Optional['outputs.JobDefinitionTaskContainerPropertiesFirelensConfigurationProperties']:
        """
        The FireLens configuration for the container. This is used to specify and configure a log router for container logs. For more information, see [Custom log](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html) routing in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "firelens_configuration")

    @property
    @pulumi.getter(name="linuxParameters")
    def linux_parameters(self) -> Optional['outputs.JobDefinitionLinuxParameters']:
        """
        Linux-specific modifications that are applied to the container, such as Linux kernel capabilities. For more information, see [KernelCapabilities](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html) .
        """
        return pulumi.get(self, "linux_parameters")

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional['outputs.JobDefinitionLogConfiguration']:
        """
        The log configuration specification for the container.

        This parameter maps to `LogConfig` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `--log-driver` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .

        By default, containers use the same logging driver that the Docker daemon uses. However the container can use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information about the options for different supported log drivers, see [Configure logging drivers](https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/) in the *Docker documentation* .

        > Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon (shown in the `LogConfiguration` data type). Additional log drivers may be available in future releases of the Amazon ECS container agent. 

        This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: sudo docker version `--format '{{.Server.APIVersion}}'`

        > The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "log_configuration")

    @property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> Optional[Sequence['outputs.JobDefinitionMountPoint']]:
        """
        The mount points for data volumes in your container.

        This parameter maps to `Volumes` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the [--volume](https://docs.aws.amazon.com/) option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .

        Windows containers can mount whole directories on the same drive as `$env:ProgramData` . Windows containers can't mount directories on a different drive, and mount point can't be across drives.
        """
        return pulumi.get(self, "mount_points")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of a container. The name can be used as a unique identifier to target your `dependsOn` and `Overrides` objects.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def privileged(self) -> Optional[builtins.bool]:
        """
        When this parameter is `true` , the container is given elevated privileges on the host container instance (similar to the `root` user). This parameter maps to `Privileged` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `--privileged` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .

        > This parameter is not supported for Windows containers or tasks run on Fargate.
        """
        return pulumi.get(self, "privileged")

    @property
    @pulumi.getter(name="readonlyRootFilesystem")
    def readonly_root_filesystem(self) -> Optional[builtins.bool]:
        """
        When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `--read-only` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .

        > This parameter is not supported for Windows containers.
        """
        return pulumi.get(self, "readonly_root_filesystem")

    @property
    @pulumi.getter(name="repositoryCredentials")
    def repository_credentials(self) -> Optional['outputs.JobDefinitionRepositoryCredentials']:
        """
        The private repository authentication credentials to use.
        """
        return pulumi.get(self, "repository_credentials")

    @property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> Optional[Sequence['outputs.JobDefinitionResourceRequirement']]:
        """
        The type and amount of a resource to assign to a container. The only supported resource is a GPU.
        """
        return pulumi.get(self, "resource_requirements")

    @property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.JobDefinitionSecret']]:
        """
        The secrets to pass to the container. For more information, see [Specifying Sensitive Data](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html) in the Amazon Elastic Container Service Developer Guide.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter
    def ulimits(self) -> Optional[Sequence['outputs.JobDefinitionUlimit']]:
        """
        A list of `ulimits` to set in the container. If a `ulimit` value is specified in a task definition, it overrides the default values set by Docker. This parameter maps to `Ulimits` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `--ulimit` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .

        Amazon ECS tasks hosted on Fargate use the default resource limit values set by the operating system with the exception of the nofile resource limit parameter which Fargate overrides. The `nofile` resource limit sets a restriction on the number of open files that a container can use. The default `nofile` soft limit is `1024` and the default hard limit is `65535` .

        This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: sudo docker version `--format '{{.Server.APIVersion}}'`

        > This parameter is not supported for Windows containers.
        """
        return pulumi.get(self, "ulimits")

    @property
    @pulumi.getter
    def user(self) -> Optional[builtins.str]:
        """
        The user to use inside the container. This parameter maps to User in the Create a container section of the Docker Remote API and the --user option to docker run.

        > When running tasks using the `host` network mode, don't run containers using the `root user (UID 0)` . We recommend using a non-root user for better security. 

        You can specify the `user` using the following formats. If specifying a UID or GID, you must specify it as a positive integer.

        - `user`
        - `user:group`
        - `uid`
        - `uid:gid`
        - `user:gi`
        - `uid:group`

        > This parameter is not supported for Windows containers.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class JobDefinitionTaskContainerPropertiesFirelensConfigurationProperties(dict):
    """
    The FireLens configuration for the container. This is used to specify and configure a log router for container logs. For more information, see [Custom log](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html) routing in the *Amazon Elastic Container Service Developer Guide* .
    """
    def __init__(__self__, *,
                 type: builtins.str,
                 options: Optional[Mapping[str, builtins.str]] = None):
        """
        The FireLens configuration for the container. This is used to specify and configure a log router for container logs. For more information, see [Custom log](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html) routing in the *Amazon Elastic Container Service Developer Guide* .
        """
        pulumi.set(__self__, "type", type)
        if options is not None:
            pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def options(self) -> Optional[Mapping[str, builtins.str]]:
        return pulumi.get(self, "options")


@pulumi.output_type
class JobDefinitionTmpfs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPath":
            suggest = "container_path"
        elif key == "mountOptions":
            suggest = "mount_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionTmpfs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionTmpfs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionTmpfs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_path: builtins.str,
                 size: builtins.int,
                 mount_options: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str container_path: The absolute file path in the container where the `tmpfs` volume is mounted.
        :param builtins.int size: The size (in MiB) of the `tmpfs` volume.
        :param Sequence[builtins.str] mount_options: The list of `tmpfs` volume mount options.
               
               Valid values: " `defaults` " | " `ro` " | " `rw` " | " `suid` " | " `nosuid` " | " `dev` " | " `nodev` " | " `exec` " | " `noexec` " | " `sync` " | " `async` " | " `dirsync` " | " `remount` " | " `mand` " | " `nomand` " | " `atime` " | " `noatime` " | " `diratime` " | " `nodiratime` " | " `bind` " | " `rbind" | "unbindable" | "runbindable" | "private" | "rprivate" | "shared" | "rshared" | "slave" | "rslave" | "relatime` " | " `norelatime` " | " `strictatime` " | " `nostrictatime` " | " `mode` " | " `uid` " | " `gid` " | " `nr_inodes` " | " `nr_blocks` " | " `mpol` "
        """
        pulumi.set(__self__, "container_path", container_path)
        pulumi.set(__self__, "size", size)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> builtins.str:
        """
        The absolute file path in the container where the `tmpfs` volume is mounted.
        """
        return pulumi.get(self, "container_path")

    @property
    @pulumi.getter
    def size(self) -> builtins.int:
        """
        The size (in MiB) of the `tmpfs` volume.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of `tmpfs` volume mount options.

        Valid values: " `defaults` " | " `ro` " | " `rw` " | " `suid` " | " `nosuid` " | " `dev` " | " `nodev` " | " `exec` " | " `noexec` " | " `sync` " | " `async` " | " `dirsync` " | " `remount` " | " `mand` " | " `nomand` " | " `atime` " | " `noatime` " | " `diratime` " | " `nodiratime` " | " `bind` " | " `rbind" | "unbindable" | "runbindable" | "private" | "rprivate" | "shared" | "rshared" | "slave" | "rslave" | "relatime` " | " `norelatime` " | " `strictatime` " | " `nostrictatime` " | " `mode` " | " `uid` " | " `gid` " | " `nr_inodes` " | " `nr_blocks` " | " `mpol` "
        """
        return pulumi.get(self, "mount_options")


@pulumi.output_type
class JobDefinitionUlimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hardLimit":
            suggest = "hard_limit"
        elif key == "softLimit":
            suggest = "soft_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionUlimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionUlimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionUlimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hard_limit: builtins.int,
                 name: builtins.str,
                 soft_limit: builtins.int):
        """
        :param builtins.int hard_limit: The hard limit for the `ulimit` type.
        :param builtins.str name: The `type` of the `ulimit` . Valid values are: `core` | `cpu` | `data` | `fsize` | `locks` | `memlock` | `msgqueue` | `nice` | `nofile` | `nproc` | `rss` | `rtprio` | `rttime` | `sigpending` | `stack` .
        :param builtins.int soft_limit: The soft limit for the `ulimit` type.
        """
        pulumi.set(__self__, "hard_limit", hard_limit)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "soft_limit", soft_limit)

    @property
    @pulumi.getter(name="hardLimit")
    def hard_limit(self) -> builtins.int:
        """
        The hard limit for the `ulimit` type.
        """
        return pulumi.get(self, "hard_limit")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The `type` of the `ulimit` . Valid values are: `core` | `cpu` | `data` | `fsize` | `locks` | `memlock` | `msgqueue` | `nice` | `nofile` | `nproc` | `rss` | `rtprio` | `rttime` | `sigpending` | `stack` .
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="softLimit")
    def soft_limit(self) -> builtins.int:
        """
        The soft limit for the `ulimit` type.
        """
        return pulumi.get(self, "soft_limit")


@pulumi.output_type
class JobDefinitionVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "efsVolumeConfiguration":
            suggest = "efs_volume_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 efs_volume_configuration: Optional['outputs.JobDefinitionEfsVolumeConfiguration'] = None,
                 host: Optional['outputs.JobDefinitionHost'] = None,
                 name: Optional[builtins.str] = None):
        """
        :param 'JobDefinitionEfsVolumeConfiguration' efs_volume_configuration: This parameter is specified when you're using an Amazon Elastic File System file system for job storage. Jobs that are running on Fargate resources must specify a `platformVersion` of at least `1.4.0` .
        :param 'JobDefinitionHost' host: The contents of the `host` parameter determine whether your data volume persists on the host container instance and where it's stored. If the host parameter is empty, then the Docker daemon assigns a host path for your data volume. However, the data isn't guaranteed to persist after the containers that are associated with it stop running.
               
               > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
        :param builtins.str name: The name of the volume. It can be up to 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_). This name is referenced in the `sourceVolume` parameter of container definition `mountPoints` .
        """
        if efs_volume_configuration is not None:
            pulumi.set(__self__, "efs_volume_configuration", efs_volume_configuration)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="efsVolumeConfiguration")
    def efs_volume_configuration(self) -> Optional['outputs.JobDefinitionEfsVolumeConfiguration']:
        """
        This parameter is specified when you're using an Amazon Elastic File System file system for job storage. Jobs that are running on Fargate resources must specify a `platformVersion` of at least `1.4.0` .
        """
        return pulumi.get(self, "efs_volume_configuration")

    @property
    @pulumi.getter
    def host(self) -> Optional['outputs.JobDefinitionHost']:
        """
        The contents of the `host` parameter determine whether your data volume persists on the host container instance and where it's stored. If the host parameter is empty, then the Docker daemon assigns a host path for your data volume. However, the data isn't guaranteed to persist after the containers that are associated with it stop running.

        > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the volume. It can be up to 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_). This name is referenced in the `sourceVolume` parameter of container definition `mountPoints` .
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class JobQueueComputeEnvironmentOrder(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeEnvironment":
            suggest = "compute_environment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobQueueComputeEnvironmentOrder. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobQueueComputeEnvironmentOrder.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobQueueComputeEnvironmentOrder.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_environment: builtins.str,
                 order: builtins.int):
        """
        :param builtins.str compute_environment: The Amazon Resource Name (ARN) of the compute environment.
        :param builtins.int order: The order of the compute environment. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower `order` integer value is tried for job placement first.
        """
        pulumi.set(__self__, "compute_environment", compute_environment)
        pulumi.set(__self__, "order", order)

    @property
    @pulumi.getter(name="computeEnvironment")
    def compute_environment(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the compute environment.
        """
        return pulumi.get(self, "compute_environment")

    @property
    @pulumi.getter
    def order(self) -> builtins.int:
        """
        The order of the compute environment. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower `order` integer value is tried for job placement first.
        """
        return pulumi.get(self, "order")


@pulumi.output_type
class JobQueueJobStateTimeLimitAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxTimeSeconds":
            suggest = "max_time_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobQueueJobStateTimeLimitAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobQueueJobStateTimeLimitAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobQueueJobStateTimeLimitAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: 'JobQueueJobStateTimeLimitActionAction',
                 max_time_seconds: builtins.int,
                 reason: builtins.str,
                 state: 'JobQueueJobStateTimeLimitActionState'):
        """
        :param 'JobQueueJobStateTimeLimitActionAction' action: The action to take when a job is at the head of the job queue in the specified state for the specified period of time. The only supported value is `CANCEL` , which will cancel the job.
        :param builtins.int max_time_seconds: The approximate amount of time, in seconds, that must pass with the job in the specified state before the action is taken. The minimum value is 600 (10 minutes) and the maximum value is 86,400 (24 hours).
        :param builtins.str reason: The reason to log for the action being taken.
        :param 'JobQueueJobStateTimeLimitActionState' state: The state of the job needed to trigger the action. The only supported value is `RUNNABLE` .
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "max_time_seconds", max_time_seconds)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def action(self) -> 'JobQueueJobStateTimeLimitActionAction':
        """
        The action to take when a job is at the head of the job queue in the specified state for the specified period of time. The only supported value is `CANCEL` , which will cancel the job.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="maxTimeSeconds")
    def max_time_seconds(self) -> builtins.int:
        """
        The approximate amount of time, in seconds, that must pass with the job in the specified state before the action is taken. The minimum value is 600 (10 minutes) and the maximum value is 86,400 (24 hours).
        """
        return pulumi.get(self, "max_time_seconds")

    @property
    @pulumi.getter
    def reason(self) -> builtins.str:
        """
        The reason to log for the action being taken.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def state(self) -> 'JobQueueJobStateTimeLimitActionState':
        """
        The state of the job needed to trigger the action. The only supported value is `RUNNABLE` .
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class SchedulingPolicyFairsharePolicy(dict):
    """
    Fair Share Policy for the Job Queue.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeReservation":
            suggest = "compute_reservation"
        elif key == "shareDecaySeconds":
            suggest = "share_decay_seconds"
        elif key == "shareDistribution":
            suggest = "share_distribution"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchedulingPolicyFairsharePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchedulingPolicyFairsharePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchedulingPolicyFairsharePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_reservation: Optional[builtins.float] = None,
                 share_decay_seconds: Optional[builtins.float] = None,
                 share_distribution: Optional[Sequence['outputs.SchedulingPolicyShareAttributes']] = None):
        """
        Fair Share Policy for the Job Queue.
        :param builtins.float compute_reservation: A value used to reserve some of the available maximum vCPU for share identifiers that aren't already used.
               
               The reserved ratio is `( *computeReservation* /100)^ *ActiveFairShares*` where `*ActiveFairShares*` is the number of active share identifiers.
               
               For example, a `computeReservation` value of 50 indicates that AWS Batch reserves 50% of the maximum available vCPU if there's only one share identifier. It reserves 25% if there are two share identifiers. It reserves 12.5% if there are three share identifiers. A `computeReservation` value of 25 indicates that AWS Batch should reserve 25% of the maximum available vCPU if there's only one share identifier, 6.25% if there are two fair share identifiers, and 1.56% if there are three share identifiers.
               
               The minimum value is 0 and the maximum value is 99.
        :param builtins.float share_decay_seconds: The amount of time (in seconds) to use to calculate a fair-share percentage for each share identifier in use. A value of zero (0) indicates the default minimum time window (600 seconds). The maximum supported value is 604800 (1 week).
               
               The decay allows for more recently run jobs to have more weight than jobs that ran earlier. Consider adjusting this number if you have jobs that (on average) run longer than ten minutes, or a large difference in job count or job run times between share identifiers, and the allocation of resources doesn't meet your needs.
        :param Sequence['SchedulingPolicyShareAttributes'] share_distribution: List of Share Attributes
        """
        if compute_reservation is not None:
            pulumi.set(__self__, "compute_reservation", compute_reservation)
        if share_decay_seconds is not None:
            pulumi.set(__self__, "share_decay_seconds", share_decay_seconds)
        if share_distribution is not None:
            pulumi.set(__self__, "share_distribution", share_distribution)

    @property
    @pulumi.getter(name="computeReservation")
    def compute_reservation(self) -> Optional[builtins.float]:
        """
        A value used to reserve some of the available maximum vCPU for share identifiers that aren't already used.

        The reserved ratio is `( *computeReservation* /100)^ *ActiveFairShares*` where `*ActiveFairShares*` is the number of active share identifiers.

        For example, a `computeReservation` value of 50 indicates that AWS Batch reserves 50% of the maximum available vCPU if there's only one share identifier. It reserves 25% if there are two share identifiers. It reserves 12.5% if there are three share identifiers. A `computeReservation` value of 25 indicates that AWS Batch should reserve 25% of the maximum available vCPU if there's only one share identifier, 6.25% if there are two fair share identifiers, and 1.56% if there are three share identifiers.

        The minimum value is 0 and the maximum value is 99.
        """
        return pulumi.get(self, "compute_reservation")

    @property
    @pulumi.getter(name="shareDecaySeconds")
    def share_decay_seconds(self) -> Optional[builtins.float]:
        """
        The amount of time (in seconds) to use to calculate a fair-share percentage for each share identifier in use. A value of zero (0) indicates the default minimum time window (600 seconds). The maximum supported value is 604800 (1 week).

        The decay allows for more recently run jobs to have more weight than jobs that ran earlier. Consider adjusting this number if you have jobs that (on average) run longer than ten minutes, or a large difference in job count or job run times between share identifiers, and the allocation of resources doesn't meet your needs.
        """
        return pulumi.get(self, "share_decay_seconds")

    @property
    @pulumi.getter(name="shareDistribution")
    def share_distribution(self) -> Optional[Sequence['outputs.SchedulingPolicyShareAttributes']]:
        """
        List of Share Attributes
        """
        return pulumi.get(self, "share_distribution")


@pulumi.output_type
class SchedulingPolicyShareAttributes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shareIdentifier":
            suggest = "share_identifier"
        elif key == "weightFactor":
            suggest = "weight_factor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchedulingPolicyShareAttributes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchedulingPolicyShareAttributes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchedulingPolicyShareAttributes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 share_identifier: Optional[builtins.str] = None,
                 weight_factor: Optional[builtins.float] = None):
        """
        :param builtins.str share_identifier: A share identifier or share identifier prefix. If the string ends with an asterisk (*), this entry specifies the weight factor to use for share identifiers that start with that prefix. The list of share identifiers in a fair-share policy can't overlap. For example, you can't have one that specifies a `shareIdentifier` of `UserA*` and another that specifies a `shareIdentifier` of `UserA-1` .
               
               There can be no more than 500 share identifiers active in a job queue.
               
               The string is limited to 255 alphanumeric characters, and can be followed by an asterisk (*).
        :param builtins.float weight_factor: The weight factor for the share identifier. The default value is 1.0. A lower value has a higher priority for compute resources. For example, jobs that use a share identifier with a weight factor of 0.125 (1/8) get 8 times the compute resources of jobs that use a share identifier with a weight factor of 1.
               
               The smallest supported value is 0.0001, and the largest supported value is 999.9999.
        """
        if share_identifier is not None:
            pulumi.set(__self__, "share_identifier", share_identifier)
        if weight_factor is not None:
            pulumi.set(__self__, "weight_factor", weight_factor)

    @property
    @pulumi.getter(name="shareIdentifier")
    def share_identifier(self) -> Optional[builtins.str]:
        """
        A share identifier or share identifier prefix. If the string ends with an asterisk (*), this entry specifies the weight factor to use for share identifiers that start with that prefix. The list of share identifiers in a fair-share policy can't overlap. For example, you can't have one that specifies a `shareIdentifier` of `UserA*` and another that specifies a `shareIdentifier` of `UserA-1` .

        There can be no more than 500 share identifiers active in a job queue.

        The string is limited to 255 alphanumeric characters, and can be followed by an asterisk (*).
        """
        return pulumi.get(self, "share_identifier")

    @property
    @pulumi.getter(name="weightFactor")
    def weight_factor(self) -> Optional[builtins.float]:
        """
        The weight factor for the share identifier. The default value is 1.0. A lower value has a higher priority for compute resources. For example, jobs that use a share identifier with a weight factor of 0.125 (1/8) get 8 times the compute resources of jobs that use a share identifier with a weight factor of 1.

        The smallest supported value is 0.0001, and the largest supported value is 999.9999.
        """
        return pulumi.get(self, "weight_factor")


