# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetConsumableResourceResult',
    'AwaitableGetConsumableResourceResult',
    'get_consumable_resource',
    'get_consumable_resource_output',
]

@pulumi.output_type
class GetConsumableResourceResult:
    def __init__(__self__, available_quantity=None, consumable_resource_arn=None, created_at=None, in_use_quantity=None, total_quantity=None):
        if available_quantity and not isinstance(available_quantity, int):
            raise TypeError("Expected argument 'available_quantity' to be a int")
        pulumi.set(__self__, "available_quantity", available_quantity)
        if consumable_resource_arn and not isinstance(consumable_resource_arn, str):
            raise TypeError("Expected argument 'consumable_resource_arn' to be a str")
        pulumi.set(__self__, "consumable_resource_arn", consumable_resource_arn)
        if created_at and not isinstance(created_at, int):
            raise TypeError("Expected argument 'created_at' to be a int")
        pulumi.set(__self__, "created_at", created_at)
        if in_use_quantity and not isinstance(in_use_quantity, int):
            raise TypeError("Expected argument 'in_use_quantity' to be a int")
        pulumi.set(__self__, "in_use_quantity", in_use_quantity)
        if total_quantity and not isinstance(total_quantity, int):
            raise TypeError("Expected argument 'total_quantity' to be a int")
        pulumi.set(__self__, "total_quantity", total_quantity)

    @property
    @pulumi.getter(name="availableQuantity")
    def available_quantity(self) -> Optional[builtins.int]:
        """
        Available Quantity of ConsumableResource.
        """
        return pulumi.get(self, "available_quantity")

    @property
    @pulumi.getter(name="consumableResourceArn")
    def consumable_resource_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the consumable resource.
        """
        return pulumi.get(self, "consumable_resource_arn")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.int]:
        """
        The Unix timestamp (in milliseconds) for when the consumable resource was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="inUseQuantity")
    def in_use_quantity(self) -> Optional[builtins.int]:
        """
        In-use Quantity of ConsumableResource.
        """
        return pulumi.get(self, "in_use_quantity")

    @property
    @pulumi.getter(name="totalQuantity")
    def total_quantity(self) -> Optional[builtins.int]:
        """
        Total Quantity of ConsumableResource.
        """
        return pulumi.get(self, "total_quantity")


class AwaitableGetConsumableResourceResult(GetConsumableResourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConsumableResourceResult(
            available_quantity=self.available_quantity,
            consumable_resource_arn=self.consumable_resource_arn,
            created_at=self.created_at,
            in_use_quantity=self.in_use_quantity,
            total_quantity=self.total_quantity)


def get_consumable_resource(consumable_resource_arn: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConsumableResourceResult:
    """
    Resource Type definition for AWS::Batch::ConsumableResource


    :param builtins.str consumable_resource_arn: The Amazon Resource Name (ARN) of the consumable resource.
    """
    __args__ = dict()
    __args__['consumableResourceArn'] = consumable_resource_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:batch:getConsumableResource', __args__, opts=opts, typ=GetConsumableResourceResult).value

    return AwaitableGetConsumableResourceResult(
        available_quantity=pulumi.get(__ret__, 'available_quantity'),
        consumable_resource_arn=pulumi.get(__ret__, 'consumable_resource_arn'),
        created_at=pulumi.get(__ret__, 'created_at'),
        in_use_quantity=pulumi.get(__ret__, 'in_use_quantity'),
        total_quantity=pulumi.get(__ret__, 'total_quantity'))
def get_consumable_resource_output(consumable_resource_arn: Optional[pulumi.Input[builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConsumableResourceResult]:
    """
    Resource Type definition for AWS::Batch::ConsumableResource


    :param builtins.str consumable_resource_arn: The Amazon Resource Name (ARN) of the consumable resource.
    """
    __args__ = dict()
    __args__['consumableResourceArn'] = consumable_resource_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:batch:getConsumableResource', __args__, opts=opts, typ=GetConsumableResourceResult)
    return __ret__.apply(lambda __response__: GetConsumableResourceResult(
        available_quantity=pulumi.get(__response__, 'available_quantity'),
        consumable_resource_arn=pulumi.get(__response__, 'consumable_resource_arn'),
        created_at=pulumi.get(__response__, 'created_at'),
        in_use_quantity=pulumi.get(__response__, 'in_use_quantity'),
        total_quantity=pulumi.get(__response__, 'total_quantity')))
