# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = ['ConsumableResourceArgs', 'ConsumableResource']

@pulumi.input_type
class ConsumableResourceArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input['ConsumableResourceResourceType'],
                 total_quantity: pulumi.Input[builtins.int],
                 consumable_resource_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ConsumableResource resource.
        :param pulumi.Input['ConsumableResourceResourceType'] resource_type: Indicates whether the resource is available to be re-used after a job completes. Can be one of:
               
               - `REPLENISHABLE`
               - `NON_REPLENISHABLE`
        :param pulumi.Input[builtins.int] total_quantity: Total Quantity of ConsumableResource.
        :param pulumi.Input[builtins.str] consumable_resource_name: Name of ConsumableResource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A key-value pair to associate with a resource.
        """
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "total_quantity", total_quantity)
        if consumable_resource_name is not None:
            pulumi.set(__self__, "consumable_resource_name", consumable_resource_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input['ConsumableResourceResourceType']:
        """
        Indicates whether the resource is available to be re-used after a job completes. Can be one of:

        - `REPLENISHABLE`
        - `NON_REPLENISHABLE`
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input['ConsumableResourceResourceType']):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="totalQuantity")
    def total_quantity(self) -> pulumi.Input[builtins.int]:
        """
        Total Quantity of ConsumableResource.
        """
        return pulumi.get(self, "total_quantity")

    @total_quantity.setter
    def total_quantity(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "total_quantity", value)

    @property
    @pulumi.getter(name="consumableResourceName")
    def consumable_resource_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of ConsumableResource.
        """
        return pulumi.get(self, "consumable_resource_name")

    @consumable_resource_name.setter
    def consumable_resource_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "consumable_resource_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A key-value pair to associate with a resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:batch:ConsumableResource")
class ConsumableResource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consumable_resource_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input['ConsumableResourceResourceType']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 total_quantity: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Batch::ConsumableResource

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] consumable_resource_name: Name of ConsumableResource.
        :param pulumi.Input['ConsumableResourceResourceType'] resource_type: Indicates whether the resource is available to be re-used after a job completes. Can be one of:
               
               - `REPLENISHABLE`
               - `NON_REPLENISHABLE`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A key-value pair to associate with a resource.
        :param pulumi.Input[builtins.int] total_quantity: Total Quantity of ConsumableResource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConsumableResourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Batch::ConsumableResource

        :param str resource_name: The name of the resource.
        :param ConsumableResourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConsumableResourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consumable_resource_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input['ConsumableResourceResourceType']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 total_quantity: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConsumableResourceArgs.__new__(ConsumableResourceArgs)

            __props__.__dict__["consumable_resource_name"] = consumable_resource_name
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["tags"] = tags
            if total_quantity is None and not opts.urn:
                raise TypeError("Missing required property 'total_quantity'")
            __props__.__dict__["total_quantity"] = total_quantity
            __props__.__dict__["available_quantity"] = None
            __props__.__dict__["consumable_resource_arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["in_use_quantity"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["consumableResourceName", "resourceType", "tags.*"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ConsumableResource, __self__).__init__(
            'aws-native:batch:ConsumableResource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ConsumableResource':
        """
        Get an existing ConsumableResource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ConsumableResourceArgs.__new__(ConsumableResourceArgs)

        __props__.__dict__["available_quantity"] = None
        __props__.__dict__["consumable_resource_arn"] = None
        __props__.__dict__["consumable_resource_name"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["in_use_quantity"] = None
        __props__.__dict__["resource_type"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["total_quantity"] = None
        return ConsumableResource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availableQuantity")
    def available_quantity(self) -> pulumi.Output[builtins.int]:
        """
        Available Quantity of ConsumableResource.
        """
        return pulumi.get(self, "available_quantity")

    @property
    @pulumi.getter(name="consumableResourceArn")
    def consumable_resource_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the consumable resource.
        """
        return pulumi.get(self, "consumable_resource_arn")

    @property
    @pulumi.getter(name="consumableResourceName")
    def consumable_resource_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of ConsumableResource.
        """
        return pulumi.get(self, "consumable_resource_name")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.int]:
        """
        The Unix timestamp (in milliseconds) for when the consumable resource was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="inUseQuantity")
    def in_use_quantity(self) -> pulumi.Output[builtins.int]:
        """
        In-use Quantity of ConsumableResource.
        """
        return pulumi.get(self, "in_use_quantity")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output['ConsumableResourceResourceType']:
        """
        Indicates whether the resource is available to be re-used after a job completes. Can be one of:

        - `REPLENISHABLE`
        - `NON_REPLENISHABLE`
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A key-value pair to associate with a resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="totalQuantity")
    def total_quantity(self) -> pulumi.Output[builtins.int]:
        """
        Total Quantity of ConsumableResource.
        """
        return pulumi.get(self, "total_quantity")

