# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ComputeEnvironmentComputeResourcesArgs',
    'ComputeEnvironmentComputeResourcesArgsDict',
    'ComputeEnvironmentEc2ConfigurationObjectArgs',
    'ComputeEnvironmentEc2ConfigurationObjectArgsDict',
    'ComputeEnvironmentEksConfigurationArgs',
    'ComputeEnvironmentEksConfigurationArgsDict',
    'ComputeEnvironmentLaunchTemplateSpecificationOverrideArgs',
    'ComputeEnvironmentLaunchTemplateSpecificationOverrideArgsDict',
    'ComputeEnvironmentLaunchTemplateSpecificationArgs',
    'ComputeEnvironmentLaunchTemplateSpecificationArgsDict',
    'ComputeEnvironmentUpdatePolicyArgs',
    'ComputeEnvironmentUpdatePolicyArgsDict',
    'JobDefinitionConsumableResourcePropertiesArgs',
    'JobDefinitionConsumableResourcePropertiesArgsDict',
    'JobDefinitionConsumableResourceRequirementArgs',
    'JobDefinitionConsumableResourceRequirementArgsDict',
    'JobDefinitionContainerPropertiesFargatePlatformConfigurationPropertiesArgs',
    'JobDefinitionContainerPropertiesFargatePlatformConfigurationPropertiesArgsDict',
    'JobDefinitionContainerPropertiesArgs',
    'JobDefinitionContainerPropertiesArgsDict',
    'JobDefinitionDeviceArgs',
    'JobDefinitionDeviceArgsDict',
    'JobDefinitionEcsPropertiesArgs',
    'JobDefinitionEcsPropertiesArgsDict',
    'JobDefinitionEcsTaskPropertiesArgs',
    'JobDefinitionEcsTaskPropertiesArgsDict',
    'JobDefinitionEfsAuthorizationConfigArgs',
    'JobDefinitionEfsAuthorizationConfigArgsDict',
    'JobDefinitionEfsVolumeConfigurationArgs',
    'JobDefinitionEfsVolumeConfigurationArgsDict',
    'JobDefinitionEksContainerEnvironmentVariableArgs',
    'JobDefinitionEksContainerEnvironmentVariableArgsDict',
    'JobDefinitionEksContainerResourceRequirementsArgs',
    'JobDefinitionEksContainerResourceRequirementsArgsDict',
    'JobDefinitionEksContainerSecurityContextArgs',
    'JobDefinitionEksContainerSecurityContextArgsDict',
    'JobDefinitionEksContainerVolumeMountArgs',
    'JobDefinitionEksContainerVolumeMountArgsDict',
    'JobDefinitionEksContainerArgs',
    'JobDefinitionEksContainerArgsDict',
    'JobDefinitionEksEmptyDirArgs',
    'JobDefinitionEksEmptyDirArgsDict',
    'JobDefinitionEksHostPathArgs',
    'JobDefinitionEksHostPathArgsDict',
    'JobDefinitionEksMetadataArgs',
    'JobDefinitionEksMetadataArgsDict',
    'JobDefinitionEksPersistentVolumeClaimArgs',
    'JobDefinitionEksPersistentVolumeClaimArgsDict',
    'JobDefinitionEksPodPropertiesArgs',
    'JobDefinitionEksPodPropertiesArgsDict',
    'JobDefinitionEksPropertiesArgs',
    'JobDefinitionEksPropertiesArgsDict',
    'JobDefinitionEksSecretArgs',
    'JobDefinitionEksSecretArgsDict',
    'JobDefinitionEksVolumeArgs',
    'JobDefinitionEksVolumeArgsDict',
    'JobDefinitionEnvironmentArgs',
    'JobDefinitionEnvironmentArgsDict',
    'JobDefinitionEphemeralStorageArgs',
    'JobDefinitionEphemeralStorageArgsDict',
    'JobDefinitionEvaluateOnExitArgs',
    'JobDefinitionEvaluateOnExitArgsDict',
    'JobDefinitionHostArgs',
    'JobDefinitionHostArgsDict',
    'JobDefinitionImagePullSecretArgs',
    'JobDefinitionImagePullSecretArgsDict',
    'JobDefinitionJobTimeoutArgs',
    'JobDefinitionJobTimeoutArgsDict',
    'JobDefinitionLinuxParametersArgs',
    'JobDefinitionLinuxParametersArgsDict',
    'JobDefinitionLogConfigurationArgs',
    'JobDefinitionLogConfigurationArgsDict',
    'JobDefinitionMountPointArgs',
    'JobDefinitionMountPointArgsDict',
    'JobDefinitionMultiNodeContainerPropertiesArgs',
    'JobDefinitionMultiNodeContainerPropertiesArgsDict',
    'JobDefinitionMultiNodeEcsPropertiesArgs',
    'JobDefinitionMultiNodeEcsPropertiesArgsDict',
    'JobDefinitionMultiNodeEcsTaskPropertiesArgs',
    'JobDefinitionMultiNodeEcsTaskPropertiesArgsDict',
    'JobDefinitionNetworkConfigurationArgs',
    'JobDefinitionNetworkConfigurationArgsDict',
    'JobDefinitionNodePropertiesArgs',
    'JobDefinitionNodePropertiesArgsDict',
    'JobDefinitionNodeRangePropertyArgs',
    'JobDefinitionNodeRangePropertyArgsDict',
    'JobDefinitionRepositoryCredentialsArgs',
    'JobDefinitionRepositoryCredentialsArgsDict',
    'JobDefinitionResourceRequirementArgs',
    'JobDefinitionResourceRequirementArgsDict',
    'JobDefinitionRetryStrategyArgs',
    'JobDefinitionRetryStrategyArgsDict',
    'JobDefinitionRuntimePlatformArgs',
    'JobDefinitionRuntimePlatformArgsDict',
    'JobDefinitionSecretArgs',
    'JobDefinitionSecretArgsDict',
    'JobDefinitionTaskContainerDependencyArgs',
    'JobDefinitionTaskContainerDependencyArgsDict',
    'JobDefinitionTaskContainerPropertiesFirelensConfigurationPropertiesArgs',
    'JobDefinitionTaskContainerPropertiesFirelensConfigurationPropertiesArgsDict',
    'JobDefinitionTaskContainerPropertiesArgs',
    'JobDefinitionTaskContainerPropertiesArgsDict',
    'JobDefinitionTmpfsArgs',
    'JobDefinitionTmpfsArgsDict',
    'JobDefinitionUlimitArgs',
    'JobDefinitionUlimitArgsDict',
    'JobDefinitionVolumeArgs',
    'JobDefinitionVolumeArgsDict',
    'JobQueueComputeEnvironmentOrderArgs',
    'JobQueueComputeEnvironmentOrderArgsDict',
    'JobQueueJobStateTimeLimitActionArgs',
    'JobQueueJobStateTimeLimitActionArgsDict',
    'SchedulingPolicyFairsharePolicyArgs',
    'SchedulingPolicyFairsharePolicyArgsDict',
    'SchedulingPolicyShareAttributesArgs',
    'SchedulingPolicyShareAttributesArgsDict',
]

MYPY = False

if not MYPY:
    class ComputeEnvironmentComputeResourcesArgsDict(TypedDict):
        maxv_cpus: pulumi.Input[builtins.int]
        """
        The maximum number of Amazon EC2 vCPUs that an environment can reach.

        > With `BEST_FIT_PROGRESSIVE` , `SPOT_CAPACITY_OPTIMIZED` and `SPOT_PRICE_CAPACITY_OPTIMIZED` (recommended) strategies using On-Demand or Spot Instances, and the `BEST_FIT` strategy using Spot Instances, AWS Batch might need to exceed `maxvCpus` to meet your capacity requirements. In this event, AWS Batch never exceeds `maxvCpus` by more than a single instance.
        """
        subnets: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The VPC subnets where the compute resources are launched. Fargate compute resources can contain up to 16 subnets. For Fargate compute resources, providing an empty list will be handled as if this parameter wasn't specified and no change is made. For Amazon EC2 compute resources, providing an empty list removes the VPC subnets from the compute resource. For more information, see [VPCs and subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) in the *Amazon VPC User Guide* .

        When updating a compute environment, changing the VPC subnets requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > AWS Batch on Amazon EC2 and AWS Batch on Amazon EKS support Local Zones. For more information, see [Local Zones](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-local-zones) in the *Amazon EC2 User Guide for Linux Instances* , [Amazon EKS and AWS Local Zones](https://docs.aws.amazon.com/eks/latest/userguide/local-zones.html) in the *Amazon EKS User Guide* and [Amazon ECS clusters in Local Zones, Wavelength Zones, and AWS Outposts](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-regions-zones.html#clusters-local-zones) in the *Amazon ECS Developer Guide* .
        > 
        > AWS Batch on Fargate doesn't currently support Local Zones.
        """
        type: pulumi.Input[builtins.str]
        """
        The type of compute environment: `EC2` , `SPOT` , `FARGATE` , or `FARGATE_SPOT` . For more information, see [Compute environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the *AWS Batch User Guide* .

        If you choose `SPOT` , you must also specify an Amazon EC2 Spot Fleet role with the `spotIamFleetRole` parameter. For more information, see [Amazon EC2 spot fleet role](https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html) in the *AWS Batch User Guide* .

        When updating compute environment, changing the type of a compute environment requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        When updating the type of a compute environment, changing between `EC2` and `SPOT` or between `FARGATE` and `FARGATE_SPOT` will initiate an infrastructure update, but if you switch between `EC2` and `FARGATE` , AWS CloudFormation will create a new compute environment.
        """
        allocation_strategy: NotRequired[pulumi.Input[builtins.str]]
        """
        The allocation strategy to use for the compute resource if not enough instances of the best fitting instance type can be allocated. This might be because of availability of the instance type in the Region or [Amazon EC2 service limits](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html) . For more information, see [Allocation strategies](https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html) in the *AWS Batch User Guide* .

        When updating a compute environment, changing the allocation strategy requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* . `BEST_FIT` is not supported when updating a compute environment.

        > This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified. 

        - **BEST_FIT (default)** - AWS Batch selects an instance type that best fits the needs of the jobs with a preference for the lowest-cost instance type. If additional instances of the selected instance type aren't available, AWS Batch waits for the additional instances to be available. If there aren't enough instances available, or if the user is reaching [Amazon EC2 service limits](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html) then additional jobs aren't run until the currently running jobs have completed. This allocation strategy keeps costs lower but can limit scaling. If you are using Spot Fleets with `BEST_FIT` then the Spot Fleet IAM role must be specified.
        - **BEST_FIT_PROGRESSIVE** - AWS Batch will select additional instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types with a lower cost per unit vCPU. If additional instances of the previously selected instance types aren't available, AWS Batch will select new instance types.
        - **SPOT_CAPACITY_OPTIMIZED** - AWS Batch will select one or more instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types that are less likely to be interrupted. This allocation strategy is only available for Spot Instance compute resources.
        - **SPOT_PRICE_CAPACITY_OPTIMIZED** - The price and capacity optimized allocation strategy looks at both price and capacity to select the Spot Instance pools that are the least likely to be interrupted and have the lowest possible price. This allocation strategy is only available for Spot Instance compute resources.

        > We recommend that you use `SPOT_PRICE_CAPACITY_OPTIMIZED` rather than `SPOT_CAPACITY_OPTIMIZED` in most instances.

        With `BEST_FIT_PROGRESSIVE` , `SPOT_CAPACITY_OPTIMIZED` , and `SPOT_PRICE_CAPACITY_OPTIMIZED` allocation strategies using On-Demand or Spot Instances, and the `BEST_FIT` strategy using Spot Instances, AWS Batch might need to go above `maxvCpus` to meet your capacity requirements. In this event, AWS Batch never exceeds `maxvCpus` by more than a single instance.
        """
        bid_percentage: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your maximum percentage is 20%, the Spot price must be less than 20% of the current On-Demand price for that Amazon EC2 instance. You always pay the lowest (market) price and never more than your maximum percentage. For most use cases, we recommend leaving this field empty.

        When updating a compute environment, changing the bid percentage requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        """
        desiredv_cpus: NotRequired[pulumi.Input[builtins.int]]
        """
        The desired number of vCPUS in the compute environment. AWS Batch modifies this value between the minimum and maximum values based on job queue demand.

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it. > AWS Batch doesn't support changing the desired number of vCPUs of an existing compute environment. Don't specify this parameter for compute environments using Amazon EKS clusters. > When you update the `desiredvCpus` setting, the value must be between the `minvCpus` and `maxvCpus` values.
        > 
        > Additionally, the updated `desiredvCpus` value must be greater than or equal to the current `desiredvCpus` value. For more information, see [Troubleshooting AWS Batch](https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#error-desired-vcpus-update) in the *AWS Batch User Guide* .
        """
        ec2_configuration: NotRequired[pulumi.Input[Sequence[pulumi.Input['ComputeEnvironmentEc2ConfigurationObjectArgsDict']]]]
        """
        Provides information used to select Amazon Machine Images (AMIs) for Amazon EC2 instances in the compute environment. If `Ec2Configuration` isn't specified, the default is `ECS_AL2` .

        When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* . To remove the Amazon EC2 configuration and any custom AMI ID specified in `imageIdOverride` , set this value to an empty string.

        One or two values can be provided.

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        """
        ec2_key_pair: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon EC2 key pair that's used for instances launched in the compute environment. You can use this key pair to log in to your instances with SSH. To remove the Amazon EC2 key pair, set this value to an empty string.

        When updating a compute environment, changing the Amazon EC2 key pair requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        """
        image_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter is overridden by the `imageIdOverride` member of the `Ec2Configuration` structure. To remove the custom AMI ID and use the default AMI ID, set this value to an empty string.

        When updating a compute environment, changing the AMI ID requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it. > The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        instance_role: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon ECS instance profile applied to Amazon EC2 instances in a compute environment. Required for Amazon EC2 instances. You can specify the short name or full Amazon Resource Name (ARN) of an instance profile. For example, `*ecsInstanceRole*` or `arn:aws:iam:: *<aws_account_id>* :instance-profile/ *ecsInstanceRole*` . For more information, see [Amazon ECS instance role](https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html) in the *AWS Batch User Guide* .

        When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        """
        instance_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The instances types that can be launched. You can specify instance families to launch any instance type within those families (for example, `c5` or `p3` ), or you can specify specific sizes within a family (such as `c5.8xlarge` ). You can also choose `optimal` to select instance types (from the C4, M4, and R4 instance families) that match the demand of your job queues.

        When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it. > When you create a compute environment, the instance types that you select for the compute environment must share the same architecture. For example, you can't mix x86 and ARM instances in the same compute environment. > Currently, `optimal` uses instance types from the C4, M4, and R4 instance families. In Regions that don't have instance types from those instance families, instance types from the C5, M5, and R5 instance families are used.
        """
        launch_template: NotRequired[pulumi.Input['ComputeEnvironmentLaunchTemplateSpecificationArgsDict']]
        """
        The launch template to use for your compute resources. Any other compute resource parameters that you specify in a [CreateComputeEnvironment](https://docs.aws.amazon.com/batch/latest/APIReference/API_CreateComputeEnvironment.html) API operation override the same parameters in the launch template. You must specify either the launch template ID or launch template name in the request, but not both. For more information, see [Launch Template Support](https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html) in the ** . Removing the launch template from a compute environment will not remove the AMI specified in the launch template. In order to update the AMI specified in a launch template, the `updateToLatestImageVersion` parameter must be set to `true` .

        When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the ** .

        > This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        minv_cpus: NotRequired[pulumi.Input[builtins.int]]
        """
        The minimum number of vCPUs that an environment should maintain (even if the compute environment is `DISABLED` ).

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        """
        placement_group: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon EC2 placement group to associate with your compute resources. If you intend to submit multi-node parallel jobs to your compute environment, you should consider creating a cluster placement group and associate it with your compute resources. This keeps your multi-node parallel job on a logical grouping of instances within a single Availability Zone with high network flow potential. For more information, see [Placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html) in the *Amazon EC2 User Guide for Linux Instances* .

        When updating a compute environment, changing the placement group requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        """
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The Amazon EC2 security groups that are associated with instances launched in the compute environment. This parameter is required for Fargate compute resources, where it can contain up to 5 security groups. For Fargate compute resources, providing an empty list is handled as if this parameter wasn't specified and no change is made. For Amazon EC2 compute resources, providing an empty list removes the security groups from the compute resource.

        When updating a compute environment, changing the Amazon EC2 security groups requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
        """
        spot_iam_fleet_role: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a `SPOT` compute environment. This role is required if the allocation strategy set to `BEST_FIT` or if the allocation strategy isn't specified. For more information, see [Amazon EC2 spot fleet role](https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it. > To tag your Spot Instances on creation, the Spot Fleet IAM role specified here must use the newer *AmazonEC2SpotFleetTaggingRole* managed policy. The previously recommended *AmazonEC2SpotFleetRole* managed policy doesn't have the required permissions to tag Spot Instances. For more information, see [Spot instances not tagged on creation](https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#spot-instance-no-tag) in the *AWS Batch User Guide* .
        """
        tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        A key-value pair to associate with a resource.
        """
        update_to_latest_image_version: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether the AMI ID is updated to the latest one that's supported by AWS Batch when the compute environment has an infrastructure update. The default value is `false` .

        > An AMI ID can either be specified in the `imageId` or `imageIdOverride` parameters or be determined by the launch template that's specified in the `launchTemplate` parameter. If an AMI ID is specified any of these ways, this parameter is ignored. For more information about to update AMI IDs during an infrastructure update, see [Updating the AMI ID](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html#updating-compute-environments-ami) in the *AWS Batch User Guide* . 

        When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
        """
elif False:
    ComputeEnvironmentComputeResourcesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ComputeEnvironmentComputeResourcesArgs:
    def __init__(__self__, *,
                 maxv_cpus: pulumi.Input[builtins.int],
                 subnets: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 type: pulumi.Input[builtins.str],
                 allocation_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 bid_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 desiredv_cpus: Optional[pulumi.Input[builtins.int]] = None,
                 ec2_configuration: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeEnvironmentEc2ConfigurationObjectArgs']]]] = None,
                 ec2_key_pair: Optional[pulumi.Input[builtins.str]] = None,
                 image_id: Optional[pulumi.Input[builtins.str]] = None,
                 instance_role: Optional[pulumi.Input[builtins.str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 launch_template: Optional[pulumi.Input['ComputeEnvironmentLaunchTemplateSpecificationArgs']] = None,
                 minv_cpus: Optional[pulumi.Input[builtins.int]] = None,
                 placement_group: Optional[pulumi.Input[builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 spot_iam_fleet_role: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 update_to_latest_image_version: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.int] maxv_cpus: The maximum number of Amazon EC2 vCPUs that an environment can reach.
               
               > With `BEST_FIT_PROGRESSIVE` , `SPOT_CAPACITY_OPTIMIZED` and `SPOT_PRICE_CAPACITY_OPTIMIZED` (recommended) strategies using On-Demand or Spot Instances, and the `BEST_FIT` strategy using Spot Instances, AWS Batch might need to exceed `maxvCpus` to meet your capacity requirements. In this event, AWS Batch never exceeds `maxvCpus` by more than a single instance.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnets: The VPC subnets where the compute resources are launched. Fargate compute resources can contain up to 16 subnets. For Fargate compute resources, providing an empty list will be handled as if this parameter wasn't specified and no change is made. For Amazon EC2 compute resources, providing an empty list removes the VPC subnets from the compute resource. For more information, see [VPCs and subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) in the *Amazon VPC User Guide* .
               
               When updating a compute environment, changing the VPC subnets requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
               
               > AWS Batch on Amazon EC2 and AWS Batch on Amazon EKS support Local Zones. For more information, see [Local Zones](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-local-zones) in the *Amazon EC2 User Guide for Linux Instances* , [Amazon EKS and AWS Local Zones](https://docs.aws.amazon.com/eks/latest/userguide/local-zones.html) in the *Amazon EKS User Guide* and [Amazon ECS clusters in Local Zones, Wavelength Zones, and AWS Outposts](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-regions-zones.html#clusters-local-zones) in the *Amazon ECS Developer Guide* .
               > 
               > AWS Batch on Fargate doesn't currently support Local Zones.
        :param pulumi.Input[builtins.str] type: The type of compute environment: `EC2` , `SPOT` , `FARGATE` , or `FARGATE_SPOT` . For more information, see [Compute environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the *AWS Batch User Guide* .
               
               If you choose `SPOT` , you must also specify an Amazon EC2 Spot Fleet role with the `spotIamFleetRole` parameter. For more information, see [Amazon EC2 spot fleet role](https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html) in the *AWS Batch User Guide* .
               
               When updating compute environment, changing the type of a compute environment requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
               
               When updating the type of a compute environment, changing between `EC2` and `SPOT` or between `FARGATE` and `FARGATE_SPOT` will initiate an infrastructure update, but if you switch between `EC2` and `FARGATE` , AWS CloudFormation will create a new compute environment.
        :param pulumi.Input[builtins.str] allocation_strategy: The allocation strategy to use for the compute resource if not enough instances of the best fitting instance type can be allocated. This might be because of availability of the instance type in the Region or [Amazon EC2 service limits](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html) . For more information, see [Allocation strategies](https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html) in the *AWS Batch User Guide* .
               
               When updating a compute environment, changing the allocation strategy requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* . `BEST_FIT` is not supported when updating a compute environment.
               
               > This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified. 
               
               - **BEST_FIT (default)** - AWS Batch selects an instance type that best fits the needs of the jobs with a preference for the lowest-cost instance type. If additional instances of the selected instance type aren't available, AWS Batch waits for the additional instances to be available. If there aren't enough instances available, or if the user is reaching [Amazon EC2 service limits](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html) then additional jobs aren't run until the currently running jobs have completed. This allocation strategy keeps costs lower but can limit scaling. If you are using Spot Fleets with `BEST_FIT` then the Spot Fleet IAM role must be specified.
               - **BEST_FIT_PROGRESSIVE** - AWS Batch will select additional instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types with a lower cost per unit vCPU. If additional instances of the previously selected instance types aren't available, AWS Batch will select new instance types.
               - **SPOT_CAPACITY_OPTIMIZED** - AWS Batch will select one or more instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types that are less likely to be interrupted. This allocation strategy is only available for Spot Instance compute resources.
               - **SPOT_PRICE_CAPACITY_OPTIMIZED** - The price and capacity optimized allocation strategy looks at both price and capacity to select the Spot Instance pools that are the least likely to be interrupted and have the lowest possible price. This allocation strategy is only available for Spot Instance compute resources.
               
               > We recommend that you use `SPOT_PRICE_CAPACITY_OPTIMIZED` rather than `SPOT_CAPACITY_OPTIMIZED` in most instances.
               
               With `BEST_FIT_PROGRESSIVE` , `SPOT_CAPACITY_OPTIMIZED` , and `SPOT_PRICE_CAPACITY_OPTIMIZED` allocation strategies using On-Demand or Spot Instances, and the `BEST_FIT` strategy using Spot Instances, AWS Batch might need to go above `maxvCpus` to meet your capacity requirements. In this event, AWS Batch never exceeds `maxvCpus` by more than a single instance.
        :param pulumi.Input[builtins.int] bid_percentage: The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your maximum percentage is 20%, the Spot price must be less than 20% of the current On-Demand price for that Amazon EC2 instance. You always pay the lowest (market) price and never more than your maximum percentage. For most use cases, we recommend leaving this field empty.
               
               When updating a compute environment, changing the bid percentage requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        :param pulumi.Input[builtins.int] desiredv_cpus: The desired number of vCPUS in the compute environment. AWS Batch modifies this value between the minimum and maximum values based on job queue demand.
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it. > AWS Batch doesn't support changing the desired number of vCPUs of an existing compute environment. Don't specify this parameter for compute environments using Amazon EKS clusters. > When you update the `desiredvCpus` setting, the value must be between the `minvCpus` and `maxvCpus` values.
               > 
               > Additionally, the updated `desiredvCpus` value must be greater than or equal to the current `desiredvCpus` value. For more information, see [Troubleshooting AWS Batch](https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#error-desired-vcpus-update) in the *AWS Batch User Guide* .
        :param pulumi.Input[Sequence[pulumi.Input['ComputeEnvironmentEc2ConfigurationObjectArgs']]] ec2_configuration: Provides information used to select Amazon Machine Images (AMIs) for Amazon EC2 instances in the compute environment. If `Ec2Configuration` isn't specified, the default is `ECS_AL2` .
               
               When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* . To remove the Amazon EC2 configuration and any custom AMI ID specified in `imageIdOverride` , set this value to an empty string.
               
               One or two values can be provided.
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        :param pulumi.Input[builtins.str] ec2_key_pair: The Amazon EC2 key pair that's used for instances launched in the compute environment. You can use this key pair to log in to your instances with SSH. To remove the Amazon EC2 key pair, set this value to an empty string.
               
               When updating a compute environment, changing the Amazon EC2 key pair requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        :param pulumi.Input[builtins.str] image_id: The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter is overridden by the `imageIdOverride` member of the `Ec2Configuration` structure. To remove the custom AMI ID and use the default AMI ID, set this value to an empty string.
               
               When updating a compute environment, changing the AMI ID requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it. > The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param pulumi.Input[builtins.str] instance_role: The Amazon ECS instance profile applied to Amazon EC2 instances in a compute environment. Required for Amazon EC2 instances. You can specify the short name or full Amazon Resource Name (ARN) of an instance profile. For example, `*ecsInstanceRole*` or `arn:aws:iam:: *<aws_account_id>* :instance-profile/ *ecsInstanceRole*` . For more information, see [Amazon ECS instance role](https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html) in the *AWS Batch User Guide* .
               
               When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] instance_types: The instances types that can be launched. You can specify instance families to launch any instance type within those families (for example, `c5` or `p3` ), or you can specify specific sizes within a family (such as `c5.8xlarge` ). You can also choose `optimal` to select instance types (from the C4, M4, and R4 instance families) that match the demand of your job queues.
               
               When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it. > When you create a compute environment, the instance types that you select for the compute environment must share the same architecture. For example, you can't mix x86 and ARM instances in the same compute environment. > Currently, `optimal` uses instance types from the C4, M4, and R4 instance families. In Regions that don't have instance types from those instance families, instance types from the C5, M5, and R5 instance families are used.
        :param pulumi.Input['ComputeEnvironmentLaunchTemplateSpecificationArgs'] launch_template: The launch template to use for your compute resources. Any other compute resource parameters that you specify in a [CreateComputeEnvironment](https://docs.aws.amazon.com/batch/latest/APIReference/API_CreateComputeEnvironment.html) API operation override the same parameters in the launch template. You must specify either the launch template ID or launch template name in the request, but not both. For more information, see [Launch Template Support](https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html) in the ** . Removing the launch template from a compute environment will not remove the AMI specified in the launch template. In order to update the AMI specified in a launch template, the `updateToLatestImageVersion` parameter must be set to `true` .
               
               When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the ** .
               
               > This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input[builtins.int] minv_cpus: The minimum number of vCPUs that an environment should maintain (even if the compute environment is `DISABLED` ).
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        :param pulumi.Input[builtins.str] placement_group: The Amazon EC2 placement group to associate with your compute resources. If you intend to submit multi-node parallel jobs to your compute environment, you should consider creating a cluster placement group and associate it with your compute resources. This keeps your multi-node parallel job on a logical grouping of instances within a single Availability Zone with high network flow potential. For more information, see [Placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html) in the *Amazon EC2 User Guide for Linux Instances* .
               
               When updating a compute environment, changing the placement group requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: The Amazon EC2 security groups that are associated with instances launched in the compute environment. This parameter is required for Fargate compute resources, where it can contain up to 5 security groups. For Fargate compute resources, providing an empty list is handled as if this parameter wasn't specified and no change is made. For Amazon EC2 compute resources, providing an empty list removes the security groups from the compute resource.
               
               When updating a compute environment, changing the Amazon EC2 security groups requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
        :param pulumi.Input[builtins.str] spot_iam_fleet_role: The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a `SPOT` compute environment. This role is required if the allocation strategy set to `BEST_FIT` or if the allocation strategy isn't specified. For more information, see [Amazon EC2 spot fleet role](https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html) in the *AWS Batch User Guide* .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it. > To tag your Spot Instances on creation, the Spot Fleet IAM role specified here must use the newer *AmazonEC2SpotFleetTaggingRole* managed policy. The previously recommended *AmazonEC2SpotFleetRole* managed policy doesn't have the required permissions to tag Spot Instances. For more information, see [Spot instances not tagged on creation](https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#spot-instance-no-tag) in the *AWS Batch User Guide* .
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A key-value pair to associate with a resource.
        :param pulumi.Input[builtins.bool] update_to_latest_image_version: Specifies whether the AMI ID is updated to the latest one that's supported by AWS Batch when the compute environment has an infrastructure update. The default value is `false` .
               
               > An AMI ID can either be specified in the `imageId` or `imageIdOverride` parameters or be determined by the launch template that's specified in the `launchTemplate` parameter. If an AMI ID is specified any of these ways, this parameter is ignored. For more information about to update AMI IDs during an infrastructure update, see [Updating the AMI ID](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html#updating-compute-environments-ami) in the *AWS Batch User Guide* . 
               
               When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
        """
        pulumi.set(__self__, "maxv_cpus", maxv_cpus)
        pulumi.set(__self__, "subnets", subnets)
        pulumi.set(__self__, "type", type)
        if allocation_strategy is not None:
            pulumi.set(__self__, "allocation_strategy", allocation_strategy)
        if bid_percentage is not None:
            pulumi.set(__self__, "bid_percentage", bid_percentage)
        if desiredv_cpus is not None:
            pulumi.set(__self__, "desiredv_cpus", desiredv_cpus)
        if ec2_configuration is not None:
            pulumi.set(__self__, "ec2_configuration", ec2_configuration)
        if ec2_key_pair is not None:
            pulumi.set(__self__, "ec2_key_pair", ec2_key_pair)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_role is not None:
            pulumi.set(__self__, "instance_role", instance_role)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if minv_cpus is not None:
            pulumi.set(__self__, "minv_cpus", minv_cpus)
        if placement_group is not None:
            pulumi.set(__self__, "placement_group", placement_group)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if spot_iam_fleet_role is not None:
            pulumi.set(__self__, "spot_iam_fleet_role", spot_iam_fleet_role)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if update_to_latest_image_version is not None:
            pulumi.set(__self__, "update_to_latest_image_version", update_to_latest_image_version)

    @property
    @pulumi.getter(name="maxvCpus")
    def maxv_cpus(self) -> pulumi.Input[builtins.int]:
        """
        The maximum number of Amazon EC2 vCPUs that an environment can reach.

        > With `BEST_FIT_PROGRESSIVE` , `SPOT_CAPACITY_OPTIMIZED` and `SPOT_PRICE_CAPACITY_OPTIMIZED` (recommended) strategies using On-Demand or Spot Instances, and the `BEST_FIT` strategy using Spot Instances, AWS Batch might need to exceed `maxvCpus` to meet your capacity requirements. In this event, AWS Batch never exceeds `maxvCpus` by more than a single instance.
        """
        return pulumi.get(self, "maxv_cpus")

    @maxv_cpus.setter
    def maxv_cpus(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "maxv_cpus", value)

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The VPC subnets where the compute resources are launched. Fargate compute resources can contain up to 16 subnets. For Fargate compute resources, providing an empty list will be handled as if this parameter wasn't specified and no change is made. For Amazon EC2 compute resources, providing an empty list removes the VPC subnets from the compute resource. For more information, see [VPCs and subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) in the *Amazon VPC User Guide* .

        When updating a compute environment, changing the VPC subnets requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > AWS Batch on Amazon EC2 and AWS Batch on Amazon EKS support Local Zones. For more information, see [Local Zones](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-local-zones) in the *Amazon EC2 User Guide for Linux Instances* , [Amazon EKS and AWS Local Zones](https://docs.aws.amazon.com/eks/latest/userguide/local-zones.html) in the *Amazon EKS User Guide* and [Amazon ECS clusters in Local Zones, Wavelength Zones, and AWS Outposts](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-regions-zones.html#clusters-local-zones) in the *Amazon ECS Developer Guide* .
        > 
        > AWS Batch on Fargate doesn't currently support Local Zones.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "subnets", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of compute environment: `EC2` , `SPOT` , `FARGATE` , or `FARGATE_SPOT` . For more information, see [Compute environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the *AWS Batch User Guide* .

        If you choose `SPOT` , you must also specify an Amazon EC2 Spot Fleet role with the `spotIamFleetRole` parameter. For more information, see [Amazon EC2 spot fleet role](https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html) in the *AWS Batch User Guide* .

        When updating compute environment, changing the type of a compute environment requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        When updating the type of a compute environment, changing between `EC2` and `SPOT` or between `FARGATE` and `FARGATE_SPOT` will initiate an infrastructure update, but if you switch between `EC2` and `FARGATE` , AWS CloudFormation will create a new compute environment.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The allocation strategy to use for the compute resource if not enough instances of the best fitting instance type can be allocated. This might be because of availability of the instance type in the Region or [Amazon EC2 service limits](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html) . For more information, see [Allocation strategies](https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html) in the *AWS Batch User Guide* .

        When updating a compute environment, changing the allocation strategy requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* . `BEST_FIT` is not supported when updating a compute environment.

        > This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified. 

        - **BEST_FIT (default)** - AWS Batch selects an instance type that best fits the needs of the jobs with a preference for the lowest-cost instance type. If additional instances of the selected instance type aren't available, AWS Batch waits for the additional instances to be available. If there aren't enough instances available, or if the user is reaching [Amazon EC2 service limits](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html) then additional jobs aren't run until the currently running jobs have completed. This allocation strategy keeps costs lower but can limit scaling. If you are using Spot Fleets with `BEST_FIT` then the Spot Fleet IAM role must be specified.
        - **BEST_FIT_PROGRESSIVE** - AWS Batch will select additional instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types with a lower cost per unit vCPU. If additional instances of the previously selected instance types aren't available, AWS Batch will select new instance types.
        - **SPOT_CAPACITY_OPTIMIZED** - AWS Batch will select one or more instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types that are less likely to be interrupted. This allocation strategy is only available for Spot Instance compute resources.
        - **SPOT_PRICE_CAPACITY_OPTIMIZED** - The price and capacity optimized allocation strategy looks at both price and capacity to select the Spot Instance pools that are the least likely to be interrupted and have the lowest possible price. This allocation strategy is only available for Spot Instance compute resources.

        > We recommend that you use `SPOT_PRICE_CAPACITY_OPTIMIZED` rather than `SPOT_CAPACITY_OPTIMIZED` in most instances.

        With `BEST_FIT_PROGRESSIVE` , `SPOT_CAPACITY_OPTIMIZED` , and `SPOT_PRICE_CAPACITY_OPTIMIZED` allocation strategies using On-Demand or Spot Instances, and the `BEST_FIT` strategy using Spot Instances, AWS Batch might need to go above `maxvCpus` to meet your capacity requirements. In this event, AWS Batch never exceeds `maxvCpus` by more than a single instance.
        """
        return pulumi.get(self, "allocation_strategy")

    @allocation_strategy.setter
    def allocation_strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allocation_strategy", value)

    @property
    @pulumi.getter(name="bidPercentage")
    def bid_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your maximum percentage is 20%, the Spot price must be less than 20% of the current On-Demand price for that Amazon EC2 instance. You always pay the lowest (market) price and never more than your maximum percentage. For most use cases, we recommend leaving this field empty.

        When updating a compute environment, changing the bid percentage requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        """
        return pulumi.get(self, "bid_percentage")

    @bid_percentage.setter
    def bid_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "bid_percentage", value)

    @property
    @pulumi.getter(name="desiredvCpus")
    def desiredv_cpus(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The desired number of vCPUS in the compute environment. AWS Batch modifies this value between the minimum and maximum values based on job queue demand.

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it. > AWS Batch doesn't support changing the desired number of vCPUs of an existing compute environment. Don't specify this parameter for compute environments using Amazon EKS clusters. > When you update the `desiredvCpus` setting, the value must be between the `minvCpus` and `maxvCpus` values.
        > 
        > Additionally, the updated `desiredvCpus` value must be greater than or equal to the current `desiredvCpus` value. For more information, see [Troubleshooting AWS Batch](https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#error-desired-vcpus-update) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "desiredv_cpus")

    @desiredv_cpus.setter
    def desiredv_cpus(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "desiredv_cpus", value)

    @property
    @pulumi.getter(name="ec2Configuration")
    def ec2_configuration(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeEnvironmentEc2ConfigurationObjectArgs']]]]:
        """
        Provides information used to select Amazon Machine Images (AMIs) for Amazon EC2 instances in the compute environment. If `Ec2Configuration` isn't specified, the default is `ECS_AL2` .

        When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* . To remove the Amazon EC2 configuration and any custom AMI ID specified in `imageIdOverride` , set this value to an empty string.

        One or two values can be provided.

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        """
        return pulumi.get(self, "ec2_configuration")

    @ec2_configuration.setter
    def ec2_configuration(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeEnvironmentEc2ConfigurationObjectArgs']]]]):
        pulumi.set(self, "ec2_configuration", value)

    @property
    @pulumi.getter(name="ec2KeyPair")
    def ec2_key_pair(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon EC2 key pair that's used for instances launched in the compute environment. You can use this key pair to log in to your instances with SSH. To remove the Amazon EC2 key pair, set this value to an empty string.

        When updating a compute environment, changing the Amazon EC2 key pair requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        """
        return pulumi.get(self, "ec2_key_pair")

    @ec2_key_pair.setter
    def ec2_key_pair(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ec2_key_pair", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter is overridden by the `imageIdOverride` member of the `Ec2Configuration` structure. To remove the custom AMI ID and use the default AMI ID, set this value to an empty string.

        When updating a compute environment, changing the AMI ID requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it. > The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="instanceRole")
    def instance_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon ECS instance profile applied to Amazon EC2 instances in a compute environment. Required for Amazon EC2 instances. You can specify the short name or full Amazon Resource Name (ARN) of an instance profile. For example, `*ecsInstanceRole*` or `arn:aws:iam:: *<aws_account_id>* :instance-profile/ *ecsInstanceRole*` . For more information, see [Amazon ECS instance role](https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html) in the *AWS Batch User Guide* .

        When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        """
        return pulumi.get(self, "instance_role")

    @instance_role.setter
    def instance_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_role", value)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The instances types that can be launched. You can specify instance families to launch any instance type within those families (for example, `c5` or `p3` ), or you can specify specific sizes within a family (such as `c5.8xlarge` ). You can also choose `optimal` to select instance types (from the C4, M4, and R4 instance families) that match the demand of your job queues.

        When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it. > When you create a compute environment, the instance types that you select for the compute environment must share the same architecture. For example, you can't mix x86 and ARM instances in the same compute environment. > Currently, `optimal` uses instance types from the C4, M4, and R4 instance families. In Regions that don't have instance types from those instance families, instance types from the C5, M5, and R5 instance families are used.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "instance_types", value)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional[pulumi.Input['ComputeEnvironmentLaunchTemplateSpecificationArgs']]:
        """
        The launch template to use for your compute resources. Any other compute resource parameters that you specify in a [CreateComputeEnvironment](https://docs.aws.amazon.com/batch/latest/APIReference/API_CreateComputeEnvironment.html) API operation override the same parameters in the launch template. You must specify either the launch template ID or launch template name in the request, but not both. For more information, see [Launch Template Support](https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html) in the ** . Removing the launch template from a compute environment will not remove the AMI specified in the launch template. In order to update the AMI specified in a launch template, the `updateToLatestImageVersion` parameter must be set to `true` .

        When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the ** .

        > This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: Optional[pulumi.Input['ComputeEnvironmentLaunchTemplateSpecificationArgs']]):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="minvCpus")
    def minv_cpus(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of vCPUs that an environment should maintain (even if the compute environment is `DISABLED` ).

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        """
        return pulumi.get(self, "minv_cpus")

    @minv_cpus.setter
    def minv_cpus(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "minv_cpus", value)

    @property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon EC2 placement group to associate with your compute resources. If you intend to submit multi-node parallel jobs to your compute environment, you should consider creating a cluster placement group and associate it with your compute resources. This keeps your multi-node parallel job on a logical grouping of instances within a single Availability Zone with high network flow potential. For more information, see [Placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html) in the *Amazon EC2 User Guide for Linux Instances* .

        When updating a compute environment, changing the placement group requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
        """
        return pulumi.get(self, "placement_group")

    @placement_group.setter
    def placement_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "placement_group", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The Amazon EC2 security groups that are associated with instances launched in the compute environment. This parameter is required for Fargate compute resources, where it can contain up to 5 security groups. For Fargate compute resources, providing an empty list is handled as if this parameter wasn't specified and no change is made. For Amazon EC2 compute resources, providing an empty list removes the security groups from the compute resource.

        When updating a compute environment, changing the Amazon EC2 security groups requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="spotIamFleetRole")
    def spot_iam_fleet_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a `SPOT` compute environment. This role is required if the allocation strategy set to `BEST_FIT` or if the allocation strategy isn't specified. For more information, see [Amazon EC2 spot fleet role](https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html) in the *AWS Batch User Guide* .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it. > To tag your Spot Instances on creation, the Spot Fleet IAM role specified here must use the newer *AmazonEC2SpotFleetTaggingRole* managed policy. The previously recommended *AmazonEC2SpotFleetRole* managed policy doesn't have the required permissions to tag Spot Instances. For more information, see [Spot instances not tagged on creation](https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#spot-instance-no-tag) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "spot_iam_fleet_role")

    @spot_iam_fleet_role.setter
    def spot_iam_fleet_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spot_iam_fleet_role", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A key-value pair to associate with a resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="updateToLatestImageVersion")
    def update_to_latest_image_version(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the AMI ID is updated to the latest one that's supported by AWS Batch when the compute environment has an infrastructure update. The default value is `false` .

        > An AMI ID can either be specified in the `imageId` or `imageIdOverride` parameters or be determined by the launch template that's specified in the `launchTemplate` parameter. If an AMI ID is specified any of these ways, this parameter is ignored. For more information about to update AMI IDs during an infrastructure update, see [Updating the AMI ID](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html#updating-compute-environments-ami) in the *AWS Batch User Guide* . 

        When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "update_to_latest_image_version")

    @update_to_latest_image_version.setter
    def update_to_latest_image_version(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "update_to_latest_image_version", value)


if not MYPY:
    class ComputeEnvironmentEc2ConfigurationObjectArgsDict(TypedDict):
        image_type: pulumi.Input[builtins.str]
        """
        The image type to match with the instance type to select an AMI. The supported values are different for `ECS` and `EKS` resources.

        - **ECS** - If the `imageIdOverride` parameter isn't specified, then a recent [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) ( `ECS_AL2` ) is used. If a new image type is specified in an update, but neither an `imageId` nor a `imageIdOverride` parameter is specified, then the latest Amazon ECS optimized AMI for that image type that's supported by AWS Batch is used.

        - **ECS_AL2** - [Amazon Linux 2](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) : Default for all non-GPU instance families.
        - **ECS_AL2_NVIDIA** - [Amazon Linux 2 (GPU)](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#gpuami) : Default for all GPU instance families (for example `P4` and `G4` ) and can be used for all non AWS Graviton-based instance types.
        - **ECS_AL2023** - [Amazon Linux 2023](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) : AWS Batch supports Amazon Linux 2023.

        > Amazon Linux 2023 does not support `A1` instances.
        - **ECS_AL1** - [Amazon Linux](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#alami) . Amazon Linux has reached the end-of-life of standard support. For more information, see [Amazon Linux AMI](https://docs.aws.amazon.com/amazon-linux-ami/) .
        - **EKS** - If the `imageIdOverride` parameter isn't specified, then a recent [Amazon EKS-optimized Amazon Linux AMI](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html) ( `EKS_AL2` ) is used. If a new image type is specified in an update, but neither an `imageId` nor a `imageIdOverride` parameter is specified, then the latest Amazon EKS optimized AMI for that image type that AWS Batch supports is used.

        - **EKS_AL2** - [Amazon Linux 2](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html) : Default for all non-GPU instance families.
        - **EKS_AL2_NVIDIA** - [Amazon Linux 2 (accelerated)](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html) : Default for all GPU instance families (for example, `P4` and `G4` ) and can be used for all non AWS Graviton-based instance types.
        """
        image_id_override: NotRequired[pulumi.Input[builtins.str]]
        """
        The AMI ID used for instances launched in the compute environment that match the image type. This setting overrides the `imageId` set in the `computeResource` object.

        > The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        image_kubernetes_version: NotRequired[pulumi.Input[builtins.str]]
        """
        The Kubernetes version for the compute environment. If you don't specify a value, the latest version that AWS Batch supports is used.
        """
elif False:
    ComputeEnvironmentEc2ConfigurationObjectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ComputeEnvironmentEc2ConfigurationObjectArgs:
    def __init__(__self__, *,
                 image_type: pulumi.Input[builtins.str],
                 image_id_override: Optional[pulumi.Input[builtins.str]] = None,
                 image_kubernetes_version: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] image_type: The image type to match with the instance type to select an AMI. The supported values are different for `ECS` and `EKS` resources.
               
               - **ECS** - If the `imageIdOverride` parameter isn't specified, then a recent [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) ( `ECS_AL2` ) is used. If a new image type is specified in an update, but neither an `imageId` nor a `imageIdOverride` parameter is specified, then the latest Amazon ECS optimized AMI for that image type that's supported by AWS Batch is used.
               
               - **ECS_AL2** - [Amazon Linux 2](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) : Default for all non-GPU instance families.
               - **ECS_AL2_NVIDIA** - [Amazon Linux 2 (GPU)](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#gpuami) : Default for all GPU instance families (for example `P4` and `G4` ) and can be used for all non AWS Graviton-based instance types.
               - **ECS_AL2023** - [Amazon Linux 2023](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) : AWS Batch supports Amazon Linux 2023.
               
               > Amazon Linux 2023 does not support `A1` instances.
               - **ECS_AL1** - [Amazon Linux](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#alami) . Amazon Linux has reached the end-of-life of standard support. For more information, see [Amazon Linux AMI](https://docs.aws.amazon.com/amazon-linux-ami/) .
               - **EKS** - If the `imageIdOverride` parameter isn't specified, then a recent [Amazon EKS-optimized Amazon Linux AMI](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html) ( `EKS_AL2` ) is used. If a new image type is specified in an update, but neither an `imageId` nor a `imageIdOverride` parameter is specified, then the latest Amazon EKS optimized AMI for that image type that AWS Batch supports is used.
               
               - **EKS_AL2** - [Amazon Linux 2](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html) : Default for all non-GPU instance families.
               - **EKS_AL2_NVIDIA** - [Amazon Linux 2 (accelerated)](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html) : Default for all GPU instance families (for example, `P4` and `G4` ) and can be used for all non AWS Graviton-based instance types.
        :param pulumi.Input[builtins.str] image_id_override: The AMI ID used for instances launched in the compute environment that match the image type. This setting overrides the `imageId` set in the `computeResource` object.
               
               > The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param pulumi.Input[builtins.str] image_kubernetes_version: The Kubernetes version for the compute environment. If you don't specify a value, the latest version that AWS Batch supports is used.
        """
        pulumi.set(__self__, "image_type", image_type)
        if image_id_override is not None:
            pulumi.set(__self__, "image_id_override", image_id_override)
        if image_kubernetes_version is not None:
            pulumi.set(__self__, "image_kubernetes_version", image_kubernetes_version)

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> pulumi.Input[builtins.str]:
        """
        The image type to match with the instance type to select an AMI. The supported values are different for `ECS` and `EKS` resources.

        - **ECS** - If the `imageIdOverride` parameter isn't specified, then a recent [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) ( `ECS_AL2` ) is used. If a new image type is specified in an update, but neither an `imageId` nor a `imageIdOverride` parameter is specified, then the latest Amazon ECS optimized AMI for that image type that's supported by AWS Batch is used.

        - **ECS_AL2** - [Amazon Linux 2](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) : Default for all non-GPU instance families.
        - **ECS_AL2_NVIDIA** - [Amazon Linux 2 (GPU)](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#gpuami) : Default for all GPU instance families (for example `P4` and `G4` ) and can be used for all non AWS Graviton-based instance types.
        - **ECS_AL2023** - [Amazon Linux 2023](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) : AWS Batch supports Amazon Linux 2023.

        > Amazon Linux 2023 does not support `A1` instances.
        - **ECS_AL1** - [Amazon Linux](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#alami) . Amazon Linux has reached the end-of-life of standard support. For more information, see [Amazon Linux AMI](https://docs.aws.amazon.com/amazon-linux-ami/) .
        - **EKS** - If the `imageIdOverride` parameter isn't specified, then a recent [Amazon EKS-optimized Amazon Linux AMI](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html) ( `EKS_AL2` ) is used. If a new image type is specified in an update, but neither an `imageId` nor a `imageIdOverride` parameter is specified, then the latest Amazon EKS optimized AMI for that image type that AWS Batch supports is used.

        - **EKS_AL2** - [Amazon Linux 2](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html) : Default for all non-GPU instance families.
        - **EKS_AL2_NVIDIA** - [Amazon Linux 2 (accelerated)](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html) : Default for all GPU instance families (for example, `P4` and `G4` ) and can be used for all non AWS Graviton-based instance types.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "image_type", value)

    @property
    @pulumi.getter(name="imageIdOverride")
    def image_id_override(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AMI ID used for instances launched in the compute environment that match the image type. This setting overrides the `imageId` set in the `computeResource` object.

        > The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "image_id_override")

    @image_id_override.setter
    def image_id_override(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_id_override", value)

    @property
    @pulumi.getter(name="imageKubernetesVersion")
    def image_kubernetes_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Kubernetes version for the compute environment. If you don't specify a value, the latest version that AWS Batch supports is used.
        """
        return pulumi.get(self, "image_kubernetes_version")

    @image_kubernetes_version.setter
    def image_kubernetes_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_kubernetes_version", value)


if not MYPY:
    class ComputeEnvironmentEksConfigurationArgsDict(TypedDict):
        eks_cluster_arn: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of the Amazon EKS cluster. An example is `arn: *aws* :eks: *us-east-1* : *123456789012* :cluster/ *ClusterForBatch*` .
        """
        kubernetes_namespace: pulumi.Input[builtins.str]
        """
        The namespace of the Amazon EKS cluster. AWS Batch manages pods in this namespace. The value can't left empty or null. It must be fewer than 64 characters long, can't be set to `default` , can't start with " `kube-` ," and must match this regular expression: `^[a-z0-9]([-a-z0-9]*[a-z0-9])?$` . For more information, see [Namespaces](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/) in the Kubernetes documentation.
        """
elif False:
    ComputeEnvironmentEksConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ComputeEnvironmentEksConfigurationArgs:
    def __init__(__self__, *,
                 eks_cluster_arn: pulumi.Input[builtins.str],
                 kubernetes_namespace: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] eks_cluster_arn: The Amazon Resource Name (ARN) of the Amazon EKS cluster. An example is `arn: *aws* :eks: *us-east-1* : *123456789012* :cluster/ *ClusterForBatch*` .
        :param pulumi.Input[builtins.str] kubernetes_namespace: The namespace of the Amazon EKS cluster. AWS Batch manages pods in this namespace. The value can't left empty or null. It must be fewer than 64 characters long, can't be set to `default` , can't start with " `kube-` ," and must match this regular expression: `^[a-z0-9]([-a-z0-9]*[a-z0-9])?$` . For more information, see [Namespaces](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/) in the Kubernetes documentation.
        """
        pulumi.set(__self__, "eks_cluster_arn", eks_cluster_arn)
        pulumi.set(__self__, "kubernetes_namespace", kubernetes_namespace)

    @property
    @pulumi.getter(name="eksClusterArn")
    def eks_cluster_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Amazon EKS cluster. An example is `arn: *aws* :eks: *us-east-1* : *123456789012* :cluster/ *ClusterForBatch*` .
        """
        return pulumi.get(self, "eks_cluster_arn")

    @eks_cluster_arn.setter
    def eks_cluster_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "eks_cluster_arn", value)

    @property
    @pulumi.getter(name="kubernetesNamespace")
    def kubernetes_namespace(self) -> pulumi.Input[builtins.str]:
        """
        The namespace of the Amazon EKS cluster. AWS Batch manages pods in this namespace. The value can't left empty or null. It must be fewer than 64 characters long, can't be set to `default` , can't start with " `kube-` ," and must match this regular expression: `^[a-z0-9]([-a-z0-9]*[a-z0-9])?$` . For more information, see [Namespaces](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/) in the Kubernetes documentation.
        """
        return pulumi.get(self, "kubernetes_namespace")

    @kubernetes_namespace.setter
    def kubernetes_namespace(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "kubernetes_namespace", value)


if not MYPY:
    class ComputeEnvironmentLaunchTemplateSpecificationOverrideArgsDict(TypedDict):
        launch_template_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the launch template.

        *Note:* If you specify the `launchTemplateId` you can't specify the `launchTemplateName` as well.
        """
        launch_template_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the launch template.

        *Note:* If you specify the `launchTemplateName` you can't specify the `launchTemplateId` as well.
        """
        target_instance_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The instance type or family that this override launch template should be applied to.

        This parameter is required when defining a launch template override.

        Information included in this parameter must meet the following requirements:

        - Must be a valid Amazon EC2 instance type or family.
        - `optimal` isn't allowed.
        - `targetInstanceTypes` can target only instance types and families that are included within the [`ComputeResource.instanceTypes`](https://docs.aws.amazon.com/batch/latest/APIReference/API_ComputeResource.html#Batch-Type-ComputeResource-instanceTypes) set. `targetInstanceTypes` doesn't need to include all of the instances from the `instanceType` set, but at least a subset. For example, if `ComputeResource.instanceTypes` includes `[m5, g5]` , `targetInstanceTypes` can include `[m5.2xlarge]` and `[m5.large]` but not `[c5.large]` .
        - `targetInstanceTypes` included within the same launch template override or across launch template overrides can't overlap for the same compute environment. For example, you can't define one launch template override to target an instance family and another define an instance type within this same family.
        """
        version: NotRequired[pulumi.Input[builtins.str]]
        """
        The version number of the launch template, `$Default` , or `$Latest` .

        If the value is `$Default` , the default version of the launch template is used. If the value is `$Latest` , the latest version of the launch template is used.

        > If the AMI ID that's used in a compute environment is from the launch template, the AMI isn't changed when the compute environment is updated. It's only changed if the `updateToLatestImageVersion` parameter for the compute environment is set to `true` . During an infrastructure update, if either `$Default` or `$Latest` is specified, AWS Batch re-evaluates the launch template version, and it might use a different version of the launch template. This is the case even if the launch template isn't specified in the update. When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* . 

        Default: `$Default`

        Latest: `$Latest`
        """
elif False:
    ComputeEnvironmentLaunchTemplateSpecificationOverrideArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ComputeEnvironmentLaunchTemplateSpecificationOverrideArgs:
    def __init__(__self__, *,
                 launch_template_id: Optional[pulumi.Input[builtins.str]] = None,
                 launch_template_name: Optional[pulumi.Input[builtins.str]] = None,
                 target_instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] launch_template_id: The ID of the launch template.
               
               *Note:* If you specify the `launchTemplateId` you can't specify the `launchTemplateName` as well.
        :param pulumi.Input[builtins.str] launch_template_name: The name of the launch template.
               
               *Note:* If you specify the `launchTemplateName` you can't specify the `launchTemplateId` as well.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_instance_types: The instance type or family that this override launch template should be applied to.
               
               This parameter is required when defining a launch template override.
               
               Information included in this parameter must meet the following requirements:
               
               - Must be a valid Amazon EC2 instance type or family.
               - `optimal` isn't allowed.
               - `targetInstanceTypes` can target only instance types and families that are included within the [`ComputeResource.instanceTypes`](https://docs.aws.amazon.com/batch/latest/APIReference/API_ComputeResource.html#Batch-Type-ComputeResource-instanceTypes) set. `targetInstanceTypes` doesn't need to include all of the instances from the `instanceType` set, but at least a subset. For example, if `ComputeResource.instanceTypes` includes `[m5, g5]` , `targetInstanceTypes` can include `[m5.2xlarge]` and `[m5.large]` but not `[c5.large]` .
               - `targetInstanceTypes` included within the same launch template override or across launch template overrides can't overlap for the same compute environment. For example, you can't define one launch template override to target an instance family and another define an instance type within this same family.
        :param pulumi.Input[builtins.str] version: The version number of the launch template, `$Default` , or `$Latest` .
               
               If the value is `$Default` , the default version of the launch template is used. If the value is `$Latest` , the latest version of the launch template is used.
               
               > If the AMI ID that's used in a compute environment is from the launch template, the AMI isn't changed when the compute environment is updated. It's only changed if the `updateToLatestImageVersion` parameter for the compute environment is set to `true` . During an infrastructure update, if either `$Default` or `$Latest` is specified, AWS Batch re-evaluates the launch template version, and it might use a different version of the launch template. This is the case even if the launch template isn't specified in the update. When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* . 
               
               Default: `$Default`
               
               Latest: `$Latest`
        """
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if target_instance_types is not None:
            pulumi.set(__self__, "target_instance_types", target_instance_types)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the launch template.

        *Note:* If you specify the `launchTemplateId` you can't specify the `launchTemplateName` as well.
        """
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "launch_template_id", value)

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the launch template.

        *Note:* If you specify the `launchTemplateName` you can't specify the `launchTemplateId` as well.
        """
        return pulumi.get(self, "launch_template_name")

    @launch_template_name.setter
    def launch_template_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "launch_template_name", value)

    @property
    @pulumi.getter(name="targetInstanceTypes")
    def target_instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The instance type or family that this override launch template should be applied to.

        This parameter is required when defining a launch template override.

        Information included in this parameter must meet the following requirements:

        - Must be a valid Amazon EC2 instance type or family.
        - `optimal` isn't allowed.
        - `targetInstanceTypes` can target only instance types and families that are included within the [`ComputeResource.instanceTypes`](https://docs.aws.amazon.com/batch/latest/APIReference/API_ComputeResource.html#Batch-Type-ComputeResource-instanceTypes) set. `targetInstanceTypes` doesn't need to include all of the instances from the `instanceType` set, but at least a subset. For example, if `ComputeResource.instanceTypes` includes `[m5, g5]` , `targetInstanceTypes` can include `[m5.2xlarge]` and `[m5.large]` but not `[c5.large]` .
        - `targetInstanceTypes` included within the same launch template override or across launch template overrides can't overlap for the same compute environment. For example, you can't define one launch template override to target an instance family and another define an instance type within this same family.
        """
        return pulumi.get(self, "target_instance_types")

    @target_instance_types.setter
    def target_instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "target_instance_types", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version number of the launch template, `$Default` , or `$Latest` .

        If the value is `$Default` , the default version of the launch template is used. If the value is `$Latest` , the latest version of the launch template is used.

        > If the AMI ID that's used in a compute environment is from the launch template, the AMI isn't changed when the compute environment is updated. It's only changed if the `updateToLatestImageVersion` parameter for the compute environment is set to `true` . During an infrastructure update, if either `$Default` or `$Latest` is specified, AWS Batch re-evaluates the launch template version, and it might use a different version of the launch template. This is the case even if the launch template isn't specified in the update. When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* . 

        Default: `$Default`

        Latest: `$Latest`
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class ComputeEnvironmentLaunchTemplateSpecificationArgsDict(TypedDict):
        launch_template_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the launch template.
        """
        launch_template_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the launch template.
        """
        overrides: NotRequired[pulumi.Input[Sequence[pulumi.Input['ComputeEnvironmentLaunchTemplateSpecificationOverrideArgsDict']]]]
        """
        A launch template to use in place of the default launch template. You must specify either the launch template ID or launch template name in the request, but not both.

        You can specify up to ten (10) launch template overrides that are associated to unique instance types or families for each compute environment.

        > To unset all override templates for a compute environment, you can pass an empty array to the [UpdateComputeEnvironment.overrides](https://docs.aws.amazon.com/batch/latest/APIReference/API_UpdateComputeEnvironment.html) parameter, or not include the `overrides` parameter when submitting the `UpdateComputeEnvironment` API operation.
        """
        version: NotRequired[pulumi.Input[builtins.str]]
        """
        The version number of the launch template, `$Default` , or `$Latest` .

        If the value is `$Default` , the default version of the launch template is used. If the value is `$Latest` , the latest version of the launch template is used.

        > If the AMI ID that's used in a compute environment is from the launch template, the AMI isn't changed when the compute environment is updated. It's only changed if the `updateToLatestImageVersion` parameter for the compute environment is set to `true` . During an infrastructure update, if either `$Default` or `$Latest` is specified, AWS Batch re-evaluates the launch template version, and it might use a different version of the launch template. This is the case even if the launch template isn't specified in the update. When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* . 

        Default: `$Default`

        Latest: `$Latest`
        """
elif False:
    ComputeEnvironmentLaunchTemplateSpecificationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ComputeEnvironmentLaunchTemplateSpecificationArgs:
    def __init__(__self__, *,
                 launch_template_id: Optional[pulumi.Input[builtins.str]] = None,
                 launch_template_name: Optional[pulumi.Input[builtins.str]] = None,
                 overrides: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeEnvironmentLaunchTemplateSpecificationOverrideArgs']]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] launch_template_id: The ID of the launch template.
        :param pulumi.Input[builtins.str] launch_template_name: The name of the launch template.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeEnvironmentLaunchTemplateSpecificationOverrideArgs']]] overrides: A launch template to use in place of the default launch template. You must specify either the launch template ID or launch template name in the request, but not both.
               
               You can specify up to ten (10) launch template overrides that are associated to unique instance types or families for each compute environment.
               
               > To unset all override templates for a compute environment, you can pass an empty array to the [UpdateComputeEnvironment.overrides](https://docs.aws.amazon.com/batch/latest/APIReference/API_UpdateComputeEnvironment.html) parameter, or not include the `overrides` parameter when submitting the `UpdateComputeEnvironment` API operation.
        :param pulumi.Input[builtins.str] version: The version number of the launch template, `$Default` , or `$Latest` .
               
               If the value is `$Default` , the default version of the launch template is used. If the value is `$Latest` , the latest version of the launch template is used.
               
               > If the AMI ID that's used in a compute environment is from the launch template, the AMI isn't changed when the compute environment is updated. It's only changed if the `updateToLatestImageVersion` parameter for the compute environment is set to `true` . During an infrastructure update, if either `$Default` or `$Latest` is specified, AWS Batch re-evaluates the launch template version, and it might use a different version of the launch template. This is the case even if the launch template isn't specified in the update. When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* . 
               
               Default: `$Default`
               
               Latest: `$Latest`
        """
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the launch template.
        """
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "launch_template_id", value)

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the launch template.
        """
        return pulumi.get(self, "launch_template_name")

    @launch_template_name.setter
    def launch_template_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "launch_template_name", value)

    @property
    @pulumi.getter
    def overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeEnvironmentLaunchTemplateSpecificationOverrideArgs']]]]:
        """
        A launch template to use in place of the default launch template. You must specify either the launch template ID or launch template name in the request, but not both.

        You can specify up to ten (10) launch template overrides that are associated to unique instance types or families for each compute environment.

        > To unset all override templates for a compute environment, you can pass an empty array to the [UpdateComputeEnvironment.overrides](https://docs.aws.amazon.com/batch/latest/APIReference/API_UpdateComputeEnvironment.html) parameter, or not include the `overrides` parameter when submitting the `UpdateComputeEnvironment` API operation.
        """
        return pulumi.get(self, "overrides")

    @overrides.setter
    def overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeEnvironmentLaunchTemplateSpecificationOverrideArgs']]]]):
        pulumi.set(self, "overrides", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version number of the launch template, `$Default` , or `$Latest` .

        If the value is `$Default` , the default version of the launch template is used. If the value is `$Latest` , the latest version of the launch template is used.

        > If the AMI ID that's used in a compute environment is from the launch template, the AMI isn't changed when the compute environment is updated. It's only changed if the `updateToLatestImageVersion` parameter for the compute environment is set to `true` . During an infrastructure update, if either `$Default` or `$Latest` is specified, AWS Batch re-evaluates the launch template version, and it might use a different version of the launch template. This is the case even if the launch template isn't specified in the update. When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *AWS Batch User Guide* . 

        Default: `$Default`

        Latest: `$Latest`
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class ComputeEnvironmentUpdatePolicyArgsDict(TypedDict):
        job_execution_timeout_minutes: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the job timeout (in minutes) when the compute environment infrastructure is updated. The default value is 30.
        """
        terminate_jobs_on_update: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether jobs are automatically terminated when the compute environment infrastructure is updated. The default value is `false` .
        """
elif False:
    ComputeEnvironmentUpdatePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ComputeEnvironmentUpdatePolicyArgs:
    def __init__(__self__, *,
                 job_execution_timeout_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 terminate_jobs_on_update: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.int] job_execution_timeout_minutes: Specifies the job timeout (in minutes) when the compute environment infrastructure is updated. The default value is 30.
        :param pulumi.Input[builtins.bool] terminate_jobs_on_update: Specifies whether jobs are automatically terminated when the compute environment infrastructure is updated. The default value is `false` .
        """
        if job_execution_timeout_minutes is not None:
            pulumi.set(__self__, "job_execution_timeout_minutes", job_execution_timeout_minutes)
        if terminate_jobs_on_update is not None:
            pulumi.set(__self__, "terminate_jobs_on_update", terminate_jobs_on_update)

    @property
    @pulumi.getter(name="jobExecutionTimeoutMinutes")
    def job_execution_timeout_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the job timeout (in minutes) when the compute environment infrastructure is updated. The default value is 30.
        """
        return pulumi.get(self, "job_execution_timeout_minutes")

    @job_execution_timeout_minutes.setter
    def job_execution_timeout_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "job_execution_timeout_minutes", value)

    @property
    @pulumi.getter(name="terminateJobsOnUpdate")
    def terminate_jobs_on_update(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether jobs are automatically terminated when the compute environment infrastructure is updated. The default value is `false` .
        """
        return pulumi.get(self, "terminate_jobs_on_update")

    @terminate_jobs_on_update.setter
    def terminate_jobs_on_update(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "terminate_jobs_on_update", value)


if not MYPY:
    class JobDefinitionConsumableResourcePropertiesArgsDict(TypedDict):
        consumable_resource_list: pulumi.Input[Sequence[pulumi.Input['JobDefinitionConsumableResourceRequirementArgsDict']]]
        """
        The list of consumable resources required by a job.
        """
elif False:
    JobDefinitionConsumableResourcePropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionConsumableResourcePropertiesArgs:
    def __init__(__self__, *,
                 consumable_resource_list: pulumi.Input[Sequence[pulumi.Input['JobDefinitionConsumableResourceRequirementArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionConsumableResourceRequirementArgs']]] consumable_resource_list: The list of consumable resources required by a job.
        """
        pulumi.set(__self__, "consumable_resource_list", consumable_resource_list)

    @property
    @pulumi.getter(name="consumableResourceList")
    def consumable_resource_list(self) -> pulumi.Input[Sequence[pulumi.Input['JobDefinitionConsumableResourceRequirementArgs']]]:
        """
        The list of consumable resources required by a job.
        """
        return pulumi.get(self, "consumable_resource_list")

    @consumable_resource_list.setter
    def consumable_resource_list(self, value: pulumi.Input[Sequence[pulumi.Input['JobDefinitionConsumableResourceRequirementArgs']]]):
        pulumi.set(self, "consumable_resource_list", value)


if not MYPY:
    class JobDefinitionConsumableResourceRequirementArgsDict(TypedDict):
        consumable_resource: pulumi.Input[builtins.str]
        """
        The ARN of the consumable resource the job definition should consume.
        """
        quantity: pulumi.Input[builtins.int]
        """
        The quantity of the consumable resource that is needed.
        """
elif False:
    JobDefinitionConsumableResourceRequirementArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionConsumableResourceRequirementArgs:
    def __init__(__self__, *,
                 consumable_resource: pulumi.Input[builtins.str],
                 quantity: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.str] consumable_resource: The ARN of the consumable resource the job definition should consume.
        :param pulumi.Input[builtins.int] quantity: The quantity of the consumable resource that is needed.
        """
        pulumi.set(__self__, "consumable_resource", consumable_resource)
        pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter(name="consumableResource")
    def consumable_resource(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the consumable resource the job definition should consume.
        """
        return pulumi.get(self, "consumable_resource")

    @consumable_resource.setter
    def consumable_resource(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "consumable_resource", value)

    @property
    @pulumi.getter
    def quantity(self) -> pulumi.Input[builtins.int]:
        """
        The quantity of the consumable resource that is needed.
        """
        return pulumi.get(self, "quantity")

    @quantity.setter
    def quantity(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "quantity", value)


if not MYPY:
    class JobDefinitionContainerPropertiesFargatePlatformConfigurationPropertiesArgsDict(TypedDict):
        """
        The platform configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2 resources must not specify this parameter.
        """
        platform_version: NotRequired[pulumi.Input[builtins.str]]
elif False:
    JobDefinitionContainerPropertiesFargatePlatformConfigurationPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionContainerPropertiesFargatePlatformConfigurationPropertiesArgs:
    def __init__(__self__, *,
                 platform_version: Optional[pulumi.Input[builtins.str]] = None):
        """
        The platform configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2 resources must not specify this parameter.
        """
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "platform_version")

    @platform_version.setter
    def platform_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "platform_version", value)


if not MYPY:
    class JobDefinitionContainerPropertiesArgsDict(TypedDict):
        image: pulumi.Input[builtins.str]
        """
        Required. The image used to start a container. This string is passed directly to the Docker daemon. Images in the Docker Hub registry are available by default. Other repositories are specified with `*repository-url* / *image* : *tag*` . It can be 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), underscores (_), colons (:), periods (.), forward slashes (/), and number signs (#). This parameter maps to `Image` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `IMAGE` parameter of [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > Docker image architecture must match the processor architecture of the compute resources that they're scheduled on. For example, ARM-based Docker images can only run on ARM-based compute resources. 

        - Images in Amazon ECR Public repositories use the full `registry/repository[:tag]` or `registry/repository[@digest]` naming conventions. For example, `public.ecr.aws/ *registry_alias* / *my-web-app* : *latest*` .
        - Images in Amazon ECR repositories use the full registry and repository URI (for example, `123456789012.dkr.ecr.<region-name>.amazonaws.com/<repository-name>` ).
        - Images in official repositories on Docker Hub use a single name (for example, `ubuntu` or `mongo` ).
        - Images in other repositories on Docker Hub are qualified with an organization name (for example, `amazon/amazon-ecs-agent` ).
        - Images in other online repositories are qualified further by a domain name (for example, `quay.io/assemblyline/ubuntu` ).
        """
        command: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The command that's passed to the container. This parameter maps to `Cmd` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `COMMAND` parameter to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . For more information, see [https://docs.docker.com/engine/reference/builder/#cmd](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd) .
        """
        enable_execute_command: NotRequired[pulumi.Input[builtins.bool]]
        """
        Determines whether execute command functionality is turned on for this task. If `true` , execute command functionality is turned on all the containers in the task.
        """
        environment: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEnvironmentArgsDict']]]]
        """
        The environment variables to pass to a container. This parameter maps to `Env` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--env` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > We don't recommend using plaintext environment variables for sensitive information, such as credential data. > Environment variables cannot start with " `AWS_BATCH` ". This naming convention is reserved for variables that AWS Batch sets.
        """
        ephemeral_storage: NotRequired[pulumi.Input['JobDefinitionEphemeralStorageArgsDict']]
        """
        The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
        """
        execution_role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [AWS Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *AWS Batch User Guide* .
        """
        fargate_platform_configuration: NotRequired[pulumi.Input['JobDefinitionContainerPropertiesFargatePlatformConfigurationPropertiesArgsDict']]
        """
        The platform configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2 resources must not specify this parameter.
        """
        job_role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions. For more information, see [IAM roles for tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        linux_parameters: NotRequired[pulumi.Input['JobDefinitionLinuxParametersArgsDict']]
        """
        Linux-specific modifications that are applied to the container, such as details for device mappings.
        """
        log_configuration: NotRequired[pulumi.Input['JobDefinitionLogConfigurationArgsDict']]
        """
        The log configuration specification for the container.

        This parameter maps to `LogConfig` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--log-driver` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . By default, containers use the same logging driver that the Docker daemon uses. However the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see [Configure logging drivers](https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/) in the Docker documentation.

        > AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the [LogConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html) data type). 

        This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`

        > The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        memory: NotRequired[pulumi.Input[builtins.int]]
        """
        This parameter is deprecated, use `resourceRequirements` to specify the memory requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs that run on Amazon EC2 resources, it specifies the memory hard limit (in MiB) for a container. If your container attempts to exceed the specified number, it's terminated. You must specify at least 4 MiB of memory for a job using this parameter. The memory hard limit can be specified in several places. It must be specified for each node at least once.
        """
        mount_points: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionMountPointArgsDict']]]]
        """
        The mount points for data volumes in your container. This parameter maps to `Volumes` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--volume` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
        """
        network_configuration: NotRequired[pulumi.Input['JobDefinitionNetworkConfigurationArgsDict']]
        """
        The network configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2 resources must not specify this parameter.
        """
        privileged: NotRequired[pulumi.Input[builtins.bool]]
        """
        When this parameter is true, the container is given elevated permissions on the host container instance (similar to the `root` user). This parameter maps to `Privileged` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--privileged` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . The default value is false.

        > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided, or specified as false.
        """
        readonly_root_filesystem: NotRequired[pulumi.Input[builtins.bool]]
        """
        When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--read-only` option to `docker run` .
        """
        repository_credentials: NotRequired[pulumi.Input['JobDefinitionRepositoryCredentialsArgsDict']]
        """
        The private repository authentication credentials to use.
        """
        resource_requirements: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionResourceRequirementArgsDict']]]]
        """
        The type and amount of resources to assign to a container. The supported resources include `GPU` , `MEMORY` , and `VCPU` .
        """
        runtime_platform: NotRequired[pulumi.Input['JobDefinitionRuntimePlatformArgsDict']]
        """
        An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
        """
        secrets: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretArgsDict']]]]
        """
        The secrets for the container. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html) in the *AWS Batch User Guide* .
        """
        ulimits: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionUlimitArgsDict']]]]
        """
        A list of `ulimits` to set in the container. This parameter maps to `Ulimits` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--ulimit` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
        """
        user: NotRequired[pulumi.Input[builtins.str]]
        """
        The user name to use inside the container. This parameter maps to `User` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--user` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
        """
        vcpus: NotRequired[pulumi.Input[builtins.int]]
        """
        This parameter is deprecated, use `resourceRequirements` to specify the vCPU requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs running on Amazon EC2 resources, it specifies the number of vCPUs reserved for the job.

        Each vCPU is equivalent to 1,024 CPU shares. This parameter maps to `CpuShares` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . The number of vCPUs must be specified but can be specified in several places. You must specify it at least once for each node.
        """
        volumes: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionVolumeArgsDict']]]]
        """
        A list of data volumes used in a job.
        """
elif False:
    JobDefinitionContainerPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionContainerPropertiesArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[builtins.str],
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 enable_execute_command: Optional[pulumi.Input[builtins.bool]] = None,
                 environment: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEnvironmentArgs']]]] = None,
                 ephemeral_storage: Optional[pulumi.Input['JobDefinitionEphemeralStorageArgs']] = None,
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 fargate_platform_configuration: Optional[pulumi.Input['JobDefinitionContainerPropertiesFargatePlatformConfigurationPropertiesArgs']] = None,
                 job_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 linux_parameters: Optional[pulumi.Input['JobDefinitionLinuxParametersArgs']] = None,
                 log_configuration: Optional[pulumi.Input['JobDefinitionLogConfigurationArgs']] = None,
                 memory: Optional[pulumi.Input[builtins.int]] = None,
                 mount_points: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionMountPointArgs']]]] = None,
                 network_configuration: Optional[pulumi.Input['JobDefinitionNetworkConfigurationArgs']] = None,
                 privileged: Optional[pulumi.Input[builtins.bool]] = None,
                 readonly_root_filesystem: Optional[pulumi.Input[builtins.bool]] = None,
                 repository_credentials: Optional[pulumi.Input['JobDefinitionRepositoryCredentialsArgs']] = None,
                 resource_requirements: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionResourceRequirementArgs']]]] = None,
                 runtime_platform: Optional[pulumi.Input['JobDefinitionRuntimePlatformArgs']] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretArgs']]]] = None,
                 ulimits: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionUlimitArgs']]]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 vcpus: Optional[pulumi.Input[builtins.int]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionVolumeArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] image: Required. The image used to start a container. This string is passed directly to the Docker daemon. Images in the Docker Hub registry are available by default. Other repositories are specified with `*repository-url* / *image* : *tag*` . It can be 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), underscores (_), colons (:), periods (.), forward slashes (/), and number signs (#). This parameter maps to `Image` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `IMAGE` parameter of [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > Docker image architecture must match the processor architecture of the compute resources that they're scheduled on. For example, ARM-based Docker images can only run on ARM-based compute resources. 
               
               - Images in Amazon ECR Public repositories use the full `registry/repository[:tag]` or `registry/repository[@digest]` naming conventions. For example, `public.ecr.aws/ *registry_alias* / *my-web-app* : *latest*` .
               - Images in Amazon ECR repositories use the full registry and repository URI (for example, `123456789012.dkr.ecr.<region-name>.amazonaws.com/<repository-name>` ).
               - Images in official repositories on Docker Hub use a single name (for example, `ubuntu` or `mongo` ).
               - Images in other repositories on Docker Hub are qualified with an organization name (for example, `amazon/amazon-ecs-agent` ).
               - Images in other online repositories are qualified further by a domain name (for example, `quay.io/assemblyline/ubuntu` ).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] command: The command that's passed to the container. This parameter maps to `Cmd` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `COMMAND` parameter to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . For more information, see [https://docs.docker.com/engine/reference/builder/#cmd](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd) .
        :param pulumi.Input[builtins.bool] enable_execute_command: Determines whether execute command functionality is turned on for this task. If `true` , execute command functionality is turned on all the containers in the task.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEnvironmentArgs']]] environment: The environment variables to pass to a container. This parameter maps to `Env` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--env` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > We don't recommend using plaintext environment variables for sensitive information, such as credential data. > Environment variables cannot start with " `AWS_BATCH` ". This naming convention is reserved for variables that AWS Batch sets.
        :param pulumi.Input['JobDefinitionEphemeralStorageArgs'] ephemeral_storage: The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
        :param pulumi.Input[builtins.str] execution_role_arn: The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [AWS Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *AWS Batch User Guide* .
        :param pulumi.Input['JobDefinitionContainerPropertiesFargatePlatformConfigurationPropertiesArgs'] fargate_platform_configuration: The platform configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2 resources must not specify this parameter.
        :param pulumi.Input[builtins.str] job_role_arn: The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions. For more information, see [IAM roles for tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param pulumi.Input['JobDefinitionLinuxParametersArgs'] linux_parameters: Linux-specific modifications that are applied to the container, such as details for device mappings.
        :param pulumi.Input['JobDefinitionLogConfigurationArgs'] log_configuration: The log configuration specification for the container.
               
               This parameter maps to `LogConfig` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--log-driver` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . By default, containers use the same logging driver that the Docker daemon uses. However the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see [Configure logging drivers](https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/) in the Docker documentation.
               
               > AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the [LogConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html) data type). 
               
               This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
               
               > The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param pulumi.Input[builtins.int] memory: This parameter is deprecated, use `resourceRequirements` to specify the memory requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs that run on Amazon EC2 resources, it specifies the memory hard limit (in MiB) for a container. If your container attempts to exceed the specified number, it's terminated. You must specify at least 4 MiB of memory for a job using this parameter. The memory hard limit can be specified in several places. It must be specified for each node at least once.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionMountPointArgs']]] mount_points: The mount points for data volumes in your container. This parameter maps to `Volumes` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--volume` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
        :param pulumi.Input['JobDefinitionNetworkConfigurationArgs'] network_configuration: The network configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2 resources must not specify this parameter.
        :param pulumi.Input[builtins.bool] privileged: When this parameter is true, the container is given elevated permissions on the host container instance (similar to the `root` user). This parameter maps to `Privileged` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--privileged` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . The default value is false.
               
               > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided, or specified as false.
        :param pulumi.Input[builtins.bool] readonly_root_filesystem: When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--read-only` option to `docker run` .
        :param pulumi.Input['JobDefinitionRepositoryCredentialsArgs'] repository_credentials: The private repository authentication credentials to use.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionResourceRequirementArgs']]] resource_requirements: The type and amount of resources to assign to a container. The supported resources include `GPU` , `MEMORY` , and `VCPU` .
        :param pulumi.Input['JobDefinitionRuntimePlatformArgs'] runtime_platform: An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretArgs']]] secrets: The secrets for the container. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html) in the *AWS Batch User Guide* .
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionUlimitArgs']]] ulimits: A list of `ulimits` to set in the container. This parameter maps to `Ulimits` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--ulimit` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
        :param pulumi.Input[builtins.str] user: The user name to use inside the container. This parameter maps to `User` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--user` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
        :param pulumi.Input[builtins.int] vcpus: This parameter is deprecated, use `resourceRequirements` to specify the vCPU requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs running on Amazon EC2 resources, it specifies the number of vCPUs reserved for the job.
               
               Each vCPU is equivalent to 1,024 CPU shares. This parameter maps to `CpuShares` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . The number of vCPUs must be specified but can be specified in several places. You must specify it at least once for each node.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionVolumeArgs']]] volumes: A list of data volumes used in a job.
        """
        pulumi.set(__self__, "image", image)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if enable_execute_command is not None:
            pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if fargate_platform_configuration is not None:
            pulumi.set(__self__, "fargate_platform_configuration", fargate_platform_configuration)
        if job_role_arn is not None:
            pulumi.set(__self__, "job_role_arn", job_role_arn)
        if linux_parameters is not None:
            pulumi.set(__self__, "linux_parameters", linux_parameters)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if mount_points is not None:
            pulumi.set(__self__, "mount_points", mount_points)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if readonly_root_filesystem is not None:
            pulumi.set(__self__, "readonly_root_filesystem", readonly_root_filesystem)
        if repository_credentials is not None:
            pulumi.set(__self__, "repository_credentials", repository_credentials)
        if resource_requirements is not None:
            pulumi.set(__self__, "resource_requirements", resource_requirements)
        if runtime_platform is not None:
            pulumi.set(__self__, "runtime_platform", runtime_platform)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if ulimits is not None:
            pulumi.set(__self__, "ulimits", ulimits)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if vcpus is not None:
            pulumi.set(__self__, "vcpus", vcpus)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[builtins.str]:
        """
        Required. The image used to start a container. This string is passed directly to the Docker daemon. Images in the Docker Hub registry are available by default. Other repositories are specified with `*repository-url* / *image* : *tag*` . It can be 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), underscores (_), colons (:), periods (.), forward slashes (/), and number signs (#). This parameter maps to `Image` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `IMAGE` parameter of [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > Docker image architecture must match the processor architecture of the compute resources that they're scheduled on. For example, ARM-based Docker images can only run on ARM-based compute resources. 

        - Images in Amazon ECR Public repositories use the full `registry/repository[:tag]` or `registry/repository[@digest]` naming conventions. For example, `public.ecr.aws/ *registry_alias* / *my-web-app* : *latest*` .
        - Images in Amazon ECR repositories use the full registry and repository URI (for example, `123456789012.dkr.ecr.<region-name>.amazonaws.com/<repository-name>` ).
        - Images in official repositories on Docker Hub use a single name (for example, `ubuntu` or `mongo` ).
        - Images in other repositories on Docker Hub are qualified with an organization name (for example, `amazon/amazon-ecs-agent` ).
        - Images in other online repositories are qualified further by a domain name (for example, `quay.io/assemblyline/ubuntu` ).
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The command that's passed to the container. This parameter maps to `Cmd` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `COMMAND` parameter to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . For more information, see [https://docs.docker.com/engine/reference/builder/#cmd](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd) .
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines whether execute command functionality is turned on for this task. If `true` , execute command functionality is turned on all the containers in the task.
        """
        return pulumi.get(self, "enable_execute_command")

    @enable_execute_command.setter
    def enable_execute_command(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_execute_command", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEnvironmentArgs']]]]:
        """
        The environment variables to pass to a container. This parameter maps to `Env` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--env` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > We don't recommend using plaintext environment variables for sensitive information, such as credential data. > Environment variables cannot start with " `AWS_BATCH` ". This naming convention is reserved for variables that AWS Batch sets.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEnvironmentArgs']]]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input['JobDefinitionEphemeralStorageArgs']]:
        """
        The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input['JobDefinitionEphemeralStorageArgs']]):
        pulumi.set(self, "ephemeral_storage", value)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [AWS Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter(name="fargatePlatformConfiguration")
    def fargate_platform_configuration(self) -> Optional[pulumi.Input['JobDefinitionContainerPropertiesFargatePlatformConfigurationPropertiesArgs']]:
        """
        The platform configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2 resources must not specify this parameter.
        """
        return pulumi.get(self, "fargate_platform_configuration")

    @fargate_platform_configuration.setter
    def fargate_platform_configuration(self, value: Optional[pulumi.Input['JobDefinitionContainerPropertiesFargatePlatformConfigurationPropertiesArgs']]):
        pulumi.set(self, "fargate_platform_configuration", value)

    @property
    @pulumi.getter(name="jobRoleArn")
    def job_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions. For more information, see [IAM roles for tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "job_role_arn")

    @job_role_arn.setter
    def job_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_role_arn", value)

    @property
    @pulumi.getter(name="linuxParameters")
    def linux_parameters(self) -> Optional[pulumi.Input['JobDefinitionLinuxParametersArgs']]:
        """
        Linux-specific modifications that are applied to the container, such as details for device mappings.
        """
        return pulumi.get(self, "linux_parameters")

    @linux_parameters.setter
    def linux_parameters(self, value: Optional[pulumi.Input['JobDefinitionLinuxParametersArgs']]):
        pulumi.set(self, "linux_parameters", value)

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional[pulumi.Input['JobDefinitionLogConfigurationArgs']]:
        """
        The log configuration specification for the container.

        This parameter maps to `LogConfig` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--log-driver` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . By default, containers use the same logging driver that the Docker daemon uses. However the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see [Configure logging drivers](https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/) in the Docker documentation.

        > AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the [LogConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html) data type). 

        This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`

        > The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "log_configuration")

    @log_configuration.setter
    def log_configuration(self, value: Optional[pulumi.Input['JobDefinitionLogConfigurationArgs']]):
        pulumi.set(self, "log_configuration", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        This parameter is deprecated, use `resourceRequirements` to specify the memory requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs that run on Amazon EC2 resources, it specifies the memory hard limit (in MiB) for a container. If your container attempts to exceed the specified number, it's terminated. You must specify at least 4 MiB of memory for a job using this parameter. The memory hard limit can be specified in several places. It must be specified for each node at least once.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionMountPointArgs']]]]:
        """
        The mount points for data volumes in your container. This parameter maps to `Volumes` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--volume` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
        """
        return pulumi.get(self, "mount_points")

    @mount_points.setter
    def mount_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionMountPointArgs']]]]):
        pulumi.set(self, "mount_points", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['JobDefinitionNetworkConfigurationArgs']]:
        """
        The network configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2 resources must not specify this parameter.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['JobDefinitionNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter
    def privileged(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When this parameter is true, the container is given elevated permissions on the host container instance (similar to the `root` user). This parameter maps to `Privileged` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--privileged` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . The default value is false.

        > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided, or specified as false.
        """
        return pulumi.get(self, "privileged")

    @privileged.setter
    def privileged(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "privileged", value)

    @property
    @pulumi.getter(name="readonlyRootFilesystem")
    def readonly_root_filesystem(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--read-only` option to `docker run` .
        """
        return pulumi.get(self, "readonly_root_filesystem")

    @readonly_root_filesystem.setter
    def readonly_root_filesystem(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "readonly_root_filesystem", value)

    @property
    @pulumi.getter(name="repositoryCredentials")
    def repository_credentials(self) -> Optional[pulumi.Input['JobDefinitionRepositoryCredentialsArgs']]:
        """
        The private repository authentication credentials to use.
        """
        return pulumi.get(self, "repository_credentials")

    @repository_credentials.setter
    def repository_credentials(self, value: Optional[pulumi.Input['JobDefinitionRepositoryCredentialsArgs']]):
        pulumi.set(self, "repository_credentials", value)

    @property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionResourceRequirementArgs']]]]:
        """
        The type and amount of resources to assign to a container. The supported resources include `GPU` , `MEMORY` , and `VCPU` .
        """
        return pulumi.get(self, "resource_requirements")

    @resource_requirements.setter
    def resource_requirements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionResourceRequirementArgs']]]]):
        pulumi.set(self, "resource_requirements", value)

    @property
    @pulumi.getter(name="runtimePlatform")
    def runtime_platform(self) -> Optional[pulumi.Input['JobDefinitionRuntimePlatformArgs']]:
        """
        An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
        """
        return pulumi.get(self, "runtime_platform")

    @runtime_platform.setter
    def runtime_platform(self, value: Optional[pulumi.Input['JobDefinitionRuntimePlatformArgs']]):
        pulumi.set(self, "runtime_platform", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretArgs']]]]:
        """
        The secrets for the container. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter
    def ulimits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionUlimitArgs']]]]:
        """
        A list of `ulimits` to set in the container. This parameter maps to `Ulimits` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--ulimit` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
        """
        return pulumi.get(self, "ulimits")

    @ulimits.setter
    def ulimits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionUlimitArgs']]]]):
        pulumi.set(self, "ulimits", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user name to use inside the container. This parameter maps to `User` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--user` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter
    def vcpus(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        This parameter is deprecated, use `resourceRequirements` to specify the vCPU requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs running on Amazon EC2 resources, it specifies the number of vCPUs reserved for the job.

        Each vCPU is equivalent to 1,024 CPU shares. This parameter maps to `CpuShares` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . The number of vCPUs must be specified but can be specified in several places. You must specify it at least once for each node.
        """
        return pulumi.get(self, "vcpus")

    @vcpus.setter
    def vcpus(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vcpus", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionVolumeArgs']]]]:
        """
        A list of data volumes used in a job.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


if not MYPY:
    class JobDefinitionDeviceArgsDict(TypedDict):
        container_path: NotRequired[pulumi.Input[builtins.str]]
        """
        The path inside the container that's used to expose the host device. By default, the `hostPath` value is used.
        """
        host_path: NotRequired[pulumi.Input[builtins.str]]
        """
        The path for the device on the host container instance.
        """
        permissions: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The explicit permissions to provide to the container for the device. By default, the container has permissions for `read` , `write` , and `mknod` for the device.
        """
elif False:
    JobDefinitionDeviceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionDeviceArgs:
    def __init__(__self__, *,
                 container_path: Optional[pulumi.Input[builtins.str]] = None,
                 host_path: Optional[pulumi.Input[builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] container_path: The path inside the container that's used to expose the host device. By default, the `hostPath` value is used.
        :param pulumi.Input[builtins.str] host_path: The path for the device on the host container instance.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permissions: The explicit permissions to provide to the container for the device. By default, the container has permissions for `read` , `write` , and `mknod` for the device.
        """
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path inside the container that's used to expose the host device. By default, the `hostPath` value is used.
        """
        return pulumi.get(self, "container_path")

    @container_path.setter
    def container_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "container_path", value)

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path for the device on the host container instance.
        """
        return pulumi.get(self, "host_path")

    @host_path.setter
    def host_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_path", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The explicit permissions to provide to the container for the device. By default, the container has permissions for `read` , `write` , and `mknod` for the device.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "permissions", value)


if not MYPY:
    class JobDefinitionEcsPropertiesArgsDict(TypedDict):
        task_properties: pulumi.Input[Sequence[pulumi.Input['JobDefinitionEcsTaskPropertiesArgsDict']]]
        """
        An object that contains the properties for the Amazon ECS task definition of a job.

        > This object is currently limited to one task element. However, the task element can run up to 10 containers.
        """
elif False:
    JobDefinitionEcsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEcsPropertiesArgs:
    def __init__(__self__, *,
                 task_properties: pulumi.Input[Sequence[pulumi.Input['JobDefinitionEcsTaskPropertiesArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEcsTaskPropertiesArgs']]] task_properties: An object that contains the properties for the Amazon ECS task definition of a job.
               
               > This object is currently limited to one task element. However, the task element can run up to 10 containers.
        """
        pulumi.set(__self__, "task_properties", task_properties)

    @property
    @pulumi.getter(name="taskProperties")
    def task_properties(self) -> pulumi.Input[Sequence[pulumi.Input['JobDefinitionEcsTaskPropertiesArgs']]]:
        """
        An object that contains the properties for the Amazon ECS task definition of a job.

        > This object is currently limited to one task element. However, the task element can run up to 10 containers.
        """
        return pulumi.get(self, "task_properties")

    @task_properties.setter
    def task_properties(self, value: pulumi.Input[Sequence[pulumi.Input['JobDefinitionEcsTaskPropertiesArgs']]]):
        pulumi.set(self, "task_properties", value)


if not MYPY:
    class JobDefinitionEcsTaskPropertiesArgsDict(TypedDict):
        containers: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionTaskContainerPropertiesArgsDict']]]]
        """
        This object is a list of containers.
        """
        enable_execute_command: NotRequired[pulumi.Input[builtins.bool]]
        """
        Determines whether execute command functionality is turned on for this task. If `true` , execute command functionality is turned on all the containers in the task.
        """
        ephemeral_storage: NotRequired[pulumi.Input['JobDefinitionEphemeralStorageArgsDict']]
        """
        The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
        """
        execution_role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [AWS Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *AWS Batch User Guide* .
        """
        ipc_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        The IPC resource namespace to use for the containers in the task. The valid values are `host` , `task` , or `none` .

        If `host` is specified, all containers within the tasks that specified the `host` IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance.

        If `task` is specified, all containers within the specified `task` share the same IPC resources.

        If `none` is specified, the IPC resources within the containers of a task are private, and are not shared with other containers in a task or on the container instance.

        If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see [IPC settings](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#ipc-settings---ipc) in the Docker run reference.
        """
        network_configuration: NotRequired[pulumi.Input['JobDefinitionNetworkConfigurationArgsDict']]
        """
        The network configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2 resources must not specify this parameter.
        """
        pid_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        The process namespace to use for the containers in the task. The valid values are `host` or `task` . For example, monitoring sidecars might need `pidMode` to access information about other containers running in the same task.

        If `host` is specified, all containers within the tasks that specified the `host` PID mode on the same container instance share the process namespace with the host Amazon EC2 instance.

        If `task` is specified, all containers within the specified task share the same process namespace.

        If no value is specified, the default is a private namespace for each container. For more information, see [PID settings](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#pid-settings---pid) in the Docker run reference.
        """
        platform_version: NotRequired[pulumi.Input[builtins.str]]
        """
        The Fargate platform version where the jobs are running. A platform version is specified only for jobs that are running on Fargate resources. If one isn't specified, the `LATEST` platform version is used by default. This uses a recent, approved version of the Fargate platform for compute resources. For more information, see [AWS Fargate platform versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        runtime_platform: NotRequired[pulumi.Input['JobDefinitionRuntimePlatformArgsDict']]
        """
        An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
        """
        task_role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) that's associated with the Amazon ECS task.

        > This is object is comparable to [ContainerProperties:jobRoleArn](https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html) .
        """
        volumes: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionVolumeArgsDict']]]]
        """
        A list of volumes that are associated with the job.
        """
elif False:
    JobDefinitionEcsTaskPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEcsTaskPropertiesArgs:
    def __init__(__self__, *,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionTaskContainerPropertiesArgs']]]] = None,
                 enable_execute_command: Optional[pulumi.Input[builtins.bool]] = None,
                 ephemeral_storage: Optional[pulumi.Input['JobDefinitionEphemeralStorageArgs']] = None,
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 ipc_mode: Optional[pulumi.Input[builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input['JobDefinitionNetworkConfigurationArgs']] = None,
                 pid_mode: Optional[pulumi.Input[builtins.str]] = None,
                 platform_version: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_platform: Optional[pulumi.Input['JobDefinitionRuntimePlatformArgs']] = None,
                 task_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionVolumeArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionTaskContainerPropertiesArgs']]] containers: This object is a list of containers.
        :param pulumi.Input[builtins.bool] enable_execute_command: Determines whether execute command functionality is turned on for this task. If `true` , execute command functionality is turned on all the containers in the task.
        :param pulumi.Input['JobDefinitionEphemeralStorageArgs'] ephemeral_storage: The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
        :param pulumi.Input[builtins.str] execution_role_arn: The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [AWS Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *AWS Batch User Guide* .
        :param pulumi.Input[builtins.str] ipc_mode: The IPC resource namespace to use for the containers in the task. The valid values are `host` , `task` , or `none` .
               
               If `host` is specified, all containers within the tasks that specified the `host` IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance.
               
               If `task` is specified, all containers within the specified `task` share the same IPC resources.
               
               If `none` is specified, the IPC resources within the containers of a task are private, and are not shared with other containers in a task or on the container instance.
               
               If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see [IPC settings](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#ipc-settings---ipc) in the Docker run reference.
        :param pulumi.Input['JobDefinitionNetworkConfigurationArgs'] network_configuration: The network configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2 resources must not specify this parameter.
        :param pulumi.Input[builtins.str] pid_mode: The process namespace to use for the containers in the task. The valid values are `host` or `task` . For example, monitoring sidecars might need `pidMode` to access information about other containers running in the same task.
               
               If `host` is specified, all containers within the tasks that specified the `host` PID mode on the same container instance share the process namespace with the host Amazon EC2 instance.
               
               If `task` is specified, all containers within the specified task share the same process namespace.
               
               If no value is specified, the default is a private namespace for each container. For more information, see [PID settings](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#pid-settings---pid) in the Docker run reference.
        :param pulumi.Input[builtins.str] platform_version: The Fargate platform version where the jobs are running. A platform version is specified only for jobs that are running on Fargate resources. If one isn't specified, the `LATEST` platform version is used by default. This uses a recent, approved version of the Fargate platform for compute resources. For more information, see [AWS Fargate platform versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param pulumi.Input['JobDefinitionRuntimePlatformArgs'] runtime_platform: An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
        :param pulumi.Input[builtins.str] task_role_arn: The Amazon Resource Name (ARN) that's associated with the Amazon ECS task.
               
               > This is object is comparable to [ContainerProperties:jobRoleArn](https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html) .
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionVolumeArgs']]] volumes: A list of volumes that are associated with the job.
        """
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if enable_execute_command is not None:
            pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if ipc_mode is not None:
            pulumi.set(__self__, "ipc_mode", ipc_mode)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if pid_mode is not None:
            pulumi.set(__self__, "pid_mode", pid_mode)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if runtime_platform is not None:
            pulumi.set(__self__, "runtime_platform", runtime_platform)
        if task_role_arn is not None:
            pulumi.set(__self__, "task_role_arn", task_role_arn)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionTaskContainerPropertiesArgs']]]]:
        """
        This object is a list of containers.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionTaskContainerPropertiesArgs']]]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines whether execute command functionality is turned on for this task. If `true` , execute command functionality is turned on all the containers in the task.
        """
        return pulumi.get(self, "enable_execute_command")

    @enable_execute_command.setter
    def enable_execute_command(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_execute_command", value)

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input['JobDefinitionEphemeralStorageArgs']]:
        """
        The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input['JobDefinitionEphemeralStorageArgs']]):
        pulumi.set(self, "ephemeral_storage", value)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [AWS Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter(name="ipcMode")
    def ipc_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IPC resource namespace to use for the containers in the task. The valid values are `host` , `task` , or `none` .

        If `host` is specified, all containers within the tasks that specified the `host` IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance.

        If `task` is specified, all containers within the specified `task` share the same IPC resources.

        If `none` is specified, the IPC resources within the containers of a task are private, and are not shared with other containers in a task or on the container instance.

        If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see [IPC settings](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#ipc-settings---ipc) in the Docker run reference.
        """
        return pulumi.get(self, "ipc_mode")

    @ipc_mode.setter
    def ipc_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipc_mode", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['JobDefinitionNetworkConfigurationArgs']]:
        """
        The network configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2 resources must not specify this parameter.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['JobDefinitionNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="pidMode")
    def pid_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The process namespace to use for the containers in the task. The valid values are `host` or `task` . For example, monitoring sidecars might need `pidMode` to access information about other containers running in the same task.

        If `host` is specified, all containers within the tasks that specified the `host` PID mode on the same container instance share the process namespace with the host Amazon EC2 instance.

        If `task` is specified, all containers within the specified task share the same process namespace.

        If no value is specified, the default is a private namespace for each container. For more information, see [PID settings](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#pid-settings---pid) in the Docker run reference.
        """
        return pulumi.get(self, "pid_mode")

    @pid_mode.setter
    def pid_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pid_mode", value)

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Fargate platform version where the jobs are running. A platform version is specified only for jobs that are running on Fargate resources. If one isn't specified, the `LATEST` platform version is used by default. This uses a recent, approved version of the Fargate platform for compute resources. For more information, see [AWS Fargate platform versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "platform_version")

    @platform_version.setter
    def platform_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "platform_version", value)

    @property
    @pulumi.getter(name="runtimePlatform")
    def runtime_platform(self) -> Optional[pulumi.Input['JobDefinitionRuntimePlatformArgs']]:
        """
        An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
        """
        return pulumi.get(self, "runtime_platform")

    @runtime_platform.setter
    def runtime_platform(self, value: Optional[pulumi.Input['JobDefinitionRuntimePlatformArgs']]):
        pulumi.set(self, "runtime_platform", value)

    @property
    @pulumi.getter(name="taskRoleArn")
    def task_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) that's associated with the Amazon ECS task.

        > This is object is comparable to [ContainerProperties:jobRoleArn](https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html) .
        """
        return pulumi.get(self, "task_role_arn")

    @task_role_arn.setter
    def task_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "task_role_arn", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionVolumeArgs']]]]:
        """
        A list of volumes that are associated with the job.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


if not MYPY:
    class JobDefinitionEfsAuthorizationConfigArgsDict(TypedDict):
        access_point_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon EFS access point ID to use. If an access point is specified, the root directory value specified in the `EFSVolumeConfiguration` must either be omitted or set to `/` which enforces the path set on the EFS access point. If an access point is used, transit encryption must be enabled in the `EFSVolumeConfiguration` . For more information, see [Working with Amazon EFS access points](https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html) in the *Amazon Elastic File System User Guide* .
        """
        iam: NotRequired[pulumi.Input[builtins.str]]
        """
        Whether or not to use the AWS Batch job IAM role defined in a job definition when mounting the Amazon EFS file system. If enabled, transit encryption must be enabled in the `EFSVolumeConfiguration` . If this parameter is omitted, the default value of `DISABLED` is used. For more information, see [Using Amazon EFS access points](https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html#efs-volume-accesspoints) in the *AWS Batch User Guide* . EFS IAM authorization requires that `TransitEncryption` be `ENABLED` and that a `JobRoleArn` is specified.
        """
elif False:
    JobDefinitionEfsAuthorizationConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEfsAuthorizationConfigArgs:
    def __init__(__self__, *,
                 access_point_id: Optional[pulumi.Input[builtins.str]] = None,
                 iam: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] access_point_id: The Amazon EFS access point ID to use. If an access point is specified, the root directory value specified in the `EFSVolumeConfiguration` must either be omitted or set to `/` which enforces the path set on the EFS access point. If an access point is used, transit encryption must be enabled in the `EFSVolumeConfiguration` . For more information, see [Working with Amazon EFS access points](https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html) in the *Amazon Elastic File System User Guide* .
        :param pulumi.Input[builtins.str] iam: Whether or not to use the AWS Batch job IAM role defined in a job definition when mounting the Amazon EFS file system. If enabled, transit encryption must be enabled in the `EFSVolumeConfiguration` . If this parameter is omitted, the default value of `DISABLED` is used. For more information, see [Using Amazon EFS access points](https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html#efs-volume-accesspoints) in the *AWS Batch User Guide* . EFS IAM authorization requires that `TransitEncryption` be `ENABLED` and that a `JobRoleArn` is specified.
        """
        if access_point_id is not None:
            pulumi.set(__self__, "access_point_id", access_point_id)
        if iam is not None:
            pulumi.set(__self__, "iam", iam)

    @property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon EFS access point ID to use. If an access point is specified, the root directory value specified in the `EFSVolumeConfiguration` must either be omitted or set to `/` which enforces the path set on the EFS access point. If an access point is used, transit encryption must be enabled in the `EFSVolumeConfiguration` . For more information, see [Working with Amazon EFS access points](https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html) in the *Amazon Elastic File System User Guide* .
        """
        return pulumi.get(self, "access_point_id")

    @access_point_id.setter
    def access_point_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_point_id", value)

    @property
    @pulumi.getter
    def iam(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether or not to use the AWS Batch job IAM role defined in a job definition when mounting the Amazon EFS file system. If enabled, transit encryption must be enabled in the `EFSVolumeConfiguration` . If this parameter is omitted, the default value of `DISABLED` is used. For more information, see [Using Amazon EFS access points](https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html#efs-volume-accesspoints) in the *AWS Batch User Guide* . EFS IAM authorization requires that `TransitEncryption` be `ENABLED` and that a `JobRoleArn` is specified.
        """
        return pulumi.get(self, "iam")

    @iam.setter
    def iam(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam", value)


if not MYPY:
    class JobDefinitionEfsVolumeConfigurationArgsDict(TypedDict):
        file_system_id: pulumi.Input[builtins.str]
        """
        The Amazon EFS file system ID to use.
        """
        authorization_config: NotRequired[pulumi.Input['JobDefinitionEfsAuthorizationConfigArgsDict']]
        """
        The authorization configuration details for the Amazon EFS file system.
        """
        root_directory: NotRequired[pulumi.Input[builtins.str]]
        """
        The directory within the Amazon EFS file system to mount as the root directory inside the host. If this parameter is omitted, the root of the Amazon EFS volume is used instead. Specifying `/` has the same effect as omitting this parameter. The maximum length is 4,096 characters.

        > If an EFS access point is specified in the `authorizationConfig` , the root directory parameter must either be omitted or set to `/` , which enforces the path set on the Amazon EFS access point.
        """
        transit_encryption: NotRequired[pulumi.Input[builtins.str]]
        """
        Determines whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is used. If this parameter is omitted, the default value of `DISABLED` is used. For more information, see [Encrypting data in transit](https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html) in the *Amazon Elastic File System User Guide* .
        """
        transit_encryption_port: NotRequired[pulumi.Input[builtins.int]]
        """
        The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server. If you don't specify a transit encryption port, it uses the port selection strategy that the Amazon EFS mount helper uses. The value must be between 0 and 65,535. For more information, see [EFS mount helper](https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html) in the *Amazon Elastic File System User Guide* .
        """
elif False:
    JobDefinitionEfsVolumeConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEfsVolumeConfigurationArgs:
    def __init__(__self__, *,
                 file_system_id: pulumi.Input[builtins.str],
                 authorization_config: Optional[pulumi.Input['JobDefinitionEfsAuthorizationConfigArgs']] = None,
                 root_directory: Optional[pulumi.Input[builtins.str]] = None,
                 transit_encryption: Optional[pulumi.Input[builtins.str]] = None,
                 transit_encryption_port: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] file_system_id: The Amazon EFS file system ID to use.
        :param pulumi.Input['JobDefinitionEfsAuthorizationConfigArgs'] authorization_config: The authorization configuration details for the Amazon EFS file system.
        :param pulumi.Input[builtins.str] root_directory: The directory within the Amazon EFS file system to mount as the root directory inside the host. If this parameter is omitted, the root of the Amazon EFS volume is used instead. Specifying `/` has the same effect as omitting this parameter. The maximum length is 4,096 characters.
               
               > If an EFS access point is specified in the `authorizationConfig` , the root directory parameter must either be omitted or set to `/` , which enforces the path set on the Amazon EFS access point.
        :param pulumi.Input[builtins.str] transit_encryption: Determines whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is used. If this parameter is omitted, the default value of `DISABLED` is used. For more information, see [Encrypting data in transit](https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html) in the *Amazon Elastic File System User Guide* .
        :param pulumi.Input[builtins.int] transit_encryption_port: The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server. If you don't specify a transit encryption port, it uses the port selection strategy that the Amazon EFS mount helper uses. The value must be between 0 and 65,535. For more information, see [EFS mount helper](https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html) in the *Amazon Elastic File System User Guide* .
        """
        pulumi.set(__self__, "file_system_id", file_system_id)
        if authorization_config is not None:
            pulumi.set(__self__, "authorization_config", authorization_config)
        if root_directory is not None:
            pulumi.set(__self__, "root_directory", root_directory)
        if transit_encryption is not None:
            pulumi.set(__self__, "transit_encryption", transit_encryption)
        if transit_encryption_port is not None:
            pulumi.set(__self__, "transit_encryption_port", transit_encryption_port)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon EFS file system ID to use.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter(name="authorizationConfig")
    def authorization_config(self) -> Optional[pulumi.Input['JobDefinitionEfsAuthorizationConfigArgs']]:
        """
        The authorization configuration details for the Amazon EFS file system.
        """
        return pulumi.get(self, "authorization_config")

    @authorization_config.setter
    def authorization_config(self, value: Optional[pulumi.Input['JobDefinitionEfsAuthorizationConfigArgs']]):
        pulumi.set(self, "authorization_config", value)

    @property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The directory within the Amazon EFS file system to mount as the root directory inside the host. If this parameter is omitted, the root of the Amazon EFS volume is used instead. Specifying `/` has the same effect as omitting this parameter. The maximum length is 4,096 characters.

        > If an EFS access point is specified in the `authorizationConfig` , the root directory parameter must either be omitted or set to `/` , which enforces the path set on the Amazon EFS access point.
        """
        return pulumi.get(self, "root_directory")

    @root_directory.setter
    def root_directory(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "root_directory", value)

    @property
    @pulumi.getter(name="transitEncryption")
    def transit_encryption(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Determines whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is used. If this parameter is omitted, the default value of `DISABLED` is used. For more information, see [Encrypting data in transit](https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html) in the *Amazon Elastic File System User Guide* .
        """
        return pulumi.get(self, "transit_encryption")

    @transit_encryption.setter
    def transit_encryption(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transit_encryption", value)

    @property
    @pulumi.getter(name="transitEncryptionPort")
    def transit_encryption_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server. If you don't specify a transit encryption port, it uses the port selection strategy that the Amazon EFS mount helper uses. The value must be between 0 and 65,535. For more information, see [EFS mount helper](https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html) in the *Amazon Elastic File System User Guide* .
        """
        return pulumi.get(self, "transit_encryption_port")

    @transit_encryption_port.setter
    def transit_encryption_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "transit_encryption_port", value)


if not MYPY:
    class JobDefinitionEksContainerEnvironmentVariableArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The name of the environment variable.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        The value of the environment variable.
        """
elif False:
    JobDefinitionEksContainerEnvironmentVariableArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksContainerEnvironmentVariableArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: The name of the environment variable.
        :param pulumi.Input[builtins.str] value: The value of the environment variable.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class JobDefinitionEksContainerResourceRequirementsArgsDict(TypedDict):
        limits: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        The type and quantity of the resources to reserve for the container. The values vary based on the `name` that's specified. Resources can be requested using either the `limits` or the `requests` objects.

        - **memory** - The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your container attempts to exceed the memory specified, the container is terminated. You must specify at least 4 MiB of memory for a job. `memory` can be specified in `limits` , `requests` , or both. If `memory` is specified in both places, then the value that's specified in `limits` must be equal to the value that's specified in `requests` .

        > To maximize your resource utilization, provide your jobs with as much memory as possible for the specific instance type that you are using. To learn how, see [Memory management](https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html) in the *AWS Batch User Guide* .
        - **cpu** - The number of CPUs that's reserved for the container. Values must be an even multiple of `0.25` . `cpu` can be specified in `limits` , `requests` , or both. If `cpu` is specified in both places, then the value that's specified in `limits` must be at least as large as the value that's specified in `requests` .
        - **nvidia.com/gpu** - The number of GPUs that's reserved for the container. Values must be a whole integer. `memory` can be specified in `limits` , `requests` , or both. If `memory` is specified in both places, then the value that's specified in `limits` must be equal to the value that's specified in `requests` .
        """
        requests: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        The type and quantity of the resources to request for the container. The values vary based on the `name` that's specified. Resources can be requested by using either the `limits` or the `requests` objects.

        - **memory** - The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your container attempts to exceed the memory specified, the container is terminated. You must specify at least 4 MiB of memory for a job. `memory` can be specified in `limits` , `requests` , or both. If `memory` is specified in both, then the value that's specified in `limits` must be equal to the value that's specified in `requests` .

        > If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see [Memory management](https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html) in the *AWS Batch User Guide* .
        - **cpu** - The number of CPUs that are reserved for the container. Values must be an even multiple of `0.25` . `cpu` can be specified in `limits` , `requests` , or both. If `cpu` is specified in both, then the value that's specified in `limits` must be at least as large as the value that's specified in `requests` .
        - **nvidia.com/gpu** - The number of GPUs that are reserved for the container. Values must be a whole integer. `nvidia.com/gpu` can be specified in `limits` , `requests` , or both. If `nvidia.com/gpu` is specified in both, then the value that's specified in `limits` must be equal to the value that's specified in `requests` .
        """
elif False:
    JobDefinitionEksContainerResourceRequirementsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksContainerResourceRequirementsArgs:
    def __init__(__self__, *,
                 limits: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 requests: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] limits: The type and quantity of the resources to reserve for the container. The values vary based on the `name` that's specified. Resources can be requested using either the `limits` or the `requests` objects.
               
               - **memory** - The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your container attempts to exceed the memory specified, the container is terminated. You must specify at least 4 MiB of memory for a job. `memory` can be specified in `limits` , `requests` , or both. If `memory` is specified in both places, then the value that's specified in `limits` must be equal to the value that's specified in `requests` .
               
               > To maximize your resource utilization, provide your jobs with as much memory as possible for the specific instance type that you are using. To learn how, see [Memory management](https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html) in the *AWS Batch User Guide* .
               - **cpu** - The number of CPUs that's reserved for the container. Values must be an even multiple of `0.25` . `cpu` can be specified in `limits` , `requests` , or both. If `cpu` is specified in both places, then the value that's specified in `limits` must be at least as large as the value that's specified in `requests` .
               - **nvidia.com/gpu** - The number of GPUs that's reserved for the container. Values must be a whole integer. `memory` can be specified in `limits` , `requests` , or both. If `memory` is specified in both places, then the value that's specified in `limits` must be equal to the value that's specified in `requests` .
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] requests: The type and quantity of the resources to request for the container. The values vary based on the `name` that's specified. Resources can be requested by using either the `limits` or the `requests` objects.
               
               - **memory** - The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your container attempts to exceed the memory specified, the container is terminated. You must specify at least 4 MiB of memory for a job. `memory` can be specified in `limits` , `requests` , or both. If `memory` is specified in both, then the value that's specified in `limits` must be equal to the value that's specified in `requests` .
               
               > If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see [Memory management](https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html) in the *AWS Batch User Guide* .
               - **cpu** - The number of CPUs that are reserved for the container. Values must be an even multiple of `0.25` . `cpu` can be specified in `limits` , `requests` , or both. If `cpu` is specified in both, then the value that's specified in `limits` must be at least as large as the value that's specified in `requests` .
               - **nvidia.com/gpu** - The number of GPUs that are reserved for the container. Values must be a whole integer. `nvidia.com/gpu` can be specified in `limits` , `requests` , or both. If `nvidia.com/gpu` is specified in both, then the value that's specified in `limits` must be equal to the value that's specified in `requests` .
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The type and quantity of the resources to reserve for the container. The values vary based on the `name` that's specified. Resources can be requested using either the `limits` or the `requests` objects.

        - **memory** - The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your container attempts to exceed the memory specified, the container is terminated. You must specify at least 4 MiB of memory for a job. `memory` can be specified in `limits` , `requests` , or both. If `memory` is specified in both places, then the value that's specified in `limits` must be equal to the value that's specified in `requests` .

        > To maximize your resource utilization, provide your jobs with as much memory as possible for the specific instance type that you are using. To learn how, see [Memory management](https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html) in the *AWS Batch User Guide* .
        - **cpu** - The number of CPUs that's reserved for the container. Values must be an even multiple of `0.25` . `cpu` can be specified in `limits` , `requests` , or both. If `cpu` is specified in both places, then the value that's specified in `limits` must be at least as large as the value that's specified in `requests` .
        - **nvidia.com/gpu** - The number of GPUs that's reserved for the container. Values must be a whole integer. `memory` can be specified in `limits` , `requests` , or both. If `memory` is specified in both places, then the value that's specified in `limits` must be equal to the value that's specified in `requests` .
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The type and quantity of the resources to request for the container. The values vary based on the `name` that's specified. Resources can be requested by using either the `limits` or the `requests` objects.

        - **memory** - The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your container attempts to exceed the memory specified, the container is terminated. You must specify at least 4 MiB of memory for a job. `memory` can be specified in `limits` , `requests` , or both. If `memory` is specified in both, then the value that's specified in `limits` must be equal to the value that's specified in `requests` .

        > If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see [Memory management](https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html) in the *AWS Batch User Guide* .
        - **cpu** - The number of CPUs that are reserved for the container. Values must be an even multiple of `0.25` . `cpu` can be specified in `limits` , `requests` , or both. If `cpu` is specified in both, then the value that's specified in `limits` must be at least as large as the value that's specified in `requests` .
        - **nvidia.com/gpu** - The number of GPUs that are reserved for the container. Values must be a whole integer. `nvidia.com/gpu` can be specified in `limits` , `requests` , or both. If `nvidia.com/gpu` is specified in both, then the value that's specified in `limits` must be equal to the value that's specified in `requests` .
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "requests", value)


if not MYPY:
    class JobDefinitionEksContainerSecurityContextArgsDict(TypedDict):
        allow_privilege_escalation: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether or not a container or a Kubernetes pod is allowed to gain more privileges than its parent process. The default value is `false` .
        """
        privileged: NotRequired[pulumi.Input[builtins.bool]]
        """
        When this parameter is `true` , the container is given elevated permissions on the host container instance. The level of permissions are similar to the `root` user permissions. The default value is `false` . This parameter maps to `privileged` policy in the [Privileged pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#privileged) in the *Kubernetes documentation* .
        """
        read_only_root_filesystem: NotRequired[pulumi.Input[builtins.bool]]
        """
        When this parameter is `true` , the container is given read-only access to its root file system. The default value is `false` . This parameter maps to `ReadOnlyRootFilesystem` policy in the [Volumes and file systems pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems) in the *Kubernetes documentation* .
        """
        run_as_group: NotRequired[pulumi.Input[builtins.int]]
        """
        When this parameter is specified, the container is run as the specified group ID ( `gid` ). If this parameter isn't specified, the default is the group that's specified in the image metadata. This parameter maps to `RunAsGroup` and `MustRunAs` policy in the [Users and groups pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation* .
        """
        run_as_non_root: NotRequired[pulumi.Input[builtins.bool]]
        """
        When this parameter is specified, the container is run as a user with a `uid` other than 0. If this parameter isn't specified, so such rule is enforced. This parameter maps to `RunAsUser` and `MustRunAsNonRoot` policy in the [Users and groups pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation* .
        """
        run_as_user: NotRequired[pulumi.Input[builtins.int]]
        """
        When this parameter is specified, the container is run as the specified user ID ( `uid` ). If this parameter isn't specified, the default is the user that's specified in the image metadata. This parameter maps to `RunAsUser` and `MustRanAs` policy in the [Users and groups pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation* .
        """
elif False:
    JobDefinitionEksContainerSecurityContextArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksContainerSecurityContextArgs:
    def __init__(__self__, *,
                 allow_privilege_escalation: Optional[pulumi.Input[builtins.bool]] = None,
                 privileged: Optional[pulumi.Input[builtins.bool]] = None,
                 read_only_root_filesystem: Optional[pulumi.Input[builtins.bool]] = None,
                 run_as_group: Optional[pulumi.Input[builtins.int]] = None,
                 run_as_non_root: Optional[pulumi.Input[builtins.bool]] = None,
                 run_as_user: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.bool] allow_privilege_escalation: Whether or not a container or a Kubernetes pod is allowed to gain more privileges than its parent process. The default value is `false` .
        :param pulumi.Input[builtins.bool] privileged: When this parameter is `true` , the container is given elevated permissions on the host container instance. The level of permissions are similar to the `root` user permissions. The default value is `false` . This parameter maps to `privileged` policy in the [Privileged pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#privileged) in the *Kubernetes documentation* .
        :param pulumi.Input[builtins.bool] read_only_root_filesystem: When this parameter is `true` , the container is given read-only access to its root file system. The default value is `false` . This parameter maps to `ReadOnlyRootFilesystem` policy in the [Volumes and file systems pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems) in the *Kubernetes documentation* .
        :param pulumi.Input[builtins.int] run_as_group: When this parameter is specified, the container is run as the specified group ID ( `gid` ). If this parameter isn't specified, the default is the group that's specified in the image metadata. This parameter maps to `RunAsGroup` and `MustRunAs` policy in the [Users and groups pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation* .
        :param pulumi.Input[builtins.bool] run_as_non_root: When this parameter is specified, the container is run as a user with a `uid` other than 0. If this parameter isn't specified, so such rule is enforced. This parameter maps to `RunAsUser` and `MustRunAsNonRoot` policy in the [Users and groups pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation* .
        :param pulumi.Input[builtins.int] run_as_user: When this parameter is specified, the container is run as the specified user ID ( `uid` ). If this parameter isn't specified, the default is the user that's specified in the image metadata. This parameter maps to `RunAsUser` and `MustRanAs` policy in the [Users and groups pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation* .
        """
        if allow_privilege_escalation is not None:
            pulumi.set(__self__, "allow_privilege_escalation", allow_privilege_escalation)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if read_only_root_filesystem is not None:
            pulumi.set(__self__, "read_only_root_filesystem", read_only_root_filesystem)
        if run_as_group is not None:
            pulumi.set(__self__, "run_as_group", run_as_group)
        if run_as_non_root is not None:
            pulumi.set(__self__, "run_as_non_root", run_as_non_root)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)

    @property
    @pulumi.getter(name="allowPrivilegeEscalation")
    def allow_privilege_escalation(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not a container or a Kubernetes pod is allowed to gain more privileges than its parent process. The default value is `false` .
        """
        return pulumi.get(self, "allow_privilege_escalation")

    @allow_privilege_escalation.setter
    def allow_privilege_escalation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_privilege_escalation", value)

    @property
    @pulumi.getter
    def privileged(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When this parameter is `true` , the container is given elevated permissions on the host container instance. The level of permissions are similar to the `root` user permissions. The default value is `false` . This parameter maps to `privileged` policy in the [Privileged pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#privileged) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "privileged")

    @privileged.setter
    def privileged(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "privileged", value)

    @property
    @pulumi.getter(name="readOnlyRootFilesystem")
    def read_only_root_filesystem(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When this parameter is `true` , the container is given read-only access to its root file system. The default value is `false` . This parameter maps to `ReadOnlyRootFilesystem` policy in the [Volumes and file systems pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "read_only_root_filesystem")

    @read_only_root_filesystem.setter
    def read_only_root_filesystem(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "read_only_root_filesystem", value)

    @property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        When this parameter is specified, the container is run as the specified group ID ( `gid` ). If this parameter isn't specified, the default is the group that's specified in the image metadata. This parameter maps to `RunAsGroup` and `MustRunAs` policy in the [Users and groups pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "run_as_group")

    @run_as_group.setter
    def run_as_group(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "run_as_group", value)

    @property
    @pulumi.getter(name="runAsNonRoot")
    def run_as_non_root(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When this parameter is specified, the container is run as a user with a `uid` other than 0. If this parameter isn't specified, so such rule is enforced. This parameter maps to `RunAsUser` and `MustRunAsNonRoot` policy in the [Users and groups pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "run_as_non_root")

    @run_as_non_root.setter
    def run_as_non_root(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "run_as_non_root", value)

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        When this parameter is specified, the container is run as the specified user ID ( `uid` ). If this parameter isn't specified, the default is the user that's specified in the image metadata. This parameter maps to `RunAsUser` and `MustRanAs` policy in the [Users and groups pod security policies](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "run_as_user")

    @run_as_user.setter
    def run_as_user(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "run_as_user", value)


if not MYPY:
    class JobDefinitionEksContainerVolumeMountArgsDict(TypedDict):
        mount_path: NotRequired[pulumi.Input[builtins.str]]
        """
        The path on the container where the volume is mounted.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name the volume mount. This must match the name of one of the volumes in the pod.
        """
        read_only: NotRequired[pulumi.Input[builtins.bool]]
        """
        If this value is `true` , the container has read-only access to the volume. Otherwise, the container can write to the volume. The default value is `false` .
        """
        sub_path: NotRequired[pulumi.Input[builtins.str]]
        """
        A sub-path inside the referenced volume instead of its root.
        """
elif False:
    JobDefinitionEksContainerVolumeMountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksContainerVolumeMountArgs:
    def __init__(__self__, *,
                 mount_path: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 read_only: Optional[pulumi.Input[builtins.bool]] = None,
                 sub_path: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] mount_path: The path on the container where the volume is mounted.
        :param pulumi.Input[builtins.str] name: The name the volume mount. This must match the name of one of the volumes in the pod.
        :param pulumi.Input[builtins.bool] read_only: If this value is `true` , the container has read-only access to the volume. Otherwise, the container can write to the volume. The default value is `false` .
        :param pulumi.Input[builtins.str] sub_path: A sub-path inside the referenced volume instead of its root.
        """
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if sub_path is not None:
            pulumi.set(__self__, "sub_path", sub_path)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path on the container where the volume is mounted.
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name the volume mount. This must match the name of one of the volumes in the pod.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If this value is `true` , the container has read-only access to the volume. Otherwise, the container can write to the volume. The default value is `false` .
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A sub-path inside the referenced volume instead of its root.
        """
        return pulumi.get(self, "sub_path")

    @sub_path.setter
    def sub_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sub_path", value)


if not MYPY:
    class JobDefinitionEksContainerArgsDict(TypedDict):
        image: pulumi.Input[builtins.str]
        """
        The Docker image used to start the container.
        """
        args: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        An array of arguments to the entrypoint. If this isn't specified, the `CMD` of the container image is used. This corresponds to the `args` member in the [Entrypoint](https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint) portion of the [Pod](https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/) in Kubernetes. Environment variable references are expanded using the container's environment.

        If the referenced environment variable doesn't exist, the reference in the command isn't changed. For example, if the reference is to " `$(NAME1)` " and the `NAME1` environment variable doesn't exist, the command string will remain " `$(NAME1)` ." `$$` is replaced with `$` , and the resulting string isn't expanded. For example, `$$(VAR_NAME)` is passed as `$(VAR_NAME)` whether or not the `VAR_NAME` environment variable exists. For more information, see [Dockerfile reference: CMD](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd) and [Define a command and arguments for a pod](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/) in the *Kubernetes documentation* .
        """
        command: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The entrypoint for the container. This isn't run within a shell. If this isn't specified, the `ENTRYPOINT` of the container image is used. Environment variable references are expanded using the container's environment.

        If the referenced environment variable doesn't exist, the reference in the command isn't changed. For example, if the reference is to " `$(NAME1)` " and the `NAME1` environment variable doesn't exist, the command string will remain " `$(NAME1)` ." `$$` is replaced with `$` and the resulting string isn't expanded. For example, `$$(VAR_NAME)` will be passed as `$(VAR_NAME)` whether or not the `VAR_NAME` environment variable exists. The entrypoint can't be updated. For more information, see [ENTRYPOINT](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#entrypoint) in the *Dockerfile reference* and [Define a command and arguments for a container](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/) and [Entrypoint](https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint) in the *Kubernetes documentation* .
        """
        env: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksContainerEnvironmentVariableArgsDict']]]]
        """
        The environment variables to pass to a container.

        > Environment variables cannot start with " `AWS_BATCH` ". This naming convention is reserved for variables that AWS Batch sets.
        """
        image_pull_policy: NotRequired[pulumi.Input[builtins.str]]
        """
        The image pull policy for the container. Supported values are `Always` , `IfNotPresent` , and `Never` . This parameter defaults to `IfNotPresent` . However, if the `:latest` tag is specified, it defaults to `Always` . For more information, see [Updating images](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/containers/images/#updating-images) in the *Kubernetes documentation* .
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the container. If the name isn't specified, the default name " `Default` " is used. Each container in a pod must have a unique name.
        """
        resources: NotRequired[pulumi.Input['JobDefinitionEksContainerResourceRequirementsArgsDict']]
        """
        The type and amount of resources to assign to a container. The supported resources include `memory` , `cpu` , and `nvidia.com/gpu` . For more information, see [Resource management for pods and containers](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) in the *Kubernetes documentation* .
        """
        security_context: NotRequired[pulumi.Input['JobDefinitionEksContainerSecurityContextArgsDict']]
        """
        The security context for a job. For more information, see [Configure a security context for a pod or container](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/security-context/) in the *Kubernetes documentation* .
        """
        volume_mounts: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksContainerVolumeMountArgsDict']]]]
        """
        The volume mounts for the container. AWS Batch supports `emptyDir` , `hostPath` , and `secret` volume types. For more information about volumes and volume mounts in Kubernetes, see [Volumes](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/) in the *Kubernetes documentation* .
        """
elif False:
    JobDefinitionEksContainerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksContainerArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[builtins.str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 env: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksContainerEnvironmentVariableArgs']]]] = None,
                 image_pull_policy: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resources: Optional[pulumi.Input['JobDefinitionEksContainerResourceRequirementsArgs']] = None,
                 security_context: Optional[pulumi.Input['JobDefinitionEksContainerSecurityContextArgs']] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksContainerVolumeMountArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] image: The Docker image used to start the container.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] args: An array of arguments to the entrypoint. If this isn't specified, the `CMD` of the container image is used. This corresponds to the `args` member in the [Entrypoint](https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint) portion of the [Pod](https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/) in Kubernetes. Environment variable references are expanded using the container's environment.
               
               If the referenced environment variable doesn't exist, the reference in the command isn't changed. For example, if the reference is to " `$(NAME1)` " and the `NAME1` environment variable doesn't exist, the command string will remain " `$(NAME1)` ." `$$` is replaced with `$` , and the resulting string isn't expanded. For example, `$$(VAR_NAME)` is passed as `$(VAR_NAME)` whether or not the `VAR_NAME` environment variable exists. For more information, see [Dockerfile reference: CMD](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd) and [Define a command and arguments for a pod](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/) in the *Kubernetes documentation* .
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] command: The entrypoint for the container. This isn't run within a shell. If this isn't specified, the `ENTRYPOINT` of the container image is used. Environment variable references are expanded using the container's environment.
               
               If the referenced environment variable doesn't exist, the reference in the command isn't changed. For example, if the reference is to " `$(NAME1)` " and the `NAME1` environment variable doesn't exist, the command string will remain " `$(NAME1)` ." `$$` is replaced with `$` and the resulting string isn't expanded. For example, `$$(VAR_NAME)` will be passed as `$(VAR_NAME)` whether or not the `VAR_NAME` environment variable exists. The entrypoint can't be updated. For more information, see [ENTRYPOINT](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#entrypoint) in the *Dockerfile reference* and [Define a command and arguments for a container](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/) and [Entrypoint](https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint) in the *Kubernetes documentation* .
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksContainerEnvironmentVariableArgs']]] env: The environment variables to pass to a container.
               
               > Environment variables cannot start with " `AWS_BATCH` ". This naming convention is reserved for variables that AWS Batch sets.
        :param pulumi.Input[builtins.str] image_pull_policy: The image pull policy for the container. Supported values are `Always` , `IfNotPresent` , and `Never` . This parameter defaults to `IfNotPresent` . However, if the `:latest` tag is specified, it defaults to `Always` . For more information, see [Updating images](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/containers/images/#updating-images) in the *Kubernetes documentation* .
        :param pulumi.Input[builtins.str] name: The name of the container. If the name isn't specified, the default name " `Default` " is used. Each container in a pod must have a unique name.
        :param pulumi.Input['JobDefinitionEksContainerResourceRequirementsArgs'] resources: The type and amount of resources to assign to a container. The supported resources include `memory` , `cpu` , and `nvidia.com/gpu` . For more information, see [Resource management for pods and containers](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) in the *Kubernetes documentation* .
        :param pulumi.Input['JobDefinitionEksContainerSecurityContextArgs'] security_context: The security context for a job. For more information, see [Configure a security context for a pod or container](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/security-context/) in the *Kubernetes documentation* .
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksContainerVolumeMountArgs']]] volume_mounts: The volume mounts for the container. AWS Batch supports `emptyDir` , `hostPath` , and `secret` volume types. For more information about volumes and volume mounts in Kubernetes, see [Volumes](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/) in the *Kubernetes documentation* .
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if security_context is not None:
            pulumi.set(__self__, "security_context", security_context)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[builtins.str]:
        """
        The Docker image used to start the container.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array of arguments to the entrypoint. If this isn't specified, the `CMD` of the container image is used. This corresponds to the `args` member in the [Entrypoint](https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint) portion of the [Pod](https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/) in Kubernetes. Environment variable references are expanded using the container's environment.

        If the referenced environment variable doesn't exist, the reference in the command isn't changed. For example, if the reference is to " `$(NAME1)` " and the `NAME1` environment variable doesn't exist, the command string will remain " `$(NAME1)` ." `$$` is replaced with `$` , and the resulting string isn't expanded. For example, `$$(VAR_NAME)` is passed as `$(VAR_NAME)` whether or not the `VAR_NAME` environment variable exists. For more information, see [Dockerfile reference: CMD](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd) and [Define a command and arguments for a pod](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The entrypoint for the container. This isn't run within a shell. If this isn't specified, the `ENTRYPOINT` of the container image is used. Environment variable references are expanded using the container's environment.

        If the referenced environment variable doesn't exist, the reference in the command isn't changed. For example, if the reference is to " `$(NAME1)` " and the `NAME1` environment variable doesn't exist, the command string will remain " `$(NAME1)` ." `$$` is replaced with `$` and the resulting string isn't expanded. For example, `$$(VAR_NAME)` will be passed as `$(VAR_NAME)` whether or not the `VAR_NAME` environment variable exists. The entrypoint can't be updated. For more information, see [ENTRYPOINT](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#entrypoint) in the *Dockerfile reference* and [Define a command and arguments for a container](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/) and [Entrypoint](https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksContainerEnvironmentVariableArgs']]]]:
        """
        The environment variables to pass to a container.

        > Environment variables cannot start with " `AWS_BATCH` ". This naming convention is reserved for variables that AWS Batch sets.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksContainerEnvironmentVariableArgs']]]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The image pull policy for the container. Supported values are `Always` , `IfNotPresent` , and `Never` . This parameter defaults to `IfNotPresent` . However, if the `:latest` tag is specified, it defaults to `Always` . For more information, see [Updating images](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/containers/images/#updating-images) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "image_pull_policy")

    @image_pull_policy.setter
    def image_pull_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_pull_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the container. If the name isn't specified, the default name " `Default` " is used. Each container in a pod must have a unique name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['JobDefinitionEksContainerResourceRequirementsArgs']]:
        """
        The type and amount of resources to assign to a container. The supported resources include `memory` , `cpu` , and `nvidia.com/gpu` . For more information, see [Resource management for pods and containers](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['JobDefinitionEksContainerResourceRequirementsArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> Optional[pulumi.Input['JobDefinitionEksContainerSecurityContextArgs']]:
        """
        The security context for a job. For more information, see [Configure a security context for a pod or container](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/security-context/) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "security_context")

    @security_context.setter
    def security_context(self, value: Optional[pulumi.Input['JobDefinitionEksContainerSecurityContextArgs']]):
        pulumi.set(self, "security_context", value)

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksContainerVolumeMountArgs']]]]:
        """
        The volume mounts for the container. AWS Batch supports `emptyDir` , `hostPath` , and `secret` volume types. For more information about volumes and volume mounts in Kubernetes, see [Volumes](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksContainerVolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)


if not MYPY:
    class JobDefinitionEksEmptyDirArgsDict(TypedDict):
        medium: NotRequired[pulumi.Input[builtins.str]]
        """
        The medium to store the volume. The default value is an empty string, which uses the storage of the node.

        - **""** - *(Default)* Use the disk storage of the node.
        - **"Memory"** - Use the `tmpfs` volume that's backed by the RAM of the node. Contents of the volume are lost when the node reboots, and any storage on the volume counts against the container's memory limit.
        """
        size_limit: NotRequired[pulumi.Input[builtins.str]]
        """
        The maximum size of the volume. By default, there's no maximum size defined.
        """
elif False:
    JobDefinitionEksEmptyDirArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksEmptyDirArgs:
    def __init__(__self__, *,
                 medium: Optional[pulumi.Input[builtins.str]] = None,
                 size_limit: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] medium: The medium to store the volume. The default value is an empty string, which uses the storage of the node.
               
               - **""** - *(Default)* Use the disk storage of the node.
               - **"Memory"** - Use the `tmpfs` volume that's backed by the RAM of the node. Contents of the volume are lost when the node reboots, and any storage on the volume counts against the container's memory limit.
        :param pulumi.Input[builtins.str] size_limit: The maximum size of the volume. By default, there's no maximum size defined.
        """
        if medium is not None:
            pulumi.set(__self__, "medium", medium)
        if size_limit is not None:
            pulumi.set(__self__, "size_limit", size_limit)

    @property
    @pulumi.getter
    def medium(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The medium to store the volume. The default value is an empty string, which uses the storage of the node.

        - **""** - *(Default)* Use the disk storage of the node.
        - **"Memory"** - Use the `tmpfs` volume that's backed by the RAM of the node. Contents of the volume are lost when the node reboots, and any storage on the volume counts against the container's memory limit.
        """
        return pulumi.get(self, "medium")

    @medium.setter
    def medium(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "medium", value)

    @property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum size of the volume. By default, there's no maximum size defined.
        """
        return pulumi.get(self, "size_limit")

    @size_limit.setter
    def size_limit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "size_limit", value)


if not MYPY:
    class JobDefinitionEksHostPathArgsDict(TypedDict):
        path: NotRequired[pulumi.Input[builtins.str]]
        """
        The path of the file or directory on the host to mount into containers on the pod.
        """
elif False:
    JobDefinitionEksHostPathArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksHostPathArgs:
    def __init__(__self__, *,
                 path: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] path: The path of the file or directory on the host to mount into containers on the pod.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path of the file or directory on the host to mount into containers on the pod.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)


if not MYPY:
    class JobDefinitionEksMetadataArgsDict(TypedDict):
        annotations: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Key-value pairs used to attach arbitrary, non-identifying metadata to Kubernetes objects. Valid annotation keys have two segments: an optional prefix and a name, separated by a slash (/).

        - The prefix is optional and must be 253 characters or less. If specified, the prefix must be a DNS subdomain− a series of DNS labels separated by dots (.), and it must end with a slash (/).
        - The name segment is required and must be 63 characters or less. It can include alphanumeric characters ([a-z0-9A-Z]), dashes (-), underscores (_), and dots (.), but must begin and end with an alphanumeric character.

        > Annotation values must be 255 characters or less. 

        Annotations can be added or modified at any time. Each resource can have multiple annotations.
        """
        labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Key-value pairs used to identify, sort, and organize cube resources. Can contain up to 63 uppercase letters, lowercase letters, numbers, hyphens (-), and underscores (_). Labels can be added or modified at any time. Each resource can have multiple labels, but each key must be unique for a given object.
        """
        namespace: NotRequired[pulumi.Input[builtins.str]]
        """
        The namespace of the Amazon EKS cluster. In Kubernetes, namespaces provide a mechanism for isolating groups of resources within a single cluster. Names of resources need to be unique within a namespace, but not across namespaces. AWS Batch places Batch Job pods in this namespace. If this field is provided, the value can't be empty or null. It must meet the following requirements:

        - 1-63 characters long
        - Can't be set to default
        - Can't start with `kube`
        - Must match the following regular expression: `^[a-z0-9]([-a-z0-9]*[a-z0-9])?$`

        For more information, see [Namespaces](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/) in the *Kubernetes documentation* . This namespace can be different from the `kubernetesNamespace` set in the compute environment's `EksConfiguration` , but must have identical role-based access control (RBAC) roles as the compute environment's `kubernetesNamespace` . For multi-node parallel jobs, the same value must be provided across all the node ranges.
        """
elif False:
    JobDefinitionEksMetadataArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksMetadataArgs:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Key-value pairs used to attach arbitrary, non-identifying metadata to Kubernetes objects. Valid annotation keys have two segments: an optional prefix and a name, separated by a slash (/).
               
               - The prefix is optional and must be 253 characters or less. If specified, the prefix must be a DNS subdomain− a series of DNS labels separated by dots (.), and it must end with a slash (/).
               - The name segment is required and must be 63 characters or less. It can include alphanumeric characters ([a-z0-9A-Z]), dashes (-), underscores (_), and dots (.), but must begin and end with an alphanumeric character.
               
               > Annotation values must be 255 characters or less. 
               
               Annotations can be added or modified at any time. Each resource can have multiple annotations.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Key-value pairs used to identify, sort, and organize cube resources. Can contain up to 63 uppercase letters, lowercase letters, numbers, hyphens (-), and underscores (_). Labels can be added or modified at any time. Each resource can have multiple labels, but each key must be unique for a given object.
        :param pulumi.Input[builtins.str] namespace: The namespace of the Amazon EKS cluster. In Kubernetes, namespaces provide a mechanism for isolating groups of resources within a single cluster. Names of resources need to be unique within a namespace, but not across namespaces. AWS Batch places Batch Job pods in this namespace. If this field is provided, the value can't be empty or null. It must meet the following requirements:
               
               - 1-63 characters long
               - Can't be set to default
               - Can't start with `kube`
               - Must match the following regular expression: `^[a-z0-9]([-a-z0-9]*[a-z0-9])?$`
               
               For more information, see [Namespaces](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/) in the *Kubernetes documentation* . This namespace can be different from the `kubernetesNamespace` set in the compute environment's `EksConfiguration` , but must have identical role-based access control (RBAC) roles as the compute environment's `kubernetesNamespace` . For multi-node parallel jobs, the same value must be provided across all the node ranges.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value pairs used to attach arbitrary, non-identifying metadata to Kubernetes objects. Valid annotation keys have two segments: an optional prefix and a name, separated by a slash (/).

        - The prefix is optional and must be 253 characters or less. If specified, the prefix must be a DNS subdomain− a series of DNS labels separated by dots (.), and it must end with a slash (/).
        - The name segment is required and must be 63 characters or less. It can include alphanumeric characters ([a-z0-9A-Z]), dashes (-), underscores (_), and dots (.), but must begin and end with an alphanumeric character.

        > Annotation values must be 255 characters or less. 

        Annotations can be added or modified at any time. Each resource can have multiple annotations.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value pairs used to identify, sort, and organize cube resources. Can contain up to 63 uppercase letters, lowercase letters, numbers, hyphens (-), and underscores (_). Labels can be added or modified at any time. Each resource can have multiple labels, but each key must be unique for a given object.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The namespace of the Amazon EKS cluster. In Kubernetes, namespaces provide a mechanism for isolating groups of resources within a single cluster. Names of resources need to be unique within a namespace, but not across namespaces. AWS Batch places Batch Job pods in this namespace. If this field is provided, the value can't be empty or null. It must meet the following requirements:

        - 1-63 characters long
        - Can't be set to default
        - Can't start with `kube`
        - Must match the following regular expression: `^[a-z0-9]([-a-z0-9]*[a-z0-9])?$`

        For more information, see [Namespaces](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/) in the *Kubernetes documentation* . This namespace can be different from the `kubernetesNamespace` set in the compute environment's `EksConfiguration` , but must have identical role-based access control (RBAC) roles as the compute environment's `kubernetesNamespace` . For multi-node parallel jobs, the same value must be provided across all the node ranges.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)


if not MYPY:
    class JobDefinitionEksPersistentVolumeClaimArgsDict(TypedDict):
        claim_name: pulumi.Input[builtins.str]
        """
        The name of the `persistentVolumeClaim` bounded to a `persistentVolume` . For more information, see [Persistent Volume Claims](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims) in the *Kubernetes documentation* .
        """
        read_only: NotRequired[pulumi.Input[builtins.bool]]
        """
        An optional boolean value indicating if the mount is read only. Default is false. For more information, see [Read Only Mounts](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#read-only-mounts) in the *Kubernetes documentation* .
        """
elif False:
    JobDefinitionEksPersistentVolumeClaimArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPersistentVolumeClaimArgs:
    def __init__(__self__, *,
                 claim_name: pulumi.Input[builtins.str],
                 read_only: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] claim_name: The name of the `persistentVolumeClaim` bounded to a `persistentVolume` . For more information, see [Persistent Volume Claims](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims) in the *Kubernetes documentation* .
        :param pulumi.Input[builtins.bool] read_only: An optional boolean value indicating if the mount is read only. Default is false. For more information, see [Read Only Mounts](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#read-only-mounts) in the *Kubernetes documentation* .
        """
        pulumi.set(__self__, "claim_name", claim_name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="claimName")
    def claim_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the `persistentVolumeClaim` bounded to a `persistentVolume` . For more information, see [Persistent Volume Claims](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "claim_name")

    @claim_name.setter
    def claim_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "claim_name", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        An optional boolean value indicating if the mount is read only. Default is false. For more information, see [Read Only Mounts](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#read-only-mounts) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "read_only", value)


if not MYPY:
    class JobDefinitionEksPodPropertiesArgsDict(TypedDict):
        containers: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksContainerArgsDict']]]]
        """
        The properties of the container that's used on the Amazon EKS pod.

        > This object is limited to 10 elements.
        """
        dns_policy: NotRequired[pulumi.Input[builtins.str]]
        """
        The DNS policy for the pod. The default value is `ClusterFirst` . If the `hostNetwork` parameter is not specified, the default is `ClusterFirstWithHostNet` . `ClusterFirst` indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node. For more information, see [Pod's DNS policy](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy) in the *Kubernetes documentation* .

        Valid values: `Default` | `ClusterFirst` | `ClusterFirstWithHostNet`
        """
        host_network: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates if the pod uses the hosts' network IP address. The default value is `true` . Setting this to `false` enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections. For more information, see [Host namespaces](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces) and [Pod networking](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking) in the *Kubernetes documentation* .
        """
        image_pull_secrets: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionImagePullSecretArgsDict']]]]
        """
        References a Kubernetes secret resource. It holds a list of secrets. These secrets help to gain access to pull an images from a private registry.

        `ImagePullSecret$name` is required when this object is used.
        """
        init_containers: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksContainerArgsDict']]]]
        """
        These containers run before application containers, always runs to completion, and must complete successfully before the next container starts. These containers are registered with the Amazon EKS Connector agent and persists the registration information in the Kubernetes backend data store. For more information, see [Init Containers](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/workloads/pods/init-containers/) in the *Kubernetes documentation* .

        > This object is limited to 10 elements.
        """
        metadata: NotRequired[pulumi.Input['JobDefinitionEksMetadataArgsDict']]
        """
        Metadata about the Kubernetes pod. For more information, see [Understanding Kubernetes Objects](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/kubernetes-objects/) in the *Kubernetes documentation* .
        """
        service_account_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the service account that's used to run the pod. For more information, see [Kubernetes service accounts](https://docs.aws.amazon.com/eks/latest/userguide/service-accounts.html) and [Configure a Kubernetes service account to assume an IAM role](https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html) in the *Amazon EKS User Guide* and [Configure service accounts for pods](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/) in the *Kubernetes documentation* .
        """
        share_process_namespace: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates if the processes in a container are shared, or visible, to other containers in the same pod. For more information, see [Share Process Namespace between Containers in a Pod](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/share-process-namespace/) .
        """
        volumes: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksVolumeArgsDict']]]]
        """
        Specifies the volumes for a job definition that uses Amazon EKS resources.
        """
elif False:
    JobDefinitionEksPodPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPodPropertiesArgs:
    def __init__(__self__, *,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksContainerArgs']]]] = None,
                 dns_policy: Optional[pulumi.Input[builtins.str]] = None,
                 host_network: Optional[pulumi.Input[builtins.bool]] = None,
                 image_pull_secrets: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionImagePullSecretArgs']]]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksContainerArgs']]]] = None,
                 metadata: Optional[pulumi.Input['JobDefinitionEksMetadataArgs']] = None,
                 service_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 share_process_namespace: Optional[pulumi.Input[builtins.bool]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksVolumeArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksContainerArgs']]] containers: The properties of the container that's used on the Amazon EKS pod.
               
               > This object is limited to 10 elements.
        :param pulumi.Input[builtins.str] dns_policy: The DNS policy for the pod. The default value is `ClusterFirst` . If the `hostNetwork` parameter is not specified, the default is `ClusterFirstWithHostNet` . `ClusterFirst` indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node. For more information, see [Pod's DNS policy](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy) in the *Kubernetes documentation* .
               
               Valid values: `Default` | `ClusterFirst` | `ClusterFirstWithHostNet`
        :param pulumi.Input[builtins.bool] host_network: Indicates if the pod uses the hosts' network IP address. The default value is `true` . Setting this to `false` enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections. For more information, see [Host namespaces](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces) and [Pod networking](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking) in the *Kubernetes documentation* .
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionImagePullSecretArgs']]] image_pull_secrets: References a Kubernetes secret resource. It holds a list of secrets. These secrets help to gain access to pull an images from a private registry.
               
               `ImagePullSecret$name` is required when this object is used.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksContainerArgs']]] init_containers: These containers run before application containers, always runs to completion, and must complete successfully before the next container starts. These containers are registered with the Amazon EKS Connector agent and persists the registration information in the Kubernetes backend data store. For more information, see [Init Containers](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/workloads/pods/init-containers/) in the *Kubernetes documentation* .
               
               > This object is limited to 10 elements.
        :param pulumi.Input['JobDefinitionEksMetadataArgs'] metadata: Metadata about the Kubernetes pod. For more information, see [Understanding Kubernetes Objects](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/kubernetes-objects/) in the *Kubernetes documentation* .
        :param pulumi.Input[builtins.str] service_account_name: The name of the service account that's used to run the pod. For more information, see [Kubernetes service accounts](https://docs.aws.amazon.com/eks/latest/userguide/service-accounts.html) and [Configure a Kubernetes service account to assume an IAM role](https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html) in the *Amazon EKS User Guide* and [Configure service accounts for pods](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/) in the *Kubernetes documentation* .
        :param pulumi.Input[builtins.bool] share_process_namespace: Indicates if the processes in a container are shared, or visible, to other containers in the same pod. For more information, see [Share Process Namespace between Containers in a Pod](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/share-process-namespace/) .
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksVolumeArgs']]] volumes: Specifies the volumes for a job definition that uses Amazon EKS resources.
        """
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if dns_policy is not None:
            pulumi.set(__self__, "dns_policy", dns_policy)
        if host_network is not None:
            pulumi.set(__self__, "host_network", host_network)
        if image_pull_secrets is not None:
            pulumi.set(__self__, "image_pull_secrets", image_pull_secrets)
        if init_containers is not None:
            pulumi.set(__self__, "init_containers", init_containers)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if service_account_name is not None:
            pulumi.set(__self__, "service_account_name", service_account_name)
        if share_process_namespace is not None:
            pulumi.set(__self__, "share_process_namespace", share_process_namespace)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksContainerArgs']]]]:
        """
        The properties of the container that's used on the Amazon EKS pod.

        > This object is limited to 10 elements.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter(name="dnsPolicy")
    def dns_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DNS policy for the pod. The default value is `ClusterFirst` . If the `hostNetwork` parameter is not specified, the default is `ClusterFirstWithHostNet` . `ClusterFirst` indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node. For more information, see [Pod's DNS policy](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy) in the *Kubernetes documentation* .

        Valid values: `Default` | `ClusterFirst` | `ClusterFirstWithHostNet`
        """
        return pulumi.get(self, "dns_policy")

    @dns_policy.setter
    def dns_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_policy", value)

    @property
    @pulumi.getter(name="hostNetwork")
    def host_network(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates if the pod uses the hosts' network IP address. The default value is `true` . Setting this to `false` enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections. For more information, see [Host namespaces](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces) and [Pod networking](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "host_network")

    @host_network.setter
    def host_network(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "host_network", value)

    @property
    @pulumi.getter(name="imagePullSecrets")
    def image_pull_secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionImagePullSecretArgs']]]]:
        """
        References a Kubernetes secret resource. It holds a list of secrets. These secrets help to gain access to pull an images from a private registry.

        `ImagePullSecret$name` is required when this object is used.
        """
        return pulumi.get(self, "image_pull_secrets")

    @image_pull_secrets.setter
    def image_pull_secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionImagePullSecretArgs']]]]):
        pulumi.set(self, "image_pull_secrets", value)

    @property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksContainerArgs']]]]:
        """
        These containers run before application containers, always runs to completion, and must complete successfully before the next container starts. These containers are registered with the Amazon EKS Connector agent and persists the registration information in the Kubernetes backend data store. For more information, see [Init Containers](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/workloads/pods/init-containers/) in the *Kubernetes documentation* .

        > This object is limited to 10 elements.
        """
        return pulumi.get(self, "init_containers")

    @init_containers.setter
    def init_containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksContainerArgs']]]]):
        pulumi.set(self, "init_containers", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['JobDefinitionEksMetadataArgs']]:
        """
        Metadata about the Kubernetes pod. For more information, see [Understanding Kubernetes Objects](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/kubernetes-objects/) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['JobDefinitionEksMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the service account that's used to run the pod. For more information, see [Kubernetes service accounts](https://docs.aws.amazon.com/eks/latest/userguide/service-accounts.html) and [Configure a Kubernetes service account to assume an IAM role](https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html) in the *Amazon EKS User Guide* and [Configure service accounts for pods](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "service_account_name")

    @service_account_name.setter
    def service_account_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_account_name", value)

    @property
    @pulumi.getter(name="shareProcessNamespace")
    def share_process_namespace(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates if the processes in a container are shared, or visible, to other containers in the same pod. For more information, see [Share Process Namespace between Containers in a Pod](https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/share-process-namespace/) .
        """
        return pulumi.get(self, "share_process_namespace")

    @share_process_namespace.setter
    def share_process_namespace(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "share_process_namespace", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksVolumeArgs']]]]:
        """
        Specifies the volumes for a job definition that uses Amazon EKS resources.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


if not MYPY:
    class JobDefinitionEksPropertiesArgsDict(TypedDict):
        pod_properties: NotRequired[pulumi.Input['JobDefinitionEksPodPropertiesArgsDict']]
        """
        The properties for the Kubernetes pod resources of a job.
        """
elif False:
    JobDefinitionEksPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPropertiesArgs:
    def __init__(__self__, *,
                 pod_properties: Optional[pulumi.Input['JobDefinitionEksPodPropertiesArgs']] = None):
        """
        :param pulumi.Input['JobDefinitionEksPodPropertiesArgs'] pod_properties: The properties for the Kubernetes pod resources of a job.
        """
        if pod_properties is not None:
            pulumi.set(__self__, "pod_properties", pod_properties)

    @property
    @pulumi.getter(name="podProperties")
    def pod_properties(self) -> Optional[pulumi.Input['JobDefinitionEksPodPropertiesArgs']]:
        """
        The properties for the Kubernetes pod resources of a job.
        """
        return pulumi.get(self, "pod_properties")

    @pod_properties.setter
    def pod_properties(self, value: Optional[pulumi.Input['JobDefinitionEksPodPropertiesArgs']]):
        pulumi.set(self, "pod_properties", value)


if not MYPY:
    class JobDefinitionEksSecretArgsDict(TypedDict):
        secret_name: pulumi.Input[builtins.str]
        """
        The name of the secret. The name must be allowed as a DNS subdomain name. For more information, see [DNS subdomain names](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names) in the *Kubernetes documentation* .
        """
        optional: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether the secret or the secret's keys must be defined.
        """
elif False:
    JobDefinitionEksSecretArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksSecretArgs:
    def __init__(__self__, *,
                 secret_name: pulumi.Input[builtins.str],
                 optional: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] secret_name: The name of the secret. The name must be allowed as a DNS subdomain name. For more information, see [DNS subdomain names](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names) in the *Kubernetes documentation* .
        :param pulumi.Input[builtins.bool] optional: Specifies whether the secret or the secret's keys must be defined.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the secret. The name must be allowed as a DNS subdomain name. For more information, see [DNS subdomain names](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "secret_name", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the secret or the secret's keys must be defined.
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "optional", value)


if not MYPY:
    class JobDefinitionEksVolumeArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The name of the volume. The name must be allowed as a DNS subdomain name. For more information, see [DNS subdomain names](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names) in the *Kubernetes documentation* .
        """
        empty_dir: NotRequired[pulumi.Input['JobDefinitionEksEmptyDirArgsDict']]
        """
        Specifies the configuration of a Kubernetes `emptyDir` volume. For more information, see [emptyDir](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#emptydir) in the *Kubernetes documentation* .
        """
        host_path: NotRequired[pulumi.Input['JobDefinitionEksHostPathArgsDict']]
        """
        Specifies the configuration of a Kubernetes `hostPath` volume. For more information, see [hostPath](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#hostpath) in the *Kubernetes documentation* .
        """
        persistent_volume_claim: NotRequired[pulumi.Input['JobDefinitionEksPersistentVolumeClaimArgsDict']]
        """
        Specifies the configuration of a Kubernetes `persistentVolumeClaim` bounded to a `persistentVolume` . For more information, see [Persistent Volume Claims](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims) in the *Kubernetes documentation* .
        """
        secret: NotRequired[pulumi.Input['JobDefinitionEksSecretArgsDict']]
        """
        Specifies the configuration of a Kubernetes `secret` volume. For more information, see [secret](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#secret) in the *Kubernetes documentation* .
        """
elif False:
    JobDefinitionEksVolumeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksVolumeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 empty_dir: Optional[pulumi.Input['JobDefinitionEksEmptyDirArgs']] = None,
                 host_path: Optional[pulumi.Input['JobDefinitionEksHostPathArgs']] = None,
                 persistent_volume_claim: Optional[pulumi.Input['JobDefinitionEksPersistentVolumeClaimArgs']] = None,
                 secret: Optional[pulumi.Input['JobDefinitionEksSecretArgs']] = None):
        """
        :param pulumi.Input[builtins.str] name: The name of the volume. The name must be allowed as a DNS subdomain name. For more information, see [DNS subdomain names](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names) in the *Kubernetes documentation* .
        :param pulumi.Input['JobDefinitionEksEmptyDirArgs'] empty_dir: Specifies the configuration of a Kubernetes `emptyDir` volume. For more information, see [emptyDir](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#emptydir) in the *Kubernetes documentation* .
        :param pulumi.Input['JobDefinitionEksHostPathArgs'] host_path: Specifies the configuration of a Kubernetes `hostPath` volume. For more information, see [hostPath](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#hostpath) in the *Kubernetes documentation* .
        :param pulumi.Input['JobDefinitionEksPersistentVolumeClaimArgs'] persistent_volume_claim: Specifies the configuration of a Kubernetes `persistentVolumeClaim` bounded to a `persistentVolume` . For more information, see [Persistent Volume Claims](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims) in the *Kubernetes documentation* .
        :param pulumi.Input['JobDefinitionEksSecretArgs'] secret: Specifies the configuration of a Kubernetes `secret` volume. For more information, see [secret](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#secret) in the *Kubernetes documentation* .
        """
        pulumi.set(__self__, "name", name)
        if empty_dir is not None:
            pulumi.set(__self__, "empty_dir", empty_dir)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)
        if persistent_volume_claim is not None:
            pulumi.set(__self__, "persistent_volume_claim", persistent_volume_claim)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the volume. The name must be allowed as a DNS subdomain name. For more information, see [DNS subdomain names](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="emptyDir")
    def empty_dir(self) -> Optional[pulumi.Input['JobDefinitionEksEmptyDirArgs']]:
        """
        Specifies the configuration of a Kubernetes `emptyDir` volume. For more information, see [emptyDir](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#emptydir) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "empty_dir")

    @empty_dir.setter
    def empty_dir(self, value: Optional[pulumi.Input['JobDefinitionEksEmptyDirArgs']]):
        pulumi.set(self, "empty_dir", value)

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional[pulumi.Input['JobDefinitionEksHostPathArgs']]:
        """
        Specifies the configuration of a Kubernetes `hostPath` volume. For more information, see [hostPath](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#hostpath) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "host_path")

    @host_path.setter
    def host_path(self, value: Optional[pulumi.Input['JobDefinitionEksHostPathArgs']]):
        pulumi.set(self, "host_path", value)

    @property
    @pulumi.getter(name="persistentVolumeClaim")
    def persistent_volume_claim(self) -> Optional[pulumi.Input['JobDefinitionEksPersistentVolumeClaimArgs']]:
        """
        Specifies the configuration of a Kubernetes `persistentVolumeClaim` bounded to a `persistentVolume` . For more information, see [Persistent Volume Claims](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "persistent_volume_claim")

    @persistent_volume_claim.setter
    def persistent_volume_claim(self, value: Optional[pulumi.Input['JobDefinitionEksPersistentVolumeClaimArgs']]):
        pulumi.set(self, "persistent_volume_claim", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input['JobDefinitionEksSecretArgs']]:
        """
        Specifies the configuration of a Kubernetes `secret` volume. For more information, see [secret](https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#secret) in the *Kubernetes documentation* .
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input['JobDefinitionEksSecretArgs']]):
        pulumi.set(self, "secret", value)


if not MYPY:
    class JobDefinitionEnvironmentArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the environment variable.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        The value of the environment variable.
        """
elif False:
    JobDefinitionEnvironmentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEnvironmentArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: The name of the environment variable.
        :param pulumi.Input[builtins.str] value: The value of the environment variable.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class JobDefinitionEphemeralStorageArgsDict(TypedDict):
        size_in_gi_b: pulumi.Input[builtins.int]
        """
        The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is `21` GiB and the maximum supported value is `200` GiB.
        """
elif False:
    JobDefinitionEphemeralStorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEphemeralStorageArgs:
    def __init__(__self__, *,
                 size_in_gi_b: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] size_in_gi_b: The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is `21` GiB and the maximum supported value is `200` GiB.
        """
        pulumi.set(__self__, "size_in_gi_b", size_in_gi_b)

    @property
    @pulumi.getter(name="sizeInGiB")
    def size_in_gi_b(self) -> pulumi.Input[builtins.int]:
        """
        The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is `21` GiB and the maximum supported value is `200` GiB.
        """
        return pulumi.get(self, "size_in_gi_b")

    @size_in_gi_b.setter
    def size_in_gi_b(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "size_in_gi_b", value)


if not MYPY:
    class JobDefinitionEvaluateOnExitArgsDict(TypedDict):
        action: pulumi.Input[builtins.str]
        """
        Specifies the action to take if all of the specified conditions ( `onStatusReason` , `onReason` , and `onExitCode` ) are met. The values aren't case sensitive.
        """
        on_exit_code: NotRequired[pulumi.Input[builtins.str]]
        """
        Contains a glob pattern to match against the decimal representation of the `ExitCode` returned for a job. The pattern can be up to 512 characters long. It can contain only numbers, and can end with an asterisk (*) so that only the start of the string needs to be an exact match.

        The string can contain up to 512 characters.
        """
        on_reason: NotRequired[pulumi.Input[builtins.str]]
        """
        Contains a glob pattern to match against the `Reason` returned for a job. The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white space (including spaces and tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
        """
        on_status_reason: NotRequired[pulumi.Input[builtins.str]]
        """
        Contains a glob pattern to match against the `StatusReason` returned for a job. The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white spaces (including spaces or tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
        """
elif False:
    JobDefinitionEvaluateOnExitArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEvaluateOnExitArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[builtins.str],
                 on_exit_code: Optional[pulumi.Input[builtins.str]] = None,
                 on_reason: Optional[pulumi.Input[builtins.str]] = None,
                 on_status_reason: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] action: Specifies the action to take if all of the specified conditions ( `onStatusReason` , `onReason` , and `onExitCode` ) are met. The values aren't case sensitive.
        :param pulumi.Input[builtins.str] on_exit_code: Contains a glob pattern to match against the decimal representation of the `ExitCode` returned for a job. The pattern can be up to 512 characters long. It can contain only numbers, and can end with an asterisk (*) so that only the start of the string needs to be an exact match.
               
               The string can contain up to 512 characters.
        :param pulumi.Input[builtins.str] on_reason: Contains a glob pattern to match against the `Reason` returned for a job. The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white space (including spaces and tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
        :param pulumi.Input[builtins.str] on_status_reason: Contains a glob pattern to match against the `StatusReason` returned for a job. The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white spaces (including spaces or tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
        """
        pulumi.set(__self__, "action", action)
        if on_exit_code is not None:
            pulumi.set(__self__, "on_exit_code", on_exit_code)
        if on_reason is not None:
            pulumi.set(__self__, "on_reason", on_reason)
        if on_status_reason is not None:
            pulumi.set(__self__, "on_status_reason", on_status_reason)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the action to take if all of the specified conditions ( `onStatusReason` , `onReason` , and `onExitCode` ) are met. The values aren't case sensitive.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="onExitCode")
    def on_exit_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Contains a glob pattern to match against the decimal representation of the `ExitCode` returned for a job. The pattern can be up to 512 characters long. It can contain only numbers, and can end with an asterisk (*) so that only the start of the string needs to be an exact match.

        The string can contain up to 512 characters.
        """
        return pulumi.get(self, "on_exit_code")

    @on_exit_code.setter
    def on_exit_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_exit_code", value)

    @property
    @pulumi.getter(name="onReason")
    def on_reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Contains a glob pattern to match against the `Reason` returned for a job. The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white space (including spaces and tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
        """
        return pulumi.get(self, "on_reason")

    @on_reason.setter
    def on_reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_reason", value)

    @property
    @pulumi.getter(name="onStatusReason")
    def on_status_reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Contains a glob pattern to match against the `StatusReason` returned for a job. The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white spaces (including spaces or tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
        """
        return pulumi.get(self, "on_status_reason")

    @on_status_reason.setter
    def on_status_reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_status_reason", value)


if not MYPY:
    class JobDefinitionHostArgsDict(TypedDict):
        source_path: NotRequired[pulumi.Input[builtins.str]]
        """
        The path on the host container instance that's presented to the container. If this parameter is empty, then the Docker daemon has assigned a host path for you. If this parameter contains a file location, then the data volume persists at the specified location on the host container instance until you delete it manually. If the source path location doesn't exist on the host container instance, the Docker daemon creates it. If the location does exist, the contents of the source path folder are exported.

        > This parameter isn't applicable to jobs that run on Fargate resources. Don't provide this for these jobs.
        """
elif False:
    JobDefinitionHostArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionHostArgs:
    def __init__(__self__, *,
                 source_path: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] source_path: The path on the host container instance that's presented to the container. If this parameter is empty, then the Docker daemon has assigned a host path for you. If this parameter contains a file location, then the data volume persists at the specified location on the host container instance until you delete it manually. If the source path location doesn't exist on the host container instance, the Docker daemon creates it. If the location does exist, the contents of the source path folder are exported.
               
               > This parameter isn't applicable to jobs that run on Fargate resources. Don't provide this for these jobs.
        """
        if source_path is not None:
            pulumi.set(__self__, "source_path", source_path)

    @property
    @pulumi.getter(name="sourcePath")
    def source_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path on the host container instance that's presented to the container. If this parameter is empty, then the Docker daemon has assigned a host path for you. If this parameter contains a file location, then the data volume persists at the specified location on the host container instance until you delete it manually. If the source path location doesn't exist on the host container instance, the Docker daemon creates it. If the location does exist, the contents of the source path folder are exported.

        > This parameter isn't applicable to jobs that run on Fargate resources. Don't provide this for these jobs.
        """
        return pulumi.get(self, "source_path")

    @source_path.setter
    def source_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_path", value)


if not MYPY:
    class JobDefinitionImagePullSecretArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Provides a unique identifier for the `ImagePullSecret` . This object is required when `EksPodProperties$imagePullSecrets` is used.
        """
elif False:
    JobDefinitionImagePullSecretArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionImagePullSecretArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: Provides a unique identifier for the `ImagePullSecret` . This object is required when `EksPodProperties$imagePullSecrets` is used.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Provides a unique identifier for the `ImagePullSecret` . This object is required when `EksPodProperties$imagePullSecrets` is used.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class JobDefinitionJobTimeoutArgsDict(TypedDict):
        attempt_duration_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        The job timeout time (in seconds) that's measured from the job attempt's `startedAt` timestamp. After this time passes, AWS Batch terminates your jobs if they aren't finished. The minimum value for the timeout is 60 seconds.

        For array jobs, the timeout applies to the child jobs, not to the parent array job.

        For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not to the individual nodes.
        """
elif False:
    JobDefinitionJobTimeoutArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionJobTimeoutArgs:
    def __init__(__self__, *,
                 attempt_duration_seconds: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] attempt_duration_seconds: The job timeout time (in seconds) that's measured from the job attempt's `startedAt` timestamp. After this time passes, AWS Batch terminates your jobs if they aren't finished. The minimum value for the timeout is 60 seconds.
               
               For array jobs, the timeout applies to the child jobs, not to the parent array job.
               
               For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not to the individual nodes.
        """
        if attempt_duration_seconds is not None:
            pulumi.set(__self__, "attempt_duration_seconds", attempt_duration_seconds)

    @property
    @pulumi.getter(name="attemptDurationSeconds")
    def attempt_duration_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The job timeout time (in seconds) that's measured from the job attempt's `startedAt` timestamp. After this time passes, AWS Batch terminates your jobs if they aren't finished. The minimum value for the timeout is 60 seconds.

        For array jobs, the timeout applies to the child jobs, not to the parent array job.

        For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not to the individual nodes.
        """
        return pulumi.get(self, "attempt_duration_seconds")

    @attempt_duration_seconds.setter
    def attempt_duration_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "attempt_duration_seconds", value)


if not MYPY:
    class JobDefinitionLinuxParametersArgsDict(TypedDict):
        devices: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionDeviceArgsDict']]]]
        """
        Any of the host devices to expose to the container. This parameter maps to `Devices` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--device` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
        """
        init_process_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        If true, run an `init` process inside the container that forwards signals and reaps processes. This parameter maps to the `--init` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
        """
        max_swap: NotRequired[pulumi.Input[builtins.int]]
        """
        The total amount of swap memory (in MiB) a container can use. This parameter is translated to the `--memory-swap` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) where the value is the sum of the container memory plus the `maxSwap` value. For more information, see [`--memory-swap` details](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/resource_constraints/#--memory-swap-details) in the Docker documentation.

        If a `maxSwap` value of `0` is specified, the container doesn't use swap. Accepted values are `0` or any positive integer. If the `maxSwap` parameter is omitted, the container doesn't use the swap configuration for the container instance on which it runs. A `maxSwap` value must be set for the `swappiness` parameter to be used.

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
        """
        shared_memory_size: NotRequired[pulumi.Input[builtins.int]]
        """
        The value for the size (in MiB) of the `/dev/shm` volume. This parameter maps to the `--shm-size` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
        """
        swappiness: NotRequired[pulumi.Input[builtins.int]]
        """
        You can use this parameter to tune a container's memory swappiness behavior. A `swappiness` value of `0` causes swapping to not occur unless absolutely necessary. A `swappiness` value of `100` causes pages to be swapped aggressively. Valid values are whole numbers between `0` and `100` . If the `swappiness` parameter isn't specified, a default value of `60` is used. If a value isn't specified for `maxSwap` , then this parameter is ignored. If `maxSwap` is set to 0, the container doesn't use swap. This parameter maps to the `--memory-swappiness` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        Consider the following when you use a per-container swap configuration.

        - Swap space must be enabled and allocated on the container instance for the containers to use.

        > By default, the Amazon ECS optimized AMIs don't have swap enabled. You must enable swap on the instance to use this feature. For more information, see [Instance store swap volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-store-swap-volumes.html) in the *Amazon EC2 User Guide for Linux Instances* or [How do I allocate memory to work as swap space in an Amazon EC2 instance by using a swap file?](https://docs.aws.amazon.com/premiumsupport/knowledge-center/ec2-memory-swap-file/)
        - The swap space parameters are only supported for job definitions using EC2 resources.
        - If the `maxSwap` and `swappiness` parameters are omitted from a job definition, each container has a default `swappiness` value of 60. Moreover, the total swap usage is limited to two times the memory reservation of the container.

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
        """
        tmpfs: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionTmpfsArgsDict']]]]
        """
        The container path, mount options, and size (in MiB) of the `tmpfs` mount. This parameter maps to the `--tmpfs` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide this parameter for this resource type.
        """
elif False:
    JobDefinitionLinuxParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionLinuxParametersArgs:
    def __init__(__self__, *,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionDeviceArgs']]]] = None,
                 init_process_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 max_swap: Optional[pulumi.Input[builtins.int]] = None,
                 shared_memory_size: Optional[pulumi.Input[builtins.int]] = None,
                 swappiness: Optional[pulumi.Input[builtins.int]] = None,
                 tmpfs: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionTmpfsArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionDeviceArgs']]] devices: Any of the host devices to expose to the container. This parameter maps to `Devices` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--device` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
        :param pulumi.Input[builtins.bool] init_process_enabled: If true, run an `init` process inside the container that forwards signals and reaps processes. This parameter maps to the `--init` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
        :param pulumi.Input[builtins.int] max_swap: The total amount of swap memory (in MiB) a container can use. This parameter is translated to the `--memory-swap` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) where the value is the sum of the container memory plus the `maxSwap` value. For more information, see [`--memory-swap` details](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/resource_constraints/#--memory-swap-details) in the Docker documentation.
               
               If a `maxSwap` value of `0` is specified, the container doesn't use swap. Accepted values are `0` or any positive integer. If the `maxSwap` parameter is omitted, the container doesn't use the swap configuration for the container instance on which it runs. A `maxSwap` value must be set for the `swappiness` parameter to be used.
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
        :param pulumi.Input[builtins.int] shared_memory_size: The value for the size (in MiB) of the `/dev/shm` volume. This parameter maps to the `--shm-size` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
        :param pulumi.Input[builtins.int] swappiness: You can use this parameter to tune a container's memory swappiness behavior. A `swappiness` value of `0` causes swapping to not occur unless absolutely necessary. A `swappiness` value of `100` causes pages to be swapped aggressively. Valid values are whole numbers between `0` and `100` . If the `swappiness` parameter isn't specified, a default value of `60` is used. If a value isn't specified for `maxSwap` , then this parameter is ignored. If `maxSwap` is set to 0, the container doesn't use swap. This parameter maps to the `--memory-swappiness` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               Consider the following when you use a per-container swap configuration.
               
               - Swap space must be enabled and allocated on the container instance for the containers to use.
               
               > By default, the Amazon ECS optimized AMIs don't have swap enabled. You must enable swap on the instance to use this feature. For more information, see [Instance store swap volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-store-swap-volumes.html) in the *Amazon EC2 User Guide for Linux Instances* or [How do I allocate memory to work as swap space in an Amazon EC2 instance by using a swap file?](https://docs.aws.amazon.com/premiumsupport/knowledge-center/ec2-memory-swap-file/)
               - The swap space parameters are only supported for job definitions using EC2 resources.
               - If the `maxSwap` and `swappiness` parameters are omitted from a job definition, each container has a default `swappiness` value of 60. Moreover, the total swap usage is limited to two times the memory reservation of the container.
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionTmpfsArgs']]] tmpfs: The container path, mount options, and size (in MiB) of the `tmpfs` mount. This parameter maps to the `--tmpfs` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide this parameter for this resource type.
        """
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if init_process_enabled is not None:
            pulumi.set(__self__, "init_process_enabled", init_process_enabled)
        if max_swap is not None:
            pulumi.set(__self__, "max_swap", max_swap)
        if shared_memory_size is not None:
            pulumi.set(__self__, "shared_memory_size", shared_memory_size)
        if swappiness is not None:
            pulumi.set(__self__, "swappiness", swappiness)
        if tmpfs is not None:
            pulumi.set(__self__, "tmpfs", tmpfs)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionDeviceArgs']]]]:
        """
        Any of the host devices to expose to the container. This parameter maps to `Devices` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--device` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionDeviceArgs']]]]):
        pulumi.set(self, "devices", value)

    @property
    @pulumi.getter(name="initProcessEnabled")
    def init_process_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, run an `init` process inside the container that forwards signals and reaps processes. This parameter maps to the `--init` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
        """
        return pulumi.get(self, "init_process_enabled")

    @init_process_enabled.setter
    def init_process_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "init_process_enabled", value)

    @property
    @pulumi.getter(name="maxSwap")
    def max_swap(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The total amount of swap memory (in MiB) a container can use. This parameter is translated to the `--memory-swap` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) where the value is the sum of the container memory plus the `maxSwap` value. For more information, see [`--memory-swap` details](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/resource_constraints/#--memory-swap-details) in the Docker documentation.

        If a `maxSwap` value of `0` is specified, the container doesn't use swap. Accepted values are `0` or any positive integer. If the `maxSwap` parameter is omitted, the container doesn't use the swap configuration for the container instance on which it runs. A `maxSwap` value must be set for the `swappiness` parameter to be used.

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
        """
        return pulumi.get(self, "max_swap")

    @max_swap.setter
    def max_swap(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_swap", value)

    @property
    @pulumi.getter(name="sharedMemorySize")
    def shared_memory_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The value for the size (in MiB) of the `/dev/shm` volume. This parameter maps to the `--shm-size` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
        """
        return pulumi.get(self, "shared_memory_size")

    @shared_memory_size.setter
    def shared_memory_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "shared_memory_size", value)

    @property
    @pulumi.getter
    def swappiness(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        You can use this parameter to tune a container's memory swappiness behavior. A `swappiness` value of `0` causes swapping to not occur unless absolutely necessary. A `swappiness` value of `100` causes pages to be swapped aggressively. Valid values are whole numbers between `0` and `100` . If the `swappiness` parameter isn't specified, a default value of `60` is used. If a value isn't specified for `maxSwap` , then this parameter is ignored. If `maxSwap` is set to 0, the container doesn't use swap. This parameter maps to the `--memory-swappiness` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        Consider the following when you use a per-container swap configuration.

        - Swap space must be enabled and allocated on the container instance for the containers to use.

        > By default, the Amazon ECS optimized AMIs don't have swap enabled. You must enable swap on the instance to use this feature. For more information, see [Instance store swap volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-store-swap-volumes.html) in the *Amazon EC2 User Guide for Linux Instances* or [How do I allocate memory to work as swap space in an Amazon EC2 instance by using a swap file?](https://docs.aws.amazon.com/premiumsupport/knowledge-center/ec2-memory-swap-file/)
        - The swap space parameters are only supported for job definitions using EC2 resources.
        - If the `maxSwap` and `swappiness` parameters are omitted from a job definition, each container has a default `swappiness` value of 60. Moreover, the total swap usage is limited to two times the memory reservation of the container.

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
        """
        return pulumi.get(self, "swappiness")

    @swappiness.setter
    def swappiness(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "swappiness", value)

    @property
    @pulumi.getter
    def tmpfs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionTmpfsArgs']]]]:
        """
        The container path, mount options, and size (in MiB) of the `tmpfs` mount. This parameter maps to the `--tmpfs` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide this parameter for this resource type.
        """
        return pulumi.get(self, "tmpfs")

    @tmpfs.setter
    def tmpfs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionTmpfsArgs']]]]):
        pulumi.set(self, "tmpfs", value)


if not MYPY:
    class JobDefinitionLogConfigurationArgsDict(TypedDict):
        log_driver: pulumi.Input[builtins.str]
        """
        The log driver to use for the container. The valid values that are listed for this parameter are log drivers that the Amazon ECS container agent can communicate with by default.

        The supported log drivers are `awslogs` , `fluentd` , `gelf` , `json-file` , `journald` , `logentries` , `syslog` , and `splunk` .

        > Jobs that are running on Fargate resources are restricted to the `awslogs` and `splunk` log drivers. 

        - **awsfirelens** - Specifies the firelens logging driver. For more information on configuring Firelens, see [Send Amazon ECS logs to an AWS service or AWS Partner](https://docs.aws.amazon.com//AmazonECS/latest/developerguide/using_firelens.html) in the *Amazon Elastic Container Service Developer Guide* .
        - **awslogs** - Specifies the Amazon CloudWatch Logs logging driver. For more information, see [Using the awslogs log driver](https://docs.aws.amazon.com/batch/latest/userguide/using_awslogs.html) in the *AWS Batch User Guide* and [Amazon CloudWatch Logs logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/awslogs/) in the Docker documentation.
        - **fluentd** - Specifies the Fluentd logging driver. For more information including usage and options, see [Fluentd logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/fluentd/) in the *Docker documentation* .
        - **gelf** - Specifies the Graylog Extended Format (GELF) logging driver. For more information including usage and options, see [Graylog Extended Format logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/gelf/) in the *Docker documentation* .
        - **journald** - Specifies the journald logging driver. For more information including usage and options, see [Journald logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/journald/) in the *Docker documentation* .
        - **json-file** - Specifies the JSON file logging driver. For more information including usage and options, see [JSON File logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/json-file/) in the *Docker documentation* .
        - **splunk** - Specifies the Splunk logging driver. For more information including usage and options, see [Splunk logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/splunk/) in the *Docker documentation* .
        - **syslog** - Specifies the syslog logging driver. For more information including usage and options, see [Syslog logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/syslog/) in the *Docker documentation* .

        > If you have a custom driver that's not listed earlier that you want to work with the Amazon ECS container agent, you can fork the Amazon ECS container agent project that's [available on GitHub](https://docs.aws.amazon.com/https://github.com/aws/amazon-ecs-agent) and customize it to work with that driver. We encourage you to submit pull requests for changes that you want to have included. However, Amazon Web Services doesn't currently support running modified copies of this software. 

        This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
        """
        options: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        The configuration options to send to the log driver. This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
        """
        secret_options: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretArgsDict']]]]
        """
        The secrets to pass to the log configuration. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html) in the *AWS Batch User Guide* .
        """
elif False:
    JobDefinitionLogConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionLogConfigurationArgs:
    def __init__(__self__, *,
                 log_driver: pulumi.Input[builtins.str],
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 secret_options: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] log_driver: The log driver to use for the container. The valid values that are listed for this parameter are log drivers that the Amazon ECS container agent can communicate with by default.
               
               The supported log drivers are `awslogs` , `fluentd` , `gelf` , `json-file` , `journald` , `logentries` , `syslog` , and `splunk` .
               
               > Jobs that are running on Fargate resources are restricted to the `awslogs` and `splunk` log drivers. 
               
               - **awsfirelens** - Specifies the firelens logging driver. For more information on configuring Firelens, see [Send Amazon ECS logs to an AWS service or AWS Partner](https://docs.aws.amazon.com//AmazonECS/latest/developerguide/using_firelens.html) in the *Amazon Elastic Container Service Developer Guide* .
               - **awslogs** - Specifies the Amazon CloudWatch Logs logging driver. For more information, see [Using the awslogs log driver](https://docs.aws.amazon.com/batch/latest/userguide/using_awslogs.html) in the *AWS Batch User Guide* and [Amazon CloudWatch Logs logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/awslogs/) in the Docker documentation.
               - **fluentd** - Specifies the Fluentd logging driver. For more information including usage and options, see [Fluentd logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/fluentd/) in the *Docker documentation* .
               - **gelf** - Specifies the Graylog Extended Format (GELF) logging driver. For more information including usage and options, see [Graylog Extended Format logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/gelf/) in the *Docker documentation* .
               - **journald** - Specifies the journald logging driver. For more information including usage and options, see [Journald logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/journald/) in the *Docker documentation* .
               - **json-file** - Specifies the JSON file logging driver. For more information including usage and options, see [JSON File logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/json-file/) in the *Docker documentation* .
               - **splunk** - Specifies the Splunk logging driver. For more information including usage and options, see [Splunk logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/splunk/) in the *Docker documentation* .
               - **syslog** - Specifies the syslog logging driver. For more information including usage and options, see [Syslog logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/syslog/) in the *Docker documentation* .
               
               > If you have a custom driver that's not listed earlier that you want to work with the Amazon ECS container agent, you can fork the Amazon ECS container agent project that's [available on GitHub](https://docs.aws.amazon.com/https://github.com/aws/amazon-ecs-agent) and customize it to work with that driver. We encourage you to submit pull requests for changes that you want to have included. However, Amazon Web Services doesn't currently support running modified copies of this software. 
               
               This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] options: The configuration options to send to the log driver. This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretArgs']]] secret_options: The secrets to pass to the log configuration. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html) in the *AWS Batch User Guide* .
        """
        pulumi.set(__self__, "log_driver", log_driver)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if secret_options is not None:
            pulumi.set(__self__, "secret_options", secret_options)

    @property
    @pulumi.getter(name="logDriver")
    def log_driver(self) -> pulumi.Input[builtins.str]:
        """
        The log driver to use for the container. The valid values that are listed for this parameter are log drivers that the Amazon ECS container agent can communicate with by default.

        The supported log drivers are `awslogs` , `fluentd` , `gelf` , `json-file` , `journald` , `logentries` , `syslog` , and `splunk` .

        > Jobs that are running on Fargate resources are restricted to the `awslogs` and `splunk` log drivers. 

        - **awsfirelens** - Specifies the firelens logging driver. For more information on configuring Firelens, see [Send Amazon ECS logs to an AWS service or AWS Partner](https://docs.aws.amazon.com//AmazonECS/latest/developerguide/using_firelens.html) in the *Amazon Elastic Container Service Developer Guide* .
        - **awslogs** - Specifies the Amazon CloudWatch Logs logging driver. For more information, see [Using the awslogs log driver](https://docs.aws.amazon.com/batch/latest/userguide/using_awslogs.html) in the *AWS Batch User Guide* and [Amazon CloudWatch Logs logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/awslogs/) in the Docker documentation.
        - **fluentd** - Specifies the Fluentd logging driver. For more information including usage and options, see [Fluentd logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/fluentd/) in the *Docker documentation* .
        - **gelf** - Specifies the Graylog Extended Format (GELF) logging driver. For more information including usage and options, see [Graylog Extended Format logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/gelf/) in the *Docker documentation* .
        - **journald** - Specifies the journald logging driver. For more information including usage and options, see [Journald logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/journald/) in the *Docker documentation* .
        - **json-file** - Specifies the JSON file logging driver. For more information including usage and options, see [JSON File logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/json-file/) in the *Docker documentation* .
        - **splunk** - Specifies the Splunk logging driver. For more information including usage and options, see [Splunk logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/splunk/) in the *Docker documentation* .
        - **syslog** - Specifies the syslog logging driver. For more information including usage and options, see [Syslog logging driver](https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/syslog/) in the *Docker documentation* .

        > If you have a custom driver that's not listed earlier that you want to work with the Amazon ECS container agent, you can fork the Amazon ECS container agent project that's [available on GitHub](https://docs.aws.amazon.com/https://github.com/aws/amazon-ecs-agent) and customize it to work with that driver. We encourage you to submit pull requests for changes that you want to have included. However, Amazon Web Services doesn't currently support running modified copies of this software. 

        This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
        """
        return pulumi.get(self, "log_driver")

    @log_driver.setter
    def log_driver(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "log_driver", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The configuration options to send to the log driver. This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="secretOptions")
    def secret_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretArgs']]]]:
        """
        The secrets to pass to the log configuration. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "secret_options")

    @secret_options.setter
    def secret_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretArgs']]]]):
        pulumi.set(self, "secret_options", value)


if not MYPY:
    class JobDefinitionMountPointArgsDict(TypedDict):
        container_path: NotRequired[pulumi.Input[builtins.str]]
        """
        The path on the container where the host volume is mounted.
        """
        read_only: NotRequired[pulumi.Input[builtins.bool]]
        """
        If this value is `true` , the container has read-only access to the volume. Otherwise, the container can write to the volume. The default value is `false` .
        """
        source_volume: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the volume to mount.
        """
elif False:
    JobDefinitionMountPointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionMountPointArgs:
    def __init__(__self__, *,
                 container_path: Optional[pulumi.Input[builtins.str]] = None,
                 read_only: Optional[pulumi.Input[builtins.bool]] = None,
                 source_volume: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] container_path: The path on the container where the host volume is mounted.
        :param pulumi.Input[builtins.bool] read_only: If this value is `true` , the container has read-only access to the volume. Otherwise, the container can write to the volume. The default value is `false` .
        :param pulumi.Input[builtins.str] source_volume: The name of the volume to mount.
        """
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if source_volume is not None:
            pulumi.set(__self__, "source_volume", source_volume)

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path on the container where the host volume is mounted.
        """
        return pulumi.get(self, "container_path")

    @container_path.setter
    def container_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "container_path", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If this value is `true` , the container has read-only access to the volume. Otherwise, the container can write to the volume. The default value is `false` .
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="sourceVolume")
    def source_volume(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the volume to mount.
        """
        return pulumi.get(self, "source_volume")

    @source_volume.setter
    def source_volume(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_volume", value)


if not MYPY:
    class JobDefinitionMultiNodeContainerPropertiesArgsDict(TypedDict):
        image: pulumi.Input[builtins.str]
        """
        Required. The image used to start a container. This string is passed directly to the Docker daemon. Images in the Docker Hub registry are available by default. Other repositories are specified with `*repository-url* / *image* : *tag*` . It can be 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), underscores (_), colons (:), periods (.), forward slashes (/), and number signs (#). This parameter maps to `Image` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `IMAGE` parameter of [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > Docker image architecture must match the processor architecture of the compute resources that they're scheduled on. For example, ARM-based Docker images can only run on ARM-based compute resources. 

        - Images in Amazon ECR Public repositories use the full `registry/repository[:tag]` or `registry/repository[@digest]` naming conventions. For example, `public.ecr.aws/ *registry_alias* / *my-web-app* : *latest*` .
        - Images in Amazon ECR repositories use the full registry and repository URI (for example, `123456789012.dkr.ecr.<region-name>.amazonaws.com/<repository-name>` ).
        - Images in official repositories on Docker Hub use a single name (for example, `ubuntu` or `mongo` ).
        - Images in other repositories on Docker Hub are qualified with an organization name (for example, `amazon/amazon-ecs-agent` ).
        - Images in other online repositories are qualified further by a domain name (for example, `quay.io/assemblyline/ubuntu` ).
        """
        command: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The command that's passed to the container. This parameter maps to `Cmd` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `COMMAND` parameter to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . For more information, see [https://docs.docker.com/engine/reference/builder/#cmd](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd) .
        """
        enable_execute_command: NotRequired[pulumi.Input[builtins.bool]]
        """
        Determines whether execute command functionality is turned on for this task. If `true` , execute command functionality is turned on all the containers in the task.
        """
        environment: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEnvironmentArgsDict']]]]
        """
        The environment variables to pass to a container. This parameter maps to `Env` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--env` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > We don't recommend using plaintext environment variables for sensitive information, such as credential data. > Environment variables cannot start with " `AWS_BATCH` ". This naming convention is reserved for variables that AWS Batch sets.
        """
        ephemeral_storage: NotRequired[pulumi.Input['JobDefinitionEphemeralStorageArgsDict']]
        """
        The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
        """
        execution_role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [AWS Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *AWS Batch User Guide* .
        """
        instance_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The instance type to use for a multi-node parallel job. All node groups in a multi-node parallel job must use the same instance type.

        > This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
        """
        job_role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions. For more information, see [IAM roles for tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        linux_parameters: NotRequired[pulumi.Input['JobDefinitionLinuxParametersArgsDict']]
        """
        Linux-specific modifications that are applied to the container, such as details for device mappings.
        """
        log_configuration: NotRequired[pulumi.Input['JobDefinitionLogConfigurationArgsDict']]
        """
        The log configuration specification for the container.

        This parameter maps to `LogConfig` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--log-driver` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . By default, containers use the same logging driver that the Docker daemon uses. However the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see [Configure logging drivers](https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/) in the Docker documentation.

        > AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the [LogConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html) data type). 

        This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`

        > The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        memory: NotRequired[pulumi.Input[builtins.int]]
        """
        This parameter is deprecated, use `resourceRequirements` to specify the memory requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs that run on Amazon EC2 resources, it specifies the memory hard limit (in MiB) for a container. If your container attempts to exceed the specified number, it's terminated. You must specify at least 4 MiB of memory for a job using this parameter. The memory hard limit can be specified in several places. It must be specified for each node at least once.
        """
        mount_points: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionMountPointArgsDict']]]]
        """
        The mount points for data volumes in your container.

        This parameter maps to `Volumes` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the [--volume](https://docs.aws.amazon.com/) option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .

        Windows containers can mount whole directories on the same drive as `$env:ProgramData` . Windows containers can't mount directories on a different drive, and mount point can't be across drives.
        """
        privileged: NotRequired[pulumi.Input[builtins.bool]]
        """
        When this parameter is true, the container is given elevated permissions on the host container instance (similar to the `root` user). This parameter maps to `Privileged` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--privileged` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . The default value is false.

        > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided, or specified as false.
        """
        readonly_root_filesystem: NotRequired[pulumi.Input[builtins.bool]]
        """
        When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--read-only` option to `docker run` .
        """
        repository_credentials: NotRequired[pulumi.Input['JobDefinitionRepositoryCredentialsArgsDict']]
        """
        The private repository authentication credentials to use.
        """
        resource_requirements: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionResourceRequirementArgsDict']]]]
        """
        The type and amount of resources to assign to a container. The supported resources include `GPU` , `MEMORY` , and `VCPU` .
        """
        runtime_platform: NotRequired[pulumi.Input['JobDefinitionRuntimePlatformArgsDict']]
        """
        An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
        """
        secrets: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretArgsDict']]]]
        """
        The secrets for the container. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html) in the *AWS Batch User Guide* .
        """
        ulimits: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionUlimitArgsDict']]]]
        """
        A list of `ulimits` to set in the container. This parameter maps to `Ulimits` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--ulimit` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
        """
        user: NotRequired[pulumi.Input[builtins.str]]
        """
        The user name to use inside the container. This parameter maps to `User` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--user` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
        """
        vcpus: NotRequired[pulumi.Input[builtins.int]]
        """
        This parameter is deprecated, use `resourceRequirements` to specify the vCPU requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs running on Amazon EC2 resources, it specifies the number of vCPUs reserved for the job.

        Each vCPU is equivalent to 1,024 CPU shares. This parameter maps to `CpuShares` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . The number of vCPUs must be specified but can be specified in several places. You must specify it at least once for each node.
        """
        volumes: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionVolumeArgsDict']]]]
        """
        A list of data volumes used in a job.
        """
elif False:
    JobDefinitionMultiNodeContainerPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionMultiNodeContainerPropertiesArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[builtins.str],
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 enable_execute_command: Optional[pulumi.Input[builtins.bool]] = None,
                 environment: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEnvironmentArgs']]]] = None,
                 ephemeral_storage: Optional[pulumi.Input['JobDefinitionEphemeralStorageArgs']] = None,
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 job_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 linux_parameters: Optional[pulumi.Input['JobDefinitionLinuxParametersArgs']] = None,
                 log_configuration: Optional[pulumi.Input['JobDefinitionLogConfigurationArgs']] = None,
                 memory: Optional[pulumi.Input[builtins.int]] = None,
                 mount_points: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionMountPointArgs']]]] = None,
                 privileged: Optional[pulumi.Input[builtins.bool]] = None,
                 readonly_root_filesystem: Optional[pulumi.Input[builtins.bool]] = None,
                 repository_credentials: Optional[pulumi.Input['JobDefinitionRepositoryCredentialsArgs']] = None,
                 resource_requirements: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionResourceRequirementArgs']]]] = None,
                 runtime_platform: Optional[pulumi.Input['JobDefinitionRuntimePlatformArgs']] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretArgs']]]] = None,
                 ulimits: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionUlimitArgs']]]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 vcpus: Optional[pulumi.Input[builtins.int]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionVolumeArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] image: Required. The image used to start a container. This string is passed directly to the Docker daemon. Images in the Docker Hub registry are available by default. Other repositories are specified with `*repository-url* / *image* : *tag*` . It can be 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), underscores (_), colons (:), periods (.), forward slashes (/), and number signs (#). This parameter maps to `Image` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `IMAGE` parameter of [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > Docker image architecture must match the processor architecture of the compute resources that they're scheduled on. For example, ARM-based Docker images can only run on ARM-based compute resources. 
               
               - Images in Amazon ECR Public repositories use the full `registry/repository[:tag]` or `registry/repository[@digest]` naming conventions. For example, `public.ecr.aws/ *registry_alias* / *my-web-app* : *latest*` .
               - Images in Amazon ECR repositories use the full registry and repository URI (for example, `123456789012.dkr.ecr.<region-name>.amazonaws.com/<repository-name>` ).
               - Images in official repositories on Docker Hub use a single name (for example, `ubuntu` or `mongo` ).
               - Images in other repositories on Docker Hub are qualified with an organization name (for example, `amazon/amazon-ecs-agent` ).
               - Images in other online repositories are qualified further by a domain name (for example, `quay.io/assemblyline/ubuntu` ).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] command: The command that's passed to the container. This parameter maps to `Cmd` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `COMMAND` parameter to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . For more information, see [https://docs.docker.com/engine/reference/builder/#cmd](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd) .
        :param pulumi.Input[builtins.bool] enable_execute_command: Determines whether execute command functionality is turned on for this task. If `true` , execute command functionality is turned on all the containers in the task.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEnvironmentArgs']]] environment: The environment variables to pass to a container. This parameter maps to `Env` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--env` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > We don't recommend using plaintext environment variables for sensitive information, such as credential data. > Environment variables cannot start with " `AWS_BATCH` ". This naming convention is reserved for variables that AWS Batch sets.
        :param pulumi.Input['JobDefinitionEphemeralStorageArgs'] ephemeral_storage: The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
        :param pulumi.Input[builtins.str] execution_role_arn: The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [AWS Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *AWS Batch User Guide* .
        :param pulumi.Input[builtins.str] instance_type: The instance type to use for a multi-node parallel job. All node groups in a multi-node parallel job must use the same instance type.
               
               > This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
        :param pulumi.Input[builtins.str] job_role_arn: The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions. For more information, see [IAM roles for tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param pulumi.Input['JobDefinitionLinuxParametersArgs'] linux_parameters: Linux-specific modifications that are applied to the container, such as details for device mappings.
        :param pulumi.Input['JobDefinitionLogConfigurationArgs'] log_configuration: The log configuration specification for the container.
               
               This parameter maps to `LogConfig` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--log-driver` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . By default, containers use the same logging driver that the Docker daemon uses. However the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see [Configure logging drivers](https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/) in the Docker documentation.
               
               > AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the [LogConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html) data type). 
               
               This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
               
               > The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param pulumi.Input[builtins.int] memory: This parameter is deprecated, use `resourceRequirements` to specify the memory requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs that run on Amazon EC2 resources, it specifies the memory hard limit (in MiB) for a container. If your container attempts to exceed the specified number, it's terminated. You must specify at least 4 MiB of memory for a job using this parameter. The memory hard limit can be specified in several places. It must be specified for each node at least once.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionMountPointArgs']]] mount_points: The mount points for data volumes in your container.
               
               This parameter maps to `Volumes` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the [--volume](https://docs.aws.amazon.com/) option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .
               
               Windows containers can mount whole directories on the same drive as `$env:ProgramData` . Windows containers can't mount directories on a different drive, and mount point can't be across drives.
        :param pulumi.Input[builtins.bool] privileged: When this parameter is true, the container is given elevated permissions on the host container instance (similar to the `root` user). This parameter maps to `Privileged` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--privileged` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . The default value is false.
               
               > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided, or specified as false.
        :param pulumi.Input[builtins.bool] readonly_root_filesystem: When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--read-only` option to `docker run` .
        :param pulumi.Input['JobDefinitionRepositoryCredentialsArgs'] repository_credentials: The private repository authentication credentials to use.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionResourceRequirementArgs']]] resource_requirements: The type and amount of resources to assign to a container. The supported resources include `GPU` , `MEMORY` , and `VCPU` .
        :param pulumi.Input['JobDefinitionRuntimePlatformArgs'] runtime_platform: An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretArgs']]] secrets: The secrets for the container. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html) in the *AWS Batch User Guide* .
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionUlimitArgs']]] ulimits: A list of `ulimits` to set in the container. This parameter maps to `Ulimits` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--ulimit` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
        :param pulumi.Input[builtins.str] user: The user name to use inside the container. This parameter maps to `User` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--user` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
        :param pulumi.Input[builtins.int] vcpus: This parameter is deprecated, use `resourceRequirements` to specify the vCPU requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs running on Amazon EC2 resources, it specifies the number of vCPUs reserved for the job.
               
               Each vCPU is equivalent to 1,024 CPU shares. This parameter maps to `CpuShares` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . The number of vCPUs must be specified but can be specified in several places. You must specify it at least once for each node.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionVolumeArgs']]] volumes: A list of data volumes used in a job.
        """
        pulumi.set(__self__, "image", image)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if enable_execute_command is not None:
            pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if job_role_arn is not None:
            pulumi.set(__self__, "job_role_arn", job_role_arn)
        if linux_parameters is not None:
            pulumi.set(__self__, "linux_parameters", linux_parameters)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if mount_points is not None:
            pulumi.set(__self__, "mount_points", mount_points)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if readonly_root_filesystem is not None:
            pulumi.set(__self__, "readonly_root_filesystem", readonly_root_filesystem)
        if repository_credentials is not None:
            pulumi.set(__self__, "repository_credentials", repository_credentials)
        if resource_requirements is not None:
            pulumi.set(__self__, "resource_requirements", resource_requirements)
        if runtime_platform is not None:
            pulumi.set(__self__, "runtime_platform", runtime_platform)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if ulimits is not None:
            pulumi.set(__self__, "ulimits", ulimits)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if vcpus is not None:
            pulumi.set(__self__, "vcpus", vcpus)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[builtins.str]:
        """
        Required. The image used to start a container. This string is passed directly to the Docker daemon. Images in the Docker Hub registry are available by default. Other repositories are specified with `*repository-url* / *image* : *tag*` . It can be 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), underscores (_), colons (:), periods (.), forward slashes (/), and number signs (#). This parameter maps to `Image` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `IMAGE` parameter of [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > Docker image architecture must match the processor architecture of the compute resources that they're scheduled on. For example, ARM-based Docker images can only run on ARM-based compute resources. 

        - Images in Amazon ECR Public repositories use the full `registry/repository[:tag]` or `registry/repository[@digest]` naming conventions. For example, `public.ecr.aws/ *registry_alias* / *my-web-app* : *latest*` .
        - Images in Amazon ECR repositories use the full registry and repository URI (for example, `123456789012.dkr.ecr.<region-name>.amazonaws.com/<repository-name>` ).
        - Images in official repositories on Docker Hub use a single name (for example, `ubuntu` or `mongo` ).
        - Images in other repositories on Docker Hub are qualified with an organization name (for example, `amazon/amazon-ecs-agent` ).
        - Images in other online repositories are qualified further by a domain name (for example, `quay.io/assemblyline/ubuntu` ).
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The command that's passed to the container. This parameter maps to `Cmd` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `COMMAND` parameter to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . For more information, see [https://docs.docker.com/engine/reference/builder/#cmd](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd) .
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines whether execute command functionality is turned on for this task. If `true` , execute command functionality is turned on all the containers in the task.
        """
        return pulumi.get(self, "enable_execute_command")

    @enable_execute_command.setter
    def enable_execute_command(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_execute_command", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEnvironmentArgs']]]]:
        """
        The environment variables to pass to a container. This parameter maps to `Env` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--env` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > We don't recommend using plaintext environment variables for sensitive information, such as credential data. > Environment variables cannot start with " `AWS_BATCH` ". This naming convention is reserved for variables that AWS Batch sets.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEnvironmentArgs']]]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input['JobDefinitionEphemeralStorageArgs']]:
        """
        The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate .
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input['JobDefinitionEphemeralStorageArgs']]):
        pulumi.set(self, "ephemeral_storage", value)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [AWS Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The instance type to use for a multi-node parallel job. All node groups in a multi-node parallel job must use the same instance type.

        > This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="jobRoleArn")
    def job_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions. For more information, see [IAM roles for tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "job_role_arn")

    @job_role_arn.setter
    def job_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_role_arn", value)

    @property
    @pulumi.getter(name="linuxParameters")
    def linux_parameters(self) -> Optional[pulumi.Input['JobDefinitionLinuxParametersArgs']]:
        """
        Linux-specific modifications that are applied to the container, such as details for device mappings.
        """
        return pulumi.get(self, "linux_parameters")

    @linux_parameters.setter
    def linux_parameters(self, value: Optional[pulumi.Input['JobDefinitionLinuxParametersArgs']]):
        pulumi.set(self, "linux_parameters", value)

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional[pulumi.Input['JobDefinitionLogConfigurationArgs']]:
        """
        The log configuration specification for the container.

        This parameter maps to `LogConfig` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--log-driver` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . By default, containers use the same logging driver that the Docker daemon uses. However the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see [Configure logging drivers](https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/) in the Docker documentation.

        > AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the [LogConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html) data type). 

        This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`

        > The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "log_configuration")

    @log_configuration.setter
    def log_configuration(self, value: Optional[pulumi.Input['JobDefinitionLogConfigurationArgs']]):
        pulumi.set(self, "log_configuration", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        This parameter is deprecated, use `resourceRequirements` to specify the memory requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs that run on Amazon EC2 resources, it specifies the memory hard limit (in MiB) for a container. If your container attempts to exceed the specified number, it's terminated. You must specify at least 4 MiB of memory for a job using this parameter. The memory hard limit can be specified in several places. It must be specified for each node at least once.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionMountPointArgs']]]]:
        """
        The mount points for data volumes in your container.

        This parameter maps to `Volumes` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the [--volume](https://docs.aws.amazon.com/) option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .

        Windows containers can mount whole directories on the same drive as `$env:ProgramData` . Windows containers can't mount directories on a different drive, and mount point can't be across drives.
        """
        return pulumi.get(self, "mount_points")

    @mount_points.setter
    def mount_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionMountPointArgs']]]]):
        pulumi.set(self, "mount_points", value)

    @property
    @pulumi.getter
    def privileged(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When this parameter is true, the container is given elevated permissions on the host container instance (similar to the `root` user). This parameter maps to `Privileged` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--privileged` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . The default value is false.

        > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided, or specified as false.
        """
        return pulumi.get(self, "privileged")

    @privileged.setter
    def privileged(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "privileged", value)

    @property
    @pulumi.getter(name="readonlyRootFilesystem")
    def readonly_root_filesystem(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--read-only` option to `docker run` .
        """
        return pulumi.get(self, "readonly_root_filesystem")

    @readonly_root_filesystem.setter
    def readonly_root_filesystem(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "readonly_root_filesystem", value)

    @property
    @pulumi.getter(name="repositoryCredentials")
    def repository_credentials(self) -> Optional[pulumi.Input['JobDefinitionRepositoryCredentialsArgs']]:
        """
        The private repository authentication credentials to use.
        """
        return pulumi.get(self, "repository_credentials")

    @repository_credentials.setter
    def repository_credentials(self, value: Optional[pulumi.Input['JobDefinitionRepositoryCredentialsArgs']]):
        pulumi.set(self, "repository_credentials", value)

    @property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionResourceRequirementArgs']]]]:
        """
        The type and amount of resources to assign to a container. The supported resources include `GPU` , `MEMORY` , and `VCPU` .
        """
        return pulumi.get(self, "resource_requirements")

    @resource_requirements.setter
    def resource_requirements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionResourceRequirementArgs']]]]):
        pulumi.set(self, "resource_requirements", value)

    @property
    @pulumi.getter(name="runtimePlatform")
    def runtime_platform(self) -> Optional[pulumi.Input['JobDefinitionRuntimePlatformArgs']]:
        """
        An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
        """
        return pulumi.get(self, "runtime_platform")

    @runtime_platform.setter
    def runtime_platform(self, value: Optional[pulumi.Input['JobDefinitionRuntimePlatformArgs']]):
        pulumi.set(self, "runtime_platform", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretArgs']]]]:
        """
        The secrets for the container. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter
    def ulimits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionUlimitArgs']]]]:
        """
        A list of `ulimits` to set in the container. This parameter maps to `Ulimits` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--ulimit` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
        """
        return pulumi.get(self, "ulimits")

    @ulimits.setter
    def ulimits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionUlimitArgs']]]]):
        pulumi.set(self, "ulimits", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user name to use inside the container. This parameter maps to `User` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--user` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter
    def vcpus(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        This parameter is deprecated, use `resourceRequirements` to specify the vCPU requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs running on Amazon EC2 resources, it specifies the number of vCPUs reserved for the job.

        Each vCPU is equivalent to 1,024 CPU shares. This parameter maps to `CpuShares` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . The number of vCPUs must be specified but can be specified in several places. You must specify it at least once for each node.
        """
        return pulumi.get(self, "vcpus")

    @vcpus.setter
    def vcpus(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vcpus", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionVolumeArgs']]]]:
        """
        A list of data volumes used in a job.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


if not MYPY:
    class JobDefinitionMultiNodeEcsPropertiesArgsDict(TypedDict):
        task_properties: pulumi.Input[Sequence[pulumi.Input['JobDefinitionMultiNodeEcsTaskPropertiesArgsDict']]]
        """
        An object that contains the properties for the Amazon ECS task definition of a job.

        > This object is currently limited to one task element. However, the task element can run up to 10 containers.
        """
elif False:
    JobDefinitionMultiNodeEcsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionMultiNodeEcsPropertiesArgs:
    def __init__(__self__, *,
                 task_properties: pulumi.Input[Sequence[pulumi.Input['JobDefinitionMultiNodeEcsTaskPropertiesArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionMultiNodeEcsTaskPropertiesArgs']]] task_properties: An object that contains the properties for the Amazon ECS task definition of a job.
               
               > This object is currently limited to one task element. However, the task element can run up to 10 containers.
        """
        pulumi.set(__self__, "task_properties", task_properties)

    @property
    @pulumi.getter(name="taskProperties")
    def task_properties(self) -> pulumi.Input[Sequence[pulumi.Input['JobDefinitionMultiNodeEcsTaskPropertiesArgs']]]:
        """
        An object that contains the properties for the Amazon ECS task definition of a job.

        > This object is currently limited to one task element. However, the task element can run up to 10 containers.
        """
        return pulumi.get(self, "task_properties")

    @task_properties.setter
    def task_properties(self, value: pulumi.Input[Sequence[pulumi.Input['JobDefinitionMultiNodeEcsTaskPropertiesArgs']]]):
        pulumi.set(self, "task_properties", value)


if not MYPY:
    class JobDefinitionMultiNodeEcsTaskPropertiesArgsDict(TypedDict):
        containers: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionTaskContainerPropertiesArgsDict']]]]
        """
        This object is a list of containers.
        """
        enable_execute_command: NotRequired[pulumi.Input[builtins.bool]]
        """
        Determines whether execute command functionality is turned on for this task. If `true` , execute command functionality is turned on all the containers in the task.
        """
        execution_role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [AWS Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *AWS Batch User Guide* .
        """
        ipc_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        The IPC resource namespace to use for the containers in the task. The valid values are `host` , `task` , or `none` .

        If `host` is specified, all containers within the tasks that specified the `host` IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance.

        If `task` is specified, all containers within the specified `task` share the same IPC resources.

        If `none` is specified, the IPC resources within the containers of a task are private, and are not shared with other containers in a task or on the container instance.

        If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see [IPC settings](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#ipc-settings---ipc) in the Docker run reference.
        """
        pid_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        The process namespace to use for the containers in the task. The valid values are `host` or `task` . For example, monitoring sidecars might need `pidMode` to access information about other containers running in the same task.

        If `host` is specified, all containers within the tasks that specified the `host` PID mode on the same container instance share the process namespace with the host Amazon EC2 instance.

        If `task` is specified, all containers within the specified task share the same process namespace.

        If no value is specified, the default is a private namespace for each container. For more information, see [PID settings](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#pid-settings---pid) in the Docker run reference.
        """
        task_role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) that's associated with the Amazon ECS task.

        > This is object is comparable to [ContainerProperties:jobRoleArn](https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html) .
        """
        volumes: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionVolumeArgsDict']]]]
        """
        A list of volumes that are associated with the job.
        """
elif False:
    JobDefinitionMultiNodeEcsTaskPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionMultiNodeEcsTaskPropertiesArgs:
    def __init__(__self__, *,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionTaskContainerPropertiesArgs']]]] = None,
                 enable_execute_command: Optional[pulumi.Input[builtins.bool]] = None,
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 ipc_mode: Optional[pulumi.Input[builtins.str]] = None,
                 pid_mode: Optional[pulumi.Input[builtins.str]] = None,
                 task_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionVolumeArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionTaskContainerPropertiesArgs']]] containers: This object is a list of containers.
        :param pulumi.Input[builtins.bool] enable_execute_command: Determines whether execute command functionality is turned on for this task. If `true` , execute command functionality is turned on all the containers in the task.
        :param pulumi.Input[builtins.str] execution_role_arn: The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [AWS Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *AWS Batch User Guide* .
        :param pulumi.Input[builtins.str] ipc_mode: The IPC resource namespace to use for the containers in the task. The valid values are `host` , `task` , or `none` .
               
               If `host` is specified, all containers within the tasks that specified the `host` IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance.
               
               If `task` is specified, all containers within the specified `task` share the same IPC resources.
               
               If `none` is specified, the IPC resources within the containers of a task are private, and are not shared with other containers in a task or on the container instance.
               
               If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see [IPC settings](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#ipc-settings---ipc) in the Docker run reference.
        :param pulumi.Input[builtins.str] pid_mode: The process namespace to use for the containers in the task. The valid values are `host` or `task` . For example, monitoring sidecars might need `pidMode` to access information about other containers running in the same task.
               
               If `host` is specified, all containers within the tasks that specified the `host` PID mode on the same container instance share the process namespace with the host Amazon EC2 instance.
               
               If `task` is specified, all containers within the specified task share the same process namespace.
               
               If no value is specified, the default is a private namespace for each container. For more information, see [PID settings](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#pid-settings---pid) in the Docker run reference.
        :param pulumi.Input[builtins.str] task_role_arn: The Amazon Resource Name (ARN) that's associated with the Amazon ECS task.
               
               > This is object is comparable to [ContainerProperties:jobRoleArn](https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html) .
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionVolumeArgs']]] volumes: A list of volumes that are associated with the job.
        """
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if enable_execute_command is not None:
            pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if ipc_mode is not None:
            pulumi.set(__self__, "ipc_mode", ipc_mode)
        if pid_mode is not None:
            pulumi.set(__self__, "pid_mode", pid_mode)
        if task_role_arn is not None:
            pulumi.set(__self__, "task_role_arn", task_role_arn)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionTaskContainerPropertiesArgs']]]]:
        """
        This object is a list of containers.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionTaskContainerPropertiesArgs']]]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines whether execute command functionality is turned on for this task. If `true` , execute command functionality is turned on all the containers in the task.
        """
        return pulumi.get(self, "enable_execute_command")

    @enable_execute_command.setter
    def enable_execute_command(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_execute_command", value)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [AWS Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter(name="ipcMode")
    def ipc_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IPC resource namespace to use for the containers in the task. The valid values are `host` , `task` , or `none` .

        If `host` is specified, all containers within the tasks that specified the `host` IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance.

        If `task` is specified, all containers within the specified `task` share the same IPC resources.

        If `none` is specified, the IPC resources within the containers of a task are private, and are not shared with other containers in a task or on the container instance.

        If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see [IPC settings](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#ipc-settings---ipc) in the Docker run reference.
        """
        return pulumi.get(self, "ipc_mode")

    @ipc_mode.setter
    def ipc_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipc_mode", value)

    @property
    @pulumi.getter(name="pidMode")
    def pid_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The process namespace to use for the containers in the task. The valid values are `host` or `task` . For example, monitoring sidecars might need `pidMode` to access information about other containers running in the same task.

        If `host` is specified, all containers within the tasks that specified the `host` PID mode on the same container instance share the process namespace with the host Amazon EC2 instance.

        If `task` is specified, all containers within the specified task share the same process namespace.

        If no value is specified, the default is a private namespace for each container. For more information, see [PID settings](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#pid-settings---pid) in the Docker run reference.
        """
        return pulumi.get(self, "pid_mode")

    @pid_mode.setter
    def pid_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pid_mode", value)

    @property
    @pulumi.getter(name="taskRoleArn")
    def task_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) that's associated with the Amazon ECS task.

        > This is object is comparable to [ContainerProperties:jobRoleArn](https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html) .
        """
        return pulumi.get(self, "task_role_arn")

    @task_role_arn.setter
    def task_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "task_role_arn", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionVolumeArgs']]]]:
        """
        A list of volumes that are associated with the job.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


if not MYPY:
    class JobDefinitionNetworkConfigurationArgsDict(TypedDict):
        assign_public_ip: NotRequired[pulumi.Input[builtins.str]]
        """
        Indicates whether the job has a public IP address. For a job that's running on Fargate resources in a private subnet to send outbound traffic to the internet (for example, to pull container images), the private subnet requires a NAT gateway be attached to route requests to the internet. For more information, see [Amazon ECS task networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide* . The default value is " `DISABLED` ".
        """
elif False:
    JobDefinitionNetworkConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionNetworkConfigurationArgs:
    def __init__(__self__, *,
                 assign_public_ip: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] assign_public_ip: Indicates whether the job has a public IP address. For a job that's running on Fargate resources in a private subnet to send outbound traffic to the internet (for example, to pull container images), the private subnet requires a NAT gateway be attached to route requests to the internet. For more information, see [Amazon ECS task networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide* . The default value is " `DISABLED` ".
        """
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether the job has a public IP address. For a job that's running on Fargate resources in a private subnet to send outbound traffic to the internet (for example, to pull container images), the private subnet requires a NAT gateway be attached to route requests to the internet. For more information, see [Amazon ECS task networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide* . The default value is " `DISABLED` ".
        """
        return pulumi.get(self, "assign_public_ip")

    @assign_public_ip.setter
    def assign_public_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "assign_public_ip", value)


if not MYPY:
    class JobDefinitionNodePropertiesArgsDict(TypedDict):
        main_node: pulumi.Input[builtins.int]
        """
        Specifies the node index for the main node of a multi-node parallel job. This node index value must be fewer than the number of nodes.
        """
        node_range_properties: pulumi.Input[Sequence[pulumi.Input['JobDefinitionNodeRangePropertyArgsDict']]]
        """
        A list of node ranges and their properties that are associated with a multi-node parallel job.
        """
        num_nodes: pulumi.Input[builtins.int]
        """
        The number of nodes that are associated with a multi-node parallel job.
        """
elif False:
    JobDefinitionNodePropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionNodePropertiesArgs:
    def __init__(__self__, *,
                 main_node: pulumi.Input[builtins.int],
                 node_range_properties: pulumi.Input[Sequence[pulumi.Input['JobDefinitionNodeRangePropertyArgs']]],
                 num_nodes: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] main_node: Specifies the node index for the main node of a multi-node parallel job. This node index value must be fewer than the number of nodes.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionNodeRangePropertyArgs']]] node_range_properties: A list of node ranges and their properties that are associated with a multi-node parallel job.
        :param pulumi.Input[builtins.int] num_nodes: The number of nodes that are associated with a multi-node parallel job.
        """
        pulumi.set(__self__, "main_node", main_node)
        pulumi.set(__self__, "node_range_properties", node_range_properties)
        pulumi.set(__self__, "num_nodes", num_nodes)

    @property
    @pulumi.getter(name="mainNode")
    def main_node(self) -> pulumi.Input[builtins.int]:
        """
        Specifies the node index for the main node of a multi-node parallel job. This node index value must be fewer than the number of nodes.
        """
        return pulumi.get(self, "main_node")

    @main_node.setter
    def main_node(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "main_node", value)

    @property
    @pulumi.getter(name="nodeRangeProperties")
    def node_range_properties(self) -> pulumi.Input[Sequence[pulumi.Input['JobDefinitionNodeRangePropertyArgs']]]:
        """
        A list of node ranges and their properties that are associated with a multi-node parallel job.
        """
        return pulumi.get(self, "node_range_properties")

    @node_range_properties.setter
    def node_range_properties(self, value: pulumi.Input[Sequence[pulumi.Input['JobDefinitionNodeRangePropertyArgs']]]):
        pulumi.set(self, "node_range_properties", value)

    @property
    @pulumi.getter(name="numNodes")
    def num_nodes(self) -> pulumi.Input[builtins.int]:
        """
        The number of nodes that are associated with a multi-node parallel job.
        """
        return pulumi.get(self, "num_nodes")

    @num_nodes.setter
    def num_nodes(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "num_nodes", value)


if not MYPY:
    class JobDefinitionNodeRangePropertyArgsDict(TypedDict):
        target_nodes: pulumi.Input[builtins.str]
        """
        The range of nodes, using node index values. A range of `0:3` indicates nodes with index values of `0` through `3` . If the starting range value is omitted ( `:n` ), then `0` is used to start the range. If the ending range value is omitted ( `n:` ), then the highest possible node index is used to end the range. Your accumulative node ranges must account for all nodes ( `0:n` ). You can nest node ranges (for example, `0:10` and `4:5` ). In this case, the `4:5` range properties override the `0:10` properties.
        """
        consumable_resource_properties: NotRequired[pulumi.Input['JobDefinitionConsumableResourcePropertiesArgsDict']]
        """
        Contains a list of consumable resources required by a job.
        """
        container: NotRequired[pulumi.Input['JobDefinitionMultiNodeContainerPropertiesArgsDict']]
        """
        The container details for the node range.
        """
        ecs_properties: NotRequired[pulumi.Input['JobDefinitionMultiNodeEcsPropertiesArgsDict']]
        """
        This is an object that represents the properties of the node range for a multi-node parallel job.
        """
        eks_properties: NotRequired[pulumi.Input['JobDefinitionEksPropertiesArgsDict']]
        """
        This is an object that represents the properties of the node range for a multi-node parallel job.
        """
        instance_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The instance types of the underlying host infrastructure of a multi-node parallel job.

        > This parameter isn't applicable to jobs that are running on Fargate resources.
        > 
        > In addition, this list object is currently limited to one element.
        """
elif False:
    JobDefinitionNodeRangePropertyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionNodeRangePropertyArgs:
    def __init__(__self__, *,
                 target_nodes: pulumi.Input[builtins.str],
                 consumable_resource_properties: Optional[pulumi.Input['JobDefinitionConsumableResourcePropertiesArgs']] = None,
                 container: Optional[pulumi.Input['JobDefinitionMultiNodeContainerPropertiesArgs']] = None,
                 ecs_properties: Optional[pulumi.Input['JobDefinitionMultiNodeEcsPropertiesArgs']] = None,
                 eks_properties: Optional[pulumi.Input['JobDefinitionEksPropertiesArgs']] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] target_nodes: The range of nodes, using node index values. A range of `0:3` indicates nodes with index values of `0` through `3` . If the starting range value is omitted ( `:n` ), then `0` is used to start the range. If the ending range value is omitted ( `n:` ), then the highest possible node index is used to end the range. Your accumulative node ranges must account for all nodes ( `0:n` ). You can nest node ranges (for example, `0:10` and `4:5` ). In this case, the `4:5` range properties override the `0:10` properties.
        :param pulumi.Input['JobDefinitionConsumableResourcePropertiesArgs'] consumable_resource_properties: Contains a list of consumable resources required by a job.
        :param pulumi.Input['JobDefinitionMultiNodeContainerPropertiesArgs'] container: The container details for the node range.
        :param pulumi.Input['JobDefinitionMultiNodeEcsPropertiesArgs'] ecs_properties: This is an object that represents the properties of the node range for a multi-node parallel job.
        :param pulumi.Input['JobDefinitionEksPropertiesArgs'] eks_properties: This is an object that represents the properties of the node range for a multi-node parallel job.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] instance_types: The instance types of the underlying host infrastructure of a multi-node parallel job.
               
               > This parameter isn't applicable to jobs that are running on Fargate resources.
               > 
               > In addition, this list object is currently limited to one element.
        """
        pulumi.set(__self__, "target_nodes", target_nodes)
        if consumable_resource_properties is not None:
            pulumi.set(__self__, "consumable_resource_properties", consumable_resource_properties)
        if container is not None:
            pulumi.set(__self__, "container", container)
        if ecs_properties is not None:
            pulumi.set(__self__, "ecs_properties", ecs_properties)
        if eks_properties is not None:
            pulumi.set(__self__, "eks_properties", eks_properties)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)

    @property
    @pulumi.getter(name="targetNodes")
    def target_nodes(self) -> pulumi.Input[builtins.str]:
        """
        The range of nodes, using node index values. A range of `0:3` indicates nodes with index values of `0` through `3` . If the starting range value is omitted ( `:n` ), then `0` is used to start the range. If the ending range value is omitted ( `n:` ), then the highest possible node index is used to end the range. Your accumulative node ranges must account for all nodes ( `0:n` ). You can nest node ranges (for example, `0:10` and `4:5` ). In this case, the `4:5` range properties override the `0:10` properties.
        """
        return pulumi.get(self, "target_nodes")

    @target_nodes.setter
    def target_nodes(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_nodes", value)

    @property
    @pulumi.getter(name="consumableResourceProperties")
    def consumable_resource_properties(self) -> Optional[pulumi.Input['JobDefinitionConsumableResourcePropertiesArgs']]:
        """
        Contains a list of consumable resources required by a job.
        """
        return pulumi.get(self, "consumable_resource_properties")

    @consumable_resource_properties.setter
    def consumable_resource_properties(self, value: Optional[pulumi.Input['JobDefinitionConsumableResourcePropertiesArgs']]):
        pulumi.set(self, "consumable_resource_properties", value)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input['JobDefinitionMultiNodeContainerPropertiesArgs']]:
        """
        The container details for the node range.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input['JobDefinitionMultiNodeContainerPropertiesArgs']]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="ecsProperties")
    def ecs_properties(self) -> Optional[pulumi.Input['JobDefinitionMultiNodeEcsPropertiesArgs']]:
        """
        This is an object that represents the properties of the node range for a multi-node parallel job.
        """
        return pulumi.get(self, "ecs_properties")

    @ecs_properties.setter
    def ecs_properties(self, value: Optional[pulumi.Input['JobDefinitionMultiNodeEcsPropertiesArgs']]):
        pulumi.set(self, "ecs_properties", value)

    @property
    @pulumi.getter(name="eksProperties")
    def eks_properties(self) -> Optional[pulumi.Input['JobDefinitionEksPropertiesArgs']]:
        """
        This is an object that represents the properties of the node range for a multi-node parallel job.
        """
        return pulumi.get(self, "eks_properties")

    @eks_properties.setter
    def eks_properties(self, value: Optional[pulumi.Input['JobDefinitionEksPropertiesArgs']]):
        pulumi.set(self, "eks_properties", value)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The instance types of the underlying host infrastructure of a multi-node parallel job.

        > This parameter isn't applicable to jobs that are running on Fargate resources.
        > 
        > In addition, this list object is currently limited to one element.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "instance_types", value)


if not MYPY:
    class JobDefinitionRepositoryCredentialsArgsDict(TypedDict):
        credentials_parameter: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of the secret containing the private repository credentials.
        """
elif False:
    JobDefinitionRepositoryCredentialsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionRepositoryCredentialsArgs:
    def __init__(__self__, *,
                 credentials_parameter: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] credentials_parameter: The Amazon Resource Name (ARN) of the secret containing the private repository credentials.
        """
        pulumi.set(__self__, "credentials_parameter", credentials_parameter)

    @property
    @pulumi.getter(name="credentialsParameter")
    def credentials_parameter(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the secret containing the private repository credentials.
        """
        return pulumi.get(self, "credentials_parameter")

    @credentials_parameter.setter
    def credentials_parameter(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "credentials_parameter", value)


if not MYPY:
    class JobDefinitionResourceRequirementArgsDict(TypedDict):
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of resource to assign to a container. The supported resources include `GPU` , `MEMORY` , and `VCPU` .
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        The quantity of the specified resource to reserve for the container. The values vary based on the `type` specified.

        - **type="GPU"** - The number of physical GPUs to reserve for the container. Make sure that the number of GPUs reserved for all containers in a job doesn't exceed the number of available GPUs on the compute resource that the job is launched on.

        > GPUs aren't available for jobs that are running on Fargate resources.
        - **type="MEMORY"** - The memory hard limit (in MiB) present to the container. This parameter is supported for jobs that are running on Amazon EC2 resources. If your container attempts to exceed the memory specified, the container is terminated. This parameter maps to `Memory` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--memory` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . You must specify at least 4 MiB of memory for a job. This is required but can be specified in several places for multi-node parallel (MNP) jobs. It must be specified for each node at least once. This parameter maps to `Memory` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--memory` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see [Memory management](https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html) in the *AWS Batch User Guide* . 

        For jobs that are running on Fargate resources, then `value` is the hard limit (in MiB), and must match one of the supported values and the `VCPU` values must be one of the values supported for that memory value.

        - **value = 512** - `VCPU` = 0.25
        - **value = 1024** - `VCPU` = 0.25 or 0.5
        - **value = 2048** - `VCPU` = 0.25, 0.5, or 1
        - **value = 3072** - `VCPU` = 0.5, or 1
        - **value = 4096** - `VCPU` = 0.5, 1, or 2
        - **value = 5120, 6144, or 7168** - `VCPU` = 1 or 2
        - **value = 8192** - `VCPU` = 1, 2, or 4
        - **value = 9216, 10240, 11264, 12288, 13312, 14336, or 15360** - `VCPU` = 2 or 4
        - **value = 16384** - `VCPU` = 2, 4, or 8
        - **value = 17408, 18432, 19456, 21504, 22528, 23552, 25600, 26624, 27648, 29696, or 30720** - `VCPU` = 4
        - **value = 20480, 24576, or 28672** - `VCPU` = 4 or 8
        - **value = 36864, 45056, 53248, or 61440** - `VCPU` = 8
        - **value = 32768, 40960, 49152, or 57344** - `VCPU` = 8 or 16
        - **value = 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880** - `VCPU` = 16
        - **type="VCPU"** - The number of vCPUs reserved for the container. This parameter maps to `CpuShares` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . Each vCPU is equivalent to 1,024 CPU shares. For Amazon EC2 resources, you must specify at least one vCPU. This is required but can be specified in several places; it must be specified for each node at least once.

        The default for the Fargate On-Demand vCPU resource count quota is 6 vCPUs. For more information about Fargate quotas, see [AWS Fargate quotas](https://docs.aws.amazon.com/general/latest/gr/ecs-service.html#service-quotas-fargate) in the *AWS General Reference* .

        For jobs that are running on Fargate resources, then `value` must match one of the supported values and the `MEMORY` values must be one of the values supported for that `VCPU` value. The supported values are 0.25, 0.5, 1, 2, 4, 8, and 16

        - **value = 0.25** - `MEMORY` = 512, 1024, or 2048
        - **value = 0.5** - `MEMORY` = 1024, 2048, 3072, or 4096
        - **value = 1** - `MEMORY` = 2048, 3072, 4096, 5120, 6144, 7168, or 8192
        - **value = 2** - `MEMORY` = 4096, 5120, 6144, 7168, 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, or 16384
        - **value = 4** - `MEMORY` = 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, 16384, 17408, 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600, 26624, 27648, 28672, 29696, or 30720
        - **value = 8** - `MEMORY` = 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056, 49152, 53248, 57344, or 61440
        - **value = 16** - `MEMORY` = 32768, 40960, 49152, 57344, 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880
        """
elif False:
    JobDefinitionResourceRequirementArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionResourceRequirementArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: The type of resource to assign to a container. The supported resources include `GPU` , `MEMORY` , and `VCPU` .
        :param pulumi.Input[builtins.str] value: The quantity of the specified resource to reserve for the container. The values vary based on the `type` specified.
               
               - **type="GPU"** - The number of physical GPUs to reserve for the container. Make sure that the number of GPUs reserved for all containers in a job doesn't exceed the number of available GPUs on the compute resource that the job is launched on.
               
               > GPUs aren't available for jobs that are running on Fargate resources.
               - **type="MEMORY"** - The memory hard limit (in MiB) present to the container. This parameter is supported for jobs that are running on Amazon EC2 resources. If your container attempts to exceed the memory specified, the container is terminated. This parameter maps to `Memory` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--memory` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . You must specify at least 4 MiB of memory for a job. This is required but can be specified in several places for multi-node parallel (MNP) jobs. It must be specified for each node at least once. This parameter maps to `Memory` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--memory` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see [Memory management](https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html) in the *AWS Batch User Guide* . 
               
               For jobs that are running on Fargate resources, then `value` is the hard limit (in MiB), and must match one of the supported values and the `VCPU` values must be one of the values supported for that memory value.
               
               - **value = 512** - `VCPU` = 0.25
               - **value = 1024** - `VCPU` = 0.25 or 0.5
               - **value = 2048** - `VCPU` = 0.25, 0.5, or 1
               - **value = 3072** - `VCPU` = 0.5, or 1
               - **value = 4096** - `VCPU` = 0.5, 1, or 2
               - **value = 5120, 6144, or 7168** - `VCPU` = 1 or 2
               - **value = 8192** - `VCPU` = 1, 2, or 4
               - **value = 9216, 10240, 11264, 12288, 13312, 14336, or 15360** - `VCPU` = 2 or 4
               - **value = 16384** - `VCPU` = 2, 4, or 8
               - **value = 17408, 18432, 19456, 21504, 22528, 23552, 25600, 26624, 27648, 29696, or 30720** - `VCPU` = 4
               - **value = 20480, 24576, or 28672** - `VCPU` = 4 or 8
               - **value = 36864, 45056, 53248, or 61440** - `VCPU` = 8
               - **value = 32768, 40960, 49152, or 57344** - `VCPU` = 8 or 16
               - **value = 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880** - `VCPU` = 16
               - **type="VCPU"** - The number of vCPUs reserved for the container. This parameter maps to `CpuShares` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . Each vCPU is equivalent to 1,024 CPU shares. For Amazon EC2 resources, you must specify at least one vCPU. This is required but can be specified in several places; it must be specified for each node at least once.
               
               The default for the Fargate On-Demand vCPU resource count quota is 6 vCPUs. For more information about Fargate quotas, see [AWS Fargate quotas](https://docs.aws.amazon.com/general/latest/gr/ecs-service.html#service-quotas-fargate) in the *AWS General Reference* .
               
               For jobs that are running on Fargate resources, then `value` must match one of the supported values and the `MEMORY` values must be one of the values supported for that `VCPU` value. The supported values are 0.25, 0.5, 1, 2, 4, 8, and 16
               
               - **value = 0.25** - `MEMORY` = 512, 1024, or 2048
               - **value = 0.5** - `MEMORY` = 1024, 2048, 3072, or 4096
               - **value = 1** - `MEMORY` = 2048, 3072, 4096, 5120, 6144, 7168, or 8192
               - **value = 2** - `MEMORY` = 4096, 5120, 6144, 7168, 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, or 16384
               - **value = 4** - `MEMORY` = 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, 16384, 17408, 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600, 26624, 27648, 28672, 29696, or 30720
               - **value = 8** - `MEMORY` = 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056, 49152, 53248, 57344, or 61440
               - **value = 16** - `MEMORY` = 32768, 40960, 49152, 57344, 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of resource to assign to a container. The supported resources include `GPU` , `MEMORY` , and `VCPU` .
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The quantity of the specified resource to reserve for the container. The values vary based on the `type` specified.

        - **type="GPU"** - The number of physical GPUs to reserve for the container. Make sure that the number of GPUs reserved for all containers in a job doesn't exceed the number of available GPUs on the compute resource that the job is launched on.

        > GPUs aren't available for jobs that are running on Fargate resources.
        - **type="MEMORY"** - The memory hard limit (in MiB) present to the container. This parameter is supported for jobs that are running on Amazon EC2 resources. If your container attempts to exceed the memory specified, the container is terminated. This parameter maps to `Memory` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--memory` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . You must specify at least 4 MiB of memory for a job. This is required but can be specified in several places for multi-node parallel (MNP) jobs. It must be specified for each node at least once. This parameter maps to `Memory` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--memory` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see [Memory management](https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html) in the *AWS Batch User Guide* . 

        For jobs that are running on Fargate resources, then `value` is the hard limit (in MiB), and must match one of the supported values and the `VCPU` values must be one of the values supported for that memory value.

        - **value = 512** - `VCPU` = 0.25
        - **value = 1024** - `VCPU` = 0.25 or 0.5
        - **value = 2048** - `VCPU` = 0.25, 0.5, or 1
        - **value = 3072** - `VCPU` = 0.5, or 1
        - **value = 4096** - `VCPU` = 0.5, 1, or 2
        - **value = 5120, 6144, or 7168** - `VCPU` = 1 or 2
        - **value = 8192** - `VCPU` = 1, 2, or 4
        - **value = 9216, 10240, 11264, 12288, 13312, 14336, or 15360** - `VCPU` = 2 or 4
        - **value = 16384** - `VCPU` = 2, 4, or 8
        - **value = 17408, 18432, 19456, 21504, 22528, 23552, 25600, 26624, 27648, 29696, or 30720** - `VCPU` = 4
        - **value = 20480, 24576, or 28672** - `VCPU` = 4 or 8
        - **value = 36864, 45056, 53248, or 61440** - `VCPU` = 8
        - **value = 32768, 40960, 49152, or 57344** - `VCPU` = 8 or 16
        - **value = 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880** - `VCPU` = 16
        - **type="VCPU"** - The number of vCPUs reserved for the container. This parameter maps to `CpuShares` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . Each vCPU is equivalent to 1,024 CPU shares. For Amazon EC2 resources, you must specify at least one vCPU. This is required but can be specified in several places; it must be specified for each node at least once.

        The default for the Fargate On-Demand vCPU resource count quota is 6 vCPUs. For more information about Fargate quotas, see [AWS Fargate quotas](https://docs.aws.amazon.com/general/latest/gr/ecs-service.html#service-quotas-fargate) in the *AWS General Reference* .

        For jobs that are running on Fargate resources, then `value` must match one of the supported values and the `MEMORY` values must be one of the values supported for that `VCPU` value. The supported values are 0.25, 0.5, 1, 2, 4, 8, and 16

        - **value = 0.25** - `MEMORY` = 512, 1024, or 2048
        - **value = 0.5** - `MEMORY` = 1024, 2048, 3072, or 4096
        - **value = 1** - `MEMORY` = 2048, 3072, 4096, 5120, 6144, 7168, or 8192
        - **value = 2** - `MEMORY` = 4096, 5120, 6144, 7168, 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, or 16384
        - **value = 4** - `MEMORY` = 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, 16384, 17408, 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600, 26624, 27648, 28672, 29696, or 30720
        - **value = 8** - `MEMORY` = 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056, 49152, 53248, 57344, or 61440
        - **value = 16** - `MEMORY` = 32768, 40960, 49152, 57344, 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class JobDefinitionRetryStrategyArgsDict(TypedDict):
        attempts: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of times to move a job to the `RUNNABLE` status. You can specify between 1 and 10 attempts. If the value of `attempts` is greater than one, the job is retried on failure the same number of attempts as the value.
        """
        evaluate_on_exit: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEvaluateOnExitArgsDict']]]]
        """
        Array of up to 5 objects that specify the conditions where jobs are retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. If none of the listed conditions match, then the job is retried.
        """
elif False:
    JobDefinitionRetryStrategyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionRetryStrategyArgs:
    def __init__(__self__, *,
                 attempts: Optional[pulumi.Input[builtins.int]] = None,
                 evaluate_on_exit: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEvaluateOnExitArgs']]]] = None):
        """
        :param pulumi.Input[builtins.int] attempts: The number of times to move a job to the `RUNNABLE` status. You can specify between 1 and 10 attempts. If the value of `attempts` is greater than one, the job is retried on failure the same number of attempts as the value.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEvaluateOnExitArgs']]] evaluate_on_exit: Array of up to 5 objects that specify the conditions where jobs are retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. If none of the listed conditions match, then the job is retried.
        """
        if attempts is not None:
            pulumi.set(__self__, "attempts", attempts)
        if evaluate_on_exit is not None:
            pulumi.set(__self__, "evaluate_on_exit", evaluate_on_exit)

    @property
    @pulumi.getter
    def attempts(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of times to move a job to the `RUNNABLE` status. You can specify between 1 and 10 attempts. If the value of `attempts` is greater than one, the job is retried on failure the same number of attempts as the value.
        """
        return pulumi.get(self, "attempts")

    @attempts.setter
    def attempts(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "attempts", value)

    @property
    @pulumi.getter(name="evaluateOnExit")
    def evaluate_on_exit(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEvaluateOnExitArgs']]]]:
        """
        Array of up to 5 objects that specify the conditions where jobs are retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. If none of the listed conditions match, then the job is retried.
        """
        return pulumi.get(self, "evaluate_on_exit")

    @evaluate_on_exit.setter
    def evaluate_on_exit(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEvaluateOnExitArgs']]]]):
        pulumi.set(self, "evaluate_on_exit", value)


if not MYPY:
    class JobDefinitionRuntimePlatformArgsDict(TypedDict):
        cpu_architecture: NotRequired[pulumi.Input[builtins.str]]
        """
        The vCPU architecture. The default value is `X86_64` . Valid values are `X86_64` and `ARM64` .

        > This parameter must be set to `X86_64` for Windows containers. > Fargate Spot is not supported for `ARM64` and Windows-based containers on Fargate. A job queue will be blocked if a Fargate `ARM64` or Windows job is submitted to a job queue with only Fargate Spot compute environments. However, you can attach both `FARGATE` and `FARGATE_SPOT` compute environments to the same job queue.
        """
        operating_system_family: NotRequired[pulumi.Input[builtins.str]]
        """
        The operating system for the compute environment. Valid values are: `LINUX` (default), `WINDOWS_SERVER_2019_CORE` , `WINDOWS_SERVER_2019_FULL` , `WINDOWS_SERVER_2022_CORE` , and `WINDOWS_SERVER_2022_FULL` .

        > The following parameters can’t be set for Windows containers: `linuxParameters` , `privileged` , `user` , `ulimits` , `readonlyRootFilesystem` , and `efsVolumeConfiguration` . > The AWS Batch Scheduler checks the compute environments that are attached to the job queue before registering a task definition with Fargate. In this scenario, the job queue is where the job is submitted. If the job requires a Windows container and the first compute environment is `LINUX` , the compute environment is skipped and the next compute environment is checked until a Windows-based compute environment is found. > Fargate Spot is not supported for `ARM64` and Windows-based containers on Fargate. A job queue will be blocked if a Fargate `ARM64` or Windows job is submitted to a job queue with only Fargate Spot compute environments. However, you can attach both `FARGATE` and `FARGATE_SPOT` compute environments to the same job queue.
        """
elif False:
    JobDefinitionRuntimePlatformArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionRuntimePlatformArgs:
    def __init__(__self__, *,
                 cpu_architecture: Optional[pulumi.Input[builtins.str]] = None,
                 operating_system_family: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] cpu_architecture: The vCPU architecture. The default value is `X86_64` . Valid values are `X86_64` and `ARM64` .
               
               > This parameter must be set to `X86_64` for Windows containers. > Fargate Spot is not supported for `ARM64` and Windows-based containers on Fargate. A job queue will be blocked if a Fargate `ARM64` or Windows job is submitted to a job queue with only Fargate Spot compute environments. However, you can attach both `FARGATE` and `FARGATE_SPOT` compute environments to the same job queue.
        :param pulumi.Input[builtins.str] operating_system_family: The operating system for the compute environment. Valid values are: `LINUX` (default), `WINDOWS_SERVER_2019_CORE` , `WINDOWS_SERVER_2019_FULL` , `WINDOWS_SERVER_2022_CORE` , and `WINDOWS_SERVER_2022_FULL` .
               
               > The following parameters can’t be set for Windows containers: `linuxParameters` , `privileged` , `user` , `ulimits` , `readonlyRootFilesystem` , and `efsVolumeConfiguration` . > The AWS Batch Scheduler checks the compute environments that are attached to the job queue before registering a task definition with Fargate. In this scenario, the job queue is where the job is submitted. If the job requires a Windows container and the first compute environment is `LINUX` , the compute environment is skipped and the next compute environment is checked until a Windows-based compute environment is found. > Fargate Spot is not supported for `ARM64` and Windows-based containers on Fargate. A job queue will be blocked if a Fargate `ARM64` or Windows job is submitted to a job queue with only Fargate Spot compute environments. However, you can attach both `FARGATE` and `FARGATE_SPOT` compute environments to the same job queue.
        """
        if cpu_architecture is not None:
            pulumi.set(__self__, "cpu_architecture", cpu_architecture)
        if operating_system_family is not None:
            pulumi.set(__self__, "operating_system_family", operating_system_family)

    @property
    @pulumi.getter(name="cpuArchitecture")
    def cpu_architecture(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The vCPU architecture. The default value is `X86_64` . Valid values are `X86_64` and `ARM64` .

        > This parameter must be set to `X86_64` for Windows containers. > Fargate Spot is not supported for `ARM64` and Windows-based containers on Fargate. A job queue will be blocked if a Fargate `ARM64` or Windows job is submitted to a job queue with only Fargate Spot compute environments. However, you can attach both `FARGATE` and `FARGATE_SPOT` compute environments to the same job queue.
        """
        return pulumi.get(self, "cpu_architecture")

    @cpu_architecture.setter
    def cpu_architecture(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpu_architecture", value)

    @property
    @pulumi.getter(name="operatingSystemFamily")
    def operating_system_family(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The operating system for the compute environment. Valid values are: `LINUX` (default), `WINDOWS_SERVER_2019_CORE` , `WINDOWS_SERVER_2019_FULL` , `WINDOWS_SERVER_2022_CORE` , and `WINDOWS_SERVER_2022_FULL` .

        > The following parameters can’t be set for Windows containers: `linuxParameters` , `privileged` , `user` , `ulimits` , `readonlyRootFilesystem` , and `efsVolumeConfiguration` . > The AWS Batch Scheduler checks the compute environments that are attached to the job queue before registering a task definition with Fargate. In this scenario, the job queue is where the job is submitted. If the job requires a Windows container and the first compute environment is `LINUX` , the compute environment is skipped and the next compute environment is checked until a Windows-based compute environment is found. > Fargate Spot is not supported for `ARM64` and Windows-based containers on Fargate. A job queue will be blocked if a Fargate `ARM64` or Windows job is submitted to a job queue with only Fargate Spot compute environments. However, you can attach both `FARGATE` and `FARGATE_SPOT` compute environments to the same job queue.
        """
        return pulumi.get(self, "operating_system_family")

    @operating_system_family.setter
    def operating_system_family(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operating_system_family", value)


if not MYPY:
    class JobDefinitionSecretArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The name of the secret.
        """
        value_from: pulumi.Input[builtins.str]
        """
        The secret to expose to the container. The supported values are either the full Amazon Resource Name (ARN) of the AWS Secrets Manager secret or the full ARN of the parameter in the AWS Systems Manager Parameter Store.

        > If the AWS Systems Manager Parameter Store parameter exists in the same Region as the job you're launching, then you can use either the full Amazon Resource Name (ARN) or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
        """
elif False:
    JobDefinitionSecretArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionSecretArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 value_from: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] name: The name of the secret.
        :param pulumi.Input[builtins.str] value_from: The secret to expose to the container. The supported values are either the full Amazon Resource Name (ARN) of the AWS Secrets Manager secret or the full ARN of the parameter in the AWS Systems Manager Parameter Store.
               
               > If the AWS Systems Manager Parameter Store parameter exists in the same Region as the job you're launching, then you can use either the full Amazon Resource Name (ARN) or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value_from", value_from)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the secret.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> pulumi.Input[builtins.str]:
        """
        The secret to expose to the container. The supported values are either the full Amazon Resource Name (ARN) of the AWS Secrets Manager secret or the full ARN of the parameter in the AWS Systems Manager Parameter Store.

        > If the AWS Systems Manager Parameter Store parameter exists in the same Region as the job you're launching, then you can use either the full Amazon Resource Name (ARN) or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
        """
        return pulumi.get(self, "value_from")

    @value_from.setter
    def value_from(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value_from", value)


if not MYPY:
    class JobDefinitionTaskContainerDependencyArgsDict(TypedDict):
        condition: pulumi.Input[builtins.str]
        """
        The dependency condition of the container. The following are the available conditions and their behavior:

        - `START` - This condition emulates the behavior of links and volumes today. It validates that a dependent container is started before permitting other containers to start.
        - `COMPLETE` - This condition validates that a dependent container runs to completion (exits) before permitting other containers to start. This can be useful for nonessential containers that run a script and then exit. This condition can't be set on an essential container.
        - `SUCCESS` - This condition is the same as `COMPLETE` , but it also requires that the container exits with a zero status. This condition can't be set on an essential container.
        """
        container_name: pulumi.Input[builtins.str]
        """
        A unique identifier for the container.
        """
elif False:
    JobDefinitionTaskContainerDependencyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionTaskContainerDependencyArgs:
    def __init__(__self__, *,
                 condition: pulumi.Input[builtins.str],
                 container_name: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] condition: The dependency condition of the container. The following are the available conditions and their behavior:
               
               - `START` - This condition emulates the behavior of links and volumes today. It validates that a dependent container is started before permitting other containers to start.
               - `COMPLETE` - This condition validates that a dependent container runs to completion (exits) before permitting other containers to start. This can be useful for nonessential containers that run a script and then exit. This condition can't be set on an essential container.
               - `SUCCESS` - This condition is the same as `COMPLETE` , but it also requires that the container exits with a zero status. This condition can't be set on an essential container.
        :param pulumi.Input[builtins.str] container_name: A unique identifier for the container.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "container_name", container_name)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Input[builtins.str]:
        """
        The dependency condition of the container. The following are the available conditions and their behavior:

        - `START` - This condition emulates the behavior of links and volumes today. It validates that a dependent container is started before permitting other containers to start.
        - `COMPLETE` - This condition validates that a dependent container runs to completion (exits) before permitting other containers to start. This can be useful for nonessential containers that run a script and then exit. This condition can't be set on an essential container.
        - `SUCCESS` - This condition is the same as `COMPLETE` , but it also requires that the container exits with a zero status. This condition can't be set on an essential container.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Input[builtins.str]:
        """
        A unique identifier for the container.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "container_name", value)


if not MYPY:
    class JobDefinitionTaskContainerPropertiesFirelensConfigurationPropertiesArgsDict(TypedDict):
        """
        The FireLens configuration for the container. This is used to specify and configure a log router for container logs. For more information, see [Custom log](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html) routing in the *Amazon Elastic Container Service Developer Guide* .
        """
        type: pulumi.Input[builtins.str]
        options: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
elif False:
    JobDefinitionTaskContainerPropertiesFirelensConfigurationPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionTaskContainerPropertiesFirelensConfigurationPropertiesArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The FireLens configuration for the container. This is used to specify and configure a log router for container logs. For more information, see [Custom log](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html) routing in the *Amazon Elastic Container Service Developer Guide* .
        """
        pulumi.set(__self__, "type", type)
        if options is not None:
            pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "options", value)


if not MYPY:
    class JobDefinitionTaskContainerPropertiesArgsDict(TypedDict):
        image: pulumi.Input[builtins.str]
        """
        The image used to start a container. This string is passed directly to the Docker daemon. By default, images in the Docker Hub registry are available. Other repositories are specified with either `repository-url/image:tag` or `repository-url/image@digest` . Up to 255 letters (uppercase and lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter maps to `Image` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `IMAGE` parameter of the [*docker run*](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .
        """
        command: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The command that's passed to the container. This parameter maps to `Cmd` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `COMMAND` parameter to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . For more information, see [Dockerfile reference: CMD](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd) .
        """
        depends_on: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionTaskContainerDependencyArgsDict']]]]
        """
        A list of containers that this container depends on.
        """
        environment: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEnvironmentArgsDict']]]]
        """
        The environment variables to pass to a container. This parameter maps to Env in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--env` parameter to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > We don't recommend using plaintext environment variables for sensitive information, such as credential data. > Environment variables cannot start with `AWS_BATCH` . This naming convention is reserved for variables that AWS Batch sets.
        """
        essential: NotRequired[pulumi.Input[builtins.bool]]
        """
        If the essential parameter of a container is marked as `true` , and that container fails or stops for any reason, all other containers that are part of the task are stopped. If the `essential` parameter of a container is marked as false, its failure doesn't affect the rest of the containers in a task. If this parameter is omitted, a container is assumed to be essential.

        All jobs must have at least one essential container. If you have an application that's composed of multiple containers, group containers that are used for a common purpose into components, and separate the different components into multiple task definitions. For more information, see [Application Architecture](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        firelens_configuration: NotRequired[pulumi.Input['JobDefinitionTaskContainerPropertiesFirelensConfigurationPropertiesArgsDict']]
        """
        The FireLens configuration for the container. This is used to specify and configure a log router for container logs. For more information, see [Custom log](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html) routing in the *Amazon Elastic Container Service Developer Guide* .
        """
        linux_parameters: NotRequired[pulumi.Input['JobDefinitionLinuxParametersArgsDict']]
        """
        Linux-specific modifications that are applied to the container, such as Linux kernel capabilities. For more information, see [KernelCapabilities](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html) .
        """
        log_configuration: NotRequired[pulumi.Input['JobDefinitionLogConfigurationArgsDict']]
        """
        The log configuration specification for the container.

        This parameter maps to `LogConfig` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `--log-driver` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .

        By default, containers use the same logging driver that the Docker daemon uses. However the container can use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information about the options for different supported log drivers, see [Configure logging drivers](https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/) in the *Docker documentation* .

        > Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon (shown in the `LogConfiguration` data type). Additional log drivers may be available in future releases of the Amazon ECS container agent. 

        This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: sudo docker version `--format '{{.Server.APIVersion}}'`

        > The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        mount_points: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionMountPointArgsDict']]]]
        """
        The mount points for data volumes in your container.

        This parameter maps to `Volumes` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the [--volume](https://docs.aws.amazon.com/) option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .

        Windows containers can mount whole directories on the same drive as `$env:ProgramData` . Windows containers can't mount directories on a different drive, and mount point can't be across drives.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of a container. The name can be used as a unique identifier to target your `dependsOn` and `Overrides` objects.
        """
        privileged: NotRequired[pulumi.Input[builtins.bool]]
        """
        When this parameter is `true` , the container is given elevated privileges on the host container instance (similar to the `root` user). This parameter maps to `Privileged` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `--privileged` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .

        > This parameter is not supported for Windows containers or tasks run on Fargate.
        """
        readonly_root_filesystem: NotRequired[pulumi.Input[builtins.bool]]
        """
        When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `--read-only` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .

        > This parameter is not supported for Windows containers.
        """
        repository_credentials: NotRequired[pulumi.Input['JobDefinitionRepositoryCredentialsArgsDict']]
        """
        The private repository authentication credentials to use.
        """
        resource_requirements: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionResourceRequirementArgsDict']]]]
        """
        The type and amount of a resource to assign to a container. The only supported resource is a GPU.
        """
        secrets: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretArgsDict']]]]
        """
        The secrets to pass to the container. For more information, see [Specifying Sensitive Data](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html) in the Amazon Elastic Container Service Developer Guide.
        """
        ulimits: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionUlimitArgsDict']]]]
        """
        A list of `ulimits` to set in the container. If a `ulimit` value is specified in a task definition, it overrides the default values set by Docker. This parameter maps to `Ulimits` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `--ulimit` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .

        Amazon ECS tasks hosted on Fargate use the default resource limit values set by the operating system with the exception of the nofile resource limit parameter which Fargate overrides. The `nofile` resource limit sets a restriction on the number of open files that a container can use. The default `nofile` soft limit is `1024` and the default hard limit is `65535` .

        This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: sudo docker version `--format '{{.Server.APIVersion}}'`

        > This parameter is not supported for Windows containers.
        """
        user: NotRequired[pulumi.Input[builtins.str]]
        """
        The user to use inside the container. This parameter maps to User in the Create a container section of the Docker Remote API and the --user option to docker run.

        > When running tasks using the `host` network mode, don't run containers using the `root user (UID 0)` . We recommend using a non-root user for better security. 

        You can specify the `user` using the following formats. If specifying a UID or GID, you must specify it as a positive integer.

        - `user`
        - `user:group`
        - `uid`
        - `uid:gid`
        - `user:gi`
        - `uid:group`

        > This parameter is not supported for Windows containers.
        """
elif False:
    JobDefinitionTaskContainerPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionTaskContainerPropertiesArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[builtins.str],
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionTaskContainerDependencyArgs']]]] = None,
                 environment: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEnvironmentArgs']]]] = None,
                 essential: Optional[pulumi.Input[builtins.bool]] = None,
                 firelens_configuration: Optional[pulumi.Input['JobDefinitionTaskContainerPropertiesFirelensConfigurationPropertiesArgs']] = None,
                 linux_parameters: Optional[pulumi.Input['JobDefinitionLinuxParametersArgs']] = None,
                 log_configuration: Optional[pulumi.Input['JobDefinitionLogConfigurationArgs']] = None,
                 mount_points: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionMountPointArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 privileged: Optional[pulumi.Input[builtins.bool]] = None,
                 readonly_root_filesystem: Optional[pulumi.Input[builtins.bool]] = None,
                 repository_credentials: Optional[pulumi.Input['JobDefinitionRepositoryCredentialsArgs']] = None,
                 resource_requirements: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionResourceRequirementArgs']]]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretArgs']]]] = None,
                 ulimits: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionUlimitArgs']]]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] image: The image used to start a container. This string is passed directly to the Docker daemon. By default, images in the Docker Hub registry are available. Other repositories are specified with either `repository-url/image:tag` or `repository-url/image@digest` . Up to 255 letters (uppercase and lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter maps to `Image` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `IMAGE` parameter of the [*docker run*](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] command: The command that's passed to the container. This parameter maps to `Cmd` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `COMMAND` parameter to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . For more information, see [Dockerfile reference: CMD](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd) .
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionTaskContainerDependencyArgs']]] depends_on: A list of containers that this container depends on.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEnvironmentArgs']]] environment: The environment variables to pass to a container. This parameter maps to Env in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--env` parameter to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > We don't recommend using plaintext environment variables for sensitive information, such as credential data. > Environment variables cannot start with `AWS_BATCH` . This naming convention is reserved for variables that AWS Batch sets.
        :param pulumi.Input[builtins.bool] essential: If the essential parameter of a container is marked as `true` , and that container fails or stops for any reason, all other containers that are part of the task are stopped. If the `essential` parameter of a container is marked as false, its failure doesn't affect the rest of the containers in a task. If this parameter is omitted, a container is assumed to be essential.
               
               All jobs must have at least one essential container. If you have an application that's composed of multiple containers, group containers that are used for a common purpose into components, and separate the different components into multiple task definitions. For more information, see [Application Architecture](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param pulumi.Input['JobDefinitionTaskContainerPropertiesFirelensConfigurationPropertiesArgs'] firelens_configuration: The FireLens configuration for the container. This is used to specify and configure a log router for container logs. For more information, see [Custom log](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html) routing in the *Amazon Elastic Container Service Developer Guide* .
        :param pulumi.Input['JobDefinitionLinuxParametersArgs'] linux_parameters: Linux-specific modifications that are applied to the container, such as Linux kernel capabilities. For more information, see [KernelCapabilities](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html) .
        :param pulumi.Input['JobDefinitionLogConfigurationArgs'] log_configuration: The log configuration specification for the container.
               
               This parameter maps to `LogConfig` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `--log-driver` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .
               
               By default, containers use the same logging driver that the Docker daemon uses. However the container can use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information about the options for different supported log drivers, see [Configure logging drivers](https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/) in the *Docker documentation* .
               
               > Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon (shown in the `LogConfiguration` data type). Additional log drivers may be available in future releases of the Amazon ECS container agent. 
               
               This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: sudo docker version `--format '{{.Server.APIVersion}}'`
               
               > The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionMountPointArgs']]] mount_points: The mount points for data volumes in your container.
               
               This parameter maps to `Volumes` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the [--volume](https://docs.aws.amazon.com/) option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .
               
               Windows containers can mount whole directories on the same drive as `$env:ProgramData` . Windows containers can't mount directories on a different drive, and mount point can't be across drives.
        :param pulumi.Input[builtins.str] name: The name of a container. The name can be used as a unique identifier to target your `dependsOn` and `Overrides` objects.
        :param pulumi.Input[builtins.bool] privileged: When this parameter is `true` , the container is given elevated privileges on the host container instance (similar to the `root` user). This parameter maps to `Privileged` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `--privileged` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .
               
               > This parameter is not supported for Windows containers or tasks run on Fargate.
        :param pulumi.Input[builtins.bool] readonly_root_filesystem: When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `--read-only` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .
               
               > This parameter is not supported for Windows containers.
        :param pulumi.Input['JobDefinitionRepositoryCredentialsArgs'] repository_credentials: The private repository authentication credentials to use.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionResourceRequirementArgs']]] resource_requirements: The type and amount of a resource to assign to a container. The only supported resource is a GPU.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretArgs']]] secrets: The secrets to pass to the container. For more information, see [Specifying Sensitive Data](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html) in the Amazon Elastic Container Service Developer Guide.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionUlimitArgs']]] ulimits: A list of `ulimits` to set in the container. If a `ulimit` value is specified in a task definition, it overrides the default values set by Docker. This parameter maps to `Ulimits` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `--ulimit` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .
               
               Amazon ECS tasks hosted on Fargate use the default resource limit values set by the operating system with the exception of the nofile resource limit parameter which Fargate overrides. The `nofile` resource limit sets a restriction on the number of open files that a container can use. The default `nofile` soft limit is `1024` and the default hard limit is `65535` .
               
               This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: sudo docker version `--format '{{.Server.APIVersion}}'`
               
               > This parameter is not supported for Windows containers.
        :param pulumi.Input[builtins.str] user: The user to use inside the container. This parameter maps to User in the Create a container section of the Docker Remote API and the --user option to docker run.
               
               > When running tasks using the `host` network mode, don't run containers using the `root user (UID 0)` . We recommend using a non-root user for better security. 
               
               You can specify the `user` using the following formats. If specifying a UID or GID, you must specify it as a positive integer.
               
               - `user`
               - `user:group`
               - `uid`
               - `uid:gid`
               - `user:gi`
               - `uid:group`
               
               > This parameter is not supported for Windows containers.
        """
        pulumi.set(__self__, "image", image)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if essential is not None:
            pulumi.set(__self__, "essential", essential)
        if firelens_configuration is not None:
            pulumi.set(__self__, "firelens_configuration", firelens_configuration)
        if linux_parameters is not None:
            pulumi.set(__self__, "linux_parameters", linux_parameters)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if mount_points is not None:
            pulumi.set(__self__, "mount_points", mount_points)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if readonly_root_filesystem is not None:
            pulumi.set(__self__, "readonly_root_filesystem", readonly_root_filesystem)
        if repository_credentials is not None:
            pulumi.set(__self__, "repository_credentials", repository_credentials)
        if resource_requirements is not None:
            pulumi.set(__self__, "resource_requirements", resource_requirements)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if ulimits is not None:
            pulumi.set(__self__, "ulimits", ulimits)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[builtins.str]:
        """
        The image used to start a container. This string is passed directly to the Docker daemon. By default, images in the Docker Hub registry are available. Other repositories are specified with either `repository-url/image:tag` or `repository-url/image@digest` . Up to 255 letters (uppercase and lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter maps to `Image` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `IMAGE` parameter of the [*docker run*](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The command that's passed to the container. This parameter maps to `Cmd` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `COMMAND` parameter to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . For more information, see [Dockerfile reference: CMD](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd) .
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionTaskContainerDependencyArgs']]]]:
        """
        A list of containers that this container depends on.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionTaskContainerDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEnvironmentArgs']]]]:
        """
        The environment variables to pass to a container. This parameter maps to Env in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--env` parameter to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > We don't recommend using plaintext environment variables for sensitive information, such as credential data. > Environment variables cannot start with `AWS_BATCH` . This naming convention is reserved for variables that AWS Batch sets.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEnvironmentArgs']]]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def essential(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If the essential parameter of a container is marked as `true` , and that container fails or stops for any reason, all other containers that are part of the task are stopped. If the `essential` parameter of a container is marked as false, its failure doesn't affect the rest of the containers in a task. If this parameter is omitted, a container is assumed to be essential.

        All jobs must have at least one essential container. If you have an application that's composed of multiple containers, group containers that are used for a common purpose into components, and separate the different components into multiple task definitions. For more information, see [Application Architecture](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "essential")

    @essential.setter
    def essential(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "essential", value)

    @property
    @pulumi.getter(name="firelensConfiguration")
    def firelens_configuration(self) -> Optional[pulumi.Input['JobDefinitionTaskContainerPropertiesFirelensConfigurationPropertiesArgs']]:
        """
        The FireLens configuration for the container. This is used to specify and configure a log router for container logs. For more information, see [Custom log](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html) routing in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "firelens_configuration")

    @firelens_configuration.setter
    def firelens_configuration(self, value: Optional[pulumi.Input['JobDefinitionTaskContainerPropertiesFirelensConfigurationPropertiesArgs']]):
        pulumi.set(self, "firelens_configuration", value)

    @property
    @pulumi.getter(name="linuxParameters")
    def linux_parameters(self) -> Optional[pulumi.Input['JobDefinitionLinuxParametersArgs']]:
        """
        Linux-specific modifications that are applied to the container, such as Linux kernel capabilities. For more information, see [KernelCapabilities](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html) .
        """
        return pulumi.get(self, "linux_parameters")

    @linux_parameters.setter
    def linux_parameters(self, value: Optional[pulumi.Input['JobDefinitionLinuxParametersArgs']]):
        pulumi.set(self, "linux_parameters", value)

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional[pulumi.Input['JobDefinitionLogConfigurationArgs']]:
        """
        The log configuration specification for the container.

        This parameter maps to `LogConfig` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `--log-driver` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .

        By default, containers use the same logging driver that the Docker daemon uses. However the container can use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information about the options for different supported log drivers, see [Configure logging drivers](https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/) in the *Docker documentation* .

        > Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon (shown in the `LogConfiguration` data type). Additional log drivers may be available in future releases of the Amazon ECS container agent. 

        This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: sudo docker version `--format '{{.Server.APIVersion}}'`

        > The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "log_configuration")

    @log_configuration.setter
    def log_configuration(self, value: Optional[pulumi.Input['JobDefinitionLogConfigurationArgs']]):
        pulumi.set(self, "log_configuration", value)

    @property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionMountPointArgs']]]]:
        """
        The mount points for data volumes in your container.

        This parameter maps to `Volumes` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the [--volume](https://docs.aws.amazon.com/) option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .

        Windows containers can mount whole directories on the same drive as `$env:ProgramData` . Windows containers can't mount directories on a different drive, and mount point can't be across drives.
        """
        return pulumi.get(self, "mount_points")

    @mount_points.setter
    def mount_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionMountPointArgs']]]]):
        pulumi.set(self, "mount_points", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a container. The name can be used as a unique identifier to target your `dependsOn` and `Overrides` objects.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def privileged(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When this parameter is `true` , the container is given elevated privileges on the host container instance (similar to the `root` user). This parameter maps to `Privileged` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `--privileged` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .

        > This parameter is not supported for Windows containers or tasks run on Fargate.
        """
        return pulumi.get(self, "privileged")

    @privileged.setter
    def privileged(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "privileged", value)

    @property
    @pulumi.getter(name="readonlyRootFilesystem")
    def readonly_root_filesystem(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `--read-only` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .

        > This parameter is not supported for Windows containers.
        """
        return pulumi.get(self, "readonly_root_filesystem")

    @readonly_root_filesystem.setter
    def readonly_root_filesystem(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "readonly_root_filesystem", value)

    @property
    @pulumi.getter(name="repositoryCredentials")
    def repository_credentials(self) -> Optional[pulumi.Input['JobDefinitionRepositoryCredentialsArgs']]:
        """
        The private repository authentication credentials to use.
        """
        return pulumi.get(self, "repository_credentials")

    @repository_credentials.setter
    def repository_credentials(self, value: Optional[pulumi.Input['JobDefinitionRepositoryCredentialsArgs']]):
        pulumi.set(self, "repository_credentials", value)

    @property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionResourceRequirementArgs']]]]:
        """
        The type and amount of a resource to assign to a container. The only supported resource is a GPU.
        """
        return pulumi.get(self, "resource_requirements")

    @resource_requirements.setter
    def resource_requirements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionResourceRequirementArgs']]]]):
        pulumi.set(self, "resource_requirements", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretArgs']]]]:
        """
        The secrets to pass to the container. For more information, see [Specifying Sensitive Data](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html) in the Amazon Elastic Container Service Developer Guide.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter
    def ulimits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionUlimitArgs']]]]:
        """
        A list of `ulimits` to set in the container. If a `ulimit` value is specified in a task definition, it overrides the default values set by Docker. This parameter maps to `Ulimits` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the `--ulimit` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration) .

        Amazon ECS tasks hosted on Fargate use the default resource limit values set by the operating system with the exception of the nofile resource limit parameter which Fargate overrides. The `nofile` resource limit sets a restriction on the number of open files that a container can use. The default `nofile` soft limit is `1024` and the default hard limit is `65535` .

        This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: sudo docker version `--format '{{.Server.APIVersion}}'`

        > This parameter is not supported for Windows containers.
        """
        return pulumi.get(self, "ulimits")

    @ulimits.setter
    def ulimits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionUlimitArgs']]]]):
        pulumi.set(self, "ulimits", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user to use inside the container. This parameter maps to User in the Create a container section of the Docker Remote API and the --user option to docker run.

        > When running tasks using the `host` network mode, don't run containers using the `root user (UID 0)` . We recommend using a non-root user for better security. 

        You can specify the `user` using the following formats. If specifying a UID or GID, you must specify it as a positive integer.

        - `user`
        - `user:group`
        - `uid`
        - `uid:gid`
        - `user:gi`
        - `uid:group`

        > This parameter is not supported for Windows containers.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user", value)


if not MYPY:
    class JobDefinitionTmpfsArgsDict(TypedDict):
        container_path: pulumi.Input[builtins.str]
        """
        The absolute file path in the container where the `tmpfs` volume is mounted.
        """
        size: pulumi.Input[builtins.int]
        """
        The size (in MiB) of the `tmpfs` volume.
        """
        mount_options: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The list of `tmpfs` volume mount options.

        Valid values: " `defaults` " | " `ro` " | " `rw` " | " `suid` " | " `nosuid` " | " `dev` " | " `nodev` " | " `exec` " | " `noexec` " | " `sync` " | " `async` " | " `dirsync` " | " `remount` " | " `mand` " | " `nomand` " | " `atime` " | " `noatime` " | " `diratime` " | " `nodiratime` " | " `bind` " | " `rbind" | "unbindable" | "runbindable" | "private" | "rprivate" | "shared" | "rshared" | "slave" | "rslave" | "relatime` " | " `norelatime` " | " `strictatime` " | " `nostrictatime` " | " `mode` " | " `uid` " | " `gid` " | " `nr_inodes` " | " `nr_blocks` " | " `mpol` "
        """
elif False:
    JobDefinitionTmpfsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionTmpfsArgs:
    def __init__(__self__, *,
                 container_path: pulumi.Input[builtins.str],
                 size: pulumi.Input[builtins.int],
                 mount_options: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] container_path: The absolute file path in the container where the `tmpfs` volume is mounted.
        :param pulumi.Input[builtins.int] size: The size (in MiB) of the `tmpfs` volume.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] mount_options: The list of `tmpfs` volume mount options.
               
               Valid values: " `defaults` " | " `ro` " | " `rw` " | " `suid` " | " `nosuid` " | " `dev` " | " `nodev` " | " `exec` " | " `noexec` " | " `sync` " | " `async` " | " `dirsync` " | " `remount` " | " `mand` " | " `nomand` " | " `atime` " | " `noatime` " | " `diratime` " | " `nodiratime` " | " `bind` " | " `rbind" | "unbindable" | "runbindable" | "private" | "rprivate" | "shared" | "rshared" | "slave" | "rslave" | "relatime` " | " `norelatime` " | " `strictatime` " | " `nostrictatime` " | " `mode` " | " `uid` " | " `gid` " | " `nr_inodes` " | " `nr_blocks` " | " `mpol` "
        """
        pulumi.set(__self__, "container_path", container_path)
        pulumi.set(__self__, "size", size)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> pulumi.Input[builtins.str]:
        """
        The absolute file path in the container where the `tmpfs` volume is mounted.
        """
        return pulumi.get(self, "container_path")

    @container_path.setter
    def container_path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "container_path", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[builtins.int]:
        """
        The size (in MiB) of the `tmpfs` volume.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of `tmpfs` volume mount options.

        Valid values: " `defaults` " | " `ro` " | " `rw` " | " `suid` " | " `nosuid` " | " `dev` " | " `nodev` " | " `exec` " | " `noexec` " | " `sync` " | " `async` " | " `dirsync` " | " `remount` " | " `mand` " | " `nomand` " | " `atime` " | " `noatime` " | " `diratime` " | " `nodiratime` " | " `bind` " | " `rbind" | "unbindable" | "runbindable" | "private" | "rprivate" | "shared" | "rshared" | "slave" | "rslave" | "relatime` " | " `norelatime` " | " `strictatime` " | " `nostrictatime` " | " `mode` " | " `uid` " | " `gid` " | " `nr_inodes` " | " `nr_blocks` " | " `mpol` "
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "mount_options", value)


if not MYPY:
    class JobDefinitionUlimitArgsDict(TypedDict):
        hard_limit: pulumi.Input[builtins.int]
        """
        The hard limit for the `ulimit` type.
        """
        name: pulumi.Input[builtins.str]
        """
        The `type` of the `ulimit` . Valid values are: `core` | `cpu` | `data` | `fsize` | `locks` | `memlock` | `msgqueue` | `nice` | `nofile` | `nproc` | `rss` | `rtprio` | `rttime` | `sigpending` | `stack` .
        """
        soft_limit: pulumi.Input[builtins.int]
        """
        The soft limit for the `ulimit` type.
        """
elif False:
    JobDefinitionUlimitArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionUlimitArgs:
    def __init__(__self__, *,
                 hard_limit: pulumi.Input[builtins.int],
                 name: pulumi.Input[builtins.str],
                 soft_limit: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] hard_limit: The hard limit for the `ulimit` type.
        :param pulumi.Input[builtins.str] name: The `type` of the `ulimit` . Valid values are: `core` | `cpu` | `data` | `fsize` | `locks` | `memlock` | `msgqueue` | `nice` | `nofile` | `nproc` | `rss` | `rtprio` | `rttime` | `sigpending` | `stack` .
        :param pulumi.Input[builtins.int] soft_limit: The soft limit for the `ulimit` type.
        """
        pulumi.set(__self__, "hard_limit", hard_limit)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "soft_limit", soft_limit)

    @property
    @pulumi.getter(name="hardLimit")
    def hard_limit(self) -> pulumi.Input[builtins.int]:
        """
        The hard limit for the `ulimit` type.
        """
        return pulumi.get(self, "hard_limit")

    @hard_limit.setter
    def hard_limit(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "hard_limit", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The `type` of the `ulimit` . Valid values are: `core` | `cpu` | `data` | `fsize` | `locks` | `memlock` | `msgqueue` | `nice` | `nofile` | `nproc` | `rss` | `rtprio` | `rttime` | `sigpending` | `stack` .
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="softLimit")
    def soft_limit(self) -> pulumi.Input[builtins.int]:
        """
        The soft limit for the `ulimit` type.
        """
        return pulumi.get(self, "soft_limit")

    @soft_limit.setter
    def soft_limit(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "soft_limit", value)


if not MYPY:
    class JobDefinitionVolumeArgsDict(TypedDict):
        efs_volume_configuration: NotRequired[pulumi.Input['JobDefinitionEfsVolumeConfigurationArgsDict']]
        """
        This parameter is specified when you're using an Amazon Elastic File System file system for job storage. Jobs that are running on Fargate resources must specify a `platformVersion` of at least `1.4.0` .
        """
        host: NotRequired[pulumi.Input['JobDefinitionHostArgsDict']]
        """
        The contents of the `host` parameter determine whether your data volume persists on the host container instance and where it's stored. If the host parameter is empty, then the Docker daemon assigns a host path for your data volume. However, the data isn't guaranteed to persist after the containers that are associated with it stop running.

        > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the volume. It can be up to 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_). This name is referenced in the `sourceVolume` parameter of container definition `mountPoints` .
        """
elif False:
    JobDefinitionVolumeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionVolumeArgs:
    def __init__(__self__, *,
                 efs_volume_configuration: Optional[pulumi.Input['JobDefinitionEfsVolumeConfigurationArgs']] = None,
                 host: Optional[pulumi.Input['JobDefinitionHostArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['JobDefinitionEfsVolumeConfigurationArgs'] efs_volume_configuration: This parameter is specified when you're using an Amazon Elastic File System file system for job storage. Jobs that are running on Fargate resources must specify a `platformVersion` of at least `1.4.0` .
        :param pulumi.Input['JobDefinitionHostArgs'] host: The contents of the `host` parameter determine whether your data volume persists on the host container instance and where it's stored. If the host parameter is empty, then the Docker daemon assigns a host path for your data volume. However, the data isn't guaranteed to persist after the containers that are associated with it stop running.
               
               > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
        :param pulumi.Input[builtins.str] name: The name of the volume. It can be up to 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_). This name is referenced in the `sourceVolume` parameter of container definition `mountPoints` .
        """
        if efs_volume_configuration is not None:
            pulumi.set(__self__, "efs_volume_configuration", efs_volume_configuration)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="efsVolumeConfiguration")
    def efs_volume_configuration(self) -> Optional[pulumi.Input['JobDefinitionEfsVolumeConfigurationArgs']]:
        """
        This parameter is specified when you're using an Amazon Elastic File System file system for job storage. Jobs that are running on Fargate resources must specify a `platformVersion` of at least `1.4.0` .
        """
        return pulumi.get(self, "efs_volume_configuration")

    @efs_volume_configuration.setter
    def efs_volume_configuration(self, value: Optional[pulumi.Input['JobDefinitionEfsVolumeConfigurationArgs']]):
        pulumi.set(self, "efs_volume_configuration", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input['JobDefinitionHostArgs']]:
        """
        The contents of the `host` parameter determine whether your data volume persists on the host container instance and where it's stored. If the host parameter is empty, then the Docker daemon assigns a host path for your data volume. However, the data isn't guaranteed to persist after the containers that are associated with it stop running.

        > This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input['JobDefinitionHostArgs']]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the volume. It can be up to 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_). This name is referenced in the `sourceVolume` parameter of container definition `mountPoints` .
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class JobQueueComputeEnvironmentOrderArgsDict(TypedDict):
        compute_environment: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of the compute environment.
        """
        order: pulumi.Input[builtins.int]
        """
        The order of the compute environment. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower `order` integer value is tried for job placement first.
        """
elif False:
    JobQueueComputeEnvironmentOrderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobQueueComputeEnvironmentOrderArgs:
    def __init__(__self__, *,
                 compute_environment: pulumi.Input[builtins.str],
                 order: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.str] compute_environment: The Amazon Resource Name (ARN) of the compute environment.
        :param pulumi.Input[builtins.int] order: The order of the compute environment. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower `order` integer value is tried for job placement first.
        """
        pulumi.set(__self__, "compute_environment", compute_environment)
        pulumi.set(__self__, "order", order)

    @property
    @pulumi.getter(name="computeEnvironment")
    def compute_environment(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the compute environment.
        """
        return pulumi.get(self, "compute_environment")

    @compute_environment.setter
    def compute_environment(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compute_environment", value)

    @property
    @pulumi.getter
    def order(self) -> pulumi.Input[builtins.int]:
        """
        The order of the compute environment. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower `order` integer value is tried for job placement first.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "order", value)


if not MYPY:
    class JobQueueJobStateTimeLimitActionArgsDict(TypedDict):
        action: pulumi.Input['JobQueueJobStateTimeLimitActionAction']
        """
        The action to take when a job is at the head of the job queue in the specified state for the specified period of time. The only supported value is `CANCEL` , which will cancel the job.
        """
        max_time_seconds: pulumi.Input[builtins.int]
        """
        The approximate amount of time, in seconds, that must pass with the job in the specified state before the action is taken. The minimum value is 600 (10 minutes) and the maximum value is 86,400 (24 hours).
        """
        reason: pulumi.Input[builtins.str]
        """
        The reason to log for the action being taken.
        """
        state: pulumi.Input['JobQueueJobStateTimeLimitActionState']
        """
        The state of the job needed to trigger the action. The only supported value is `RUNNABLE` .
        """
elif False:
    JobQueueJobStateTimeLimitActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobQueueJobStateTimeLimitActionArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['JobQueueJobStateTimeLimitActionAction'],
                 max_time_seconds: pulumi.Input[builtins.int],
                 reason: pulumi.Input[builtins.str],
                 state: pulumi.Input['JobQueueJobStateTimeLimitActionState']):
        """
        :param pulumi.Input['JobQueueJobStateTimeLimitActionAction'] action: The action to take when a job is at the head of the job queue in the specified state for the specified period of time. The only supported value is `CANCEL` , which will cancel the job.
        :param pulumi.Input[builtins.int] max_time_seconds: The approximate amount of time, in seconds, that must pass with the job in the specified state before the action is taken. The minimum value is 600 (10 minutes) and the maximum value is 86,400 (24 hours).
        :param pulumi.Input[builtins.str] reason: The reason to log for the action being taken.
        :param pulumi.Input['JobQueueJobStateTimeLimitActionState'] state: The state of the job needed to trigger the action. The only supported value is `RUNNABLE` .
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "max_time_seconds", max_time_seconds)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input['JobQueueJobStateTimeLimitActionAction']:
        """
        The action to take when a job is at the head of the job queue in the specified state for the specified period of time. The only supported value is `CANCEL` , which will cancel the job.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['JobQueueJobStateTimeLimitActionAction']):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="maxTimeSeconds")
    def max_time_seconds(self) -> pulumi.Input[builtins.int]:
        """
        The approximate amount of time, in seconds, that must pass with the job in the specified state before the action is taken. The minimum value is 600 (10 minutes) and the maximum value is 86,400 (24 hours).
        """
        return pulumi.get(self, "max_time_seconds")

    @max_time_seconds.setter
    def max_time_seconds(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_time_seconds", value)

    @property
    @pulumi.getter
    def reason(self) -> pulumi.Input[builtins.str]:
        """
        The reason to log for the action being taken.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input['JobQueueJobStateTimeLimitActionState']:
        """
        The state of the job needed to trigger the action. The only supported value is `RUNNABLE` .
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input['JobQueueJobStateTimeLimitActionState']):
        pulumi.set(self, "state", value)


if not MYPY:
    class SchedulingPolicyFairsharePolicyArgsDict(TypedDict):
        """
        Fair Share Policy for the Job Queue.
        """
        compute_reservation: NotRequired[pulumi.Input[builtins.float]]
        """
        A value used to reserve some of the available maximum vCPU for share identifiers that aren't already used.

        The reserved ratio is `( *computeReservation* /100)^ *ActiveFairShares*` where `*ActiveFairShares*` is the number of active share identifiers.

        For example, a `computeReservation` value of 50 indicates that AWS Batch reserves 50% of the maximum available vCPU if there's only one share identifier. It reserves 25% if there are two share identifiers. It reserves 12.5% if there are three share identifiers. A `computeReservation` value of 25 indicates that AWS Batch should reserve 25% of the maximum available vCPU if there's only one share identifier, 6.25% if there are two fair share identifiers, and 1.56% if there are three share identifiers.

        The minimum value is 0 and the maximum value is 99.
        """
        share_decay_seconds: NotRequired[pulumi.Input[builtins.float]]
        """
        The amount of time (in seconds) to use to calculate a fair-share percentage for each share identifier in use. A value of zero (0) indicates the default minimum time window (600 seconds). The maximum supported value is 604800 (1 week).

        The decay allows for more recently run jobs to have more weight than jobs that ran earlier. Consider adjusting this number if you have jobs that (on average) run longer than ten minutes, or a large difference in job count or job run times between share identifiers, and the allocation of resources doesn't meet your needs.
        """
        share_distribution: NotRequired[pulumi.Input[Sequence[pulumi.Input['SchedulingPolicyShareAttributesArgsDict']]]]
        """
        List of Share Attributes
        """
elif False:
    SchedulingPolicyFairsharePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SchedulingPolicyFairsharePolicyArgs:
    def __init__(__self__, *,
                 compute_reservation: Optional[pulumi.Input[builtins.float]] = None,
                 share_decay_seconds: Optional[pulumi.Input[builtins.float]] = None,
                 share_distribution: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulingPolicyShareAttributesArgs']]]] = None):
        """
        Fair Share Policy for the Job Queue.
        :param pulumi.Input[builtins.float] compute_reservation: A value used to reserve some of the available maximum vCPU for share identifiers that aren't already used.
               
               The reserved ratio is `( *computeReservation* /100)^ *ActiveFairShares*` where `*ActiveFairShares*` is the number of active share identifiers.
               
               For example, a `computeReservation` value of 50 indicates that AWS Batch reserves 50% of the maximum available vCPU if there's only one share identifier. It reserves 25% if there are two share identifiers. It reserves 12.5% if there are three share identifiers. A `computeReservation` value of 25 indicates that AWS Batch should reserve 25% of the maximum available vCPU if there's only one share identifier, 6.25% if there are two fair share identifiers, and 1.56% if there are three share identifiers.
               
               The minimum value is 0 and the maximum value is 99.
        :param pulumi.Input[builtins.float] share_decay_seconds: The amount of time (in seconds) to use to calculate a fair-share percentage for each share identifier in use. A value of zero (0) indicates the default minimum time window (600 seconds). The maximum supported value is 604800 (1 week).
               
               The decay allows for more recently run jobs to have more weight than jobs that ran earlier. Consider adjusting this number if you have jobs that (on average) run longer than ten minutes, or a large difference in job count or job run times between share identifiers, and the allocation of resources doesn't meet your needs.
        :param pulumi.Input[Sequence[pulumi.Input['SchedulingPolicyShareAttributesArgs']]] share_distribution: List of Share Attributes
        """
        if compute_reservation is not None:
            pulumi.set(__self__, "compute_reservation", compute_reservation)
        if share_decay_seconds is not None:
            pulumi.set(__self__, "share_decay_seconds", share_decay_seconds)
        if share_distribution is not None:
            pulumi.set(__self__, "share_distribution", share_distribution)

    @property
    @pulumi.getter(name="computeReservation")
    def compute_reservation(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        A value used to reserve some of the available maximum vCPU for share identifiers that aren't already used.

        The reserved ratio is `( *computeReservation* /100)^ *ActiveFairShares*` where `*ActiveFairShares*` is the number of active share identifiers.

        For example, a `computeReservation` value of 50 indicates that AWS Batch reserves 50% of the maximum available vCPU if there's only one share identifier. It reserves 25% if there are two share identifiers. It reserves 12.5% if there are three share identifiers. A `computeReservation` value of 25 indicates that AWS Batch should reserve 25% of the maximum available vCPU if there's only one share identifier, 6.25% if there are two fair share identifiers, and 1.56% if there are three share identifiers.

        The minimum value is 0 and the maximum value is 99.
        """
        return pulumi.get(self, "compute_reservation")

    @compute_reservation.setter
    def compute_reservation(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "compute_reservation", value)

    @property
    @pulumi.getter(name="shareDecaySeconds")
    def share_decay_seconds(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The amount of time (in seconds) to use to calculate a fair-share percentage for each share identifier in use. A value of zero (0) indicates the default minimum time window (600 seconds). The maximum supported value is 604800 (1 week).

        The decay allows for more recently run jobs to have more weight than jobs that ran earlier. Consider adjusting this number if you have jobs that (on average) run longer than ten minutes, or a large difference in job count or job run times between share identifiers, and the allocation of resources doesn't meet your needs.
        """
        return pulumi.get(self, "share_decay_seconds")

    @share_decay_seconds.setter
    def share_decay_seconds(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "share_decay_seconds", value)

    @property
    @pulumi.getter(name="shareDistribution")
    def share_distribution(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SchedulingPolicyShareAttributesArgs']]]]:
        """
        List of Share Attributes
        """
        return pulumi.get(self, "share_distribution")

    @share_distribution.setter
    def share_distribution(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulingPolicyShareAttributesArgs']]]]):
        pulumi.set(self, "share_distribution", value)


if not MYPY:
    class SchedulingPolicyShareAttributesArgsDict(TypedDict):
        share_identifier: NotRequired[pulumi.Input[builtins.str]]
        """
        A share identifier or share identifier prefix. If the string ends with an asterisk (*), this entry specifies the weight factor to use for share identifiers that start with that prefix. The list of share identifiers in a fair-share policy can't overlap. For example, you can't have one that specifies a `shareIdentifier` of `UserA*` and another that specifies a `shareIdentifier` of `UserA-1` .

        There can be no more than 500 share identifiers active in a job queue.

        The string is limited to 255 alphanumeric characters, and can be followed by an asterisk (*).
        """
        weight_factor: NotRequired[pulumi.Input[builtins.float]]
        """
        The weight factor for the share identifier. The default value is 1.0. A lower value has a higher priority for compute resources. For example, jobs that use a share identifier with a weight factor of 0.125 (1/8) get 8 times the compute resources of jobs that use a share identifier with a weight factor of 1.

        The smallest supported value is 0.0001, and the largest supported value is 999.9999.
        """
elif False:
    SchedulingPolicyShareAttributesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SchedulingPolicyShareAttributesArgs:
    def __init__(__self__, *,
                 share_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 weight_factor: Optional[pulumi.Input[builtins.float]] = None):
        """
        :param pulumi.Input[builtins.str] share_identifier: A share identifier or share identifier prefix. If the string ends with an asterisk (*), this entry specifies the weight factor to use for share identifiers that start with that prefix. The list of share identifiers in a fair-share policy can't overlap. For example, you can't have one that specifies a `shareIdentifier` of `UserA*` and another that specifies a `shareIdentifier` of `UserA-1` .
               
               There can be no more than 500 share identifiers active in a job queue.
               
               The string is limited to 255 alphanumeric characters, and can be followed by an asterisk (*).
        :param pulumi.Input[builtins.float] weight_factor: The weight factor for the share identifier. The default value is 1.0. A lower value has a higher priority for compute resources. For example, jobs that use a share identifier with a weight factor of 0.125 (1/8) get 8 times the compute resources of jobs that use a share identifier with a weight factor of 1.
               
               The smallest supported value is 0.0001, and the largest supported value is 999.9999.
        """
        if share_identifier is not None:
            pulumi.set(__self__, "share_identifier", share_identifier)
        if weight_factor is not None:
            pulumi.set(__self__, "weight_factor", weight_factor)

    @property
    @pulumi.getter(name="shareIdentifier")
    def share_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A share identifier or share identifier prefix. If the string ends with an asterisk (*), this entry specifies the weight factor to use for share identifiers that start with that prefix. The list of share identifiers in a fair-share policy can't overlap. For example, you can't have one that specifies a `shareIdentifier` of `UserA*` and another that specifies a `shareIdentifier` of `UserA-1` .

        There can be no more than 500 share identifiers active in a job queue.

        The string is limited to 255 alphanumeric characters, and can be followed by an asterisk (*).
        """
        return pulumi.get(self, "share_identifier")

    @share_identifier.setter
    def share_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "share_identifier", value)

    @property
    @pulumi.getter(name="weightFactor")
    def weight_factor(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The weight factor for the share identifier. The default value is 1.0. A lower value has a higher priority for compute resources. For example, jobs that use a share identifier with a weight factor of 0.125 (1/8) get 8 times the compute resources of jobs that use a share identifier with a weight factor of 1.

        The smallest supported value is 0.0001, and the largest supported value is 999.9999.
        """
        return pulumi.get(self, "weight_factor")

    @weight_factor.setter
    def weight_factor(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "weight_factor", value)


